/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kafka.log.UnifiedLog;
import kafka.server.BrokerServer;
import kafka.server.KafkaConfig$;
import kafka.server.metadata.BrokerMetadataPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.MetadataPublisher;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.fault.FaultHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\b\u0010\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004<\u0001\u0001\u0006Ia\t\u0005\u0006y\u0001!\t!\u0010\u0005\u0006\u001d\u0002!\t!\u0010\u0005\u0006'\u0002!\t!\u0010\u0005\u00061\u0002!\t!\u0010\u0005\u00065\u0002!Ia\u0017\u0005\u0006e\u0002!Ia\u001d\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAa!!\u0017\u0001\t\u0003i\u0004BBA/\u0001\u0011\u0005QHA\u000eCe>\\WM]'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5feR+7\u000f\u001e\u0006\u0003!E\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003%M\taa]3sm\u0016\u0014(\"\u0001\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005y\u0011!D3ySR,\u0005pY3qi&|g.F\u0001$!\r!SfL\u0007\u0002K)\u0011aeJ\u0001\u0007CR|W.[2\u000b\u0005!J\u0013AC2p]\u000e,(O]3oi*\u0011!fK\u0001\u0005kRLGNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059*#aD!u_6L7MU3gKJ,gnY3\u0011\u0005ABdBA\u00197\u001d\t\u0011T'D\u00014\u0015\t!T#\u0001\u0004=e>|GOP\u0005\u00025%\u0011q'G\u0001\ba\u0006\u001c7.Y4f\u0013\tI$HA\u0005UQJ|w/\u00192mK*\u0011q'G\u0001\u000fKbLG/\u0012=dKB$\u0018n\u001c8!\u0003\u0015\u0019X\r^+q)\u0005q\u0004C\u0001\r@\u0013\t\u0001\u0015D\u0001\u0003V]&$\bF\u0001\u0003C!\t\u0019E*D\u0001E\u0015\t)e)A\u0002ba&T!a\u0012%\u0002\u000f),\b/\u001b;fe*\u0011\u0011JS\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0017\u0006\u0019qN]4\n\u00055#%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u000b\u0002\u0006!B\u00111)U\u0005\u0003%\u0012\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002#Q,7\u000f^$fiR{\u0007/[2EK2$\u0018\r\u000b\u0002\u0007+B\u00111IV\u0005\u0003/\u0012\u0013A\u0001V3ti\u0006)B/Z:u\r&tGm\u0015;sCf\u0014V\r\u001d7jG\u0006\u001c\bFA\u0004V\u0003\u001diwnY6M_\u001e$2\u0001\u00182n!\ti\u0006-D\u0001_\u0015\ty6#A\u0002m_\u001eL!!\u00190\u0003\u0015Us\u0017NZ5fI2{w\rC\u0003d\u0011\u0001\u0007A-A\u0004u_BL7-\u00133\u0011\u0005\u0015\\W\"\u00014\u000b\u0005\u001dD\u0017AB2p[6|gN\u0003\u0002\u0015S*\u0011!NS\u0001\u0007CB\f7\r[3\n\u000514'\u0001B+vS\u0012DQA\u001c\u0005A\u0002=\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002fa&\u0011\u0011O\u001a\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)!x\u000e]5d\u00136\fw-\u001a\u000b\u0006ij\\\u00181\u0002\t\u0003kbl\u0011A\u001e\u0006\u0003o\"\fQ![7bO\u0016L!!\u001f<\u0003\u0015Q{\u0007/[2J[\u0006<W\rC\u0003d\u0013\u0001\u0007A\rC\u0003}\u0013\u0001\u0007Q0A\u0003u_BL7\rE\u0002\u007f\u0003\u000bq1a`A\u0001!\t\u0011\u0014$C\u0002\u0002\u0004e\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0004\u0003\u0013\u0011aa\u0015;sS:<'bAA\u00023!9\u0011QB\u0005A\u0002\u0005=\u0011A\u00039beRLG/[8ogB9a0!\u0005\u0002\u0016\u0005m\u0011\u0002BA\n\u0003\u0013\u00111!T1q!\rA\u0012qC\u0005\u0004\u00033I\"aA%oiB)\u0001'!\b\u0002\u0016%\u0019\u0011q\u0004\u001e\u0003\u0007M+\u0017/A\u0006u_BL7m]%nC\u001e,G\u0003BA\u0013\u0003W\u00012!^A\u0014\u0013\r\tIC\u001e\u0002\f)>\u0004\u0018nY:J[\u0006<W\rC\u0004\u0002.)\u0001\r!a\f\u0002\rQ|\u0007/[2t!\u0011\u0001\u0014Q\u0004;\u0002;9,w/T8dW\u0012Kh.Y7jG\u000e{gNZ5h!V\u0014G.[:iKJ$b!!\u000e\u0002<\u0005\u001d\u0003c\u0001\u0011\u00028%\u0019\u0011\u0011H\b\u0003-\u0011Kh.Y7jG\u000e{gNZ5h!V\u0014G.[:iKJDq!!\u0010\f\u0001\u0004\ty$\u0001\u0004ce>\\WM\u001d\t\u0005\u0003\u0003\n\u0019%D\u0001\u0012\u0013\r\t)%\u0005\u0002\r\u0005J|7.\u001a:TKJ4XM\u001d\u0005\b\u0003\u0013Z\u0001\u0019AA&\u00031)'O]8s\u0011\u0006tG\r\\3s!\u0011\ti%!\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\nQAZ1vYRT!A\u00055\n\t\u0005]\u0013q\n\u0002\r\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001*i\u0016\u001cHOU3m_\u0006$W\u000b\u001d3bi\u0016$g)\u001b7fg^KG\u000f[8vi\u000e{gNZ5h\u0007\"\fgnZ3)\u00051)\u0016\u0001\t;fgR,\u0005pY3qi&|g.\u00138Va\u0012\fG/Z\"p_J$\u0017N\\1u_JD#!D+")
public class BrokerMetadataPublisherTest {
    private final AtomicReference<Throwable> exitException = new AtomicReference<Object>(null);

    public AtomicReference<Throwable> exitException() {
        return this.exitException;
    }

    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((code, x$1) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Exit ").append(code).toString())));
        Exit.setHaltProcedure((code, x$2) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Halt ").append(code).toString())));
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        Throwable exception = this.exitException().get();
        if (exception != null) {
            throw exception;
        }
    }

    @Test
    public void testGetTopicDelta() {
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("not-a-topic", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for unknown topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("foo", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for deleted topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("bar", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Expected to see delta for changed topic");
    }

    @Test
    public void testFindStrayReplicas() {
        int brokerId = 0;
        String deletedTopic = "a";
        Uuid deletedTopicId = Uuid.randomUuid();
        TopicPartition deletedTopicPartition1 = new TopicPartition(deletedTopic, 0);
        UnifiedLog deletedTopicLog1 = this.mockLog(deletedTopicId, deletedTopicPartition1);
        TopicPartition deletedTopicPartition2 = new TopicPartition(deletedTopic, 1);
        UnifiedLog deletedTopicLog2 = this.mockLog(deletedTopicId, deletedTopicPartition2);
        String recreatedTopic = "b";
        TopicPartition recreatedTopicPartition = new TopicPartition(recreatedTopic, 0);
        UnifiedLog recreatedTopicLog = this.mockLog(Uuid.randomUuid(), recreatedTopicPartition);
        TopicImage recreatedTopicImage = this.topicImage(Uuid.randomUuid(), recreatedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)recreatedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))));
        String reassignedTopic = "c";
        Uuid reassignedTopicId = Uuid.randomUuid();
        TopicPartition reassignedTopicPartition = new TopicPartition(reassignedTopic, 0);
        UnifiedLog reassignedTopicLog = this.mockLog(reassignedTopicId, reassignedTopicPartition);
        TopicPartition retainedTopicPartition = new TopicPartition(reassignedTopic, 1);
        UnifiedLog retainedTopicLog = this.mockLog(reassignedTopicId, retainedTopicPartition);
        TopicImage reassignedTopicImage = this.topicImage(reassignedTopicId, reassignedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)reassignedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)retainedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})))}))));
        .colon.colon logs = new .colon.colon((Object)deletedTopicLog1, (List)new .colon.colon((Object)deletedTopicLog2, (List)new .colon.colon((Object)recreatedTopicLog, (List)new .colon.colon((Object)reassignedTopicLog, (List)new .colon.colon((Object)retainedTopicLog, (List)Nil$.MODULE$)))));
        TopicsImage image = this.topicsImage((Seq<TopicImage>)new .colon.colon((Object)recreatedTopicImage, (List)new .colon.colon((Object)reassignedTopicImage, (List)Nil$.MODULE$)));
        Set expectedStrayPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{deletedTopicPartition1, deletedTopicPartition2, recreatedTopicPartition, reassignedTopicPartition}));
        Set strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, image, (Iterable)logs).toSet();
        Assertions.assertEquals((Object)expectedStrayPartitions, (Object)strayPartitions);
    }

    /*
     * WARNING - void declaration
     */
    private UnifiedLog mockLog(Uuid topicId, TopicPartition topicPartition) {
        void var3_3;
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
        return var3_3;
    }

    private TopicImage topicImage(Uuid topicId, String topic, scala.collection.immutable.Map<Object, Seq<Object>> partitions) {
        scala.collection.immutable.Map partitionRegistrations = (scala.collection.immutable.Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partitionId = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new PartitionRegistration((int[])replicas.toArray(ClassTag$.MODULE$.Int()), (int[])replicas.toArray(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), BoxesRunTime.unboxToInt((Object)replicas.head()), LeaderRecoveryState.RECOVERED, 0, 0));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        return new TopicImage(topic, topicId, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRegistrations).asJava());
    }

    private TopicsImage topicsImage(Seq<TopicImage> topics) {
        scala.collection.immutable.Map idsMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.id()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map namesMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.name()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new TopicsImage((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)idsMap).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)namesMap).asJava());
    }

    private DynamicConfigPublisher newMockDynamicConfigPublisher(BrokerServer broker, FaultHandler errorHandler) {
        return (DynamicConfigPublisher)Mockito.spy((Object)new DynamicConfigPublisher(broker.config(), errorHandler, broker.dynamicConfigHandlers().toMap(Predef$.MODULE$.$conforms()), "broker"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReloadUpdatedFilesWithoutConfigChange() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            DynamicConfigPublisher publisher = this.newMockDynamicConfigPublisher(broker, (FaultHandler)cluster.nonFatalFaultHandler());
            AtomicInteger numTimesReloadCalled = new AtomicInteger(0);
            publisher.reloadUpdatedFilesWithoutConfigChange((Properties)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, numTimesReloadCalled){
                private final AtomicInteger numTimesReloadCalled$1;

                public void answer(InvocationOnMock invocation) {
                    this.numTimesReloadCalled$1.addAndGet(1);
                }
                {
                    this.numTimesReloadCalled$1 = numTimesReloadCalled$1;
                }
            });
            broker.metadataPublisher().dynamicConfigPublisher_$eq(publisher);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((int)0, (int)numTimesReloadCalled.get());
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$1(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$2());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(broker.config().nodeId())), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$3(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$4());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExceptionInUpdateCoordinator() {
        KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();
        try {
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            long l = 60000L;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ retry_this = testUtils$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$1(broker);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            BrokerMetadataPublisher publisher = (BrokerMetadataPublisher)Mockito.spy((Object)broker.metadataPublisher());
            ((BrokerMetadataPublisher)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("injected failure")}).when((Object)publisher)).updateCoordinator((MetadataImage)ArgumentMatchers.any(), (MetadataDelta)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any());
            broker.metadataListener().alterPublisher((MetadataPublisher)publisher).get();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.createTopics(Collections.singletonList(new NewTopic("foo", 1, (short)1))).all().get();
            }
            TestUtils$ testUtils$2 = TestUtils$.MODULE$;
            long l2 = 60000L;
            if (testUtils$2 == null) {
                throw null;
            }
            TestUtils$ retry_this2 = testUtils$2;
            LongRef retry_wait2 = LongRef.create((long)1L);
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$2(cluster);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                    }
                    Thread.sleep(retry_wait2.elem);
                    retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                    continue;
                }
                break;
            }
        }
        finally {
            cluster.nonFatalFaultHandler().setIgnore(true);
            cluster.close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$1(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 0;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$2() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$3(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 1;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$4() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$1(BrokerServer broker$1) {
        Assertions.assertNotNull((Object)broker$1.metadataPublisher());
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$2(KafkaClusterTestKit cluster$1) {
        Assertions.assertTrue((boolean)((String)Option$.MODULE$.apply((Object)cluster$1.nonFatalFaultHandler().firstException()).flatMap((Function1 & Serializable & scala.Serializable)e -> Option$.MODULE$.apply((Object)e.getMessage())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "(none)")).contains("injected failure"));
    }
}

