/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.OptionSpec;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.utils.Exit$;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Array$;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u001f\u0002!\tA\u0010\u0005\u0006)\u0002!\tA\u0010\u0005\u00063\u0002!\tA\u0010\u0005\u00067\u0002!\tA\u0010\u0005\u0006;\u0002!\tA\u0010\u0005\u0006?\u0002!\tA\u0010\u0005\u0006C\u0002!\tA\u0010\u0005\u0006G\u0002!\tA\u0010\u0005\u0006K\u0002!\tA\u0010\u0005\u0006O\u0002!\tA\u0010\u0005\u0006S\u0002!\tA\u0010\u0005\u0006W\u0002!\tA\u0010\u0005\u0006[\u0002!\tA\u0010\u0005\u0006_\u0002!\tA\u0010\u0005\u0006c\u0002!\tA\u0010\u0005\u0006g\u0002!\tA\u0010\u0005\u0006k\u0002!\tA\u0010\u0005\u0006o\u0002!\tA\u0010\u0005\u0006s\u0002!\tA\u0010\u0005\u0006w\u0002!\tA\u0010\u0005\u0006{\u0002!\tA\u0010\u0005\u0006\u007f\u0002!\tA\u0010\u0005\u0007\u0003\u0007\u0001A\u0011\u0001 \t\r\u0005\u001d\u0001\u0001\"\u0001?\u0011\u0019\tY\u0001\u0001C\u0001}!9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001BBA\u001b\u0001\u0011\u0005a\b\u0003\u0004\u0002:\u0001!\tA\u0010\u0002\"%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7oQ8n[\u0006tG-\u0011:hgR+7\u000f\u001e\u0006\u0003G\u0011\nQ!\u00193nS:T\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"!\r\u0001\u000e\u0003\t\n\u0011$\\5tg&twMQ8piN$(/\u00199TKJ4XM]'tOV\tA\u0007\u0005\u00026u5\taG\u0003\u00028q\u0005!A.\u00198h\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\rM#(/\u001b8h\u0003ii\u0017n]:j]\u001e\u0014un\u001c;tiJ\f\u0007oU3sm\u0016\u0014Xj]4!\u0003\u0015\u0019X\r^+q)\u0005y\u0004CA\u0015A\u0013\t\t%F\u0001\u0003V]&$\bF\u0001\u0003D!\t!U*D\u0001F\u0015\t1u)A\u0002ba&T!\u0001S%\u0002\u000f),\b/\u001b;fe*\u0011!jS\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0019\u0006\u0019qN]4\n\u00059+%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u000b\u0002\u0006#B\u0011AIU\u0005\u0003'\u0016\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002_MDw.\u001e7e\u0007>\u0014(/Z2uYf\u0004\u0016M]:f-\u0006d\u0017\u000eZ'j]&lW/\\$f]\u0016\u0014\u0018\r^3PaRLwN\\:)\u0005\u00191\u0006C\u0001#X\u0013\tAVI\u0001\u0003UKN$\u0018AL:i_VdGmQ8se\u0016\u001cG\u000f\\=QCJ\u001cXMV1mS\u0012l\u0015N\\5nk6,\u00050Z2vi\u0016|\u0005\u000f^5p]ND#a\u0002,\u0002[MDw.\u001e7e\u0007>\u0014(/Z2uYf\u0004\u0016M]:f-\u0006d\u0017\u000eZ'j]&lW/\u001c,fe&4\u0017p\u00149uS>t7\u000f\u000b\u0002\t-\u0006\u00113\u000f[8vY\u0012\fE\u000e\\8x)\"\u0014x\u000e\u001e;mK>\u0003H/[8o\u001f:,\u00050Z2vi\u0016D#!\u0003,\u00025MDw.\u001e7e+N,G)\u001a4bk2$8/\u00134F]\u0006\u0014G.\u001a3)\u0005)1\u0016\u0001\u0003;fgRd\u0015n\u001d;)\u0005-1\u0016!\n;fgR\u001c\u0015M\\2fY^KG\u000f\u001b)sKN,'O^3UQJ|G\u000f\u001e7fg>\u0003H/[8oQ\taa+\u0001\ntQ>,H\u000e\u001a$bS2LeMT8Be\u001e\u001c\bFA\u0007W\u0003Q\u0019\bn\\;mI\u001a\u000b\u0017\u000e\\%g\u00052\fgn[!sO\"\u0012aBV\u0001\u001cg\"|W\u000f\u001c3GC&d\u0017JZ'vYRL\u0007\u000f\\3BGRLwN\\:)\u0005=1\u0016!J:i_VdGMT8u\u00032dwn^#yK\u000e,H/Z,ji\"$v\u000e]5dg>\u0003H/[8oQ\t\u0001b+A\u0012tQ>,H\u000e\u001a(pi\u0006cGn\\<Fq\u0016\u001cW\u000f^3XSRD'I]8lKJd\u0015n\u001d;)\u0005E1\u0016AL:i_VdGMT8u\u00032dwn^#yK\u000e,H/Z,ji\"|W\u000f\u001e*fCN\u001c\u0018n\u001a8nK:$x\n\u001d;j_:D#A\u0005,\u0002YQ,7\u000f^'jgNLgn\u001a\"p_R\u001cHO]1q'\u0016\u0014h/\u001a:Be\u001e,X.\u001a8u\r>\u0014X\t_3dkR,\u0007FA\nW\u0003Q\u001a\bn\\;mI:{G/\u00117m_^<UM\\3sCR,w+\u001b;i_V$(I]8lKJ\u001c\u0018I\u001c3U_BL7m](qi&|gn\u001d\u0015\u0003)Y\u000b!f\u001d5pk2$gj\u001c;BY2|woR3oKJ\fG/Z,ji\"|W\u000f\u001e\"s_.,'o](qi&|g\u000e\u000b\u0002\u0016-\u0006I3\u000f[8vY\u0012tu\u000e^!mY><x)\u001a8fe\u0006$XmV5uQ>,H\u000fV8qS\u000e\u001cx\n\u001d;j_:D#A\u0006,\u0002QMDw.\u001e7e\u001d>$\u0018\t\u001c7po\u001e+g.\u001a:bi\u0016<\u0016\u000e\u001e5UQJ|G\u000f\u001e7f\u001fB$\u0018n\u001c8)\u0005]1\u0016\u0001L:i_VdGMT8u\u00032dwn^$f]\u0016\u0014\u0018\r^3XSRD'+Z1tg&<g.\\3oi>\u0003H/[8oQ\tAb+\u0001\u000ftQ>,H\u000e\u001a)sS:$\b*\u001a7q)\u0016DH/\u00134IK2\u0004\u0018I]4)\u0005e1\u0016!L:i_VdGMT8u\u00032dwn\u001e,fe&4\u0017pV5uQ>,HOU3bgNLwM\\7f]R|\u0005\u000f^5p]\"\u0012!DV\u0001*g\"|W\u000f\u001c3O_R\fE\u000e\\8x\u0005J|7.\u001a:t\u0019&\u001cHoV5uQZ+'/\u001b4z\u001fB$\u0018n\u001c8)\u0005m1\u0016AJ:i_VdGMT8u\u00032dwn\u001e+ie>$H\u000f\\3XSRDg+\u001a:jMf|\u0005\u000f^5p]\"\u0012ADV\u0001%g\"|W\u000f\u001c3O_R\fE\u000e\\8x)>\u0004\u0018nY:PaRLwN\\,ji\"4VM]5gs\"\u0012QDV\u0001\u000fg\"|W\u000f\u001c3GC&dw+\u001b;i)\u0015y\u00141CA\u0016\u0011\u001d\t)B\ba\u0001\u0003/\t1!\\:h!\u0011\tI\"a\n\u000f\t\u0005m\u00111\u0005\t\u0004\u0003;QSBAA\u0010\u0015\r\t\tCJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015\"&\u0001\u0004Qe\u0016$WMZ\u0005\u0004w\u0005%\"bAA\u0013U!9\u0011Q\u0006\u0010A\u0002\u0005=\u0012\u0001B1sON\u0004R!KA\u0019\u0003/I1!a\r+\u0005\u0015\t%O]1z\u0003A\u001a\bn\\;mI:{G/\u00117m_^\u001c\u0015M\\2fY^KG\u000f[8vi\n{w\u000e^:ue\u0006\u00048+\u001a:wKJ|\u0005\u000f^5p]\"\u0012qDV\u00010g\"|W\u000f\u001c3O_R\fE\u000e\\8x\u0007\u0006t7-\u001a7XSRDw.\u001e;SK\u0006\u001c8/[4o[\u0016tGOS:p]\u001aKG.\u001a\u0015\u0003AYCs\u0001AA \u0003\u000b\n9\u0005E\u0002E\u0003\u0003J1!a\u0011F\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012\u0001\u0010")
public class ReassignPartitionsCommandArgsTest {
    private final String missingBootstrapServerMsg;

    public String missingBootstrapServerMsg() {
        return this.missingBootstrapServerMsg;
    }

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, message) -> ReassignPartitionsCommandArgsTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AfterEach
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void shouldCorrectlyParseValidMinimumGenerateOptions() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumExecuteOptions() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumVerifyOptions() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldAllowThrottleOptionOnExecute() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--throttle", "100", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldUseDefaultsIfEnabled() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
        Assertions.assertEquals((long)10000L, (long)BoxesRunTime.unboxToLong((Object)opts.options().valueOf((OptionSpec)opts.timeoutOpt())));
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)opts.options().valueOf((OptionSpec)opts.interBrokerThrottleOpt())));
    }

    @Test
    public void testList() {
        String[] args = (String[])((Object[])new String[]{"--list", "--bootstrap-server", "localhost:1234"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void testCancelWithPreserveThrottlesOption() {
        String[] args = (String[])((Object[])new String[]{"--cancel", "--bootstrap-server", "localhost:1234", "--reassignment-json-file", "myfile.json", "--preserve-throttles"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldFailIfNoArgs() {
        String[] args = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        this.shouldFailWith(ReassignPartitionsCommand$.MODULE$.helpText(), args);
    }

    @Test
    public void shouldFailIfBlankArg() {
        String[] args = (String[])((Object[])new String[]{" "});
        this.shouldFailWith("Command must include exactly one action", args);
    }

    @Test
    public void shouldFailIfMultipleActions() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--verify", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Command must include exactly one action", args);
    }

    @Test
    public void shouldNotAllowExecuteWithTopicsOption() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[topics-to-move-json-file]\" can't be used with action \"[execute]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithBrokerList() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--broker-list", "101,102"});
        this.shouldFailWith("Option \"[broker-list]\" can't be used with action \"[execute]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithoutReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--execute"});
        this.shouldFailWith("Missing required argument \"[reassignment-json-file]\"", args);
    }

    @Test
    public void testMissingBootstrapServerArgumentForExecute() {
        String[] args = (String[])((Object[])new String[]{"--execute"});
        this.shouldFailWith(this.missingBootstrapServerMsg(), args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersAndTopicsOptions() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--generate"});
        this.shouldFailWith("Missing required argument \"[topics-to-move-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersOption() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--topics-to-move-json-file", "myfile.json", "--generate"});
        this.shouldFailWith("Missing required argument \"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutTopicsOption() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--broker-list", "101,102", "--generate"});
        this.shouldFailWith("Missing required argument \"[topics-to-move-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithThrottleOption() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--generate", "--broker-list", "101,102", "--throttle", "100", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[throttle]\" can't be used with action \"[generate]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[reassignment-json-file]\" can't be used with action \"[generate]\"", args);
    }

    @Test
    public void shouldPrintHelpTextIfHelpArg() {
        String[] args = (String[])((Object[])new String[]{"--help"});
        this.shouldFailWith(ReassignPartitionsCommand$.MODULE$.helpText(), args);
    }

    @Test
    public void shouldNotAllowVerifyWithoutReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--verify"});
        this.shouldFailWith("Missing required argument \"[reassignment-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowBrokersListWithVerifyOption() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--verify", "--broker-list", "100,101", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[broker-list]\" can't be used with action \"[verify]\"", args);
    }

    @Test
    public void shouldNotAllowThrottleWithVerifyOption() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--verify", "--throttle", "100", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[throttle]\" can't be used with action \"[verify]\"", args);
    }

    @Test
    public void shouldNotAllowTopicsOptionWithVerify() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[topics-to-move-json-file]\" can't be used with action \"[verify]\"", args);
    }

    public void shouldFailWith(String msg, String[] args) {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args), () -> new StringBuilder(51).append("Should have failed with [").append(msg).append("] but no failure occurred.").toString());
        Assertions.assertTrue((boolean)e.getMessage().startsWith(msg), (String)new StringBuilder(46).append("Expected exception with message:\n[").append(msg).append("]\nbut was\n[").append(e.getMessage()).append("]").toString());
    }

    @Test
    public void shouldNotAllowCancelWithoutBootstrapServerOption() {
        String[] args = (String[])((Object[])new String[]{"--cancel"});
        this.shouldFailWith(this.missingBootstrapServerMsg(), args);
    }

    @Test
    public void shouldNotAllowCancelWithoutReassignmentJsonFile() {
        String[] args = (String[])((Object[])new String[]{"--cancel", "--bootstrap-server", "localhost:1234", "--preserve-throttles"});
        this.shouldFailWith("Missing required argument \"[reassignment-json-file]\"", args);
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public ReassignPartitionsCommandArgsTest() {
        this.missingBootstrapServerMsg = "Please specify --bootstrap-server";
    }
}

