/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.metadata.BrokerMetadataListener$;
import kafka.server.metadata.BrokerMetadataListener$BatchLoadResults$;
import kafka.server.metadata.MetadataPublisher;
import kafka.server.metadata.MetadataSnapshotter;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.SnapshotReader;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011]s!\u0002;v\u0011\u0003ah!\u0002@v\u0011\u0003y\bbBA\u0007\u0003\u0011\u0005\u0011q\u0002\u0005\n\u0003#\t!\u0019!C\u0001\u0003'A\u0001\"!\n\u0002A\u0003%\u0011Q\u0003\u0005\n\u0003O\t!\u0019!C\u0001\u0003'A\u0001\"!\u000b\u0002A\u0003%\u0011Q\u0003\u0004\u0006}V\u0004\u00111\u0006\u0005\u000b\u0003W:!Q1A\u0005\u0002\u00055\u0004BCA;\u000f\t\u0005\t\u0015!\u0003\u0002p!Q\u0011qO\u0004\u0003\u0002\u0003\u0006I!!\u001f\t\u0015\u0005\u001duA!A!\u0002\u0013\tI\t\u0003\u0006\u0002$\u001e\u0011)\u0019!C\u0001\u0003KC!\"!,\b\u0005\u0003\u0005\u000b\u0011BAT\u0011)\tyk\u0002BC\u0002\u0013\u0005\u0011\u0011\u0017\u0005\u000b\u0003w;!\u0011!Q\u0001\n\u0005M\u0006bBA\u0007\u000f\u0011\u0005\u0011Q\u0018\u0005\n\u0003\u0017<!\u0019!C\u0005\u0003\u001bD\u0001\"!6\bA\u0003%\u0011q\u001a\u0005\n\u0003/<!\u0019!C\u0005\u00033D\u0001\"a:\bA\u0003%\u00111\u001c\u0005\n\u0003S<!\u0019!C\u0005\u0003WD\u0001Ba\u0001\bA\u0003%\u0011Q\u001e\u0005\n\u0005\u000b9!\u0019!C\u0005\u0003WD\u0001Ba\u0002\bA\u0003%\u0011Q\u001e\u0005\n\u0005\u00139\u0001\u0019!C\u0001\u0003KC\u0011Ba\u0003\b\u0001\u0004%\tA!\u0004\t\u0011\teq\u0001)Q\u0005\u0003OC\u0011Ba\t\b\u0001\u0004%I!!*\t\u0013\t\u0015r\u00011A\u0005\n\t\u001d\u0002\u0002\u0003B\u0016\u000f\u0001\u0006K!a*\t\u0013\t5r\u00011A\u0005\n\t=\u0002\"\u0003B\u001f\u000f\u0001\u0007I\u0011\u0002B \u0011!\u0011\u0019e\u0002Q!\n\tE\u0002\"\u0003B#\u000f\u0001\u0007I\u0011\u0002B$\u0011%\u0011ye\u0002a\u0001\n\u0013\u0011\t\u0006\u0003\u0005\u0003V\u001d\u0001\u000b\u0015\u0002B%\u0011%\u00119f\u0002a\u0001\n\u0013\u0011I\u0006C\u0005\u0003d\u001d\u0001\r\u0011\"\u0003\u0003f!A!\u0011N\u0004!B\u0013\u0011Y\u0006C\u0005\u0003l\u001d\u0001\r\u0011\"\u0003\u0002&\"I!QN\u0004A\u0002\u0013%!q\u000e\u0005\t\u0005g:\u0001\u0015)\u0003\u0002(\"I!QO\u0004C\u0002\u0013\u0005!q\u000f\u0005\t\u0005\u000b;\u0001\u0015!\u0003\u0003z!9!qQ\u0004\u0005\u0002\u0005\u0015\u0006b\u0002BE\u000f\u0011\u0005#1\u0012\u0004\u0007\u0005/;\u0001A!'\t\u0015\t=uF!A!\u0002\u0013\u0011\t\nC\u0004\u0002\u000e=\"\tA!+\t\u000f\tEv\u0006\"\u0011\u00034\"9!QW\u0004\u0005\n\t]\u0006b\u0002B`\u000f\u0011\u0005#\u0011\u0019\u0004\u0007\u0005#<\u0001Aa5\t\u0015\t=UG!A!\u0002\u0013\u0011)\rC\u0004\u0002\u000eU\"\tA!6\t\u000f\tEV\u0007\"\u0011\u00034\u001a1!1\\\u0004A\u0005;D!Ba;:\u0005+\u0007I\u0011AA7\u0011)\u0011i/\u000fB\tB\u0003%\u0011q\u000e\u0005\u000b\u0005_L$Q3A\u0005\u0002\u00055\u0004B\u0003Bys\tE\t\u0015!\u0003\u0002p!Q!1_\u001d\u0003\u0016\u0004%\t!!*\t\u0015\tU\u0018H!E!\u0002\u0013\t9\u000b\u0003\u0006\u0003xf\u0012)\u001a!C\u0001\u0003KC!B!?:\u0005#\u0005\u000b\u0011BAT\u0011\u001d\ti!\u000fC\u0001\u0005wDqaa\u0002:\t\u0003\u001aI\u0001C\u0005\u0004\fe\n\t\u0011\"\u0001\u0004\u000e!I1qC\u001d\u0012\u0002\u0013\u00051\u0011\u0004\u0005\n\u0007_I\u0014\u0013!C\u0001\u00073A\u0011b!\r:#\u0003%\taa\r\t\u0013\r]\u0012(%A\u0005\u0002\rM\u0002\"CB\u001ds\u0005\u0005I\u0011IA\n\u0011%\u0019Y$OA\u0001\n\u0003\ti\u0007C\u0005\u0004>e\n\t\u0011\"\u0001\u0004@!I1\u0011J\u001d\u0002\u0002\u0013\u000531\n\u0005\n\u00073J\u0014\u0011!C\u0001\u00077B\u0011ba\u0018:\u0003\u0003%\te!\u0019\t\u0013\r\r\u0014(!A\u0005B\r\u0015t!CB5\u000f\u0005\u0005\t\u0012AB6\r%\u0011YnBA\u0001\u0012\u0003\u0019i\u0007C\u0004\u0002\u000eE#\taa\u001f\t\u0013\r\u001d\u0011+!A\u0005F\ru\u0004\"CB@#\u0006\u0005I\u0011QBA\u0011%\u0019Y)UA\u0001\n\u0003\u001bi\tC\u0004\u0004\u001c\u001e!Ia!(\t\u000f\r\u001dw\u0001\"\u0001\u0004J\u001a11\u0011]\u0004\u0001\u0007GD!ba8Y\u0005\u0003\u0005\u000b\u0011\u0002B/\u0011\u001d\ti\u0001\u0017C\u0001\u0007KD\u0011ba;Y\u0005\u0004%\ta!<\t\u0011\r=\b\f)A\u0005\u0007\u0017DqA!-Y\t\u0003\u0012\u0019\fC\u0004\u0004r\u001e!\taa=\u0007\r\r]x\u0001AB}\u0011)\u0019yn\u0018B\u0001B\u0003%!Q\f\u0005\b\u0003\u001byF\u0011AB~\u0011%\u0019Yo\u0018b\u0001\n\u0003\u0019i\u000f\u0003\u0005\u0004p~\u0003\u000b\u0011BBf\u0011\u001d\u0011\tl\u0018C!\u0005gCq\u0001\"\u0001\b\t\u0013!\u0019\u0001C\u0004\u0005\b\u001d!\t\u0005\"\u0003\t\u000f\u0011Uq\u0001\"\u0011\u00034\u001a1AqC\u0004\u0001\t3Aq!!\u0004i\t\u0003!Y\u0002C\u0004\u00032\"$\tEa-\t\u000f\u0011}q\u0001\"\u0001\u00034\"AA\u0011E\u0004\u0005\u0002e$\u0019C\u0002\u0004\u0005.\u001d\u0001Aq\u0006\u0005\u000b\u0007Wl'\u0011!Q\u0001\n\u0011\u0015\u0002bBA\u0007[\u0012\u0005AQ\b\u0005\n\t\u0007j'\u0019!C\u0001\t\u000bB\u0001\u0002\"\u0014nA\u0003%Aq\t\u0005\b\t\u001fjG\u0011\tC)\u0011\u001d\u0011\t,\u001cC!\u0005g\u000baC\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rT5ti\u0016tWM\u001d\u0006\u0003m^\f\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003qf\faa]3sm\u0016\u0014(\"\u0001>\u0002\u000b-\fgm[1\u0004\u0001A\u0011Q0A\u0007\u0002k\n1\"I]8lKJlU\r^1eCR\fG*[:uK:,'oE\u0002\u0002\u0003\u0003\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0003\u0003\u000f\tQa]2bY\u0006LA!a\u0003\u0002\u0006\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001?\u0002;5+G/\u00193bi\u0006\u0014\u0015\r^2i!J|7-Z:tS:<G+[7f+N,\"!!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005!A.\u00198h\u0015\t\ty\"\u0001\u0003kCZ\f\u0017\u0002BA\u0012\u00033\u0011aa\u0015;sS:<\u0017AH'fi\u0006$\u0017\r^1CCR\u001c\u0007\u000e\u0015:pG\u0016\u001c8/\u001b8h)&lW-V:!\u0003IiU\r^1eCR\f')\u0019;dQNK'0Z:\u0002'5+G/\u00193bi\u0006\u0014\u0015\r^2i'&TXm\u001d\u0011\u0014\u000f\u001d\ti#a\r\u0002`A!\u0011qCA\u0018\u0013\u0011\t\t$!\u0007\u0003\r=\u0013'.Z2u!\u0019\t)$a\u0013\u0002R9!\u0011qGA$\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012\u0001\u0002:bMRT1A_A \u0015\u0011\t\t%a\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)%A\u0002pe\u001eLA!!\u0013\u0002:\u0005Q!+\u00194u\u00072LWM\u001c;\n\t\u00055\u0013q\n\u0002\t\u0019&\u001cH/\u001a8fe*!\u0011\u0011JA\u001d!\u0011\t\u0019&a\u0017\u000e\u0005\u0005U#\u0002BA,\u00033\naaY8n[>t'b\u0001=\u0002>%!\u0011QLA+\u0005Q\t\u0005/['fgN\fw-Z!oIZ+'o]5p]B!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002fe\fq!\\3ue&\u001c7/\u0003\u0003\u0002j\u0005\r$!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006A!M]8lKJLE-\u0006\u0002\u0002pA!\u00111AA9\u0013\u0011\t\u0019(!\u0002\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005!A/[7f!\u0011\tY(a!\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000bQ!\u001e;jYNTA!a\u0016\u0002>%!\u0011QQA?\u0005\u0011!\u0016.\\3\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\bCBA\u0002\u0003\u0017\u000by)\u0003\u0003\u0002\u000e\u0006\u0015!AB(qi&|g\u000e\u0005\u0003\u0002\u0012\u0006}e\u0002BAJ\u00037\u0003B!!&\u0002\u00065\u0011\u0011q\u0013\u0006\u0004\u00033[\u0018A\u0002\u001fs_>$h(\u0003\u0003\u0002\u001e\u0006\u0015\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002$\u0005\u0005&\u0002BAO\u0003\u000b\t\u0001$\\1y\u0005f$Xm\u001d\"fi^,WM\\*oCB\u001c\bn\u001c;t+\t\t9\u000b\u0005\u0003\u0002\u0004\u0005%\u0016\u0002BAV\u0003\u000b\u0011A\u0001T8oO\u0006IR.\u0019=CsR,7OQ3uo\u0016,gn\u00158baNDw\u000e^:!\u0003-\u0019h.\u00199tQ>$H/\u001a:\u0016\u0005\u0005M\u0006CBA\u0002\u0003\u0017\u000b)\fE\u0002~\u0003oK1!!/v\u0005MiU\r^1eCR\f7K\\1qg\"|G\u000f^3s\u00031\u0019h.\u00199tQ>$H/\u001a:!)1\ty,!1\u0002D\u0006\u0015\u0017qYAe!\tix\u0001C\u0004\u0002lA\u0001\r!a\u001c\t\u000f\u0005]\u0004\u00031\u0001\u0002z!9\u0011q\u0011\tA\u0002\u0005%\u0005bBAR!\u0001\u0007\u0011q\u0015\u0005\b\u0003_\u0003\u0002\u0019AAZ\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0003\u0003\u001f\u0004B!a\u001f\u0002R&!\u00111[A?\u0005)aunZ\"p]R,\u0007\u0010^\u0001\fY><7i\u001c8uKb$\b%A\u0002m_\u001e,\"!a7\u0011\t\u0005u\u00171]\u0007\u0003\u0003?TA!!9\u0002D\u0005)1\u000f\u001c45U&!\u0011Q]Ap\u0005\u0019aunZ4fe\u0006!An\\4!\u0003]\u0011\u0017\r^2i!J|7-Z:tS:<G+[7f\u0011&\u001cH/\u0006\u0002\u0002nB!\u0011q^A\u0000\u001b\t\t\tP\u0003\u0003\u0002t\u0006U\u0018\u0001B2pe\u0016TA!!\u001a\u0002x*!\u0011\u0011`A~\u0003\u0019I\u0018-\\7fe*\u0011\u0011Q`\u0001\u0004G>l\u0017\u0002\u0002B\u0001\u0003c\u0014\u0011\u0002S5ti><'/Y7\u00021\t\fGo\u00195Qe>\u001cWm]:j]\u001e$\u0016.\\3ISN$\b%A\u000bnKR\fG-\u0019;b\u0005\u0006$8\r[*ju\u0016D\u0015n\u001d;\u0002-5,G/\u00193bi\u0006\u0014\u0015\r^2i'&TX\rS5ti\u0002\nab\u00185jO\",7\u000f^(gMN,G/\u0001\n`Q&<\u0007.Z:u\u001f\u001a47/\u001a;`I\u0015\fH\u0003\u0002B\b\u0005+\u0001B!a\u0001\u0003\u0012%!!1CA\u0003\u0005\u0011)f.\u001b;\t\u0013\t]!$!AA\u0002\u0005\u001d\u0016a\u0001=%c\u0005yq\f[5hQ\u0016\u001cHo\u00144gg\u0016$\b\u0005K\u0002\u001c\u0005;\u0001B!a\u0001\u0003 %!!\u0011EA\u0003\u0005!1x\u000e\\1uS2,\u0017!E0iS\u001eDWm\u001d;US6,7\u000f^1na\u0006)r\f[5hQ\u0016\u001cH\u000fV5nKN$\u0018-\u001c9`I\u0015\fH\u0003\u0002B\b\u0005SA\u0011Ba\u0006\u001e\u0003\u0003\u0005\r!a*\u0002%}C\u0017n\u001a5fgR$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u0007?&l\u0017mZ3\u0016\u0005\tE\u0002\u0003\u0002B\u001a\u0005si!A!\u000e\u000b\t\t]\u0012QH\u0001\u0006S6\fw-Z\u0005\u0005\u0005w\u0011)DA\u0007NKR\fG-\u0019;b\u00136\fw-Z\u0001\u000b?&l\u0017mZ3`I\u0015\fH\u0003\u0002B\b\u0005\u0003B\u0011Ba\u0006!\u0003\u0003\u0005\rA!\r\u0002\u000f}KW.Y4fA\u00051q\fZ3mi\u0006,\"A!\u0013\u0011\t\tM\"1J\u0005\u0005\u0005\u001b\u0012)DA\u0007NKR\fG-\u0019;b\t\u0016dG/Y\u0001\u000b?\u0012,G\u000e^1`I\u0015\fH\u0003\u0002B\b\u0005'B\u0011Ba\u0006$\u0003\u0003\u0005\rA!\u0013\u0002\u000f}#W\r\u001c;bA\u0005Qq\f];cY&\u001c\b.\u001a:\u0016\u0005\tm\u0003CBA\u0002\u0003\u0017\u0013i\u0006E\u0002~\u0005?J1A!\u0019v\u0005EiU\r^1eCR\f\u0007+\u001e2mSNDWM]\u0001\u000f?B,(\r\\5tQ\u0016\u0014x\fJ3r)\u0011\u0011yAa\u001a\t\u0013\t]a%!AA\u0002\tm\u0013aC0qk\nd\u0017n\u001d5fe\u0002\nqc\u00182zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^*oCB\u001c\bn\u001c;\u00027}\u0013\u0017\u0010^3t'&t7-\u001a'bgR\u001cf.\u00199tQ>$x\fJ3r)\u0011\u0011yA!\u001d\t\u0013\t]\u0011&!AA\u0002\u0005\u001d\u0016\u0001G0csR,7oU5oG\u0016d\u0015m\u001d;T]\u0006\u00048\u000f[8uA\u0005QQM^3oiF+X-^3\u0016\u0005\te\u0004\u0003\u0002B>\u0005\u0003k!A! \u000b\t\t}\u0014QH\u0001\u0006cV,W/Z\u0005\u0005\u0005\u0007\u0013iHA\bLC\u001a\\\u0017-\u0012<f]R\fV/Z;f\u0003-)g/\u001a8u#V,W/\u001a\u0011\u0002+!Lw\r[3ti6+G/\u00193bi\u0006|eMZ:fi\u0006a\u0001.\u00198eY\u0016\u001cu.\\7jiR!!q\u0002BG\u0011\u001d\u0011yI\fa\u0001\u0005#\u000baA]3bI\u0016\u0014\bCBA\u001c\u0005'\u000b\t&\u0003\u0003\u0003\u0016\u0006e\"a\u0003\"bi\u000eD'+Z1eKJ\u0014!\u0003S1oI2,7i\\7nSR\u001cXI^3oiN\u0019qFa'\u0011\t\tu%1\u0015\b\u0005\u0005w\u0012y*\u0003\u0003\u0003\"\nu\u0014AC#wK:$\u0018+^3vK&!!Q\u0015BT\u0005M1\u0015-\u001b7ve\u0016dunZ4j]\u001e,e/\u001a8u\u0015\u0011\u0011\tK! \u0015\t\t-&q\u0016\t\u0004\u0005[{S\"A\u0004\t\u000f\t=\u0015\u00071\u0001\u0003\u0012\u0006\u0019!/\u001e8\u0015\u0005\t=\u0011AD:i_VdGm\u00158baNDw\u000e\u001e\u000b\u0003\u0005s\u0003B!a\u0001\u0003<&!!QXA\u0003\u0005\u001d\u0011un\u001c7fC:\fa\u0002[1oI2,7K\\1qg\"|G\u000f\u0006\u0003\u0003\u0010\t\r\u0007b\u0002BHi\u0001\u0007!Q\u0019\t\u0007\u0005\u000f\u0014i-!\u0015\u000e\u0005\t%'\u0002\u0002Bf\u0003{\t\u0001b\u001d8baNDw\u000e^\u0005\u0005\u0005\u001f\u0014IM\u0001\bT]\u0006\u00048\u000f[8u%\u0016\fG-\u001a:\u0003'!\u000bg\u000e\u001a7f':\f\u0007o\u001d5pi\u00163XM\u001c;\u0014\u0007U\u0012Y\n\u0006\u0003\u0003X\ne\u0007c\u0001BWk!9!qR\u001cA\u0002\t\u0015'\u0001\u0005\"bi\u000eDGj\\1e%\u0016\u001cX\u000f\u001c;t'\u001dI\u0014\u0011\u0001Bp\u0005K\u0004B!a\u0001\u0003b&!!1]A\u0003\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u0001\u0003h&!!\u0011^A\u0003\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003)qW/\u001c\"bi\u000eDWm]\u0001\f]Vl')\u0019;dQ\u0016\u001c\b%\u0001\u0006ok6\u0014VmY8sIN\f1B\\;n%\u0016\u001cwN\u001d3tA\u0005IQ\r\\1qg\u0016$Wk]\u0001\u000bK2\f\u0007o]3e+N\u0004\u0013\u0001\u00038v[\nKH/Z:\u0002\u00139,XNQ=uKN\u0004CC\u0003B\u007f\u0005\u007f\u001c\taa\u0001\u0004\u0006A\u0019!QV\u001d\t\u000f\t-(\t1\u0001\u0002p!9!q\u001e\"A\u0002\u0005=\u0004b\u0002Bz\u0005\u0002\u0007\u0011q\u0015\u0005\b\u0005o\u0014\u0005\u0019AAT\u0003!!xn\u0015;sS:<GCAAH\u0003\u0011\u0019w\u000e]=\u0015\u0015\tu8qBB\t\u0007'\u0019)\u0002C\u0005\u0003l\u0012\u0003\n\u00111\u0001\u0002p!I!q\u001e#\u0011\u0002\u0003\u0007\u0011q\u000e\u0005\n\u0005g$\u0005\u0013!a\u0001\u0003OC\u0011Ba>E!\u0003\u0005\r!a*\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u001111\u0004\u0016\u0005\u0003_\u001aib\u000b\u0002\u0004 A!1\u0011EB\u0016\u001b\t\u0019\u0019C\u0003\u0003\u0004&\r\u001d\u0012!C;oG\",7m[3e\u0015\u0011\u0019I#!\u0002\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004.\r\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0007kQC!a*\u0004\u001e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\r\u00053q\t\t\u0005\u0003\u0007\u0019\u0019%\u0003\u0003\u0004F\u0005\u0015!aA!os\"I!qC&\u0002\u0002\u0003\u0007\u0011qN\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111Q\n\t\u0007\u0007\u001f\u001a)f!\u0011\u000e\u0005\rE#\u0002BB*\u0003\u000b\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00199f!\u0015\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005s\u001bi\u0006C\u0005\u0003\u00185\u000b\t\u00111\u0001\u0004B\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002p\u00051Q-];bYN$BA!/\u0004h!I!qC(\u0002\u0002\u0003\u00071\u0011I\u0001\u0011\u0005\u0006$8\r\u001b'pC\u0012\u0014Vm];miN\u00042A!,R'\u0015\t6q\u000eBs!9\u0019\tha\u001e\u0002p\u0005=\u0014qUAT\u0005{l!aa\u001d\u000b\t\rU\u0014QA\u0001\beVtG/[7f\u0013\u0011\u0019Iha\u001d\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0004lQ\u0011\u0011QC\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0005{\u001c\u0019i!\"\u0004\b\u000e%\u0005b\u0002Bv)\u0002\u0007\u0011q\u000e\u0005\b\u0005_$\u0006\u0019AA8\u0011\u001d\u0011\u0019\u0010\u0016a\u0001\u0003OCqAa>U\u0001\u0004\t9+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r=5q\u0013\t\u0007\u0003\u0007\tYi!%\u0011\u0019\u0005\r11SA8\u0003_\n9+a*\n\t\rU\u0015Q\u0001\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\reU+!AA\u0002\tu\u0018a\u0001=%a\u0005YAn\\1e\u0005\u0006$8\r[3t)1\u0011ipa(\u0004$\u000e]6QXBa\u0011\u001d\u0019\tK\u0016a\u0001\u0005\u0013\nQ\u0001Z3mi\u0006Dqa!*W\u0001\u0004\u00199+\u0001\u0005ji\u0016\u0014\u0018\r^8s!\u0019\u0019Ika,\u000426\u001111\u0016\u0006\u0005\u0007[\u000bi\"\u0001\u0003vi&d\u0017\u0002BB,\u0007W\u0003b!a\u000e\u00044\u0006E\u0013\u0002BB[\u0003s\u0011QAQ1uG\"Dqa!/W\u0001\u0004\u0019Y,A\nmCN$\u0018\t\u001d9f]\u0012$\u0016.\\3ti\u0006l\u0007\u000f\u0005\u0004\u0002\u0004\u0005-\u0015q\u0015\u0005\b\u0007\u007f3\u0006\u0019AB^\u0003Ma\u0017m\u001d;D_6l\u0017\u000e\u001e;fI>3gm]3u\u0011\u001d\u0019\u0019M\u0016a\u0001\u0007\u000b\f!\u0003\\1ti\u000e{W.\\5ui\u0016$W\t]8dQB1\u00111AAF\u0003_\nqb\u001d;beR\u0004VO\u00197jg\"Lgn\u001a\u000b\u0005\u0007\u0017\u001ci\u000e\u0005\u0004\u0004N\u000eM7q[\u0007\u0003\u0007\u001fTAa!5\u0004,\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\rU7q\u001a\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003BA\f\u00073LAaa7\u0002\u001a\t!ak\\5e\u0011\u001d\u0019yn\u0016a\u0001\u0005;\n\u0011\u0002];cY&\u001c\b.\u001a:\u0003)M#\u0018M\u001d;Qk\nd\u0017n\u001d5j]\u001e,e/\u001a8u'\rA&1\u0014\u000b\u0005\u0007O\u001cI\u000fE\u0002\u0003.bCqaa8[\u0001\u0004\u0011i&\u0001\u0004gkR,(/Z\u000b\u0003\u0007\u0017\fqAZ;ukJ,\u0007%\u0001\bbYR,'\u000fU;cY&\u001c\b.\u001a:\u0015\t\r-7Q\u001f\u0005\b\u0007?t\u0006\u0019\u0001B/\u0005M\tE\u000e^3s!V\u0014G.[:iKJ,e/\u001a8u'\ry&1\u0014\u000b\u0005\u0007{\u001cy\u0010E\u0002\u0003.~Cqaa8b\u0001\u0004\u0011i&A\u0004qk\nd\u0017n\u001d5\u0015\t\t=AQ\u0001\u0005\b\u0007?,\u0007\u0019\u0001B/\u0003IA\u0017M\u001c3mK2+\u0017\rZ3s\u0007\"\fgnZ3\u0015\t\t=A1\u0002\u0005\b\t\u001b1\u0007\u0019\u0001C\b\u00039aW-\u00193fe\u0006sG-\u00129pG\"\u0004B!a\u000e\u0005\u0012%!A1CA\u001d\u00059aU-\u00193fe\u0006sG-\u00129pG\"\fQBY3hS:\u001c\u0006.\u001e;e_^t'!D*ikR$wn\u001e8Fm\u0016tGoE\u0002i\u00057#\"\u0001\"\b\u0011\u0007\t5\u0006.A\u0003dY>\u001cX-A\bhKRLU.Y4f%\u0016\u001cwN\u001d3t)\t!)\u0003\u0005\u0004\u0004N\u000eMGq\u0005\t\u0007\u0007S#I#!\u0015\n\t\u0011-21\u0016\u0002\u0005\u0019&\u001cHO\u0001\u000bHKRLU.Y4f%\u0016\u001cwN\u001d3t\u000bZ,g\u000e^\n\u0006[\nmE\u0011\u0007\t\u0007\tg!I\u0004b\n\u000e\u0005\u0011U\"\u0002\u0002C\u001c\u0007W\u000b\u0001BZ;oGRLwN\\\u0005\u0005\tw!)D\u0001\u0005D_:\u001cX/\\3s)\u0011!y\u0004\"\u0011\u0011\u0007\t5V\u000eC\u0004\u0004l>\u0004\r\u0001\"\n\u0002\u000fI,7m\u001c:egV\u0011Aq\t\t\u0007\u0007S#I%!\u0015\n\t\u0011-31\u0016\u0002\n\u0003J\u0014\u0018-\u001f'jgR\f\u0001B]3d_J$7\u000fI\u0001\u0007C\u000e\u001cW\r\u001d;\u0015\t\t=A1\u000b\u0005\b\t+\u0012\b\u0019\u0001C\u0014\u0003\u0015\u0011\u0017\r^2i\u0001")
public class BrokerMetadataListener
implements RaftClient.Listener<ApiMessageAndVersion>,
KafkaMetricsGroup {
    private volatile BrokerMetadataListener$BatchLoadResults$ BatchLoadResults$module;
    private final int brokerId;
    private final Time time;
    private final long maxBytesBetweenSnapshots;
    private final Option<MetadataSnapshotter> snapshotter;
    private final LogContext logContext;
    private final Logger kafka$server$metadata$BrokerMetadataListener$$log;
    private final Histogram batchProcessingTimeHist;
    private final Histogram metadataBatchSizeHist;
    private volatile long _highestOffset;
    private long kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp;
    private MetadataImage kafka$server$metadata$BrokerMetadataListener$$_image;
    private MetadataDelta kafka$server$metadata$BrokerMetadataListener$$_delta;
    private Option<MetadataPublisher> kafka$server$metadata$BrokerMetadataListener$$_publisher;
    private long kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot;
    private final KafkaEventQueue eventQueue;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String MetadataBatchSizes() {
        return BrokerMetadataListener$.MODULE$.MetadataBatchSizes();
    }

    public static String MetadataBatchProcessingTimeUs() {
        return BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public BrokerMetadataListener$BatchLoadResults$ BatchLoadResults() {
        if (this.BatchLoadResults$module == null) {
            this.BatchLoadResults$lzycompute$1();
        }
        return this.BatchLoadResults$module;
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long maxBytesBetweenSnapshots() {
        return this.maxBytesBetweenSnapshots;
    }

    public Option<MetadataSnapshotter> snapshotter() {
        return this.snapshotter;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public Logger kafka$server$metadata$BrokerMetadataListener$$log() {
        return this.kafka$server$metadata$BrokerMetadataListener$$log;
    }

    private Histogram batchProcessingTimeHist() {
        return this.batchProcessingTimeHist;
    }

    private Histogram metadataBatchSizeHist() {
        return this.metadataBatchSizeHist;
    }

    public long _highestOffset() {
        return this._highestOffset;
    }

    public void _highestOffset_$eq(long x$1) {
        this._highestOffset = x$1;
    }

    public long kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp;
    }

    private void kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp_$eq(long x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp = x$1;
    }

    public MetadataImage kafka$server$metadata$BrokerMetadataListener$$_image() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_image;
    }

    private void kafka$server$metadata$BrokerMetadataListener$$_image_$eq(MetadataImage x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_image = x$1;
    }

    public MetadataDelta kafka$server$metadata$BrokerMetadataListener$$_delta() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_delta;
    }

    public void kafka$server$metadata$BrokerMetadataListener$$_delta_$eq(MetadataDelta x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_delta = x$1;
    }

    public Option<MetadataPublisher> kafka$server$metadata$BrokerMetadataListener$$_publisher() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_publisher;
    }

    public void kafka$server$metadata$BrokerMetadataListener$$_publisher_$eq(Option<MetadataPublisher> x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_publisher = x$1;
    }

    public long kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot;
    }

    public void kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot_$eq(long x$1) {
        this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot = x$1;
    }

    public KafkaEventQueue eventQueue() {
        return this.eventQueue;
    }

    public long highestMetadataOffset() {
        return this._highestOffset();
    }

    public void handleCommit(BatchReader<ApiMessageAndVersion> reader) {
        this.eventQueue().append((EventQueue.Event)new HandleCommitsEvent(this, reader));
    }

    public boolean kafka$server$metadata$BrokerMetadataListener$$shouldSnapshot() {
        return this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot() >= this.maxBytesBetweenSnapshots();
    }

    public void handleSnapshot(SnapshotReader<ApiMessageAndVersion> reader) {
        this.eventQueue().append((EventQueue.Event)new HandleSnapshotEvent(this, reader));
    }

    public BatchLoadResults kafka$server$metadata$BrokerMetadataListener$$loadBatches(MetadataDelta delta, java.util.Iterator<Batch<ApiMessageAndVersion>> iterator, Option<Object> lastAppendTimestamp, Option<Object> lastCommittedOffset, Option<Object> lastCommittedEpoch) {
        long startTimeNs = this.time.nanoseconds();
        int numBatches = 0;
        IntRef numRecords = IntRef.create((int)0);
        long numBytes = 0L;
        while (iterator.hasNext()) {
            Batch<ApiMessageAndVersion> batch = iterator.next();
            int epoch = BoxesRunTime.unboxToInt((Object)lastCommittedEpoch.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> batch.epoch()));
            this.kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp_$eq(BoxesRunTime.unboxToLong((Object)lastAppendTimestamp.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> batch.appendTimestamp())));
            IntRef index = IntRef.create((int)0);
            batch.records().forEach(messageAndVersion -> {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Metadata batch ").append(batch.lastOffset()).append(": processing [").append(index$1.elem + 1).append("/").append(batch.records().size()).append("]:").append(" ").append(messageAndVersion.message()).toString());
                }
                this._highestOffset_$eq(BoxesRunTime.unboxToLong((Object)lastCommittedOffset.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> batch.baseOffset() + (long)index$1.elem)));
                delta.replay(this.highestMetadataOffset(), epoch, messageAndVersion.message());
                ++numRecords$1.elem;
                ++index$1.elem;
            });
            numBytes += (long)batch.sizeInBytes();
            this.metadataBatchSizeHist().update(batch.records().size());
            ++numBatches;
        }
        long endTimeNs = this.time.nanoseconds();
        long elapsedUs = TimeUnit.MICROSECONDS.convert(endTimeNs - startTimeNs, TimeUnit.NANOSECONDS);
        this.batchProcessingTimeHist().update(elapsedUs);
        return new BatchLoadResults(this, numBatches, numRecords.elem, elapsedUs, numBytes);
    }

    public CompletableFuture<Void> startPublishing(MetadataPublisher publisher) {
        StartPublishingEvent event = new StartPublishingEvent(this, publisher);
        this.eventQueue().append((EventQueue.Event)event);
        return event.future();
    }

    public CompletableFuture<Void> alterPublisher(MetadataPublisher publisher) {
        AlterPublisherEvent event = new AlterPublisherEvent(this, publisher);
        this.eventQueue().append((EventQueue.Event)event);
        return event.future();
    }

    public void kafka$server$metadata$BrokerMetadataListener$$publish(MetadataPublisher publisher) {
        MetadataDelta delta = this.kafka$server$metadata$BrokerMetadataListener$$_delta();
        this.kafka$server$metadata$BrokerMetadataListener$$_image_$eq(this.kafka$server$metadata$BrokerMetadataListener$$_delta().apply());
        this.kafka$server$metadata$BrokerMetadataListener$$_delta_$eq(new MetadataDelta(this.kafka$server$metadata$BrokerMetadataListener$$_image()));
        if (this.isDebugEnabled()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Publishing new metadata delta ").append(delta).append(" at offset ").append($this.kafka$server$metadata$BrokerMetadataListener$$_image().highestOffsetAndEpoch().offset).append(".").toString());
        }
        publisher.publish(delta, this.kafka$server$metadata$BrokerMetadataListener$$_image());
    }

    public void handleLeaderChange(LeaderAndEpoch leaderAndEpoch) {
    }

    public void beginShutdown() {
        this.eventQueue().beginShutdown("beginShutdown", (EventQueue.Event)new ShutdownEvent());
    }

    public void close() {
        this.beginShutdown();
        this.eventQueue().close();
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<List<ApiMessageAndVersion>> getImageRecords() {
        void var1_1;
        CompletableFuture<List<ApiMessageAndVersion>> future = new CompletableFuture<List<ApiMessageAndVersion>>();
        this.eventQueue().append((EventQueue.Event)new GetImageRecordsEvent(this, future));
        return var1_1;
    }

    private final void BatchLoadResults$lzycompute$1() {
        synchronized (this) {
            if (this.BatchLoadResults$module == null) {
                this.BatchLoadResults$module = new BrokerMetadataListener$BatchLoadResults$(this);
            }
            return;
        }
    }

    public BrokerMetadataListener(int brokerId, Time time, Option<String> threadNamePrefix, long maxBytesBetweenSnapshots, Option<MetadataSnapshotter> snapshotter) {
        this.brokerId = brokerId;
        this.time = time;
        this.maxBytesBetweenSnapshots = maxBytesBetweenSnapshots;
        this.snapshotter = snapshotter;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logContext = new LogContext(new StringBuilder(29).append("[BrokerMetadataListener id=").append(brokerId).append("] ").toString());
        this.kafka$server$metadata$BrokerMetadataListener$$log = this.logContext().logger(BrokerMetadataListener.class);
        this.logIdent_$eq(this.logContext().logPrefix());
        this.batchProcessingTimeHist = this.newHistogram(BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs(), this.newHistogram$default$2(), this.newHistogram$default$3());
        this.metadataBatchSizeHist = this.newHistogram(BrokerMetadataListener$.MODULE$.MetadataBatchSizes(), this.newHistogram$default$2(), this.newHistogram$default$3());
        this._highestOffset = -1L;
        this.kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp = -1L;
        this.kafka$server$metadata$BrokerMetadataListener$$_image = MetadataImage.EMPTY;
        this.kafka$server$metadata$BrokerMetadataListener$$_delta = new MetadataDelta(this.kafka$server$metadata$BrokerMetadataListener$$_image());
        this.kafka$server$metadata$BrokerMetadataListener$$_publisher = None$.MODULE$;
        this.kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot = 0L;
        this.eventQueue = new KafkaEventQueue(time, this.logContext(), (String)threadNamePrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public class AlterPublisherEvent
    extends EventQueue.FailureLoggingEvent {
        private final MetadataPublisher publisher;
        private final CompletableFuture<Void> future;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public CompletableFuture<Void> future() {
            return this.future;
        }

        public void run() {
            this.kafka$server$metadata$BrokerMetadataListener$AlterPublisherEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_publisher_$eq((Option<MetadataPublisher>)new Some((Object)this.publisher));
            this.kafka$server$metadata$BrokerMetadataListener$AlterPublisherEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$log().info(new StringBuilder(17).append("Set publisher to ").append(this.publisher).toString());
            this.future().complete(null);
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$AlterPublisherEvent$$$outer() {
            return this.$outer;
        }

        public AlterPublisherEvent(BrokerMetadataListener $outer, MetadataPublisher publisher) {
            this.publisher = publisher;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
            this.future = new CompletableFuture();
        }
    }

    public class BatchLoadResults
    implements Product,
    scala.Serializable {
        private final int numBatches;
        private final int numRecords;
        private final long elapsedUs;
        private final long numBytes;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public int numBatches() {
            return this.numBatches;
        }

        public int numRecords() {
            return this.numRecords;
        }

        public long elapsedUs() {
            return this.elapsedUs;
        }

        public long numBytes() {
            return this.numBytes;
        }

        public String toString() {
            return new StringBuilder(71).append(this.numBatches()).append(" batch(es) with ").append(this.numRecords()).append(" record(s) in ").append(this.numBytes()).append(" bytes ").append("ending at offset ").append(this.kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer().highestMetadataOffset()).append(" in ").append(this.elapsedUs()).append(" microseconds").toString();
        }

        public BatchLoadResults copy(int numBatches, int numRecords, long elapsedUs, long numBytes) {
            return new BatchLoadResults(this.kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer(), numBatches, numRecords, elapsedUs, numBytes);
        }

        public int copy$default$1() {
            return this.numBatches();
        }

        public int copy$default$2() {
            return this.numRecords();
        }

        public long copy$default$3() {
            return this.elapsedUs();
        }

        public long copy$default$4() {
            return this.numBytes();
        }

        public String productPrefix() {
            return "BatchLoadResults";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.numBatches());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.numRecords());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.elapsedUs());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this.numBytes());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BatchLoadResults;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.numBatches()), (int)this.numRecords()), (int)Statics.longHash((long)this.elapsedUs())), (int)Statics.longHash((long)this.numBytes())), (int)4);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof BatchLoadResults && ((BatchLoadResults)x$1).kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer() == this.kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer();
                    if (!bl) break block3;
                    BatchLoadResults batchLoadResults = (BatchLoadResults)x$1;
                    if (!(this.numBatches() == batchLoadResults.numBatches() && this.numRecords() == batchLoadResults.numRecords() && this.elapsedUs() == batchLoadResults.elapsedUs() && this.numBytes() == batchLoadResults.numBytes() && batchLoadResults.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$BatchLoadResults$$$outer() {
            return this.$outer;
        }

        public BatchLoadResults(BrokerMetadataListener $outer, int numBatches, int numRecords, long elapsedUs, long numBytes) {
            this.numBatches = numBatches;
            this.numRecords = numRecords;
            this.elapsedUs = elapsedUs;
            this.numBytes = numBytes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class GetImageRecordsEvent
    extends EventQueue.FailureLoggingEvent
    implements Consumer<List<ApiMessageAndVersion>> {
        private final CompletableFuture<List<ApiMessageAndVersion>> future;
        private final ArrayList<ApiMessageAndVersion> records;
        public final /* synthetic */ BrokerMetadataListener $outer;

        @Override
        public Consumer<List<ApiMessageAndVersion>> andThen(Consumer<? super List<ApiMessageAndVersion>> x$1) {
            return Consumer.super.andThen(x$1);
        }

        public ArrayList<ApiMessageAndVersion> records() {
            return this.records;
        }

        @Override
        public void accept(List<ApiMessageAndVersion> batch) {
            this.records().addAll(batch);
        }

        public void run() {
            this.kafka$server$metadata$BrokerMetadataListener$GetImageRecordsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_image().write((Consumer)this);
            this.future.complete(this.records());
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$GetImageRecordsEvent$$$outer() {
            return this.$outer;
        }

        public GetImageRecordsEvent(BrokerMetadataListener $outer, CompletableFuture<List<ApiMessageAndVersion>> future) {
            this.future = future;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
            this.records = new ArrayList();
        }
    }

    public class HandleCommitsEvent
    extends EventQueue.FailureLoggingEvent {
        private final BatchReader<ApiMessageAndVersion> reader;
        public final /* synthetic */ BrokerMetadataListener $outer;

        /*
         * WARNING - void declaration
         */
        public void run() {
            void var1_1;
            try {
                BatchLoadResults loadResults = this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$loadBatches(this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta(), (java.util.Iterator<Batch<ApiMessageAndVersion>>)this.reader, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                if (this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().isDebugEnabled()) {
                    this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Loaded new commits: ").append(loadResults).toString());
                }
            }
            finally {
                this.reader.close();
            }
            this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_publisher().foreach((Function1 & Serializable & scala.Serializable)publisher -> {
                HandleCommitsEvent.$anonfun$run$2(this, publisher);
                return BoxedUnit.UNIT;
            });
            this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().snapshotter().foreach(arg_0 -> HandleCommitsEvent.$anonfun$run$3$adapted(this, (BatchLoadResults)var1_1, arg_0));
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$2(HandleCommitsEvent $this, MetadataPublisher publisher) {
            $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$publish(publisher);
        }

        public static final /* synthetic */ void $anonfun$run$3(HandleCommitsEvent $this, BatchLoadResults results$1, MetadataSnapshotter snapshotter) {
            $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot_$eq($this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot() + results$1.numBytes());
            if ($this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$shouldSnapshot() && snapshotter.maybeStartSnapshot($this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_highestTimestamp(), $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta().apply())) {
                $this.kafka$server$metadata$BrokerMetadataListener$HandleCommitsEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_bytesSinceLastSnapshot_$eq(0L);
                return;
            }
        }

        public HandleCommitsEvent(BrokerMetadataListener $outer, BatchReader<ApiMessageAndVersion> reader) {
            this.reader = reader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
        }

        public static final /* synthetic */ Object $anonfun$run$3$adapted(HandleCommitsEvent $this, BatchLoadResults results$1, MetadataSnapshotter snapshotter) {
            HandleCommitsEvent.$anonfun$run$3($this, results$1, snapshotter);
            return BoxedUnit.UNIT;
        }
    }

    public class HandleSnapshotEvent
    extends EventQueue.FailureLoggingEvent {
        private final SnapshotReader<ApiMessageAndVersion> reader;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public void run() {
            try {
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Loading snapshot ").append($this.reader.snapshotId().offset).append("-").append($this.reader.snapshotId().epoch).append(".").toString());
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta_$eq(new MetadataDelta(this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_image()));
                BatchLoadResults loadResults = this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$loadBatches(this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta(), (java.util.Iterator<Batch<ApiMessageAndVersion>>)this.reader, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.reader.lastContainedLogTimestamp())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.reader.lastContainedLogOffset())), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.reader.lastContainedLogEpoch())));
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_delta().finishSnapshot();
                this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Loaded snapshot ").append($this.reader.snapshotId().offset).append("-").append($this.reader.snapshotId().epoch).append(": ").append(loadResults).toString());
            }
            finally {
                this.reader.close();
            }
            this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_publisher().foreach((Function1 & Serializable & scala.Serializable)publisher -> {
                HandleSnapshotEvent.$anonfun$run$6(this, publisher);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$6(HandleSnapshotEvent $this, MetadataPublisher publisher) {
            $this.kafka$server$metadata$BrokerMetadataListener$HandleSnapshotEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$publish(publisher);
        }

        public HandleSnapshotEvent(BrokerMetadataListener $outer, SnapshotReader<ApiMessageAndVersion> reader) {
            this.reader = reader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
        }
    }

    public class ShutdownEvent
    extends EventQueue.FailureLoggingEvent {
        public void run() {
            this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric(BrokerMetadataListener$.MODULE$.MetadataBatchProcessingTimeUs(), this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric$default$2());
            this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric(BrokerMetadataListener$.MODULE$.MetadataBatchSizes(), this.kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer().removeMetric$default$2());
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$ShutdownEvent$$$outer() {
            return BrokerMetadataListener.this;
        }

        public ShutdownEvent() {
            if (BrokerMetadataListener.this == null) {
                throw null;
            }
            super(BrokerMetadataListener.this.kafka$server$metadata$BrokerMetadataListener$$log());
        }
    }

    public class StartPublishingEvent
    extends EventQueue.FailureLoggingEvent {
        private final MetadataPublisher publisher;
        private final CompletableFuture<Void> future;
        public final /* synthetic */ BrokerMetadataListener $outer;

        public CompletableFuture<Void> future() {
            return this.future;
        }

        public void run() {
            this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$_publisher_$eq((Option<MetadataPublisher>)new Some((Object)this.publisher));
            this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$log().info(new StringBuilder(47).append("Starting to publish metadata events at offset ").append(this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().highestMetadataOffset()).append(".").toString());
            try {
                this.kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer().kafka$server$metadata$BrokerMetadataListener$$publish(this.publisher);
                this.future().complete(null);
                return;
            }
            catch (Throwable e) {
                this.future().completeExceptionally(e);
                throw e;
            }
        }

        public /* synthetic */ BrokerMetadataListener kafka$server$metadata$BrokerMetadataListener$StartPublishingEvent$$$outer() {
            return this.$outer;
        }

        public StartPublishingEvent(BrokerMetadataListener $outer, MetadataPublisher publisher) {
            this.publisher = publisher;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$server$metadata$BrokerMetadataListener$$log());
            this.future = new CompletableFuture();
        }
    }
}

