/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r]s!B\u0016-\u0011\u0003\u0019d!B\u001b-\u0011\u00031\u0004\"B\u001f\u0002\t\u0003q\u0004\"B \u0002\t\u0003\u0001\u0005bBB&\u0003\u0011%1Q\n\u0005\b\u0007#\nA\u0011BB*\r\u0011)D\u0006\u0001\"\t\u0011%3!\u0011!Q\u0001\n)C\u0001\"\u0014\u0004\u0003\u0002\u0003\u0006IA\u0014\u0005\t#\u001a\u0011\t\u0011)A\u0005%\"A\u0001L\u0002B\u0001B\u0003%\u0011\f\u0003\u0005]\r\t\u0005\t\u0015!\u0003^\u0011!\u0001gA!A!\u0002\u0013\t\u0007\u0002C7\u0007\u0005\u0003\u0005\u000b\u0011\u00028\t\u000bu2A\u0011A9\u0006\te4\u0001A_\u0003\u0007\u0003\u000f1\u0001!!\u0003\u0006\r\u0005]a\u0001AA\u0005\u000b\u0019\tIB\u0002\u0001\u0002\u001c!I\u00111\n\u0004C\u0002\u0013%\u0011Q\n\u0005\t\u0003O2\u0001\u0015!\u0003\u0002P!I\u0011\u0011\u000e\u0004C\u0002\u0013\u0005\u00111\u000e\u0005\b\u0003[2\u0001\u0015!\u0003V\u0011\u001d\tyG\u0002C\u0001\u0003cB\u0011\"!/\u0007#\u0003%\t!a/\t\u000f\u0005Eg\u0001\"\u0003\u0002T\"9\u0011q\u001f\u0004\u0005\u0002\u0005e\bb\u0002B\u000f\r\u0011\u0005!q\u0004\u0005\b\u0005c1A\u0011\u0001B\u001a\u0011%\u0011\tGBI\u0001\n\u0003\tY\fC\u0004\u0003d\u0019!\tA!\u001a\t\u000f\t5d\u0001\"\u0001\u0003p!9!q\u000f\u0004\u0005\n\te\u0004b\u0002BP\r\u0011\u0005!\u0011\u0015\u0005\n\u0005g3\u0011\u0013!C\u0001\u0003wCqA!.\u0007\t\u0013\u00119\fC\u0004\u0003P\u001a!\tA!5\t\u000f\tmg\u0001\"\u0001\u0003^\"9!\u0011\u001d\u0004\u0005\n\t\r\b\u0002\u0003B{\r\u0011\u0005AFa>\t\u000f\t}h\u0001\"\u0001\u0004\u0002!I1Q\u0002\u0004\u0012\u0002\u0013\u00051q\u0002\u0005\b\u0007'1A\u0011AB\u000b\u0003Y!&/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014(BA\u0017/\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005=\u0002\u0014aC2p_J$\u0017N\\1u_JT\u0011!M\u0001\u0006W\u000647.Y\u0002\u0001!\t!\u0014!D\u0001-\u0005Y!&/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u00148CA\u00018!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aM\u0001\u0006CB\u0004H.\u001f\u000b\u0010\u0003\u000e]1\u0011EB\u0016\u0007[\u0019\tda\u0010\u0004JA\u0011AGB\n\u0004\r]\u001a\u0005C\u0001#H\u001b\u0005)%B\u0001$1\u0003\u0015)H/\u001b7t\u0013\tAUIA\u0004M_\u001e<\u0017N\\4\u0002\u0013QDhnQ8oM&<\u0007C\u0001\u001bL\u0013\taEFA\tUe\u0006t7/Y2uS>t7i\u001c8gS\u001e\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005\u0011{\u0015B\u0001)F\u0005%\u00196\r[3ek2,'/A\fde\u0016\fG/\u001a)s_\u0012,8-\u001a:JI6\u000bg.Y4feB\u0019\u0001hU+\n\u0005QK$!\u0003$v]\u000e$\u0018n\u001c81!\t!d+\u0003\u0002XY\t\t\u0002K]8ek\u000e,'/\u00133NC:\fw-\u001a:\u0002\u0015QDh.T1oC\u001e,'\u000f\u0005\u000255&\u00111\f\f\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\fq\u0003\u001e=o\u001b\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0011\u0005Qr\u0016BA0-\u0005}!&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0005i&lW\r\u0005\u0002cW6\t1M\u0003\u0002GI*\u0011QMZ\u0001\u0007G>lWn\u001c8\u000b\u0005E:'B\u00015j\u0003\u0019\t\u0007/Y2iK*\t!.A\u0002pe\u001eL!\u0001\\2\u0003\tQKW.Z\u0001\u000bY><7i\u001c8uKb$\bC\u00012p\u0013\t\u00018M\u0001\u0006M_\u001e\u001cuN\u001c;fqR$\u0002\"\u0011:tiV4x\u000f\u001f\u0005\u0006\u0013:\u0001\rA\u0013\u0005\u0006\u001b:\u0001\rA\u0014\u0005\u0006#:\u0001\rA\u0015\u0005\u00061:\u0001\r!\u0017\u0005\u00069:\u0001\r!\u0018\u0005\u0006A:\u0001\r!\u0019\u0005\u0006[:\u0001\rA\u001c\u0002\u0017\u0013:LG\u000f\u0015:pIV\u001cWM]%e\u0007\u0006dGNY1dWB)\u0001h_?\u0002\u0002%\u0011A0\u000f\u0002\n\rVt7\r^5p]F\u0002\"\u0001\u000e@\n\u0005}d#\u0001F%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a*fgVdG\u000fE\u00029\u0003\u0007I1!!\u0002:\u0005\u0011)f.\u001b;\u0003+\u0005#G\rU1si&$\u0018n\u001c8t\u0007\u0006dGNY1dWB1\u0001h_A\u0006\u0003\u0003\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#!\u0017\u0001\u00039s_R|7m\u001c7\n\t\u0005U\u0011q\u0002\u0002\u0007\u000bJ\u0014xN]:\u0003\u001d\u0015sG\r\u0016=o\u0007\u0006dGNY1dW\nI\u0011\t]5SKN,H\u000e^\u000b\u0005\u0003;\tI\u0004\u0005\u0005\u0002 \u0005=\u00121BA\u001b\u001d\u0011\t\t#a\u000b\u000f\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n3\u0003\u0019a$o\\8u}%\t!(C\u0002\u0002.e\nq\u0001]1dW\u0006<W-\u0003\u0003\u00022\u0005M\"AB#ji\",'OC\u0002\u0002.e\u0002B!a\u000e\u0002:1\u0001AaBA\u001e%\t\u0007\u0011Q\b\u0002\u0002)F!\u0011qHA#!\rA\u0014\u0011I\u0005\u0004\u0003\u0007J$a\u0002(pi\"Lgn\u001a\t\u0004q\u0005\u001d\u0013bAA%s\t\u0019\u0011I\\=\u0002\u0011%\u001c\u0018i\u0019;jm\u0016,\"!a\u0014\u0011\t\u0005E\u00131M\u0007\u0003\u0003'RA!!\u0016\u0002X\u00051\u0011\r^8nS\u000eTA!!\u0017\u0002\\\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005u\u0013qL\u0001\u0005kRLGN\u0003\u0002\u0002b\u0005!!.\u0019<b\u0013\u0011\t)'a\u0015\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003%I7/Q2uSZ,\u0007%A\tqe>$WoY3s\u0013\u0012l\u0015M\\1hKJ,\u0012!V\u0001\u0013aJ|G-^2fe&#W*\u00198bO\u0016\u0014\b%\u0001\u000biC:$G.Z%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\r\u0003\u0003\t\u0019(a\"\u0002\u0012\u0006\u0005\u0016\u0011\u0016\u0005\b\u0003k:\u0002\u0019AA<\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007\u0003BA=\u0003\u0003sA!a\u001f\u0002~A\u0019\u00111E\u001d\n\u0007\u0005}\u0014(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\u000b)I\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u007fJ\u0004bBAE/\u0001\u0007\u00111R\u0001\u0015iJ\fgn]1di&|g\u000eV5nK>,H/T:\u0011\u0007a\ni)C\u0002\u0002\u0010f\u00121!\u00138u\u0011\u001d\t\u0019j\u0006a\u0001\u0003+\u000b!$\u001a=qK\u000e$X\r\u001a)s_\u0012,8-\u001a:JI\u0006sG-\u00129pG\"\u0004R\u0001OAL\u00037K1!!':\u0005\u0019y\u0005\u000f^5p]B\u0019!-!(\n\u0007\u0005}5M\u0001\nQe>$WoY3s\u0013\u0012\fe\u000eZ#q_\u000eD\u0007bBAR/\u0001\u0007\u0011QU\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u00042!a*\u0010\u001b\u00051\u0001\"CAV/A\u0005\t\u0019AAW\u00031\u0011X-];fgRdunY1m!\u0011\ty+!.\u000e\u0005\u0005E&bAAZa\u000511/\u001a:wKJLA!a.\u00022\na!+Z9vKN$Hj\\2bY\u0006q\u0002.\u00198eY\u0016Le.\u001b;Qe>$WoY3s\u0013\u0012$C-\u001a4bk2$H%N\u000b\u0003\u0003{SC!!,\u0002@.\u0012\u0011\u0011\u0019\t\u0005\u0003\u0007\fi-\u0004\u0002\u0002F*!\u0011qYAe\u0003%)hn\u00195fG.,GMC\u0002\u0002Lf\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty-!2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000fqe\u0016\u0004\u0018M]3J]&$\bK]8ek\u000e,'/\u00133Ue\u0006t7/\u001b;\u0015\u0019\u0005U\u00171]As\u0003O\fY/!>\u0011\u000b\u0005\u001d&#a6\u0011\u000fa\nI.a#\u0002^&\u0019\u00111\\\u001d\u0003\rQ+\b\u000f\\33!\r!\u0014q\\\u0005\u0004\u0003Cd#A\u0005+y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006Dq!!\u001e\u001a\u0001\u0004\t9\bC\u0004\u0002\nf\u0001\r!a#\t\u000f\u0005%\u0018\u00041\u0001\u0002\f\u0006\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0005\b\u0003[L\u0002\u0019AAx\u0003-!\bP\\'fi\u0006$\u0017\r^1\u0011\u0007Q\n\t0C\u0002\u0002t2\u00121\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006Dq!a%\u001a\u0001\u0004\t)*\u0001\fiC:$G.\u001a'jgR$&/\u00198tC\u000e$\u0018n\u001c8t)\u0019\tYPa\u0002\u0003\u0018A!\u0011Q B\u0002\u001b\t\tyPC\u0002\u0003\u0002\u0011\fq!\\3tg\u0006<W-\u0003\u0003\u0003\u0006\u0005}(\u0001\b'jgR$&/\u00198tC\u000e$\u0018n\u001c8t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\b\u0005\u0013Q\u0002\u0019\u0001B\u0006\u0003M1\u0017\u000e\u001c;fe\u0016$\u0007K]8ek\u000e,'/\u00133t!\u0019\tIH!\u0004\u0003\u0012%!!qBAC\u0005\r\u0019V\r\u001e\t\u0004q\tM\u0011b\u0001B\u000bs\t!Aj\u001c8h\u0011\u001d\u0011IB\u0007a\u0001\u00057\taBZ5mi\u0016\u0014X\rZ*uCR,7\u000f\u0005\u0004\u0002z\t5\u0011qO\u0001\u001bQ\u0006tG\r\\3EKN\u001c'/\u001b2f)J\fgn]1di&|gn\u001d\u000b\u0005\u0005C\u0011y\u0003\u0005\u0003\u0003$\t%b\u0002BA\u007f\u0005KIAAa\n\u0002\u0000\u0006\u0001C)Z:de&\u0014W\r\u0016:b]N\f7\r^5p]N\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u0011YC!\f\u0003!Q\u0013\u0018M\\:bGRLwN\\*uCR,'\u0002\u0002B\u0014\u0003\u007fDq!!\u001e\u001c\u0001\u0004\t9(\u0001\u0011iC:$G.Z!eIB\u000b'\u000f^5uS>t7\u000fV8Ue\u0006t7/Y2uS>tGCDA\u0001\u0005k\u00119Da\u000f\u0003F\tm#q\f\u0005\b\u0003kb\u0002\u0019AA<\u0011\u001d\u0011I\u0004\ba\u0001\u0005#\t!\u0002\u001d:pIV\u001cWM]%e\u0011\u001d\u0011i\u0004\ba\u0001\u0005\u007f\tQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007c\u0001\u001d\u0003B%\u0019!1I\u001d\u0003\u000bMCwN\u001d;\t\u000f\t\u001dC\u00041\u0001\u0003J\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\r\t-#\u0011\u000bB*\u001b\t\u0011iEC\u0002\u0003Pe\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yA!\u0014\u0011\t\tU#qK\u0007\u0002I&\u0019!\u0011\f3\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u00111\u0015\u000fA\u0002\tu\u0003cAAT!!I\u00111\u0016\u000f\u0011\u0002\u0003\u0007\u0011QV\u0001+Q\u0006tG\r\\3BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p)J\fgn]1di&|g\u000e\n3fM\u0006,H\u000e\u001e\u00137\u0003)yg.\u00127fGRLwN\u001c\u000b\u0007\u0003\u0003\u00119Ga\u001b\t\u000f\t%d\u00041\u0001\u0002\f\u0006\u0019B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8JI\"9\u0011\u0011\u001e\u0010A\u0002\u0005-\u0015!D8o%\u0016\u001c\u0018n\u001a8bi&|g\u000e\u0006\u0004\u0002\u0002\tE$1\u000f\u0005\b\u0005Sz\u0002\u0019AAF\u0011\u001d\tIo\ba\u0001\u0005k\u0002R\u0001OAL\u0003\u0017\u000bq\u0005\\8h\u0013:4\u0018\r\\5e'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]\u0006sGMU3ukJtWI\u001d:peRA!1\u0010BC\u0005\u000f\u0013y\t\u0005\u0005\u0003~\t\u0005\u00151BA \u001b\t\u0011yHC\u0002\u0002^eJAAa!\u0003\u0000\t!A*\u001a4u\u0011\u001d\t)\b\ta\u0001\u0003oBqA!#!\u0001\u0004\u0011Y)\u0001\tue\u0006t7/Y2uS>t7\u000b^1uKB\u0019AG!$\n\u0007\t-B\u0006C\u0004\u0003\u0012\u0002\u0002\rAa%\u0002#Q\u0014\u0018M\\:bGRLwN\u001c*fgVdG\u000f\u0005\u0003\u0003\u0016\nmUB\u0001BL\u0015\r\u0011I\nZ\u0001\te\u0016\fX/Z:ug&!!Q\u0014BL\u0005E!&/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e^\u0001\u0015Q\u0006tG\r\\3F]\u0012$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u001d\u0005\u0005!1\u0015BS\u0005O\u0013IK!,\u00032\"9\u0011QO\u0011A\u0002\u0005]\u0004b\u0002B\u001dC\u0001\u0007!\u0011\u0003\u0005\b\u0005{\t\u0003\u0019\u0001B \u0011\u001d\u0011Y+\ta\u0001\u0005'\u000bq\u0002\u001e=o\u001b\u0006\u00148.\u001a:SKN,H\u000e\u001e\u0005\b\u0003G\u000b\u0003\u0019\u0001BX!\r\t9+\u0005\u0005\n\u0003W\u000b\u0003\u0013!a\u0001\u0003[\u000ba\u0004[1oI2,WI\u001c3Ue\u0006t7/Y2uS>tG\u0005Z3gCVdG\u000f\n\u001c\u0002\u001d\u0015tG\r\u0016:b]N\f7\r^5p]R\u0001\u0012\u0011\u0001B]\u0005w\u0013iLa0\u0003B\n-'Q\u001a\u0005\b\u0003k\u001a\u0003\u0019AA<\u0011\u001d\u0011Id\ta\u0001\u0005#AqA!\u0010$\u0001\u0004\u0011y\u0004C\u0004\u0003,\u000e\u0002\rAa%\t\u000f\t\r7\u00051\u0001\u0003F\u0006a\u0011n\u001d$s_6\u001cE.[3oiB\u0019\u0001Ha2\n\u0007\t%\u0017HA\u0004C_>dW-\u00198\t\u000f\u0005\r6\u00051\u0001\u00030\"9\u00111V\u0012A\u0002\u00055\u0016a\u0006;sC:\u001c\u0018m\u0019;j_:$v\u000e]5d\u0007>tg-[4t+\t\u0011\u0019\u000e\u0005\u0003\u0003V\n]WBAA.\u0013\u0011\u0011I.a\u0017\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0007qCJ$\u0018\u000e^5p]\u001a{'\u000f\u0006\u0003\u0002\f\n}\u0007bBA;K\u0001\u0007\u0011qO\u0001\u0019_:,e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\u001cu.\u001c9mKR,G\u0003\u0002Bs\u0005W$B!!\u0001\u0003h\"9!\u0011\u001e\u0014A\u0002\u0005-\u0011!B3se>\u0014\bb\u0002BwM\u0001\u0007!q^\u0001\u0011ibt\u0017\nZ!oIBKG-\u00129pG\"\u00042\u0001\u000eBy\u0013\r\u0011\u0019\u0010\f\u0002\")J\fgn]1di&|g.\u00197JI\u0006sG\r\u0015:pIV\u001cWM]%e\u000bB|7\r[\u0001\u001aC\n|'\u000f\u001e+j[\u0016$w*\u001e;Ue\u0006t7/Y2uS>t7\u000f\u0006\u0003\u0002\u0002\te\bb\u0002B~O\u0001\u0007!Q`\u0001\u000b_:\u001cu.\u001c9mKR,\u0007C\u0002\u001d|\u0005_\u0014y+A\u0004ti\u0006\u0014H/\u001e9\u0015\r\u0005\u000511AB\u0005\u0011\u001d\u0019)\u0001\u000ba\u0001\u0007\u000f\taE]3ue&,g/\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u!\u0011A4+a#\t\u0013\r-\u0001\u0006%AA\u0002\t\u0015\u0017aH3oC\ndW\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]\u0006\t2\u000f^1siV\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\rE!\u0006\u0002Bc\u0003\u007f\u000b\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003\u0003Aqa!\u0007\u0004\u0001\u0004\u0019Y\"\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003_\u001bi\"\u0003\u0003\u0004 \u0005E&aC&bM.\f7i\u001c8gS\u001eDqaa\t\u0004\u0001\u0004\u0019)#\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\t\u0005=6qE\u0005\u0005\u0007S\t\tL\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000b5\u001b\u0001\u0019\u0001(\t\r\r=2\u00011\u0001S\u0003e\u0019'/Z1uKB\u0013x\u000eZ;dKJLEmR3oKJ\fGo\u001c:\t\u000f\rM2\u00011\u0001\u00046\u00059Q.\u001a;sS\u000e\u001c\b\u0003BB\u001c\u0007wi!a!\u000f\u000b\u0007\rMB-\u0003\u0003\u0004>\re\"aB'fiJL7m\u001d\u0005\b\u0007\u0003\u001a\u0001\u0019AB\"\u00035iW\r^1eCR\f7)Y2iKB!\u0011qVB#\u0013\u0011\u00199%!-\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011\u0015\u00017\u00011\u0001b\u0003QIg.\u001b;Ue\u0006t7/Y2uS>tWI\u001d:peR\u0019Qpa\u0014\t\u000f\t%H\u00011\u0001\u0002\f\u00059\u0012N\\5u)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u000b\u0004{\u000eU\u0003bBAw\u000b\u0001\u0007\u0011Q\u001c")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private final ProducerIdManager producerIdManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, Function0<ProducerIdManager> function0, Metrics metrics, MetadataCache metadataCache, Time time) {
        if (TransactionCoordinator$.MODULE$ == null) {
            throw null;
        }
        TransactionConfig apply_txnConfig = new TransactionConfig(Predef$.MODULE$.Integer2int(kafkaConfig.transactionalIdExpirationMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionMaxTimeoutMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicPartitions()), Predef$.MODULE$.Short2short(kafkaConfig.transactionTopicReplicationFactor()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicSegmentBytes()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionsLoadBufferSize()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionTopicMinISR()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionAbortTimedOutTransactionCleanupIntervalMs()), Predef$.MODULE$.Integer2int(kafkaConfig.transactionRemoveExpiredTransactionalIdCleanupIntervalMs()), Predef$.MODULE$.Integer2int(kafkaConfig.requestTimeoutMs()));
        TransactionStateManager apply_txnStateManager = new TransactionStateManager(kafkaConfig.brokerId(), scheduler, replicaManager, apply_txnConfig, time, metrics);
        LogContext apply_logContext = new LogContext(new StringBuilder(29).append("[TransactionCoordinator id=").append(kafkaConfig.brokerId()).append("] ").toString());
        TransactionMarkerChannelManager apply_txnMarkerChannelManager = TransactionMarkerChannelManager$.MODULE$.apply(kafkaConfig, metrics, metadataCache, apply_txnStateManager, time, apply_logContext);
        return new TransactionCoordinator(apply_txnConfig, scheduler, function0, apply_txnStateManager, apply_txnMarkerChannelManager, time, apply_logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public ProducerIdManager producerIdManager() {
        return this.producerIdManager;
    }

    /*
     * WARNING - void declaration
     */
    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch, Function1<InitProducerIdResult, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        if (transactionalId == null) {
            long producerId = this.producerIdManager().generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
            return;
        }
        if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
            return;
        }
        if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Either<Errors, CoordinatorEpochAndTxnMetadata> either;
            if (None$.MODULE$.equals(x0$1)) {
                long producerId = this.producerIdManager().generateProducerId();
                long x$3 = -1L;
                short x$4 = -1;
                short x$5 = -1;
                Empty$ x$7 = Empty$.MODULE$;
                scala.collection.mutable.Set x$8 = Set$.MODULE$.empty();
                long x$9 = $this.time.milliseconds();
                long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
                TransactionMetadata createdMetadata = new TransactionMetadata(transactionalId, producerId, x$3, x$4, x$5, transactionTimeoutMs, x$7, (scala.collection.mutable.Set<TopicPartition>)x$8, x$10, x$9);
                either = $this.txnManager.putTransactionStateIfNotExists(createdMetadata);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
            } else {
                throw new MatchError(x0$1);
            }
            return either;
        }).flatMap((Function1 & Serializable & scala.Serializable)existingEpochAndMetadata -> {
            int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
            TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
            return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> this.prepareInitProducerIdTransit(transactionalId, transactionTimeoutMs, coordinatorEpoch, txnMetadata, expectedProducerIdAndEpoch));
        });
        if (result instanceof Left) {
            Errors error2 = (Errors)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            TransactionState transactionState = newMetadata.txnState();
            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
            if (!(transactionState != null ? !transactionState.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                Tuple2 tuple22;
                void endTransaction_txnMarkerResult;
                void endTransaction_producerEpoch;
                void endTransaction_isFromClient;
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)error -> {
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                    } else {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    }
                    return BoxedUnit.UNIT;
                };
                boolean bl = false;
                TransactionResult transactionResult = TransactionResult.ABORT;
                short s = newMetadata.producerEpoch();
                long endTransaction_producerId = newMetadata.producerId();
                BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
                if (transactionalId.isEmpty()) {
                    Errors errors;
                    Errors errors2 = errors = Errors.INVALID_REQUEST;
                    Errors errors3 = Errors.NONE;
                    if (errors2 == null ? errors3 != null : !errors2.equals(errors3)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap(arg_0 -> TransactionCoordinator.$anonfun$endTransaction$1(this, endTransaction_producerId, (boolean)endTransaction_isFromClient, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, endTransaction_isEpochFence, transactionalId, arg_0));
                if (endTransaction_preAppendResult instanceof Left) {
                    Errors errors;
                    Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
                    this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TransactionCoordinator.$anonfun$endTransaction$4((TransactionResult)endTransaction_txnMarkerResult, endTransaction_err, transactionalId)));
                    Errors errors4 = errors = endTransaction_err;
                    Errors errors5 = Errors.NONE;
                    if (errors4 == null ? errors5 != null : !errors4.equals(errors5)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(errors));
                        return;
                    }
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    return;
                }
                if (endTransaction_preAppendResult instanceof Right && (tuple22 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
                    void endTransaction_responseCallback;
                    int endTransaction_coordinatorEpoch = tuple22._1$mcI$sp();
                    TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple22._2();
                    Function1 & Serializable & scala.Serializable endTransaction_x$4 = arg_0 -> TransactionCoordinator.$anonfun$endTransaction$15$adapted(this, transactionalId, endTransaction_coordinatorEpoch, endTransaction_producerId, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, (Function1)endTransaction_responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence, arg_0);
                    Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
                    this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, requestLocal);
                    return;
                }
                throw new MatchError((Object)endTransaction_preAppendResult);
            }
            Function1 & Serializable & scala.Serializable x$14 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata));
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$16 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$14, x$16, requestLocal);
            return;
        }
        throw new MatchError((Object)result);
    }

    public RequestLocal handleInitProducerId$default$5() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProducerIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch) {
        Left left;
        if (txnMetadata.pendingTransitionInProgress()) {
            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        if (!expectedProducerIdAndEpoch.forall((Function1 & Serializable & scala.Serializable)producerIdAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch, txnMetadata)))) {
            return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
        }
        TransactionState transactionState = txnMetadata.state();
        boolean bl = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
        if (bl) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
            if (bl2) {
                Left left2;
                Right transitMetadataResult;
                Right right;
                if (txnMetadata.isProducerEpochExhausted() && expectedProducerIdAndEpoch.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata, x$1)))) {
                    long newProducerId = this.producerIdManager().generateProducerId();
                    right = package$.MODULE$.Right().apply((Object)txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds(), expectedProducerIdAndEpoch.isDefined()));
                } else {
                    right = transitMetadataResult = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, (Option<Object>)expectedProducerIdAndEpoch.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToShort((short)x$2.epoch)), this.time.milliseconds());
                }
                if (transitMetadataResult instanceof Right) {
                    TxnTransitMetadata transitMetadata = (TxnTransitMetadata)((Right)transitMetadataResult).value();
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
                } else if (transitMetadataResult instanceof Left) {
                    Errors err = (Errors)((Left)transitMetadataResult).value();
                    left2 = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError(transitMetadataResult);
                }
                left = left2;
            } else if (Ongoing$.MODULE$.equals(transactionState)) {
                left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
            } else {
                boolean bl3 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                if (bl3) {
                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                throw new MatchError((Object)transactionState);
            }
        }
        return left;
    }

    public ListTransactionsResponseData handleListTransactions(scala.collection.immutable.Set<Object> filteredProducerIds, scala.collection.immutable.Set<String> filteredStates) {
        if (!this.isActive().get()) {
            return new ListTransactionsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        return this.txnManager.listTransactionStates(filteredProducerIds, filteredStates);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DescribeTransactionsResponseData.TransactionState handleDescribeTransactions(String transactionalId) {
        if (transactionalId == null) {
            throw new IllegalArgumentException("Invalid null transactionalId");
        }
        DescribeTransactionsResponseData.TransactionState transactionState = new DescribeTransactionsResponseData.TransactionState().setTransactionalId(transactionalId);
        if (!this.isActive().get()) {
            return transactionState.setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        if (transactionalId.isEmpty()) {
            return transactionState.setErrorCode(Errors.INVALID_REQUEST.code());
        }
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            Errors error = (Errors)((Left)either).value();
            return transactionState.setErrorCode(error.code());
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (None$.MODULE$.equals(option)) {
                return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
            }
        }
        if (!bl) throw new MatchError(either);
        Option option = (Option)right.value();
        if (!(option instanceof Some)) throw new MatchError(either);
        TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
        return (DescribeTransactionsResponseData.TransactionState)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
            TransactionState transactionState = txnMetadata.state();
            Dead$ dead$ = Dead$.MODULE$;
            if (!(transactionState != null ? !transactionState.equals(dead$) : dead$ != null)) {
                return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
            }
            txnMetadata.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$handleDescribeTransactions$2(transactionState, topicPartition)));
            return transactionState.setErrorCode(Errors.NONE.code()).setProducerId(txnMetadata.producerId()).setProducerEpoch(txnMetadata.producerEpoch()).setTransactionState(txnMetadata.state().name()).setTransactionTimeoutMs(txnMetadata.txnTimeoutMs()).setTransactionStartTimeMs(txnMetadata.txnStartTimestamp());
        });
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    block8: {
                        block7: {
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                            if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block7;
                            TransactionState transactionState2 = txnMetadata.state();
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block8;
                        }
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    Ongoing$ ongoing$ = Ongoing$.MODULE$;
                    if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null) && partitions.subsetOf(txnMetadata.topicPartitions())) {
                        return package$.MODULE$.Left().apply((Object)Errors.NONE);
                    }
                    return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions.toSet(), $this.time.milliseconds())));
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (result instanceof Left) {
            Errors err = (Errors)((Left)result).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)result);
    }

    public RequestLocal handleAddPartitionsToTransaction$default$6() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    public void onElection(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Elected as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch2).toString());
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void onResignation(int txnTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Resigned as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        if (coordinatorEpoch instanceof Some) {
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)coordinatorEpoch).value());
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, epoch);
        } else if (None$.MODULE$.equals(coordinatorEpoch)) {
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId);
        } else {
            throw new MatchError(coordinatorEpoch);
        }
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("TransactionalId: ").append(transactionalId).append("'s state is ").append(transactionState).append(", but received transaction ").append("marker result to send: ").append(transactionResult).toString());
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        boolean endTransaction_isFromClient = true;
        BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Right right;
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (Empty$.MODULE$.equals(transactionState)) {
                        right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else {
                        boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl) {
                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return right;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (endTransaction_preAppendResult instanceof Left) {
            Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)endTransaction_err);
            return;
        }
        if (endTransaction_preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
            int endTransaction_coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable & scala.Serializable endTransaction_x$4 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Left left;
                        if (None$.MODULE$.equals(x0$1)) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        if (x0$1 instanceof Some) {
                            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                            if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                                    Left<Errors, Nothing$> left;
                                    if (txnMetadata.producerId() != producerId) {
                                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    }
                                    if (txnMetadata.producerEpoch() != producerEpoch) {
                                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                                    }
                                    if (txnMetadata.pendingTransitionInProgress()) {
                                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    }
                                    TransactionState transactionState = txnMetadata.state();
                                    boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                    if (bl) {
                                        left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                        left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                                        left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else {
                                        boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                        if (bl2) {
                                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                            throw new IllegalStateException(errorMsg);
                                        }
                                        throw new MatchError((Object)transactionState);
                                    }
                                    return left;
                                });
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                            }
                        } else {
                            throw new MatchError(x0$1);
                        }
                        Left left2 = left;
                        return left2;
                    });
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Right) || (tuple2 = (Tuple2)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value()) == null) throw new MatchError((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        $this.txnManager.getTransactionState(transactionalId).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)endTransaction_preAppendResult);
    }

    public RequestLocal handleEndTransaction$default$6() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    private void endTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, boolean isFromClient, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        BooleanRef isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Right right;
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (Empty$.MODULE$.equals(transactionState)) {
                        right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else {
                        boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl) {
                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return right;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (preAppendResult instanceof Left) {
            Errors err = (Errors)((Left)preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)preAppendResult).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either $anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Left left;
                        if (None$.MODULE$.equals(x0$1)) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        if (x0$1 instanceof Some) {
                            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                            if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                                    Left<Errors, Nothing$> left;
                                    if (txnMetadata.producerId() != producerId) {
                                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    }
                                    if (txnMetadata.producerEpoch() != producerEpoch) {
                                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                                    }
                                    if (txnMetadata.pendingTransitionInProgress()) {
                                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    }
                                    TransactionState transactionState = txnMetadata.state();
                                    boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                    if (bl) {
                                        left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                        left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                        TransactionResult transactionResult = txnMarkerResult;
                                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                                        left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                    } else {
                                        boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                        if (bl2) {
                                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                            throw new IllegalStateException(errorMsg);
                                        }
                                        throw new MatchError((Object)transactionState);
                                    }
                                    return left;
                                });
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                            }
                        } else {
                            throw new MatchError(x0$1);
                        }
                        Left left2 = left;
                        return left2;
                    });
                    if ($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                        Errors $anonfun$endTransaction$15_sendTxnMarkersCallback$1_err = (Errors)((Left)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!($anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult instanceof Right) || (tuple2 = (Tuple2)((Right)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult).value()) == null) throw new MatchError((Object)$anonfun$endTransaction$15_sendTxnMarkersCallback$1_preSendResult);
                        TransactionMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(endTransaction_coordinatorEpoch, txnMarkerResult, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_txnMetadata, $anonfun$endTransaction$15_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
                    if (isEpochFence$1.elem) {
                        $this.txnManager.getTransactionState(transactionalId).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$4, x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)preAppendResult);
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void onEndTransactionComplete(TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch, Errors error) {
        if (Errors.NONE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Completed rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" due to timeout").toString());
            return;
        }
        boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(error) ? true : (Errors.PRODUCER_FENCED.equals(error) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(error));
        if (bl) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("has been cancelled due to error ").append(error).toString());
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("failed due to error ").append(error).toString());
    }

    public void abortTimedOutTransactions(Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>> onComplete) {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> {
            $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (None$.MODULE$.equals(x0$1)) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
                } else if (x0$1 instanceof Some) {
                    TransactionMetadata $anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                    ((Option)$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                            return None$.MODULE$;
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                            return None$.MODULE$;
                        }
                        return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                    })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                        this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), RequestLocal$.MODULE$.NoCaching());
                        return BoxedUnit.UNIT;
                    });
                } else {
                    throw new MatchError(x0$1);
                }
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.abortTimedOutTransactions((Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>>)(Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> (Function1 & Serializable & scala.Serializable)error -> {
            this.onEndTransactionComplete(txnIdAndPidEpoch, error);
            return BoxedUnit.UNIT;
        }), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.scheduler.schedule$default$5());
        this.txnManager.startup(retrieveTransactionTopicPartitionCount, enableTransactionalIdExpiration);
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$2() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager().shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$4(Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$7(TransactionCoordinator $this, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    private static final boolean isValidProducerId$1(ProducerIdAndEpoch producerIdAndEpoch, TransactionMetadata txnMetadata$2) {
        return txnMetadata$2.producerEpoch() == -1 || producerIdAndEpoch.producerId == txnMetadata$2.producerId() || producerIdAndEpoch.producerId == txnMetadata$2.lastProducerId() && TransactionMetadata$.MODULE$.isEpochExhausted(producerIdAndEpoch.epoch);
    }

    public static final /* synthetic */ boolean $anonfun$prepareInitProducerIdTransit$2(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$1) {
        return x$1.epoch == txnMetadata$2.producerEpoch();
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeTransactions$2(DescribeTransactionsResponseData.TransactionState transactionState$1, TopicPartition topicPartition) {
        DescribeTransactionsResponseData.TopicData topicData = transactionState$1.topics().find(topicPartition.topic());
        if (topicData == null) {
            topicData = new DescribeTransactionsResponseData.TopicData().setTopic(topicPartition.topic());
            transactionState$1.topics().add((ImplicitLinkedHashCollection.Element)topicData);
        }
        return topicData.partitions().add(Predef$.MODULE$.int2Integer(topicPartition.partition()));
    }

    public static final /* synthetic */ void $anonfun$endTransaction$12(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$6, Errors error$2, TxnTransitMetadata newMetadata$2, Option x0$2) {
        if (None$.MODULE$.equals(x0$2)) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId$4).append(", but there is ").append("no metadata in the cache; this is not expected").toString());
            return;
        }
        if (x0$2 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$2).value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$6) {
                epochAndMetadata.transactionMetadata().hasFailedEpochFence_$eq(true);
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(166).append("The coordinator failed to write an epoch fence transition for producer ").append(transactionalId$4).append(" to the transaction log ").append("with error ").append(error$2).append(". The epoch was increased to ").append(newMetadata$2.producerEpoch()).append(" but not returned to the client").toString());
                return;
            }
        } else {
            throw new MatchError((Object)x0$2);
        }
    }

    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$4, int coordinatorEpoch$6, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$4).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Left left;
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                            if (bl) {
                                left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else {
                                boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                if (bl2) {
                                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                    throw new IllegalStateException(errorMsg);
                                }
                                throw new MatchError((Object)transactionState);
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError(x0$1);
                }
                Left left2 = left;
                return left2;
            });
            if (preSendResult instanceof Left) {
                Errors err = (Errors)((Left)preSendResult).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            }
            if (preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)preSendResult).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)preSendResult);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            this.txnManager.getTransactionState(transactionalId$4).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$endTransaction$15(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$6, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either sendTxnMarkersCallback$1_preSendResult = $this.txnManager.getTransactionState(transactionalId$4).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Left left;
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == endTransaction_coordinatorEpoch) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                            if (bl) {
                                left = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else {
                                boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                if (bl2) {
                                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                    throw new IllegalStateException(errorMsg);
                                }
                                throw new MatchError((Object)transactionState);
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult).append(" was ").append("successfully appended to the log for ").append(transactionalId).append(" with old epoch ").append(endTransaction_coordinatorEpoch).toString());
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError(x0$1);
                }
                Left left2 = left;
                return left2;
            });
            if (sendTxnMarkersCallback$1_preSendResult instanceof Left) {
                Errors sendTxnMarkersCallback$1_err = (Errors)((Left)sendTxnMarkersCallback$1_preSendResult).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)sendTxnMarkersCallback$1_err);
                return;
            }
            if (sendTxnMarkersCallback$1_preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)sendTxnMarkersCallback$1_preSendResult).value()) != null) {
                TransactionMetadata sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                $this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, sendTxnMarkersCallback$1_txnMetadata, sendTxnMarkersCallback$1_newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)sendTxnMarkersCallback$1_preSendResult);
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(endTransaction_newMetadata).append(" to transaction log with coordinator epoch ").append(endTransaction_coordinatorEpoch).append(" failed").toString());
        if (isEpochFence$1.elem) {
            $this.txnManager.getTransactionState(transactionalId$4).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId, endTransaction_coordinatorEpoch, error, endTransaction_newMetadata, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$7(TransactionCoordinator $this, TransactionMetadata txnMetadata$7, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, TxnTransitMetadata txnTransitMetadata) {
        $this.endTransaction(txnMetadata$7.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete$1.apply((Object)txnIdAndPidEpoch$2)), RequestLocal$.MODULE$.NoCaching());
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$2(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Function1 onComplete$1, Option x0$1) {
        if (None$.MODULE$.equals(x0$1)) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
            return;
        }
        if (x0$1 instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
            ((Option)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                    return None$.MODULE$;
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                    return None$.MODULE$;
                }
                return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
            })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), RequestLocal$.MODULE$.NoCaching());
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$1(TransactionCoordinator $this, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch) {
        $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch).toString());
            } else if (x0$1 instanceof Some) {
                TransactionMetadata $anonfun$abortTimedOutTransactions$2_txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                ((Option)$anonfun$abortTimedOutTransactions$2_txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadata.producerId() != txnIdAndPidEpoch.producerId()) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                        return None$.MODULE$;
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch).append(" since there is a ").append("pending state transition").toString());
                        return None$.MODULE$;
                    }
                    return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                })).foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                    this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete.apply(txnIdAndPidEpoch)), RequestLocal$.MODULE$.NoCaching());
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return BoxedUnit.UNIT;
        });
    }

    public TransactionCoordinator(TransactionConfig txnConfig, Scheduler scheduler, Function0<ProducerIdManager> createProducerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
        this.producerIdManager = (ProducerIdManager)createProducerIdManager.apply();
    }
}

