/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import kafka.log.TxnMetadata;
import kafka.log.UnifiedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\rw!B3g\u0011\u0003Yg!B7g\u0011\u0003q\u0007\"B;\u0002\t\u00031\bbB<\u0002\u0005\u0004%I\u0001\u001f\u0005\u0007y\u0006\u0001\u000b\u0011B=\t\u000fu\f!\u0019!C\u0005}\"9\u0011qB\u0001!\u0002\u0013y\b\u0002CA\t\u0003\t\u0007I\u0011\u0002@\t\u000f\u0005M\u0011\u0001)A\u0005\u007f\"A\u0011QC\u0001C\u0002\u0013%a\u0010C\u0004\u0002\u0018\u0005\u0001\u000b\u0011B@\t\u0011\u0005e\u0011A1A\u0005\nyDq!a\u0007\u0002A\u0003%q\u0010\u0003\u0005\u0002\u001e\u0005\u0011\r\u0011\"\u0003\u007f\u0011\u001d\ty\"\u0001Q\u0001\n}D\u0001\"!\t\u0002\u0005\u0004%IA \u0005\b\u0003G\t\u0001\u0015!\u0003\u0000\u0011!\t)#\u0001b\u0001\n\u0013q\bbBA\u0014\u0003\u0001\u0006Ia \u0005\t\u0003S\t!\u0019!C\u0005}\"9\u00111F\u0001!\u0002\u0013y\b\u0002CA\u0017\u0003\t\u0007I\u0011\u0002@\t\u000f\u0005=\u0012\u0001)A\u0005\u007f\"A\u0011\u0011G\u0001C\u0002\u0013%a\u0010C\u0004\u00024\u0005\u0001\u000b\u0011B@\t\u0011\u0005U\u0012A1A\u0005\nyDq!a\u000e\u0002A\u0003%q\u0010C\u0005\u0002:\u0005\u0011\r\u0011\"\u0003\u0002<!A\u00111I\u0001!\u0002\u0013\ti\u0004C\u0005\u0002F\u0005\u0011\r\u0011\"\u0003\u0002<!A\u0011qI\u0001!\u0002\u0013\ti\u0004C\u0005\u0002J\u0005\u0011\r\u0011\"\u0003\u0002<!A\u00111J\u0001!\u0002\u0013\ti\u0004C\u0005\u0002N\u0005\u0011\r\u0011\"\u0001\u0002P!A\u0011qN\u0001!\u0002\u0013\t\t\u0006C\u0005\u0002r\u0005\u0011\r\u0011\"\u0001\u0002P!A\u00111O\u0001!\u0002\u0013\t\t\u0006C\u0004\u0002v\u0005!\t!a\u001e\t\u000f\u0005\u001d\u0016\u0001\"\u0003\u0002*\"9\u0011QZ\u0001\u0005\n\u0005=\u0007\u0002CAm\u0003\u0011\u0005a-a7\t\u0013\u00055\u0018!%A\u0005\u0002\u0005=\b\"\u0003B\u0003\u0003E\u0005I\u0011\u0001B\u0004\r\u0015ig\r\u0001B\f\u0011)\u0011\u0019c\u000bBC\u0002\u0013\u0005!Q\u0005\u0005\u000b\u0005_Y#\u0011!Q\u0001\n\t\u001d\u0002B\u0003B\u0019W\t\u0005\r\u0011\"\u0001\u00034!Q!QG\u0016\u0003\u0002\u0004%\tAa\u000e\t\u0015\tu2F!A!B\u0013\tY\n\u0003\u0006\u0003H-\u0012)\u0019!C\u0001\u0003wA!B!\u0013,\u0005\u0003\u0005\u000b\u0011BA\u001f\u0011)\u0011Ye\u000bBC\u0002\u0013\u0005!Q\n\u0005\u000b\u0005\u001fZ#\u0011!Q\u0001\n\t-\u0001BB;,\t\u0003\u0011\t\u0006C\u0005\u0003^-\u0002\r\u0011\"\u0003\u0003`!I!QO\u0016A\u0002\u0013%!q\u000f\u0005\t\u0005wZ\u0003\u0015)\u0003\u0003b!I!QP\u0016C\u0002\u0013%!q\u0010\u0005\t\u0005\u0003[\u0003\u0015!\u0003\u00028\"I!1Q\u0016A\u0002\u0013%!Q\u0011\u0005\n\u0005\u000f[\u0003\u0019!C\u0005\u0005\u0013C\u0001B!$,A\u0003&\u0011q\u0019\u0005\n\u0005\u001f[\u0003\u0019!C\u0005\u0005\u000bC\u0011B!%,\u0001\u0004%IAa%\t\u0011\t]5\u0006)Q\u0005\u0003\u000fD\u0011B!',\u0005\u0004%IAa'\t\u0011\t-6\u0006)A\u0005\u0005;C\u0011B!,,\u0005\u0004%IAa'\t\u0011\t=6\u0006)A\u0005\u0005;CqA!-,\t\u0013\u0011\u0019\f\u0003\u0005\u00036.\"\tA\u001aB\\\u0011\u001d\u0011yl\u000bC\u0001\u0005\u0003DqA!6,\t\u0003\u00119\u000e\u0003\u0005\u0003^.\"\tA\u001aBp\u0011\u001d\u0011\u0019o\u000bC\u0001\u0005\u000bCqA!:,\t\u0003\u00119\u000fC\u0004\u0003t.\"\tA!>\t\u000f\t]8\u0006\"\u0003\u0003z\"A11A\u0016\u0005\u0002\u0019\u001c)\u0001C\u0004\u0004\f-\"Ia!\u0004\t\u000f\r]1\u0006\"\u0001\u0004\u001a!91QD\u0016\u0005\u0002\r}\u0001bBB\u0015W\u0011\u000511\u0006\u0005\b\u0007\u0003ZC\u0011AB\"\u0011\u001d\u0019Ie\u000bC\u0001\u0007\u0017Bqa!\u0015,\t\u0003\u0019\u0019\u0006C\u0004\u0004Z-\"\taa\u0017\t\u000f\ru3\u0006\"\u0001\u0004`!91QM\u0016\u0005\u0002\t}\u0007bBB4W\u0011\u0005!q\u001c\u0005\t\u0007SZC\u0011\u00014\u0004l!911O\u0016\u0005\u0002\rU\u0004bBB=W\u0011%11\u0010\u0005\b\u0007\u007fZC\u0011ABA\u0011\u001d\u0019)i\u000bC\u0001\u0007\u000fCqaa%,\t\u0003\u0019)\nC\u0004\u0004\u001a.\"\taa'\t\u000f\r\u001d6\u0006\"\u0003\u0004*\"911V\u0016\u0005\n\r%\u0006bBBWW\u0011%1q\u0016\u0005\t\u0007k[C\u0011\u00014\u00048\u0006!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJT!a\u001a5\u0002\u00071|wMC\u0001j\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001\\\u0001\u000e\u0003\u0019\u0014A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148CA\u0001p!\t\u00018/D\u0001r\u0015\u0005\u0011\u0018!B:dC2\f\u0017B\u0001;r\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a[\u0001\u0018!J|G-^2feNs\u0017\r]:i_R4VM]:j_:,\u0012!\u001f\t\u0003ajL!a_9\u0003\u000bMCwN\u001d;\u00021A\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$h+\u001a:tS>t\u0007%\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-F\u0001\u0000!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\tA\u0001\\1oO*\u0011\u0011\u0011B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u000e\u0005\r!AB*ue&tw-A\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG\rI\u0001\t\u0007J\u001cg)[3mI\u0006I1I]2GS\u0016dG\rI\u0001\u0010!J|G-^2fe&#g)[3mI\u0006\u0001\u0002K]8ek\u000e,'/\u00133GS\u0016dG\rI\u0001\u0012\u0019\u0006\u001cHoU3rk\u0016t7-\u001a$jK2$\u0017A\u0005'bgR\u001cV-];f]\u000e,g)[3mI\u0002\n!\u0003\u0015:pIV\u001cWM]#q_\u000eDg)[3mI\u0006\u0019\u0002K]8ek\u000e,'/\u00129pG\"4\u0015.\u001a7eA\u0005yA*Y:u\u001f\u001a47/\u001a;GS\u0016dG-\u0001\tMCN$xJ\u001a4tKR4\u0015.\u001a7eA\u0005\u0001rJ\u001a4tKR$U\r\u001c;b\r&,G\u000eZ\u0001\u0012\u001f\u001a47/\u001a;EK2$\u0018MR5fY\u0012\u0004\u0013A\u0004+j[\u0016\u001cH/Y7q\r&,G\u000eZ\u0001\u0010)&lWm\u001d;b[B4\u0015.\u001a7eA\u0005!\u0002K]8ek\u000e,'/\u00128ue&,7OR5fY\u0012\fQ\u0003\u0015:pIV\u001cWM]#oiJLWm\u001d$jK2$\u0007%A\u000bD_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u001aKW\r\u001c3\u0002-\r{wN\u001d3j]\u0006$xN]#q_\u000eDg)[3mI\u0002\n!dQ;se\u0016tG\u000f\u0016=o\r&\u00148\u000f^(gMN,GOR5fY\u0012\f1dQ;se\u0016tG\u000f\u0016=o\r&\u00148\u000f^(gMN,GOR5fY\u0012\u0004\u0013!\u0004,feNLwN\\(gMN,G/\u0006\u0002\u0002>A\u0019\u0001/a\u0010\n\u0007\u0005\u0005\u0013OA\u0002J]R\faBV3sg&|gn\u00144gg\u0016$\b%A\u0005De\u000e|eMZ:fi\u0006Q1I]2PM\u001a\u001cX\r\u001e\u0011\u0002+A\u0013x\u000eZ;dKJ,e\u000e\u001e:jKN|eMZ:fi\u00061\u0002K]8ek\u000e,'/\u00128ue&,7o\u00144gg\u0016$\b%A\u000eQe>$WoY3s':\f\u0007o\u001d5pi\u0016sGO]=TG\",W.Y\u000b\u0003\u0003#\u0002B!a\u0015\u0002l5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&A\u0003usB,7O\u0003\u0003\u0002\\\u0005u\u0013\u0001\u00039s_R|7m\u001c7\u000b\t\u0005}\u0013\u0011M\u0001\u0007G>lWn\u001c8\u000b\u0007%\f\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014AB1qC\u000eDWM\u0003\u0002\u0002j\u0005\u0019qN]4\n\t\u00055\u0014Q\u000b\u0002\u0007'\u000eDW-\\1\u00029A\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$XI\u001c;ssN\u001b\u0007.Z7bA\u0005!\u0002+\u001b3T]\u0006\u00048\u000f[8u\u001b\u0006\u00048k\u00195f[\u0006\fQ\u0003U5e':\f\u0007o\u001d5pi6\u000b\u0007oU2iK6\f\u0007%\u0001\u0007sK\u0006$7K\\1qg\"|G\u000f\u0006\u0003\u0002z\u0005]\u0005CBA>\u0003\u0017\u000b\tJ\u0004\u0003\u0002~\u0005\u001de\u0002BA@\u0003\u000bk!!!!\u000b\u0007\u0005\r%.\u0001\u0004=e>|GOP\u0005\u0002e&\u0019\u0011\u0011R9\u0002\u000fA\f7m[1hK&!\u0011QRAH\u0005!IE/\u001a:bE2,'bAAEcB\u0019A.a%\n\u0007\u0005UeM\u0001\nQe>$WoY3s'R\fG/Z#oiJL\bbBAMK\u0001\u0007\u00111T\u0001\u0005M&dW\r\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\u0011\t\t+a\u0002\u0002\u0005%|\u0017\u0002BAS\u0003?\u0013AAR5mK\u0006iqO]5uKNs\u0017\r]:i_R$b!a+\u00022\u0006M\u0006c\u00019\u0002.&\u0019\u0011qV9\u0003\tUs\u0017\u000e\u001e\u0005\b\u000333\u0003\u0019AAN\u0011\u001d\t)L\na\u0001\u0003o\u000bq!\u001a8ue&,7\u000f\u0005\u0005\u0002:\u0006\r\u0017qYAI\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0003\f\u0018AC2pY2,7\r^5p]&!\u0011QYA^\u0005\ri\u0015\r\u001d\t\u0004a\u0006%\u0017bAAfc\n!Aj\u001c8h\u00039I7o\u00158baNDw\u000e\u001e$jY\u0016$B!!5\u0002XB\u0019\u0001/a5\n\u0007\u0005U\u0017OA\u0004C_>dW-\u00198\t\u000f\u0005eu\u00051\u0001\u0002\u001c\u0006\tB.[:u':\f\u0007o\u001d5pi\u001aKG.Z:\u0015\t\u0005u\u0017\u0011\u001e\t\u0007\u0003w\ny.a9\n\t\u0005\u0005\u0018q\u0012\u0002\u0004'\u0016\f\bc\u00017\u0002f&\u0019\u0011q\u001d4\u0003\u0019Ms\u0017\r]:i_R4\u0015\u000e\\3\t\u000f\u0005-\b\u00061\u0001\u0002\u001c\u0006\u0019A-\u001b:\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tP\u000b\u0003\u0002>\u0005M8FAA{!\u0011\t9P!\u0001\u000e\u0005\u0005e(\u0002BA~\u0003{\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0018/\u0001\u0006b]:|G/\u0019;j_:LAAa\u0001\u0002z\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011IA\u000b\u0003\u0003\f\u0005M\b\u0003\u0002B\u0007\u0005'i!Aa\u0004\u000b\t\tE\u0011QL\u0001\u0006kRLGn]\u0005\u0005\u0005+\u0011yA\u0001\u0003US6,7\u0003B\u0016p\u00053\u0001BAa\u0007\u0003 5\u0011!Q\u0004\u0006\u0004\u0005#A\u0017\u0002\u0002B\u0011\u0005;\u0011q\u0001T8hO&tw-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\t\u001d\u0002\u0003\u0002B\u0015\u0005Wi!!!\u0018\n\t\t5\u0012Q\f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013aB0m_\u001e$\u0015N]\u000b\u0003\u00037\u000b1b\u00187pO\u0012K'o\u0018\u0013fcR!\u00111\u0016B\u001d\u0011%\u0011YdLA\u0001\u0002\u0004\tY*A\u0002yIE\n\u0001b\u00187pO\u0012K'\u000f\t\u0015\u0004a\t\u0005\u0003c\u00019\u0003D%\u0019!QI9\u0003\u0011Y|G.\u0019;jY\u0016\f\u0011$\\1y!J|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\u0006QR.\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'tA\u0005!A/[7f+\t\u0011Y!A\u0003uS6,\u0007\u0005\u0006\u0006\u0003T\tU#q\u000bB-\u00057\u0002\"\u0001\\\u0016\t\u000f\t\rR\u00071\u0001\u0003(!9!\u0011G\u001bA\u0002\u0005m\u0005\"\u0003B$kA\u0005\t\u0019AA\u001f\u0011%\u0011Y%\u000eI\u0001\u0002\u0004\u0011Y!A\u0005t]\u0006\u00048\u000f[8ugV\u0011!\u0011\r\t\t\u0005G\u0012iG!\u001d\u0002d6\u0011!Q\r\u0006\u0005\u0005O\u0012I'\u0001\u0006d_:\u001cWO\u001d:f]RTAAa\u001b\u0002\b\u0005!Q\u000f^5m\u0013\u0011\u0011yG!\u001a\u0003+\r{gnY;se\u0016tGoU6ja2K7\u000f^'baB!\u0011\u0011\u0001B:\u0013\u0011\tY-a\u0001\u0002\u001bMt\u0017\r]:i_R\u001cx\fJ3r)\u0011\tYK!\u001f\t\u0013\tmr'!AA\u0002\t\u0005\u0014AC:oCB\u001c\bn\u001c;tA\u0005I\u0001O]8ek\u000e,'o]\u000b\u0003\u0003o\u000b!\u0002\u001d:pIV\u001cWM]:!\u00035a\u0017m\u001d;NCB|eMZ:fiV\u0011\u0011qY\u0001\u0012Y\u0006\u001cH/T1q\u001f\u001a47/\u001a;`I\u0015\fH\u0003BAV\u0005\u0017C\u0011Ba\u000f=\u0003\u0003\u0005\r!a2\u0002\u001d1\f7\u000f^'ba>3gm]3uA\u0005qA.Y:u':\f\u0007o\u00144gg\u0016$\u0018A\u00057bgR\u001cf.\u00199PM\u001a\u001cX\r^0%KF$B!a+\u0003\u0016\"I!1H \u0002\u0002\u0003\u0007\u0011qY\u0001\u0010Y\u0006\u001cHo\u00158ba>3gm]3uA\u0005YqN\\4pS:<G\u000b\u001f8t+\t\u0011i\n\u0005\u0005\u0003 \n\u0005\u0016q\u0019BS\u001b\t\u0011I'\u0003\u0003\u0003$\n%$a\u0002+sK\u0016l\u0015\r\u001d\t\u0004Y\n\u001d\u0016b\u0001BUM\nYA\u000b\u001f8NKR\fG-\u0019;b\u00031ygnZ8j]\u001e$\u0006P\\:!\u0003A)hN]3qY&\u001c\u0017\r^3e)bt7/A\tv]J,\u0007\u000f\\5dCR,G\r\u0016=og\u0002\nQ\u0002\\8bINs\u0017\r]:i_R\u001cHC\u0001B1\u0003Q\u0011X-\\8wKN#(/Y=T]\u0006\u00048\u000f[8ugR!\u00111\u0016B]\u0011\u001d\u0011YL\u0012a\u0001\u0005{\u000b!c]3h[\u0016tGOQ1tK>3gm]3ugB1\u00111PAp\u0003\u000f\f1CZ5sgR,fn\u001d;bE2,wJ\u001a4tKR,\"Aa1\u0011\u000bA\u0014)M!3\n\u0007\t\u001d\u0017O\u0001\u0004PaRLwN\u001c\t\u0005\u0005\u0017\u0014\t.\u0004\u0002\u0003N*\u0019!q\u001a5\u0002\rM,'O^3s\u0013\u0011\u0011\u0019N!4\u0003#1{wm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018-\u0001\fp]\"Kw\r[,bi\u0016\u0014X.\u0019:l+B$\u0017\r^3e)\u0011\tYK!7\t\u000f\tm\u0007\n1\u0001\u0002H\u0006i\u0001.[4i/\u0006$XM]7be.\fACZ5sgR,f\u000eZ3dS\u0012,Gm\u00144gg\u0016$XC\u0001Bq!\u0015\u0001(QYAd\u00031i\u0017\r]#oI>3gm]3u\u0003=\t7\r^5wKB\u0013x\u000eZ;dKJ\u001cXC\u0001Bu!!\u0011YO!=\u0002H\u0006EUB\u0001Bw\u0015\u0011\u0011y/a0\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BAc\u0005[\fq![:F[B$\u00180\u0006\u0002\u0002R\u0006\u0001Bn\\1e\rJ|Wn\u00158baNDw\u000e\u001e\u000b\u0007\u0003W\u0013YPa@\t\u000f\tuX\n1\u0001\u0002H\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bbBB\u0001\u001b\u0002\u0007\u0011qY\u0001\fGV\u0014(/\u001a8u)&lW-A\tm_\u0006$\u0007K]8ek\u000e,'/\u00128uef$B!a+\u0004\b!91\u0011\u0002(A\u0002\u0005E\u0015!B3oiJL\u0018!E5t!J|G-^2fe\u0016C\b/\u001b:fIR1\u0011\u0011[B\b\u0007'Aqa!\u0005P\u0001\u0004\t9-A\u0007dkJ\u0014XM\u001c;US6,Wj\u001d\u0005\b\u0007+y\u0005\u0019AAI\u00035\u0001(o\u001c3vG\u0016\u00148\u000b^1uK\u00061\"/Z7pm\u0016,\u0005\u0010]5sK\u0012\u0004&o\u001c3vG\u0016\u00148\u000f\u0006\u0003\u0002,\u000em\u0001bBB\t!\u0002\u0007\u0011qY\u0001\u0012iJ,hnY1uK\u0006sGMU3m_\u0006$G\u0003CAV\u0007C\u0019\u0019ca\n\t\u000f\tu\u0018\u000b1\u0001\u0002H\"91QE)A\u0002\u0005\u001d\u0017\u0001\u00047pO\u0016sGm\u00144gg\u0016$\bbBB\t#\u0002\u0007\u0011qY\u0001\u000eaJ,\u0007/\u0019:f+B$\u0017\r^3\u0015\r\r521GB\u001c!\ra7qF\u0005\u0004\u0007c1'A\u0005)s_\u0012,8-\u001a:BaB,g\u000eZ%oM>Dqa!\u000eS\u0001\u0004\t9-\u0001\u0006qe>$WoY3s\u0013\u0012Dqa!\u000fS\u0001\u0004\u0019Y$\u0001\u0004pe&<\u0017N\u001c\t\u0004Y\u000eu\u0012bAB M\na\u0011\t\u001d9f]\u0012|%/[4j]\u00061Q\u000f\u001d3bi\u0016$B!a+\u0004F!91qI*A\u0002\r5\u0012AC1qa\u0016tG-\u00138g_\u0006\u0011R\u000f\u001d3bi\u0016l\u0015\r]#oI>3gm]3u)\u0011\tYk!\u0014\t\u000f\r=C\u000b1\u0001\u0002H\u0006QA.Y:u\u001f\u001a47/\u001a;\u0002\u00131\f7\u000f^#oiJLH\u0003BB+\u0007/\u0002R\u0001\u001dBc\u0003#Cqa!\u000eV\u0001\u0004\t9-\u0001\u0007uC.,7K\\1qg\"|G\u000f\u0006\u0002\u0002,\u0006yQ\u000f\u001d3bi\u0016\u0004\u0016M]3oi\u0012K'\u000f\u0006\u0003\u0002,\u000e\u0005\u0004bBB2/\u0002\u0007\u00111T\u0001\na\u0006\u0014XM\u001c;ESJ\fA\u0003\\1uKN$8K\\1qg\"|Go\u00144gg\u0016$\u0018\u0001F8mI\u0016\u001cHo\u00158baNDw\u000e^(gMN,G/A\u000bt]\u0006\u00048\u000f[8u\r&dWMR8s\u001f\u001a47/\u001a;\u0015\t\r54q\u000e\t\u0006a\n\u0015\u00171\u001d\u0005\b\u0007cR\u0006\u0019AAd\u0003\u0019ygMZ:fi\u0006YrN\u001c'pON#\u0018M\u001d;PM\u001a\u001cX\r^%oGJ,W.\u001a8uK\u0012$B!a+\u0004x!9!Q`.A\u0002\u0005\u001d\u0017A\b:f[>4X-\u00168sKBd\u0017nY1uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8t)\u0011\tYk! \t\u000f\rED\f1\u0001\u0002H\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0005\u0003W\u001b\u0019\tC\u0004\u0004ru\u0003\r!a2\u0002!1\f7\u000f^*uC\ndWm\u00144gg\u0016$H\u0003BAd\u0007\u0013Cqaa#_\u0001\u0004\u0019i)\u0001\u0007d_6\u0004H.\u001a;fIRCh\u000eE\u0002m\u0007\u001fK1a!%g\u00051\u0019u.\u001c9mKR,G\r\u0016=o\u0003-\u0019w.\u001c9mKR,G\u000b\u001f8\u0015\t\u0005-6q\u0013\u0005\b\u0007\u0017{\u0006\u0019ABG\u0003U!W\r\\3uKNs\u0017\r]:i_R\u001c()\u001a4pe\u0016$B!a+\u0004\u001e\"91\u0011\u000f1A\u0002\u0005\u001d\u0007f\u00011\u0004\"B!!1DBR\u0013\u0011\u0019)K!\b\u0003\u0015QD'/Z1eg\u00064W-\u0001\npY\u0012,7\u000f^*oCB\u001c\bn\u001c;GS2,WCAB7\u0003Ia\u0017\r^3tiNs\u0017\r]:i_R4\u0015\u000e\\3\u0002/I,Wn\u001c<f\u0003:$G)\u001a7fi\u0016\u001cf.\u00199tQ>$H\u0003BAV\u0007cCqaa-d\u0001\u0004\t9-\u0001\bt]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;\u0002AI,Wn\u001c<f\u0003:$W*\u0019:l':\f\u0007o\u001d5pi\u001a{'\u000fR3mKRLwN\u001c\u000b\u0005\u0007[\u001aI\fC\u0004\u00044\u0012\u0004\r!a2)\u0007-\u001ai\f\u0005\u0003\u0003\u001c\r}\u0016\u0002BBa\u0005;\u0011QB\\8oi\"\u0014X-\u00193tC\u001a,\u0007")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File _logDir;
    private final int maxProducerIdExpirationMs;
    private final Time time;
    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$4() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File _logDir() {
        return this._logDir;
    }

    public void _logDir_$eq(File x$1) {
        this._logDir = x$1;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    public Time time() {
        return this.time;
    }

    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots() {
        return this.snapshots;
    }

    private void snapshots_$eq(ConcurrentSkipListMap<Long, SnapshotFile> x$1) {
        this.snapshots = x$1;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    /*
     * WARNING - void declaration
     */
    private ConcurrentSkipListMap<Long, SnapshotFile> loadSnapshots() {
        void var1_1;
        ConcurrentSkipListMap tm = new ConcurrentSkipListMap();
        ProducerStateManager$.MODULE$.listSnapshotFiles(this._logDir()).foreach((Function1 & Serializable & scala.Serializable)f -> tm.put(Predef$.MODULE$.long2Long(f.offset()), f));
        return var1_1;
    }

    public void removeStraySnapshots(Seq<Object> segmentBaseOffsets) {
        None$ maxSegmentBaseOffset = segmentBaseOffsets.isEmpty() ? None$.MODULE$ : new Some(segmentBaseOffsets.max((Ordering)Ordering.Long$.MODULE$));
        Set baseOffsets = segmentBaseOffsets.toSet();
        ObjectRef latestStraySnapshot = ObjectRef.create((Object)None$.MODULE$);
        ConcurrentSkipListMap<Long, SnapshotFile> ss = this.loadSnapshots();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(ss.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$removeStraySnapshots$1(latestStraySnapshot, baseOffsets, ss, snapshot);
            return BoxedUnit.UNIT;
        });
        ((Option)latestStraySnapshot.elem).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset())).foreach((Function1)((JFunction1.mcVJ.sp & Serializable & scala.Serializable)arg_0 -> ProducerStateManager.$anonfun$removeStraySnapshots$3((Option)maxSegmentBaseOffset, ss, arg_0)));
        this.snapshots_$eq(ss);
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TxnMetadata)x$5.getValue()).firstOffset());
        if (unreplicatedFirstOffset.isEmpty()) {
            return undecidedFirstOffset;
        }
        if (undecidedFirstOffset.isEmpty()) {
            return unreplicatedFirstOffset;
        }
        if (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset()) {
            return undecidedFirstOffset;
        }
        return var1_1;
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        Option<SnapshotFile> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            SnapshotFile snapshot = (SnapshotFile)((Some)option).value();
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading producer state from snapshot file '").append(snapshot).append("'").toString());
                ((Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshot.file()).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, currentTime, producerEntry)))).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                    this.loadProducerEntry(entry);
                    return BoxedUnit.UNIT;
                });
                this.lastSnapOffset_$eq(snapshot.offset());
                this.lastMapOffset_$eq(this.lastSnapOffset());
                return;
            }
            catch (CorruptSnapshotException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to load producer snapshot from '").append(snapshot.file()).append("': ").append(e.getMessage()).toString());
                this.removeAndDeleteSnapshot(snapshot.offset());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset);
            this.lastMapOffset_$eq(logStartOffset);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        entry.currentTxnFirstOffset().foreach((Function1 & Serializable & scala.Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong((Object)offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().$minus$minus$eq((TraversableOnce)((MapLike)this.producers().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, x0$1)))).keySet());
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$truncateAndReload$1(this, logEndOffset, logStartOffset, snapshot);
            return BoxedUnit.UNIT;
        });
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
            return;
        }
        this.onLogStartOffsetIncremented(logStartOffset);
    }

    public ProducerAppendInfo prepareUpdate(long producerId, AppendOrigin origin) {
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, origin);
    }

    public void update(ProducerAppendInfo appendInfo) {
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Invalid producer id ").append(appendInfo.producerId()).append(" passed to update ").append("for partition ").append(this.topicPartition()).toString());
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Updated producer ").append(appendInfo.producerId()).append(" state to ").append(appendInfo).toString());
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
        if (option instanceof Some) {
            ((ProducerStateEntry)((Some)option).value()).update(updatedEntry);
        } else if (None$.MODULE$.equals(option)) {
            this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
        } else {
            throw new MatchError((Object)option);
        }
        appendInfo.startedTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), (TxnMetadata)txn));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        if (this.lastMapOffset() > this.lastSnapOffset()) {
            SnapshotFile snapshotFile = SnapshotFile$.MODULE$.apply(UnifiedLog$.MODULE$.producerSnapshotFile(this._logDir(), this.lastMapOffset()));
            long start = this.time().hiResClockMs();
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile.file(), this.producers());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Wrote producer snapshot at offset ").append(this.lastMapOffset()).append(" with ").append(this.producers().size()).append(" producer ids in ").append(this.time().hiResClockMs() - start).append(" ms.").toString());
            this.snapshots().put(Predef$.MODULE$.long2Long(snapshotFile.offset()), snapshotFile);
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public void updateParentDir(File parentDir) {
        this._logDir_$eq(parentDir);
        this.snapshots().forEach((x$7, s) -> s.updateParentDir(parentDir));
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.offset()));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.offset()));
    }

    public Option<SnapshotFile> snapshotFileForOffset(long offset) {
        return Option$.MODULE$.apply((Object)this.snapshots().get(BoxesRunTime.boxToLong((long)offset)));
    }

    public void onLogStartOffsetIncremented(long logStartOffset) {
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset)));
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getValue().lastOffset().exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$10 -> x$10 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncateFullyAndStartAt(long offset) {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(offset);
    }

    public long lastStableOffset(CompletedTxn completedTxn) {
        return BoxesRunTime.unboxToLong((Object)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.ongoingTxns().values()).asScala()).find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$lastStableOffset$1(completedTxn, x$11))).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$lastStableOffset$2(x$12))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> completedTxn.lastOffset() + 1L));
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Attempted to complete transaction ").append(completedTxn).append(" on partition ").append(this.topicPartition()).append(" ").append("which was not started").toString());
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
    }

    public void deleteSnapshotsBefore(long offset) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().subMap((Object)Predef$.MODULE$.long2Long(0L), (Object)Predef$.MODULE$.long2Long(offset)).values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
    }

    private Option<SnapshotFile> oldestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$13 -> (SnapshotFile)x$13.getValue());
    }

    private Option<SnapshotFile> latestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().lastEntry()).map((Function1 & Serializable & scala.Serializable)x$14 -> (SnapshotFile)x$14.getValue());
    }

    private void removeAndDeleteSnapshot(long snapshotOffset) {
        Option$.MODULE$.apply((Object)this.snapshots().remove(BoxesRunTime.boxToLong((long)snapshotOffset))).foreach((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.deleteIfExists()));
    }

    public Option<SnapshotFile> removeAndMarkSnapshotForDeletion(long snapshotOffset) {
        return Option$.MODULE$.apply((Object)this.snapshots().remove(BoxesRunTime.boxToLong((long)snapshotOffset))).flatMap((Function1 & Serializable & scala.Serializable)snapshot -> {
            try {
                snapshot.renameTo(UnifiedLog$.MODULE$.DeletedFileSuffix());
                return new Some(snapshot);
            }
            catch (NoSuchFileException noSuchFileException) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Failed to rename producer state snapshot ").append(snapshot.file().getAbsoluteFile()).append(" with deletion suffix because it was already deleted").toString());
                return None$.MODULE$;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$1(ObjectRef latestStraySnapshot$1, Set baseOffsets$1, ConcurrentSkipListMap ss$1, SnapshotFile snapshot) {
        long key = snapshot.offset();
        Option option = (Option)latestStraySnapshot$1.elem;
        if (option instanceof Some) {
            SnapshotFile prev = (SnapshotFile)((Some)option).value();
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                prev.deleteIfExists();
                ss$1.remove(BoxesRunTime.boxToLong((long)prev.offset()));
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
        } else if (None$.MODULE$.equals(option)) {
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$3(Option maxSegmentBaseOffset$1, ConcurrentSkipListMap ss$1, long strayOffset) {
        maxSegmentBaseOffset$1.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)maxOffset -> {
            if (strayOffset < maxOffset) {
                Option$.MODULE$.apply(ss$1.remove(BoxesRunTime.boxToLong((long)strayOffset))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.deleteIfExists()));
            }
        });
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long currentTime$1, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$1, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        ProducerStateEntry lastEntry = (ProducerStateEntry)x0$1._2();
        boolean bl = $this.isProducerExpired(currentTimeMs$1, lastEntry);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$truncateAndReload$1(ProducerStateManager $this, long logEndOffset$1, long logStartOffset$1, SnapshotFile snapshot) {
        if (snapshot.offset() > logEndOffset$1 || snapshot.offset() <= logStartOffset$1) {
            $this.removeAndDeleteSnapshot(snapshot.offset());
        }
    }

    public static final /* synthetic */ boolean $anonfun$lastStableOffset$1(CompletedTxn completedTxn$1, TxnMetadata x$11) {
        return x$11.producerId() != completedTxn$1.producerId();
    }

    public static final /* synthetic */ long $anonfun$lastStableOffset$2(TxnMetadata x$12) {
        return x$12.firstOffset().messageOffset();
    }

    public ProducerStateManager(TopicPartition topicPartition, File _logDir, int maxProducerIdExpirationMs, Time time) {
        this.topicPartition = topicPartition;
        this._logDir = _logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[ProducerStateManager partition=").append(topicPartition).append("] ").toString());
        this.snapshots = (ConcurrentSkipListMap)Predef$.MODULE$.locally(this.loadSnapshots());
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

