/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kafka.log.LogSegment;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0010!\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\u0006q\u0001!\t!\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019y\u0005\u0001)A\u0005\u007f!)\u0001\u000b\u0001C\u0001#\")A\f\u0001C\u0001#\")a\f\u0001C\u0001?\")1\r\u0001C\u0001I\")1\u000e\u0001C\u0001Y\")a\u000e\u0001C\u0001Y\")q\u000e\u0001C\u0001Y\")\u0001\u000f\u0001C\u0001c\")!\u0010\u0001C\u0001w\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!a\r\u0001\t\u0003\tI\u0004C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBA6\u0001\u0011%\u0011Q\u000e\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!a!\u0001\t\u0003\t)\tC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011q\u0013\u0001\u0005\u0002\u00055\u0005bBAN\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003?\u0003A\u0011AAQ\u0005-aunZ*fO6,g\u000e^:\u000b\u0005\u0005\u0012\u0013a\u00017pO*\t1%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\u000592T\"A\u0018\u000b\u0005A\n\u0014AB2p[6|gN\u0003\u0002$e)\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0013\t9tF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\rqJg.\u001b;?)\tQD\b\u0005\u0002<\u00015\t\u0001\u0005C\u0003-\u0005\u0001\u0007Q&\u0001\u0005tK\u001elWM\u001c;t+\u0005y\u0004\u0003\u0002!H\u00132k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b!bY8oGV\u0014(/\u001a8u\u0015\t!U)\u0001\u0003vi&d'\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u0006\u0013acQ8oGV\u0014(/\u001a8u\u001d\u00064\u0018nZ1cY\u0016l\u0015\r\u001d\t\u0003O)K!a\u0013\u0015\u0003\t1{gn\u001a\t\u0003w5K!A\u0014\u0011\u0003\u00151{wmU3h[\u0016tG/A\u0005tK\u001elWM\u001c;tA\u00059\u0011n]#naRLX#\u0001*\u0011\u0005\u001d\u001a\u0016B\u0001+)\u0005\u001d\u0011un\u001c7fC:D#!\u0002,\u0011\u0005]SV\"\u0001-\u000b\u0005e\u0013\u0013!B;uS2\u001c\u0018BA.Y\u0005)!\bN]3bIN\fg-Z\u0001\t]>tW)\u001c9us\"\u0012aAV\u0001\u0004C\u0012$GC\u0001'a\u0011\u0015\tw\u00011\u0001M\u0003\u001d\u0019XmZ7f]RD#a\u0002,\u0002\rI,Wn\u001c<f)\t)\u0007\u000e\u0005\u0002(M&\u0011q\r\u000b\u0002\u0005+:LG\u000fC\u0003j\u0011\u0001\u0007\u0011*\u0001\u0004pM\u001a\u001cX\r\u001e\u0015\u0003\u0011Y\u000bQa\u00197fCJ$\u0012!\u001a\u0015\u0003\u0013Y\u000bQa\u00197pg\u0016\fQb\u00197pg\u0016D\u0015M\u001c3mKJ\u001c\u0018aD;qI\u0006$X\rU1sK:$H)\u001b:\u0015\u0005\u0015\u0014\b\"B:\r\u0001\u0004!\u0018a\u00013jeB\u0011Q\u000f_\u0007\u0002m*\u0011q/R\u0001\u0003S>L!!\u001f<\u0003\t\u0019KG.Z\u0001\u0011]Vl'-\u001a:PMN+w-\\3oiN,\u0012\u0001 \t\u0003OuL!A \u0015\u0003\u0007%sG\u000f\u000b\u0002\u000e-\u0006Y!-Y:f\u001f\u001a47/\u001a;t+\t\t)\u0001E\u0003\u0002\b\u0005]\u0011J\u0004\u0003\u0002\n\u0005Ma\u0002BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=A%\u0001\u0004=e>|GOP\u0005\u0002S%\u0019\u0011Q\u0003\u0015\u0002\u000fA\f7m[1hK&!\u0011\u0011DA\u000e\u0005!IE/\u001a:bE2,'bAA\u000bQ\u0005A1m\u001c8uC&t7\u000fF\u0002S\u0003CAQ![\bA\u0002%C#a\u0004,\u0002\u0007\u001d,G\u000f\u0006\u0003\u0002*\u0005=\u0002\u0003B\u0014\u0002,1K1!!\f)\u0005\u0019y\u0005\u000f^5p]\")\u0011\u000e\u0005a\u0001\u0013\"\u0012\u0001CV\u0001\u0007m\u0006dW/Z:\u0016\u0005\u0005]\u0002#BA\u0004\u0003/aECBA\u001c\u0003w\ty\u0004\u0003\u0004\u0002>I\u0001\r!S\u0001\u0005MJ|W\u000e\u0003\u0004\u0002BI\u0001\r!S\u0001\u0003i>\f\u0001D\\8o\u0003\u000e$\u0018N^3M_\u001e\u001cVmZ7f]R\u001chI]8n)\u0011\t9$a\u0012\t\r\u0005u2\u00031\u0001J\u0003)1Gn\\8s\u000b:$(/\u001f\u000b\u0005\u0003\u001b\ny\u0006E\u0003(\u0003W\ty\u0005\u0005\u0004\u0002R\u0005e\u0013\n\u0014\b\u0005\u0003'\n)&D\u0001D\u0013\r\t9fQ\u0001\u0004\u001b\u0006\u0004\u0018\u0002BA.\u0003;\u0012Q!\u00128uefT1!a\u0016D\u0011\u0015IG\u00031\u0001JQ\t!b+\u0001\u0007gY>|'oU3h[\u0016tG\u000f\u0006\u0003\u0002*\u0005\u001d\u0004\"B5\u0016\u0001\u0004I\u0005FA\u000bW\u0003)awn^3s\u000b:$(/\u001f\u000b\u0005\u0003\u001b\ny\u0007C\u0003j-\u0001\u0007\u0011\n\u000b\u0002\u0017-\u0006aAn\\<feN+w-\\3oiR!\u0011\u0011FA<\u0011\u0015Iw\u00031\u0001JQ\t9b+A\u0006iS\u001eDWM]#oiJLH\u0003BA'\u0003\u007fBQ!\u001b\rA\u0002%C#\u0001\u0007,\u0002\u001b!Lw\r[3s'\u0016<W.\u001a8u)\u0011\tI#a\"\t\u000b%L\u0002\u0019A%)\u0005e1\u0016A\u00034jeN$XI\u001c;ssV\u0011\u0011Q\n\u0015\u00035Y\u000bABZ5sgR\u001cVmZ7f]R,\"!!\u000b)\u0005m1\u0016!\u00037bgR,e\u000e\u001e:zQ\tab+A\u0006mCN$8+Z4nK:$\bFA\u000fW\u00039A\u0017n\u001a5feN+w-\\3oiN$B!a\u000e\u0002$\"1\u0011Q\u0015\u0010A\u0002%\u000b!BY1tK>3gm]3u\u0001")
public class LogSegments {
    private final TopicPartition topicPartition;
    private final ConcurrentNavigableMap<Object, LogSegment> segments;

    private ConcurrentNavigableMap<Object, LogSegment> segments() {
        return this.segments;
    }

    public boolean isEmpty() {
        return this.segments().isEmpty();
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public LogSegment add(LogSegment segment) {
        return this.segments().put(BoxesRunTime.boxToLong((long)segment.baseOffset()), segment);
    }

    public void remove(long offset) {
        this.segments().remove(BoxesRunTime.boxToLong((long)offset));
    }

    public void clear() {
        this.segments().clear();
    }

    public void close() {
        this.values().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public void closeHandlers() {
        this.values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.closeHandlers();
            return BoxedUnit.UNIT;
        });
    }

    public void updateParentDir(File dir) {
        this.values().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.updateParentDir(dir);
            return BoxedUnit.UNIT;
        });
    }

    public int numberOfSegments() {
        return this.segments().size();
    }

    public Iterable<Object> baseOffsets() {
        return (Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.segments().values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.baseOffset()), Iterable$.MODULE$.canBuildFrom());
    }

    public boolean contains(long offset) {
        return this.segments().containsKey(BoxesRunTime.boxToLong((long)offset));
    }

    public Option<LogSegment> get(long offset) {
        return Option$.MODULE$.apply(this.segments().get(BoxesRunTime.boxToLong((long)offset)));
    }

    public Iterable<LogSegment> values() {
        return (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.segments().values()).asScala();
    }

    public Iterable<LogSegment> values(long from, long to) {
        if (from == to) {
            return List$.MODULE$.empty();
        }
        if (to < from) {
            throw new IllegalArgumentException(new StringBuilder(98).append("Invalid log segment range: requested segments in ").append(this.topicPartition).append(" ").append("from offset ").append(from).append(" which is greater than limit offset ").append(to).toString());
        }
        ConcurrentNavigableMap view = (ConcurrentNavigableMap)Option$.MODULE$.apply(this.segments().floorKey(BoxesRunTime.boxToLong((long)from))).map((Function1 & Serializable & scala.Serializable)floor -> LogSegments.$anonfun$values$1(this, to, BoxesRunTime.unboxToLong((Object)floor))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.segments().headMap((Object)BoxesRunTime.boxToLong((long)to)));
        return (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(view.values()).asScala();
    }

    public Iterable<LogSegment> nonActiveLogSegmentsFrom(long from) {
        LogSegment activeSegment = (LogSegment)this.lastSegment().get();
        if (from > activeSegment.baseOffset()) {
            return Nil$.MODULE$;
        }
        return this.values(from, activeSegment.baseOffset());
    }

    private Option<Map.Entry<Object, LogSegment>> floorEntry(long offset) {
        return Option$.MODULE$.apply(this.segments().floorEntry(BoxesRunTime.boxToLong((long)offset)));
    }

    public Option<LogSegment> floorSegment(long offset) {
        return this.floorEntry(offset).map((Function1 & Serializable & scala.Serializable)x$5 -> (LogSegment)x$5.getValue());
    }

    private Option<Map.Entry<Object, LogSegment>> lowerEntry(long offset) {
        return Option$.MODULE$.apply(this.segments().lowerEntry(BoxesRunTime.boxToLong((long)offset)));
    }

    public Option<LogSegment> lowerSegment(long offset) {
        return this.lowerEntry(offset).map((Function1 & Serializable & scala.Serializable)x$6 -> (LogSegment)x$6.getValue());
    }

    public Option<Map.Entry<Object, LogSegment>> higherEntry(long offset) {
        return Option$.MODULE$.apply(this.segments().higherEntry(BoxesRunTime.boxToLong((long)offset)));
    }

    public Option<LogSegment> higherSegment(long offset) {
        return this.higherEntry(offset).map((Function1 & Serializable & scala.Serializable)x$7 -> (LogSegment)x$7.getValue());
    }

    public Option<Map.Entry<Object, LogSegment>> firstEntry() {
        return Option$.MODULE$.apply(this.segments().firstEntry());
    }

    public Option<LogSegment> firstSegment() {
        return this.firstEntry().map((Function1 & Serializable & scala.Serializable)x$8 -> (LogSegment)x$8.getValue());
    }

    public Option<Map.Entry<Object, LogSegment>> lastEntry() {
        return Option$.MODULE$.apply(this.segments().lastEntry());
    }

    public Option<LogSegment> lastSegment() {
        return this.lastEntry().map((Function1 & Serializable & scala.Serializable)x$9 -> (LogSegment)x$9.getValue());
    }

    public Iterable<LogSegment> higherSegments(long baseOffset) {
        java.util.Map view = (java.util.Map)Option$.MODULE$.apply(this.segments().higherKey(BoxesRunTime.boxToLong((long)baseOffset))).map((Function1 & Serializable & scala.Serializable)higherOffset -> LogSegments.$anonfun$higherSegments$1(this, BoxesRunTime.unboxToLong((Object)higherOffset))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava());
        return (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(view.values()).asScala();
    }

    public static final /* synthetic */ ConcurrentNavigableMap $anonfun$values$1(LogSegments $this, long to$1, long floor) {
        return $this.segments().subMap((Object)BoxesRunTime.boxToLong((long)floor), (Object)BoxesRunTime.boxToLong((long)to$1));
    }

    public static final /* synthetic */ ConcurrentNavigableMap $anonfun$higherSegments$1(LogSegments $this, long higherOffset) {
        return $this.segments().tailMap((Object)BoxesRunTime.boxToLong((long)higherOffset), true);
    }

    public LogSegments(TopicPartition topicPartition) {
        this.topicPartition = topicPartition;
        this.segments = new ConcurrentSkipListMap<Object, LogSegment>();
    }
}

