/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicThreadPool;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r\u001dx!B)S\u0011\u00039f!B-S\u0011\u0003Q\u0006\"B1\u0002\t\u0003\u0011\u0007\u0002C2\u0002\u0005\u0004%\tA\u00153\t\rU\f\u0001\u0015!\u0003f\u0011\u001d1\u0018A1A\u0005\u0002\u0011Daa^\u0001!\u0002\u0013)\u0007b\u0002=\u0002\u0005\u0004%I!\u001f\u0005\u0007{\u0006\u0001\u000b\u0011\u0002>\t\u000fy\f!\u0019!C\u0005I\"1q0\u0001Q\u0001\n\u0015D\u0001\"!\u0001\u0002\u0005\u0004%I!\u001f\u0005\b\u0003\u0007\t\u0001\u0015!\u0003{\u0011!\t)!\u0001b\u0001\n\u0013I\bbBA\u0004\u0003\u0001\u0006IA\u001f\u0005\n\u0003\u0013\t!\u0019!C\u0001\u0003\u0017A\u0001\"!\b\u0002A\u0003%\u0011Q\u0002\u0005\t\u0003?\t!\u0019!C\u0005I\"9\u0011\u0011E\u0001!\u0002\u0013)\u0007bBA\u0012\u0003\u0011\u0005\u0011Q\u0005\u0005\b\u0003\u000b\nA\u0011AA$\u0011\u001d\t\t'\u0001C\u0001\u0003GBq!! \u0002\t\u0013\ty\bC\u0004\u0002\u0006\u0006!I!a\"\t\u000f\u0005-\u0015\u0001\"\u0003\u0002\u000e\"9\u0011\u0011S\u0001\u0005\n\u0005M\u0005\u0002CAL\u0003\u0011\u0005!+!'\t\u0011\u0005e\u0016\u0001\"\u0001S\u0003wC\u0001\"a1\u0002\t\u0003\u0011\u0016Q\u0019\u0004\u00063J\u0003\u00111\u001a\u0005\u000b\u00033l\"Q1A\u0005\n\u0005m\u0007BCAr;\t\u0005\t\u0015!\u0003\u0002^\"1\u0011-\bC\u0001\u0003KD!\"a;\u001e\u0005\u0004%\tAUAw\u0011!\t\u00190\bQ\u0001\n\u0005=\bBCA{;\t\u0007I\u0011\u0001*\u0002n\"A\u0011q_\u000f!\u0002\u0013\ty\u000fC\u0005\u0002zv\u0011\r\u0011\"\u0003\u0002|\"A\u0011q`\u000f!\u0002\u0013\ti\u0010C\u0005\u0003\u0002u\u0011\r\u0011\"\u0003\u0002|\"A!1A\u000f!\u0002\u0013\ti\u0010C\u0005\u0003\u0006u\u0011\r\u0011\"\u0003\u0003\b!A!qC\u000f!\u0002\u0013\u0011I\u0001C\u0005\u0003\u001au\u0011\r\u0011\"\u0003\u0003\u001c!A!QE\u000f!\u0002\u0013\u0011i\u0002C\u0005\u0003(u\u0011\r\u0011\"\u0003\u0003*!A!1H\u000f!\u0002\u0013\u0011Y\u0003C\u0005\u0003>u\u0001\r\u0011\"\u0003\u0002\\\"I!qH\u000fA\u0002\u0013%!\u0011\t\u0005\t\u0005\u000fj\u0002\u0015)\u0003\u0002^\"I!\u0011J\u000fC\u0002\u0013%!1\n\u0005\t\u00053j\u0002\u0015!\u0003\u0003N!A!1L\u000f\u0005\u0002I\u0013i\u0006\u0003\u0005\u0003pu!\tA\u0015B9\u0011\u001d\u0011\u0019(\bC\u0001\u0005kBqA!!\u001e\t\u0003\u0011\u0019\tC\u0004\u0003\nv!\tAa#\t\u000f\t=U\u0004\"\u0001\u0003\u0012\"9!QS\u000f\u0005\n\t]\u0005\u0002\u0003BO;\u0011\u0005!+a7\t\u0011\t}U\u0004\"\u0001S\u0005CC\u0001Ba*\u001e\t\u0003\u0011&\u0011\u0015\u0005\t\u0005SkB\u0011\u0001*\u0003,\"A!1X\u000f\u0005\u0002I\u0013i\f\u0003\u0005\u0003Bv!\tA\u0015Bb\u0011\u001d\u0011I-\bC\u0005\u0005\u0017DqAa8\u001e\t\u0013\u0011\t\u000f\u0003\u0005\u0003dv!\tA\u0015Bs\u0011!\u0011i/\bC\u0001%\n=\bb\u0002B{;\u0011%!q\u001f\u0005\b\u0007\u000biB\u0011BB\u0004\u0011!\u0019y!\bC\u0001%\u000eE\u0001bBB\f;\u0011%1\u0011\u0004\u0005\t\u0007?iB\u0011\u0001*\u0004\"!91qI\u000f\u0005\n\r%\u0003bBB;;\u0011%1q\u000f\u0005\b\u0007{jB\u0011\u0002B9\u0011\u001d\u0019y(\bC\u0005\u0007\u0003Cqa!$\u001e\t\u0013\u0019y\tC\u0004\u0004\"v!Iaa)\t\u000f\r%W\u0004\"\u0003\u0004L\u0006\u0019B)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jO*\u00111\u000bV\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003U\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002Y\u00035\t!KA\nEs:\fW.[2Ce>\\WM]\"p]\u001aLwm\u0005\u0002\u00027B\u0011AlX\u0007\u0002;*\ta,A\u0003tG\u0006d\u0017-\u0003\u0002a;\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A,\u0002-\u0011Kh.Y7jGN+7-\u001e:jif\u001cuN\u001c4jON,\u0012!\u001a\t\u0004M.lW\"A4\u000b\u0005!L\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003Uv\u000b!bY8mY\u0016\u001cG/[8o\u0013\tawMA\u0002TKR\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\t1\fgn\u001a\u0006\u0002e\u0006!!.\u0019<b\u0013\t!xN\u0001\u0004TiJLgnZ\u0001\u0018\tft\u0017-\\5d'\u0016\u001cWO]5us\u000e{gNZ5hg\u0002\n\u0011#\u00117m\tft\u0017-\\5d\u0007>tg-[4t\u0003I\tE\u000e\u001c#z]\u0006l\u0017nY\"p]\u001aLwm\u001d\u0011\u00027\rcWo\u001d;fe2+g/\u001a7MSN$XM\\3s\u0007>tg-[4t+\u0005Q\bcA>}[6\t\u0011.\u0003\u0002mS\u0006a2\t\\;ti\u0016\u0014H*\u001a<fY2K7\u000f^3oKJ\u001cuN\u001c4jON\u0004\u0013\u0001\u0005)fe\n\u0013xn[3s\u0007>tg-[4t\u0003E\u0001VM\u001d\"s_.,'oQ8oM&<7\u000fI\u0001\u0019\u0019&\u001cH/\u001a8fe6+7\r[1oSNl7i\u001c8gS\u001e\u001c\u0018!\u0007'jgR,g.\u001a:NK\u000eD\u0017M\\5t[\u000e{gNZ5hg\u0002\nQCU3m_\u0006$\u0017M\u00197f\r&dWmQ8oM&<7/\u0001\fSK2|\u0017\rZ1cY\u00164\u0015\u000e\\3D_:4\u0017nZ:!\u0003Ma\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001e\u0014VmZ3y+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u00115\fGo\u00195j]\u001eT1!a\u0006^\u0003\u0011)H/\u001b7\n\t\u0005m\u0011\u0011\u0003\u0002\u0006%\u0016<W\r_\u0001\u0015\u0019&\u001cH/\u001a8fe\u000e{gNZ5h%\u0016<W\r\u001f\u0011\u0002-\u0011Kh.Y7jGB\u000b7o]<pe\u0012\u001cuN\u001c4jON\fq\u0003R=oC6L7\rU1tg^|'\u000fZ\"p]\u001aLwm\u001d\u0011\u0002!%\u001c\b+Y:to>\u0014HmQ8oM&<G\u0003BA\u0014\u0003[\u00012\u0001XA\u0015\u0013\r\tY#\u0018\u0002\b\u0005>|G.Z1o\u0011\u001d\tyc\u0005a\u0001\u0003c\tAA\\1nKB!\u00111GA!\u001d\u0011\t)$!\u0010\u0011\u0007\u0005]R,\u0004\u0002\u0002:)\u0019\u00111\b,\u0002\rq\u0012xn\u001c;?\u0013\r\ty$X\u0001\u0007!J,G-\u001a4\n\u0007Q\f\u0019EC\u0002\u0002@u\u000bAC\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0016P\\8os6\u001cHCBA%\u00037\ni\u0006\u0005\u0004\u0002L\u0005U\u0013\u0011\u0007\b\u0005\u0003\u001b\n\tF\u0004\u0003\u00028\u0005=\u0013\"\u00010\n\u0007\u0005MS,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0013\u0011\f\u0002\u0005\u0019&\u001cHOC\u0002\u0002TuCq!a\f\u0015\u0001\u0004\t\t\u0004C\u0004\u0002`Q\u0001\r!a\n\u0002+5\fGo\u00195MSN$XM\\3s\u001fZ,'O]5eK\u0006ya/\u00197jI\u0006$XmQ8oM&<7\u000f\u0006\u0004\u0002f\u0005-\u0014\u0011\u0010\t\u00049\u0006\u001d\u0014bAA5;\n!QK\\5u\u0011\u001d\ti'\u0006a\u0001\u0003_\nQ\u0001\u001d:paN\u0004B!!\u001d\u0002v5\u0011\u00111\u000f\u0006\u0004\u0003/\t\u0018\u0002BA<\u0003g\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\tY(\u0006a\u0001\u0003O\tq\u0002]3s\u0005J|7.\u001a:D_:4\u0017nZ\u0001\u0011a\u0016\u0014(I]8lKJ\u001cuN\u001c4jON$B!!!\u0002\u0004B!1\u0010`A\u0019\u0011\u001d\tiG\u0006a\u0001\u0003_\n\u0011C\\8o\tft\u0017-\\5d\u0007>tg-[4t)\u0011\t\t)!#\t\u000f\u00055t\u00031\u0001\u0002p\u0005!3/Z2ve&$\u0018pQ8oM&<7oV5uQ>,H\u000fT5ti\u0016tWM\u001d)sK\u001aL\u0007\u0010\u0006\u0003\u0002\u0002\u0006=\u0005bBA71\u0001\u0007\u0011qN\u0001\u0014m\u0006d\u0017\u000eZ1uK\u000e{gNZ5h)f\u0004Xm\u001d\u000b\u0005\u0003K\n)\nC\u0004\u0002ne\u0001\r!a\u001c\u0002#\u0005$G\rR=oC6L7mQ8oM&<7\u000f\u0006\u0003\u0002f\u0005m\u0005bBAO5\u0001\u0007\u0011qT\u0001\nG>tg-[4EK\u001a\u0004B!!)\u000266\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u0003S\u000bY+\u0001\u0004d_6lwN\u001c\u0006\u0004+\u00065&\u0002BAX\u0003c\u000ba!\u00199bG\",'BAAZ\u0003\ry'oZ\u0005\u0005\u0003o\u000b\u0019KA\u0005D_:4\u0017n\u001a#fM\u0006AB-\u001f8b[&\u001c7i\u001c8gS\u001e,\u0006\u000fZ1uK6{G-Z:\u0016\u0005\u0005u\u0006\u0003CA9\u0003\u007f\u000b\t$!\r\n\t\u0005\u0005\u00171\u000f\u0002\u0004\u001b\u0006\u0004\u0018A\u0006:fg>dg/\u001a,be&\f'\r\\3D_:4\u0017nZ:\u0015\t\u0005=\u0014q\u0019\u0005\b\u0003\u0013d\u0002\u0019AA8\u00035\u0001(o\u001c9t\u001fJLw-\u001b8bYN!QdWAg!\u0011\ty-!6\u000e\u0005\u0005E'bAAj)\u0006)Q\u000f^5mg&!\u0011q[Ai\u0005\u001daunZ4j]\u001e\f1b[1gW\u0006\u001cuN\u001c4jOV\u0011\u0011Q\u001c\t\u00041\u0006}\u0017bAAq%\nY1*\u00194lC\u000e{gNZ5h\u00031Y\u0017MZ6b\u0007>tg-[4!)\u0011\t9/!;\u0011\u0005ak\u0002bBAmA\u0001\u0007\u0011Q\\\u0001\u0014gR\fG/[2Ce>\\WM]\"p]\u001aLwm]\u000b\u0003\u0003_\u0004RAZAy[6L1!!1h\u0003Q\u0019H/\u0019;jG\n\u0013xn[3s\u0007>tg-[4tA\u0005!2\u000f^1uS\u000e$UMZ1vYR\u001cuN\u001c4jON\fQc\u001d;bi&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\b%\u0001\u000bes:\fW.[2Ce>\\WM]\"p]\u001aLwm]\u000b\u0003\u0003{\u0004rAZAy\u0003c\t\t$A\u000bes:\fW.[2Ce>\\WM]\"p]\u001aLwm\u001d\u0011\u0002+\u0011Lh.Y7jG\u0012+g-Y;mi\u000e{gNZ5hg\u00061B-\u001f8b[&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\b%A\bsK\u000e|gNZ5hkJ\f'\r\\3t+\t\u0011I\u0001E\u0003g\u0005\u0017\u0011y!C\u0002\u0003\u000e\u001d\u0014aAQ;gM\u0016\u0014\b\u0003\u0002B\t\u0005'i!!a*\n\t\tU\u0011q\u0015\u0002\u000f%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003A\u0011XmY8oM&<WO]1cY\u0016\u001c\b%A\u000bce>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z:\u0016\u0005\tu\u0001#\u00024\u0003\f\t}\u0001c\u0001-\u0003\"%\u0019!1\u0005*\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003Y\u0011'o\\6feJ+7m\u001c8gS\u001e,(/\u00192mKN\u0004\u0013\u0001\u00027pG.,\"Aa\u000b\u0011\t\t5\"qG\u0007\u0003\u0005_QAA!\r\u00034\u0005)An\\2lg*!!QGA:\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005s\u0011yC\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0003\u0015awnY6!\u00035\u0019WO\u001d:f]R\u001cuN\u001c4jO\u0006\t2-\u001e:sK:$8i\u001c8gS\u001e|F%Z9\u0015\t\u0005\u0015$1\t\u0005\n\u0005\u000b\u0002\u0014\u0011!a\u0001\u0003;\f1\u0001\u001f\u00132\u00039\u0019WO\u001d:f]R\u001cuN\u001c4jO\u0002\nA\u0004Z=oC6L7mQ8oM&<\u0007+Y:to>\u0014H-\u00128d_\u0012,'/\u0006\u0002\u0003NA)ALa\u0014\u0003T%\u0019!\u0011K/\u0003\r=\u0003H/[8o!\u0011\tyM!\u0016\n\t\t]\u0013\u0011\u001b\u0002\u0010!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\u0006iB-\u001f8b[&\u001c7i\u001c8gS\u001e\u0004\u0016m]:x_J$WI\\2pI\u0016\u0014\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$B!!\u001a\u0003`!9!\u0011\r\u001bA\u0002\t\r\u0014\u0001\u0003>l\u00072LWM\u001c;\u0011\t\t\u0015$1N\u0007\u0003\u0005OR1A!\u001bU\u0003\tQ8.\u0003\u0003\u0003n\t\u001d$!D&bM.\f'l[\"mS\u0016tG/A\u0003dY\u0016\f'\u000f\u0006\u0002\u0002f\u0005\u0011\u0012\r\u001a3SK\u000e|gNZ5hkJ\f'\r\\3t)\u0011\t)Ga\u001e\t\u000f\ted\u00071\u0001\u0003|\u0005Y1.\u00194lCN+'O^3s!\rA&QP\u0005\u0004\u0005\u007f\u0012&aC&bM.\f'I]8lKJ\f\u0011#\u00193e%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)\u0011\t)G!\"\t\u000f\t\u001du\u00071\u0001\u0003\u0010\u0005q!/Z2p]\u001aLw-\u001e:bE2,\u0017aF1eI\n\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)\u0011\t)G!$\t\u000f\t\u001d\u0005\b1\u0001\u0003 \u0005!\"/Z7pm\u0016\u0014VmY8oM&<WO]1cY\u0016$B!!\u001a\u0003\u0014\"9!qQ\u001dA\u0002\t=\u0011a\u0007<fe&4\u0017PU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\u0006\u0003\u0002f\te\u0005b\u0002BNu\u0001\u0007\u0011\u0011Q\u0001\fG>tg-[4OC6,7/\u0001\ndkJ\u0014XM\u001c;LC\u001a\\\u0017mQ8oM&<\u0017aG2veJ,g\u000e\u001e#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7/\u0006\u0002\u0003$B91P!*\u00022\u0005E\u0012bAAaS\u0006a2-\u001e:sK:$H)\u001f8b[&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\u0018AE;qI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e$b!!\u001a\u0003.\n]\u0006b\u0002BX}\u0001\u0007!\u0011W\u0001\tEJ|7.\u001a:JIB\u0019ALa-\n\u0007\tUVLA\u0002J]RDqA!/?\u0001\u0004\ty'A\bqKJ\u001c\u0018n\u001d;f]R\u0004&o\u001c9t\u0003M)\b\u000fZ1uK\u0012+g-Y;mi\u000e{gNZ5h)\u0011\t)Ga0\t\u000f\tev\b1\u0001\u0002p\u0005)#/\u001a7pC\u0012,\u0006\u000fZ1uK\u00124\u0015\u000e\\3t/&$\bn\\;u\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0005\u0003K\u0012)\rC\u0004\u0003H\u0002\u0003\r!a\u001c\u0002\u00119,w\u000f\u0015:paN\f!$\\1zE\u0016\u001c%/Z1uKB\u000b7o]<pe\u0012,enY8eKJ$BA!\u0014\u0003N\"9!qZ!A\u0002\tE\u0017AB:fGJ,G\u000fE\u0003]\u0005\u001f\u0012\u0019\u000e\u0005\u0003\u0003V\nmWB\u0001Bl\u0015\u0011\u0011I.a)\u0002\u000bQL\b/Z:\n\t\tu'q\u001b\u0002\t!\u0006\u001c8o^8sI\u0006y\u0001/Y:to>\u0014H-\u00128d_\u0012,'/\u0006\u0002\u0003T\u0005\tBo\u001c)feNL7\u000f^3oiB\u0013x\u000e]:\u0015\r\u0005=$q\u001dBv\u0011\u001d\u0011Io\u0011a\u0001\u0003_\n1bY8oM&<\u0007K]8qg\"9\u00111P\"A\u0002\u0005\u001d\u0012a\u00054s_6\u0004VM]:jgR,g\u000e\u001e)s_B\u001cHCBA8\u0005c\u0014\u0019\u0010C\u0004\u0003:\u0012\u0003\r!a\u001c\t\u000f\u0005mD\t1\u0001\u0002(\u00051R.Y=cKJ+WI\\2pI\u0016\u0004\u0016m]:x_J$7\u000f\u0006\u0004\u0002p\te(1 \u0005\b\u0005s+\u0005\u0019AA8\u0011\u001d\u0011i0\u0012a\u0001\u0005\u007f\fQ\"\u00193nS:T6n\u00117jK:$\b\u0003\u0002B3\u0007\u0003IAaa\u0001\u0003h\ti\u0011\tZ7j]j[7\t\\5f]R\f1C^1mS\u0012\fG/\u001a3LC\u001a\\\u0017\r\u0015:paN$bAa)\u0004\n\r5\u0001bBB\u0006\r\u0002\u0007\u0011qN\u0001\u000eaJ|\u0007o](wKJ\u0014\u0018\u000eZ3\t\u000f\u0005md\t1\u0001\u0002(\u0005Aa/\u00197jI\u0006$X\r\u0006\u0004\u0002f\rM1Q\u0003\u0005\b\u0003[:\u0005\u0019AA8\u0011\u001d\tYh\u0012a\u0001\u0003O\tAC]3n_Z,\u0017J\u001c<bY&$7i\u001c8gS\u001e\u001cHCBA3\u00077\u0019i\u0002C\u0004\u0002n!\u0003\r!a\u001c\t\u000f\u0005m\u0004\n1\u0001\u0002(\u0005\u0001R.Y=cKJ+7m\u001c8gS\u001e,(/\u001a\u000b\t\u0003K\u001a\u0019c!\n\u0004*!9!qQ%A\u0002\t=\u0001bBB\u0014\u0013\u0002\u0007\u0011Q\\\u0001\n_2$7i\u001c8gS\u001eDqaa\u000bJ\u0001\u0004\u0019i#A\u0005oK^\u001cuN\u001c4jOB\"1qFB\u001b!!\t\t(a0\u00022\rE\u0002\u0003BB\u001a\u0007ka\u0001\u0001\u0002\u0007\u00048\r%\u0012\u0011!A\u0001\u0006\u0003\u0019IDA\u0002`IE\nBaa\u000f\u0004BA\u0019Al!\u0010\n\u0007\r}RLA\u0004O_RD\u0017N\\4\u0011\u0007q\u001b\u0019%C\u0002\u0004Fu\u00131!\u00118z\u00039)\b\u000fZ1uK\u0012\u001cuN\u001c4jON$baa\u0013\u0004\\\r\u001d\u0004c\u0002/\u0004N\rE\u0013\u0011Q\u0005\u0004\u0007\u001fj&A\u0002+va2,'\u0007\r\u0003\u0004T\r]\u0003c\u00024\u0002r\u0006E2Q\u000b\t\u0005\u0007g\u00199\u0006B\u0006\u0004Z)\u000b\t\u0011!A\u0003\u0002\re\"aA0%i!9!q\u0019&A\u0002\ru\u0003\u0007BB0\u0007G\u0002\u0002\"!\u001d\u0002@\u0006E2\u0011\r\t\u0005\u0007g\u0019\u0019\u0007\u0002\u0007\u0004f\rm\u0013\u0011!A\u0001\u0006\u0003\u0019IDA\u0002`IIBqa!\u001bK\u0001\u0004\u0019Y'\u0001\u0007dkJ\u0014XM\u001c;Qe>\u00048\u000f\r\u0003\u0004n\rE\u0004\u0003CA9\u0003\u007f\u000b\tda\u001c\u0011\t\rM2\u0011\u000f\u0003\r\u0007g\u001a9'!A\u0001\u0002\u000b\u00051\u0011\b\u0002\u0004?\u0012\u001a\u0014!D8wKJ\u0014\u0018\u000eZ3Qe>\u00048\u000f\u0006\u0004\u0002f\re41\u0010\u0005\b\u0003[Z\u0005\u0019AA\u007f\u0011\u001d\u0019Ya\u0013a\u0001\u0003{\f1#\u001e9eCR,7)\u001e:sK:$8i\u001c8gS\u001e\fa\u0003\u001d:pG\u0016\u001c8OU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0007\u0007\u0007\u001b9i!#\u0011\u000fq\u001bi%!8\u0004\u0006B1\u00111JA+\u0005?AqAa2N\u0001\u0004\u0011\u0019\u000bC\u0004\u0004\f6\u0003\r!a\n\u0002\u0019Y\fG.\u001b3bi\u0016|e\u000e\\=\u0002)9,W\rZ:SK\u000e|gNZ5hkJ\fG/[8o)!\t9c!%\u0004\u001a\u000eu\u0005bBBJ\u001d\u0002\u00071QS\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t!\u0019\t\tha&\u00022%\u0019A.a\u001d\t\u000f\rme\n1\u0001\u0002\u0002\u0006YQ\u000f\u001d3bi\u0016$7*Z=t\u0011\u001d\u0019yJ\u0014a\u0001\u0003\u0003\u000b1\u0002Z3mKR,GmS3zg\u0006i\u0002O]8dKN\u001cH*[:uK:,'OU3d_:4\u0017nZ;sC\ndW\r\u0006\u0007\u0002f\r\u00156QWB\\\u0007\u0007\u001c)\rC\u0004\u0004(>\u0003\ra!+\u0002-1L7\u000f^3oKJ\u0014VmY8oM&<WO]1cY\u0016\u0004Baa+\u000426\u00111Q\u0016\u0006\u0005\u0007_\u000b9+A\u0004oKR<xN]6\n\t\rM6Q\u0016\u0002\u0017\u0019&\u001cH/\u001a8feJ+7m\u001c8gS\u001e,(/\u00192mK\"911F(A\u0002\u0005u\u0007bBB]\u001f\u0002\u000711X\u0001\u000eGV\u001cHo\\7D_:4\u0017nZ:\u0011\u0011\u0005E\u0014qXA\u0019\u0007{\u00032A\\B`\u0013\r\u0019\tm\u001c\u0002\u0007\u001f\nTWm\u0019;\t\u000f\r-u\n1\u0001\u0002(!91qY(A\u0002\u0005\u001d\u0012A\u0003:fY>\fGm\u00148ms\u0006)\u0002O]8dKN\u001c(+Z2p]\u001aLw-\u001e:bE2,G\u0003DA3\u0007\u001b\u001cyma5\u0004b\u000e\u0015\bb\u0002BD!\u0002\u0007!q\u0002\u0005\b\u0007#\u0004\u0006\u0019AAA\u0003I)\b\u000fZ1uK\u0012\u001cuN\u001c4jO:\u000bW.Z:\t\u000f\rU\u0007\u000b1\u0001\u0004X\u0006i\u0011\r\u001c7OK^\u001cuN\u001c4jON\u0004Da!7\u0004^BA\u0011\u0011OA`\u0003c\u0019Y\u000e\u0005\u0003\u00044\ruG\u0001DBp\u0007'\f\t\u0011!A\u0003\u0002\re\"aA0%k!911\u001d)A\u0002\rm\u0016\u0001\u00058fo\u000e+8\u000f^8n\u0007>tg-[4t\u0011\u001d\u0019Y\t\u0015a\u0001\u0003O\u0001")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final Buffer<Reconfigurable> reconfigurables;
    private final Buffer<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties properties, boolean bl) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(properties, bl);
    }

    public static List<String> brokerConfigSynonyms(String string, boolean bl) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, bl);
    }

    public static boolean isPasswordConfig(String string) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(string);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    private Buffer<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private Buffer<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(KafkaZkClient zkClient) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()));
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(this.kafkaConfig().brokerId()));
        Properties brokerConfig = this.maybeReEncodePasswords(props, adminZkClient);
        this.updateBrokerConfig(this.kafkaConfig().brokerId(), brokerConfig);
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaBroker kafkaServer) {
        Authorizer authz;
        Option<Authorizer> option = kafkaServer.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        this.addReconfigurable(kafkaServer.kafkaYammerMetrics());
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer));
        this.addReconfigurable(new DynamicClientQuotaCallback(this.kafkaConfig().brokerId(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicThreadPool(kafkaServer));
        if (kafkaServer.logManager().cleaner() != null) {
            this.addBrokerReconfigurable(kafkaServer.logManager().cleaner());
        }
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
    }

    /*
     * WARNING - void declaration
     */
    public void addReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addBrokerReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$removeReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyReconfigurableConfigs(Set<String> configNames) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$1(configNames);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public KafkaConfig currentKafkaConfig() {
        KafkaConfig kafkaConfig;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            kafkaConfig = this.currentConfig();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return kafkaConfig;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicBrokerConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicBrokerConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicDefaultConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicDefaultConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public void updateBrokerConfig(int brokerId, Properties persistentProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateBrokerConfig$1(this, persistentProps, brokerId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateDefaultConfig(Properties persistentProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateDefaultConfig$1(this, persistentProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$1(this, newProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable & scala.Serializable)secret -> new PasswordEncoder((Password)secret, this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), this.kafkaConfig().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        void var3_3;
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)configProps.clone();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$1(this, perBrokerConfig, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        void var3_3;
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$5(this, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        void var3_3;
        Properties props = (Properties)persistentProps.clone();
        if (((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) {
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable & scala.Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, props, adminZkClient, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return var3_3;
    }

    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        Properties propsResolved = DynamicBrokerConfig$.MODULE$.resolveVariableConfigs(propsOverride);
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsResolved, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return newProps;
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Properties props, boolean perBrokerConfig) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$validate$1(this, props, perBrokerConfig);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala();
            return;
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.keys().foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Dynamic ").append(configSource).append(" config contains invalid values: ").append(invalidProps).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        if (((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) {
            reconfigurable.reconfigure(newConfig);
        }
    }

    private Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<String, ?> currentProps) {
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(newProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
        Set deletedKeySet = ((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(currentProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$2(newProps, x0$2)))).keySet();
        return new Tuple2((Object)changeMap, (Object)deletedKeySet);
    }

    /*
     * WARNING - void declaration
     */
    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(k, v) -> {
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)k, false).foreach((Function1 & Serializable & scala.Serializable)key -> props.remove(key));
            return props.put(k, v);
        };
        Map<String, String> map = Implicits$.MODULE$.MapExtensionMethods(propsOverride);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentConfig() {
        void var5_5;
        void var4_4;
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        KafkaConfig oldConfig = this.currentConfig();
        Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig newConfig = (KafkaConfig)((Object)tuple2._1());
        List brokerReconfigurablesToUpdate = (List)tuple2._2();
        void newConfig2 = var4_4;
        void brokerReconfigurablesToUpdate2 = var5_5;
        if (newConfig2 != this.currentConfig()) {
            this.currentConfig_$eq((KafkaConfig)newConfig2);
            this.kafkaConfig().updateCurrentConfig((KafkaConfig)newConfig2);
            brokerReconfigurablesToUpdate2.foreach(arg_0 -> DynamicBrokerConfig.$anonfun$updateCurrentConfig$1$adapted(oldConfig, (KafkaConfig)newConfig2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly) {
        void var6_6;
        void var5_5;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(newProps).asJava(), !validateOnly, (Option<DynamicBrokerConfig>)None$.MODULE$);
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeySet = (Set)tuple2._2();
        void changeMap2 = var5_5;
        void deletedKeySet2 = var6_6;
        if (changeMap2.nonEmpty() || deletedKeySet2.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                newConfig.valuesFromThisConfig().keySet().forEach(x$6 -> customConfigs.remove(x$6));
                this.reconfigurables().foreach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$2$adapted(this, newConfig, customConfigs, validateOnly, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, arg_0));
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().foreach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$3(this, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, newConfig, validateOnly, brokerReconfigurablesToUpdate, arg_0));
                return new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(newConfig.originalsFromThisConfig()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        }
        return new Tuple2((Object)this.currentConfig(), (Object)List$.MODULE$.empty());
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys, Set<String> deletedKeys) {
        return ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(updatedKeys)).nonEmpty() || ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(deletedKeys)).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        void var11_11;
        void var10_10;
        ListenerName listenerName = listenerReconfigurable.listenerName();
        java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
        java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newValues, oldValues);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeys = (Set)tuple2._2();
        void changeMap2 = var10_10;
        void deletedKeys2 = var11_11;
        Set updatedKeys = changeMap2.keySet();
        boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys, (Set<String>)deletedKeys2);
        if (reloadOnly != configsChanged) {
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        allNewConfigs.forEach((k, v) -> newConfigs.put((String)k, v));
        newConfigs.putAll(newCustomConfigs);
        try {
            reconfigurable.validateReconfiguration(newConfigs);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
        }
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" custom configs: ").append(newCustomConfigs).toString());
            reconfigurable.reconfigure(newConfigs);
        }
    }

    public static final /* synthetic */ Buffer $anonfun$addReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$1) {
        $this.verifyReconfigurableConfigs((Set<String>)((Set)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable$1.reconfigurableConfigs()).asScala()));
        return $this.reconfigurables().$plus$eq((Object)reconfigurable$1);
    }

    public static final /* synthetic */ Buffer $anonfun$addBrokerReconfigurable$1(DynamicBrokerConfig $this, BrokerReconfigurable reconfigurable$2) {
        $this.verifyReconfigurableConfigs(reconfigurable$2.reconfigurableConfigs());
        return $this.brokerReconfigurables().$plus$eq((Object)reconfigurable$2);
    }

    public static final /* synthetic */ Buffer $anonfun$removeReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$3) {
        return $this.reconfigurables().$minus$eq((Object)reconfigurable$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ void $anonfun$verifyReconfigurableConfigs$1(Set configNames$1) {
        Set nonDynamic = (Set)configNames$1.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
        Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicBrokerConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicBrokerConfigs().clone();
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicDefaultConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicDefaultConfigs().clone();
    }

    public static final /* synthetic */ void $anonfun$updateBrokerConfig$1(DynamicBrokerConfig $this, Properties persistentProps$1, int brokerId$1) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$1, true);
            $this.dynamicBrokerConfigs().clear();
            $this.dynamicBrokerConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig();
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId$1).append(" could not be applied: ").append(persistentProps$1).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateDefaultConfig$1(DynamicBrokerConfig $this, Properties persistentProps$2) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$2, false);
            $this.dynamicDefaultConfigs().clear();
            $this.dynamicDefaultConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig();
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps$2).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists(arg_0 -> DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(reconfigurable.reconfigurableConfigs(), arg_0));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            return;
        }
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(x0$1).toString());
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$1(DynamicBrokerConfig $this, Properties newProps$1) {
        ((IterableLike)$this.reconfigurables().filter((Function1 & Serializable & scala.Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4($this, newProps$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$3) {
        if (value != null) {
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$1(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$3, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.encodePassword$1(name, value, perBrokerConfig$1, props$3);
        }
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        if (invalidPropNames.nonEmpty()) {
            invalidPropNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        if (value != null) {
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                props$4.remove(configName);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$5(DynamicBrokerConfig $this, Properties props$4, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.decodePassword$1(name, value, props$4);
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$3(DynamicBrokerConfig $this, PasswordEncoder passwordDecoder$1, Properties props$5, String configName, String value2) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(configName) && value2 != null) {
            Some some;
            try {
                some = new Some((Object)passwordDecoder$1.decode(value2).value());
            }
            catch (Exception exception) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                some = None$.MODULE$;
            }
            some.foreach((Function1 & Serializable & scala.Serializable)value -> props$5.put(configName, $this.passwordEncoder().encode(new Password(value))));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, Properties props$5, AdminZkClient adminZkClient$1, PasswordEncoder passwordDecoder) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(configName, value) -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$3($this, passwordDecoder, props$5, configName, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$3).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$validate$1(DynamicBrokerConfig $this, Properties props$6, boolean perBrokerConfig$2) {
        Map<String, String> newProps = $this.validatedKafkaProps(props$6, perBrokerConfig$2);
        return $this.processReconfiguration(newProps, true);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        boolean bl;
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                bl = false;
            }
            catch (Exception exception) {
                bl = true;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String k = (String)x0$1._1();
        boolean bl = !BoxesRunTime.equals((Object)x0$1._2(), currentProps$1.get(k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$2(java.util.Map newProps$2, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        String k = (String)x0$2._1();
        boolean bl = !newProps$2.containsKey(k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            return;
        }
        if ($this.needsReconfiguration(x0$1.reconfigurableConfigs(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            $this.processReconfigurable(x0$1, (Set<String>)changeMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
            return;
        }
    }

    public static final /* synthetic */ Object $anonfun$processReconfiguration$3(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, Buffer brokerReconfigurablesToUpdate$1, BrokerReconfigurable reconfigurable) {
        if ($this.needsReconfiguration((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            reconfigurable.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                return brokerReconfigurablesToUpdate$1.$plus$eq((Object)reconfigurable);
            }
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
        this.staticBrokerConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(KafkaConfig$.MODULE$.defaultValues()).asJava()))).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.brokerReconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantReadWriteLock();
        this.currentConfig = kafkaConfig;
        this.dynamicConfigPasswordEncoder = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
    }

    public static final /* synthetic */ Object $anonfun$updateCurrentConfig$1$adapted(KafkaConfig oldConfig$2, KafkaConfig newConfig$2, BrokerReconfigurable x$4) {
        x$4.reconfigure(oldConfig$2, newConfig$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processReconfiguration$2$adapted(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        DynamicBrokerConfig.$anonfun$processReconfiguration$2($this, newConfig$3, customConfigs$1, validateOnly$1, changeMap$1, deletedKeySet$1, x0$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(java.util.Set eta$0$1$1, Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

