/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u000e\u001d\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\tC\u0003K\u0001\u0011\u00051\nC\u0004R\u0001\t\u0007I\u0011\u0002*\t\r}\u0003\u0001\u0015!\u0003T\u0011\u001d\u0001\u0007A1A\u0005\n\u0005Da\u0001\u001c\u0001!\u0002\u0013\u0011\u0007\"B7\u0001\t\u0003q\u0007\"B7\u0001\t\u0013)\b\"B>\u0001\t\u0013a\bBB@\u0001\t\u0013\t\t\u0001C\u0004\u0002\u001a\u0001!I!a\u0007\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003#\u0002A\u0011AA*\u0011\u001d\t9\u0006\u0001C\u0001\u0003'Bq!!\u0017\u0001\t\u0003\tI\u0005C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003w\u0002A\u0011AA=\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!!!\u0001\t\u0013\tIH\u0001\u000bMK\u0006$WM]#q_\u000eDg)\u001b7f\u0007\u0006\u001c\u0007.\u001a\u0006\u0003;y\tQ!\u001a9pG\"T!a\b\u0011\u0002\rM,'O^3s\u0015\u0005\t\u0013!B6bM.\f7\u0001A\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002,]5\tAF\u0003\u0002.A\u0005)Q\u000f^5mg&\u0011q\u0006\f\u0002\b\u0019><w-\u001b8h\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"A\r\u001e\u000e\u0003MR!\u0001N\u001b\u0002\r\r|W.\\8o\u0015\t\tcG\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<\u0017BA\u001e4\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fA\u0002\\8h\u000b:$wJ\u001a4tKR\u00042!\n A\u0013\tydEA\u0005Gk:\u001cG/[8oaA\u0011Q%Q\u0005\u0003\u0005\u001a\u0012A\u0001T8oO\u0006Q1\r[3dWB|\u0017N\u001c;\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001ds\u0012aC2iK\u000e\\\u0007o\\5oiNL!!\u0013$\u0003+1+\u0017\rZ3s\u000bB|7\r[\"iK\u000e\\\u0007o\\5oi\u00061A(\u001b8jiz\"B\u0001\u0014(P!B\u0011Q\nA\u0007\u00029!)\u0001\u0007\u0002a\u0001c!)A\b\u0002a\u0001{!)1\t\u0002a\u0001\t\u0006!An\\2l+\u0005\u0019\u0006C\u0001+^\u001b\u0005)&B\u0001,X\u0003\u0015awnY6t\u0015\tA\u0016,\u0001\u0006d_:\u001cWO\u001d:f]RT!AW.\u0002\tU$\u0018\u000e\u001c\u0006\u00029\u0006!!.\u0019<b\u0013\tqVK\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0003\u0015awnY6!\u0003\u0019)\u0007o\\2igV\t!\r\u0005\u0003dI\u001aLW\"A-\n\u0005\u0015L&a\u0002+sK\u0016l\u0015\r\u001d\t\u0003K\u001dL!\u0001\u001b\u0014\u0003\u0007%sG\u000f\u0005\u0002NU&\u00111\u000e\b\u0002\u000b\u000bB|7\r[#oiJL\u0018aB3q_\u000eD7\u000fI\u0001\u0007CN\u001c\u0018n\u001a8\u0015\u0007=\u00148\u000f\u0005\u0002&a&\u0011\u0011O\n\u0002\u0005+:LG\u000fC\u0003\u001e\u0013\u0001\u0007a\rC\u0003u\u0013\u0001\u0007\u0001)A\u0006ti\u0006\u0014Ho\u00144gg\u0016$HC\u0001<z!\t)s/\u0003\u0002yM\t9!i\\8mK\u0006t\u0007\"\u0002>\u000b\u0001\u0004I\u0017!B3oiJL\u0018\u0001I7bs\n,GK];oG\u0006$XMT8o\u001b>tw\u000e^8oS\u000e,e\u000e\u001e:jKN$\"a\\?\t\u000by\\\u0001\u0019A5\u0002\u00119,w/\u00128uef\fQB]3n_Z,gI]8n\u000b:$G\u0003BA\u0002\u0003\u001f\u0001R!!\u0002\u0002\f%l!!a\u0002\u000b\u0007\u0005%a%\u0001\u0006d_2dWm\u0019;j_:LA!!\u0004\u0002\b\t\u00191+Z9\t\u000f\u0005EA\u00021\u0001\u0002\u0014\u0005I\u0001O]3eS\u000e\fG/\u001a\t\u0006K\u0005U\u0011N^\u0005\u0004\u0003/1#!\u0003$v]\u000e$\u0018n\u001c82\u0003=\u0011X-\\8wK\u001a\u0013x.\\*uCJ$H\u0003BA\u0002\u0003;Aq!!\u0005\u000e\u0001\u0004\t\u0019\"A\nsK6|g/Z,iS2,W*\u0019;dQ&tw\r\u0006\u0004\u0002\u0004\u0005\r\u0012\u0011\t\u0005\b\u0003Kq\u0001\u0019AA\u0014\u0003!IG/\u001a:bi>\u0014\b#B2\u0002*\u00055\u0012bAA\u00163\nA\u0011\n^3sCR|'\u000f\u0005\u0004\u00020\u0005mb-\u001b\b\u0005\u0003c\t9D\u0004\u0003\u00024\u0005UR\"A.\n\u0005i[\u0016bAA\u001d3\u0006\u0019Q*\u00199\n\t\u0005u\u0012q\b\u0002\u0006\u000b:$(/\u001f\u0006\u0004\u0003sI\u0006bBA\t\u001d\u0001\u0007\u00111C\u0001\t]>tW)\u001c9usV\ta/A\u0006mCR,7\u000f^#oiJLXCAA&!\u0011)\u0013QJ5\n\u0007\u0005=cE\u0001\u0004PaRLwN\\\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007.\u0006\u0002\u0002VA!Q%!\u0014g\u00035\u0001(/\u001a<j_V\u001cX\t]8dQ\u0006iQ-\u0019:mS\u0016\u001cH/\u00128uef\fA\"\u001a8e\u001f\u001a47/\u001a;G_J$B!a\u0018\u0002fA)Q%!\u0019g\u0001&\u0019\u00111\r\u0014\u0003\rQ+\b\u000f\\33\u0011\u0019\t9\u0007\u0006a\u0001M\u0006q!/Z9vKN$X\rZ#q_\u000eD\u0017a\u0004;sk:\u001c\u0017\r^3Ge>lWI\u001c3\u0015\u0007=\fi\u0007\u0003\u0004\u0002pU\u0001\r\u0001Q\u0001\nK:$wJ\u001a4tKR\f\u0011\u0003\u001e:v]\u000e\fG/\u001a$s_6\u001cF/\u0019:u)\ry\u0017Q\u000f\u0005\u0006iZ\u0001\r\u0001Q\u0001\u000eG2,\u0017M]!oI\u001acWo\u001d5\u0015\u0003=\fQa\u00197fCJ\fA\"\u001a9pG\",e\u000e\u001e:jKN,\"!a\u0001\u0002\u000b\u0019dWo\u001d5")
public class LeaderEpochFileCache
implements Logging {
    private final Function0<Object> logEndOffset;
    private final LeaderEpochCheckpoint checkpoint;
    private final ReentrantReadWriteLock lock;
    private final TreeMap<Object, EpochEntry> epochs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private TreeMap<Object, EpochEntry> epochs() {
        return this.epochs;
    }

    public void assign(int epoch, long startOffset) {
        EpochEntry entry = new EpochEntry(epoch, startOffset);
        if (this.assign(entry)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Appended new epoch entry ").append(entry).append(". Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
            this.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean assign(EpochEntry entry) {
        boolean bl;
        void inWriteLock_lock;
        if (entry.epoch() < 0 || entry.startOffset() < 0L) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Received invalid partition leader epoch entry ").append(entry).toString());
        }
        if (!this.isUpdateNeeded$1(entry)) {
            return false;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            bl = LeaderEpochFileCache.$anonfun$assign$2(this, entry);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void maybeTruncateNonMonotonicEntries(EpochEntry newEntry) {
        void var3_3;
        EpochEntry removeFromEnd_removeWhileMatching_entry;
        EpochEntry epochEntry;
        Iterator removeFromEnd_removeWhileMatching_iterator = this.epochs().descendingMap().entrySet().iterator();
        ListBuffer removeFromEnd_removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeFromEnd_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$1(newEntry, epochEntry = (removeFromEnd_removeWhileMatching_entry = (EpochEntry)removeFromEnd_removeWhileMatching_iterator.next().getValue()))) {
            removeFromEnd_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromEnd_removeWhileMatching_entry);
            removeFromEnd_removeWhileMatching_iterator.remove();
        }
        if (var3_3.size() > 1 || var3_3.nonEmpty() && ((EpochEntry)var3_3.head()).startOffset() != newEntry.startOffset()) {
            this.warn((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$2(this, newEntry, (Seq)var3_3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeFromEnd(Function1<EpochEntry, Object> predicate) {
        void var3_3;
        EpochEntry removeWhileMatching_entry;
        Iterator removeWhileMatching_iterator = this.epochs().descendingMap().entrySet().iterator();
        ListBuffer removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeWhileMatching_iterator.hasNext() && BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)(removeWhileMatching_entry = (EpochEntry)removeWhileMatching_iterator.next().getValue())))) {
            removeWhileMatching_removedEpochs.$plus$eq((Object)removeWhileMatching_entry);
            removeWhileMatching_iterator.remove();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeFromStart(Function1<EpochEntry, Object> predicate) {
        void var3_3;
        EpochEntry removeWhileMatching_entry;
        Iterator<Map.Entry<Object, EpochEntry>> removeWhileMatching_iterator = this.epochs().entrySet().iterator();
        ListBuffer removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeWhileMatching_iterator.hasNext() && BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)(removeWhileMatching_entry = removeWhileMatching_iterator.next().getValue())))) {
            removeWhileMatching_removedEpochs.$plus$eq((Object)removeWhileMatching_entry);
            removeWhileMatching_iterator.remove();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeWhileMatching(Iterator<Map.Entry<Object, EpochEntry>> iterator, Function1<EpochEntry, Object> predicate) {
        void var3_3;
        ListBuffer removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (iterator.hasNext()) {
            EpochEntry entry = iterator.next().getValue();
            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)entry))) {
                removedEpochs.$plus$eq((Object)entry);
                iterator.remove();
                continue;
            }
            return removedEpochs;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean nonEmpty() {
        boolean bl;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            bl = LeaderEpochFileCache.$anonfun$nonEmpty$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public Option<EpochEntry> latestEntry() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$latestEntry$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    public Option<Object> latestEpoch() {
        Option<EpochEntry> option = this.latestEntry();
        if (option == null) {
            throw null;
        }
        Option<EpochEntry> map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((EpochEntry)map_this.get()).epoch()));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public Option<Object> previousEpoch() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$previousEpoch$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public Option<EpochEntry> earliestEntry() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$earliestEntry$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Object, Object> endOffsetFor(int requestedEpoch) {
        Tuple2 tuple2;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            tuple2 = LeaderEpochFileCache.$anonfun$endOffsetFor$1(this, requestedEpoch);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return tuple2;
    }

    /*
     * WARNING - void declaration
     */
    public void truncateFromEnd(long endOffset) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$truncateFromEnd$1(this, endOffset);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void truncateFromStart(long startOffset) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$truncateFromStart$1(this, startOffset);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clearAndFlush() {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$clearAndFlush$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clear() {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$clear$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public Seq<EpochEntry> epochEntries() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.epochs().values()).asScala()).toSeq();
    }

    private void flush() {
        this.checkpoint.write((Iterable<EpochEntry>)((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.epochs().values()).asScala()));
    }

    public static final /* synthetic */ void $anonfun$new$1(LeaderEpochFileCache $this) {
        $this.checkpoint.read().foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)$this.assign(entry)));
    }

    private final boolean isUpdateNeeded$1(EpochEntry entry$2) {
        boolean bl;
        Option<EpochEntry> option = this.latestEntry();
        if (option instanceof Some) {
            EpochEntry lastEntry = (EpochEntry)((Some)option).value();
            bl = entry$2.epoch() != lastEntry.epoch() || entry$2.startOffset() < lastEntry.startOffset();
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$assign$2(LeaderEpochFileCache $this, EpochEntry entry$2) {
        if ($this.isUpdateNeeded$1(entry$2)) {
            $this.maybeTruncateNonMonotonicEntries(entry$2);
            $this.epochs().put(BoxesRunTime.boxToInteger((int)entry$2.epoch()), entry$2);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$maybeTruncateNonMonotonicEntries$1(EpochEntry newEntry$1, EpochEntry entry) {
        return entry.epoch() >= newEntry$1.epoch() || entry.startOffset() >= newEntry$1.startOffset();
    }

    public static final /* synthetic */ String $anonfun$maybeTruncateNonMonotonicEntries$2(LeaderEpochFileCache $this, EpochEntry newEntry$1, Seq removedEpochs$1) {
        return new StringBuilder(88).append("New epoch entry ").append(newEntry$1).append(" caused truncation of conflicting entries ").append(removedEpochs$1).append(". ").append("Cache now contains ").append($this.epochs().size()).append(" entries.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$nonEmpty$1(LeaderEpochFileCache $this) {
        return !$this.epochs().isEmpty();
    }

    public static final /* synthetic */ EpochEntry $anonfun$latestEntry$2(Map.Entry x$1) {
        return (EpochEntry)x$1.getValue();
    }

    public static final /* synthetic */ Option $anonfun$latestEntry$1(LeaderEpochFileCache $this) {
        Option option = Option$.MODULE$.apply($this.epochs().lastEntry());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)LeaderEpochFileCache.$anonfun$latestEntry$2((Map.Entry)map_this.get()));
        return object;
    }

    public static final /* synthetic */ int $anonfun$previousEpoch$3(Map.Entry x$3) {
        return BoxesRunTime.unboxToInt(x$3.getKey());
    }

    public static final /* synthetic */ Option $anonfun$previousEpoch$1(LeaderEpochFileCache $this) {
        None$ none$;
        Option<EpochEntry> option = $this.latestEntry();
        if (option == null) {
            throw null;
        }
        Option<EpochEntry> flatMap_this = option;
        if (flatMap_this.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            EpochEntry epochEntry = (EpochEntry)flatMap_this.get();
            none$ = Option$.MODULE$.apply($this.epochs().lowerEntry(BoxesRunTime.boxToInteger((int)epochEntry.epoch())));
        }
        if (none$ == null) {
            throw null;
        }
        Object object = none$.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)LeaderEpochFileCache.$anonfun$previousEpoch$3((Map.Entry)none$.get())));
        return object;
    }

    public static final /* synthetic */ EpochEntry $anonfun$earliestEntry$2(Map.Entry x$4) {
        return (EpochEntry)x$4.getValue();
    }

    public static final /* synthetic */ Option $anonfun$earliestEntry$1(LeaderEpochFileCache $this) {
        Option option = Option$.MODULE$.apply($this.epochs().firstEntry());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)LeaderEpochFileCache.$anonfun$earliestEntry$2((Map.Entry)map_this.get()));
        return object;
    }

    public static final /* synthetic */ String $anonfun$endOffsetFor$2(LeaderEpochFileCache $this, int requestedEpoch$1, Tuple2 epochAndOffset$1) {
        return new StringBuilder(103).append("Processed end offset request for epoch ").append(requestedEpoch$1).append(" and returning epoch ").append(epochAndOffset$1._1$mcI$sp()).append(" ").append("with end offset ").append(epochAndOffset$1._2$mcJ$sp()).append(" from epoch cache of size ").append($this.epochs().size()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$endOffsetFor$1(LeaderEpochFileCache $this, int requestedEpoch$1) {
        void var2_4;
        Map.Entry<Object, EpochEntry> floorEntry;
        Map.Entry<Object, EpochEntry> higherEntry;
        Tuple2.mcIJ.sp epochAndOffset = requestedEpoch$1 == -1 ? new Tuple2.mcIJ.sp(-1, -1L) : ($this.latestEpoch().contains((Object)BoxesRunTime.boxToInteger((int)requestedEpoch$1)) ? new Tuple2.mcIJ.sp(requestedEpoch$1, $this.logEndOffset.apply$mcJ$sp()) : ((higherEntry = $this.epochs().higherEntry(BoxesRunTime.boxToInteger((int)requestedEpoch$1))) == null ? new Tuple2.mcIJ.sp(-1, -1L) : ((floorEntry = $this.epochs().floorEntry(BoxesRunTime.boxToInteger((int)requestedEpoch$1))) == null ? new Tuple2.mcIJ.sp(requestedEpoch$1, higherEntry.getValue().startOffset()) : new Tuple2.mcIJ.sp(floorEntry.getValue().epoch(), higherEntry.getValue().startOffset()))));
        $this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$endOffsetFor$2($this, requestedEpoch$1, (Tuple2)epochAndOffset)));
        return var2_4;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$2(long endOffset$1, EpochEntry x$5) {
        return x$5.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$3(long endOffset$1, EpochEntry x$6) {
        return x$6.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ String $anonfun$truncateFromEnd$4(LeaderEpochFileCache $this, Seq removedEntries$1, long endOffset$1) {
        return new StringBuilder(97).append("Cleared entries ").append(removedEntries$1).append(" from epoch cache after ").append("truncating to end offset ").append(endOffset$1).append(", leaving ").append($this.epochs().size()).append(" entries in the cache.").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$truncateFromEnd$1(LeaderEpochFileCache $this, long endOffset$1) {
        if (endOffset$1 >= 0L) {
            EpochEntry epochEntry;
            Option<EpochEntry> option = $this.latestEntry();
            if (option == null) {
                throw null;
            }
            Option<EpochEntry> exists_this = option;
            boolean bl = !exists_this.isEmpty() && LeaderEpochFileCache.$anonfun$truncateFromEnd$2(endOffset$1, epochEntry = (EpochEntry)exists_this.get());
            if (bl) {
                void var6_6;
                EpochEntry removeFromEnd_removeWhileMatching_entry;
                EpochEntry epochEntry2;
                Iterator removeFromEnd_removeWhileMatching_iterator = $this.epochs().descendingMap().entrySet().iterator();
                ListBuffer removeFromEnd_removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
                while (removeFromEnd_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset$1, epochEntry2 = (removeFromEnd_removeWhileMatching_entry = (EpochEntry)removeFromEnd_removeWhileMatching_iterator.next().getValue()))) {
                    removeFromEnd_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromEnd_removeWhileMatching_entry);
                    removeFromEnd_removeWhileMatching_iterator.remove();
                }
                $this.flush();
                $this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$truncateFromEnd$4($this, (Seq)var6_6, endOffset$1)));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromStart$2(long startOffset$1, EpochEntry entry) {
        return entry.startOffset() <= startOffset$1;
    }

    public static final /* synthetic */ void $anonfun$truncateFromStart$3(LeaderEpochFileCache $this, long startOffset$1, Seq removedEntries$2, EpochEntry firstBeforeStartOffset) {
        EpochEntry updatedFirstEntry = new EpochEntry(firstBeforeStartOffset.epoch(), startOffset$1);
        $this.epochs().put(BoxesRunTime.boxToInteger((int)updatedFirstEntry.epoch()), updatedFirstEntry);
        $this.flush();
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Cleared entries ").append(removedEntries$2).append(" and rewrote first entry ").append(updatedFirstEntry).append(" after ").append("truncating to start offset ").append(startOffset$1).append(", leaving ").append($this.epochs().size()).append(" in the cache.").toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$truncateFromStart$1(LeaderEpochFileCache $this, long startOffset$1) {
        void var5_3;
        EpochEntry removeFromStart_removeWhileMatching_entry;
        EpochEntry epochEntry;
        Iterator<Map.Entry<Object, EpochEntry>> removeFromStart_removeWhileMatching_iterator = $this.epochs().entrySet().iterator();
        ListBuffer removeFromStart_removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeFromStart_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset$1, epochEntry = (removeFromStart_removeWhileMatching_entry = removeFromStart_removeWhileMatching_iterator.next().getValue()))) {
            removeFromStart_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromStart_removeWhileMatching_entry);
            removeFromStart_removeWhileMatching_iterator.remove();
        }
        Option option = var5_3.lastOption();
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            EpochEntry epochEntry2 = (EpochEntry)foreach_this.get();
            LeaderEpochFileCache.$anonfun$truncateFromStart$3($this, startOffset$1, (Seq)var5_3, epochEntry2);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$clearAndFlush$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
        $this.flush();
    }

    public static final /* synthetic */ void $anonfun$clear$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
    }

    /*
     * WARNING - void declaration
     */
    public LeaderEpochFileCache(TopicPartition topicPartition, Function0<Object> logEndOffset, LeaderEpochCheckpoint checkpoint) {
        void inWriteLock_lock;
        this.logEndOffset = logEndOffset;
        this.checkpoint = checkpoint;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(20).append("[LeaderEpochCache ").append(topicPartition).append("] ").toString());
        this.lock = new ReentrantReadWriteLock();
        this.epochs = new TreeMap();
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$new$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public static final /* synthetic */ Object $anonfun$maybeTruncateNonMonotonicEntries$1$adapted(EpochEntry newEntry$1, EpochEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$1(newEntry$1, entry));
    }

    public static final /* synthetic */ Object $anonfun$latestEpoch$1$adapted(EpochEntry x$2) {
        return BoxesRunTime.boxToInteger((int)x$2.epoch());
    }

    public static final /* synthetic */ Object $anonfun$previousEpoch$3$adapted(Map.Entry x$3) {
        return BoxesRunTime.boxToInteger((int)LeaderEpochFileCache.$anonfun$previousEpoch$3(x$3));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromEnd$2$adapted(long endOffset$1, EpochEntry x$5) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$2(endOffset$1, x$5));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromEnd$3$adapted(long endOffset$1, EpochEntry x$6) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset$1, x$6));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromStart$2$adapted(long startOffset$1, EpochEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset$1, entry));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromStart$3$adapted(LeaderEpochFileCache $this, long startOffset$1, Seq removedEntries$2, EpochEntry firstBeforeStartOffset) {
        LeaderEpochFileCache.$anonfun$truncateFromStart$3($this, startOffset$1, removedEntries$2, firstBeforeStartOffset);
        return BoxedUnit.UNIT;
    }
}

