/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}a\u0001\u0002\u0011\"\u0001\u0019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006q\u0001!\t!\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\bO\u0002\t\n\u0011\"\u0001i\u0011\u001d\u0019\b!%A\u0005\u0002QDQA\u001e\u0001\u0005\u0002]D\u0001\"!\u0005\u0001#\u0003%\t\u0001\u001e\u0005\n\u0003'\u0001\u0011\u0013!C\u0001\u0003+Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003wB\u0011\"a \u0001#\u0003%\t!!!\t\u0013\u0005\u0015\u0005!%A\u0005\u0002\u0005\u001d\u0005bBAF\u0001\u0011%\u0011Q\u0012\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!!/\u0001\t\u0003\tY\fC\u0004\u0002D\u0002!\t!!2\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0003;\u0004A\u0011AAt\u0011\u001d\ti\u000f\u0001C\u0001\u0003_Dq!a=\u0001\t\u0013\t)\u0010C\u0004\u0003\u0002\u0001!\tAa\u0001\t\u000f\t%\u0001\u0001\"\u0001\u0003\f!9!q\u0002\u0001\u0005\u0002\tE\u0001b\u0002B\u000b\u0001\u0011\u0005!q\u0003\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u000b\u0005\t\u001a\u0013A\u0001>l\u0015\u0005!\u0013!B6bM.\f7\u0001A\n\u0004\u0001\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/c5\tqF\u0003\u00021G\u0005)Q\u000f^5mg&\u0011!g\f\u0002\b\u0019><w-\u001b8h\u0003!Q8n\u00117jK:$\bCA\u001b7\u001b\u0005\t\u0013BA\u001c\"\u00055Y\u0015MZ6b5.\u001cE.[3oi\u00061A(\u001b8jiz\"\"AO\u001e\u0011\u0005U\u0002\u0001\"B\u001a\u0003\u0001\u0004!\u0014aC2sK\u0006$X\rV8qS\u000e$bAP!O'V{\u0006C\u0001\u0015@\u0013\t\u0001\u0015F\u0001\u0003V]&$\b\"\u0002\"\u0004\u0001\u0004\u0019\u0015!\u0002;pa&\u001c\u0007C\u0001#L\u001d\t)\u0015\n\u0005\u0002GS5\tqI\u0003\u0002IK\u00051AH]8pizJ!AS\u0015\u0002\rA\u0013X\rZ3g\u0013\taUJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0015&BQaT\u0002A\u0002A\u000b!\u0002]1si&$\u0018n\u001c8t!\tA\u0013+\u0003\u0002SS\t\u0019\u0011J\u001c;\t\u000bQ\u001b\u0001\u0019\u0001)\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0004W\u0007A\u0005\t\u0019A,\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u00031vk\u0011!\u0017\u0006\u00035n\u000bA!\u001e;jY*\tA,\u0001\u0003kCZ\f\u0017B\u00010Z\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\bA\u000e\u0001\n\u00111\u0001b\u00035\u0011\u0018mY6Bo\u0006\u0014X-T8eKB\u0011!-Z\u0007\u0002G*\u0011AmI\u0001\u0006C\u0012l\u0017N\\\u0005\u0003M\u000e\u0014QBU1dW\u0006;\u0018M]3N_\u0012,\u0017!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$H\u0005N\u000b\u0002S*\u0012qK[\u0016\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001]\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002s[\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%kU\tQO\u000b\u0002bU\u0006\u0011r-\u001a;Ce>\\WM]'fi\u0006$\u0017\r^1t)\u0015A\u00181AA\u0003!\rIHP`\u0007\u0002u*\u001110K\u0001\u000bG>dG.Z2uS>t\u0017BA?{\u0005\r\u0019V-\u001d\t\u0003E~L1!!\u0001d\u00059\u0011%o\\6fe6+G/\u00193bi\u0006Dq\u0001\u0019\u0004\u0011\u0002\u0003\u0007\u0011\rC\u0005\u0002\b\u0019\u0001\n\u00111\u0001\u0002\n\u0005Q!M]8lKJd\u0015n\u001d;\u0011\u000b!\nY!a\u0004\n\u0007\u00055\u0011F\u0001\u0004PaRLwN\u001c\t\u0004sr\u0004\u0016\u0001H4fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCN$C-\u001a4bk2$H%M\u0001\u001dO\u0016$(I]8lKJlU\r^1eCR\f7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t9BK\u0002\u0002\n)\f\u0011d\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oiR9a(!\b\u0002 \u0005\r\u0002\"\u0002\"\n\u0001\u0004\u0019\u0005BBA\u0011\u0013\u0001\u0007q+\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0003KI\u0001\u0019AA\u0014\u0003i\u0001\u0018M\u001d;ji&|gNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\u0019I\u0018\u0011\u0006)\u0002\u0010%\u0019\u00111\u0006>\u0003\u00075\u000b\u0007/A\nwC2LG-\u0019;f)>\u0004\u0018nY\"sK\u0006$X\rF\u0004?\u0003c\t\u0019$!\u000e\t\u000b\tS\u0001\u0019A\"\t\u000f\u0005\u0015\"\u00021\u0001\u0002(!1\u0011\u0011\u0005\u0006A\u0002]\u000bQd\u001e:ji\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u000b\b}\u0005m\u0012QHA(\u0011\u0015\u00115\u00021\u0001D\u0011\u001d\tyd\u0003a\u0001\u0003\u0003\n\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\u0019I\u0018\u0011\u0006)\u0002DA!\u0011QIA&\u001b\t\t9EC\u0002\u0002J\r\n!bY8oiJ|G\u000e\\3s\u0013\u0011\ti%a\u0012\u0003#I+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fC\u0004\u0002R-\u0001\r!a\u0015\u0002\u0011%\u001cX\u000b\u001d3bi\u0016\u00042\u0001KA+\u0013\r\t9&\u000b\u0002\b\u0005>|G.Z1o\u0003-!W\r\\3uKR{\u0007/[2\u0015\u0007y\ni\u0006C\u0003C\u0019\u0001\u00071)A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u000f\u0003O\t\u0019'!\u001a\u0002j\u00055\u0014\u0011OA;\u0011\u0015\u0011U\u00021\u0001D\u0011\u001d\t9'\u0004a\u0001\u0003\u0003\n!#\u001a=jgRLgnZ!tg&<g.\\3oi\"1\u00111N\u0007A\u0002a\f!\"\u00197m\u0005J|7.\u001a:t\u0011!\ty'\u0004I\u0001\u0002\u0004\u0001\u0016!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0005\u0002@5\u0001\n\u00111\u0001\u0002tA)\u0001&a\u0003\u0002(!I\u0011qO\u0007\u0011\u0002\u0003\u0007\u00111K\u0001\rm\u0006d\u0017\u000eZ1uK>sG._\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIQ*\"!! +\u0005AS\u0017aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t\u0019IK\u0002\u0002t)\fq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005%%fAA*U\u0006Ib/\u00197jI\u0006$XMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u001dq\u0014qRAI\u0003+Cq!a\u0010\u0012\u0001\u0004\t9\u0003\u0003\u0004\u0002\u0014F\u0001\r\u0001U\u0001\u001aKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0004\u0002\u0018F\u0001\r!!'\u0002%\u00054\u0018-\u001b7bE2,'I]8lKJLEm\u001d\t\u0005\t\u0006m\u0005+C\u0002\u0002\u001e6\u00131aU3u\u0003-\u0001\u0018M]:f\u0005J|7.\u001a:\u0015\t\u0005\r\u0016Q\u0015\t\u0005Q\u0005-\u0001\u000b\u0003\u0004\u0002(J\u0001\raQ\u0001\u0007EJ|7.\u001a:\u0002\u001b\rD\u0017M\\4f\u0007>tg-[4t)\u001dq\u0014QVAY\u0003kCa!a,\u0014\u0001\u0004\u0019\u0015AC3oi&$\u0018\u0010V=qK\"1\u00111W\nA\u0002\r\u000b!\"\u001a8uSRLh*Y7f\u0011\u0019\t9l\u0005a\u0001/\u000691m\u001c8gS\u001e\u001c\u0018\u0001F2iC:<Wm\u00117jK:$\u0018\nZ\"p]\u001aLw\rF\u0003?\u0003{\u000b\t\r\u0003\u0004\u0002@R\u0001\raQ\u0001\u0012g\u0006t\u0017\u000e^5{K\u0012\u001cE.[3oi&#\u0007BBA\\)\u0001\u0007q+\u0001\u0010dQ\u0006tw-Z+tKJ|%/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\u001cuN\u001c4jOR)a(a2\u0002L\"1\u0011\u0011Z\u000bA\u0002\r\u000b1c]1oSRL'0\u001a3F]RLG/\u001f(b[\u0016Da!a.\u0016\u0001\u00049\u0016a\u0005<bY&$\u0017\r^3U_BL7mQ8oM&<G#\u0002 \u0002R\u0006M\u0007\"\u0002\"\u0017\u0001\u0004\u0019\u0005BBA\\-\u0001\u0007q+A\tdQ\u0006tw-\u001a+pa&\u001c7i\u001c8gS\u001e$RAPAm\u00037DQAQ\fA\u0002\rCa!a.\u0018\u0001\u00049\u0016AE2iC:<WM\u0011:pW\u0016\u00148i\u001c8gS\u001e$RAPAq\u0003KDq!a9\u0019\u0001\u0004\ty!A\u0004ce>\\WM]:\t\r\u0005]\u0006\u00041\u0001X)\u0015q\u0014\u0011^Av\u0011\u001d\t9+\u0007a\u0001\u0003GCa!a.\u001a\u0001\u00049\u0016\u0001\u0006<bY&$\u0017\r^3Ce>\\WM]\"p]\u001aLw\rF\u0002?\u0003cDa!a.\u001b\u0001\u00049\u0016AE2iC:<W-\u00128uSRL8i\u001c8gS\u001e$rAPA|\u0003w\fy\u0010\u0003\u0004\u0002zn\u0001\raQ\u0001\u000fe>|G/\u00128uSRLH+\u001f9f\u0011\u0019\tip\u0007a\u0001\u0007\u00069b-\u001e7m'\u0006t\u0017\u000e^5{K\u0012,e\u000e^5us:\u000bW.\u001a\u0005\u0007\u0003o[\u0002\u0019A,\u0002#\u0019,Go\u00195F]RLG/_\"p]\u001aLw\rF\u0003X\u0005\u000b\u00119\u0001\u0003\u0004\u0002zr\u0001\ra\u0011\u0005\u0007\u0003\u0013d\u0002\u0019A\"\u0002%\u001d,G/\u00117m)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u0003\u0005\u001b\u0001R!_A\u0015\u0007^\u000bQCZ3uG\"\fE\u000e\\#oi&$\u0018pQ8oM&<7\u000f\u0006\u0003\u0003\u000e\tM\u0001BBAX=\u0001\u00071)\u0001\u000egKR\u001c\u0007.\u00117m\u0007\"LG\u000eZ#oi&$\u0018pQ8oM&<7\u000f\u0006\u0004\u0003\u000e\te!1\u0004\u0005\u0007\u0003s|\u0002\u0019A\"\t\r\tuq\u00041\u0001D\u0003=\u0019\u0007.\u001b7e\u000b:$\u0018\u000e^=UsB,\u0007")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map<Object, Seq<Object>> replicaAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.createTopicWithAssignment(topic, topicConfig, replicaAssignment);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        None$ none$;
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        if (brokerList == null) {
            throw null;
        }
        if (brokerList.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            Seq seq = (Seq)brokerList.get();
            none$ = new Some((Object)AdminZkClient.$anonfun$getBrokerMetadatas$1(allBrokers, seq));
        }
        if (none$ == null) {
            throw null;
        }
        Object object = none$.isEmpty() ? allBrokers : none$.get();
        Object brokers = object;
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode2 != null ? !rackAwareMode2.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack()), Seq$.MODULE$.canBuildFrom()));
        return (Seq)seq.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, Seq<Object>> partitionReplicaAssignment) {
        this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append("assignment ").append(partitionReplicaAssignment).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)((Map)partitionReplicaAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                Seq v = (Seq)x0$1._2();
                ReplicaAssignment replicaAssignment = ReplicaAssignment$.MODULE$.apply((Seq<Object>)v);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())), false);
    }

    public void validateTopicCreate(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            Set<String> allTopics = this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1());
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            Set collidingTopics = (Set)allTopics.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable & scala.Serializable)reps -> {
            AdminZkClient.$anonfun$validateTopicCreate$3(partitionReplicaAssignment, reps);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((TraversableOnce)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig$.MODULE$.validate(config);
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate) {
        try {
            scala.collection.immutable.Map assignment = ((TraversableOnce)replicaAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int partitionId = x0$1._1$mcI$sp();
                ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (!isUpdate) {
                this.zkClient.createTopicAssignment(topic, (Map<TopicPartition, Seq<Object>>)((Map)assignment.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    void $minus$greater$extension_y;
                    void $minus$greater$extension_$this;
                    if (x0$2 != null) {
                        TopicPartition k = (TopicPartition)x0$2._1();
                        ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                        Seq<Object> seq = v.replicas();
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                    } else {
                        throw new MatchError(null);
                    }
                    Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    return tuple2;
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())));
            } else {
                this.zkClient.setTopicAssignment(topic, (Map<TopicPartition, ReplicaAssignment>)assignment, this.zkClient.setTopicAssignment$default$3());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                String string = "Updated path %s with %s for replica assignment";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment}));
            });
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                String string = "topic %s is already marked for deletion";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                throw new TopicAlreadyMarkedForDeletionException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, Seq<Object>> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable & scala.Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
        }
        if (replicaAssignment == null) {
            throw null;
        }
        if (!replicaAssignment.isEmpty()) {
            Map map = (Map)replicaAssignment.get();
            this.validateReplicaAssignment((Map<Object, Seq<Object>>)map, existingAssignmentPartition0.size(), (Set<Object>)((TraversableOnce)allBrokers.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Seq$.MODULE$.canBuildFrom())).toSet());
        }
        Object object = replicaAssignment.isEmpty() ? AdminZkClient.$anonfun$addPartitions$4(allBrokers, existingAssignmentPartition0, partitionsToAdd, existingAssignment) : replicaAssignment.get();
        Map proposedAssignmentForNewPartitions = (Map)object;
        Map proposedAssignment = existingAssignment.$plus$plus((GenTraversableOnce)proposedAssignmentForNewPartitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                int tp = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                ReplicaAssignment replicaAssignment = ReplicaAssignment$.MODULE$.apply((Seq<Object>)replicas, (Seq<Object>)Nil$.MODULE$, (Seq<Object>)Nil$.MODULE$);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Creating ").append(partitionsToAdd).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(proposedAssignmentForNewPartitions).append(".").toString());
            this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)proposedAssignment, true);
        }
        return (Map)proposedAssignment.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$2 != null) {
                int k = x0$2._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                Seq<Object> seq = v.replicas();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    private void validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, int expectedReplicationFactor, Set<Object> availableBrokerIds) {
        replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                int partitionId = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                if (replicas.isEmpty()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
                }
                if (replicas.size() != replicas.toSet().size()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(replicas.mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
                }
                if (!replicas.toSet().subsetOf((GenSet)availableBrokerIds)) {
                    throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(replicas.mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds.mkString(", ")).append(".").toString());
                }
                Integer n = BoxesRunTime.boxToInteger((int)replicas.size());
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        });
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new scala.Serializable(null, expectedReplicationFactor){
            public static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    Seq replicas = (Seq)x1._2();
                    if (replicas.size() != this.expectedReplicationFactor$1) {
                        void $minus$greater$extension_y;
                        void $minus$greater$extension_$this;
                        Integer n = BoxesRunTime.boxToInteger((int)replicas.size());
                        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition));
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        object = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                boolean bl = x1 != null && ((Seq)x1._2()).size() != this.expectedReplicationFactor$1;
                return bl;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$2)), (Ordering)Ordering.Int$.MODULE$);
            Seq partitions = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$3)), Seq$.MODULE$.canBuildFrom());
            Seq repFactors = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$4)), Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        None$ none$;
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            try {
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                some = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(broker).toInt()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
            }
            none$ = some;
        }
        return none$;
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(49).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.Topic()).append(", ").append(ConfigType$.MODULE$.Client()).append(", ").append(ConfigType$.MODULE$.Broker()).toString());
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            String string = "Topic \"%s\" does not exist.";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new AdminOperationException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        LogConfig$.MODULE$.validate(configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)broker)).toString(), configs));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        if (broker == null) {
            throw null;
        }
        Object object = broker.isEmpty() ? None$.MODULE$ : new Some((Object)AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)broker.get())));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? ConfigEntityName$.MODULE$.Default() : object.get();
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)object2, configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder(0).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((TraversableOnce)this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1()).map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((TraversableOnce)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable & scala.Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable & scala.Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(0).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Seq $anonfun$getBrokerMetadatas$1(Seq allBrokers$1, Seq brokerIds) {
        return (Seq)allBrokers$1.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))));
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$3(Map partitionReplicaAssignment$2, Seq reps) {
        if (reps.size() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$7) {
        return x$7.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Map $anonfun$addPartitions$4(Seq allBrokers$2, Seq existingAssignmentPartition0$1, int partitionsToAdd$1, Map existingAssignment$1) {
        int startIndex = package$.MODULE$.max(0, allBrokers$2.indexWhere((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$addPartitions$5(existingAssignmentPartition0$1, x$7))));
        return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)allBrokers$2, partitionsToAdd$1, existingAssignmentPartition0$1.size(), startIndex, existingAssignment$1.size());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$2) {
        void var1_1;
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        int partitionId = x0$2._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$3) {
        void var1_1;
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        int partitionId = x0$3._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$4) {
        void var1_1;
        if (x0$4 == null) {
            throw new MatchError(null);
        }
        int rf = x0$4._2$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$8) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$8)).toString();
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        Seq seq;
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(0).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        Seq entityNames = this.zkClient.getAllEntitiesWithConfig(string);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            seq = (Seq)entityNames.map((Function1 & Serializable & scala.Serializable)entityName -> new StringBuilder(0).append(path).append('/').append((String)entityName).toString(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(rootPath)) {
            seq = entityNames;
        } else {
            throw new MatchError((Object)rootPath);
        }
        return seq;
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$addPartitions$2$adapted(AdminZkClient $this, Seq existingAssignmentPartition0$1, Seq allBrokers$2, Map proposedReplicaAssignment) {
        $this.validateReplicaAssignment((Map<Object, Seq<Object>>)proposedReplicaAssignment, existingAssignmentPartition0$1.size(), (Set<Object>)((TraversableOnce)allBrokers$2.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Seq$.MODULE$.canBuildFrom())).toSet());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2$adapted(Object x$8) {
        return AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$8));
    }
}

