/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.CachedPartition;
import kafka.server.EvictableKey;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.LastUsedKey;
import kafka.utils.Logging;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001\u0002\u000f\u001e\u0001\tB\u0001\"\u000e\u0001\u0003\u0006\u0004%IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001BC\u0002\u0013%A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d9\u0005\u00011A\u0005\nqBq\u0001\u0013\u0001A\u0002\u0013%\u0011\n\u0003\u0004P\u0001\u0001\u0006K!\u0010\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019i\u0006\u0001)A\u0005%\"9a\f\u0001b\u0001\n\u0013y\u0006BB6\u0001A\u0003%\u0001\rC\u0004m\u0001\t\u0007I\u0011B7\t\rI\u0004\u0001\u0015!\u0003o\u0011\u001d\u0019\bA1A\u0005\n5Da\u0001\u001e\u0001!\u0002\u0013q\u0007bB;\u0001\u0005\u0004%\tA\u001e\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003x\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aa!!\u0006\u0001\t\u00031\u0004BBA\f\u0001\u0011\u0005A\bC\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003+\u0002A\u0011AA.\u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\u0012\u0011CR3uG\"\u001cVm]:j_:\u001c\u0015m\u00195f\u0015\tqr$\u0001\u0004tKJ4XM\u001d\u0006\u0002A\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001$S=\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017 \u0003\u0015)H/\u001b7t\u0013\tq3FA\u0004M_\u001e<\u0017N\\4\u0011\u0005A\u001aT\"A\u0019\u000b\u0005Iz\u0012aB7fiJL7m]\u0005\u0003iE\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003)i\u0017\r_#oiJLWm]\u000b\u0002oA\u0011A\u0005O\u0005\u0003s\u0015\u00121!\u00138u\u0003-i\u0017\r_#oiJLWm\u001d\u0011\u0002\u0015\u00154\u0018n\u0019;j_:l5/F\u0001>!\t!c(\u0003\u0002@K\t!Aj\u001c8h\u0003-)g/[2uS>tWj\u001d\u0011\u0002\rqJg.\u001b;?)\r\u0019UI\u0012\t\u0003\t\u0002i\u0011!\b\u0005\u0006k\u0015\u0001\ra\u000e\u0005\u0006w\u0015\u0001\r!P\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0002#9,X\u000eU1si&$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002K\u001bB\u0011AeS\u0005\u0003\u0019\u0016\u0012A!\u00168ji\"9ajBA\u0001\u0002\u0004i\u0014a\u0001=%c\u0005qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001C:fgNLwN\\:\u0016\u0003I\u0003Ba\u0015-856\tAK\u0003\u0002V-\u00069Q.\u001e;bE2,'BA,&\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00033R\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002E7&\u0011A,\b\u0002\r\r\u0016$8\r[*fgNLwN\\\u0001\ng\u0016\u001c8/[8og\u0002\n\u0001\u0002\\1tiV\u001bX\rZ\u000b\u0002AB!\u0011M\u001a5[\u001b\u0005\u0011'BA2e\u0003\u0011)H/\u001b7\u000b\u0003\u0015\fAA[1wC&\u0011qM\u0019\u0002\b)J,W-T1q!\t!\u0015.\u0003\u0002k;\tYA*Y:u+N,GmS3z\u0003%a\u0017m\u001d;Vg\u0016$\u0007%\u0001\bfm&\u001cG/\u00192mK\nK\u0018\t\u001c7\u0016\u00039\u0004B!\u00194p5B\u0011A\t]\u0005\u0003cv\u0011A\"\u0012<jGR\f'\r\\3LKf\fq\"\u001a<jGR\f'\r\\3Cs\u0006cG\u000eI\u0001\u0016KZL7\r^1cY\u0016\u0014\u0015\u0010\u0015:jm&dWmZ3e\u0003Y)g/[2uC\ndWMQ=Qe&4\u0018\u000e\\3hK\u0012\u0004\u0013AD3wS\u000e$\u0018n\u001c8t\u001b\u0016$XM]\u000b\u0002oB\u0019\u00010!\u0001\u000e\u0003eT!A_>\u0002\t\r|'/\u001a\u0006\u0003eqT!! @\u0002\re\fW.\\3s\u0015\u0005y\u0018aA2p[&\u0019\u00111A=\u0003\u000b5+G/\u001a:\u0002\u001f\u00154\u0018n\u0019;j_:\u001cX*\u001a;fe\u0002\n1aZ3u)\u0011\tY!!\u0005\u0011\t\u0011\niAW\u0005\u0004\u0003\u001f)#AB(qi&|g\u000e\u0003\u0004\u0002\u0014M\u0001\raN\u0001\ng\u0016\u001c8/[8o\u0013\u0012\fAa]5{K\u0006yAo\u001c;bYB\u000b'\u000f^5uS>t7/\u0001\u0007oK^\u001cVm]:j_:LE\rF\u00018\u0003Ii\u0017-\u001f2f\u0007J,\u0017\r^3TKN\u001c\u0018n\u001c8\u0015\u0013]\n\t#!\n\u00020\u0005E\u0002BBA\u0012/\u0001\u0007Q(A\u0002o_^Dq!a\n\u0018\u0001\u0004\tI#\u0001\u0006qe&4\u0018\u000e\\3hK\u0012\u00042\u0001JA\u0016\u0013\r\ti#\n\u0002\b\u0005>|G.Z1o\u0011\u0019\t)b\u0006a\u0001o!9\u00111G\fA\u0002\u0005U\u0012\u0001E2sK\u0006$X\rU1si&$\u0018n\u001c8t!\u0015!\u0013qGA\u001e\u0013\r\tI$\n\u0002\n\rVt7\r^5p]B\u0002B!!\u0010\u0002D9\u0019A)a\u0010\n\u0007\u0005\u0005S$\u0001\u0007GKR\u001c\u0007nU3tg&|g.\u0003\u0003\u0002F\u0005\u001d#!C\"B\u0007\"+u,T!Q\u0015\r\t\t%H\u0001\tiJLXI^5diRA\u0011\u0011FA'\u0003\u001f\n\u0019\u0006C\u0004\u0002(a\u0001\r!!\u000b\t\r\u0005E\u0003\u00041\u0001p\u0003\rYW-\u001f\u0005\u0007\u0003GA\u0002\u0019A\u001f\u0002\rI,Wn\u001c<f)\u0011\tY!!\u0017\t\r\u0005M\u0011\u00041\u00018)\u0011\tY!!\u0018\t\r\u0005}#\u00041\u0001[\u0003\u001d\u0019Xm]:j_:\fQ\u0001^8vG\"$RASA3\u0003OBa!a\u0018\u001c\u0001\u0004Q\u0006BBA\u00127\u0001\u0007Q\b")
public class FetchSessionCache
implements KafkaMetricsGroup {
    private final int maxEntries;
    private final long evictionMs;
    private long numPartitions;
    private final HashMap<Object, FetchSession> sessions;
    private final TreeMap<LastUsedKey, FetchSession> lastUsed;
    private final TreeMap<EvictableKey, FetchSession> evictableByAll;
    private final TreeMap<EvictableKey, FetchSession> evictableByPrivileged;
    private final Meter evictionsMeter;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        FetchSessionCache fetchSessionCache = this;
        synchronized (fetchSessionCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int maxEntries() {
        return this.maxEntries;
    }

    private long evictionMs() {
        return this.evictionMs;
    }

    private long numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(long x$1) {
        this.numPartitions = x$1;
    }

    private HashMap<Object, FetchSession> sessions() {
        return this.sessions;
    }

    private TreeMap<LastUsedKey, FetchSession> lastUsed() {
        return this.lastUsed;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByAll() {
        return this.evictableByAll;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByPrivileged() {
        return this.evictableByPrivileged;
    }

    public Meter evictionsMeter() {
        return this.evictionsMeter;
    }

    public synchronized Option<FetchSession> get(int sessionId) {
        return this.sessions().get((Object)BoxesRunTime.boxToInteger((int)sessionId));
    }

    public synchronized int size() {
        return this.sessions().size();
    }

    public synchronized long totalPartitions() {
        return this.numPartitions();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int newSessionId() {
        void var1_1;
        int id = 0;
        do {
            id = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        } while (this.sessions().contains((Object)BoxesRunTime.boxToInteger((int)id)) || id == 0);
        return (int)var1_1;
    }

    public synchronized int maybeCreateSession(long now, boolean privileged, int size, Function0<ImplicitLinkedHashCollection<CachedPartition>> createPartitions) {
        int n;
        if (this.sessions().size() < this.maxEntries() || this.tryEvict(privileged, new EvictableKey(privileged, size, 0), now)) {
            ImplicitLinkedHashCollection partitionMap = (ImplicitLinkedHashCollection)createPartitions.apply();
            FetchSession session = new FetchSession(this.newSessionId(), privileged, (ImplicitLinkedHashCollection<CachedPartition>)partitionMap, now, now, FetchMetadata.nextEpoch((int)0));
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Created fetch session ").append(session.toString()).toString());
            this.sessions().put((Object)BoxesRunTime.boxToInteger((int)session.id()), (Object)session);
            this.touch(session, now);
            n = session.id();
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("No fetch session created for privileged=").append(privileged).append(", size=").append(size).append(".").toString());
            n = 0;
        }
        return n;
    }

    public synchronized boolean tryEvict(boolean privileged, EvictableKey key, long now) {
        boolean bl;
        Map.Entry<LastUsedKey, FetchSession> lastUsedEntry = this.lastUsed().firstEntry();
        if (lastUsedEntry == null) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There are no cache entries to evict.");
            bl = false;
        } else if (now - lastUsedEntry.getKey().lastUsedMs() > this.evictionMs()) {
            FetchSession session = lastUsedEntry.getValue();
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Evicting stale FetchSession ").append(session.id()).append(".").toString());
            this.remove(session);
            this.evictionsMeter().mark();
            bl = true;
        } else {
            TreeMap<EvictableKey, FetchSession> map = privileged ? this.evictableByPrivileged() : this.evictableByAll();
            Map.Entry<EvictableKey, FetchSession> evictableEntry = map.firstEntry();
            if (evictableEntry == null) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No evictable entries found.");
                bl = false;
            } else if (key.compareTo(evictableEntry.getKey()) < 0) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Can't evict ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).toString());
                bl = false;
            } else {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Evicting ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).append(".").toString());
                this.remove(evictableEntry.getValue());
                this.evictionsMeter().mark();
                bl = true;
            }
        }
        return bl;
    }

    public synchronized Option<FetchSession> remove(int sessionId) {
        Option<FetchSession> option;
        Option<FetchSession> option2 = this.get(sessionId);
        if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else if (option2 instanceof Some) {
            Some some = (Some)option2;
            FetchSession session = (FetchSession)some.value();
            option = this.remove(session);
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    public synchronized Option<FetchSession> remove(FetchSession session) {
        Option removeResult;
        block3: {
            EvictableKey evictableKey;
            FetchSession fetchSession = session;
            synchronized (fetchSession) {
                this.lastUsed().remove(session.lastUsedKey());
                evictableKey = session.evictableKey();
            }
            EvictableKey evictableKey2 = evictableKey;
            this.evictableByAll().remove(evictableKey2);
            this.evictableByPrivileged().remove(evictableKey2);
            removeResult = this.sessions().remove((Object)BoxesRunTime.boxToInteger((int)session.id()));
            if (!removeResult.isDefined()) break block3;
            this.numPartitions_$eq(this.numPartitions() - (long)session.cachedSize());
        }
        return removeResult;
    }

    public synchronized void touch(FetchSession session, long now) {
        FetchSession fetchSession = session;
        synchronized (fetchSession) {
            this.lastUsed().remove(session.lastUsedKey());
            session.lastUsedMs_$eq(now);
            this.lastUsed().put(session.lastUsedKey(), session);
            int oldSize = session.cachedSize();
            if (oldSize != -1) {
                EvictableKey oldEvictableKey = session.evictableKey();
                this.evictableByPrivileged().remove(oldEvictableKey);
                this.evictableByAll().remove(oldEvictableKey);
                this.numPartitions_$eq(this.numPartitions() - (long)oldSize);
            }
            session.cachedSize_$eq(session.size());
            EvictableKey newEvictableKey = session.evictableKey();
            FetchSession fetchSession2 = !session.privileged() || now - session.creationMs() > this.evictionMs() ? this.evictableByPrivileged().put(newEvictableKey, session) : BoxedUnit.UNIT;
            Object object = now - session.creationMs() > this.evictionMs() ? this.evictableByAll().put(newEvictableKey, session) : BoxedUnit.UNIT;
            this.numPartitions_$eq(this.numPartitions() + (long)session.cachedSize());
        }
    }

    public FetchSessionCache(int maxEntries, long evictionMs) {
        this.maxEntries = maxEntries;
        this.evictionMs = evictionMs;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.numPartitions = 0L;
        this.sessions = new HashMap();
        this.lastUsed = new TreeMap();
        this.evictableByAll = new TreeMap();
        this.evictableByPrivileged = new TreeMap();
        this.removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSISONS(), this.removeMetric$default$2());
        this.newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSISONS(), new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public int value() {
                return this.$outer.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), this.removeMetric$default$2());
        this.newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public long value() {
                return this.$outer.totalPartitions();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), this.removeMetric$default$2());
        this.evictionsMeter = this.newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS, (Map<String, String>)Map$.MODULE$.empty());
    }
}

