/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import java.net.InetAddress;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.PermissionType$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.ResourceType$;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class AuthorizerUtils$ {
    public static AuthorizerUtils$ MODULE$;
    private final String WildcardPrincipal;
    private final String WildcardHost;

    static {
        new AuthorizerUtils$();
    }

    public String WildcardPrincipal() {
        return this.WildcardPrincipal;
    }

    public String WildcardHost() {
        return this.WildcardHost;
    }

    public Either<ApiError, Tuple2<Resource, Acl>> convertToResourceAndAcl(AclBindingFilter filter) {
        Left left;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ResourceType$.MODULE$.fromJava(filter.patternFilter().resourceType())).flatMap((Function1 & Serializable & scala.Serializable)resourceType -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> SecurityUtils.parseKafkaPrincipal((String)filter.entryFilter().principal())).flatMap((Function1 & Serializable & scala.Serializable)principal -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Operation$.MODULE$.fromJava(filter.entryFilter().operation())).flatMap((Function1 & Serializable & scala.Serializable)operation -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> PermissionType$.MODULE$.fromJava(filter.entryFilter().permissionType())).map((Function1 & Serializable & scala.Serializable)permissionType -> {
            Resource resource = new Resource((ResourceType)resourceType, filter.patternFilter().name(), filter.patternFilter().patternType());
            Acl acl = new Acl((KafkaPrincipal)principal, (PermissionType)permissionType, filter.entryFilter().host(), (Operation)operation);
            return new Tuple3(permissionType, (Object)resource, (Object)acl);
        }).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Resource resource = (Resource)tuple3._2();
            Acl acl = (Acl)tuple3._3();
            Tuple2 tuple2 = new Tuple2((Object)resource, (Object)acl);
            return tuple2;
        }))));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable throwable = failure.exception();
            left = package$.MODULE$.Left().apply((Object)new ApiError(Errors.INVALID_REQUEST, throwable.getMessage()));
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tuple2 s = (Tuple2)success.value();
            left = package$.MODULE$.Right().apply((Object)s);
        } else {
            throw new MatchError((Object)try_);
        }
        return left;
    }

    public AclBinding convertToAclBinding(Resource resource, Acl acl) {
        ResourcePattern resourcePattern = new ResourcePattern(resource.resourceType().toJava(), resource.name(), resource.patternType());
        return new AclBinding(resourcePattern, this.convertToAccessControlEntry(acl));
    }

    public AccessControlEntry convertToAccessControlEntry(Acl acl) {
        return new AccessControlEntry(acl.principal().toString(), acl.host().toString(), acl.operation().toJava(), acl.permissionType().toJava());
    }

    public Acl convertToAcl(AccessControlEntry ace) {
        return new Acl(SecurityUtils.parseKafkaPrincipal((String)ace.principal()), PermissionType$.MODULE$.fromJava(ace.permissionType()), ace.host(), Operation$.MODULE$.fromJava(ace.operation()));
    }

    public Resource convertToResource(ResourcePattern resourcePattern) {
        return new Resource(ResourceType$.MODULE$.fromJava(resourcePattern.resourceType()), resourcePattern.name(), resourcePattern.patternType());
    }

    public void validateAclBinding(AclBinding aclBinding) {
        if (aclBinding.isUnknown()) {
            throw new IllegalArgumentException("ACL binding contains unknown elements");
        }
    }

    public Set<AclOperation> supportedOperations(org.apache.kafka.common.resource.ResourceType resourceType) {
        return (Set)ResourceType$.MODULE$.fromJava(resourceType).supportedOperations().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toJava(), Set$.MODULE$.canBuildFrom());
    }

    public boolean isClusterResource(String name) {
        return name.equals(Resource$.MODULE$.ClusterResourceName());
    }

    public AuthorizableRequestContext sessionToRequestContext(RequestChannel.Session session) {
        return new AuthorizableRequestContext(session){
            private final RequestChannel.Session session$1;

            public String clientId() {
                return "";
            }

            public int requestType() {
                return -1;
            }

            public String listenerName() {
                return "";
            }

            public InetAddress clientAddress() {
                return this.session$1.clientAddress();
            }

            public KafkaPrincipal principal() {
                return this.session$1.principal();
            }

            public SecurityProtocol securityProtocol() {
                return null;
            }

            public int correlationId() {
                return -1;
            }

            public int requestVersion() {
                return -1;
            }
            {
                this.session$1 = session$1;
            }
        };
    }

    private AuthorizerUtils$() {
        MODULE$ = this;
        this.WildcardPrincipal = "User:*";
        this.WildcardHost = "*";
    }
}

