/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AuthorizerUtils$;
import kafka.utils.Logging;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.SetLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rUs!B\"E\u0011\u0003Ye!B'E\u0011\u0003q\u0005\"B+\u0002\t\u00031\u0006bB,\u0002\u0005\u0004%\t\u0001\u0017\u0005\u0007C\u0006\u0001\u000b\u0011B-\t\u000f\t\f!\u0019!C\u00011\"11-\u0001Q\u0001\neCq\u0001Z\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004f\u0003\u0001\u0006I!\u0017\u0005\bM\u0006\u0011\r\u0011\"\u0001Y\u0011\u00199\u0017\u0001)A\u00053\"9\u0001.\u0001b\u0001\n\u0003A\u0006BB5\u0002A\u0003%\u0011\fC\u0004k\u0003\t\u0007I\u0011\u0001-\t\r-\f\u0001\u0015!\u0003Z\r\u0011a\u0017\u0001Q7\t\u0011Q|!Q3A\u0005\u0002UD\u0011\"!\u0003\u0010\u0005#\u0005\u000b\u0011\u0002<\t\u0015\u0005-qB!f\u0001\n\u0003\ti\u0001\u0003\u0006\u0002\u0016=\u0011\t\u0012)A\u0005\u0003\u001fAa!V\b\u0005\u0002\u0005]\u0001bBA\u0011\u001f\u0011\u0005\u00111\u0005\u0005\n\u0003Wy\u0011\u0011!C\u0001\u0003[A\u0011\"a\r\u0010#\u0003%\t!!\u000e\t\u0013\u0005-s\"%A\u0005\u0002\u00055\u0003\u0002CA)\u001f\u0005\u0005I\u0011\t-\t\u0013\u0005Ms\"!A\u0005\u0002\u00055\u0001\"CA+\u001f\u0005\u0005I\u0011AA,\u0011%\t\u0019gDA\u0001\n\u0003\n)\u0007C\u0005\u0002t=\t\t\u0011\"\u0001\u0002v!I\u0011\u0011P\b\u0002\u0002\u0013\u0005\u00131\u0010\u0005\n\u0003{z\u0011\u0011!C!\u0003\u007fB\u0011\"!!\u0010\u0003\u0003%\t%a!\b\u0013\u0005\u001d\u0015!!A\t\u0002\u0005%e\u0001\u00037\u0002\u0003\u0003E\t!a#\t\rU\u0013C\u0011AAM\u0011%\tiHIA\u0001\n\u000b\ny\bC\u0005\u0002\u001c\n\n\t\u0011\"!\u0002\u001e\"I\u00111\u0015\u0012\u0002\u0002\u0013\u0005\u0015Q\u0015\u0005\n\u0003o\u0013\u0013\u0011!C\u0005\u0003sC\u0011\"!1\u0002\u0005\u0004%\t!a1\t\u0011\u0005\u0015\u0017\u0001)A\u0005\u000331q!a2\u0002\u0001\u0011\u000bI\r\u0003\u0004VU\u0011\u0005\u0011q\u001b\u0005\b\u00037TC\u0011IAo\r\u0015iE\t\u0001B\u0012\u0011\u0019)V\u0006\"\u0001\u00038!I!1H\u0017C\u0002\u0013%!Q\b\u0005\t\u0005\u001fj\u0003\u0015!\u0003\u0003@!Q!\u0011K\u0017A\u0002\u0013EA)!\u0004\t\u0015\tMS\u00061A\u0005\u0012\u0011\u0013)\u0006\u0003\u0005\u0003Z5\u0002\u000b\u0015BA\b\u0011\u001d\u0011Y&\fC!\u0005;BqA!\".\t\u0003\u00129\tC\u0004\u000386\"\tA!/\t\u000f\t]W\u0006\"\u0011\u0003Z\"9!q\\\u0017\u0005B\t\u0005\bb\u0002Bp[\u0011\u0005#\u0011\u001e\u0005\b\u0005[lC\u0011\tBx\u0011\u001d\u0011i/\fC!\u0005gDqAa?.\t\u0003\u0011i\u0010C\u0004\u0003n6\"\te!\u0004\t\u000f\r=Q\u0006\"\u0001\u0004\u0012!911C\u0017\u0005\n\rU\u0001bBB\u0015[\u0011%11\u0006\u0005\u0007i6\"Ia!\u000f\t\u000f\r}R\u0006\"\u0003\u0004B\u0005\u00192+[7qY\u0016\f5\r\\!vi\"|'/\u001b>fe*\u0011QIR\u0001\u0005CV$\bN\u0003\u0002H\u0011\u0006A1/Z2ve&$\u0018PC\u0001J\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001T\u0001\u000e\u0003\u0011\u00131cU5na2,\u0017i\u00197BkRDwN]5{KJ\u001c\"!A(\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1*A\u0005[WV\u0013H\u000e\u0015:paV\t\u0011\f\u0005\u0002[?6\t1L\u0003\u0002];\u0006!A.\u00198h\u0015\u0005q\u0016\u0001\u00026bm\u0006L!\u0001Y.\u0003\rM#(/\u001b8h\u0003)Q6.\u0016:m!J|\u0007\u000fI\u0001\u00185.\u001cuN\u001c8fGRLwN\u001c+j[\u0016|U\u000f\u001e)s_B\f\u0001DW6D_:tWm\u0019;j_:$\u0016.\\3PkR\u0004&o\u001c9!\u0003QQ6nU3tg&|g\u000eV5nK>+H\u000f\u0015:pa\u0006)\"l[*fgNLwN\u001c+j[\u0016|U\u000f\u001e)s_B\u0004\u0013!\u0006.l\u001b\u0006D\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo]\u0001\u00175.l\u0015\r_%o\r2Lw\r\u001b;SKF,Xm\u001d;tA\u0005q1+\u001e9feV\u001bXM]:Qe>\u0004\u0018aD*va\u0016\u0014Xk]3sgB\u0013x\u000e\u001d\u0011\u0002?\u0005cGn\\<Fm\u0016\u0014\u0018p\u001c8f\u0013\u001atu.Q2m\u0013N4u.\u001e8e!J|\u0007/\u0001\u0011BY2|w/\u0012<fef|g.Z%g\u001d>\f5\r\\%t\r>,h\u000e\u001a)s_B\u0004#!\u0004,feNLwN\\3e\u0003\u000ed7o\u0005\u0003\u0010\u001f:\f\bC\u0001)p\u0013\t\u0001\u0018KA\u0004Qe>$Wo\u0019;\u0011\u0005A\u0013\u0018BA:R\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011\t7\r\\:\u0016\u0003Y\u0004Ba\u001e@\u0002\u00049\u0011\u0001\u0010 \t\u0003sFk\u0011A\u001f\u0006\u0003w*\u000ba\u0001\u0010:p_Rt\u0014BA?R\u0003\u0019\u0001&/\u001a3fM&\u0019q0!\u0001\u0003\u0007M+GO\u0003\u0002~#B\u0019A*!\u0002\n\u0007\u0005\u001dAIA\u0002BG2\fQ!Y2mg\u0002\n\u0011B_6WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005=\u0001c\u0001)\u0002\u0012%\u0019\u00111C)\u0003\u0007%sG/\u0001\u0006{WZ+'o]5p]\u0002\"b!!\u0007\u0002\u001e\u0005}\u0001cAA\u000e\u001f5\t\u0011\u0001C\u0003u)\u0001\u0007a\u000fC\u0004\u0002\fQ\u0001\r!a\u0004\u0002\r\u0015D\u0018n\u001d;t+\t\t)\u0003E\u0002Q\u0003OI1!!\u000bR\u0005\u001d\u0011un\u001c7fC:\fAaY8qsR1\u0011\u0011DA\u0018\u0003cAq\u0001\u001e\f\u0011\u0002\u0003\u0007a\u000fC\u0005\u0002\fY\u0001\n\u00111\u0001\u0002\u0010\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001cU\r1\u0018\u0011H\u0016\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0005v]\u000eDWmY6fI*\u0019\u0011QI)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002J\u0005}\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA(U\u0011\ty!!\u000f\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0017\u0002`A\u0019\u0001+a\u0017\n\u0007\u0005u\u0013KA\u0002B]fD\u0011\"!\u0019\u001c\u0003\u0003\u0005\r!a\u0004\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u0007\u0005\u0004\u0002j\u0005=\u0014\u0011L\u0007\u0003\u0003WR1!!\u001cR\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003c\nYG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0013\u0003oB\u0011\"!\u0019\u001e\u0003\u0003\u0005\r!!\u0017\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0004\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!W\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015\u0012Q\u0011\u0005\n\u0003C\u0002\u0013\u0011!a\u0001\u00033\nQBV3sg&|g.\u001a3BG2\u001c\bcAA\u000eEM!!%!$r!%\ty)!&w\u0003\u001f\tI\"\u0004\u0002\u0002\u0012*\u0019\u00111S)\u0002\u000fI,h\u000e^5nK&!\u0011qSAI\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003\u0013\u000bQ!\u00199qYf$b!!\u0007\u0002 \u0006\u0005\u0006\"\u0002;&\u0001\u00041\bbBA\u0006K\u0001\u0007\u0011qB\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9+a-\u0011\u000bA\u000bI+!,\n\u0007\u0005-\u0016K\u0001\u0004PaRLwN\u001c\t\u0007!\u0006=f/a\u0004\n\u0007\u0005E\u0016K\u0001\u0004UkBdWM\r\u0005\n\u0003k3\u0013\u0011!a\u0001\u00033\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0006c\u0001.\u0002>&\u0019\u0011qX.\u0003\r=\u0013'.Z2u\u0003\u0019qu.Q2mgV\u0011\u0011\u0011D\u0001\b\u001d>\f5\r\\:!\u00059\u0011\u0015m]3BkRDwN]5{KJ\u001c2AKAf!\u0011\ti-a5\u000e\u0005\u0005='bAAi\r\u0006Q\u0011-\u001e;i_JL'0\u001a:\n\t\u0005U\u0017q\u001a\u0002\u000e\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:\u0015\u0005\u0005e\u0007cAA\u000eU\u0005yAn\\4Bk\u0012LG/T3tg\u0006<W\r\u0006\u0005\u0002`\u0006\u0015(\u0011\u0001B\u0006!\r\u0001\u0016\u0011]\u0005\u0004\u0003G\f&\u0001B+oSRDq!a:-\u0001\u0004\tI/\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0011\t\u0005-\u0018Q`\u0007\u0003\u0003[TA!!5\u0002p*!\u0011\u0011_Az\u0003\u0019\u0019XM\u001d<fe*\u0019\u0011*!>\u000b\t\u0005]\u0018\u0011`\u0001\u0007CB\f7\r[3\u000b\u0005\u0005m\u0018aA8sO&!\u0011q`Aw\u0005i\tU\u000f\u001e5pe&T\u0018M\u00197f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0011\u001d\u0011\u0019\u0001\fa\u0001\u0005\u000b\ta!Y2uS>t\u0007\u0003BAv\u0005\u000fIAA!\u0003\u0002n\n1\u0011i\u0019;j_:DqA!\u0004-\u0001\u0004\t)#\u0001\u0006bkRDwN]5{K\u0012Ds!\u0001B\t\u0005/\u0011Y\u0002E\u0002Q\u0005'I1A!\u0006R\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u00053\t1&V:fA-\fgm[1/g\u0016\u001cWO]5us:\nW\u000f\u001e5pe&TXM\u001d\u0018BG2\fU\u000f\u001e5pe&TXM]\u0011\u0003\u0005;\t\u0011bU5oG\u0016\u0004#G\f\u001b)\u000f\u0005\u0011\tBa\u0006\u0003\u001c!:\u0001A!\u0005\u0003\u0018\tm1cB\u0017\u0002<\n\u0015\"1\u0006\t\u0004\u0019\n\u001d\u0012b\u0001B\u0015\t\nQ\u0011)\u001e;i_JL'0\u001a:\u0011\t\t5\"1G\u0007\u0003\u0005_Q1A!\rI\u0003\u0015)H/\u001b7t\u0013\u0011\u0011)Da\f\u0003\u000f1{wmZ5oOR\u0011!\u0011\b\t\u0003\u00196\nQ\"Y2m\u0003V$\bn\u001c:ju\u0016\u0014XC\u0001B !\r\u0011\tE\u000b\b\u0004\u0005\u0007\u0002a\u0002\u0002B#\u0005\u001brAAa\u0012\u0003L9\u0019\u0011P!\u0013\n\u0003%K!a\u0012%\n\u0005\u00153\u0015AD1dY\u0006+H\u000f[8sSj,'\u000fI\u0001\u0011[\u0006DX\u000b\u001d3bi\u0016\u0014V\r\u001e:jKN\fA#\\1y+B$\u0017\r^3SKR\u0014\u0018.Z:`I\u0015\fH\u0003BAp\u0005/B\u0011\"!\u00193\u0003\u0003\u0005\r!a\u0004\u0002#5\f\u00070\u00169eCR,'+\u001a;sS\u0016\u001c\b%A\u0005d_:4\u0017nZ;sKR!\u0011q\u001cB0\u0011\u001d\u0011\t\u0007\u000ea\u0001\u0005G\n1B[1wC\u000e{gNZ5hgB\"!Q\rB=!!\u00119G!\u001c\u0003r\tUTB\u0001B5\u0015\r\u0011Y'X\u0001\u0005kRLG.\u0003\u0003\u0003p\t%$aA'baB\u0019qOa\u001d\n\u0007\u0001\f\t\u0001\u0005\u0003\u0003x\teD\u0002\u0001\u0003\r\u0005w\u0012y&!A\u0001\u0002\u000b\u0005!Q\u0010\u0002\u0004?\u0012\n\u0014\u0003\u0002B@\u00033\u00022\u0001\u0015BA\u0013\r\u0011\u0019)\u0015\u0002\b\u001d>$\b.\u001b8h\u0003%\tW\u000f\u001e5pe&TX\r\u0006\u0005\u0002&\t%%1\u0015BW\u0011\u001d\u0011Y)\u000ea\u0001\u0005\u001b\u000bqa]3tg&|g\u000e\u0005\u0003\u0003\u0010\nue\u0002\u0002BI\u0005/sAAa\u0012\u0003\u0014&\u0019!Q\u0013%\u0002\u000f9,Go^8sW&!!\u0011\u0014BN\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2T1A!&I\u0013\u0011\u0011yJ!)\u0003\u000fM+7o]5p]*!!\u0011\u0014BN\u0011\u001d\u0011)+\u000ea\u0001\u0005O\u000b\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0011\u00071\u0013I+C\u0002\u0003,\u0012\u0013\u0011b\u00149fe\u0006$\u0018n\u001c8\t\u000f\t=V\u00071\u0001\u00032\u0006A!/Z:pkJ\u001cW\rE\u0002M\u0005gK1A!.E\u0005!\u0011Vm]8ve\u000e,\u0017aC5t'V\u0004XM]+tKJ$\"\"!\n\u0003<\nu&q\u0018Bj\u0011\u001d\u0011)K\u000ea\u0001\u0005OCqAa,7\u0001\u0004\u0011\t\fC\u0004\u0003BZ\u0002\rAa1\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0007\u0003\u0002Bc\u0005\u001fl!Aa2\u000b\u0007\u0015\u0013IMC\u0002H\u0005\u0017TAA!4\u0002t\u000611m\\7n_:LAA!5\u0003H\nq1*\u00194lCB\u0013\u0018N\\2ja\u0006d\u0007b\u0002Bkm\u0001\u0007!\u0011O\u0001\u0005Q>\u001cH/A\u0004bI\u0012\f5\r\\:\u0015\r\u0005}'1\u001cBo\u0011\u0015!x\u00071\u0001w\u0011\u001d\u0011yk\u000ea\u0001\u0005c\u000b!B]3n_Z,\u0017i\u00197t)\u0019\t)Ca9\u0003h\"1!Q\u001d\u001dA\u0002Y\fq\"Y2mgR{'-\u001a*f[>4X\r\u001a\u0005\b\u0005_C\u0004\u0019\u0001BY)\u0011\t)Ca;\t\u000f\t=\u0016\b1\u0001\u00032\u00069q-\u001a;BG2\u001cHc\u0001<\u0003r\"9!q\u0016\u001eA\u0002\tEF\u0003\u0002B{\u0005s\u0004ba\u001eB|\u0005c3\u0018\u0002\u0002B8\u0003\u0003AqA!1<\u0001\u0004\u0011\u0019-A\bhKRl\u0015\r^2iS:<\u0017i\u00197t)\u00151(q`B\u0005\u0011\u001d\u0019\t\u0001\u0010a\u0001\u0007\u0007\tAB]3t_V\u00148-\u001a+za\u0016\u00042\u0001TB\u0003\u0013\r\u00199\u0001\u0012\u0002\r%\u0016\u001cx.\u001e:dKRK\b/\u001a\u0005\b\u0007\u0017a\u0004\u0019\u0001B9\u00031\u0011Xm]8ve\u000e,g*Y7f)\t\u0011)0A\u0003dY>\u001cX\r\u0006\u0002\u0002`\u0006Q1M]3bi\u0016\f5\r\\:\u0015\t\u0005}7q\u0003\u0005\b\u00073y\u0004\u0019AB\u000e\u0003!\u0011\u0017N\u001c3j]\u001e\u001c\b\u0003B<\u007f\u0007;\u0001Baa\b\u0004&5\u00111\u0011\u0005\u0006\u0005\u0007G\u0011Y-A\u0002bG2LAaa\n\u0004\"\tQ\u0011i\u00197CS:$\u0017N\\4\u0002\u0015\u0011,G.\u001a;f\u0003\u000ed7\u000f\u0006\u0003\u0002&\r5\u0002bBB\u0018\u0001\u0002\u00071\u0011G\u0001\bM&dG/\u001a:t!\u00119hpa\r\u0011\t\r}1QG\u0005\u0005\u0007o\u0019\tC\u0001\tBG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;feR!!Q_B\u001e\u0011\u001d\u0019i$\u0011a\u0001\u0007g\taAZ5mi\u0016\u0014\u0018A\u0004;ie><X\t_2faRLwN\u001c\u000b\u0005\u0003?\u001c\u0019\u0005C\u0004\u0004F\t\u0003\raa\u0012\u0002\u0003\u0015\u0004Ba!\u0013\u0004P5\u001111\n\u0006\u0005\u0007\u001b\u0012Y-\u0001\u0004feJ|'o]\u0005\u0005\u0007#\u001aYE\u0001\u0007Ba&,\u0005pY3qi&|g\u000eK\u0004.\u0005#\u00119Ba\u0007")
public class SimpleAclAuthorizer
implements Authorizer,
Logging {
    private final BaseAuthorizer aclAuthorizer;
    private int maxUpdateRetries;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static VersionedAcls NoAcls() {
        return SimpleAclAuthorizer$.MODULE$.NoAcls();
    }

    public static String AllowEveryoneIfNoAclIsFoundProp() {
        return SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp();
    }

    public static String SuperUsersProp() {
        return SimpleAclAuthorizer$.MODULE$.SuperUsersProp();
    }

    public static String ZkMaxInFlightRequests() {
        return SimpleAclAuthorizer$.MODULE$.ZkMaxInFlightRequests();
    }

    public static String ZkSessionTimeOutProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkSessionTimeOutProp();
    }

    public static String ZkConnectionTimeOutProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkConnectionTimeOutProp();
    }

    public static String ZkUrlProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkUrlProp();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        SimpleAclAuthorizer simpleAclAuthorizer = this;
        synchronized (simpleAclAuthorizer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private BaseAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    public int maxUpdateRetries() {
        return this.maxUpdateRetries;
    }

    public void maxUpdateRetries_$eq(int x$1) {
        this.maxUpdateRetries = x$1;
    }

    public void configure(Map<String, ?> javaConfigs) {
        this.aclAuthorizer().configure(javaConfigs);
    }

    @Override
    public boolean authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        AuthorizableRequestContext requestContext = AuthorizerUtils$.MODULE$.sessionToRequestContext(session);
        Action action = new Action(operation.toJava(), resource.toPattern(), 1, true, true);
        Object object = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().authorize(requestContext, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)action, (List)Nil$.MODULE$)).asJava())).asScala()).head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    public boolean isSuperUser(Operation operation, Resource resource, KafkaPrincipal principal, String host) {
        return this.aclAuthorizer().isSuperUser(principal);
    }

    @Override
    public void addAcls(scala.collection.immutable.Set<Acl> acls, Resource resource) {
        block0: {
            this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
            if (acls == null || !acls.nonEmpty()) break block0;
            scala.collection.immutable.Set bindings = (scala.collection.immutable.Set)acls.map((Function1 & Serializable & scala.Serializable)acl -> AuthorizerUtils$.MODULE$.convertToAclBinding(resource, (Acl)acl), Set$.MODULE$.canBuildFrom());
            this.createAcls((scala.collection.immutable.Set<AclBinding>)bindings);
        }
    }

    @Override
    public boolean removeAcls(scala.collection.immutable.Set<Acl> aclsTobeRemoved, Resource resource) {
        scala.collection.immutable.Set filters = (scala.collection.immutable.Set)aclsTobeRemoved.map((Function1 & Serializable & scala.Serializable)acl -> new AclBindingFilter(resource.toPattern().toFilter(), AuthorizerUtils$.MODULE$.convertToAccessControlEntry((Acl)acl).toFilter()), Set$.MODULE$.canBuildFrom());
        return this.deleteAcls((scala.collection.immutable.Set<AclBindingFilter>)filters);
    }

    @Override
    public boolean removeAcls(Resource resource) {
        AclBindingFilter filter = new AclBindingFilter(resource.toPattern().toFilter(), AccessControlEntryFilter.ANY);
        return this.deleteAcls((scala.collection.immutable.Set<AclBindingFilter>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{filter}))));
    }

    @Override
    public scala.collection.immutable.Set<Acl> getAcls(Resource resource) {
        AclBindingFilter filter = new AclBindingFilter(resource.toPattern().toFilter(), AccessControlEntryFilter.ANY);
        return (scala.collection.immutable.Set)this.acls(filter).getOrElse((Object)resource, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    @Override
    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls(KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return this.acls(filter);
    }

    public scala.collection.immutable.Set<Acl> getMatchingAcls(ResourceType resourceType, String resourceName) {
        AclBindingFilter filter = new AclBindingFilter(new ResourcePatternFilter(resourceType.toJava(), resourceName, PatternType.MATCH), AccessControlEntryFilter.ANY);
        return ((TraversableOnce)this.acls(filter).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (scala.collection.immutable.Set)x$1._2(), Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Override
    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls() {
        return this.acls(AclBindingFilter.ANY);
    }

    @Override
    public void close() {
        this.aclAuthorizer().close();
    }

    private void createAcls(scala.collection.immutable.Set<AclBinding> bindings) {
        this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
        Buffer results = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().createAcls(null, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (AclCreateResult)x$2.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom());
        results.foreach((Function1 & Serializable & scala.Serializable)result -> {
            SimpleAclAuthorizer.$anonfun$createAcls$2(this, result);
            return BoxedUnit.UNIT;
        });
    }

    private boolean deleteAcls(scala.collection.immutable.Set<AclBindingFilter> filters) {
        this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
        Buffer results = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().deleteAcls(null, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)filters.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (AclDeleteResult)x$3.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom());
        results.foreach((Function1 & Serializable & scala.Serializable)result -> {
            SimpleAclAuthorizer.$anonfun$deleteAcls$2(this, result);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)results.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$4.aclBindingDeleteResults()).asScala(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)result -> {
            SimpleAclAuthorizer.$anonfun$deleteAcls$5(result);
            return BoxedUnit.UNIT;
        });
        return results.exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizer.$anonfun$deleteAcls$7(r)));
    }

    private scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> acls(AclBindingFilter filter) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(filter)).asScala()).foreach((Function1 & Serializable & scala.Serializable)binding -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizer.$anonfun$acls$1(result, binding)));
        return result.mapValues((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toSet()).toMap(Predef$.MODULE$.$conforms());
    }

    private void throwException(ApiException e) {
        if (e.getCause() != null) {
            throw e.getCause();
        }
        throw e;
    }

    public static final /* synthetic */ void $anonfun$createAcls$2(SimpleAclAuthorizer $this, AclCreateResult result) {
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1 & Serializable & scala.Serializable)e -> {
            $this.throwException(e);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$deleteAcls$2(SimpleAclAuthorizer $this, AclDeleteResult result) {
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1 & Serializable & scala.Serializable)e -> {
            $this.throwException(e);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$deleteAcls$5(AclDeleteResult.AclBindingDeleteResult result) {
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1 & Serializable & scala.Serializable)e -> {
            throw e;
        });
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$8(AclDeleteResult.AclBindingDeleteResult d) {
        return !d.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$7(AclDeleteResult r) {
        return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(r.aclBindingDeleteResults()).asScala()).exists((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)SimpleAclAuthorizer.$anonfun$deleteAcls$8(d)));
    }

    public static final /* synthetic */ boolean $anonfun$acls$1(scala.collection.mutable.Map result$1, AclBinding binding) {
        Resource resource = AuthorizerUtils$.MODULE$.convertToResource(binding.pattern());
        Acl acl = AuthorizerUtils$.MODULE$.convertToAcl(binding.entry());
        return ((SetLike)result$1.getOrElseUpdate((Object)resource, (Function0 & Serializable & scala.Serializable)() -> (Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$))).add((Object)acl);
    }

    public SimpleAclAuthorizer() {
        Logging.$init$(this);
        this.aclAuthorizer = new BaseAuthorizer();
        this.maxUpdateRetries = 10;
    }

    public static class BaseAuthorizer
    extends AclAuthorizer {
        @Override
        public void logAuditMessage(AuthorizableRequestContext requestContext, Action action, boolean authorized) {
            BoxedUnit boxedUnit;
            KafkaPrincipal principal = requestContext.principal();
            String host = requestContext.clientAddress().getHostAddress();
            Operation operation = Operation$.MODULE$.fromJava(action.operation());
            Resource resource = AuthorizerUtils$.MODULE$.convertToResource(action.resourcePattern());
            if (authorized) {
                BoxedUnit boxedUnit2;
                if (this.authorizerLogger().underlying().isDebugEnabled()) {
                    this.authorizerLogger().underlying().debug(BaseAuthorizer.logMessage$1(authorized, principal, operation, host, resource));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else if (this.authorizerLogger().underlying().isInfoEnabled()) {
                this.authorizerLogger().underlying().info(BaseAuthorizer.logMessage$1(authorized, principal, operation, host, resource));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        private static final String logMessage$1(boolean authorized$1, KafkaPrincipal principal$1, Operation operation$1, String host$1, Resource resource$1) {
            String authResult = authorized$1 ? "Allowed" : "Denied";
            return new StringBuilder(57).append("Principal = ").append(principal$1).append(" is ").append(authResult).append(" Operation = ").append(operation$1).append(" from host = ").append(host$1).append(" on resource = ").append(resource$1).toString();
        }
    }

    public static class VersionedAcls
    implements Product,
    scala.Serializable {
        private final scala.collection.immutable.Set<Acl> acls;
        private final int zkVersion;

        public scala.collection.immutable.Set<Acl> acls() {
            return this.acls;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public boolean exists() {
            return this.zkVersion() != ZkVersion$.MODULE$.UnknownVersion();
        }

        public VersionedAcls copy(scala.collection.immutable.Set<Acl> acls, int zkVersion) {
            return new VersionedAcls(acls, zkVersion);
        }

        public scala.collection.immutable.Set<Acl> copy$default$1() {
            return this.acls();
        }

        public int copy$default$2() {
            return this.zkVersion();
        }

        public String productPrefix() {
            return "VersionedAcls";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.acls();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.zkVersion());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof VersionedAcls;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.acls()));
            n = Statics.mix((int)n, (int)this.zkVersion());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof VersionedAcls)) return false;
            boolean bl = true;
            if (!bl) return false;
            VersionedAcls versionedAcls = (VersionedAcls)x$1;
            scala.collection.immutable.Set<Acl> set = this.acls();
            scala.collection.immutable.Set<Acl> set2 = versionedAcls.acls();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (this.zkVersion() != versionedAcls.zkVersion()) return false;
            if (!versionedAcls.canEqual(this)) return false;
            return true;
        }

        public VersionedAcls(scala.collection.immutable.Set<Acl> acls, int zkVersion) {
            this.acls = acls;
            this.zkVersion = zkVersion;
            Product.$init$((Product)this);
        }
    }
}

