/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.Log;
import kafka.log.LogSegment;
import kafka.log.OffsetsToClean;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class LogCleanerManager$
implements Logging {
    public static LogCleanerManager$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LogCleanerManager$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager$ logCleanerManager$ = this;
        synchronized (logCleanerManager$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isCompactAndDelete(Log log) {
        return log.config().compact() && log.config().delete();
    }

    public long maxCompactionDelay(Log log, long firstDirtyOffset, long now) {
        Iterable<LogSegment> dirtyNonActiveSegments = log.nonActiveLogSegmentsFrom(firstDirtyOffset);
        Iterable firstBatchTimestamps = (Iterable)log.getFirstBatchTimestampForSegments(dirtyNonActiveSegments).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> x$3 > 0L);
        long earliestDirtySegmentTimestamp = firstBatchTimestamps.nonEmpty() ? BoxesRunTime.unboxToLong((Object)firstBatchTimestamps.min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        long maxCompactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().maxCompactionLagMs()), 0L);
        long cleanUntilTime = now - maxCompactionLagMs;
        return earliestDirtySegmentTimestamp < cleanUntilTime ? cleanUntilTime - earliestDirtySegmentTimestamp : 0L;
    }

    public OffsetsToClean cleanableOffsets(Log log, Option<Object> lastCleanOffset, long now) {
        None$ none$;
        Tuple2.mcJZ.sp sp2;
        Tuple2.mcJZ.sp sp3;
        long logStartOffset = log.logStartOffset();
        long checkpointDirtyOffset = BoxesRunTime.unboxToLong((Object)lastCleanOffset.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset));
        if (checkpointDirtyOffset < logStartOffset) {
            if (!this.isCompactAndDelete(log)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Resetting first dirty offset of ").append(log.name()).append(" to log start offset ").append(logStartOffset).append(" ").append("since the checkpointed offset ").append(checkpointDirtyOffset).append(" is invalid.").toString());
            }
            sp3 = new Tuple2.mcJZ.sp(logStartOffset, true);
        } else if (checkpointDirtyOffset > log.logEndOffset()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(130).append("The last checkpoint dirty offset for partition ").append(log.name()).append(" is ").append(checkpointDirtyOffset).append(", ").append("which is larger than the log end offset ").append(log.logEndOffset()).append(". Resetting to the log start offset ").append(logStartOffset).append(".").toString());
            sp3 = new Tuple2.mcJZ.sp(logStartOffset, true);
        } else {
            sp3 = sp2 = new Tuple2.mcJZ.sp(checkpointDirtyOffset, false);
        }
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        long firstDirtyOffset = sp2._1$mcJ$sp();
        boolean forceUpdateCheckpoint = sp2._2$mcZ$sp();
        Tuple2.mcJZ.sp sp4 = new Tuple2.mcJZ.sp(firstDirtyOffset, forceUpdateCheckpoint);
        Tuple2.mcJZ.sp sp5 = sp4;
        long firstDirtyOffset2 = sp5._1$mcJ$sp();
        boolean forceUpdateCheckpoint2 = sp5._2$mcZ$sp();
        long minCompactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().compactionLagMs()), 0L);
        Option[] optionArray = new Option[3];
        optionArray[0] = log.firstUnstableOffset();
        optionArray[1] = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)log.activeSegment().baseOffset()));
        if (minCompactionLagMs > 0L) {
            Iterable<LogSegment> dirtyNonActiveSegments = log.nonActiveLogSegmentsFrom(firstDirtyOffset2);
            none$ = dirtyNonActiveSegments.find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager$.$anonfun$cleanableOffsets$4(now, minCompactionLagMs, log, s))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.baseOffset()));
        } else {
            none$ = None$.MODULE$;
        }
        optionArray[2] = none$;
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])optionArray)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).min((Ordering)Ordering.Long$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(139).append("Finding range of cleanable offsets for log=").append(log.name()).append(". Last clean offset=").append(lastCleanOffset).append(" ").append("now=").append(now).append(" => firstDirtyOffset=").append(firstDirtyOffset2).append(" firstUncleanableOffset=").append(firstUncleanableDirtyOffset).append(" ").append("activeSegment.baseOffset=").append(log.activeSegment().baseOffset()).toString());
        return new OffsetsToClean(firstDirtyOffset2, package$.MODULE$.max(firstDirtyOffset2, firstUncleanableDirtyOffset), forceUpdateCheckpoint2);
    }

    public Tuple2<Object, Object> calculateCleanableBytes(Log log, long firstDirtyOffset, long uncleanableOffset) {
        LogSegment firstUncleanableSegment = (LogSegment)log.nonActiveLogSegmentsFrom(uncleanableOffset).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> log.activeSegment());
        long firstUncleanableOffset = firstUncleanableSegment.baseOffset();
        long cleanableBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments(firstDirtyOffset, package$.MODULE$.max(firstDirtyOffset, firstUncleanableOffset)).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return new Tuple2.mcJJ.sp(firstUncleanableOffset, cleanableBytes);
    }

    public static final /* synthetic */ boolean $anonfun$cleanableOffsets$4(long now$3, long minCompactionLagMs$1, Log log$2, LogSegment s) {
        boolean isUncleanable = s.largestTimestamp() > now$3 - minCompactionLagMs$1;
        MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(131).append("Checking if log segment may be cleaned: log='").append(log$2.name()).append("' segment.baseOffset=").append(s.baseOffset()).append(" ").append("segment.largestTimestamp=").append(s.largestTimestamp()).append("; now - compactionLag=").append(now$3 - minCompactionLagMs$1).append("; ").append("is uncleanable=").append(isUncleanable).toString());
        return isUncleanable;
    }

    private LogCleanerManager$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

