/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$Throttle$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class ReassignPartitionsCommand$
implements Logging {
    public static ReassignPartitionsCommand$ MODULE$;
    private final ReassignPartitionsCommand.Throttle NoThrottle;
    private final String AnyLogDir;
    private final int EarliestVersion;
    private final String helpText;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand$ reassignPartitionsCommand$ = this;
        synchronized (reassignPartitionsCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Map<TopicPartitionReplica, String> $lessinit$greater$default$4() {
        return scala.collection.Map$.MODULE$.empty();
    }

    public ReassignPartitionsCommand.Throttle NoThrottle() {
        return this.NoThrottle;
    }

    public String AnyLogDir() {
        return this.AnyLogDir;
    }

    public int EarliestVersion() {
        return this.EarliestVersion;
    }

    public String helpText() {
        return this.helpText;
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        String zkConnect = (String)opts.options().valueOf(opts.zkConnectOpt());
        Time time = Time.SYSTEM;
        Option<Admin> adminClientOpt = this.createAdminClient(opts);
        try (KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnect, JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, time, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8(), KafkaZkClient$.MODULE$.apply$default$9());){
            try {
                if (opts.options().has((OptionSpec)opts.verifyOpt())) {
                    this.verifyAssignment(zkClient, adminClientOpt, opts);
                } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
                    this.generateAssignment(zkClient, opts);
                } else if (opts.options().has((OptionSpec)opts.executeOpt())) {
                    this.executeAssignment(zkClient, adminClientOpt, opts);
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(38).append("Partitions reassignment failed due to ").append(e.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            }
        }
    }

    private Option<Admin> createAdminClient(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        None$ none$;
        if (opts.options().has(opts.bootstrapServerOpt())) {
            Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
            props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
            props.putIfAbsent("client.id", "reassign-partitions-tool");
            none$ = new Some((Object)AdminClient.create((Properties)props));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void verifyAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String jsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String jsonString = Utils.readFileAsString((String)jsonFile);
        this.verifyAssignment(zkClient, adminClientOpt, jsonString);
    }

    public void verifyAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, String jsonString) {
        Predef$.MODULE$.println((Object)"Status of partition reassignment: ");
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq partitionsToBeReassigned = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsToBeReassigned, (Object)replicaAssignment);
        Tuple2 tuple23 = tuple22;
        Seq partitionsToBeReassigned2 = (Seq)tuple23._1();
        Map replicaAssignment2 = (Map)tuple23._2();
        Map<TopicPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfPartitionReassignmentSucceeded(zkClient, (Map<TopicPartition, Seq<Object>>)partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()));
        Map<TopicPartitionReplica, ReassignmentStatus> replicasReassignmentStatus = this.checkIfReplicaReassignmentSucceeded(adminClientOpt, (Map<TopicPartitionReplica, String>)replicaAssignment2);
        reassignedPartitionsStatus.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ReassignPartitionsCommand$.$anonfun$verifyAssignment$1(x0$1);
            return BoxedUnit.UNIT;
        });
        replicasReassignmentStatus.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ReassignPartitionsCommand$.$anonfun$verifyAssignment$2(x0$2);
            return BoxedUnit.UNIT;
        });
        this.removeThrottle(zkClient, reassignedPartitionsStatus, replicasReassignmentStatus, adminZkClient);
    }

    public void removeThrottle(KafkaZkClient zkClient, Map<TopicPartition, ReassignmentStatus> reassignedPartitionsStatus, Map<TopicPartitionReplica, ReassignmentStatus> replicasReassignmentStatus, AdminZkClient adminZkClient) {
        block1: {
            if (!reassignedPartitionsStatus.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$removeThrottle$1(x0$1))) || !replicasReassignmentStatus.forall((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$removeThrottle$2(x0$2)))) break block1;
            BooleanRef changed = BooleanRef.create((boolean)false);
            ((IterableLike)zkClient.getAllBrokersInCluster().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
                block0: {
                    Properties configs = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString());
                    if (!(configs.remove(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()) != null)) break block0;
                    adminZkClient.changeBrokerConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId}))), configs);
                    changed$1.elem = true;
                }
            });
            Seq topics = (Seq)((SetLike)reassignedPartitionsStatus.keySet().map((Function1 & Serializable & scala.Serializable)tp -> tp.topic(), Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)replicasReassignmentStatus.keySet().map((Function1 & Serializable & scala.Serializable)replica -> replica.topic(), Set$.MODULE$.canBuildFrom())).toSeq().distinct();
            topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ReassignPartitionsCommand$.$anonfun$removeThrottle$7(adminZkClient, changed, topic);
                return BoxedUnit.UNIT;
            });
            if (changed.elem) {
                Predef$.MODULE$.println((Object)"Throttle was removed.");
            }
        }
    }

    public void generateAssignment(KafkaZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String topicsToMoveJsonFile = (String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        int[] brokerListToReassign = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)opts.options().valueOf(opts.brokerListOpt()))).split(','))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$generateAssignment$1(x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Iterable duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Broker list contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignments.mkString(",")})));
        }
        String topicsToMoveJsonString = Utils.readFileAsString((String)topicsToMoveJsonFile);
        boolean disableRackAware = opts.options().has((OptionSpec)opts.disableRackAware());
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> tuple2 = this.generateAssignment(zkClient, (Seq<Object>)Predef$.MODULE$.wrapIntArray(brokerListToReassign), topicsToMoveJsonString, disableRackAware);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map proposedAssignments = (Map)tuple2._1();
        Map currentAssignments = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)proposedAssignments, (Object)currentAssignments);
        Tuple2 tuple23 = tuple22;
        Map proposedAssignments2 = (Map)tuple23._1();
        Map currentAssignments2 = (Map)tuple23._2();
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n%s\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicPartition, Seq<Object>>)currentAssignments2, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicPartition, Seq<Object>>)proposedAssignments2, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
    }

    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> generateAssignment(KafkaZkClient zkClient, Seq<Object> brokerListToReassign, String topicsToMoveJsonString, boolean disableRackAware) {
        Seq<String> topicsToReassign = this.parseTopicsData(topicsToMoveJsonString);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("List of topics to reassign contains duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        Map<TopicPartition, Seq<Object>> currentAssignment = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)topicsToReassign.toSet());
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            String string = tp.topic();
            return string;
        });
        Product rackAwareMode = disableRackAware ? RackAwareMode$Disabled$.MODULE$ : RackAwareMode$Enforced$.MODULE$;
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        Seq<BrokerMetadata> brokerMetadatas = adminZkClient.getBrokerMetadatas((RackAwareMode)rackAwareMode, (Option<Seq<Object>>)new Some(brokerListToReassign));
        scala.collection.mutable.Map partitionsToBeReassigned = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        groupedByTopic.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Seq seq;
            Map assignment;
            String topic;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Seq replicas;
                topic = (String)tuple2._1();
                assignment = (Map)tuple2._2();
                Tuple2 tuple22 = (Tuple2)assignment.head();
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                seq = replicas = (Seq)tuple22._2();
            } else {
                throw new MatchError((Object)tuple2);
            }
            Seq replicas = seq;
            Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, assignment.size(), replicas.size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)partitionsToBeReassigned.$plus$plus$eq((TraversableOnce)assignedReplicas.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int partition = tuple2._1$mcI$sp();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)replicas);
                return tuple22;
            }, scala.collection.Map$.MODULE$.canBuildFrom()));
            return map;
        });
        return new Tuple2((Object)partitionsToBeReassigned, currentAssignment);
    }

    public void executeAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String reassignmentJsonString = Utils.readFileAsString((String)reassignmentJsonFile);
        long interBrokerThrottle = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.interBrokerThrottleOpt()));
        long replicaAlterLogDirsThrottle = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.replicaAlterLogDirsThrottleOpt()));
        long timeoutMs = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.timeoutOpt()));
        this.executeAssignment(zkClient, adminClientOpt, reassignmentJsonString, new ReassignPartitionsCommand.Throttle(interBrokerThrottle, replicaAlterLogDirsThrottle, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$3()), timeoutMs);
    }

    public void executeAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, String reassignmentJsonString, ReassignPartitionsCommand.Throttle throttle, long timeoutMs) {
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseAndValidate(zkClient, reassignmentJsonString);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq partitionAssignment = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionAssignment, (Object)replicaAssignment);
        Tuple2 tuple23 = tuple22;
        Seq partitionAssignment2 = (Seq)tuple23._1();
        Map replicaAssignment2 = (Map)tuple23._2();
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkClient, adminClientOpt, (Map<TopicPartition, Seq<Object>>)partitionAssignment2.toMap(Predef$.MODULE$.$conforms()), (Map<TopicPartitionReplica, String>)replicaAssignment2, adminZkClient);
        if (zkClient.reassignPartitionsInProgress()) {
            Predef$.MODULE$.println((Object)"There is an existing assignment running.");
            reassignPartitionsCommand.maybeLimit(throttle);
        } else {
            this.printCurrentAssignment(zkClient, (Seq<String>)((Seq)partitionAssignment2.map((Function1 & Serializable & scala.Serializable)x$6 -> ((TopicPartition)x$6._1()).topic(), Seq$.MODULE$.canBuildFrom())));
            if (throttle.interBrokerLimit() >= 0L || throttle.replicaAlterLogDirsLimit() >= 0L) {
                Predef$.MODULE$.println((Object)String.format("Warning: You must run Verify periodically, until the reassignment completes, to ensure the throttle is removed. You can also alter the throttle by rerunning the Execute command passing a new value.", new Object[0]));
            }
            if (reassignPartitionsCommand.reassignPartitions(throttle, timeoutMs)) {
                Predef$.MODULE$.println((Object)"Successfully started reassignment of partitions.");
            } else {
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Failed to reassign partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionAssignment2})));
            }
        }
    }

    public long executeAssignment$default$5() {
        return 10000L;
    }

    public void printCurrentAssignment(KafkaZkClient zkClient, Seq<String> topics) {
        Map<TopicPartition, Seq<Object>> currentPartitionReplicaAssignment = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)topics.toSet());
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(currentPartitionReplicaAssignment, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
    }

    public String formatAsReassignmentJson(Map<TopicPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicPartitionReplica, String> replicaLogDirAssignment) {
        return Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            java.util.Map map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replicas"), JavaConverters$.MODULE$.seqAsJavaListConverter(replicas).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log_dirs"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)r -> ReassignPartitionsCommand$.$anonfun$formatAsReassignmentJson$2(replicaLogDirAssignment, tp, BoxesRunTime.unboxToInt((Object)r)), Seq$.MODULE$.canBuildFrom())).asJava())}))).asJava();
            return map;
        }, Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> parseTopicsData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                JsonValue jsonValue = (JsonValue)some2.value();
                n = BoxesRunTime.unboxToInt((Object)jsonValue.to(DecodeJson$DecodeInt$.MODULE$));
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestVersion();
            }
            int version = n;
            return this.parseTopicsData(version, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Seq<String> parseTopicsData(int version, JsonValue js) {
        int n = version;
        switch (n) {
            case 1: {
                break;
            }
            default: {
                throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
            }
        }
        return (Seq)Option$.MODULE$.option2Iterable(js.asJsonObject().get("topics")).toSeq().flatMap((Function1 & Serializable & scala.Serializable)partitionsSeq -> partitionsSeq.asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)p -> p.asJsonObject().apply("topic").to(DecodeJson$DecodeString$.MODULE$)), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                JsonValue jsonValue = (JsonValue)some2.value();
                n = BoxesRunTime.unboxToInt((Object)jsonValue.to(DecodeJson$DecodeInt$.MODULE$));
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestVersion();
            }
            int version = n;
            return this.parsePartitionReassignmentData(version, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    /*
     * Enabled aggressive block sorting
     */
    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(int version, JsonValue jsonData) {
        int n = version;
        switch (n) {
            case 1: {
                ListBuffer partitionAssignment = (ListBuffer)ListBuffer$.MODULE$.empty();
                scala.collection.mutable.Map replicaAssignment = Map$.MODULE$.empty();
                Option$.MODULE$.option2Iterable(jsonData.asJsonObject().get("partitions")).toSeq().foreach((Function1 & Serializable & scala.Serializable)partitionsSeq -> {
                    ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$1(partitionAssignment, replicaAssignment, partitionsSeq);
                    return BoxedUnit.UNIT;
                });
                return new Tuple2((Object)partitionAssignment, (Object)replicaAssignment);
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parseAndValidate(KafkaZkClient zkClient, String reassignmentJsonString) {
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(reassignmentJsonString);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq partitionsToBeReassigned = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsToBeReassigned, (Object)replicaAssignment);
        Tuple2 tuple23 = tuple22;
        Seq partitionsToBeReassigned2 = (Seq)tuple23._1();
        Map replicaAssignment2 = (Map)tuple23._2();
        if (partitionsToBeReassigned2.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment data file is empty");
        }
        if (partitionsToBeReassigned2.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseAndValidate$1(x$10)))) {
            throw new AdminCommandFailedException("Partition replica list cannot be empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates((Traversable)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TopicPartition tp;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
            return topicPartition;
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicateReassignedPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition reassignment contains duplicate topic partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignedPartitions.mkString(",")})));
        }
        Seq duplicateEntries = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)tp, CoreUtils$.MODULE$.duplicates(replicas));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseAndValidate$4(x0$3)));
        if (duplicateEntries.nonEmpty()) {
            String duplicatesMsg = ((TraversableOnce)duplicateEntries.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Iterable duplicateReplicas = (Iterable)tuple2._2();
                String string = new StringOps(Predef$.MODULE$.augmentString("%s contains multiple entries for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, duplicateReplicas.mkString(",")}));
                return string;
            }, Seq$.MODULE$.canBuildFrom())).mkString(". ");
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatesMsg})));
        }
        Seq proposedTopics = (Seq)((SeqLike)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            String string = tp.topic();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        Map<TopicPartition, Seq<Object>> existingAssignment = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)proposedTopics.toSet());
        Seq nonExistentPartitions = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            TopicPartition tp;
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
            return topicPartition;
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)existingAssignment.contains((Object)key)));
        if (nonExistentPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(58).append("The proposed assignment contains non-existent partitions: ").append(nonExistentPartitions).toString());
        }
        Seq<Object> existingBrokerIDs = zkClient.getSortedBrokerList();
        scala.collection.immutable.Set nonExistingBrokerIDs = ((TraversableOnce)((TraversableLike)partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()).values().flatten((Function1)Predef$.MODULE$.$conforms())).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)existingBrokerIDs.contains(elem)))).toSet();
        if (nonExistingBrokerIDs.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(57).append("The proposed assignment contains non-existent brokerIDs: ").append(nonExistingBrokerIDs.mkString(",")).toString());
        }
        return new Tuple2((Object)partitionsToBeReassigned2, (Object)replicaAssignment2);
    }

    public Map<TopicPartition, ReassignmentStatus> checkIfPartitionReassignmentSucceeded(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> partitionsToBeReassigned) {
        Map<TopicPartition, Seq<Object>> partitionsBeingReassigned = zkClient.getPartitionReassignment();
        Tuple2 tuple2 = partitionsToBeReassigned.keys().partition((Function1 & Serializable & scala.Serializable)topicAndPartition -> BoxesRunTime.boxToBoolean((boolean)partitionsBeingReassigned.contains((Object)topicAndPartition)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable beingReassigned = (Iterable)tuple2._1();
        Iterable notBeingReassigned = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)beingReassigned, (Object)notBeingReassigned);
        Tuple2 tuple23 = tuple22;
        Iterable beingReassigned2 = (Iterable)tuple23._1();
        Iterable notBeingReassigned2 = (Iterable)tuple23._2();
        return ((MapLike)notBeingReassigned2.groupBy((Function1 & Serializable & scala.Serializable)x$12 -> x$12.topic()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            Iterable partitions = (Iterable)tuple2._2();
            Map<TopicPartition, Seq<Object>> replicasForTopic = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
            Iterable iterable = (Iterable)partitions.map(arg_0 -> ReassignPartitionsCommand$.$anonfun$checkIfPartitionReassignmentSucceeded$4(partitionsToBeReassigned, replicasForTopic, arg_0), Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((TraversableOnce)beingReassigned2.map((Function1 & Serializable & scala.Serializable)topicAndPartition -> new Tuple2(topicAndPartition, (Object)ReassignmentInProgress$.MODULE$), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private Map<TopicPartitionReplica, ReassignmentStatus> checkIfReplicaReassignmentSucceeded(Option<Admin> adminClientOpt, Map<TopicPartitionReplica, String> replicaAssignment) {
        scala.collection.immutable.Map map;
        if (replicaAssignment.nonEmpty()) {
            Admin adminClient = (Admin)adminClientOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new AdminCommandFailedException("bootstrap-server needs to be provided in order to reassign replica to the specified log directory");
            });
            map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.describeReplicaLogDirs((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter(replicaAssignment.keySet()).asJava()).all().get()).asScala();
        } else {
            map = scala.collection.Map$.MODULE$.empty();
        }
        scala.collection.immutable.Map replicaLogDirInfos = map;
        return (Map)replicaAssignment.map(arg_0 -> ReassignPartitionsCommand$.$anonfun$checkIfReplicaReassignmentSucceeded$2((Map)replicaLogDirInfos, arg_0), scala.collection.Map$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        void var2_2;
        block5: {
            ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts;
            block6: {
                block4: {
                    opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
                    CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.helpText());
                    OptionSet optionSet = opts.options();
                    int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.generateOpt(), opts.executeOpt(), opts.verifyOpt()}))).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)optionSet.has(x$1)));
                    if (actions != 1) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --generate, --execute or --verify");
                    }
                    CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.zkConnectOpt()}));
                    if (!opts.options().has((OptionSpec)opts.verifyOpt())) break block4;
                    if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
                    }
                    CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.verifyOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.interBrokerThrottleOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
                    break block5;
                }
                if (!opts.options().has((OptionSpec)opts.generateOpt())) break block6;
                if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
                }
                CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.generateOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.interBrokerThrottleOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.reassignmentJsonFileOpt()}))));
                break block5;
            }
            if (!opts.options().has((OptionSpec)opts.executeOpt())) break block5;
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.executeOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
        }
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyAssignment$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        ReassignmentStatus status = (ReassignmentStatus)tuple2._2();
        ReassignmentStatus reassignmentStatus = status;
        if (ReassignmentCompleted$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s completed successfully")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReassignmentFailed$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!ReassignmentInProgress$.MODULE$.equals(reassignmentStatus)) throw new MatchError((Object)reassignmentStatus);
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyAssignment$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartitionReplica replica = (TopicPartitionReplica)tuple2._1();
        ReassignmentStatus status = (ReassignmentStatus)tuple2._2();
        ReassignmentStatus reassignmentStatus = status;
        if (ReassignmentCompleted$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s completed successfully")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReassignmentFailed$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!ReassignmentInProgress$.MODULE$.equals(reassignmentStatus)) throw new MatchError((Object)reassignmentStatus);
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s is still in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$removeThrottle$1(Tuple2 x0$1) {
        ReassignmentStatus status;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReassignmentStatus reassignmentStatus = status = (ReassignmentStatus)tuple2._2();
        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
        boolean bl = !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$removeThrottle$2(Tuple2 x0$2) {
        ReassignmentStatus status;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReassignmentStatus reassignmentStatus = status = (ReassignmentStatus)tuple2._2();
        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
        boolean bl = !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$removeThrottle$7(AdminZkClient adminZkClient$1, BooleanRef changed$1, String topic) {
        block0: {
            Properties configs = adminZkClient$1.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
            if (!(configs.remove(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()) != null | configs.remove(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()) != null)) break block0;
            adminZkClient$1.changeTopicConfig(topic, configs);
            changed$1.elem = true;
        }
    }

    public static final /* synthetic */ int $anonfun$generateAssignment$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ String $anonfun$formatAsReassignmentJson$2(Map replicaLogDirAssignment$1, TopicPartition tp$1, int r) {
        return (String)replicaLogDirAssignment$1.getOrElse((Object)new TopicPartitionReplica(tp$1.topic(), tp$1.partition(), r), (Function0 & Serializable & scala.Serializable)() -> MODULE$.AnyLogDir());
    }

    public static final /* synthetic */ boolean $anonfun$parsePartitionReassignmentData$5(Tuple2 x$8) {
        Object object = x$8._2();
        String string = MODULE$.AnyLogDir();
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ void $anonfun$parsePartitionReassignmentData$1(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue partitionsSeq) {
        partitionsSeq.asJsonArray().iterator().foreach((Function1 & Serializable & scala.Serializable)p -> {
            Seq seq;
            JsonObject partitionFields = p.asJsonObject();
            String topic = partitionFields.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
            int partition = BoxesRunTime.unboxToInt((Object)partitionFields.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
            Seq newReplicas = (Seq)partitionFields.apply("replicas").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            Option<JsonValue> option = partitionFields.get("log_dirs");
            if (option instanceof Some) {
                Some some = (Some)option;
                JsonValue jsonValue = (JsonValue)some.value();
                seq = (Seq)jsonValue.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            } else if (None$.MODULE$.equals(option)) {
                seq = (Seq)newReplicas.map((Function1 & Serializable & scala.Serializable)x$7 -> ReassignPartitionsCommand$.MODULE$.AnyLogDir(), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(option);
            }
            Seq newLogDirs = seq;
            if (newReplicas.size() != newLogDirs.size()) {
                throw new AdminCommandFailedException(new StringBuilder(78).append("Size of replicas list ").append(newReplicas).append(" is different from ").append("size of log dirs list ").append(newLogDirs).append(" for partition ").append(new TopicPartition(topic, partition)).toString());
            }
            partitionAssignment$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)newReplicas));
            return (scala.collection.mutable.Map)replicaAssignment$1.$plus$plus$eq((TraversableOnce)((TraversableLike)((TraversableLike)newReplicas.zip((GenIterable)newLogDirs, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int replica = tuple2._1$mcI$sp();
                String logDir = (String)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, partition, replica)), (Object)logDir);
                return tuple22;
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$5(x$8))));
        });
    }

    public static final /* synthetic */ boolean $anonfun$parseAndValidate$1(Tuple2 x$10) {
        return ((SeqLike)x$10._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseAndValidate$4(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable duplicatedReplicas = (Iterable)tuple2._2();
        boolean bl = duplicatedReplicas.nonEmpty();
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Tuple2 $anonfun$checkIfPartitionReassignmentSucceeded$4(Map partitionsToBeReassigned$2, Map replicasForTopic$1, TopicPartition topicAndPartition) {
        newReplicas = (Seq)partitionsToBeReassigned$2.apply((Object)topicAndPartition);
        var6_4 = replicasForTopic$1.get((Object)topicAndPartition);
        if (!(var6_4 instanceof Some)) ** GOTO lbl-1000
        var7_5 = (Some)var6_4;
        v0 = seq = (Seq)var7_5.value();
        var9_7 = newReplicas;
        if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
            var3_8 /* !! */  = ReassignmentCompleted$.MODULE$;
        } else lbl-1000:
        // 2 sources

        {
            var3_8 /* !! */  = ReassignmentFailed$.MODULE$;
        }
        reassignmentStatus = var3_8 /* !! */ ;
        return new Tuple2((Object)topicAndPartition, (Object)reassignmentStatus);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Tuple2 $anonfun$checkIfReplicaReassignmentSucceeded$2(Map replicaLogDirInfos$1, Tuple2 x0$1) {
        void var3_12;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartitionReplica replica = (TopicPartitionReplica)tuple2._1();
        String newLogDir = (String)tuple2._2();
        Option option = replicaLogDirInfos$1.get((Object)replica);
        if (option instanceof Some) {
            Product product;
            Some some = (Some)option;
            DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaLogDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)some.value();
            if (replicaLogDirInfo.getCurrentReplicaLogDir() == null) {
                Predef$.MODULE$.println((Object)new StringBuilder(109).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" is not found in any live log dir on ").append("broker ").append(replica.brokerId()).append(". There is likely offline log directory on the broker.").toString());
                product = ReassignmentFailed$.MODULE$;
            } else {
                String string = replicaLogDirInfo.getFutureReplicaLogDir();
                String string2 = newLogDir;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    product = ReassignmentInProgress$.MODULE$;
                } else if (replicaLogDirInfo.getFutureReplicaLogDir() != null) {
                    Predef$.MODULE$.println((Object)new StringBuilder(61).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" on broker ").append(replica.brokerId()).append(" ").append("is being moved to log dir ").append(replicaLogDirInfo.getFutureReplicaLogDir()).append(" instead of ").append(newLogDir).toString());
                    product = ReassignmentFailed$.MODULE$;
                } else {
                    String string3 = replicaLogDirInfo.getCurrentReplicaLogDir();
                    String string4 = newLogDir;
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        product = ReassignmentCompleted$.MODULE$;
                    } else {
                        Predef$.MODULE$.println((Object)new StringBuilder(59).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" on broker ").append(replica.brokerId()).append(" ").append("is not being moved from log dir ").append(replicaLogDirInfo.getCurrentReplicaLogDir()).append(" to ").append(newLogDir).toString());
                        product = ReassignmentFailed$.MODULE$;
                    }
                }
            }
            ReassignmentInProgress$ reassignmentInProgress$ = product;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            Predef$.MODULE$.println((Object)new StringBuilder(56).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" is not found in any live log dir on broker ").append(replica.brokerId()).append(".").toString());
            ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
        }
        void status = var3_12;
        return new Tuple2((Object)replica, (Object)status);
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.NoThrottle = new ReassignPartitionsCommand.Throttle(-1L, -1L, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$3());
        this.AnyLogDir = "any";
        this.EarliestVersion = 1;
        this.helpText = "This tool helps to moves topic partitions between replicas.";
    }
}

