/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u000f\u001f\u0001\rBQA\u000b\u0001\u0005\u0002-BQA\f\u0001\u0005B=BqA\u000e\u0001C\u0002\u0013\u0005q\u0007\u0003\u0004A\u0001\u0001\u0006I\u0001\u000f\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001C\u0011\u0019y\u0005\u0001)A\u0005\u0007\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006B\u0002-\u0001A\u0003%!\u000bC\u0005Z\u0001\u0001\u0007\t\u0019!C\u00015\"I1\r\u0001a\u0001\u0002\u0004%\t\u0001\u001a\u0005\nU\u0002\u0001\r\u0011!Q!\nmCQa\u001b\u0001\u0005B1DQ\u0001\u001e\u0001\u0005B1DQ!\u001f\u0001\u0005RiDa!a\u0001\u0001\t\u0003a\u0007BBA\u0007\u0001\u0011\u0005A\u000eC\u0004\u0002\u0012\u0001!I!a\u0005\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA/\u0001\u0011%\u0011q\f\u0005\n\u0003g\u0002\u0011\u0013!C\u0005\u0003kBq!a#\u0001\t\u0013\ti\t\u0003\u0004\u0002\u001c\u0002!\ta\f\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\tI\u000b\u0001C\u0005\u0003WC\u0011\"a,\u0001#\u0003%I!!-\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"9\u0011Q\u0018\u0001\u0005\n\u0005}&A\u0007#z]\u0006l\u0017nY\"p]:,7\r^5p]F+x\u000e^1UKN$(BA\u0010!\u0003\u001dqW\r^<pe.T\u0011!I\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0005\u0005\u0002&Q5\taE\u0003\u0002(A\u000511/\u001a:wKJL!!\u000b\u0014\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#\u0001\u0017\u0011\u00055\u0002Q\"\u0001\u0010\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t\u0019\u0011J\u001c;\u0002\u000bQ|\u0007/[2\u0016\u0003a\u0002\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\t1\fgn\u001a\u0006\u0002{\u0005!!.\u0019<b\u0013\ty$H\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u00111L7\u000f^3oKJ,\u0012a\u0011\t\u0003\t6k\u0011!\u0012\u0006\u0003?\u0019S!a\u0012%\u0002\r\r|W.\\8o\u0015\t\t\u0013J\u0003\u0002K\u0017\u00061\u0011\r]1dQ\u0016T\u0011\u0001T\u0001\u0004_J<\u0017B\u0001(F\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003%a\u0017n\u001d;f]\u0016\u0014\b%\u0001\u0007m_\u000e\fG.\u00113ee\u0016\u001c8/F\u0001S!\t\u0019f+D\u0001U\u0015\t)F(A\u0002oKRL!a\u0016+\u0003\u0017%sW\r^!eIJ,7o]\u0001\u000eY>\u001c\u0017\r\\!eIJ,7o\u001d\u0011\u0002\u0011\u0015DXmY;u_J,\u0012a\u0017\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\u0001G(\u0001\u0003vi&d\u0017B\u00012^\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017\u0001D3yK\u000e,Ho\u001c:`I\u0015\fHCA3i!\t\td-\u0003\u0002he\t!QK\\5u\u0011\u001dI'\"!AA\u0002m\u000b1\u0001\u001f\u00132\u0003%)\u00070Z2vi>\u0014\b%A\u0003tKR,\u0006\u000fF\u0001fQ\taa\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002r\u0017\u0006)!.\u001e8ji&\u00111\u000f\u001d\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D#!\u0004<\u0011\u0005=<\u0018B\u0001=q\u0005\u0015\te\r^3s\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002fw\")AP\u0004a\u0001{\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u0005y|X\"A0\n\u0007\u0005\u0005qL\u0001\u0006Qe>\u0004XM\u001d;jKN\f!\u0004^3ti\u0012Kh.Y7jG\u000e{gN\\3di&|g.U;pi\u0006D3aDA\u0004!\ry\u0017\u0011B\u0005\u0004\u0003\u0017\u0001(\u0001\u0002+fgR\f!\u0005^3ti\u0012Kh.Y7jG2K7\u000f^3oKJ\u001cuN\u001c8fGRLwN\\)v_R\f\u0007f\u0001\t\u0002\b\u0005\u0011\"/Z2p]\u001aLw-\u001e:f'\u0016\u0014h/\u001a:t)\u001d)\u0017QCA\r\u0003GAa!a\u0006\u0012\u0001\u0004i\u0018\u0001\u00038foB\u0013x\u000e]:\t\u000f\u0005m\u0011\u00031\u0001\u0002\u001e\u0005y\u0001/\u001a:Ce>\\WM]\"p]\u001aLw\rE\u00022\u0003?I1!!\t3\u0005\u001d\u0011un\u001c7fC:Dq!!\n\u0012\u0001\u0004\t9#A\u0007b!J|\u0007\u000fV8WKJLg-\u001f\t\bc\u0005%\u0012QFA\u0017\u0013\r\tYC\r\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005=\u0012Q\b\b\u0005\u0003c\tI\u0004E\u0002\u00024Ij!!!\u000e\u000b\u0007\u0005]\"%\u0001\u0004=e>|GOP\u0005\u0004\u0003w\u0011\u0014A\u0002)sK\u0012,g-C\u0002@\u0003\u007fQ1!a\u000f3\u0003=9\u0018-\u001b;G_Jd\u0015n\u001d;f]\u0016\u0014HcA3\u0002F!9\u0011q\t\nA\u0002\u00055\u0012\u0001\u00047jgR,g.\u001a:OC6,\u0017!E2sK\u0006$X-\u00113nS:\u001cE.[3oiR\u0011\u0011Q\n\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003\u0015\tG-\\5o\u0015\r\t9\u0006S\u0001\bG2LWM\u001c;t\u0013\u0011\tY&!\u0015\u0003\u0017\u0005#W.\u001b8DY&,g\u000e^\u0001\u0016o\u0006LGOR8s\u0007>tg-[4P]N+'O^3s)\u001d)\u0017\u0011MA3\u0003SBq!a\u0019\u0015\u0001\u0004\ti#\u0001\u0005qe>\u0004h*Y7f\u0011\u001d\t9\u0007\u0006a\u0001\u0003[\t\u0011\u0002\u001d:paZ\u000bG.^3\t\u0013\u0005-D\u0003%AA\u0002\u00055\u0014!C7bq^\u000b\u0017\u000e^'t!\r\t\u0014qN\u0005\u0004\u0003c\u0012$\u0001\u0002'p]\u001e\fqd^1ji\u001a{'oQ8oM&<wJ\\*feZ,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t9H\u000b\u0003\u0002n\u0005e4FAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015%'\u0001\u0006b]:|G/\u0019;j_:LA!!#\u0002\u0000\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001dA\u0014x\u000eZ;dKJ+\u0017/^3tiV\u0011\u0011q\u0012\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013$\u0002\u0011I,\u0017/^3tiNLA!!'\u0002\u0014\nq\u0001K]8ek\u000e,'+Z9vKN$\u0018aD2p]:,7\r^5p]\u000e{WO\u001c;\u0002\u000f\r|gN\\3diR!\u0011\u0011UAT!\r\u0019\u00161U\u0005\u0004\u0003K#&AB*pG.,G\u000f\u0003\u0004B1\u0001\u0007\u0011QF\u0001\u001aGJ,\u0017\r^3B]\u00124VM]5gs\u000e{gN\\3di&|g\u000eF\u0002f\u0003[C\u0001\"Q\r\u0011\u0002\u0003\u0007\u0011QF\u0001$GJ,\u0017\r^3B]\u00124VM]5gs\u000e{gN\\3di&|g\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019L\u000b\u0003\u0002.\u0005e\u0014\u0001\u0005<fe&4\u0017pQ8o]\u0016\u001cG/[8o)\r)\u0017\u0011\u0018\u0005\b\u0003w[\u0002\u0019AAQ\u0003\u0019\u0019xnY6fi\u0006!b/\u001a:jMfl\u0015\r_\"p]:,7\r^5p]N$R!ZAa\u0003\u000bDa!a1\u001d\u0001\u0004\u0001\u0014AD7bq\u000e{gN\\3di&|gn\u001d\u0005\b\u0003\u000fd\u0002\u0019AAe\u0003I\u0019wN\u001c8fGR<\u0016\u000e\u001e5GC&dWO]3\u0011\tE\nY-Z\u0005\u0004\u0003\u001b\u0014$!\u0003$v]\u000e$\u0018n\u001c81\u0001")
public class DynamicConnectionQuotaTest
extends BaseRequestTest {
    private final String topic;
    private final ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final InetAddress localAddress = InetAddress.getByName("127.0.0.1");
    private ExecutorService executor;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic() {
        return this.topic;
    }

    public ListenerName listener() {
        return this.listener;
    }

    public InetAddress localAddress() {
        return this.localAddress;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), this.brokerCount(), this.brokerCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Override
    @After
    public void tearDown() {
        try {
            if (this.executor() != null) {
                this.executor().shutdownNow();
                Assert.assertTrue((boolean)this.executor().awaitTermination(10L, TimeUnit.SECONDS));
            }
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
    }

    @Test
    public void testDynamicConnectionQuota() {
        int maxConnectionsPerIP = 5;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIP)).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), (Object)((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIP)).toString()));
        this.verifyMaxConnections(maxConnectionsPerIP, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$1());
        int maxConnectionsPerIPOverride = 7;
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), (Object)new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString()));
        this.verifyMaxConnections(maxConnectionsPerIPOverride, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$1());
    }

    @Test
    public void testDynamicListenerConnectionQuota() {
        int initialConnectionCount = this.connectionCount();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "5");
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsProp(), (Object)"5"));
        this.verifyMaxConnections(5, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$2());
        String newListeners = "PLAINTEXT://localhost:0,INTERNAL://localhost:0";
        props.put(KafkaConfig$.MODULE$.ListenersProp(), newListeners);
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "PLAINTEXT:PLAINTEXT,INTERNAL:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "10");
        props.put("listener.name.internal.max.connections", "5");
        props.put("listener.name.plaintext.max.connections", "5");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)newListeners));
        this.waitForListener("INTERNAL");
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable & scala.Serializable)x$1 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        conns = (IndexedSeq)conns.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable & scala.Serializable)x$2 -> this.connect("INTERNAL"), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        conns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        conns.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialConnectionCount == this.connectionCount(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connections not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        int maxConnectionsPlaintext = 7;
        String listenerProp = new StringBuilder(0).append(this.listener().configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        props.put(listenerProp, ((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPlaintext)).toString());
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)listenerProp, (Object)((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPlaintext)).toString()));
        this.verifyMaxConnections(maxConnectionsPlaintext, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.connectAndVerify$2());
        IndexedSeq plaintextConnections = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext).map((Function1 & Serializable & scala.Serializable)x$4 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.executor_$eq(Executors.newSingleThreadExecutor());
        Future<?> future = this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createAndVerifyConnection(this.createAndVerifyConnection$default$1())));
        Thread.sleep(100L);
        Assert.assertFalse((boolean)future.isDone());
        ((Socket)plaintextConnections.head()).close();
        future.get(30L, TimeUnit.SECONDS);
        plaintextConnections.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialConnectionCount == this.connectionCount(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connections not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        IndexedSeq plaintextConns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable & scala.Serializable)x$6 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq internalConns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable & scala.Serializable)x$7 -> this.connect("INTERNAL"), IndexedSeq$.MODULE$.canBuildFrom());
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        plaintextConns = (IndexedSeq)plaintextConns.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).map((Function1 & Serializable & scala.Serializable)x$8 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.connectionCount() <= 10, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Internal connections not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> internalConns.foreach((Function1 & Serializable & scala.Serializable)socket -> this.sendAndReceive((AbstractRequest)this.produceRequest(), ApiKeys.PRODUCE, (Socket)socket, this.sendAndReceive$default$4())), ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        plaintextConns.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.close();
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialConnectionCount == this.connectionCount(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connections not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private void reconfigureServers(Properties newProps, boolean perBrokerConfig, Tuple2<String, String> aPropToVerify) {
        int initialConnectionCount = this.connectionCount();
        AdminClient adminClient = this.createAdminClient();
        TestUtils$.MODULE$.alterConfigs((Seq<KafkaServer>)this.servers(), adminClient, newProps, perBrokerConfig).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), this.waitForConfigOnServer$default$3());
        adminClient.close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialConnectionCount == this.connectionCount(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Admin client connection not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private void waitForListener(String listenerName) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Assert.assertTrue((((KafkaServer)this.servers().head()).socketServer().boundPort(ListenerName.normalised((String)listenerName)) > 0 ? 1 : 0) != 0);
            }
            catch (KafkaException e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private AdminClient createAdminClient() {
        void var3_3;
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        AdminClient adminClient = AdminClient.create((Properties)config);
        return var3_3;
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$.MODULE$.retry(maxWaitMs, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.assertEquals((Object)propValue, ((KafkaServer)this.servers().head()).config().originals().get(propName)));
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    private ProduceRequest produceRequest() {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())});
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        return (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build();
    }

    public int connectionCount() {
        return ((KafkaServer)this.servers().head()).socketServer().connectionCount(this.localAddress());
    }

    public Socket connect(String listener) {
        ListenerName listenerName = ListenerName.normalised((String)listener);
        return new Socket("localhost", ((KafkaServer)this.servers().head()).socketServer().boundPort(listenerName));
    }

    private void createAndVerifyConnection(String listener) {
        try (Socket socket = this.connect(listener);){
            this.verifyConnection(socket);
        }
    }

    private String createAndVerifyConnection$default$1() {
        return "PLAINTEXT";
    }

    private void verifyConnection(Socket socket) {
        ProduceResponse.PartitionResponse partitionResponse;
        ProduceRequest request = this.produceRequest();
        ByteBuffer response = this.sendAndReceive((AbstractRequest)request, ApiKeys.PRODUCE, socket, this.sendAndReceive$default$4());
        ProduceResponse produceResponse = ProduceResponse.parse((ByteBuffer)response, (short)request.version());
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProduceResponse.PartitionResponse partitionResponse2 = partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        ProduceResponse.PartitionResponse partitionResponse3 = partitionResponse2;
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse3.error);
    }

    private void verifyMaxConnections(int maxConnections, Function0<BoxedUnit> connectWithFailure) {
        int initialConnectionCount = this.connectionCount();
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnections - 1).map((Function1 & Serializable & scala.Serializable)x$11 -> this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.connectionCount() == maxConnections - 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "produce request connection is not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        conns = (IndexedSeq)conns.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions$.MODULE$.intercept(connectWithFailure, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        ((Socket)conns.head()).close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.connectionCount() == maxConnections - 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "connection is not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.createAndVerifyConnection(this.createAndVerifyConnection$default$1());
        conns.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> initialConnectionCount == this.connectionCount(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connections not closed", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private final void connectAndVerify$1() {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), ApiKeys.PRODUCE, socket, this.sendAndReceive$default$4());
        }
    }

    private final void connectAndVerify$2() {
        socket.setSoTimeout(1000);
        try (Socket socket = this.connect("PLAINTEXT");){
            ByteBuffer response = this.sendAndReceive((AbstractRequest)this.produceRequest(), ApiKeys.PRODUCE, socket, this.sendAndReceive$default$4());
            Assert.assertEquals((long)0L, (long)response.remaining());
        }
    }

    public DynamicConnectionQuotaTest() {
        this.topic = "test";
    }
}

