/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple5;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tef\u0001\u0002#F\u0001)CQ!\u0015\u0001\u0005\u0002ICq!\u0016\u0001C\u0002\u0013\u0005a\u000b\u0003\u0004e\u0001\u0001\u0006Ia\u0016\u0005\u0006K\u0002!\tA\u001a\u0005\u0006c\u0002!IA\u001d\u0005\u0006q\u0002!\tA\u001a\u0005\u0006s\u0002!\tA\u001a\u0005\u0006w\u0002!I\u0001 \u0005\u0006\u007f\u0002!\tA\u001a\u0005\u0007\u0003\u0007\u0001A\u0011\u00014\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!1\u0011Q\u0002\u0001\u0005\u0002\u0019Dq!!\u0005\u0001\t\u0013\t\u0019\u0002C\u0004\u0002$\u0001!I!!\n\t\r\u0005-\u0002\u0001\"\u0001g\u0011\u0019\ty\u0003\u0001C\u0001M\"9\u00111\u0007\u0001\u0005\n\u0005U\u0002BBA\u001d\u0001\u0011\u0005a\r\u0003\u0004\u0002>\u0001!\tA\u001a\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0011\u0019\t9\u0005\u0001C\u0001M\"1\u00111\n\u0001\u0005\u0002\u0019Dq!a\u0014\u0001\t\u0013\t\t\u0006\u0003\u0004\u0002X\u0001!\tA\u001a\u0005\u0007\u00037\u0002A\u0011\u00014\t\r\u0005}\u0003\u0001\"\u0001g\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBa!!\u001b\u0001\t\u00031\u0007BBA7\u0001\u0011\u0005a\r\u0003\u0004\u0002\u0002\u0002!\tA\u001a\u0005\u0007\u0003\u000b\u0003A\u0011\u00014\t\r\u0005%\u0005\u0001\"\u0001g\u0011\u0019\ti\t\u0001C\u0001M\"1\u0011\u0011\u0013\u0001\u0005\u0002\u0019Da!!&\u0001\t\u00031\u0007BBAM\u0001\u0011\u0005a\r\u0003\u0004\u0002\u001e\u0002!\tA\u001a\u0005\u0007\u0003C\u0003A\u0011\u00014\t\r\u0005\u0015\u0006\u0001\"\u0001g\u0011\u0019\tI\u000b\u0001C\u0001M\"1\u0011Q\u0016\u0001\u0005\u0002\u0019Da!!-\u0001\t\u00031\u0007BBA[\u0001\u0011\u0005a\r\u0003\u0004\u0002H\u0002!\tA\u001a\u0005\u0007\u0003\u0017\u0004A\u0011\u00014\t\r\u0005=\u0007\u0001\"\u0001g\u0011\u0019\t\u0019\u000e\u0001C\u0001M\"1\u0011q\u001b\u0001\u0005\u0002\u0019Da!a7\u0001\t\u00031\u0007BBAp\u0001\u0011\u0005a\r\u0003\u0004\u0002d\u0002!\tA\u001a\u0005\u0007\u0003_\u0004A\u0011\u00014\t\r\u0005M\b\u0001\"\u0001g\u0011\u0019\t9\u0010\u0001C\u0001M\"1\u00111 \u0001\u0005\u0002\u0019Da!a@\u0001\t\u00031\u0007B\u0002B\u0002\u0001\u0011\u0005a\r\u0003\u0004\u0003\u0010\u0001!\tA\u001a\u0005\u0007\u0005'\u0001A\u0011\u00014\t\u000f\t]\u0001\u0001\"\u0003\u0003\u001a!9!q\u0006\u0001\u0005\n\tE\u0002\"\u0003B)\u0001E\u0005I\u0011\u0002B*\u0011\u001d\u0011I\u0007\u0001C\u0001\u0005WBqA!\u001e\u0001\t\u0013\u00119\bC\u0004\u0003~\u0001!\tAa \t\u000f\t5\u0005\u0001\"\u0001\u0003\u0010\"9!1\u0014\u0001\u0005\u0002\tu%\u0001\u0005'pOZ\u000bG.\u001b3bi>\u0014H+Z:u\u0015\t1u)A\u0002m_\u001eT\u0011\u0001S\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\n\u0005\u0002M\u001f6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJ\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0003\"\u0001\u0016\u0001\u000e\u0003\u0015\u000bA\u0001^5nKV\tq\u000b\u0005\u0002YE6\t\u0011L\u0003\u0002[7\u0006)Q\u000f^5mg*\u0011A,X\u0001\u0007G>lWn\u001c8\u000b\u0005!s&BA0a\u0003\u0019\t\u0007/Y2iK*\t\u0011-A\u0002pe\u001eL!aY-\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001!i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,gj\u001c8D_6\u0004(/Z:tK\u00124\u0016\u0007F\u0001h!\ta\u0005.\u0003\u0002j\u001b\n!QK\\5uQ\t!1\u000e\u0005\u0002m_6\tQN\u0003\u0002oA\u0006)!.\u001e8ji&\u0011\u0001/\u001c\u0002\u0005)\u0016\u001cH/A\u0010dQ\u0016\u001c7\u000eT8h\u0003B\u0004XM\u001c3US6,gj\u001c8D_6\u0004(/Z:tK\u0012$\"aZ:\t\u000bQ,\u0001\u0019A;\u0002\u000b5\fw-[2\u0011\u000513\u0018BA<N\u0005\u0011\u0011\u0015\u0010^3\u0002AQ,7\u000f\u001e'pO\u0006\u0003\b/\u001a8e)&lWMT8o\u0007>l\u0007O]3tg\u0016$gKM\u0001%i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Wc!\u0012qa[\u0001$G\",7m\u001b'pO\u0006\u0003\b/\u001a8e)&lWmV5uQJ+7m\\7qe\u0016\u001c8/[8o)\t9W\u0010C\u0003\u007f\u0011\u0001\u0007Q/A\u0006uCJ<W\r^'bO&\u001c\u0017\u0001\n;fgRdunZ!qa\u0016tG\rV5nK^KG\u000f\u001b*fG>l\u0007O]3tg&|gN\u0016\u001a)\u0005%Y\u0017a\n;fgRdunZ!qa\u0016tG\rV5nK^KG\u000f[8viJ+7m\\7qe\u0016\u001c8/[8o-FB#AC6\u0002M\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"|W\u000f\u001e*fG>l\u0007O]3tg&|g\u000eF\u0002h\u0003\u0017AQ\u0001^\u0006A\u0002U\fA\u0005^3ti&sg/\u00197jI>3gm]3u%\u0006tw-Z!oIJ+7m\u001c:e\u0007>,h\u000e\u001e\u0015\u0003\u0019-\f\u0001%Y:tKJ$\u0018J\u001c<bY&$')\u0019;dQ\u000e{WO\u001c;Pm\u0016\u0014(/\u001b3fgR)q-!\u0006\u0002 !9\u0011qC\u0007A\u0002\u0005e\u0011a\u00047bgR|eMZ:fi\u0012+G\u000e^1\u0011\u00071\u000bY\"C\u0002\u0002\u001e5\u00131!\u00138u\u0011\u001d\t\t#\u0004a\u0001\u00033\tQaY8v]R\fQE^1mS\u0012\fG/\u001a*fG>\u0014HMQ1uG\"<\u0016\u000e\u001e5D_VtGo\u0014<feJLG-Z:\u0015\u000b\u001d\f9#!\u000b\t\u000f\u0005]a\u00021\u0001\u0002\u001a!9\u0011\u0011\u0005\bA\u0002\u0005e\u0011a\n;fgRdunZ!qa\u0016tG\rV5nK^KG\u000f[8viJ+7m\\7qe\u0016\u001c8/[8o-JB#aD6\u0002'Q,7\u000f\u001e(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0005AY\u0017AE2iK\u000e\\gj\u001c8D_6\u0004(/Z:tK\u0012$2aZA\u001c\u0011\u0015!\u0018\u00031\u0001v\u0003M!Xm\u001d;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\t\u00112.A\nuKN$(+Z2p[B\u0014Xm]:j_:4\u0016\u0007\u000b\u0002\u0014W\u0006\u00112\r[3dWJ+7m\\7qe\u0016\u001c8/[8o)\r9\u0017Q\t\u0005\u0006iR\u0001\r!^\u0001\u0014i\u0016\u001cHOU3d_6\u0004(/Z:tS>tgK\r\u0015\u0003+-\f\u0001\u0005^3ti\u000e\u0013X-\u0019;f)&lW-\u00169D_:4XM]:j_:4\u0006\u0007V8Wc!\u0012ac[\u0001\"G\",7m[\"sK\u0006$X\rV5nKV\u00038i\u001c8wKJ\u001c\u0018n\u001c8Ge>lg\u000b\r\u000b\u0004O\u0006M\u0003BBA+/\u0001\u0007Q/A\u0004u_6\u000bw-[2\u0002AQ,7\u000f^\"sK\u0006$X\rV5nKV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{gK\r\u0015\u00031-\f\u0001\u0005^3ti\u000e\u0013X-\u0019;f)&lW-\u00169D_:4XM]:j_:4\u0016\u0007V8We!\u0012\u0011d[\u0001\u0011i\u0016\u001cHoQ8naJ,7o]3e-FB#AG6\u0002\u001f\rDWmY6D_6\u0004(/Z:tK\u0012$2aZA4\u0011\u0015!8\u00041\u0001v\u0003A!Xm\u001d;D_6\u0004(/Z:tK\u00124&\u0007\u000b\u0002\u001dW\u0006!C/Z:u\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,gj\u001c8D_6\u0004(/Z:tK\u00124\u0016\u0007\u000b\u0004\u001eW\u0006E\u00141O\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011Q\u000f\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111P.\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\ty(!\u001f\u00033%sg/\u00197jIRKW.Z:uC6\u0004X\t_2faRLwN\\\u0001%i\u0016\u001cH/\u00138wC2LGm\u0011:fCR,G+[7f\u001d>t7i\\7qe\u0016\u001c8/\u001a3We!2ad[A9\u0003g\n\u0011\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWmQ8naJ,7o]3e-FBcaH6\u0002r\u0005M\u0014!\t;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.Z\"p[B\u0014Xm]:fIZ\u0013\u0004F\u0002\u0011l\u0003c\n\u0019(A\u0015uKN$\u0018IY:pYV$Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0003C-\fa\u0005^3ti\u0006\u00137o\u001c7vi\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGoQ8naJ,7o]3eQ\t\u00113.A\u0016uKN$(+\u001a7bi&4Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\t\u00193.A\u0016uKN$(+\u001a7bi&4Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\t!3.\u0001\u0015uKN$(+\u001a7bi&4Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;D_6\u0004(/Z:tK\u00124\u0016\u0007\u000b\u0002&W\u0006AC/Z:u%\u0016d\u0017\r^5wK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$8i\\7qe\u0016\u001c8/\u001a3We!\u0012ae[\u00019i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8Wc9{gnQ8naJ,7o]3eQ\t93.\u0001\u001duKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u0003Dk\u001c,3\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0005!Z\u0017!\u000e;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ,\u0006oQ8om\u0016\u00148/[8o-B\"vNV\u0019D_6\u0004(/Z:tK\u0012D#!K6\u0002kQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-J\u001au.\u001c9sKN\u001cX\r\u001a\u0015\u0003U-\fq\u0005^3ti\u000e{g\u000e\u001e:pYJ+7m\u001c:eg:{G/\u00117m_^,GM\u0012:p[\u000ec\u0017.\u001a8ug\"21f[A9\u0003s\u001b#!a/\u0011\t\u0005u\u00161Y\u0007\u0003\u0003\u007fS1!!1\\\u0003\u0019\u0011XmY8sI&!\u0011QYA`\u0005YIeN^1mS\u0012\u0014VmY8sI\u0016C8-\u001a9uS>t\u0017a\b;fgR\u001cuN\u001c;s_2\u0014VmY8sINtu\u000e^\"p[B\u0014Xm]:fI\"\u0012Af[\u0001;i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gNV\u0019U_Z\u0003dj\u001c8D_6\u0004(/Z:tK\u0012D#!L6\u0002oQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,2)>4\u0006gQ8naJ,7o]3eQ\tq3.\u0001\u001duKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u000bDk\u001c,3\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0005=Z\u0017!\u000e;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ,\u0006oQ8om\u0016\u00148/[8o-F\"vN\u0016\u001aD_6\u0004(/Z:tK\u0012D#\u0001M6\u0002uQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,3)>4\u0016GT8o\u0007>l\u0007O]3tg\u0016$\u0007FA\u0019l\u0003]\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:E_^t7i\u001c8wKJ\u001c\u0018n\u001c8WeQ{g+M\"p[B\u0014Xm]:fI\"\u0012!g[\u00015i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gn\u00144Ue\u0006t7/Y2uS>t\u0017\r\u001c*fG>\u0014Hm\u001d(piB+'/\\5ui\u0016$\u0007FB\u001al\u0003c\n9o\t\u0002\u0002jB!\u0011qOAv\u0013\u0011\ti/!\u001f\u0003IUs7/\u001e9q_J$X\r\u001a$pe6+7o]1hK\u001a{'/\\1u\u000bb\u001cW\r\u001d;j_:\f\u0011\u0007^3ti\u0012{wO\\\"p]Z,'o]5p]>3\u0017\nZ3na>$XM\u001c;SK\u000e|'\u000fZ:O_R\u0004VM]7jiR,G\r\u000b\u00045W\u0006E\u0014q]\u0001;i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u0003dj\u001c8D_6\u0004(/Z:tK\u0012D#!N6\u0002oQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,3)>4\u0006gQ8naJ,7o]3eQ\t14.\u0001\u000fuKN$\u0018J\u001c<bY&$\u0017J\u001c8fe6\u000bw-[2WKJ\u001c\u0018n\u001c8)\r]Z\u0017\u0011OA]\u0003-\"Xm\u001d;D_6\u0004(/Z:tK\u0012\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$\u0007F\u0002\u001dl\u0003c\nI,A\u0016uKN$(l\u0015;e\u0007>l\u0007O]3tg\u0016$w+\u001b;i+:\fg/Y5mC\ndW-\u0013\"Q-\u0016\u00148/[8oQ\u0019I4.!\u001d\u0003\b\r\u0012!\u0011\u0002\t\u0005\u0003o\u0012Y!\u0003\u0003\u0003\u000e\u0005e$aI+ogV\u0004\bo\u001c:uK\u0012\u001cu.\u001c9sKN\u001c\u0018n\u001c8UsB,W\t_2faRLwN\\\u0001.i\u0016\u001cH/\u00168d_6\u0004(/Z:tK\u0012\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$\u0007F\u0002\u001el\u0003c\nI,A\u0017uKN$(+Z2p[B\u0014Xm]:fI\n\u000bGo\u00195XSRDw.\u001e;SK\u000e|'\u000fZ:O_R\fE\u000e\\8xK\u0012DcaO6\u0002r\u0005e\u0016!\t;fgR\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$G#B4\u0003\u001c\t-\u0002b\u0002B\u000fy\u0001\u0007!qD\u0001\fg>,(oY3D_\u0012,7\r\u0005\u0003\u0003\"\t\u001dRB\u0001B\u0012\u0015\r\u0011)cR\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011ICa\t\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007b\u0002B\u0017y\u0001\u0007!qD\u0001\fi\u0006\u0014x-\u001a;D_\u0012,7-A\u0007de\u0016\fG/\u001a*fG>\u0014Hm\u001d\u000b\t\u0005g\u0011ID!\u0010\u0003HA!\u0011Q\u0018B\u001b\u0013\u0011\u00119$a0\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u0019\u0011Y$\u0010a\u0001k\u0006QQ.Y4jGZ\u000bG.^3\t\u0013\t}R\b%AA\u0002\t\u0005\u0013!\u0003;j[\u0016\u001cH/Y7q!\ra%1I\u0005\u0004\u0005\u000bj%\u0001\u0002'p]\u001eDqA!\u0013>\u0001\u0004\u0011Y%A\u0003d_\u0012,7\r\u0005\u0003\u0002>\n5\u0013\u0002\u0002B(\u0003\u007f\u0013qbQ8naJ,7o]5p]RK\b/Z\u0001\u0018GJ,\u0017\r^3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uII*\"A!\u0016+\t\t\u0005#qK\u0016\u0003\u00053\u0002BAa\u0017\u0003f5\u0011!Q\f\u0006\u0005\u0005?\u0012\t'A\u0005v]\u000eDWmY6fI*\u0019!1M'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003h\tu#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a1\r[3dW>3gm]3ugR)qM!\u001c\u0003r!9!qN A\u0002\tM\u0012a\u0002:fG>\u0014Hm\u001d\u0005\b\u0005gz\u0004\u0019\u0001B!\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u0001\u001de\u0016\u001cwN\u001d3t/&$\b.\u00138wC2LG-\u00138oKJl\u0015mZ5d)\u0011\u0011\u0019D!\u001f\t\u000f\tm\u0004\t1\u0001\u0003B\u0005i\u0011N\\5uS\u0006dwJ\u001a4tKR\fq#\\1zE\u0016\u001c\u0005.Z2l\u0005\u0006\u001cX\rV5nKN$\u0018-\u001c9\u0015\u000b\u001d\u0014\tIa!\t\u000f\u0005E\u0014\t1\u0001\u0003B!9!QQ!A\u0002\t\u001d\u0015!\u00022bi\u000eD\u0007\u0003BA_\u0005\u0013KAAa#\u0002@\nY!+Z2pe\u0012\u0014\u0015\r^2i\u0003U1\u0018\r\\5eCR,Gj\\4BaB,g\u000e\u001a+j[\u0016$ra\u001aBI\u0005+\u0013I\nC\u0004\u0003\u0014\n\u0003\rA!\u0011\u0002+\u0015D\b/Z2uK\u0012dunZ!qa\u0016tG\rV5nK\"9!q\u0013\"A\u0002\t\u0005\u0013!F3ya\u0016\u001cG/\u001a3CCN,G+[7fgR\fW\u000e\u001d\u0005\b\u0005\u000b\u0013\u0005\u0019\u0001BD\u0003m1XM]5gsJ+7m\u001c:e\u0007>tg/\u001a:tS>t7\u000b^1ugRIqMa(\u0003*\n5&q\u0016\u0005\b\u0005C\u001b\u0005\u0019\u0001BR\u0003\u0015\u0019H/\u0019;t!\u0011\tiL!*\n\t\t\u001d\u0016q\u0018\u0002\u0016%\u0016\u001cwN\u001d3D_:4XM]:j_:\u001cF/\u0019;t\u0011\u001d\u0011Yk\u0011a\u0001\u00033\t1C\\;n\u0007>tg/\u001a:uK\u0012\u0014VmY8sINDqAa\u001cD\u0001\u0004\u0011\u0019\u0004C\u0004\u00032\u000e\u0003\rAa-\u0002\u0015\r|W\u000e\u001d:fgN,G\rE\u0002M\u0005kK1Aa.N\u0005\u001d\u0011un\u001c7fC:\u0004")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;

    public Time time() {
        return this.time;
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            this.validateLogAppendTime(now, 1234L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)"The offset of max timestamp should be 0", (long)0L, (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, false);
    }

    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            this.validateLogAppendTime(now, -1L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        RecordConversionStats stats = validatedResults.recordConversionStats();
        this.verifyRecordConversionStats(stats, 3, records, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            this.validateLogAppendTime(now, 1234L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.validateRecordBatchWithCountOverrides(lastOffsetDelta, count), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
    }

    private void validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records.buffer().putInt(57, count);
        records.buffer().putInt(23, lastOffsetDelta);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef(0L), this.time(), this.time().milliseconds(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    private void checkNonCompressed(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        Tuple5 tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
        Tuple5 tuple54 = tuple53;
        long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
        short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
        int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
        boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
        int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, partitionLeaderEpoch2, true, ApiVersion$.MODULE$.latestVersion());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$checkNonCompressed$1(this, timestampSeq, producerEpoch2, producerId2, baseSequence2, isTransactional2, partitionLeaderEpoch2, i, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)"Offset of max timestamp should be 1", (long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 0, records, false);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    private void checkRecompression(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        Tuple5 tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
        Tuple5 tuple54 = tuple53;
        long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
        short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
        int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
        boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
        int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, partitionLeaderEpoch2, true, ApiVersion$.MODULE$.latestVersion());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$checkRecompression$1(this, timestampSeq, producerEpoch2, producerId2, baseSequence2, partitionLeaderEpoch2, i, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)"Offset of max timestamp should be 2", (long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        MemoryRecords records;
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords x$4 = records = this.createRecords(x$1, x$3, x$2);
        kafka.common.LongRef x$5 = new kafka.common.LongRef(0L);
        Time x$6 = this.time();
        long x$7 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$8 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        byte x$10 = toMagic;
        boolean x$11 = false;
        TimestampType x$12 = TimestampType.CREATE_TIME;
        long x$13 = 1000L;
        int x$14 = -1;
        boolean x$15 = true;
        ApiVersion x$16 = ApiVersion$.MODULE$.latestVersion();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$4, x$5, x$6, x$7, (CompressionCodec)x$8, (CompressionCodec)x$9, x$11, x$10, x$12, x$13, x$14, x$15, x$16);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCreateTimeUpConversionFromV0$1(this, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(-1L).toString(), (long)-1L, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        MemoryRecords records;
        long timestamp = System.currentTimeMillis();
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = timestamp;
        MemoryRecords x$4 = records = this.createRecords(x$1, x$3, x$2);
        kafka.common.LongRef x$5 = new kafka.common.LongRef(0L);
        Time x$6 = this.time();
        long x$7 = timestamp;
        DefaultCompressionCodec$ x$8 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        byte x$10 = 2;
        boolean x$11 = false;
        TimestampType x$12 = TimestampType.CREATE_TIME;
        long x$13 = 1000L;
        int x$14 = -1;
        boolean x$15 = true;
        ApiVersion x$16 = ApiVersion$.MODULE$.latestVersion();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$4, x$5, x$6, x$7, (CompressionCodec)x$8, (CompressionCodec)x$9, x$11, x$10, x$12, x$13, x$14, x$15, x$16);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$testCreateTimeUpConversionV1ToV2$1(this, timestamp, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    private void checkCompressed(byte magic) {
        MemoryRecords records;
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        Tuple5 tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
        Tuple5 tuple54 = tuple53;
        long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
        short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
        int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
        boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
        int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
        MemoryRecords x$1 = records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        kafka.common.LongRef x$2 = new kafka.common.LongRef(0L);
        Time x$3 = this.time();
        long x$4 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$5 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        byte x$7 = magic;
        boolean x$8 = false;
        TimestampType x$9 = TimestampType.CREATE_TIME;
        long x$10 = 1000L;
        int x$11 = partitionLeaderEpoch2;
        boolean x$12 = true;
        ApiVersion x$13 = ApiVersion$.MODULE$.latestVersion();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$1, x$2, x$3, x$4, (CompressionCodec)x$5, (CompressionCodec)x$6, x$8, x$7, x$9, x$10, x$11, x$12, x$13);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCompressed$1(this, timestampSeq, producerEpoch2, producerId2, baseSequence2, partitionLeaderEpoch2, i, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeCompressedV1() {
        MemoryRecords records;
        long now = System.currentTimeMillis();
        MemoryRecords x$1 = records = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        kafka.common.LongRef x$2 = new kafka.common.LongRef(0L);
        Time x$3 = this.time();
        long x$4 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$5 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        byte x$7 = 1;
        boolean x$8 = false;
        TimestampType x$9 = TimestampType.CREATE_TIME;
        long x$10 = 1000L;
        int x$11 = -1;
        boolean x$12 = true;
        ApiVersion x$13 = ApiVersion$.MODULE$.latestVersion();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$1, x$2, x$3, x$4, (CompressionCodec)x$5, (CompressionCodec)x$6, x$8, x$7, x$9, x$10, x$11, x$12, x$13);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeCompressedV2() {
        MemoryRecords records;
        long now = System.currentTimeMillis();
        MemoryRecords x$1 = records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        kafka.common.LongRef x$2 = new kafka.common.LongRef(0L);
        Time x$3 = this.time();
        long x$4 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$5 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        byte x$7 = 1;
        boolean x$8 = false;
        TimestampType x$9 = TimestampType.CREATE_TIME;
        long x$10 = 1000L;
        int x$11 = -1;
        boolean x$12 = true;
        ApiVersion x$13 = ApiVersion$.MODULE$.latestVersion();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$1, x$2, x$3, x$4, (CompressionCodec)x$5, (CompressionCodec)x$6, x$8, x$7, x$9, x$10, x$11, x$12, x$13);
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords x$4 = records;
        kafka.common.LongRef x$5 = new kafka.common.LongRef((long)offset);
        Time x$6 = this.time();
        long x$7 = System.currentTimeMillis();
        NoCompressionCodec$ x$8 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$9 = NoCompressionCodec$.MODULE$;
        byte x$10 = 0;
        boolean x$11 = false;
        TimestampType x$12 = TimestampType.CREATE_TIME;
        long x$13 = 1000L;
        int x$14 = -1;
        boolean x$15 = true;
        ApiVersion x$16 = ApiVersion$.MODULE$.latestVersion();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$4, x$5, x$6, x$7, (CompressionCodec)x$8, (CompressionCodec)x$9, x$11, x$10, x$12, x$13, x$14, x$15, x$16).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test(expected=InvalidRecordException.class)
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion());
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator.ValidationAndOffsetAssignResult result = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, false, ApiVersion$.MODULE$.latestVersion());
        List batches = TestUtils.toList((Iterable)result.validatedRecords().batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        MutableRecordBatch batch = (MutableRecordBatch)batches.get(0);
        Assert.assertFalse((boolean)batch.isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion()).validatedRecords(), offset);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidInnerMagicVersion() {
        int offset = 1234567;
        MemoryRecords records = this.recordsWithInvalidInnerMagic(offset);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)SnappyCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion());
    }

    @Test(expected=InvalidRecordException.class)
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test(expected=UnsupportedCompressionTypeException.class)
    public void testZStdCompressedWithUnavailableIBPVersion() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)ZStdCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, (ApiVersion)KAFKA_2_0_IV1$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    private void testBatchWithoutRecordsNotAllowed(CompressionCodec sourceCodec, CompressionCodec targetCodec) {
        int offset = 1234567;
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40));
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        Tuple5 tuple52 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
        Tuple5 tuple53 = tuple52;
        long producerId2 = BoxesRunTime.unboxToLong((Object)tuple53._1());
        short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple53._2());
        int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple53._3());
        boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple53._4());
        int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple53._5());
        ByteBuffer buffer = ByteBuffer.allocate(61);
        DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (long)0L, (long)5L, (int)partitionLeaderEpoch2, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)isTransactional2, (boolean)false);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), sourceCodec, targetCodec, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion());
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    public void checkOffsets(MemoryRecords records, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (boolean)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).nonEmpty());
        LongRef offset = LongRef.create((long)baseOffset);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            LogValidatorTest.$anonfun$checkOffsets$1(offset, entry);
            return BoxedUnit.UNIT;
        });
    }

    private MemoryRecords recordsWithInvalidInnerMagic(long initialOffset) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.sizeInBytes()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        LongRef offset = LongRef.create((long)initialOffset);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        RecordBatch recordBatch = batch;
        if (recordBatch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)recordBatch;
            Assert.assertEquals((String)new StringBuilder(35).append("Unexpected base timestamp of batch ").append(batch).toString(), (long)expected, (long)defaultRecordBatch.firstTimestamp());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assert.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringBuilder(34).append("Unexpected max timestamp of batch ").append(batch).toString(), (long)expectedLogAppendTime, (long)batch.maxTimestamp());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$validateLogAppendTime$1(expectedLogAppendTime, record);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records, boolean compressed) {
        Assert.assertNotNull((String)"Records processing info is null", (Object)stats);
        Assert.assertEquals((long)numConvertedRecords, (long)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assert.assertTrue((String)new StringBuilder(29).append("Conversion time not recorded ").append(stats).toString(), (stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringBuilder(26).append("Conversion time not valid ").append(stats).toString(), (stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0);
        }
        int originalSize = records.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assert.assertTrue((String)new StringBuilder(35).append("Temp bytes too small, orig=").append(originalSize).append(" actual=").append(tempBytes).toString(), (tempBytes > (long)originalSize ? 1 : 0) != 0);
        } else if (numConvertedRecords > 0 || compressed) {
            Assert.assertTrue((String)"Temp bytes not updated", (tempBytes > 0L ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)tempBytes);
        }
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$3(Seq timestampSeq$1, IntRef i$1, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(i$1.elem)), (long)record.timestamp());
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$1(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$1, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$1, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$1, (long)batch.baseSequence());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
        Assert.assertEquals((long)partitionLeaderEpoch$1, (long)batch.partitionLeaderEpoch());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkNonCompressed$3(timestampSeq$1, i$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$3(Seq timestampSeq$2, IntRef i$2, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(i$2.elem)), (long)record.timestamp());
        ++i$2.elem;
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$1(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$2, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$2, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$2, (long)batch.baseSequence());
        Assert.assertEquals((long)partitionLeaderEpoch$2, (long)batch.partitionLeaderEpoch());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkRecompression$3(timestampSeq$2, i$2, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkCreateTimeUpConversionFromV0$1(LogValidatorTest $this, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
        Assert.assertEquals((long)-1L, (long)batch.maxTimestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
        Assert.assertEquals((long)-1L, (long)batch.producerId());
        Assert.assertEquals((long)-1L, (long)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$testCreateTimeUpConversionV1ToV2$1(LogValidatorTest $this, long timestamp$1, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(timestamp$1, (RecordBatch)batch);
        Assert.assertEquals((long)timestamp$1, (long)batch.maxTimestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
        Assert.assertEquals((long)-1L, (long)batch.producerId());
        Assert.assertEquals((long)-1L, (long)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$3(Seq timestampSeq$3, IntRef i$3, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(i$3.elem)), (long)record.timestamp());
        ++i$3.elem;
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$1(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$3, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$3, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$3, (long)batch.baseSequence());
        Assert.assertEquals((long)partitionLeaderEpoch$3, (long)batch.partitionLeaderEpoch());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkCompressed$3(timestampSeq$3, i$3, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkOffsets$1(LongRef offset$1, Record entry) {
        Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)offset$1.elem, (long)entry.offset());
        ++offset$1.elem;
    }

    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1(int id) {
        return LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public static final /* synthetic */ void $anonfun$recordsWithInvalidInnerMagic$3(MemoryRecordsBuilder builder$1, LongRef offset$2, LegacyRecord record) {
        builder$1.appendUncheckedWithOffset(offset$2.elem, record);
        ++offset$2.elem;
    }

    public static final /* synthetic */ void $anonfun$validateLogAppendTime$1(long expectedLogAppendTime$1, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((String)new StringBuilder(31).append("Unexpected timestamp of record ").append(record).toString(), (long)expectedLogAppendTime$1, (long)record.timestamp());
    }
}

