/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.FixedPortTestUtils$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013%1\u0006\u0003\u00043\u0001\u0001\u0006I\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u0003,\u0011\u0019!\u0004\u0001)A\u0005Y!9Q\u0007\u0001b\u0001\n\u0013Y\u0003B\u0002\u001c\u0001A\u0003%A\u0006C\u00048\u0001\t\u0007I\u0011A\u0016\t\ra\u0002\u0001\u0015!\u0003-\u0011\u001dI\u0004A1A\u0005\niBaa\u0011\u0001!\u0002\u0013Y\u0004b\u0002#\u0001\u0005\u0004%IA\u000f\u0005\u0007\u000b\u0002\u0001\u000b\u0011B\u001e\t\u000f\u0019\u0003!\u0019!C\u0001\u000f\"1a\n\u0001Q\u0001\n!CQa\u0014\u0001\u0005BACQa\u0019\u0001\u0005\u0002\u0011DQ!\u001d\u0001\u0005\nID\u0011\"a\f\u0001#\u0003%I!!\r\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J\u00191\u00111\f\u0001\u0005\u0003;BaAJ\u000b\u0005\u0002\u0005-\u0004BBA9+\u0011\u0005C\r\u0003\u0004\u0002tU!\t\u0005\u001a\u0002\u0017)J\fgn]1di&|gn\u001d\"pk:\u001cW\rV3ti*\u00111\u0004H\u0001\u0004CBL'\"A\u000f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0003Gq\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011QE\t\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011AG\u0001\u0013aJ|G-^2fe\n+hMZ3s'&TX-F\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\rIe\u000e^\u0001\u0014aJ|G-^2fe\n+hMZ3s'&TX\rI\u0001\u0016g\u0016\u0014h/\u001a:NKN\u001c\u0018mZ3NCb\u0014\u0015\u0010^3t\u0003Y\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKN\u0004\u0013!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u00159,XnU3sm\u0016\u00148/A\u0006ok6\u001cVM\u001d<feN\u0004\u0013aC8viB,H\u000fV8qS\u000e,\u0012a\u000f\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA\u0001\\1oO*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\">\u0005\u0019\u0019FO]5oO\u0006aq.\u001e;qkR$v\u000e]5dA\u0005Q\u0011N\u001c9viR{\u0007/[2\u0002\u0017%t\u0007/\u001e;U_BL7\rI\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\t\u0001\n\u0005\u0002J\u00196\t!J\u0003\u0002L\u007f\u0005!Q\u000f^5m\u0013\ti%J\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001c\u001c<feJLG-\u001b8h!J|\u0007o\u001d\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012!\u0015\t\u0004%jkfBA*Y\u001d\t!v+D\u0001V\u0015\t1f$\u0001\u0004=e>|GOP\u0005\u0002_%\u0011\u0011LL\u0001\ba\u0006\u001c7.Y4f\u0013\tYFLA\u0002TKFT!!\u0017\u0018\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001d\u0012AB:feZ,'/\u0003\u0002c?\nY1*\u00194lC\u000e{gNZ5h\u0003E!Xm\u001d;Ce>\\WM\u001d$bS2,(/\u001a\u000b\u0002KB\u0011QFZ\u0005\u0003O:\u0012A!\u00168ji\"\u0012\u0011#\u001b\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\fQA[;oSRT\u0011A\\\u0001\u0004_J<\u0017B\u00019l\u0005\u0011!Vm\u001d;\u0002E\r\u0014X-\u0019;f\u0007>t7/^7fe\u0006sGmU;cg\u000e\u0014\u0018NY3U_R{\u0007/[2t)\u001d\u0019\u0018\u0011BA\u000e\u0003K\u0001B\u0001\u001e?\u007f}6\tQO\u0003\u0002wo\u0006A1m\u001c8tk6,'O\u0003\u0002ys\u000691\r\\5f]R\u001c(BA\u000f{\u0015\tYX.\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003{V\u0014QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b\u0003B\u0017\u0000\u0003\u0007I1!!\u0001/\u0005\u0015\t%O]1z!\ri\u0013QA\u0005\u0004\u0003\u000fq#\u0001\u0002\"zi\u0016Dq!a\u0003\u0013\u0001\u0004\ti!A\u0004he>,\b/\u00133\u0011\t\u0005=\u0011q\u0003\b\u0005\u0003#\t\u0019\u0002\u0005\u0002U]%\u0019\u0011Q\u0003\u0018\u0002\rA\u0013X\rZ3g\u0013\r\u0011\u0015\u0011\u0004\u0006\u0004\u0003+q\u0003bBA\u000f%\u0001\u0007\u0011qD\u0001\u0007i>\u0004\u0018nY:\u0011\u000bI\u000b\t#!\u0004\n\u0007\u0005\rBL\u0001\u0003MSN$\b\"CA\u0014%A\u0005\t\u0019AA\u0015\u00035\u0011X-\u00193D_6l\u0017\u000e\u001e;fIB\u0019Q&a\u000b\n\u0007\u00055bFA\u0004C_>dW-\u00198\u0002Y\r\u0014X-\u0019;f\u0007>t7/^7fe\u0006sGmU;cg\u000e\u0014\u0018NY3U_R{\u0007/[2tI\u0011,g-Y;mi\u0012\u001aTCAA\u001aU\u0011\tI#!\u000e,\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0011/\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\nYDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAb\u0019:fCR,Gk\u001c9jGN$\"!a\u0013\u0011\r\u00055\u0013q\u000b\u0017-\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013!C5n[V$\u0018M\u00197f\u0015\r\t)FL\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA-\u0003\u001f\u00121!T1q\u0005=\u0011u.\u001e8dKN\u001b\u0007.\u001a3vY\u0016\u00148cA\u000b\u0002`A!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002fq\tQ!\u001e;jYNLA!!\u001b\u0002d\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e)\t\ti\u0007E\u0002\u0002pUi\u0011\u0001A\u0001\u0007I><vN]6\u0002\u0011MDW\u000f\u001e3po:\u0004")
public class TransactionsBounceTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int kafka$api$TransactionsBounceTest$$numPartitions;
    private final int numServers;
    private final String kafka$api$TransactionsBounceTest$$outputTopic;
    private final String inputTopic;
    private final Properties overridingProps = new Properties();

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    public int kafka$api$TransactionsBounceTest$$numPartitions() {
        return this.kafka$api$TransactionsBounceTest$$numPartitions;
    }

    public int numServers() {
        return this.numServers;
    }

    public String kafka$api$TransactionsBounceTest$$outputTopic() {
        return this.kafka$api$TransactionsBounceTest$$outputTopic;
    }

    private String inputTopic() {
        return this.inputTopic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), true, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testBrokerFailure() {
        String consumerGroup = "myGroup";
        int numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndSubscribeToTopics(consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), this.createConsumerAndSubscribeToTopics$default$3());
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer("test-txn", (Seq<KafkaServer>)this.servers(), 512, TestUtils$.MODULE$.createTransactionalProducer$default$4(), TestUtils$.MODULE$.createTransactionalProducer$default$5());
        producer.initTransactions();
        BounceScheduler scheduler = new BounceScheduler();
        scheduler.start();
        IntRef numMessagesProcessed = IntRef.create((int)0);
        IntRef iteration = IntRef.create((int)0);
        try {
            while (numMessagesProcessed.elem < numInputRecords) {
                int toRead = Math.min(200, numInputRecords - numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, toRead, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received ").append(records.size()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString());
                producer.beginTransaction();
                boolean shouldAbort = iteration.elem % 3 == 0;
                records.foreach((Function1 & Serializable & scala.Serializable)record -> producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), !shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Sent ").append(records.size()).append(" messages. Committing offsets.").toString());
                producer.sendOffsetsToTransaction((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions(consumer)).asJava(), consumerGroup);
                if (shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(records.size()).append(" messages.").toString());
                    producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(records.size()).append(" messages.").toString());
                    producer.commitTransaction();
                    numMessagesProcessed.elem += records.size();
                }
                ++iteration.elem;
            }
        }
        finally {
            producer.close();
            consumer.close();
        }
        scheduler.shutdown();
        KafkaConsumer<byte[], byte[]> verifyingConsumer = this.createConsumerAndSubscribeToTopics("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numInputRecords, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$7(recordsByPartition, record);
            return BoxedUnit.UNIT;
        });
        ListBuffer outputRecords = new ListBuffer();
        recordsByPartition.values().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionsBounceTest.$anonfun$testBrokerFailure$9(outputRecords, x0$1);
            return BoxedUnit.UNIT;
        });
        Set recordSet = outputRecords.toSet();
        Assert.assertEquals((long)numInputRecords, (long)recordSet.size());
        Set expectedValues = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numInputRecords).toSet();
        Assert.assertEquals((String)new StringBuilder(18).append("Missing messages: ").append(expectedValues.$minus$minus((GenTraversableOnce)recordSet)).toString(), (Object)expectedValues, (Object)recordSet);
        verifyingConsumer.close();
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndSubscribeToTopics(String groupId, List<String> topics, boolean readCommitted) {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$2 = groupId;
        boolean x$3 = readCommitted;
        boolean x$4 = false;
        String x$5 = TestUtils$.MODULE$.createConsumer$default$3();
        int x$6 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, x$2, x$5, x$4, x$3, x$6, x$7, x$8, x$9, x$10, x$11);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava());
        return consumer;
    }

    private boolean createConsumerAndSubscribeToTopics$default$3() {
        return false;
    }

    private scala.collection.immutable.Map<Object, Object> createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(this.inputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
        return this.createTopic(this.kafka$api$TransactionsBounceTest$$outputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
    }

    public static final /* synthetic */ void $anonfun$testBrokerFailure$7(HashMap recordsByPartition$1, ConsumerRecord record) {
        int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record))).toInt();
        TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
        ((BufferLike)recordsByPartition$1.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> new ListBuffer())).append((Seq)Predef$.MODULE$.wrapIntArray(new int[]{value}));
    }

    public static final /* synthetic */ void $anonfun$testBrokerFailure$9(ListBuffer outputRecords$1, ListBuffer x0$1) {
        ListBuffer listBuffer = x0$1;
        Assert.assertEquals((String)"Out of order messages detected", (Object)listBuffer, (Object)listBuffer.sorted((Ordering)Ordering.Int$.MODULE$));
        outputRecords$1.appendAll((TraversableOnce)listBuffer);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public TransactionsBounceTest() {
        this.producerBufferSize = 65536;
        this.kafka$api$TransactionsBounceTest$$numPartitions = 3;
        this.numServers = 4;
        this.kafka$api$TransactionsBounceTest$$outputTopic = "output-topic";
        this.inputTopic = "input-topic";
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.serverMessageMaxBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
    }

    public class BounceScheduler
    extends ShutdownableThread {
        public void doWork() {
            this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                BounceScheduler.$anonfun$doWork$1(this, server);
                return BoxedUnit.UNIT;
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$numPartitions()).foreach((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)partition -> TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().zkClient(), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$outputTopic(), partition, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6()));
        }

        public void shutdown() {
            super.shutdown();
        }

        public /* synthetic */ TransactionsBounceTest kafka$api$TransactionsBounceTest$BounceScheduler$$$outer() {
            return TransactionsBounceTest.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$1(BounceScheduler $this, KafkaServer server) {
            $this.trace((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Shutting down server : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            server.shutdown();
            server.awaitShutdown();
            Thread.sleep(500L);
            $this.trace((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Server %s shut down. Starting it up again.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            server.startup();
            $this.trace((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Restarted server: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            Thread.sleep(500L);
        }

        public BounceScheduler() {
            if (TransactionsBounceTest.this == null) {
                throw null;
            }
            super("daemon-broker-bouncer", false);
        }
    }
}

