/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.CustomQuotaCallbackTest$GroupedUser$;
import kafka.api.GroupedUserPrincipal;
import kafka.api.GroupedUserPrincipalBuilder;
import kafka.api.GroupedUserPrincipalBuilder$;
import kafka.api.GroupedUserQuotaCallback;
import kafka.api.GroupedUserQuotaCallback$;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.QuotaTestClients;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.JaasTestUtils$ScramLoginModule$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r5g\u0001\u0002-Z\u0001yCQA\u001a\u0001\u0005\u0002\u001dDQ!\u001b\u0001\u0005R)DQA\u001f\u0001\u0005RmDa!!\u0002\u0001\t#Z\bBCA\u0004\u0001!\u0015\r\u0011\"\u0015\u0002\n!I\u0011q\u0005\u0001C\u0002\u0013\u0005\u0013\u0011\u0006\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002,!I\u00111\u0007\u0001C\u0002\u0013%\u0011Q\u0007\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u00028!I\u0011\u0011\u000b\u0001C\u0002\u0013%\u00111\u000b\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002D!I\u0011q\u000b\u0001C\u0002\u0013E\u0013\u0011\f\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002\\!I\u00111\u000e\u0001C\u0002\u0013E\u0013\u0011\f\u0005\t\u0003[\u0002\u0001\u0015!\u0003\u0002\\!I\u0011q\u000e\u0001C\u0002\u0013%\u0011\u0011\u000f\u0005\t\u0003\u001f\u0003\u0001\u0015!\u0003\u0002t!Y\u0011\u0011\u0013\u0001A\u0002\u0003\u0007I\u0011BAJ\u0011-\ti\u000b\u0001a\u0001\u0002\u0004%I!a,\t\u0017\u0005m\u0006\u00011A\u0001B\u0003&\u0011Q\u0013\u0005\n\u0003{\u0003!\u0019!C\u0001\u0003SA\u0001\"a0\u0001A\u0003%\u00111\u0006\u0005\n\u0003\u0003\u0004!\u0019!C\u0001\u0003SA\u0001\"a1\u0001A\u0003%\u00111\u0006\u0005\n\u0003\u000b\u0004!\u0019!C\u0001\u0003SA\u0001\"a2\u0001A\u0003%\u00111\u0006\u0005\b\u0003\u0013\u0004A\u0011IAf\u0011\u001d\tY\u000e\u0001C!\u0003\u0017Dq!!:\u0001\t\u0003\nY\rC\u0004\u0002h\u0002!\t!a3\t\u000f\u0005E\b\u0001\"\u0003\u0002t\"91\u0011\u000f\u0001\u0005\n\rM\u0004bBB@\u0001\u0011%1\u0011\u0011\u0005\b\u0007\u0007\u0003A\u0011BBC\u0011\u001d\u0019i\t\u0001C\u0005\u0007\u001f3a!!?\u0001\u0001\u0006m\bB\u0003B\bI\tU\r\u0011\"\u0001\u0003\u0012!Q!q\u0005\u0013\u0003\u0012\u0003\u0006IAa\u0005\t\u0015\t%BE!f\u0001\n\u0003\u0011\t\u0002\u0003\u0006\u0003,\u0011\u0012\t\u0012)A\u0005\u0005'A!B!\f%\u0005+\u0007I\u0011\u0001B\t\u0011)\u0011y\u0003\nB\tB\u0003%!1\u0003\u0005\u000b\u0005c!#Q3A\u0005\u0002\tM\u0002B\u0003B!I\tE\t\u0015!\u0003\u00036!Q!1\t\u0013\u0003\u0016\u0004%\tA!\u0005\t\u0015\t\u0015CE!E!\u0002\u0013\u0011\u0019\u0002\u0003\u0006\u0003H\u0011\u0012)\u001a!C\u0001\u0005#A!B!\u0013%\u0005#\u0005\u000b\u0011\u0002B\n\u0011)\tY\n\nBK\u0002\u0013\u0005\u00131\u0013\u0005\r\u0005\u0017\"#\u0011#Q\u0001\n\u0005U%Q\n\u0005\u000b\u0005\u001f\"#Q3A\u0005B\tE\u0003\u0002\u0004B/I\tE\t\u0015!\u0003\u0003T\t}\u0003B\u00024%\t\u0003\u0011\t\u0007C\u0004\u0003t\u0011\"\tE!\u001e\t\u000f\tuD\u0005\"\u0011\u0003\u0000!9!1\u0012\u0013\u0005B\t5\u0005b\u0002BTI\u0011\u0005\u00131\u001a\u0005\b\u0005S#C\u0011\u0001BV\u0011\u001d\u0011)\f\nC\u0001\u0005oC\u0011Ba4%#\u0003%\tA!5\t\u0013\t\u001dH%%A\u0005\u0002\t%\bb\u0002BwI\u0011\u0005!q\u001e\u0005\b\u0005\u007f$C\u0011AAf\u0011\u001d\u0019\t\u0001\nC\u0005\u0007\u0007A\u0011ba\u0002%\u0003\u0003%\ta!\u0003\t\u0013\rmA%%A\u0005\u0002\ru\u0001\"CB\u0011IE\u0005I\u0011AB\u000f\u0011%\u0019\u0019\u0003JI\u0001\n\u0003\u0019i\u0002C\u0005\u0004&\u0011\n\n\u0011\"\u0001\u0004(!I11\u0006\u0013\u0012\u0002\u0013\u00051Q\u0004\u0005\n\u0007[!\u0013\u0013!C\u0001\u0007;A\u0011ba\f%#\u0003%\ta!\r\t\u0013\rUB%%A\u0005\u0002\r]\u0002\"CB\u001eI\u0005\u0005I\u0011IA*\u0011%\u0019i\u0004JA\u0001\n\u0003\tI\u0003C\u0005\u0004@\u0011\n\t\u0011\"\u0001\u0004B!I11\n\u0013\u0002\u0002\u0013\u00053Q\n\u0005\n\u0007+\"\u0013\u0011!C\u0001\u0007/B\u0011ba\u0017%\u0003\u0003%\te!\u0018\t\u0013\r}C%!A\u0005B\r\u0005\u0004\"CB2I\u0005\u0005I\u0011IB3\u000f%\u0019)\nAA\u0001\u0012\u0003\u00199JB\u0005\u0002z\u0002\t\t\u0011#\u0001\u0004\u001a\"1am\u0015C\u0001\u0007OC\u0011ba\u0018T\u0003\u0003%)e!\u0019\t\u0013\r%6+!A\u0005\u0002\u000e-\u0006\"CB_'\u0006\u0005I\u0011QB`\u0005]\u0019Uo\u001d;p[F+x\u000e^1DC2d'-Y2l)\u0016\u001cHO\u0003\u0002[7\u0006\u0019\u0011\r]5\u000b\u0003q\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001?\u000e\u0004\"\u0001Y1\u000e\u0003eK!AY-\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\u0004\"\u0001\u00193\n\u0005\u0015L&!C*bg2\u001cV\r^;q\u0003\u0019a\u0014N\\5u}Q\t\u0001\u000e\u0005\u0002a\u0001\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002WB\u0011A\u000e_\u0007\u0002[*\u0011an\\\u0001\u0005CV$\bN\u0003\u0002qc\u0006A1/Z2ve&$\u0018P\u0003\u0002sg\u000611m\\7n_:T!\u0001\u0018;\u000b\u0005U4\u0018AB1qC\u000eDWMC\u0001x\u0003\ry'oZ\u0005\u0003s6\u0014\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0016\u0003q\u00042!`A\u0001\u001b\u0005q(BA@r\u0003\u001dqW\r^<pe.L1!a\u0001\u007f\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003]Ig\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW-\u0001\bueV\u001cHo\u0015;pe\u00164\u0015\u000e\\3\u0016\u0005\u0005-\u0001CBA\u0007\u0003'\t9\"\u0004\u0002\u0002\u0010)\u0011\u0011\u0011C\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003+\tyA\u0001\u0003T_6,\u0007\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u0003S>T!!!\t\u0002\t)\fg/Y\u0005\u0005\u0003K\tYB\u0001\u0003GS2,\u0017a\u00032s_.,'oQ8v]R,\"!a\u000b\u0011\t\u00055\u0011QF\u0005\u0005\u0003_\tyAA\u0002J]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\u0011\u0011q\u0007\t\u0007\u0003s\ty$a\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u001f\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t%a\u000f\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002F\u0005-SBAA$\u0015\u0011\tI%a\b\u0002\t1\fgnZ\u0005\u0005\u0003\u001b\n9E\u0001\u0004TiJLgnZ\u0001\u001bW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7\u000fI\u0001\u0019W\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNlWCAA\"\u0003eY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\u001c\u0011\u0002)M,'O^3s'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t+\t\tY\u0006\u0005\u0004\u0002\u000e\u0005M\u0011Q\f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)!\u00111MA\u0010\u0003\u0011)H/\u001b7\n\t\u0005\u001d\u0014\u0011\r\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!F:feZ,'oU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0015G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:\u0002+\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA\u0005a\u0011\rZ7j]\u000ec\u0017.\u001a8ugV\u0011\u00111\u000f\t\u0007\u0003k\nY(a \u000e\u0005\u0005]$\u0002BA=\u0003w\tq!\\;uC\ndW-\u0003\u0003\u0002~\u0005]$aC!se\u0006L()\u001e4gKJ\u0004B!!!\u0002\f6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0003bI6LgNC\u0002\u0002\nN\fqa\u00197jK:$8/\u0003\u0003\u0002\u000e\u0006\r%aC!e[&t7\t\\5f]R\fQ\"\u00193nS:\u001cE.[3oiN\u0004\u0013\u0001\u00069s_\u0012,8-\u001a:XSRDw.\u001e;Rk>$\u0018-\u0006\u0002\u0002\u0016BA\u0011qSAO\u0003C\u000b\t+\u0004\u0002\u0002\u001a*!\u00111TAD\u0003!\u0001(o\u001c3vG\u0016\u0014\u0018\u0002BAP\u00033\u0013QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bCBA\u0007\u0003G\u000b9+\u0003\u0003\u0002&\u0006=!!B!se\u0006L\b\u0003BA\u0007\u0003SKA!a+\u0002\u0010\t!!)\u001f;f\u0003a\u0001(o\u001c3vG\u0016\u0014x+\u001b;i_V$\u0018+^8uC~#S-\u001d\u000b\u0005\u0003c\u000b9\f\u0005\u0003\u0002\u000e\u0005M\u0016\u0002BA[\u0003\u001f\u0011A!\u00168ji\"I\u0011\u0011X\n\u0002\u0002\u0003\u0007\u0011QS\u0001\u0004q\u0012\n\u0014!\u00069s_\u0012,8-\u001a:XSRDw.\u001e;Rk>$\u0018\rI\u0001\u0014I\u00164\u0017-\u001e7u%\u0016\fX/Z:u#V|G/Y\u0001\u0015I\u00164\u0017-\u001e7u%\u0016\fX/Z:u#V|G/\u0019\u0011\u0002'\u0011,g-Y;miB\u0013x\u000eZ;dKF+x\u000e^1\u0002)\u0011,g-Y;miB\u0013x\u000eZ;dKF+x\u000e^1!\u0003M!WMZ1vYR\u001cuN\\:v[\u0016\fVo\u001c;b\u0003Q!WMZ1vYR\u001cuN\\:v[\u0016\fVo\u001c;bA\u0005)1/\u001a;VaR\u0011\u0011\u0011\u0017\u0015\u00047\u0005=\u0007\u0003BAi\u0003/l!!a5\u000b\u0007\u0005Ug/A\u0003kk:LG/\u0003\u0003\u0002Z\u0006M'A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\ra\u0012q\u001c\t\u0005\u0003#\f\t/\u0003\u0003\u0002d\u0006M'!B!gi\u0016\u0014\u0018aI2p]\u001aLw-\u001e:f'\u0016\u001cWO]5us\n+gm\u001c:f'\u0016\u0014h/\u001a:t'R\f'\u000f^\u0001\u0018i\u0016\u001cHoQ;ti>l\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.D3AHAv!\u0011\t\t.!<\n\t\u0005=\u00181\u001b\u0002\u0005)\u0016\u001cH/\u0001\fde\u0016\fG/Z$s_V\u0004x+\u001b;i\u001f:,Wk]3s)\u0019\t)p!\u001b\u0004nA\u0019\u0011q\u001f\u0013\u000e\u0003\u0001\u00111b\u0012:pkB,G-V:feN9A%!@\u0003\u0004\t%\u0001c\u00011\u0002\u0000&\u0019!\u0011A-\u0003!E+x\u000e^1UKN$8\t\\5f]R\u001c\b\u0003BA\u0007\u0005\u000bIAAa\u0002\u0002\u0010\t9\u0001K]8ek\u000e$\b\u0003BA\u0007\u0005\u0017IAA!\u0004\u0002\u0010\ta1+\u001a:jC2L'0\u00192mK\u0006!Qo]3s+\t\u0011\u0019\u0002\u0005\u0003\u0003\u0016\t\rb\u0002\u0002B\f\u0005?\u0001BA!\u0007\u0002\u00105\u0011!1\u0004\u0006\u0004\u0005;i\u0016A\u0002\u001fs_>$h(\u0003\u0003\u0003\"\u0005=\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002N\t\u0015\"\u0002\u0002B\u0011\u0003\u001f\tQ!^:fe\u0002\n\u0011\"^:fe\u001e\u0013x.\u001e9\u0002\u0015U\u001cXM]$s_V\u0004\b%A\u0003u_BL7-\u0001\u0004u_BL7\rI\u0001\u000bY\u0016\fG-\u001a:O_\u0012,WC\u0001B\u001b!\u0011\u00119D!\u0010\u000e\u0005\te\"b\u0001B\u001e7\u000611/\u001a:wKJLAAa\u0010\u0003:\tY1*\u00194lCN+'O^3s\u0003-aW-\u00193fe:{G-\u001a\u0011\u0002!A\u0014x\u000eZ;dKJ\u001cE.[3oi&#\u0017!\u00059s_\u0012,8-\u001a:DY&,g\u000e^%eA\u0005\u00012m\u001c8tk6,'o\u00117jK:$\u0018\nZ\u0001\u0012G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012\u0004\u0013!\u00039s_\u0012,8-\u001a:!\u0013\u0011\tY*a@\u0002\u0011\r|gn];nKJ,\"Aa\u0015\u0011\u0011\tU#\u0011LAQ\u0003Ck!Aa\u0016\u000b\t\t=\u0013qQ\u0005\u0005\u00057\u00129FA\u0007LC\u001a\\\u0017mQ8ogVlWM]\u0001\nG>t7/^7fe\u0002JAAa\u0014\u0002\u0000R\u0011\u0012Q\u001fB2\u0005K\u00129G!\u001b\u0003l\t5$q\u000eB9\u0011\u001d\u0011y!\u000ea\u0001\u0005'AqA!\u000b6\u0001\u0004\u0011\u0019\u0002C\u0004\u0003.U\u0002\rAa\u0005\t\u000f\tER\u00071\u0001\u00036!9!1I\u001bA\u0002\tM\u0001b\u0002B$k\u0001\u0007!1\u0003\u0005\b\u00037+\u0004\u0019AAK\u0011\u001d\u0011y%\u000ea\u0001\u0005'\nQ\"^:feB\u0013\u0018N\\2ja\u0006dWC\u0001B<!\ra'\u0011P\u0005\u0004\u0005wj'AD&bM.\f\u0007K]5oG&\u0004\u0018\r\\\u0001\u0010cV|G/Y'fiJL7\rV1hgR!!\u0011\u0011BD!!\u0011)Ba!\u0003\u0014\tM\u0011\u0002\u0002BC\u0005K\u00111!T1q\u0011\u001d\u0011Ii\u000ea\u0001\u0005'\t\u0001b\u00197jK:$\u0018\nZ\u0001\u000f_Z,'O]5eKF+x\u000e^1t)!\t\tLa$\u0003\u001a\nu\u0005b\u0002BIq\u0001\u0007!1S\u0001\u000eaJ|G-^2feF+x\u000e^1\u0011\t\u00055!QS\u0005\u0005\u0005/\u000byA\u0001\u0003M_:<\u0007b\u0002BNq\u0001\u0007!1S\u0001\u000eG>t7/^7feF+x\u000e^1\t\u000f\t}\u0005\b1\u0001\u0003\"\u0006a!/Z9vKN$\u0018+^8uCB!\u0011Q\u0002BR\u0013\u0011\u0011)+a\u0004\u0003\r\u0011{WO\u00197f\u0003Q\u0011X-\\8wKF+x\u000e^1Pm\u0016\u0014(/\u001b3fg\u0006q1m\u001c8gS\u001e,(/Z)v_R\fGCCAY\u0005[\u0013yK!-\u00034\"9!\u0011\u0006\u001eA\u0002\tM\u0001b\u0002BIu\u0001\u0007!1\u0013\u0005\b\u00057S\u0004\u0019\u0001BJ\u0011\u001d\u0011yJ\u000fa\u0001\u0005C\u000b\u0001dY8oM&<WO]3B]\u0012<\u0016-\u001b;G_J\fVo\u001c;b))\t\tL!/\u0003>\n\u0005'Q\u0019\u0005\b\u0005w[\u0004\u0019\u0001BJ\u00031\u0001(o\u001c3vG\u0016\fVo\u001c;b\u0011\u001d\u0011yl\u000fa\u0001\u0005'\u000b!BZ3uG\"\fVo\u001c;b\u0011%\u0011\u0019m\u000fI\u0001\u0002\u0004\tY#A\u0004eSZL7o\u001c:\t\u0013\t\u001d7\b%AA\u0002\t%\u0017!B4s_V\u0004\bCBA\u0007\u0005\u0017\u0014\u0019\"\u0003\u0003\u0003N\u0006=!AB(qi&|g.\u0001\u0012d_:4\u0017nZ;sK\u0006sGmV1ji\u001a{'/U;pi\u0006$C-\u001a4bk2$HeM\u000b\u0003\u0005'TC!a\u000b\u0003V.\u0012!q\u001b\t\u0005\u00053\u0014\u0019/\u0004\u0002\u0003\\*!!Q\u001cBp\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003b\u0006=\u0011AC1o]>$\u0018\r^5p]&!!Q\u001dBn\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001#G>tg-[4ve\u0016\fe\u000eZ,bSR4uN])v_R\fG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t-(\u0006\u0002Be\u0005+\fa\u0002\u001d:pIV\u001cWmQ8ogVlW\r\u0006\u0004\u00022\nE(1 \u0005\b\u0005gt\u0004\u0019\u0001B{\u0003U)\u0007\u0010]3diB\u0013x\u000eZ;dKRC'o\u001c;uY\u0016\u0004B!!\u0004\u0003x&!!\u0011`A\b\u0005\u001d\u0011un\u001c7fC:DqA!@?\u0001\u0004\u0011)0A\u000bfqB,7\r^\"p]N,X.\u001a+ie>$H\u000f\\3\u0002+I,Wn\u001c<f)\"\u0014x\u000e\u001e;mK6+GO]5dg\u0006y\u0011/^8uC\u0016sG/\u001b;z\u001d\u0006lW\r\u0006\u0003\u0003\u0014\r\u0015\u0001b\u0002B\u0015\u0001\u0002\u0007!1C\u0001\u0005G>\u0004\u0018\u0010\u0006\n\u0002v\u000e-1QBB\b\u0007#\u0019\u0019b!\u0006\u0004\u0018\re\u0001\"\u0003B\b\u0003B\u0005\t\u0019\u0001B\n\u0011%\u0011I#\u0011I\u0001\u0002\u0004\u0011\u0019\u0002C\u0005\u0003.\u0005\u0003\n\u00111\u0001\u0003\u0014!I!\u0011G!\u0011\u0002\u0003\u0007!Q\u0007\u0005\n\u0005\u0007\n\u0005\u0013!a\u0001\u0005'A\u0011Ba\u0012B!\u0003\u0005\rAa\u0005\t\u0013\u0005m\u0015\t%AA\u0002\u0005U\u0005\"\u0003B(\u0003B\u0005\t\u0019\u0001B*\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"aa\b+\t\tM!Q[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0004*)\"!Q\u0007Bk\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nabY8qs\u0012\"WMZ1vYR$c'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\rM\"\u0006BAK\u0005+\fabY8qs\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0004:)\"!1\u000bBk\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BB\"\u0007\u0013\u0002B!!\u0004\u0004F%!1qIA\b\u0005\r\te.\u001f\u0005\n\u0003sc\u0015\u0011!a\u0001\u0003W\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007\u001f\u0002b!!\u000f\u0004R\r\r\u0013\u0002BB*\u0003w\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!Q_B-\u0011%\tILTA\u0001\u0002\u0004\u0019\u0019%\u0001\u0005iCND7i\u001c3f)\t\tY#\u0001\u0005u_N#(/\u001b8h)\t\t\u0019%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005k\u001c9\u0007C\u0005\u0002:F\u000b\t\u00111\u0001\u0004D!911N\u0010A\u0002\tM\u0011!\u00034jeN$Xk]3s\u0011\u001d\u0019yg\ba\u0001\u0003W\t\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\fGJ,\u0017\r^3U_BL7\r\u0006\u0005\u00022\u000eU4qOB>\u0011\u001d\u0011i\u0003\ta\u0001\u0005'Aqa!\u001f!\u0001\u0004\tY#A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u0007{\u0002\u0003\u0019AA\u0016\u0003\u0019aW-\u00193fe\u0006\t2M]3bi\u0016\fE-\\5o\u00072LWM\u001c;\u0015\u0005\u0005}\u0014A\u00069s_\u0012,8-Z,ji\"|W\u000f\u001e+ie>$H\u000f\\3\u0015\r\u0005E6qQBE\u0011\u001d\u0011iC\ta\u0001\u0005'Aqaa##\u0001\u0004\tY#\u0001\u0006ok6\u0014VmY8sIN\fq!\u00193e+N,'\u000f\u0006\u0004\u0002v\u000eE51\u0013\u0005\b\u0005\u001f\u0019\u0003\u0019\u0001B\n\u0011\u001d\u0019ih\ta\u0001\u0003W\t1b\u0012:pkB,G-V:feB\u0019\u0011q_*\u0014\u000bM\u001bYJ!\u0003\u0011-\ru51\u0015B\n\u0005'\u0011\u0019B!\u000e\u0003\u0014\tM\u0011Q\u0013B*\u0003kl!aa(\u000b\t\r\u0005\u0016qB\u0001\beVtG/[7f\u0013\u0011\u0019)ka(\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\b\u0006\u0002\u0004\u0018\u0006)\u0011\r\u001d9msR\u0011\u0012Q_BW\u0007_\u001b\tla-\u00046\u000e]6\u0011XB^\u0011\u001d\u0011yA\u0016a\u0001\u0005'AqA!\u000bW\u0001\u0004\u0011\u0019\u0002C\u0004\u0003.Y\u0003\rAa\u0005\t\u000f\tEb\u000b1\u0001\u00036!9!1\t,A\u0002\tM\u0001b\u0002B$-\u0002\u0007!1\u0003\u0005\b\u000373\u0006\u0019AAK\u0011\u001d\u0011yE\u0016a\u0001\u0005'\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004B\u000e%\u0007CBA\u0007\u0005\u0017\u001c\u0019\r\u0005\u000b\u0002\u000e\r\u0015'1\u0003B\n\u0005'\u0011)Da\u0005\u0003\u0014\u0005U%1K\u0005\u0005\u0007\u000f\fyA\u0001\u0004UkBdW\r\u000f\u0005\n\u0007\u0017<\u0016\u0011!a\u0001\u0003k\f1\u0001\u001f\u00131\u0001")
public class CustomQuotaCallbackTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private volatile CustomQuotaCallbackTest$GroupedUser$ GroupedUser$module;
    private final int brokerCount;
    private final Seq<String> kafkaServerSaslMechanisms;
    private final String kafkaClientSaslMechanism;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final ArrayBuffer<AdminClient> adminClients;
    private KafkaProducer<byte[], byte[]> producerWithoutQuota;
    private final int defaultRequestQuota;
    private final int defaultProduceQuota;
    private final int defaultConsumeQuota;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    public CustomQuotaCallbackTest$GroupedUser$ GroupedUser() {
        if (this.GroupedUser$module == null) {
            this.GroupedUser$lzycompute$1();
        }
        return this.GroupedUser$module;
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName("BROKER");
    }

    private Some<File> trustStoreFile$lzycompute() {
        CustomQuotaCallbackTest customQuotaCallbackTest = this;
        synchronized (customQuotaCallbackTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        return !this.bitmap$0 ? this.trustStoreFile$lzycompute() : this.trustStoreFile;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private Seq<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    private ArrayBuffer<AdminClient> adminClients() {
        return this.adminClients;
    }

    private KafkaProducer<byte[], byte[]> producerWithoutQuota() {
        return this.producerWithoutQuota;
    }

    private void producerWithoutQuota_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producerWithoutQuota = x$1;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public int defaultProduceQuota() {
        return this.defaultProduceQuota;
    }

    public int defaultConsumeQuota() {
        return this.defaultConsumeQuota;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections(this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)"SCRAM-SHA-256"), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), GroupedUserQuotaCallback.class.getName());
        this.serverConfig().setProperty(new StringBuilder(0).append(this.listenerName().configPrefix()).append(KafkaConfig$.MODULE$.PrincipalBuilderClassProp()).toString(), GroupedUserPrincipalBuilder.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
        super.setUp();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.producerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        this.producerWithoutQuota_$eq(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()));
    }

    @Override
    @After
    public void tearDown() {
        this.adminClients().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        GroupedUserQuotaCallback$.MODULE$.tearDown();
        super.tearDown();
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Test
    public void testCustomQuotaCallback() {
        GroupedUser user;
        int brokerId = 0;
        GroupedUser qual$1 = user = this.createGroupWithOneUser("group0_user1", brokerId);
        long x$1 = 1000000L;
        long x$22 = 2000000L;
        int x$3 = qual$1.configureAndWaitForQuota$default$3();
        Option<String> x$4 = qual$1.configureAndWaitForQuota$default$4();
        qual$1.configureAndWaitForQuota(x$1, x$22, x$3, x$4);
        GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.set(0);
            return BoxedUnit.UNIT;
        });
        user.produceConsume(false, false);
        Assert.assertEquals((long)1L, (long)((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.PRODUCE)).get());
        Assert.assertEquals((long)1L, (long)((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.FETCH)).get());
        Assert.assertTrue((String)new StringBuilder(26).append("Too many quotaLimit calls ").append(GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls()).toString(), (((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.REQUEST)).get() <= 10 ? 1 : 0) != 0);
        GroupedUser qual$2 = user;
        long x$5 = 9000L;
        long x$6 = 3000L;
        int x$7 = qual$2.configureAndWaitForQuota$default$3();
        Option<String> x$8 = qual$2.configureAndWaitForQuota$default$4();
        qual$2.configureAndWaitForQuota(x$5, x$6, x$7, x$8);
        user.produceConsume(true, true);
        user = this.addUser("group0_user2", brokerId);
        user.removeQuotaOverrides();
        GroupedUser qual$3 = user;
        long x$9 = this.defaultProduceQuota();
        long x$10 = this.defaultConsumeQuota();
        double x$11 = this.defaultRequestQuota();
        KafkaServer x$12 = qual$3.waitForQuotaUpdate$default$4();
        qual$3.waitForQuotaUpdate(x$9, x$10, x$11, x$12);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        user.configureAndWaitForQuota(8000L, 2500L, 1, (Option<String>)None$.MODULE$);
        user.produceConsume(true, true);
        GroupedUser qual$4 = user = this.addUser("group0_user3", brokerId);
        long x$13 = 2000000L;
        long x$14 = 2000000L;
        int x$15 = qual$4.configureAndWaitForQuota$default$3();
        Option<String> x$16 = qual$4.configureAndWaitForQuota$default$4();
        qual$4.configureAndWaitForQuota(x$13, x$14, x$15, x$16);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        brokerId = 1;
        GroupedUser qual$5 = user = this.createGroupWithOneUser("group1_user1", brokerId);
        long x$17 = 800000L;
        long x$18 = 250000L;
        int x$19 = qual$5.configureAndWaitForQuota$default$3();
        Option<String> x$20 = qual$5.configureAndWaitForQuota$default$4();
        qual$5.configureAndWaitForQuota(x$17, x$18, x$19, x$20);
        user.produceConsume(false, false);
        String largeTopic = "group1_largeTopic";
        this.createTopic(largeTopic, 99, 0);
        GroupedUser qual$6 = user;
        long x$21 = 8000L;
        long x$222 = 2500L;
        double x$23 = this.defaultRequestQuota();
        KafkaServer x$24 = qual$6.waitForQuotaUpdate$default$4();
        qual$6.waitForQuotaUpdate(x$21, x$222, x$23, x$24);
        user.produceConsume(true, true);
        GroupedUser qual$7 = user = this.addUser("group1_user2", brokerId);
        long x$25 = this.defaultProduceQuota() / 100;
        long x$26 = this.defaultConsumeQuota() / 100;
        double x$27 = this.defaultRequestQuota();
        KafkaServer x$28 = qual$7.waitForQuotaUpdate$default$4();
        qual$7.waitForQuotaUpdate(x$25, x$26, x$27, x$28);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        user.configureAndWaitForQuota(800000L, 250000L, 100, (Option<String>)None$.MODULE$);
        user.produceConsume(true, true);
        this.adminZkClient().deleteTopic(largeTopic);
        GroupedUser qual$8 = user = this.addUser("group1_user3", brokerId);
        long x$29 = 800000L;
        long x$30 = 250000L;
        double x$31 = this.defaultRequestQuota();
        KafkaServer x$32 = qual$8.waitForQuotaUpdate$default$4();
        qual$8.waitForQuotaUpdate(x$29, x$30, x$31, x$32);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        AdminClient adminClient = this.createAdminClient();
        Properties newProps = new Properties();
        newProps.put(GroupedUserQuotaCallback$.MODULE$.DefaultProduceQuotaProp(), "8000");
        newProps.put(GroupedUserQuotaCallback$.MODULE$.DefaultFetchQuotaProp(), "2500");
        TestUtils$.MODULE$.alterConfigs((Seq<KafkaServer>)this.servers(), adminClient, newProps, false);
        GroupedUser qual$9 = user;
        long x$33 = 8000L;
        long x$34 = 2500L;
        double x$35 = this.defaultRequestQuota();
        KafkaServer x$36 = qual$9.waitForQuotaUpdate$default$4();
        qual$9.waitForQuotaUpdate(x$33, x$34, x$35, x$36);
        user.produceConsume(true, true);
        Assert.assertEquals((long)this.brokerCount(), (long)GroupedUserQuotaCallback$.MODULE$.callbackInstances().get());
    }

    /*
     * WARNING - void declaration
     */
    private GroupedUser createGroupWithOneUser(String firstUser, int brokerId) {
        void var3_3;
        GroupedUser user = this.addUser(firstUser, brokerId);
        this.createTopic(user.topic(), 1, brokerId);
        user.configureAndWaitForQuota(this.defaultProduceQuota(), this.defaultConsumeQuota(), 1, (Option<String>)None$.MODULE$);
        return var3_3;
    }

    private void createTopic(String topic, int numPartitions, int leader) {
        scala.collection.immutable.Map assignment = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}))), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)this.servers());
    }

    /*
     * WARNING - void declaration
     */
    private AdminClient createAdminClient() {
        void var2_2;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), new ListenerName("BROKER")));
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.clientSecurityProps("admin-client")).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Object value = tuple2._2();
            Object object = config.put(key.toString(), (String)value);
            return object;
        });
        config.put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        AdminClient adminClient = AdminClient.create(config);
        this.adminClients().$plus$eq((Object)adminClient);
        return var2_2;
    }

    public void kafka$api$CustomQuotaCallbackTest$$produceWithoutThrottle(String topic, int numRecords) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)i -> CustomQuotaCallbackTest.$anonfun$produceWithoutThrottle$1(this, topic, BoxesRunTime.unboxToInt((Object)i)));
    }

    private GroupedUser addUser(String user, int leader) {
        String password = new StringBuilder(7).append(user).append(":secret").toString();
        this.createScramCredentials(this.zkConnect(), user, password);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            CustomQuotaCallbackTest.$anonfun$addUser$1(this, user, server);
            return BoxedUnit.UNIT;
        });
        String userGroup = GroupedUserPrincipalBuilder$.MODULE$.group(user);
        String topic = new StringBuilder(6).append(userGroup).append("_topic").toString();
        String producerClientId = new StringBuilder(19).append(user).append(":producer-client-id").toString();
        String consumerClientId = new StringBuilder(19).append(user).append(":consumer-client-id").toString();
        this.producerConfig().put("client.id", producerClientId);
        this.producerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(user, password, JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.consumerConfig().put("client.id", consumerClientId);
        this.consumerConfig().put("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().put("group.id", new StringBuilder(6).append(user).append("-group").toString());
        this.consumerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(user, password, JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$3(), JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        return new GroupedUser(this, user, userGroup, topic, (KafkaServer)this.servers().apply(leader), producerClientId, consumerClientId, producer, consumer);
    }

    private final void GroupedUser$lzycompute$1() {
        CustomQuotaCallbackTest customQuotaCallbackTest = this;
        synchronized (customQuotaCallbackTest) {
            if (this.GroupedUser$module == null) {
                this.GroupedUser$module = new CustomQuotaCallbackTest$GroupedUser$(this);
            }
        }
    }

    public static final /* synthetic */ Future $anonfun$produceWithoutThrottle$1(CustomQuotaCallbackTest $this, String topic$1, int i) {
        byte[] payload = ((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes();
        return $this.producerWithoutQuota().send(new ProducerRecord(topic$1, null, null, (Object)payload));
    }

    public static final /* synthetic */ void $anonfun$addUser$1(CustomQuotaCallbackTest $this, String user$1, KafkaServer server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache($this.kafkaClientSaslMechanism(), ScramCredential.class);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> cache.get(user$1) != null, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SCRAM credentials not created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public CustomQuotaCallbackTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 2;
        this.kafkaServerSaslMechanisms = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}));
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties(this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        this.adminClients = new ArrayBuffer();
        this.defaultRequestQuota = 1000;
        this.defaultProduceQuota = 2000000000;
        this.defaultConsumeQuota = 1000000000;
    }

    public class GroupedUser
    extends QuotaTestClients
    implements Product,
    scala.Serializable {
        private final String user;
        private final String userGroup;
        private final String topic;
        private final KafkaServer leaderNode;
        private final String producerClientId;
        private final String consumerClientId;
        public final /* synthetic */ CustomQuotaCallbackTest $outer;

        public String user() {
            return this.user;
        }

        public String userGroup() {
            return this.userGroup;
        }

        public String topic() {
            return this.topic;
        }

        public KafkaServer leaderNode() {
            return this.leaderNode;
        }

        public String producerClientId() {
            return this.producerClientId;
        }

        public String consumerClientId() {
            return this.consumerClientId;
        }

        @Override
        public KafkaProducer<byte[], byte[]> producer() {
            return super.producer();
        }

        @Override
        public KafkaConsumer<byte[], byte[]> consumer() {
            return super.consumer();
        }

        @Override
        public KafkaPrincipal userPrincipal() {
            return new GroupedUserPrincipal(this.user(), this.userGroup());
        }

        @Override
        public scala.collection.immutable.Map<String, String> quotaMetricTags(String clientId) {
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GroupedUserQuotaCallback$.MODULE$.QuotaGroupTag()), (Object)this.userGroup())}));
        }

        @Override
        public void overrideQuotas(long producerQuota, long consumerQuota, double requestQuota) {
            this.configureQuota(this.userGroup(), producerQuota, consumerQuota, requestQuota);
        }

        @Override
        public void removeQuotaOverrides() {
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().adminZkClient().changeUserOrUserClientIdConfig(this.quotaEntityName(this.userGroup()), new Properties());
        }

        public void configureQuota(String userGroup, long producerQuota, long consumerQuota, double requestQuota) {
            Properties quotaProps = this.quotaProperties(producerQuota, consumerQuota, requestQuota);
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().adminZkClient().changeUserOrUserClientIdConfig(this.quotaEntityName(userGroup), quotaProps);
        }

        public void configureAndWaitForQuota(long produceQuota, long fetchQuota, int divisor, Option<String> group) {
            this.configureQuota((String)group.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), produceQuota, fetchQuota, this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().defaultRequestQuota());
            this.waitForQuotaUpdate(produceQuota / (long)divisor, fetchQuota / (long)divisor, this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().defaultRequestQuota(), this.waitForQuotaUpdate$default$4());
        }

        public int configureAndWaitForQuota$default$3() {
            return 1;
        }

        public Option<String> configureAndWaitForQuota$default$4() {
            return new Some((Object)this.userGroup());
        }

        public void produceConsume(boolean expectProduceThrottle, boolean expectConsumeThrottle) {
            int numRecords = 1000;
            int produced = this.produceUntilThrottled(numRecords, false);
            this.verifyProduceThrottle(expectProduceThrottle, false);
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().kafka$api$CustomQuotaCallbackTest$$produceWithoutThrottle(this.topic(), numRecords - produced);
            this.consumeUntilThrottled(numRecords, false);
            this.verifyConsumeThrottle(expectConsumeThrottle, false);
        }

        public void removeThrottleMetrics() {
            this.removeSensors$1((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
        }

        private String quotaEntityName(String userGroup) {
            return new StringBuilder(1).append(userGroup).append("_").toString();
        }

        public GroupedUser copy(String user, String userGroup, String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
            return new GroupedUser(this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer(), user, userGroup, topic, leaderNode, producerClientId, consumerClientId, producer, consumer);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.userGroup();
        }

        public String copy$default$3() {
            return this.topic();
        }

        public KafkaServer copy$default$4() {
            return this.leaderNode();
        }

        public String copy$default$5() {
            return this.producerClientId();
        }

        public String copy$default$6() {
            return this.consumerClientId();
        }

        public KafkaProducer<byte[], byte[]> copy$default$7() {
            return this.producer();
        }

        public KafkaConsumer<byte[], byte[]> copy$default$8() {
            return this.consumer();
        }

        public String productPrefix() {
            return "GroupedUser";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            KafkaProducer<byte[], byte[]> kafkaProducer;
            int n = x$1;
            switch (n) {
                case 0: {
                    kafkaProducer = this.user();
                    break;
                }
                case 1: {
                    kafkaProducer = this.userGroup();
                    break;
                }
                case 2: {
                    kafkaProducer = this.topic();
                    break;
                }
                case 3: {
                    kafkaProducer = this.leaderNode();
                    break;
                }
                case 4: {
                    kafkaProducer = this.producerClientId();
                    break;
                }
                case 5: {
                    kafkaProducer = this.consumerClientId();
                    break;
                }
                case 6: {
                    kafkaProducer = this.producer();
                    break;
                }
                case 7: {
                    kafkaProducer = this.consumer();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return kafkaProducer;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof GroupedUser;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof GroupedUser)) return false;
            if (((GroupedUser)object).kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer() != this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            GroupedUser groupedUser = (GroupedUser)x$1;
            String string = this.user();
            String string2 = groupedUser.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.userGroup();
            String string4 = groupedUser.userGroup();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.topic();
            String string6 = groupedUser.topic();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            KafkaServer kafkaServer = this.leaderNode();
            KafkaServer kafkaServer2 = groupedUser.leaderNode();
            if (kafkaServer == null) {
                if (kafkaServer2 != null) {
                    return false;
                }
            } else if (!kafkaServer.equals(kafkaServer2)) return false;
            String string7 = this.producerClientId();
            String string8 = groupedUser.producerClientId();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.consumerClientId();
            String string10 = groupedUser.consumerClientId();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            KafkaProducer<byte[], byte[]> kafkaProducer = this.producer();
            KafkaProducer<byte[], byte[]> kafkaProducer2 = groupedUser.producer();
            if (kafkaProducer == null) {
                if (kafkaProducer2 != null) {
                    return false;
                }
            } else if (!kafkaProducer.equals(kafkaProducer2)) return false;
            KafkaConsumer<byte[], byte[]> kafkaConsumer = this.consumer();
            KafkaConsumer<byte[], byte[]> kafkaConsumer2 = groupedUser.consumer();
            if (kafkaConsumer == null) {
                if (kafkaConsumer2 != null) {
                    return false;
                }
            } else if (!kafkaConsumer.equals(kafkaConsumer2)) return false;
            if (!groupedUser.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ CustomQuotaCallbackTest kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer() {
            return this.$outer;
        }

        private final void removeSensors$1(QuotaType quotaType, String clientId) {
            String sensorSuffix = this.quotaMetricTags(clientId).values().mkString(":");
            this.leaderNode().metrics().removeSensor(new StringBuilder(13).append(quotaType).append("ThrottleTime-").append(sensorSuffix).toString());
            this.leaderNode().metrics().removeSensor(new StringBuilder(1).append(quotaType).append("-").append(sensorSuffix).toString());
        }

        public GroupedUser(CustomQuotaCallbackTest $outer, String user, String userGroup, String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
            this.user = user;
            this.userGroup = userGroup;
            this.topic = topic;
            this.leaderNode = leaderNode;
            this.producerClientId = producerClientId;
            this.consumerClientId = consumerClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(topic, leaderNode, producerClientId, consumerClientId, producer, consumer);
            Product.$init$((Product)this);
        }
    }
}

