/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.AdminClientIntegrationTest$;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.security.auth.Cluster$;
import kafka.security.auth.Group$;
import kafka.security.auth.Topic$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.ElectPreferredLeadersOptions;
import org.apache.kafka.clients.admin.ElectPreferredLeadersResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t}g\u0001\u0002\"D\u0001!CQa\u0015\u0001\u0005\u0002QCQA\u0016\u0001\u0005\u0002]Cqa\u001a\u0001A\u0002\u0013\u0005\u0001\u000eC\u0004u\u0001\u0001\u0007I\u0011A;\t\ry\u0004\u0001\u0015)\u0003j\u0011!y\bA1A\u0005\u0002\u0005\u0005\u0001\u0002CA\n\u0001\u0001\u0006I!a\u0001\t\u0013\u0005U\u0001A1A\u0005\u0002\u0005]\u0001\u0002CA\u0010\u0001\u0001\u0006I!!\u0007\t\u0013\u0005\u0005\u0002A1A\u0005\u0002\u0005\r\u0002\u0002CA\u0019\u0001\u0001\u0006I!!\n\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!9\u0011q\b\u0001\u0005B\u0005U\u0002\"CA%\u0001\t\u0007I\u0011AA\f\u0011!\tY\u0005\u0001Q\u0001\n\u0005e\u0001\"CA'\u0001\t\u0007I\u0011AA\f\u0011!\ty\u0005\u0001Q\u0001\n\u0005e\u0001\"CA)\u0001\t\u0007I\u0011AA\f\u0011!\t\u0019\u0006\u0001Q\u0001\n\u0005e\u0001bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GCq!!-\u0001\t\u0003\t)\u0004C\u0004\u0002<\u0002!\t!!\u000e\t\u000f\u0005}\u0006\u0001\"\u0001\u00026!9\u00111\u0019\u0001\u0005\u0002\u0005U\u0002bBAd\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u0017\u0004A\u0011AA\u001b\u0011\u001d\ty\r\u0001C\u0001\u0003#Dq!!:\u0001\t\u0003\t)\u0004C\u0004\u0002j\u0002!\t!!\u000e\t\u000f\u00055\b\u0001\"\u0001\u00026!9\u0011\u0011\u001f\u0001\u0005\u0002\u0005U\u0002bBA{\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003s\u0004A\u0011AA\u001b\u0011\u001d\ti\u0010\u0001C\u0001\u0003kAqA!\u0001\u0001\t\u0003\t)\u0004C\u0004\u0003\u0006\u0001!\t!!\u000e\t\u000f\t%\u0001\u0001\"\u0001\u00026!9!Q\u0002\u0001\u0005\u0002\u0005U\u0002b\u0002B\t\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0005+\u0001A\u0011AA\u001b\u0011\u001d\u0011I\u0002\u0001C\u0001\u0003kAqA!\b\u0001\t\u0003\t)\u0004C\u0004\u0003\"\u0001!\t!!\u000e\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(!9!Q\t\u0001\u0005\n\t\u001d\u0003b\u0002B/\u0001\u0011\u0005\u0011Q\u0007\u0005\n\u0005C\u0002!\u0019!C\u0001\u0005GB\u0001Ba\u001b\u0001A\u0003%!Q\r\u0005\b\u0005[\u0002A\u0011AA\u001b\u0011\u001d\u0011\t\b\u0001C\u0001\u0003kAqA!\u001e\u0001\t\u0003\t)\u0004C\u0004\u0003z\u0001!\t!!\u000e\t\u000f\tu\u0004\u0001\"\u0001\u00026!9!\u0011\u0011\u0001\u0005\u0002\u0005U\u0002b\u0002BC\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0005\u0013\u0003A\u0011AA\u001b\u0011\u001d\u0011i\t\u0001C\u0001\u0003kAqA!%\u0001\t\u0003\t)dB\u0004\u0003\u0016\u000eC\tAa&\u0007\r\t\u001b\u0005\u0012\u0001BM\u0011\u0019\u0019f\b\"\u0001\u0003\"\"9!1\u0015 \u0005\u0002\t\u0015\u0006b\u0002B_}\u0011\u0005!q\u0018\u0002\u001b\u0003\u0012l\u0017N\\\"mS\u0016tG/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\t\u0016\u000b1!\u00199j\u0015\u00051\u0015!B6bM.\f7\u0001A\n\u0004\u0001%k\u0005C\u0001&L\u001b\u0005\u0019\u0015B\u0001'D\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\bC\u0001(R\u001b\u0005y%B\u0001)F\u0003\u0015)H/\u001b7t\u0013\t\u0011vJA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005)\u0006C\u0001&\u0001\u000359Gn\u001c2bYRKW.Z8viV\t\u0001\f\u0005\u0002ZA6\t!L\u0003\u0002\\9\u0006)!/\u001e7fg*\u0011QLX\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0006\u0019qN]4\n\u0005\u0005T&a\u0002+j[\u0016|W\u000f\u001e\u0015\u0003\u0005\r\u0004\"\u0001Z3\u000e\u0003qK!A\u001a/\u0003\tI+H.Z\u0001\u0007G2LWM\u001c;\u0016\u0003%\u0004\"A\u001b:\u000e\u0003-T!\u0001\\7\u0002\u000b\u0005$W.\u001b8\u000b\u00059|\u0017aB2mS\u0016tGo\u001d\u0006\u0003\rBT!!\u001d0\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u00198NA\u0006BI6Lgn\u00117jK:$\u0018AC2mS\u0016tGo\u0018\u0013fcR\u0011a\u000f \t\u0003ojl\u0011\u0001\u001f\u0006\u0002s\u0006)1oY1mC&\u00111\u0010\u001f\u0002\u0005+:LG\u000fC\u0004~\t\u0005\u0005\t\u0019A5\u0002\u0007a$\u0013'A\u0004dY&,g\u000e\u001e\u0011\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u000e\u0005!!.\u0019<b\u0013\u0011\t\t\"a\u0002\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0003\u00033\u00012a^A\u000e\u0013\r\ti\u0002\u001f\u0002\u0004\u0013:$\u0018A\u00039beRLG/[8oA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016_\u000611m\\7n_:LA!a\f\u0002*\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u000bM,G/\u00169\u0015\u0003YD3\u0001DA\u001d!\r!\u00171H\u0005\u0004\u0003{a&A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\ri\u00111\t\t\u0004I\u0006\u0015\u0013bAA$9\n)\u0011I\u001a;fe\u0006Y!M]8lKJ\u001cu.\u001e8u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u00035\u0019wN\\:v[\u0016\u00148i\\;oi\u0006q1m\u001c8tk6,'oQ8v]R\u0004\u0013!\u00049s_\u0012,8-\u001a:D_VtG/\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\"!!\u0017\u0011\r\u0005m\u00131NA9\u001d\u0011\ti&a\u001a\u000f\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019H\u0003\u0019a$o\\8u}%\t\u00110C\u0002\u0002ja\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002n\u0005=$aA*fc*\u0019\u0011\u0011\u000e=\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001eF\u0003\u0019\u0019XM\u001d<fe&!\u00111PA;\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0015\u0005\u0005\u0005\u0005\u0003CAB\u0003\u0013\u000bi)a'\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0017\tA!\u001e;jY&!\u00111RAC\u0005\ri\u0015\r\u001d\t\u0005\u0003\u001f\u000b9J\u0004\u0003\u0002\u0012\u0006M\u0005cAA0q&\u0019\u0011Q\u0013=\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t\"!'\u000b\u0007\u0005U\u0005\u0010\u0005\u0003\u0002\u0006\u0005u\u0015\u0002BAP\u0003\u000f\u0011aa\u00142kK\u000e$\u0018!D<bSR4uN\u001d+pa&\u001c7\u000fF\u0004w\u0003K\u000b9+!,\t\u000b\u001d4\u0002\u0019A5\t\u000f\u0005%f\u00031\u0001\u0002,\u0006yQ\r\u001f9fGR,G\r\u0015:fg\u0016tG\u000f\u0005\u0004\u0002\\\u0005-\u0014Q\u0012\u0005\b\u0003_3\u0002\u0019AAV\u0003=)\u0007\u0010]3di\u0016$W*[:tS:<\u0017!\u0003;fgR\u001cEn\\:fQ\r9\u0012Q\u0017\t\u0004I\u0006]\u0016bAA]9\n!A+Z:u\u00035!Xm\u001d;MSN$hj\u001c3fg\"\u001a\u0001$!.\u0002-Q,7\u000f^\"sK\u0006$X\rR3mKR,Gk\u001c9jGND3!GA[\u0003E\"Xm\u001d;De\u0016\fG/Z#ySN$\u0018N\\4U_BL7m\u001d+ie><Hk\u001c9jG\u0016C\u0018n\u001d;t\u000bb\u001cW\r\u001d;j_:D3AGA[\u0003M!Xm\u001d;NKR\fG-\u0019;b%\u00164'/Z:iQ\rY\u0012QW\u0001\u0019i\u0016\u001cH/Q;uQ>\u0014\u0018N_3e\u001fB,'/\u0019;j_:\u001c\bf\u0001\u000f\u00026\u0006a2m\u001c8gS\u001e,(/\u001a3DYV\u001cH/\u001a:QKJl\u0017n]:j_:\u001cHCAAj!\u0019\ty)!6\u0002Z&!\u0011q[AM\u0005\r\u0019V\r\u001e\t\u0005\u00037\f\t/\u0004\u0002\u0002^*!\u0011q\\A\u0015\u0003\r\t7\r\\\u0005\u0005\u0003G\fiN\u0001\u0007BG2|\u0005/\u001a:bi&|g.\u0001\u000fuKN$H)Z:de&\u0014WMT8o\u000bbL7\u000f^5oOR{\u0007/[2)\u0007y\t),A\nuKN$H)Z:de&\u0014Wm\u00117vgR,'\u000fK\u0002 \u0003k\u000b1\u0003^3ti\u0012+7o\u0019:jE\u0016dun\u001a#jeND3\u0001IA[\u0003i!Xm\u001d;EKN\u001c'/\u001b2f%\u0016\u0004H.[2b\u0019><G)\u001b:tQ\r\t\u0013QW\u0001\u0018i\u0016\u001cH/\u00117uKJ\u0014V\r\u001d7jG\u0006dun\u001a#jeND3AIA[\u0003m!Xm\u001d;EKN\u001c'/\u001b2f\u0003:$\u0017\t\u001c;fe\u000e{gNZ5hg\"\u001a1%!.\u0002)Q,7\u000f^\"sK\u0006$X\rU1si&$\u0018n\u001c8tQ\r!\u0013QW\u0001\u001bi\u0016\u001cHoU3fW\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u0015\u0004K\u0005U\u0016\u0001\b;fgRdunZ*uCJ$xJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e\u0015\u0004M\u0005U\u0016\u0001\n;fgRdunZ*uCJ$xJ\u001a4tKR\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:)\u0007\u001d\n),A\u001cuKN$(+\u001a9mS\u000e\f7)\u00198GKR\u001c\u0007N\u0012:p[2{wm\u0015;beR|eMZ:fi\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u0015\u0004Q\u0005U\u0016A\t;fgR\fE\u000e^3s\u0019><G)\u001b:t\u0003\u001a$XM\u001d#fY\u0016$XMU3d_J$7\u000fK\u0002*\u0003k\u000bQ\u0005^3ti>3gm]3ug\u001a{'\u000fV5nKN\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:)\u0007)\n),A\u000fuKN$8i\u001c8tk6,\u0017I\u001a;fe\u0012+G.\u001a;f%\u0016\u001cwN\u001d3tQ\rY\u0013QW\u0001\u001fi\u0016\u001cH\u000fR3mKR,'+Z2pe\u0012\u001cx+\u001b;i\u000bb\u001cW\r\u001d;j_:D3\u0001LA[\u0003m!Xm\u001d;EKN\u001c'/\u001b2f\u0007>tg-[4t\r>\u0014Hk\u001c9jG\"\u001aQ&!.\u0002;M,(m]2sS\n,\u0017I\u001c3XC&$hi\u001c:BgNLwM\\7f]R$RA\u001eB\u0015\u0005WAaa \u0018A\u0002\u00055\u0005b\u0002B\u0017]\u0001\u0007!qF\u0001\tG>t7/^7feBA!\u0011\u0007B\u001b\u0005s\u0011I$\u0004\u0002\u00034)\u0019!QF7\n\t\t]\"1\u0007\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0011\u000b]\u0014YDa\u0010\n\u0007\tu\u0002PA\u0003BeJ\f\u0017\u0010E\u0002x\u0005\u0003J1Aa\u0011y\u0005\u0011\u0011\u0015\u0010^3\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\bm\n%#q\u000bB.\u0011\u001d\u0011Ye\fa\u0001\u0005\u001b\n\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0005\u001f\u0012\u0019F!\u000f\u0003:5\u0011!\u0011\u000b\u0006\u0004\u0005\u0017j\u0017\u0002\u0002B+\u0005#\u0012QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bb\u0002B-_\u0001\u0007\u0011\u0011D\u0001\u000b]Vl'+Z2pe\u0012\u001c\bbBA\u0011_\u0001\u0007\u0011QE\u0001\u0018i\u0016\u001cH/\u00138wC2LG-\u00117uKJ\u001cuN\u001c4jOND3\u0001MA[\u0003\u0011\t5\tT\u0019\u0016\u0005\t\u0015\u0004\u0003BAn\u0005OJAA!\u001b\u0002^\nQ\u0011i\u00197CS:$\u0017N\\4\u0002\u000b\u0005\u001bE*\r\u0011\u0002#Q,7\u000f^!dY>\u0003XM]1uS>t7\u000fK\u00024\u0003k\u000b\u0001\u0003^3ti\u0012+G.Y=fI\u000ecwn]3)\u0007Q\n),\u0001\buKN$hi\u001c:dK\u000ecwn]3)\u0007U\n),\u0001\u000euKN$X*\u001b8j[Vl'+Z9vKN$H+[7f_V$8\u000fK\u00027\u0003k\u000b\u0001\u0004^3ti\u000e\u000bG\u000e\\%o\r2Lw\r\u001b;US6,w.\u001e;tQ\r9\u0014QW\u0001\u0013i\u0016\u001cHoQ8ogVlWM]$s_V\u00048\u000fK\u00029\u0003k\u000b\u0011\u0004^3ti\u0016cWm\u0019;Qe\u00164WM\u001d:fI2+\u0017\rZ3sg\"\u001a\u0011(!.\u0002AQ,7\u000f\u001e,bY&$\u0017J\\2sK6,g\u000e^1m\u00032$XM]\"p]\u001aLwm\u001d\u0015\u0004u\u0005U\u0016A\t;fgRLeN^1mS\u0012Len\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7\u000fK\u0002<\u0003k\u000b!\u0003^3ti2{gn\u001a+pa&\u001cg*Y7fg\"\u001aA(!.\u00025\u0005#W.\u001b8DY&,g\u000e^%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u0005)s4c\u0001 \u0003\u001cB\u0019qO!(\n\u0007\t}\u0005P\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005/\u000bac\u00195fG.4\u0016\r\\5e\u00032$XM]\"p]\u001aLwm\u001d\u000b\bm\n\u001d&\u0011\u0016B]\u0011\u00159\u0007\t1\u0001j\u0011\u001d\u0011Y\u000b\u0011a\u0001\u0005[\u000ba\u0002^8qS\u000e\u0014Vm]8ve\u000e,\u0017\u0007\u0005\u0003\u00030\nUVB\u0001BY\u0015\u0011\u0011\u0019,!\u000b\u0002\r\r|gNZ5h\u0013\u0011\u00119L!-\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\"9!1\u0018!A\u0002\t5\u0016A\u0004;pa&\u001c'+Z:pkJ\u001cWMM\u0001\u0019G\",7m[%om\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001cHc\u0002<\u0003B\nE'Q\u001c\u0005\b\u0005\u0007\f\u0005\u0019\u0001Bc\u0003!Q8n\u00117jK:$\b\u0003\u0002Bd\u0005\u001bl!A!3\u000b\u0007\t-W)\u0001\u0002{W&!!q\u001aBe\u00055Y\u0015MZ6b5.\u001cE.[3oi\"9!1[!A\u0002\tU\u0017aB:feZ,'o\u001d\t\u0007\u00037\nYGa6\u0011\t\u0005M$\u0011\\\u0005\u0005\u00057\f)HA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\b\"B4B\u0001\u0004I\u0007")
public class AdminClientIntegrationTest
extends IntegrationTestHarness {
    private AdminClient client = null;
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private final int brokerCount;
    private final int consumerCount;
    private final int producerCount;
    private final AclBinding ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));

    public static void checkInvalidAlterConfigs(KafkaZkClient kafkaZkClient, Seq<KafkaServer> seq, AdminClient adminClient) {
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(kafkaZkClient, seq, adminClient);
    }

    public static void checkValidAlterConfigs(AdminClient adminClient, ConfigResource configResource, ConfigResource configResource2) {
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(adminClient, configResource, configResource2);
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$12 = this.brokerCount();
        String x$2 = this.zkConnect();
        Some x$3 = new Some((Object)this.securityProtocol());
        Option<File> x$4 = this.trustStoreFile();
        Option<Properties> x$5 = this.serverSaslProperties();
        int x$6 = 2;
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$122 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$12, x$2, x$7, x$8, (Option<SecurityProtocol>)x$3, x$4, x$5, x$9, x$10, x$11, x$122, x$13, x$6, x$14);
        cfgs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(13).append(this.listenerName().value()).append("://localhost:").append(TestUtils$.MODULE$.RandomPort()).toString());
            config.remove(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp());
            config.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.listenerName().value());
            config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(1).append(this.listenerName().value()).append(":").append($this.securityProtocol().name).toString());
            config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
            config.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
            return !config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp()) ? config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass") : BoxedUnit.UNIT;
        });
        cfgs.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            AdminClientIntegrationTest.$anonfun$generateConfigs$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)cfgs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        config.put("request.timeout.ms", "20000");
        Properties securityProps = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)securityProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Object value = tuple2._2();
            Object object = config.put((String)key, (String)value);
            return object;
        });
        return var1_1;
    }

    public void waitForTopics(AdminClient client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            java.util.Set topics = (java.util.Set)client.listTopics().names().get();
            return expectedPresent.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)topics.contains(topicName))) && expectedMissing.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$waitForTopics$3(topics, topicName)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for topics", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testClose() {
        AdminClient client = AdminClient.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        Iterable nodes;
        this.client_$eq(AdminClient.create(this.createConfig()));
        List brokerStrs = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.brokerList().split(","))).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List nodeStrs = null;
        while ((nodeStrs = (List)((TraversableOnce)(nodes = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assert.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testCreateDeleteTopics() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0)}))).asJava())}))).asJava()), new NewTopic("mytopic2", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        java.util.Map results = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey("mytopic"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assert.assertTrue((boolean)results.containsKey("mytopic2"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assert.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assert.assertEquals((long)2L, (long)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assert.assertEquals((long)1L, (long)topic0Partition0.leader().id());
        Assert.assertEquals((long)0L, (long)topic0Partition0.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assert.assertEquals((long)2L, (long)topic0Partition1.leader().id());
        Assert.assertEquals((long)1L, (long)topic0Partition1.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assert.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assert.assertEquals((long)3L, (long)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            TopicPartitionInfo partition = (TopicPartitionInfo)topic1.partitions().get(partitionId);
            Assert.assertEquals((long)partitionId, (long)partition.partition());
            Assert.assertEquals((long)3L, (long)partition.replicas().size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).foreach((Function1 & Serializable & scala.Serializable)replica -> {
                AdminClientIntegrationTest.$anonfun$testCreateDeleteTopics$6(this, replica);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)"No duplicate replica ids", (long)partition.replicas().size(), (long)((SeqLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Buffer$.MODULE$.canBuildFrom())).distinct()).size());
            Assert.assertEquals((long)3L, (long)partition.isr().size());
            Assert.assertEquals((Object)partition.replicas(), (Object)partition.isr());
            Assert.assertTrue((boolean)partition.replicas().contains(partition.leader()));
        });
        this.client().deleteTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testCreateExistingTopicsThrowTopicExistsException() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "mytopic";
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic, 1, (short)1)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        Seq newTopicsWithInvalidRF = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic, 1, (short)(this.servers().size() + 1))}));
        ExecutionException e = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopicsWithInvalidRF).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        Assert.assertTrue((boolean)(e.getCause() instanceof TopicExistsException));
    }

    @Test
    public void testMetadataRefresh() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testMetadataRefresh$1(this, x$7))).get();
        controller.shutdown();
        controller.awaitShutdown();
        java.util.Map topicDesc = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicDesc.keySet()).asScala());
    }

    @Test
    public void testAuthorizedOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).asJava(), (Object)result.authorizedOperations().get());
        result = this.client().describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true));
        java.util.Set expectedOperations = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.configuredClusterPermissions()).asJava();
        Assert.assertEquals((Object)expectedOperations, (Object)result.authorizedOperations().get());
        String topic = "mytopic";
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic, 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), (Seq<String>)Nil$.MODULE$);
        java.util.Map topicResult = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).values();
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).asJava(), (Object)((TopicDescription)((KafkaFuture)topicResult.get(topic)).get()).authorizedOperations());
        topicResult = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava(), new DescribeTopicsOptions().includeAuthorizedOperations(true)).values();
        expectedOperations = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Topic$.MODULE$.supportedOperations().map((Function1 & Serializable & scala.Serializable)operation -> operation.toJava(), Set$.MODULE$.canBuildFrom())).asJava();
        Assert.assertEquals((Object)expectedOperations, (Object)((TopicDescription)((KafkaFuture)topicResult.get(topic)).get()).authorizedOperations());
    }

    public scala.collection.immutable.Set<AclOperation> configuredClusterPermissions() {
        return (scala.collection.immutable.Set)Cluster$.MODULE$.supportedOperations().map((Function1 & Serializable & scala.Serializable)operation -> operation.toJava(), Set$.MODULE$.canBuildFrom());
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))).map((Function1 & Serializable & scala.Serializable)x$8 -> new NewTopic(x$8, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nonExistingTopic, existingTopic}))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (TopicDescription)((KafkaFuture)results.get(nonExistingTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Collection nodes = (Collection)result.nodes().get();
        String clusterId = (String)result.clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().clusterId(), (Object)clusterId);
        Node controller = (Node)result.controller().get();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().metadataCache().getControllerId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers)).size(), (long)nodes.size());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
            AdminClientIntegrationTest.$anonfun$testDescribeCluster$2(brokers, node);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        scala.collection.immutable.Map partitionsByBroker = leaderByPartition.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$1(x0$1))).mapValues((Function1 & Serializable & scala.Serializable)x$9 -> x$9.keys().toSeq());
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), IndexedSeq$.MODULE$.canBuildFrom());
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$5(brokerId, x$10))).get();
            Seq expectedPartitions = (Seq)partitionsByBroker.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
            java.util.Map logDirInfos = (java.util.Map)logDirInfosByBroker.get(BoxesRunTime.boxToInteger((int)brokerId));
            Map replicaInfos = ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                scala.collection.mutable.Map map = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala();
                return map;
            }, Map$.MODULE$.canBuildFrom())).filterKeys((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$7(topic, x$11)));
            Assert.assertEquals((Object)expectedPartitions.toSet(), (Object)((TraversableOnce)replicaInfos.keys().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.partition()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$9(server, x0$3);
                return BoxedUnit.UNIT;
            });
        });
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        Seq replicas = ((TraversableOnce)leaderByPartition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int partition = tuple2._1$mcI$sp();
            int brokerId = tuple2._2$mcI$sp();
            TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(topic, partition, brokerId);
            return topicPartitionReplica;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        java.util.Map replicaDirInfos = (java.util.Map)this.client().describeReplicaLogDirs(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)replicas).asJavaCollection()).all().get();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(replicaDirInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            AdminClientIntegrationTest.$anonfun$testDescribeReplicaLogDirs$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map randomNums = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(server), (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(2))), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map firstReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            String logDir = new File((String)server.config().logDirs().apply(BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId())), (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map secondReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            String logDir = new File((String)server.config().logDirs().apply(1 - BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId())), (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable futures = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values();
        futures.foreach((Function1 & Serializable & scala.Serializable)future -> {
            AdminClientIntegrationTest.$anonfun$testAlterReplicaLogDirs$4(future);
            return BoxedUnit.UNIT;
        });
        this.createTopic(topic, 1, this.brokerCount(), this.createTopic$default$4());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            AdminClientIntegrationTest.$anonfun$testAlterReplicaLogDirs$6(tp, firstReplicaAssignment, topic, server);
            return BoxedUnit.UNIT;
        });
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)secondReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                LogManager qual$2 = server.logManager();
                TopicPartition x$3 = tp$1;
                boolean x$4 = qual$2.getLog$default$2();
                String logDir = ((Log)qual$2.getLog(x$3, x$4).get()).dir().getParent();
                Object object = secondReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId()));
                String string = logDir;
                return !(object != null ? !object.equals(string) : string != null);
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for replica movement", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            return BoxedUnit.UNIT;
        });
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger numMessages = new AtomicInteger();
        scala.concurrent.Future producerFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            int n;
            String x$5 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), this.securityProtocol());
            SecurityProtocol x$6 = this.securityProtocol();
            Option<File> x$7 = this.trustStoreFile();
            int x$8 = 0;
            int x$9 = 10000;
            int x$10 = -1;
            long x$11 = TestUtils$.MODULE$.createProducer$default$3();
            long x$12 = TestUtils$.MODULE$.createProducer$default$4();
            int x$13 = TestUtils$.MODULE$.createProducer$default$6();
            int x$14 = TestUtils$.MODULE$.createProducer$default$7();
            int x$15 = TestUtils$.MODULE$.createProducer$default$8();
            String x$16 = TestUtils$.MODULE$.createProducer$default$9();
            Option<Properties> x$17 = TestUtils$.MODULE$.createProducer$default$13();
            ByteArraySerializer x$18 = TestUtils$.MODULE$.createProducer$default$14();
            ByteArraySerializer x$19 = TestUtils$.MODULE$.createProducer$default$15();
            try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$5, x$10, x$11, x$12, x$8, x$13, x$14, x$15, x$16, x$9, x$6, x$7, x$17, x$18, x$19);){
                while (running.get()) {
                    Future future = producer.send(new ProducerRecord(topic, (Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(numMessages).toString().getBytes()));
                    numMessages.incrementAndGet();
                    future.get(10L, TimeUnit.SECONDS);
                }
                n = numMessages.get();
            }
            return n;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> numMessages.get() > 10, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("only ").append(numMessages).append(" messages are produced before timeout. Producer future ").append(producerFuture.value()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    LogManager qual$3 = server.logManager();
                    TopicPartition x$20 = tp$1;
                    boolean x$21 = qual$3.getLog$default$2();
                    String logDir = ((Log)qual$3.getLog(x$20, x$21).get()).dir().getParent();
                    Object object = firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId()));
                    String string = logDir;
                    return !(object != null ? !object.equals(string) : string != null);
                }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("timed out waiting for replica movement. Producer future ").append(producerFuture$1.value()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
                return BoxedUnit.UNIT;
            });
            int currentMessagesNum = numMessages.get();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> numMessages.get() - currentMessagesNum > 10, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("only ").append(numMessages.get() - currentMessagesNum).append(" messages are produced within timeout after replica movement. Producer future ").append(producerFuture.value()).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        }
        finally {
            running.set(false);
        }
        int finalNumMessages = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)producerFuture, (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS)));
        Buffer<KafkaServer> x$22 = this.servers();
        String x$23 = topic;
        int x$24 = finalNumMessages;
        SecurityProtocol x$25 = this.securityProtocol();
        Option<File> x$26 = this.trustStoreFile();
        String x$27 = TestUtils$.MODULE$.consumeTopicRecords$default$4();
        long x$28 = TestUtils$.MODULE$.consumeTopicRecords$default$7();
        Seq<ConsumerRecord<byte[], byte[]>> consumerRecords = TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)x$22, x$23, x$24, x$27, x$25, x$26, x$28);
        ((IterableLike)consumerRecords.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AdminClientIntegrationTest.$anonfun$testAlterReplicaLogDirs$18(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString());
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString());
        Seq configResources = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource1, brokerResource2}));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(configResources).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MessageMaxBytes())).toString(), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(1)).config().values().size(), (long)((Config)configs.get(brokerResource1)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertFalse((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType().toString(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertFalse((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(2)).config().values().size(), (long)((Config)configs.get(brokerResource2)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testCreatePartitions() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "create-partitions-topic-2";
        this.createTopic(topic2, 1, 2, this.createTopic$default$4());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJava()).values().get(topic1)).get()).partitions().size());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava()).values().get(topic2)).get()).partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), validateOnly));
        ObjectRef altered = ObjectRef.create((Object)((Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get()));
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic1));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)3L, (long)this.numPartitions$1(topic1));
        java.util.List<Object> newPartition2Assignments = Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})});
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), validateOnly);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic2));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2);
        Assert.assertEquals((long)3L, (long)actualPartitions2.size());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsOptions[]{validateOnly, actuallyDoIt}))).foreach((Function1 & Serializable & scala.Serializable)option -> {
            AdminClientIntegrationTest.$anonfun$testCreatePartitions$3(this, alterResult, topic1, topic2, newPartition2Assignments, altered, option);
            return BoxedUnit.UNIT;
        });
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)4L, (long)this.numPartitions$1(topic1));
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        DeleteTopicsResult deleteResult = this.client().deleteTopics(Arrays.asList((Object[])new String[]{topic1}));
        ((KafkaFuture)deleteResult.values().get(topic1)).get();
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4))}))).asJava(), validateOnly);
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
            Assert.fail((String)"Expect InvalidTopicException when the topic is queued for deletion");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidTopicException));
            Assert.assertEquals((Object)"The topic is queued for deletion.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testSeekAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        consumer.seekToBeginning(Collections.singleton(this.topicPartition()));
        Assert.assertEquals((long)0L, (long)consumer.position(this.topicPartition()));
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)5L, (long)lowWatermark);
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)5L, (long)consumer.position(this.topicPartition()));
        consumer.seek(this.topicPartition(), 7L);
        Assert.assertEquals((long)7L, (long)consumer.position(this.topicPartition()));
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava()).all().get();
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)10L, (long)consumer.position(this.topicPartition()));
    }

    @Test
    public void testLogStartOffsetCheckpoint() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        ObjectRef result = ObjectRef.create((Object)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()));
        ObjectRef lowWatermark = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)((KafkaFuture)((DeleteRecordsResult)result.elem).lowWatermarks().get(this.topicPartition())).get()).lowWatermark())));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)((Option)lowWatermark.elem));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        this.restartDeadBrokers();
        this.client().close();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.client_$eq(AdminClient.create(this.createConfig()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            result$1.elem = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)0L))}))).asJava());
            lowWatermark$1.elem = None$.MODULE$;
            KafkaFuture future = (KafkaFuture)((DeleteRecordsResult)result$1.elem).lowWatermarks().get(this.topicPartition());
            try {
                lowWatermark$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)future.get()).lowWatermark()));
                bl = ((Option)lowWatermark$1.elem).contains((Object)BoxesRunTime.boxToLong((long)5L));
            }
            catch (Throwable throwable) {
                ExecutionException executionException;
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable2).getCause() instanceof LeaderNotAvailableException) && !(executionException.getCause() instanceof NotLeaderForPartitionException)) {
                    throw throwable;
                }
                boolean bl2 = false;
                bl = bl2;
            }
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Expected low watermark of the partition to be 5 but got ").append(((Option)lowWatermark$1.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> "no response within the timeout")).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)3L, (long)lowWatermark);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(i)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset()));
    }

    @Test
    public void testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords() {
        scala.collection.immutable.Map<Object, Object> leaders = this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4());
        int followerIndex = BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().apply(0)).config().brokerId() ? 0 : 1;
        this.killBroker(followerIndex);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        result.all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(3L, 100L, followerIndex);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(i)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset()));
        this.killBroker(followerIndex);
        this.sendRecords(producer, 100, this.topicPartition());
        DeleteRecordsResult result1 = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)117L))}))).asJava());
        result1.all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(117L, 200L, followerIndex);
    }

    @Test
    public void testAlterLogDirsAfterDeleteRecords() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4());
        int expectedLEO = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, expectedLEO, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        result.all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(i)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset());
            Assert.assertEquals((long)expectedLEO, (long)((Replica)((KafkaServer)this.servers().apply(i)).replicaManager().localReplica(this.topicPartition()).get()).logEndOffset());
        });
        String futureLogDir = (String)((KafkaServer)this.servers().apply(0)).config().logDirs().apply(1);
        TopicPartitionReplica futureReplica = new TopicPartitionReplica(this.topic(), 0, ((KafkaServer)this.servers().apply(0)).config().brokerId());
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)futureReplica), (Object)futureLogDir)}))).asJava()).all().get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = futureLogDir;
            LogManager qual$1 = ((KafkaServer)this.servers().apply(0)).logManager();
            TopicPartition x$1 = this.topicPartition();
            boolean x$2 = qual$1.getLog$default$2();
            String string2 = ((Log)qual$1.getLog(x$1, x$2).get()).dir().getParent();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for replica movement", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(0)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset());
        Assert.assertEquals((long)expectedLEO, (long)((Replica)((KafkaServer)this.servers().apply(0)).replicaManager().localReplica(this.topicPartition()).get()).logEndOffset());
    }

    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        result.all().get();
        Assert.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava());
        result.all().get();
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition()));
    }

    @Test
    public void testConsumeAfterDeleteRecords() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        boolean messageCount = false;
        TestUtils$.MODULE$.consumeRecords(consumer, 10, TestUtils$.MODULE$.consumeRecords$default$3());
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        messageCount = false;
        TestUtils$.MODULE$.consumeRecords(consumer, 7, TestUtils$.MODULE$.consumeRecords$default$3());
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)8L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        messageCount = false;
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
    }

    @Test
    public void testDeleteRecordsWithException() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assert.assertEquals((long)5L, (long)((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Throwable cause = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1005))).getCause();
        Assert.assertEquals(OffsetOutOfRangeException.class, cause.getClass());
        TopicPartition nonExistPartition = new TopicPartition(this.topic(), 3);
        cause = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistPartition), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(nonExistPartition)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1012))).getCause();
        Assert.assertEquals(LeaderNotAvailableException.class, cause.getClass());
    }

    @Test
    public void testDescribeConfigsForTopic() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        ((KafkaFuture)this.client().describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
        ConfigResource nonExistentTopic = new ConfigResource(ConfigResource.Type.TOPIC, "unknown");
        DescribeConfigsResult describeResult1 = this.client().describeConfigs(Collections.singletonList(nonExistentTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Config)((KafkaFuture)describeResult1.values().get(nonExistentTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1029))).getCause() instanceof UnknownTopicOrPartitionException));
        ConfigResource invalidTopic = new ConfigResource(ConfigResource.Type.TOPIC, "(invalid topic)");
        DescribeConfigsResult describeResult2 = this.client().describeConfigs(Collections.singletonList(invalidTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Config)((KafkaFuture)describeResult2.values().get(invalidTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1034))).getCause() instanceof InvalidTopicException));
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.pollUntilTrue((Consumer<?, ?>)consumer, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !consumer.assignment().isEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected non-empty assignment", TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition topicPartition) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> AdminClientIntegrationTest.$anonfun$sendRecords$1(this, topicPartition, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1 & Serializable & scala.Serializable)x$16 -> (RecordMetadata)x$16.get());
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    public AclBinding ACL1() {
        return this.ACL1;
    }

    @Test
    public void testAclOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(this.ACL1())).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(this.ACL1().toFilter())).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)topics.map((Function1 & Serializable & scala.Serializable)x$17 -> new NewTopic(x$17, 1, 1), Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(java.time.Duration.ofHours(2L));
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future2, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        future.get();
        this.client().close(java.time.Duration.ofMinutes(30L));
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        this.client_$eq(AdminClient.create(config));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$18 -> new NewTopic(x$18, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(java.time.Duration.ZERO);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        config.put("request.timeout.ms", "0");
        this.client_$eq(AdminClient.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$19 -> new NewTopic(x$19, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("request.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        this.client_$eq((AdminClient)KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable & scala.Serializable)x$20 -> new NewTopic(x$20, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic3", "mytopic4"}))).map((Function1 & Serializable & scala.Serializable)x$21 -> new NewTopic(x$21, 1, 1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        future2.get();
        Assert.assertEquals((long)1L, (long)factory.failuresInjected());
    }

    @Test
    public void testConsumerGroups() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(AdminClient.create(config));
        try {
            ListConsumerGroupsResult list1 = this.client().listConsumerGroups();
            Assert.assertTrue((0 == ((Collection)list1.all().get()).size() ? 1 : 0) != 0);
            Assert.assertTrue((0 == ((Collection)list1.errors().get()).size() ? 1 : 0) != 0);
            Assert.assertTrue((0 == ((Collection)list1.valid().get()).size() ? 1 : 0) != 0);
            String testTopicName = "test_topic";
            int testNumPartitions = 2;
            this.client().createTopics(Collections.singleton(new NewTopic(testTopicName, testNumPartitions, 1))).all().get();
            this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)testTopicName, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                producer.send(new ProducerRecord(testTopicName, Predef$.MODULE$.int2Integer(0), null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String fakeGroupId = "fake_group_id";
            Properties newConsumerConfig = new Properties(this.consumerConfig());
            newConsumerConfig.setProperty("group.id", testGroupId);
            newConsumerConfig.setProperty("client.id", testClientId);
            Properties x$1 = newConsumerConfig;
            ByteArrayDeserializer x$2 = this.createConsumer$default$1();
            ByteArrayDeserializer x$3 = this.createConsumer$default$2();
            List<String> x$4 = this.createConsumer$default$4();
            KafkaConsumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
            CountDownLatch latch = new CountDownLatch(1);
            try {
                Thread consumerThread = new Thread(null, consumer, testTopicName, latch){
                    private final KafkaConsumer consumer$2;
                    private final String testTopicName$1;
                    private final CountDownLatch latch$1;

                    public void run() {
                        this.consumer$2.subscribe(Collections.singleton(this.testTopicName$1));
                        try {
                            while (true) {
                                this.consumer$2.poll(java.time.Duration.ofSeconds(5L));
                                if (!this.consumer$2.assignment().isEmpty() && this.latch$1.getCount() > 0L) {
                                    this.latch$1.countDown();
                                }
                                this.consumer$2.commitSync();
                            }
                        }
                        catch (InterruptException interruptException) {
                            return;
                        }
                    }
                    {
                        this.consumer$2 = consumer$2;
                        this.testTopicName$1 = testTopicName$1;
                        this.latch$1 = latch$1;
                    }
                };
                try {
                    consumerThread.start();
                    Assert.assertTrue((boolean)latch.await(30000L, TimeUnit.MILLISECONDS));
                    TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        Iterable matching = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().listConsumerGroups().all().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testConsumerGroups$2(testGroupId, x$22)));
                        return !matching.isEmpty();
                    }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Expected to be able to list ").append(testGroupId).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
                    DescribeConsumerGroupsResult result = this.client().describeConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId, fakeGroupId}))).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
                    Assert.assertEquals((long)2L, (long)result.describedGroups().size());
                    Assert.assertTrue((boolean)result.describedGroups().containsKey(testGroupId));
                    ConsumerGroupDescription testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get(testGroupId)).get();
                    Assert.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assert.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assert.assertEquals((long)1L, (long)testGroupDescription.members().size());
                    MemberDescription member = (MemberDescription)testGroupDescription.members().iterator().next();
                    Assert.assertEquals((Object)testClientId, (Object)member.clientId());
                    java.util.Set topicPartitions = member.assignment().topicPartitions();
                    Assert.assertEquals((long)testNumPartitions, (long)topicPartitions.size());
                    Assert.assertEquals((long)testNumPartitions, (long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(topicPartitions).asScala()).count((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testConsumerGroups$4(testTopicName, tp))));
                    java.util.Set expectedOperations = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Group$.MODULE$.supportedOperations().map((Function1 & Serializable & scala.Serializable)operation -> operation.toJava(), Set$.MODULE$.canBuildFrom())).asJava();
                    Assert.assertEquals((Object)expectedOperations, (Object)testGroupDescription.authorizedOperations());
                    Assert.assertTrue((boolean)result.describedGroups().containsKey(fakeGroupId));
                    ConsumerGroupDescription fakeGroupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get(fakeGroupId)).get();
                    Assert.assertEquals((Object)fakeGroupId, (Object)fakeGroupDescription.groupId());
                    Assert.assertEquals((long)0L, (long)fakeGroupDescription.members().size());
                    Assert.assertEquals((Object)"", (Object)fakeGroupDescription.partitionAssignor());
                    Assert.assertEquals((Object)ConsumerGroupState.DEAD, (Object)fakeGroupDescription.state());
                    Assert.assertEquals((Object)expectedOperations, (Object)fakeGroupDescription.authorizedOperations());
                    Assert.assertEquals((long)2L, (long)((java.util.Map)result.all().get()).size());
                    TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        TopicPartition part;
                        java.util.Map parts = (java.util.Map)this.client().listConsumerGroupOffsets(testGroupId).partitionsToOffsetAndMetadata().get();
                        return parts.containsKey(part = new TopicPartition(testTopicName, 0)) && ((OffsetAndMetadata)parts.get(part)).offset() == 1L;
                    }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the offset for partition 0 to eventually become 1.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
                    DeleteConsumerGroupsResult deleteResult = this.client().deleteConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId, fakeGroupId}))).asJava());
                    Assert.assertEquals((long)2L, (long)deleteResult.deletedGroups().size());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(fakeGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(fakeGroupId), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(testGroupId), GroupNotEmptyException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                }
                finally {
                    consumerThread.interrupt();
                    consumerThread.join();
                }
            }
            finally {
                Utils.closeQuietly(consumer, (String)"consumer");
            }
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    @Test
    public void testElectPreferredLeaders() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq prefer0 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq prefer1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        Seq prefer2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1}));
        TopicPartition partition1 = new TopicPartition("elect-preferred-leaders-topic-1", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)prefer0)}))), (Seq<KafkaServer>)this.servers());
        TopicPartition partition2 = new TopicPartition("elect-preferred-leaders-topic-2", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition2.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)prefer0)}))), (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((long)0L, (long)this.currentLeader$1(partition1));
        Assert.assertEquals((long)0L, (long)this.currentLeader$1(partition2));
        ObjectRef electResult = ObjectRef.create((Object)this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{partition1})));
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition1).get();
        Assert.assertEquals((long)0L, (long)this.currentLeader$1(partition1));
        electResult.elem = this.client().electPreferredLeaders(null);
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition1).get();
        Assert.assertEquals((long)0L, (long)this.currentLeader$1(partition1));
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition2).get();
        Assert.assertEquals((long)0L, (long)this.currentLeader$1(partition2));
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        electResult.elem = this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{partition1}));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), (Object)((ElectPreferredLeadersResult)electResult.elem).partitions().get());
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition1).get();
        this.waitForLeaderToBecome$1(partition1, 1);
        Throwable e = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((ElectPreferredLeadersResult)electResult$1.elem).partitionResult(partition2).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1347))).getCause();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getClass());
        Assert.assertEquals((Object)"Preferred leader election for partition \"elect-preferred-leaders-topic-2-0\" was not attempted", (Object)e.getMessage());
        Assert.assertEquals((long)0L, (long)this.currentLeader$1(partition2));
        electResult.elem = this.client().electPreferredLeaders(null);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)((ElectPreferredLeadersResult)electResult.elem).partitions().get()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testElectPreferredLeaders$6(x$23))));
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition1).get();
        this.waitForLeaderToBecome$1(partition1, 1);
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition2).get();
        this.waitForLeaderToBecome$1(partition2, 1);
        TopicPartition unknownPartition = new TopicPartition("topic-does-not-exist", 0);
        electResult.elem = this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{unknownPartition}));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava(), (Object)((ElectPreferredLeadersResult)electResult.elem).partitions().get());
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((ElectPreferredLeadersResult)electResult$1.elem).partitionResult(unknownPartition).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1365))).getCause();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)e.getMessage());
        Assert.assertEquals((long)1L, (long)this.currentLeader$1(partition1));
        Assert.assertEquals((long)1L, (long)this.currentLeader$1(partition2));
        this.changePreferredLeader$1(prefer2, partition1, partition2);
        electResult.elem = this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{unknownPartition, partition1}));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava(), (Object)((ElectPreferredLeadersResult)electResult.elem).partitions().get());
        this.waitForLeaderToBecome$1(partition1, 2);
        Assert.assertEquals((long)1L, (long)this.currentLeader$1(partition2));
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((ElectPreferredLeadersResult)electResult$1.elem).partitionResult(unknownPartition).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1379))).getCause();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)e.getMessage());
        electResult.elem = this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{partition2, partition2}));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava(), (Object)((ElectPreferredLeadersResult)electResult.elem).partitions().get());
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition2).get();
        this.waitForLeaderToBecome$1(partition2, 2);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        ((KafkaServer)this.servers().apply(1)).shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            java.util.Map description = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{partition1.topic(), partition2.topic()}))).asJava()).all().get();
            Iterable isr = (Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(description).asScala()).values().flatMap((Function1 & Serializable & scala.Serializable)x$24 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$24.partitions()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$25 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$25.isr()).asScala(), Buffer$.MODULE$.canBuildFrom()), scala.collection.Iterable$.MODULE$.canBuildFrom());
            return !isr.exists((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testElectPreferredLeaders$12(x$26)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expect broker 1 to no longer be in any ISR", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        ElectPreferredLeadersOptions shortTimeout = (ElectPreferredLeadersOptions)new ElectPreferredLeadersOptions().timeoutMs(Predef$.MODULE$.int2Integer(10000));
        electResult.elem = this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{partition1}), shortTimeout);
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), (Object)((ElectPreferredLeadersResult)electResult.elem).partitions().get());
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((ElectPreferredLeadersResult)electResult$1.elem).partitionResult(partition1).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1403))).getCause();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, e.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(e.getMessage()).toString(), (boolean)e.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        Assert.assertEquals((long)2L, (long)this.currentLeader$1(partition1));
        electResult.elem = this.client().electPreferredLeaders(null, shortTimeout);
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (java.util.Set)((ElectPreferredLeadersResult)electResult$1.elem).partitions().get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1411))).getCause();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, e.getClass());
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((ElectPreferredLeadersResult)electResult$1.elem).partitionResult(partition1).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1414))).getCause();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, e.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(e.getMessage()).toString(), (boolean)e.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((ElectPreferredLeadersResult)electResult$1.elem).partitionResult(partition2).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1419))).getCause();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, e.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(e.getMessage()).toString(), (boolean)e.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-2-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        Assert.assertEquals((long)2L, (long)this.currentLeader$1(partition1));
        Assert.assertEquals((long)2L, (long)this.currentLeader$1(partition2));
    }

    @Test
    public void testValidIncrementalAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topic1CreateConfigs = new Properties();
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topic1, 1, 1, topic1CreateConfigs);
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMsProp(), "1000"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete()), AlterConfigOp.OpType.APPEND), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.RetentionMsProp(), ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection();
        Collection topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assert.assertEquals((Object)"compact,delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)(Defaults$.MODULE$.LogRetentionHours() * 60 * 60 * 1000))).toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)"lz4", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.SUBTRACT)}))).asJava();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava());
        alterResult.all().get();
        describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava());
        configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.APPEND)}))).asJava();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        alterResult.all().get();
        describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava());
        configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "zip"), AlterConfigOp.OpType.SET)}))).asJava();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    @Test
    public void testInvalidIncrementalAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.75"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.65"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        Collection topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Error due to duplicate config keys"));
        ((KafkaFuture)alterResult.values().get(topic2Resource)).get();
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)Defaults$.MODULE$.CompressionType().toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.APPEND)}))).asJavaCollection();
        topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "snappy"), AlterConfigOp.OpType.SUBTRACT)}))).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value append is not allowed for config"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic2Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value subtract is not allowed for config"));
        topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.1"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    @Test
    public void testLongTopicNames() {
        AdminClient client = AdminClient.create(this.createConfig());
        String longTopicName = String.join((CharSequence)"", Collections.nCopies(249, "x"));
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(250, "x"));
        Seq newTopics2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(invalidTopicName, 3, 3), new NewTopic(longTopicName, 3, 3)}));
        java.util.Map results = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics2).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey(longTopicName));
        ((KafkaFuture)results.get(longTopicName)).get();
        Assert.assertTrue((boolean)results.containsKey(invalidTopicName));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get(invalidTopicName), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(client.alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(longTopicName, 0, 0)), ((KafkaServer)this.servers().apply(0)).config().logDirs().apply(0))}))).asJava()).all(), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        client.close();
    }

    public static final /* synthetic */ void $anonfun$generateConfigs$2(AdminClientIntegrationTest $this, Properties x$1) {
        Implicits$.MODULE$.PropertiesOps(x$1).$plus$plus$eq($this.serverConfig());
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$3(java.util.Set topics$1, String topicName) {
        return !topics$1.contains(topicName);
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$6(AdminClientIntegrationTest $this, Node replica) {
        Assert.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((replica.id() < $this.brokerCount() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataRefresh$1(AdminClientIntegrationTest $this, KafkaServer x$7) {
        return x$7.config().brokerId() == TestUtils$.MODULE$.waitUntilControllerElected($this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
    }

    public static final /* synthetic */ void $anonfun$testDescribeCluster$2(String[] brokers$1, Node node) {
        String hostStr = new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString();
        Assert.assertTrue((String)new StringBuilder(45).append("Unknown host:port pair ").append(hostStr).append(" in brokerVersionInfos").toString(), (boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers$1)).contains((Object)hostStr));
    }

    public static final /* synthetic */ int $anonfun$testDescribeLogDirs$1(Tuple2 x0$1) {
        int leaderId;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = leaderId = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$5(int brokerId$1, KafkaServer x$10) {
        return x$10.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$7(String topic$1, TopicPartition x$11) {
        String string = x$11.topic();
        String string2 = topic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$10(KafkaServer server$1, String logDir$1, TopicPartition tp) {
        LogManager qual$1 = server$1.logManager();
        TopicPartition x$1 = tp;
        boolean x$2 = qual$1.getLog$default$2();
        Assert.assertEquals((Object)((Log)qual$1.getLog(x$1, x$2).get()).dir().getParent(), (Object)logDir$1);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$9(KafkaServer server$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String logDir = (String)tuple2._1();
        DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            AdminClientIntegrationTest.$anonfun$testDescribeLogDirs$10(server$1, logDir, tp);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeReplicaLogDirs$3(TopicPartitionReplica topicPartitionReplica$1, KafkaServer x$13) {
        return x$13.config().brokerId() == topicPartitionReplica$1.brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeReplicaLogDirs$2(AdminClientIntegrationTest $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartitionReplica topicPartitionReplica = (TopicPartitionReplica)tuple2._1();
        DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)tuple2._2();
        KafkaServer server = (KafkaServer)$this.servers().find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AdminClientIntegrationTest.$anonfun$testDescribeReplicaLogDirs$3(topicPartitionReplica, x$13))).get();
        TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
        LogManager qual$1 = server.logManager();
        TopicPartition x$1 = tp;
        boolean x$2 = qual$1.getLog$default$2();
        Assert.assertEquals((Object)((Log)qual$1.getLog(x$1, x$2).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$4(KafkaFuture future) {
        ExecutionException exception = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)future.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        Assert.assertTrue((boolean)(exception.getCause() instanceof UnknownTopicOrPartitionException));
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$6(TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$1 = tp$1;
        boolean x$2 = qual$1.getLog$default$2();
        String logDir = ((Log)qual$1.getLog(x$1, x$2).get()).dir().getParent();
        Assert.assertEquals((Object)firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId())), (Object)logDir);
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$18(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ConsumerRecord consumerRecord = (ConsumerRecord)tuple2._1();
        int index = tuple2._2$mcI$sp();
        Assert.assertEquals((Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(index).toString(), (Object)new String((byte[])consumerRecord.value()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final java.util.List partitions$1(String topic) {
        return ((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).values().get(topic)).get()).partitions();
    }

    private final int numPartitions$1(String topic) {
        return this.partitions$1(topic).size();
    }

    public static final /* synthetic */ void $anonfun$testCreatePartitions$3(AdminClientIntegrationTest $this, ObjectRef alterResult$1, String topic1$2, String topic2$1, java.util.List newPartition2Assignments$1, ObjectRef altered$1, CreatePartitionsOptions option) {
        Object object;
        Object object2;
        String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)1))}))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            Assert.fail((String)new StringBuilder(63).append(desc).append(": Expect InvalidPartitionsException when newCount is a decrease").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
        }
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
            Assert.fail((String)new StringBuilder(58).append(desc).append(": Expect InvalidPartitionsException when requesting a noop").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
        }
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)newPartition2Assignments$1))}))).asJava(), option);
        try {
            object2 = ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
            object2 = BoxedUnit.UNIT;
        }
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(newPartition2Assignments$1).asScala()).reverse()).toList()).asJava())))}))).asJava(), option);
        try {
            object = ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1));
            object = BoxedUnit.UNIT;
        }
        String unknownTopic = "an-unknown-topic";
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTopic), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(unknownTopic)).get();
            Assert.fail((String)new StringBuilder(58).append(desc).append(": Expect InvalidTopicException when using an unknown topic").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof UnknownTopicOrPartitionException));
            Assert.assertEquals((String)desc, (Object)"The topic 'an-unknown-topic' does not exist.", (Object)e.getCause().getMessage());
        }
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)-22))}))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            Assert.fail((String)new StringBuilder(60).append(desc).append(": Expect InvalidPartitionsException when newCount is invalid").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
        }
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            Assert.fail((String)new StringBuilder(71).append(desc).append(": Expect InvalidPartitionsException when #brokers != replication factor").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
        }
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)6, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            Assert.fail((String)new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
        }
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            Assert.fail((String)new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
        }
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            Assert.fail((String)new StringBuilder(81).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Duplicate brokers not allowed in replica assignment: 1, 1 for partition id 3.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
        }
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)5, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})})))}))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            Assert.fail((String)new StringBuilder(94).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
        }
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(12)})})))}))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            Assert.fail((String)new StringBuilder(86).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Unknown broker(s) in replica assignment: 12.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
        }
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$2), (Object)NewPartitions.increaseTo((int)4, Collections.emptyList()))}))).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$2)).get();
            Assert.fail((String)new StringBuilder(68).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments is empty").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$2));
        }
    }

    private final void waitForFollowerLog$1(long expectedStartOffset, long expectedEndOffset, int followerIndex$1) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Option option = ((KafkaServer)this.servers().apply(followerIndex$1)).replicaManager().localReplica(this.topicPartition());
            None$ none$ = None$.MODULE$;
            return option == null ? none$ != null : !option.equals(none$);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected follower to create replica for partition", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)((KafkaServer)this.servers().apply(followerIndex$1)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset() == expectedStartOffset, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Expected follower to discover new log start offset ").append(expectedStartOffset).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)((KafkaServer)this.servers().apply(followerIndex$1)).replicaManager().localReplica(this.topicPartition()).get()).logEndOffset() == expectedEndOffset, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Expected follower to catch up to log end offset ").append(expectedEndOffset).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(AdminClientIntegrationTest $this, TopicPartition topicPartition$1, KafkaProducer producer$1, int i) {
        ProducerRecord record = new ProducerRecord(topicPartition$1.topic(), Predef$.MODULE$.int2Integer(topicPartition$1.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$1.send(record);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$2(String testGroupId$1, ConsumerGroupListing x$22) {
        String string = x$22.groupId();
        String string2 = testGroupId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$4(String testTopicName$1, TopicPartition tp) {
        return tp.topic().equals(testTopicName$1);
    }

    private final int currentLeader$1(TopicPartition topicPartition) {
        return ((TopicPartitionInfo)((TopicDescription)((KafkaFuture)this.client().describeTopics(Arrays.asList((Object[])new String[]{topicPartition.topic()})).values().get(topicPartition.topic())).get()).partitions().get(topicPartition.partition())).leader().id();
    }

    private final int preferredLeader$1(TopicPartition topicPartition) {
        return ((Node)((TopicPartitionInfo)((TopicDescription)((KafkaFuture)this.client().describeTopics(Arrays.asList((Object[])new String[]{topicPartition.topic()})).values().get(topicPartition.topic())).get()).partitions().get(topicPartition.partition())).replicas().get(0)).id();
    }

    private final void waitForLeaderToBecome$1(TopicPartition topicPartition, int leader) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.currentLeader$1(topicPartition) == leader, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Expected leader to become ").append(leader).toString(), 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private final void changePreferredLeader$1(Seq newAssignment, TopicPartition partition1$1, TopicPartition partition2$1) {
        int preferred = BoxesRunTime.unboxToInt((Object)newAssignment.head());
        int prior1 = this.currentLeader$1(partition1$1);
        int prior2 = this.currentLeader$1(partition2$1);
        scala.collection.immutable.Map m = Predef$.MODULE$.Map().empty();
        if (prior1 != preferred) {
            m = m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1$1), (Object)newAssignment));
        }
        if (prior2 != preferred) {
            m = m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2$1), (Object)newAssignment));
        }
        this.zkClient().createPartitionReassignment(m);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.preferredLeader$1(partition1$1) == preferred && this.preferredLeader$1(partition2$1) == preferred, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Expected preferred leader to become ").append(preferred).append(", but is ").append(this.preferredLeader$1(partition1$1)).append(" and ").append(this.preferredLeader$1(partition2$1)).toString(), 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)prior1, (long)this.currentLeader$1(partition1$1));
        Assert.assertEquals((long)prior2, (long)this.currentLeader$1(partition2$1));
    }

    public static final /* synthetic */ boolean $anonfun$testElectPreferredLeaders$6(TopicPartition x$23) {
        String string = x$23.topic();
        String string2 = "__consumer_offsets";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testElectPreferredLeaders$12(Node x$26) {
        return x$26.id() == 1;
    }

    public AdminClientIntegrationTest() {
        this.topic = "topic";
        this.partition = 0;
        this.brokerCount = 3;
        this.consumerCount = 1;
        this.producerCount = 1;
    }
}

