/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigType$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedCreatePartitions;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ReassignmentInProgressException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=g\u0001\u0002\u0011\"\u0001\u0019B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005w!Aa\u0007\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003B\u0011!q\u0005A!b\u0001\n\u0003y\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011Q\u0003!Q1A\u0005\u0002UC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\u0006;\u0002!\tA\u0018\u0005\bI\u0002\u0011\r\u0011\"\u0003f\u0011\u0019a\u0007\u0001)A\u0005M\"9Q\u000e\u0001b\u0001\n\u0013q\u0007B\u0002:\u0001A\u0003%q\u000eC\u0004t\u0001\t\u0007I\u0011\u0002;\t\r}\u0004\u0001\u0015!\u0003v\u0011%\t\t\u0001\u0001b\u0001\n\u0013\t\u0019\u0001\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0003\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u00111\u0018\u0001\u0005\u0002\u0005u\u0006bBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005+\u0001A\u0011\u0001B\f\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005cAqAa\r\u0001\t\u0013\u0011)\u0004C\u0004\u0003<\u0001!IA!\u0010\t\u000f\tU\u0003\u0001\"\u0003\u0003X!9!Q\u000e\u0001\u0005\n\t=\u0004b\u0002BA\u0001\u0011%!1\u0011\u0005\b\u0005\u007f\u0003A\u0011\u0002Ba\u00051\tE-\\5o\u001b\u0006t\u0017mZ3s\u0015\t\u00113%\u0001\u0004tKJ4XM\u001d\u0006\u0002I\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001([M\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019$\u0003\u0015)H/\u001b7t\u0013\t\u0011tFA\u0004M_\u001e<\u0017N\\4\u0011\u0005Q:T\"A\u001b\u000b\u0005Y\u001a\u0013aB7fiJL7m]\u0005\u0003qU\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\u0019\u0019wN\u001c4jOV\t1\b\u0005\u0002={5\t\u0011%\u0003\u0002?C\tY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002*\u0012!\u0011\t\u0003\u0005.k\u0011a\u0011\u0006\u0003m\u0011S!!\u0012$\u0002\r\r|W.\\8o\u0015\t!sI\u0003\u0002I\u0013\u00061\u0011\r]1dQ\u0016T\u0011AS\u0001\u0004_J<\u0017B\u0001'D\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003A\u0003\"\u0001P)\n\u0005I\u000b#!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u0011i\\7\t\\5f]R,\u0012A\u0016\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\u000e\n!A_6\n\u0005mC&!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uA\u00051A(\u001b8jiz\"Ra\u00181bE\u000e\u0004\"\u0001\u0010\u0001\t\u000beJ\u0001\u0019A\u001e\t\u000bYJ\u0001\u0019A!\t\u000b9K\u0001\u0019\u0001)\t\u000bQK\u0001\u0019\u0001,\u0002\u001dQ|\u0007/[2QkJ<\u0017\r^8ssV\ta\rE\u0002=O&L!\u0001[\u0011\u00033\u0011+G.Y=fI>\u0003XM]1uS>t\u0007+\u001e:hCR|'/\u001f\t\u0003y)L!a[\u0011\u0003!\u0011+G.Y=fI>\u0003XM]1uS>t\u0017a\u0004;pa&\u001c\u0007+\u001e:hCR|'/\u001f\u0011\u0002\u001b\u0005$W.\u001b8[W\u000ec\u0017.\u001a8u+\u0005y\u0007CA,q\u0013\t\t\bLA\u0007BI6LgNW6DY&,g\u000e^\u0001\u000fC\u0012l\u0017N\u001c.l\u00072LWM\u001c;!\u0003E\u0019'/Z1uKR{\u0007/[2Q_2L7-_\u000b\u0002kB\u0019\u0001F\u001e=\n\u0005]L#AB(qi&|g\u000e\u0005\u0002z{6\t!P\u0003\u0002|y\u00061\u0001o\u001c7jGfT!A\t$\n\u0005yT(!E\"sK\u0006$X\rV8qS\u000e\u0004v\u000e\\5ds\u0006\u00112M]3bi\u0016$v\u000e]5d!>d\u0017nY=!\u0003E\tG\u000e^3s\u0007>tg-[4Q_2L7-_\u000b\u0003\u0003\u000b\u0001B\u0001\u000b<\u0002\bA\u0019\u00110!\u0003\n\u0007\u0005-!PA\tBYR,'oQ8oM&<\u0007k\u001c7jGf\f!#\u00197uKJ\u001cuN\u001c4jOB{G.[2zA\u0005I\u0002.Y:EK2\f\u00170\u001a3U_BL7m\u00149fe\u0006$\u0018n\u001c8t+\t\t\u0019\u0002E\u0002)\u0003+I1!a\u0006*\u0005\u001d\u0011un\u001c7fC:\f\u0011\u0005\u001e:z\u0007>l\u0007\u000f\\3uK\u0012+G.Y=fIR{\u0007/[2Pa\u0016\u0014\u0018\r^5p]N$B!!\b\u0002$A\u0019\u0001&a\b\n\u0007\u0005\u0005\u0012F\u0001\u0003V]&$\bbBA\u0013'\u0001\u0007\u0011qE\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003S\t9D\u0004\u0003\u0002,\u0005M\u0002cAA\u0017S5\u0011\u0011q\u0006\u0006\u0004\u0003c)\u0013A\u0002\u001fs_>$h(C\u0002\u00026%\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001d\u0003w\u0011aa\u0015;sS:<'bAA\u001bS\u0005a1M]3bi\u0016$v\u000e]5dgRQ\u0011QDA!\u0003\u0017\ny%!\"\t\u000f\u0005\rC\u00031\u0001\u0002F\u00059A/[7f_V$\bc\u0001\u0015\u0002H%\u0019\u0011\u0011J\u0015\u0003\u0007%sG\u000fC\u0004\u0002NQ\u0001\r!a\u0005\u0002\u0019Y\fG.\u001b3bi\u0016|e\u000e\\=\t\u000f\u0005EC\u00031\u0001\u0002T\u0005Q1M]3bi\u0016LeNZ8\u0011\u0011\u0005U\u00131LA\u0014\u0003?j!!a\u0016\u000b\u0007\u0005e\u0013&\u0001\u0006d_2dWm\u0019;j_:LA!!\u0018\u0002X\t\u0019Q*\u00199\u0011\t\u0005\u0005\u0014q\u0010\b\u0005\u0003G\nIH\u0004\u0003\u0002f\u0005Ud\u0002BA4\u0003grA!!\u001b\u0002r9!\u00111NA8\u001d\u0011\ti#!\u001c\n\u0003)K!\u0001S%\n\u0005\u0011:\u0015BA#G\u0013\r\t9\bR\u0001\te\u0016\fX/Z:ug&!\u00111PA?\u0003M\u0019%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u\u0015\r\t9\bR\u0005\u0005\u0003\u0003\u000b\u0019I\u0001\u0007U_BL7\rR3uC&d7O\u0003\u0003\u0002|\u0005u\u0004bBAD)\u0001\u0007\u0011\u0011R\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004r\u0001KAF\u0003\u001f\u000bi\"C\u0002\u0002\u000e&\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0011\u0005U\u00131LA\u0014\u0003#\u0003B!a%\u0002\u00166\u0011\u0011QP\u0005\u0005\u0003/\u000biH\u0001\u0005Ba&,%O]8s\u00031!W\r\\3uKR{\u0007/[2t)!\ti\"!(\u0002 \u0006%\u0006bBA\"+\u0001\u0007\u0011Q\t\u0005\b\u0003C+\u0002\u0019AAR\u0003\u0019!x\u000e]5dgB1\u0011QKAS\u0003OIA!a*\u0002X\t\u00191+\u001a;\t\u000f\u0005\u001dU\u00031\u0001\u0002,B9\u0001&a#\u0002.\u0006u\u0001\u0003CA+\u00037\n9#a,\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.E\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA]\u0003g\u0013a!\u0012:s_J\u001c\u0018\u0001E2sK\u0006$X\rU1si&$\u0018n\u001c8t)1\ti\"a0\u0002B\u0006U\u0017q[At\u0011\u001d\t\u0019E\u0006a\u0001\u0003\u000bBq!a1\u0017\u0001\u0004\t)-A\u0007oK^\u0004\u0016M\u001d;ji&|gn\u001d\t\t\u0003+\nY&a\n\u0002HB!\u0011\u0011ZAh\u001d\u0011\t\u0019'a3\n\t\u00055\u0017QP\u0001\u0018\u0007J,\u0017\r^3QCJ$\u0018\u000e^5p]N\u0014V-];fgRLA!!5\u0002T\n\u0001\u0002+\u0019:uSRLwN\u001c#fi\u0006LGn\u001d\u0006\u0005\u0003\u001b\fi\bC\u0004\u0002NY\u0001\r!a\u0005\t\u000f\u0005eg\u00031\u0001\u0002\\\u0006aA.[:uK:,'OT1nKB!\u0011Q\\Ar\u001b\t\tyNC\u0002\u0002b\u0012\u000bqA\\3uo>\u00148.\u0003\u0003\u0002f\u0006}'\u0001\u0004'jgR,g.\u001a:OC6,\u0007bBAu-\u0001\u0007\u0011\u0011R\u0001\tG\u0006dGNY1dW\u0006yA-Z:de&\u0014WmQ8oM&<7\u000f\u0006\u0004\u0002p\n%!\u0011\u0003\t\t\u0003+\nY&!=\u0002|B!\u00111_A|\u001b\t\t)P\u0003\u0002:\t&!\u0011\u0011`A{\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016\u0004B!!@\u0003\u00049!\u00111SA\u0000\u0013\u0011\u0011\t!! \u0002/\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm\u001d9p]N,\u0017\u0002\u0002B\u0003\u0005\u000f\u0011aaQ8oM&<'\u0002\u0002B\u0001\u0003{BqAa\u0003\u0018\u0001\u0004\u0011i!A\u000bsKN|WO]2f)>\u001cuN\u001c4jO:\u000bW.Z:\u0011\u0011\u0005U\u00131LAy\u0005\u001f\u0001B\u0001\u000b<\u0002$\"9!1C\fA\u0002\u0005M\u0011aD5oG2,H-Z*z]>t\u00170\\:\u0002\u0019\u0005dG/\u001a:D_:4\u0017nZ:\u0015\r\te!1\u0004B\u0017!!\t)&a\u0017\u0002r\u0006E\u0005b\u0002B\u000f1\u0001\u0007!qD\u0001\bG>tg-[4t!!\t)&a\u0017\u0002r\n\u0005\u0002\u0003\u0002B\u0012\u0005SqA!a%\u0003&%!!qEA?\u0003M\tE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u\u0013\u0011\u0011)Aa\u000b\u000b\t\t\u001d\u0012Q\u0010\u0005\b\u0003\u001bB\u0002\u0019AA\n\u0003!\u0019\b.\u001e;e_^tGCAA\u000f\u0003Y\u0011Xm]8ve\u000e,g*Y7f)>\u0014%o\\6fe&#G\u0003BA#\u0005oAqA!\u000f\u001b\u0001\u0004\t9#\u0001\u0007sKN|WO]2f\u001d\u0006lW-\u0001\bce>\\WM]*z]>t\u00170\\:\u0015\t\t}\"\u0011\u000b\t\u0007\u0005\u0003\u0012Y%a\n\u000f\t\t\r#q\t\b\u0005\u0003[\u0011)%C\u0001+\u0013\r\u0011I%K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iEa\u0014\u0003\t1K7\u000f\u001e\u0006\u0004\u0005\u0013J\u0003b\u0002B*7\u0001\u0007\u0011qE\u0001\u0005]\u0006lW-\u0001\u0006d_:4\u0017n\u001a+za\u0016$bA!\u0017\u0003h\t%\u0004\u0003\u0002B.\u0005CrA!a=\u0003^%!!qLA{\u0003%\u0019uN\u001c4jO\u0012+g-\u0003\u0003\u0003d\t\u0015$\u0001\u0002+za\u0016TAAa\u0018\u0002v\"9!1\u000b\u000fA\u0002\u0005\u001d\u0002b\u0002B69\u0001\u0007!qH\u0001\tgftwN\\=ng\u0006q1m\u001c8gS\u001e\u001c\u0016P\\8os6\u001cH\u0003\u0003B9\u0005s\u0012YH! \u0011\r\t\u0005#1\nB:!\u0011\tiP!\u001e\n\t\t]$q\u0001\u0002\u000e\u0007>tg-[4Ts:|g._7\t\u000f\tMS\u00041\u0001\u0002(!9!1N\u000fA\u0002\t}\u0002b\u0002B@;\u0001\u0007\u00111C\u0001\fSN\u001cVM\\:ji&4X-\u0001\fde\u0016\fG/\u001a+pa&\u001c7i\u001c8gS\u001e,e\u000e\u001e:z)!\u0011)I!'\u0003*\nuFC\u0002BD\u0005\u001b\u0013y\t\u0005\u0003\u0002~\n%\u0015\u0002\u0002BF\u0005\u000f\u00111bQ8oM&<WI\u001c;ss\"9!1\u000b\u0010A\u0002\u0005\u001d\u0002b\u0002BI=\u0001\u0007!1S\u0001\u0006m\u0006dW/\u001a\t\u0004Q\tU\u0015b\u0001BLS\t\u0019\u0011I\\=\t\u000f\tme\u00041\u0001\u0003\u001e\u0006IAn\\4D_:4\u0017n\u001a\t\u0005\u0005?\u0013)+\u0004\u0002\u0003\"*\u0019!1U\u0012\u0002\u00071|w-\u0003\u0003\u0003(\n\u0005&!\u0003'pO\u000e{gNZ5h\u0011\u001d\u0011YK\ba\u0001\u0005[\u000b!\u0002^8qS\u000e\u0004&o\u001c9t!\u0011\u0011yK!/\u000e\u0005\tE&\u0002\u0002BZ\u0005k\u000bA!\u001e;jY*\u0011!qW\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003<\nE&A\u0003)s_B,'\u000f^5fg\"9!1\u0003\u0010A\u0002\u0005M\u0011aF2sK\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e,e\u000e\u001e:z)\u0019\u0011\u0019M!3\u0003NR1!q\u0011Bc\u0005\u000fDqAa\u0015 \u0001\u0004\t9\u0003C\u0004\u0003\u0012~\u0001\rAa%\t\u000f\t-w\u00041\u0001\u0002\u0014\u0005y\u0001/\u001a:Ce>\\WM]\"p]\u001aLw\rC\u0004\u0003\u0014}\u0001\r!a\u0005")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final KafkaZkClient zkClient;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final AdminZkClient adminZkClient;
    private final Option<CreateTopicPolicy> createTopicPolicy;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    private Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Request key ").append(key.keyLabel()).append(" unblocked ").append(completed).append(" topic requests.").toString());
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequest.TopicDetails> createInfo, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)createInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CreatePartitionsMetadata createPartitionsMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                CreateTopicsRequest.TopicDetails arguments = (CreateTopicsRequest.TopicDetails)tuple2._2();
                try {
                    Properties configs = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.configs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        Object object = configs.setProperty(key, value);
                        return object;
                    });
                    LogConfig$.MODULE$.validate(configs);
                    if (!(arguments.numPartitions == -1 && arguments.replicationFactor == -1 || arguments.replicasAssignments.isEmpty())) {
                        throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                    }
                    Map<Object, Seq<Object>> assignments = !arguments.replicasAssignments.isEmpty() ? (Map<Object, Seq<Object>>)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.replicasAssignments).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Integer partitionId = (Integer)tuple2._1();
                        java.util.List replicas = (java.util.List)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1), Buffer$.MODULE$.canBuildFrom()));
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom()) : AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)brokers, arguments.numPartitions, arguments.replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Assignments for topic ").append(topic).append(" are ").append(assignments).append(" ").toString());
                    Option<CreateTopicPolicy> option = this.createTopicPolicy();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        CreateTopicPolicy policy = (CreateTopicPolicy)some.value();
                        this.adminZkClient().validateTopicCreate(topic, assignments, configs);
                        Integer numPartitions = arguments.numPartitions == -1 ? null : Predef$.MODULE$.int2Integer(arguments.numPartitions);
                        Short replicationFactor = arguments.replicationFactor == -1 ? null : Predef$.MODULE$.short2Short(arguments.replicationFactor);
                        java.util.Map replicaAssignments = arguments.replicasAssignments.isEmpty() ? null : arguments.replicasAssignments;
                        policy.validate(new CreateTopicPolicy.RequestMetadata(topic, numPartitions, replicationFactor, replicaAssignments, arguments.configs));
                        if (!validateOnly) {
                            this.adminZkClient().createTopicWithAssignment(topic, configs, assignments);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (validateOnly) {
                            this.adminZkClient().validateTopicCreate(topic, assignments, configs);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.adminZkClient().createTopicWithAssignment(topic, configs, assignments);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    } else {
                        throw new MatchError(option);
                    }
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, assignments, ApiError.NONE);
                }
                catch (ApiException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Error processing create topic request for topic ").append(topic).append(" with arguments ").append(arguments).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)e));
                }
                catch (ConfigException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Error processing create topic request for topic ").append(topic).append(" with arguments ").append(arguments).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)new InvalidConfigurationException(e.getMessage(), e.getCause())));
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Error processing create topic request for topic ").append(topic).append(" with arguments ").append(arguments).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), ApiError.fromThrowable((Throwable)e));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CreatePartitionsMetadata createPartitionsMetadata2 = createPartitionsMetadata;
            return createPartitionsMetadata2;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$13(x$2)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createTopicMetadata -> createTopicMetadata.error().isSuccess() && !validateOnly ? new Tuple2((Object)createTopicMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedCreateKeys = ((TraversableOnce)createInfo.keys().map((Function1 & Serializable & scala.Serializable)x$3 -> new TopicKey((String)x$3), Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> {
            DeleteTopicMetadata deleteTopicMetadata;
            try {
                this.adminZkClient().deleteTopic((String)topic);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error processing delete topic request for topic ").append((String)topic).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.forException((Throwable)e));
            }
            return deleteTopicMetadata;
        }, Set$.MODULE$.canBuildFrom());
        if (timeout <= 0 || !metadata.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$deleteTopics$4(x$4)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)deleteTopicMetadata -> {
                Errors errors = deleteTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply((Object)results);
        } else {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedDeleteKeys = ((SetLike)topics.map((Function1 & Serializable & scala.Serializable)x$5 -> new TopicKey((String)x$5), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
        }
    }

    public void createPartitions(int timeout, Map<String, CreatePartitionsRequest.PartitionDetails> newPartitions, boolean validateOnly, ListenerName listenerName, Function1<Map<String, ApiError>, BoxedUnit> callback) {
        boolean reassignPartitionsInProgress = this.zkClient().reassignPartitionsInProgress();
        Seq<BrokerMetadata> allBrokers = this.adminZkClient().getBrokerMetadatas(this.adminZkClient().getBrokerMetadatas$default$1(), this.adminZkClient().getBrokerMetadatas$default$2());
        Seq allBrokerIds = (Seq)allBrokers.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)newPartitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CreatePartitionsMetadata createPartitionsMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                CreatePartitionsRequest.PartitionDetails newPartition = (CreatePartitionsRequest.PartitionDetails)tuple2._2();
                try {
                    if (reassignPartitionsInProgress) {
                        throw new ReassignmentInProgressException("A partition reassignment is in progress.");
                    }
                    scala.collection.immutable.Map existingAssignment = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                        return tuple22;
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    if (existingAssignment.isEmpty()) {
                        throw new UnknownTopicOrPartitionException(new StringBuilder(28).append("The topic '").append(topic).append("' does not exist.").toString());
                    }
                    int oldNumPartitions = existingAssignment.size();
                    int newNumPartitions = newPartition.totalCount();
                    int numPartitionsIncrement = newNumPartitions - oldNumPartitions;
                    if (numPartitionsIncrement < 0) {
                        throw new InvalidPartitionsException(new StringBuilder(69).append("Topic currently has ").append(oldNumPartitions).append(" partitions, which is higher than the requested ").append(newNumPartitions).append(".").toString());
                    }
                    if (numPartitionsIncrement == 0) {
                        throw new InvalidPartitionsException(new StringBuilder(30).append("Topic already has ").append(oldNumPartitions).append(" partitions.").toString());
                    }
                    Option reassignment = Option$.MODULE$.apply((Object)newPartition.newAssignments()).map((Function1 & Serializable & scala.Serializable)x$7 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$7).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$9)), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)assignments -> {
                        scala.collection.immutable.Set unknownBrokers = (scala.collection.immutable.Set)((TraversableOnce)assignments.flatten((Function1)Predef$.MODULE$.$conforms())).toSet().$minus$minus((GenTraversableOnce)allBrokerIds);
                        if (unknownBrokers.nonEmpty()) {
                            throw new InvalidReplicaAssignmentException(new StringBuilder(42).append("Unknown broker(s) in replica assignment: ").append(unknownBrokers.mkString(", ")).append(".").toString());
                        }
                        if (assignments.size() != numPartitionsIncrement) {
                            throw new InvalidReplicaAssignmentException(new StringBuilder(40).append("Increasing the number of partitions by ").append(numPartitionsIncrement).append(" ").append(new StringBuilder(26).append("but ").append(assignments.size()).append(" assignments provided.").toString()).toString());
                        }
                        return ((TraversableOnce)((TraversableLike)assignments.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                            Tuple2 tuple2 = x0$3;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Buffer replicas = (Buffer)tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(existingAssignment.size() + index))), (Object)replicas);
                            return tuple22;
                        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    });
                    Map<Object, Seq<Object>> updatedReplicaAssignment = this.adminZkClient().addPartitions(topic, (Map<Object, Seq<Object>>)existingAssignment, allBrokers, newPartition.totalCount(), (Option<Map<Object, Seq<Object>>>)reassignment, validateOnly);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, updatedReplicaAssignment, ApiError.NONE);
                }
                catch (AdminOperationException e) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
                }
                catch (ApiException e) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable((Throwable)e));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CreatePartitionsMetadata createPartitionsMetadata2 = createPartitionsMetadata;
            return createPartitionsMetadata2;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createPartitions$9(x$10)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1 & Serializable & scala.Serializable)createPartitionMetadata -> createPartitionMetadata.error().isSuccess() && !validateOnly ? new Tuple2((Object)createPartitionMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createPartitionMetadata.topic(), (Object)createPartitionMetadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            callback.apply((Object)results);
        } else {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata.toSeq(), this, callback);
            Seq delayedCreateKeys = ((SetLike)newPartitions.keySet().map((Function1 & Serializable & scala.Serializable)x$11 -> new TopicKey((String)x$11), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        }
    }

    public Map<ConfigResource, DescribeConfigsResponse.Config> describeConfigs(Map<ConfigResource, Option<Set<String>>> resourceToConfigNames, boolean includeSynonyms) {
        return ((TraversableOnce)resourceToConfigNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                ConfigResource resource = (ConfigResource)tuple22._1();
                Option configNames = (Option)tuple22._2();
                try {
                    DescribeConfigsResponse.Config config;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        DescribeConfigsResponse.Config config2;
                        String topic = resource.name();
                        Topic.validate((String)topic);
                        if (this.metadataCache().contains(topic)) {
                            Properties topicProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                            LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config()), topicProps);
                            config2 = AdminManager.createResponseConfig$1((Map)AdminManager.allConfigs$1(logConfig), (Function2 & Serializable & scala.Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, (String)name, value), configNames);
                        } else {
                            config2 = new DescribeConfigsResponse.Config(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, null), Collections.emptyList());
                        }
                        config = config2;
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        DescribeConfigsResponse.Config config3;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            config3 = AdminManager.createResponseConfig$1(this.config().dynamicConfig().currentDynamicDefaultConfigs(), (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, (String)name, value), configNames);
                        } else if (this.resourceNameToBrokerId(resource.name()) == this.config().brokerId()) {
                            config3 = AdminManager.createResponseConfig$1((Map)AdminManager.allConfigs$1(this.config()), (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, (String)name, value), configNames);
                        } else {
                            throw new InvalidRequestException(new StringBuilder(67).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(" or empty string, but received ").append(resource).append(".name").toString());
                        }
                        config = config3;
                    } else {
                        throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                    }
                    DescribeConfigsResponse.Config resourceConfig = config;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)resourceConfig);
                }
                catch (Throwable e) {
                    String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(resource).toString();
                    if (e instanceof ApiException) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    } else {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)new DescribeConfigsResponse.Config(ApiError.fromThrowable((Throwable)e), Collections.emptyList()));
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<ConfigResource, ApiError> alterConfigs(Map<ConfigResource, AlterConfigsRequest.Config> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                ConfigResource resource = (ConfigResource)tuple22._1();
                AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)tuple22._2();
                try {
                    Tuple2 tuple23;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        String topic = resource.name();
                        Properties properties = new Properties();
                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)configEntry -> properties.setProperty(configEntry.name(), configEntry.value()));
                        this.adminZkClient().validateTopicConfig(topic, properties);
                        this.validateConfigPolicy$1(ConfigResource.Type.TOPIC, config, resource);
                        if (!validateOnly) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Updating topic ").append(topic).append(" with new configuration ").append(config).toString());
                            this.adminZkClient().changeTopicConfig(topic, properties);
                        }
                        tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        None$ none$;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            none$ = None$.MODULE$;
                        } else {
                            int id = this.resourceNameToBrokerId(resource.name());
                            if (id != this.config().brokerId()) {
                                throw new InvalidRequestException(new StringBuilder(51).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(", but received ").append(resource).append(".name").toString());
                            }
                            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)id));
                        }
                        None$ brokerId = none$;
                        Properties configProps = new Properties();
                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)configEntry -> configProps.setProperty(configEntry.name(), configEntry.value()));
                        boolean perBrokerConfig = brokerId.nonEmpty();
                        this.config().dynamicConfig().validate(configProps, perBrokerConfig);
                        this.validateConfigPolicy$1(ConfigResource.Type.BROKER, config, resource);
                        if (!validateOnly) {
                            if (perBrokerConfig) {
                                this.config().dynamicConfig().reloadUpdatedFilesWithoutConfigChange(configProps);
                            }
                            this.adminZkClient().changeBrokerConfig((Option<Object>)brokerId, this.config().dynamicConfig().toPersistentProps(configProps, perBrokerConfig));
                        }
                        tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.NONE);
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple23;
                }
                catch (Throwable throwable) {
                    Tuple2 tuple24;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof ConfigException ? true : throwable2 instanceof IllegalArgumentException;
                    if (bl) {
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable2.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable2)));
                    } else if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(config).toString();
                        if (throwable3 instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                        }
                        tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)ApiError.fromThrowable((Throwable)throwable3));
                    } else {
                        throw throwable;
                    }
                    tuple2 = tuple24;
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple25 = tuple2;
            return tuple25;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createTopicPolicy().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfigPolicy().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    private int resourceNameToBrokerId(String resourceName) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(resourceName)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
        return n;
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private ConfigDef.Type configType(String name, List<String> synonyms) {
        ConfigDef.Type configType = this.config().typeOf(name);
        return configType != null ? configType : (ConfigDef.Type)synonyms.iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> this.config().typeOf((String)x$1)).find((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$configType$2(x$16))).orNull(Predef$.MODULE$.$conforms());
    }

    private List<DescribeConfigsResponse.ConfigSynonym> configSynonyms(String name2, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config().dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map<String, String> map = dynamicConfig.currentDynamicBrokerConfigs();
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(map, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        Map<String, String> map2 = dynamicConfig.currentDynamicDefaultConfigs();
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(map2, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)allSynonyms.dropWhile((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$configSynonyms$6(name2, s)))).toList();
    }

    private DescribeConfigsResponse.ConfigEntry createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, String name, Object value) {
        List list;
        ConfigDef.Type configEntryType;
        ConfigDef.Type type = configEntryType = logConfig.typeOf(name);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean isSensitive = !(type != null ? !type.equals(type2) : type2 != null);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
        List list2 = (List)LogConfig$.MODULE$.TopicConfigSynonyms().get((Object)name).map((Function1 & Serializable & scala.Serializable)s -> this.configSynonyms((String)s, this.brokerSynonyms((String)s), isSensitive)).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponse.ConfigSynonym configSynonym = new DescribeConfigsResponse.ConfigSynonym(name, valueAsString, DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG);
            list = (List)list2.$plus$colon((Object)configSynonym, List$.MODULE$.canBuildFrom());
        }
        List allSynonyms = list;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, false, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    private DescribeConfigsResponse.ConfigEntry createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, String name, Object value) {
        String string;
        boolean isSensitive;
        ConfigDef.Type configEntryType;
        List<String> allNames = this.brokerSynonyms(name);
        ConfigDef.Type type = configEntryType = this.configType(name, allNames);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean bl = !(type == null ? type2 != null : !type.equals(type2)) || configEntryType == null ? true : (isSensitive = false);
        if (isSensitive) {
            string = null;
        } else {
            String string2;
            Object object = value;
            String string3 = object instanceof String ? (string2 = (String)object) : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
            string = string3;
        }
        String valueAsString = string;
        List allSynonyms = (List)this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$18)));
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        boolean readOnly = !allNames.exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createBrokerConfigEntry$2(elem)));
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, readOnly, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$13(CreatePartitionsMetadata x$2) {
        return x$2.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopics$4(DeleteTopicMetadata x$4) {
        Errors errors = x$4.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createPartitions$9(CreatePartitionsMetadata x$10) {
        return x$10.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$2(Tuple2 x$12) {
        return x$12._2() != null;
    }

    private static final scala.collection.mutable.Map allConfigs$1(AbstractConfig config) {
        return ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$2(x$12)))).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$3(Option configNames$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String configName = (String)tuple2._1();
        boolean bl = configNames$1.forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.contains((Object)configName)));
        return bl;
    }

    private static final DescribeConfigsResponse.Config createResponseConfig$1(Map configs, Function2 createConfigEntry, Option configNames$1) {
        IndexedSeq filteredConfigPairs = ((TraversableOnce)configs.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames$1, x0$1)))).toIndexedSeq();
        IndexedSeq configEntries = (IndexedSeq)filteredConfigPairs.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Object value = tuple2._2();
            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createConfigEntry.apply((Object)name, value);
            return configEntry;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)configEntries).asJava());
    }

    private final void validateConfigPolicy$1(ConfigResource.Type resourceType, AlterConfigsRequest.Config config$1, ConfigResource resource$1) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            Some some = (Some)option;
            AlterConfigPolicy policy = (AlterConfigPolicy)some.value();
            scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config$1.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), (Object)entry.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            policy.validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resourceType, resource$1.name()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)configEntriesMap).asJava()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ boolean $anonfun$configType$2(ConfigDef.Type x$16) {
        return x$16 != null;
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$1, Buffer allSynonyms$1) {
        map.get((Object)name).map((Function1 & Serializable & scala.Serializable)value -> {
            String configValue = isSensitive$1 ? null : value;
            return allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponse.ConfigSynonym(name, configValue, source));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponse.ConfigSynonym s) {
        String string = s.name();
        String string2 = name$2;
        return string == null ? string2 != null : !string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponse.ConfigSynonym x$18) {
        if (perBrokerConfig$1) return true;
        DescribeConfigsResponse.ConfigSource configSource = x$18.source();
        DescribeConfigsResponse.ConfigSource configSource2 = DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
        if (configSource != null) {
            if (!configSource.equals(configSource2)) return false;
            return true;
        }
        if (configSource2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$2(String elem) {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)elem);
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, KafkaZkClient zkClient) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkClient = zkClient;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq(new StringBuilder(28).append("[Admin Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        this.adminZkClient = new AdminZkClient(zkClient);
        this.createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
    }
}

