/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\ret!\u00020`\u0011\u0003!g!\u00024`\u0011\u00039\u0007\"\u00028\u0002\t\u0003y\u0007b\u00029\u0002\u0005\u0004%I!\u001d\u0005\u0007k\u0006\u0001\u000b\u0011\u0002:\t\u000fY\f!\u0019!C\u0005o\"9\u0011\u0011A\u0001!\u0002\u0013A\b\u0002CA\u0002\u0003\t\u0007I\u0011B<\t\u000f\u0005\u0015\u0011\u0001)A\u0005q\"A\u0011qA\u0001C\u0002\u0013%q\u000fC\u0004\u0002\n\u0005\u0001\u000b\u0011\u0002=\t\u0011\u0005-\u0011A1A\u0005\n]Dq!!\u0004\u0002A\u0003%\u0001\u0010\u0003\u0005\u0002\u0010\u0005\u0011\r\u0011\"\u0003x\u0011\u001d\t\t\"\u0001Q\u0001\naD\u0001\"a\u0005\u0002\u0005\u0004%Ia\u001e\u0005\b\u0003+\t\u0001\u0015!\u0003y\u0011!\t9\"\u0001b\u0001\n\u00139\bbBA\r\u0003\u0001\u0006I\u0001\u001f\u0005\t\u00037\t!\u0019!C\u0005o\"9\u0011QD\u0001!\u0002\u0013A\b\u0002CA\u0010\u0003\t\u0007I\u0011B<\t\u000f\u0005\u0005\u0012\u0001)A\u0005q\"A\u00111E\u0001C\u0002\u0013%q\u000fC\u0004\u0002&\u0005\u0001\u000b\u0011\u0002=\t\u0011\u0005\u001d\u0012A1A\u0005\n]Dq!!\u000b\u0002A\u0003%\u0001\u0010C\u0005\u0002,\u0005\u0011\r\u0011\"\u0003\u0002.!A\u0011QG\u0001!\u0002\u0013\ty\u0003C\u0005\u00028\u0005\u0011\r\u0011\"\u0003\u0002.!A\u0011\u0011H\u0001!\u0002\u0013\ty\u0003C\u0005\u0002<\u0005\u0011\r\u0011\"\u0003\u0002.!A\u0011QH\u0001!\u0002\u0013\ty\u0003C\u0005\u0002@\u0005\u0011\r\u0011\"\u0001\u0002B!A\u0011\u0011M\u0001!\u0002\u0013\t\u0019\u0005C\u0005\u0002d\u0005\u0011\r\u0011\"\u0001\u0002B!A\u0011QM\u0001!\u0002\u0013\t\u0019\u0005C\u0004\u0002h\u0005!\t!!\u001b\t\u000f\u0005e\u0015\u0001\"\u0003\u0002\u001c\"9\u0011qX\u0001\u0005\n\u0005\u0005\u0007\u0002CAf\u0003\u0011\u0005q,!4\t\u0011\u0005e\u0017\u0001\"\u0001`\u00037Dq!a9\u0002\t\u0013\t)\u000fC\u0005\u0002t\u0006\t\n\u0011\"\u0003\u0002v\"I!1B\u0001\u0012\u0002\u0013\u0005!Q\u0002\u0004\u0006M~\u0003!\u0011\u0003\u0005\u000b\u0005?i#Q1A\u0005\u0002\t\u0005\u0002B\u0003B\u0016[\t\u0005\t\u0015!\u0003\u0003$!Q!QF\u0017\u0003\u0002\u0004%\tAa\f\t\u0015\tERF!a\u0001\n\u0003\u0011\u0019\u0004\u0003\u0006\u0003:5\u0012\t\u0011)Q\u0005\u0003\u001bC!Ba\u0011.\u0005\u000b\u0007I\u0011AA\u0017\u0011)\u0011)%\fB\u0001B\u0003%\u0011q\u0006\u0005\u0007]6\"\tAa\u0012\t\u0013\tESF1A\u0005\n\tM\u0003\u0002\u0003B+[\u0001\u0006I!!+\t\u0013\t]S\u00061A\u0005\n\te\u0003\"\u0003B.[\u0001\u0007I\u0011\u0002B/\u0011!\u0011\t'\fQ!\n\u0005e\u0006\"\u0003B2[\u0001\u0007I\u0011\u0002B-\u0011%\u0011)'\fa\u0001\n\u0013\u00119\u0007\u0003\u0005\u0003l5\u0002\u000b\u0015BA]\u0011%\u0011i'\fb\u0001\n\u0013\u0011y\u0007\u0003\u0005\u0003\u00046\u0002\u000b\u0011\u0002B9\u0011%\u0011))\fb\u0001\n\u0013\u0011y\u0007\u0003\u0005\u0003\b6\u0002\u000b\u0011\u0002B9\u0011\u001d\u0011I)\fC\u0001\u0005\u0017CqAa(.\t\u0003\u0011\t\u000bC\u0004\u0003(6\"\tA!+\t\u000f\t5V\u0006\"\u0001\u0003Z!9!qV\u0017\u0005\u0002\tE\u0006b\u0002B_[\u0011\u0005!q\u0018\u0005\b\u0005\u0003lC\u0011\u0002Bb\u0011!\u0011i-\fC\u0001?\n=\u0007b\u0002Bk[\u0011%!q\u001b\u0005\b\u0005ClC\u0011\u0001Br\u0011\u001d\u00119/\fC\u0001\u0005SDqAa=.\t\u0003\u0011)\u0010C\u0004\u0004\u00065\"\taa\u0002\t\u000f\r5Q\u0006\"\u0001\u0004\u0010!91QC\u0017\u0005\u0002\r]\u0001bBB\u000f[\u0011\u00051q\u0004\u0005\b\u0007CiC\u0011\u0001BU\u0011\u001d\u0019\u0019#\fC\u0001\u0005SCqa!\n.\t\u0013\u00199\u0003C\u0004\u000405\"\ta!\r\t\u000f\rUR\u0006\"\u0003\u00048!91QI\u0017\u0005\n\r\u001d\u0003bBB&[\u0011\u00051q\u0004\u0005\b\u0007\u001bjC\u0011AB(\u0011\u001d\tI.\fC\u0001\u00077Bqaa\u001a.\t\u0013\u0019I\u0007C\u0004\u0004n5\"Ia!\u001b\t\u000f\u0005-W\u0006\"\u0003\u0004p\u0005!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJT!\u0001Y1\u0002\u00071|wMC\u0001c\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!Z\u0001\u000e\u0003}\u0013A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148CA\u0001i!\tIG.D\u0001k\u0015\u0005Y\u0017!B:dC2\f\u0017BA7k\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001Z\u0001\u0018!J|G-^2feNs\u0017\r]:i_R4VM]:j_:,\u0012A\u001d\t\u0003SNL!\u0001\u001e6\u0003\u000bMCwN\u001d;\u00021A\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$h+\u001a:tS>t\u0007%\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-F\u0001y!\tIh0D\u0001{\u0015\tYH0\u0001\u0003mC:<'\"A?\u0002\t)\fg/Y\u0005\u0003\u007fj\u0014aa\u0015;sS:<\u0017!\u0004,feNLwN\u001c$jK2$\u0007%\u0001\u0005De\u000e4\u0015.\u001a7e\u0003%\u0019%o\u0019$jK2$\u0007%A\bQe>$WoY3s\u0013\u00124\u0015.\u001a7e\u0003A\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a$jK2$\u0007%A\tMCN$8+Z9vK:\u001cWMR5fY\u0012\f!\u0003T1tiN+\u0017/^3oG\u00164\u0015.\u001a7eA\u0005\u0011\u0002K]8ek\u000e,'/\u00129pG\"4\u0015.\u001a7e\u0003M\u0001&o\u001c3vG\u0016\u0014X\t]8dQ\u001aKW\r\u001c3!\u0003=a\u0015m\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0017\u0001\u0005'bgR|eMZ:fi\u001aKW\r\u001c3!\u0003AyeMZ:fi\u0012+G\u000e^1GS\u0016dG-A\tPM\u001a\u001cX\r\u001e#fYR\fg)[3mI\u0002\na\u0002V5nKN$\u0018-\u001c9GS\u0016dG-A\bUS6,7\u000f^1na\u001aKW\r\u001c3!\u0003Q\u0001&o\u001c3vG\u0016\u0014XI\u001c;sS\u0016\u001ch)[3mI\u0006)\u0002K]8ek\u000e,'/\u00128ue&,7OR5fY\u0012\u0004\u0013!F\"p_J$\u0017N\\1u_J,\u0005o\\2i\r&,G\u000eZ\u0001\u0017\u0007>|'\u000fZ5oCR|'/\u00129pG\"4\u0015.\u001a7eA\u0005Q2)\u001e:sK:$H\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$h)[3mI\u0006Y2)\u001e:sK:$H\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$h)[3mI\u0002\nQBV3sg&|gn\u00144gg\u0016$XCAA\u0018!\rI\u0017\u0011G\u0005\u0004\u0003gQ'aA%oi\u0006qa+\u001a:tS>twJ\u001a4tKR\u0004\u0013!C\"sG>3gm]3u\u0003)\u0019%oY(gMN,G\u000fI\u0001\u0016!J|G-^2fe\u0016sGO]5fg>3gm]3u\u0003Y\u0001&o\u001c3vG\u0016\u0014XI\u001c;sS\u0016\u001cxJ\u001a4tKR\u0004\u0013a\u0007)s_\u0012,8-\u001a:T]\u0006\u00048\u000f[8u\u000b:$(/_*dQ\u0016l\u0017-\u0006\u0002\u0002DA!\u0011QIA/\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013!\u0002;za\u0016\u001c(\u0002BA'\u0003\u001f\n\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u0005\u0003#\n\u0019&\u0001\u0004d_6lwN\u001c\u0006\u0004E\u0006U#\u0002BA,\u00033\na!\u00199bG\",'BAA.\u0003\ry'oZ\u0005\u0005\u0003?\n9E\u0001\u0004TG\",W.Y\u0001\u001d!J|G-^2feNs\u0017\r]:i_R,e\u000e\u001e:z'\u000eDW-\\1!\u0003Q\u0001\u0016\u000eZ*oCB\u001c\bn\u001c;NCB\u001c6\r[3nC\u0006)\u0002+\u001b3T]\u0006\u00048\u000f[8u\u001b\u0006\u00048k\u00195f[\u0006\u0004\u0013\u0001\u0004:fC\u0012\u001cf.\u00199tQ>$H\u0003BA6\u0003\u0013\u0003b!!\u001c\u0002~\u0005\re\u0002BA8\u0003srA!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003k\u001a\u0017A\u0002\u001fs_>$h(C\u0001l\u0013\r\tYH[\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty(!!\u0003\u0011%#XM]1cY\u0016T1!a\u001fk!\r)\u0017QQ\u0005\u0004\u0003\u000f{&A\u0005)s_\u0012,8-\u001a:Ti\u0006$X-\u00128uefDq!a#&\u0001\u0004\ti)\u0001\u0003gS2,\u0007\u0003BAH\u0003+k!!!%\u000b\u0007\u0005ME0\u0001\u0002j_&!\u0011qSAI\u0005\u00111\u0015\u000e\\3\u0002\u001b]\u0014\u0018\u000e^3T]\u0006\u00048\u000f[8u)\u0019\ti*a)\u0002&B\u0019\u0011.a(\n\u0007\u0005\u0005&N\u0001\u0003V]&$\bbBAFM\u0001\u0007\u0011Q\u0012\u0005\b\u0003O3\u0003\u0019AAU\u0003\u001d)g\u000e\u001e:jKN\u0004\u0002\"a+\u00026\u0006e\u00161Q\u0007\u0003\u0003[SA!a,\u00022\u00069Q.\u001e;bE2,'bAAZU\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0016Q\u0016\u0002\u0004\u001b\u0006\u0004\bcA5\u0002<&\u0019\u0011Q\u00186\u0003\t1{gnZ\u0001\u000fSN\u001cf.\u00199tQ>$h)\u001b7f)\u0011\t\u0019-!3\u0011\u0007%\f)-C\u0002\u0002H*\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0002\f\u001e\u0002\r!!$\u0002#1L7\u000f^*oCB\u001c\bn\u001c;GS2,7\u000f\u0006\u0003\u0002P\u0006U\u0007CBA7\u0003#\fi)\u0003\u0003\u0002T\u0006\u0005%aA*fc\"9\u0011q\u001b\u0015A\u0002\u00055\u0015a\u00013je\u0006)B-\u001a7fi\u0016\u001cf.\u00199tQ>$8OQ3g_J,GCBAO\u0003;\fy\u000eC\u0004\u0002X&\u0002\r!!$\t\u000f\u0005\u0005\u0018\u00061\u0001\u0002:\u00061qN\u001a4tKR\f1\u0003Z3mKR,7K\\1qg\"|GOR5mKN$b!!(\u0002h\u0006%\bbBAlU\u0001\u0007\u0011Q\u0012\u0005\n\u0003WT\u0003\u0013!a\u0001\u0003[\f\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0011\u000f%\fy/!/\u0002D&\u0019\u0011\u0011\u001f6\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!\b3fY\u0016$Xm\u00158baNDw\u000e\u001e$jY\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005](\u0006BAw\u0003s\\#!a?\u0011\t\u0005u(qA\u0007\u0003\u0003\u007fTAA!\u0001\u0003\u0004\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u000bQ\u0017AC1o]>$\u0018\r^5p]&!!\u0011BA\u0000\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t=!\u0006BA\u0018\u0003s\u001cB!\f5\u0003\u0014A!!Q\u0003B\u000e\u001b\t\u00119BC\u0002\u0003\u001a\u0005\fQ!\u001e;jYNLAA!\b\u0003\u0018\t9Aj\\4hS:<\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0005G\u0001BA!\n\u0003(5\u0011\u0011qJ\u0005\u0005\u0005S\tyE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\na\u0001\\8h\t&\u0014XCAAG\u0003)awn\u001a#je~#S-\u001d\u000b\u0005\u0003;\u0013)\u0004C\u0005\u00038E\n\t\u00111\u0001\u0002\u000e\u0006\u0019\u0001\u0010J\u0019\u0002\u000f1|w\rR5sA!\u001a!G!\u0010\u0011\u0007%\u0014y$C\u0002\u0003B)\u0014\u0001B^8mCRLG.Z\u0001\u001a[\u0006D\bK]8ek\u000e,'/\u00133FqBL'/\u0019;j_:l5/\u0001\u000enCb\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#ya&\u0014\u0018\r^5p]6\u001b\b\u0005\u0006\u0005\u0003J\t-#Q\nB(!\t)W\u0006C\u0004\u0003 U\u0002\rAa\t\t\u000f\t5R\u00071\u0001\u0002\u000e\"I!1I\u001b\u0011\u0002\u0003\u0007\u0011qF\u0001\naJ|G-^2feN,\"!!+\u0002\u0015A\u0014x\u000eZ;dKJ\u001c\b%A\u0007mCN$X*\u00199PM\u001a\u001cX\r^\u000b\u0003\u0003s\u000b\u0011\u0003\\1ti6\u000b\u0007o\u00144gg\u0016$x\fJ3r)\u0011\tiJa\u0018\t\u0013\t]\u0012(!AA\u0002\u0005e\u0016A\u00047bgRl\u0015\r](gMN,G\u000fI\u0001\u000fY\u0006\u001cHo\u00158ba>3gm]3u\u0003Ia\u0017m\u001d;T]\u0006\u0004xJ\u001a4tKR|F%Z9\u0015\t\u0005u%\u0011\u000e\u0005\n\u0005oa\u0014\u0011!a\u0001\u0003s\u000bq\u0002\\1tiNs\u0017\r](gMN,G\u000fI\u0001\f_:<w.\u001b8h)bt7/\u0006\u0002\u0003rAA!1\u000fB=\u0003s\u0013i(\u0004\u0002\u0003v)\u0019!q\u000f?\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005w\u0012)HA\u0004Ue\u0016,W*\u00199\u0011\u0007\u0015\u0014y(C\u0002\u0003\u0002~\u00131\u0002\u0016=o\u001b\u0016$\u0018\rZ1uC\u0006aqN\\4pS:<G\u000b\u001f8tA\u0005\u0001RO\u001c:fa2L7-\u0019;fIRChn]\u0001\u0012k:\u0014X\r\u001d7jG\u0006$X\r\u001a+y]N\u0004\u0013a\u00054jeN$XK\\:uC\ndWm\u00144gg\u0016$XC\u0001BG!\u0015I'q\u0012BJ\u0013\r\u0011\tJ\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tU%1T\u0007\u0003\u0005/S1A!'b\u0003\u0019\u0019XM\u001d<fe&!!Q\u0014BL\u0005EaunZ(gMN,G/T3uC\u0012\fG/Y\u0001\u0017_:D\u0015n\u001a5XCR,'/\\1sWV\u0003H-\u0019;fIR!\u0011Q\u0014BR\u0011\u001d\u0011)k\u0011a\u0001\u0003s\u000bQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0017\u0001\u00064jeN$XK\u001c3fG&$W\rZ(gMN,G/\u0006\u0002\u0003,B)\u0011Na$\u0002:\u0006aQ.\u00199F]\u0012|eMZ:fi\u0006y\u0011m\u0019;jm\u0016\u0004&o\u001c3vG\u0016\u00148/\u0006\u0002\u00034BA!Q\u0017B^\u0003s\u000b\u0019)\u0004\u0002\u00038*!!\u0011XAY\u0003%IW.\\;uC\ndW-\u0003\u0003\u00028\n]\u0016aB5t\u000b6\u0004H/_\u000b\u0003\u0003\u0007\f\u0001\u0003\\8bI\u001a\u0013x.\\*oCB\u001c\bn\u001c;\u0015\r\u0005u%Q\u0019Be\u0011\u001d\u00119\r\u0013a\u0001\u0003s\u000ba\u0002\\8h'R\f'\u000f^(gMN,G\u000fC\u0004\u0003L\"\u0003\r!!/\u0002\u0017\r,(O]3oiRKW.Z\u0001\u0012Y>\fG\r\u0015:pIV\u001cWM]#oiJLH\u0003BAO\u0005#DqAa5J\u0001\u0004\t\u0019)A\u0003f]R\u0014\u00180A\tjgB\u0013x\u000eZ;dKJ,\u0005\u0010]5sK\u0012$b!a1\u0003Z\nu\u0007b\u0002Bn\u0015\u0002\u0007\u0011\u0011X\u0001\u000eGV\u0014(/\u001a8u)&lW-T:\t\u000f\t}'\n1\u0001\u0002\u0004\u0006i\u0001O]8ek\u000e,'o\u0015;bi\u0016\faC]3n_Z,W\t\u001f9je\u0016$\u0007K]8ek\u000e,'o\u001d\u000b\u0005\u0003;\u0013)\u000fC\u0004\u0003\\.\u0003\r!!/\u0002#Q\u0014XO\\2bi\u0016\fe\u000e\u001a*fY>\fG\r\u0006\u0005\u0002\u001e\n-(Q\u001eBy\u0011\u001d\u00119\r\u0014a\u0001\u0003sCqAa<M\u0001\u0004\tI,\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000fC\u0004\u0003\\2\u0003\r!!/\u0002\u001bA\u0014X\r]1sKV\u0003H-\u0019;f)\u0019\u00119P!@\u0004\u0002A\u0019QM!?\n\u0007\tmxL\u0001\nQe>$WoY3s\u0003B\u0004XM\u001c3J]\u001a|\u0007b\u0002B\u0000\u001b\u0002\u0007\u0011\u0011X\u0001\u000baJ|G-^2fe&#\u0007bBB\u0002\u001b\u0002\u0007\u00111Y\u0001\rSN4%o\\7DY&,g\u000e^\u0001\u0007kB$\u0017\r^3\u0015\t\u0005u5\u0011\u0002\u0005\b\u0007\u0017q\u0005\u0019\u0001B|\u0003)\t\u0007\u000f]3oI&sgm\\\u0001\u0013kB$\u0017\r^3NCB,e\u000eZ(gMN,G\u000f\u0006\u0003\u0002\u001e\u000eE\u0001bBB\n\u001f\u0002\u0007\u0011\u0011X\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\u0018!\u00037bgR,e\u000e\u001e:z)\u0011\u0019Iba\u0007\u0011\u000b%\u0014y)a!\t\u000f\t}\b\u000b1\u0001\u0002:\u0006aA/Y6f':\f\u0007o\u001d5piR\u0011\u0011QT\u0001\u0015Y\u0006$Xm\u001d;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;\u0002)=dG-Z:u':\f\u0007o\u001d5pi>3gm]3u\u0003II7\u000f\u0015:pIV\u001cWM\u001d*fi\u0006Lg.\u001a3\u0015\r\u0005\r7\u0011FB\u0017\u0011\u001d\u0019Y\u0003\u0016a\u0001\u0003\u0007\u000b!\u0003\u001d:pIV\u001cWM]*uCR,WI\u001c;ss\"9!q\u0019+A\u0002\u0005e\u0016\u0001\u0004;sk:\u001c\u0017\r^3IK\u0006$G\u0003BAO\u0007gAqAa2V\u0001\u0004\tI,\u0001\u0011sK6|g/Z#wS\u000e$X\rZ(oO>Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\u001cH\u0003BAO\u0007sAqaa\u000fW\u0001\u0004\u0019i$\u0001\nfqBL'/\u001a3Qe>$WoY3s\u0013\u0012\u001c\bCBB \u0007\u0003\nI,\u0004\u0002\u00022&!11IAY\u0005\r\u0019V\r^\u0001\u001fe\u0016lwN^3V]J,\u0007\u000f\\5dCR,G\r\u0016:b]N\f7\r^5p]N$B!!(\u0004J!9\u0011\u0011],A\u0002\u0005e\u0016\u0001\u0003;sk:\u001c\u0017\r^3\u0002\u0017\r|W\u000e\u001d7fi\u0016$\u0006P\u001c\u000b\u0005\u0003s\u001b\t\u0006C\u0004\u0004Te\u0003\ra!\u0016\u0002\u0019\r|W\u000e\u001d7fi\u0016$G\u000b\u001f8\u0011\u0007\u0015\u001c9&C\u0002\u0004Z}\u0013AbQ8na2,G/\u001a3Uq:$B!!(\u0004^!9\u0011\u0011\u001d.A\u0002\u0005e\u0006f\u0001.\u0004bA!!QCB2\u0013\u0011\u0019)Ga\u0006\u0003\u0015QD'/Z1eg\u00064W-\u0001\npY\u0012,7\u000f^*oCB\u001c\bn\u001c;GS2,WCAB6!\u0015I'qRAG\u0003Ia\u0017\r^3tiNs\u0017\r]:i_R4\u0015\u000e\\3\u0016\u0005\u0005=\u0007fA\u0017\u0004tA!!QCB;\u0013\u0011\u00199Ha\u0006\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0001")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File logDir;
    private final int maxProducerIdExpirationMs;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ProducerStateManager producerStateManager = this;
        synchronized (producerStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TxnMetadata)x$5.getValue()).firstOffset());
        return unreplicatedFirstOffset.isEmpty() ? undecidedFirstOffset : (undecidedFirstOffset.isEmpty() ? unreplicatedFirstOffset : (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset() ? undecidedFirstOffset : var1_1));
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        while (true) {
            Option<File> option;
            if ((option = this.latestSnapshotFile()) instanceof Some) {
                Some some = (Some)option;
                File file = (File)some.value();
                try {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading producer state from snapshot file '").append(file).append("'").toString());
                    Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(file).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, logStartOffset, currentTime, producerEntry)));
                    loadedProducers.foreach((Function1 & Serializable & scala.Serializable)entry -> {
                        this.loadProducerEntry(entry);
                        return BoxedUnit.UNIT;
                    });
                    this.lastSnapOffset_$eq(Log$.MODULE$.offsetFromFile(file));
                    this.lastMapOffset_$eq(this.lastSnapOffset());
                    return;
                }
                catch (CorruptSnapshotException e) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to load producer snapshot from '").append(file).append("': ").append(e.getMessage()).toString());
                    boolean bl = Files.deleteIfExists(file.toPath());
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    this.lastSnapOffset_$eq(logStartOffset);
                    this.lastMapOffset_$eq(logStartOffset);
                    return;
                }
                throw new MatchError(option);
            }
        }
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        entry.currentTxnFirstOffset().foreach((Function1 & Serializable & scala.Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong((Object)offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().retain((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, BoxesRunTime.unboxToLong((Object)x0$1), x1$1)));
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), (Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)snapOffset -> snapOffset > logEndOffset || snapOffset <= logStartOffset);
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
        } else {
            this.truncateHead(logStartOffset);
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, boolean isFromClient) {
        Product product;
        if (!isFromClient) {
            product = ValidationType$None$.MODULE$;
        } else {
            String string = this.topicPartition().topic();
            String string2 = "__consumer_offsets";
            product = !(string != null ? !string.equals(string2) : string2 != null) ? ValidationType$EpochOnly$.MODULE$ : ValidationType$Full$.MODULE$;
        }
        ValidationType$None$ validationToPerform = product;
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(producerId, currentEntry, validationToPerform);
    }

    public void update(ProducerAppendInfo appendInfo) {
        BoxedUnit boxedUnit;
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("Invalid producer id ").append(appendInfo.producerId()).append(" passed to update ").append(new StringBuilder(14).append("for partition ").append(this.topicPartition()).toString()).toString());
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Updated producer ").append(appendInfo.producerId()).append(" state to ").append(appendInfo).toString());
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
        if (option instanceof Some) {
            Some some = (Some)option;
            ProducerStateEntry currentEntry = (ProducerStateEntry)some.value();
            currentEntry.update(updatedEntry);
            boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            boxedUnit = this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
        } else {
            throw new MatchError((Object)option);
        }
        appendInfo.startedTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), (TxnMetadata)txn));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        block0: {
            if (this.lastMapOffset() <= this.lastSnapOffset()) break block0;
            File snapshotFile = Log$.MODULE$.producerSnapshotFile(this.logDir(), this.lastMapOffset());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Writing producer snapshot at offset ").append(this.lastMapOffset()).toString());
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)));
    }

    private boolean isProducerRetained(ProducerStateEntry producerStateEntry, long logStartOffset) {
        producerStateEntry.removeBatchesOlderThan(logStartOffset);
        return producerStateEntry.lastDataOffset() >= logStartOffset;
    }

    public void truncateHead(long logStartOffset) {
        Map evictedProducerEntries = (Map)this.producers().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$truncateHead$1(this, logStartOffset, x0$1)));
        Set evictedProducerIds = evictedProducerEntries.keySet();
        this.producers().$minus$minus$eq((TraversableOnce)evictedProducerIds);
        this.removeEvictedOngoingTransactions((Set<Object>)evictedProducerIds);
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.deleteSnapshotsBefore(logStartOffset);
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset)));
    }

    private void removeEvictedOngoingTransactions(Set<Object> expiredProducerIds) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.ongoingTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator.next();
            if (!expiredProducerIds.contains((Object)BoxesRunTime.boxToLong((long)txnEntry.getValue().producerId()))) continue;
            iterator.remove();
        }
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator.next();
            Option<Object> lastOffset = txnEntry.getValue().lastOffset();
            if (!lastOffset.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> x$7 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncate() {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2());
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(0L);
    }

    /*
     * WARNING - void declaration
     */
    public long completeTxn(CompletedTxn completedTxn) {
        void var3_3;
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Attempted to complete transaction ").append(completedTxn).append(" on partition ").append(this.topicPartition()).append(" ").append("which was not started").toString());
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
        long lastStableOffset = BoxesRunTime.unboxToLong((Object)this.firstUndecidedOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> completedTxn.lastOffset() + 1L));
        return (long)var3_3;
    }

    public void deleteSnapshotsBefore(long offset) {
        ProducerStateManager$.MODULE$.deleteSnapshotsBefore(this.logDir(), offset);
    }

    private Option<File> oldestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.minBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Option<File> latestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.maxBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Seq<File> listSnapshotFiles() {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir());
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long logStartOffset$1, long currentTime$1, ProducerStateEntry producerEntry) {
        return $this.isProducerRetained(producerEntry, logStartOffset$1) && !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$1, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, long x0$1, ProducerStateEntry x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProducerStateEntry lastEntry = (ProducerStateEntry)tuple2._2();
        boolean bl = !$this.isProducerExpired(currentTimeMs$1, lastEntry);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$truncateHead$1(ProducerStateManager $this, long logStartOffset$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProducerStateEntry producerState = (ProducerStateEntry)tuple2._2();
        boolean bl = !$this.isProducerRetained(producerState, logStartOffset$3);
        return bl;
    }

    public ProducerStateManager(TopicPartition topicPartition, File logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this.logDir = logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[ProducerStateManager partition=").append(topicPartition).append("] ").toString());
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

