/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import kafka.admin.AclCommand;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.All$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Alter$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Describe$;
import kafka.security.auth.DescribeConfigs$;
import kafka.security.auth.IdempotentWrite$;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType$;
import kafka.security.auth.Write$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.io.StdIn$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Properties$;

public final class AclCommand$
implements Logging {
    public static AclCommand$ MODULE$;
    private final ResourcePatternFilter ClusterResourceFilter;
    private final String kafka$admin$AclCommand$$Newline;
    private final Map<ResourceType, Set<Operation>> ResourceTypeToValidOperations;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new AclCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AclCommand$ aclCommand$ = this;
        synchronized (aclCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ResourcePatternFilter ClusterResourceFilter() {
        return this.ClusterResourceFilter;
    }

    public String kafka$admin$AclCommand$$Newline() {
        return this.kafka$admin$AclCommand$$Newline;
    }

    public Map<ResourceType, Set<Operation>> ResourceTypeToValidOperations() {
        return this.ResourceTypeToValidOperations;
    }

    public void main(String[] args) {
        AclCommand.AclCommandOptions opts = new AclCommand.AclCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manage acls on kafka.");
        opts.checkArgs();
        AclCommand.AclCommandService aclCommandService = opts.options().has(opts.bootstrapServerOpt()) ? new AclCommand.AdminClientService(opts) : new AclCommand.AuthorizerService(opts);
        try {
            if (opts.options().has((OptionSpec)opts.addOpt())) {
                ((AclCommand.AclCommandService)aclCommandService).addAcls();
            } else if (opts.options().has((OptionSpec)opts.removeOpt())) {
                ((AclCommand.AclCommandService)aclCommandService).removeAcls();
            } else if (opts.options().has((OptionSpec)opts.listOpt())) {
                ((AclCommand.AclCommandService)aclCommandService).listAcls();
            }
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)new StringBuilder(35).append("Error while executing ACL command: ").append(e.getMessage()).toString());
            Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<Resource, Set<Acl>> kafka$admin$AclCommand$$getResourceToAcls(AclCommand.AclCommandOptions opts) {
        void var3_3;
        PatternType patternType = (PatternType)opts.options().valueOf(opts.resourcePatternType());
        if (!patternType.isSpecific()) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), new StringBuilder(70).append("A '--resource-pattern-type' value of '").append(patternType).append("' is not valid when adding acls.").toString());
        }
        Map resourceToAcl = (Map)this.kafka$admin$AclCommand$$getResourceFilterToAcls(opts).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ResourcePatternFilter filter = (ResourcePatternFilter)tuple2._1();
            Set acls = (Set)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Resource(ResourceType$.MODULE$.fromJava(filter.resourceType()), filter.name(), filter.patternType())), (Object)acls);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        if (resourceToAcl.values().exists((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isEmpty()))) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must specify one of: --allow-principal, --deny-principal when trying to add ACLs.");
        }
        return var3_3;
    }

    public Map<ResourcePatternFilter, Set<Acl>> kafka$admin$AclCommand$$getResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        ObjectRef resourceToAcls = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        if (!opts.options().has((OptionSpec)opts.producerOpt()) && !opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = ((Map)resourceToAcls.elem).$plus$plus(this.getCliResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.producerOpt())) {
            resourceToAcls.elem = ((Map)resourceToAcls.elem).$plus$plus(this.getProducerResourceFilterToAcls(opts));
        }
        if (opts.options().has((OptionSpec)opts.consumerOpt())) {
            resourceToAcls.elem = ((Map)resourceToAcls.elem).$plus$plus((GenTraversableOnce)this.getConsumerResourceFilterToAcls(opts).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ResourcePatternFilter k = (ResourcePatternFilter)tuple2._1();
                Set v = (Set)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)((Map)resourceToAcls$3.elem).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()));
        }
        this.validateOperation(opts, (Map<ResourcePatternFilter, Set<Acl>>)((Map)resourceToAcls.elem));
        return (Map)resourceToAcls.elem;
    }

    private Map<ResourcePatternFilter, Set<Acl>> getProducerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2());
        Set topics = (Set)filters.filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getProducerResourceFilterToAcls$1(x$20)));
        Set transactionalIds = (Set)filters.filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getProducerResourceFilterToAcls$2(x$21)));
        boolean enableIdempotence = opts.options().has((OptionSpec)opts.idempotentOpt());
        Set<Acl> topicAcls = this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$, Create$.MODULE$}))));
        Set<Acl> transactionalIdAcls = this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$}))));
        return ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$22 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$22), (Object)topicAcls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)transactionalIds.map((Function1 & Serializable & scala.Serializable)x$23 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$23), (Object)transactionalIdAcls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)(enableIdempotence ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ClusterResourceFilter()), this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{IdempotentWrite$.MODULE$})))))})) : Predef$.MODULE$.Map().empty()));
    }

    private Map<ResourcePatternFilter, Set<Acl>> getConsumerResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2());
        Set topics = (Set)filters.filter((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getConsumerResourceFilterToAcls$1(x$24)));
        Set groups = (Set)filters.filter((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$getConsumerResourceFilterToAcls$2(x$25)));
        Set<Acl> acls = this.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$}))));
        return ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)x$26 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$26), (Object)acls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)groups.map((Function1 & Serializable & scala.Serializable)x$27 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$27), MODULE$.getAcl(opts, (Set<Operation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$}))))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private Map<ResourcePatternFilter, Set<Acl>> getCliResourceFilterToAcls(AclCommand.AclCommandOptions opts) {
        Set<Acl> acls = this.getAcl(opts);
        Set<ResourcePatternFilter> filters = this.kafka$admin$AclCommand$$getResourceFilter(opts, this.getResourceFilter$default$2());
        return ((TraversableOnce)filters.map((Function1 & Serializable & scala.Serializable)x$28 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$28), (Object)acls), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Set<Acl> getAcl(AclCommand.AclCommandOptions opts, Set<Operation> operations) {
        Set<KafkaPrincipal> allowedPrincipals = this.kafka$admin$AclCommand$$getPrincipals(opts, opts.allowPrincipalsOpt());
        Set<KafkaPrincipal> deniedPrincipals = this.kafka$admin$AclCommand$$getPrincipals(opts, opts.denyPrincipalsOpt());
        Set<String> allowedHosts = this.getHosts(opts, opts.allowHostsOpt(), opts.allowPrincipalsOpt());
        Set<String> deniedHosts = this.getHosts(opts, opts.denyHostsOpt(), opts.denyPrincipalsOpt());
        HashSet acls = new HashSet();
        Object object = allowedHosts.nonEmpty() && allowedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(allowedPrincipals, Allow$.MODULE$, operations, allowedHosts)) : BoxedUnit.UNIT;
        Object object2 = deniedHosts.nonEmpty() && deniedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(deniedPrincipals, Deny$.MODULE$, operations, deniedHosts)) : BoxedUnit.UNIT;
        return acls.toSet();
    }

    private Set<Acl> getAcl(AclCommand.AclCommandOptions opts) {
        Set operations = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.operationsOpt())).asScala()).map((Function1 & Serializable & scala.Serializable)operation -> Operation$.MODULE$.fromString(operation.trim()), Buffer$.MODULE$.canBuildFrom())).toSet();
        return this.getAcl(opts, (Set<Operation>)operations);
    }

    public Set<Acl> getAcls(Set<KafkaPrincipal> principals, PermissionType permissionType, Set<Operation> operations, Set<String> hosts) {
        return (Set)principals.flatMap((Function1 & Serializable & scala.Serializable)principal -> (Set)operations.flatMap((Function1 & Serializable & scala.Serializable)operation -> (Set)hosts.map((Function1 & Serializable & scala.Serializable)host -> new Acl((KafkaPrincipal)principal, permissionType, (String)host, (Operation)operation), Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom());
    }

    private Set<String> getHosts(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> hostOptionSpec, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(hostOptionSpec) ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(hostOptionSpec)).asScala()).map((Function1 & Serializable & scala.Serializable)x$29 -> x$29.trim(), Buffer$.MODULE$.canBuildFrom())).toSet() : (opts.options().has(principalOptionSpec) ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Acl$.MODULE$.WildCardHost()})) : Predef$.MODULE$.Set().empty());
    }

    public Set<KafkaPrincipal> kafka$admin$AclCommand$$getPrincipals(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(principalOptionSpec) ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map((Function1 & Serializable & scala.Serializable)s -> SecurityUtils.parseKafkaPrincipal((String)s.trim()), Buffer$.MODULE$.canBuildFrom())).toSet() : Predef$.MODULE$.Set().empty();
    }

    public Set<ResourcePatternFilter> kafka$admin$AclCommand$$getResourceFilter(AclCommand.AclCommandOptions opts, boolean dieIfNoResourceFound) {
        PatternType patternType = (PatternType)opts.options().valueOf(opts.resourcePatternType());
        ObjectRef resourceFilters = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        if (opts.options().has(opts.topicOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.topicOpt())).asScala()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.TOPIC, topic.trim(), patternType));
                return BoxedUnit.UNIT;
            });
        }
        PatternType patternType2 = patternType;
        PatternType patternType3 = PatternType.LITERAL;
        if (!(patternType2 != null ? !patternType2.equals(patternType3) : patternType3 != null)) {
            if (opts.options().has((OptionSpec)opts.clusterOpt()) || opts.options().has((OptionSpec)opts.idempotentOpt())) {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)this.ClusterResourceFilter());
            }
        }
        if (opts.options().has(opts.groupOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.groupOpt())).asScala()).foreach((Function1 & Serializable & scala.Serializable)group -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.GROUP, group.trim(), patternType));
                return BoxedUnit.UNIT;
            });
        }
        if (opts.options().has(opts.transactionalIdOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.transactionalIdOpt())).asScala()).foreach((Function1 & Serializable & scala.Serializable)transactionalId -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.TRANSACTIONAL_ID, transactionalId, patternType));
                return BoxedUnit.UNIT;
            });
        }
        if (opts.options().has(opts.delegationTokenOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.delegationTokenOpt())).asScala()).foreach((Function1 & Serializable & scala.Serializable)token -> {
                resourceFilters.elem = (Set)((Set)resourceFilters.elem).$plus((Object)new ResourcePatternFilter(ResourceType.DELEGATION_TOKEN, token.trim(), patternType));
                return BoxedUnit.UNIT;
            });
        }
        if (((Set)resourceFilters.elem).isEmpty() && dieIfNoResourceFound) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must provide at least one resource: --topic <topic> or --cluster or --group <group> or --delegation-token <Delegation Token ID>");
        }
        return (Set)resourceFilters.elem;
    }

    private boolean getResourceFilter$default$2() {
        return true;
    }

    public boolean kafka$admin$AclCommand$$confirmAction(AclCommand.AclCommandOptions opts, String msg) {
        if (opts.options().has((OptionSpec)opts.forceOpt())) {
            return true;
        }
        Predef$.MODULE$.println((Object)msg);
        return StdIn$.MODULE$.readLine().equalsIgnoreCase("y");
    }

    private void validateOperation(AclCommand.AclCommandOptions opts, Map<ResourcePatternFilter, Set<Acl>> resourceToAcls) {
        resourceToAcls.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$9 -> BoxesRunTime.boxToBoolean((boolean)AclCommand$.$anonfun$validateOperation$1(check$ifrefutable$9))).foreach((Function1 & Serializable & scala.Serializable)x$31 -> {
            AclCommand$.$anonfun$validateOperation$2(opts, x$31);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceFilterToAcls$1(ResourcePatternFilter x$20) {
        ResourceType resourceType = x$20.resourceType();
        ResourceType resourceType2 = ResourceType.TOPIC;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getProducerResourceFilterToAcls$2(ResourcePatternFilter x$21) {
        ResourceType resourceType = x$21.resourceType();
        ResourceType resourceType2 = ResourceType.TRANSACTIONAL_ID;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceFilterToAcls$1(ResourcePatternFilter x$24) {
        ResourceType resourceType = x$24.resourceType();
        ResourceType resourceType2 = ResourceType.TOPIC;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConsumerResourceFilterToAcls$2(ResourcePatternFilter x$25) {
        ResourceType resourceType = x$25.resourceType();
        ResourceType resourceType2 = ResourceType.GROUP;
        return !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateOperation$1(Tuple2 check$ifrefutable$9) {
        Tuple2 tuple2 = check$ifrefutable$9;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$validateOperation$2(AclCommand.AclCommandOptions opts$2, Tuple2 x$31) {
        Tuple2 tuple2 = x$31;
        if (tuple2 != null) {
            ResourcePatternFilter resource = (ResourcePatternFilter)tuple2._1();
            Set acls = (Set)tuple2._2();
            Set validOps = (Set)MODULE$.ResourceTypeToValidOperations().apply((Object)resource.resourceType());
            if (((TraversableOnce)((Subtractable)acls.map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.operation(), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)validOps)).nonEmpty()) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts$2.parser(), new StringBuilder(39).append("ResourceType ").append(resource.resourceType()).append(" only supports operations ").append(validOps.mkString(",")).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private AclCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ClusterResourceFilter = new ResourcePatternFilter(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.kafka$admin$AclCommand$$Newline = Properties$.MODULE$.lineSeparator();
        this.ResourceTypeToValidOperations = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.TOPIC), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Describe$.MODULE$, Delete$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.GROUP), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$, Delete$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.CLUSTER), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Create$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$, Alter$.MODULE$, Describe$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.TRANSACTIONAL_ID), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$, Write$.MODULE$, All$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ResourceType.DELEGATION_TOKEN), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$, All$.MODULE$})))}));
    }
}

