/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.Constants$;
import kafka.server.QuotaType;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.SensorAccess;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001\u001d\u0011qCU3qY&\u001c\u0017\r^5p]F+x\u000e^1NC:\fw-\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u000f)A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011ABU3qY&\u001c\u0017-U;pi\u0006D\u0001\"\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\u0007G>tg-[4\u0016\u0003m\u0001\"!\u0006\u000f\n\u0005u\u0011!!\b*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\t\u0011}\u0001!\u0011!Q\u0001\nm\tqaY8oM&<\u0007\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0003#\u0003\u001diW\r\u001e:jGN,\u0012a\t\t\u0003I5j\u0011!\n\u0006\u0003C\u0019R!a\n\u0015\u0002\r\r|W.\\8o\u0015\t)\u0011F\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018&\u0005\u001diU\r\u001e:jGND\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IaI\u0001\t[\u0016$(/[2tA!A!\u0007\u0001BC\u0002\u0013%1'A\bsKBd\u0017nY1uS>tG+\u001f9f+\u0005!\u0004CA\u000b6\u0013\t1$AA\u0005Rk>$\u0018\rV=qK\"A\u0001\b\u0001B\u0001B\u0003%A'\u0001\tsKBd\u0017nY1uS>tG+\u001f9fA!A!\b\u0001BC\u0002\u0013%1(\u0001\u0003uS6,W#\u0001\u001f\u0011\u0005uzT\"\u0001 \u000b\u0005E1\u0013B\u0001!?\u0005\u0011!\u0016.\\3\t\u0011\t\u0003!\u0011!Q\u0001\nq\nQ\u0001^5nK\u0002BQ\u0001\u0012\u0001\u0005\u0002\u0015\u000ba\u0001P5oSRtD#\u0002$H\u0011&S\u0005CA\u000b\u0001\u0011\u0015I2\t1\u0001\u001c\u0011\u0015\t3\t1\u0001$\u0011\u0015\u00114\t1\u00015\u0011\u0015Q4\t1\u0001=\u0011\u001da\u0005A1A\u0005\n5\u000bA\u0001\\8dWV\ta\n\u0005\u0002P16\t\u0001K\u0003\u0002R%\u0006)An\\2lg*\u00111\u000bV\u0001\u000bG>t7-\u001e:sK:$(BA+W\u0003\u0011)H/\u001b7\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0015\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\"11\f\u0001Q\u0001\n9\u000bQ\u0001\\8dW\u0002Bq!\u0018\u0001C\u0002\u0013%a,A\nuQJ|G\u000f\u001e7fIB\u000b'\u000f^5uS>t7/F\u0001`!\u0011\u0001\u0017m\u00196\u000e\u0003IK!A\u0019*\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002eO:\u0011\u0011\"Z\u0005\u0003M*\ta\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011aM\u0003\t\u0004W:\u0004X\"\u00017\u000b\u00055T\u0011AC2pY2,7\r^5p]&\u0011q\u000e\u001c\u0002\u0004'\u0016\f\bCA\u0005r\u0013\t\u0011(BA\u0002J]RDa\u0001\u001e\u0001!\u0002\u0013y\u0016\u0001\u0006;ie>$H\u000f\\3e!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0004w\u0001\u0001\u0007I\u0011B<\u0002\u000bE,x\u000e^1\u0016\u0003a\u0004\"\u0001J=\n\u0005i,#!B)v_R\f\u0007b\u0002?\u0001\u0001\u0004%I!`\u0001\ncV|G/Y0%KF$2A`A\u0002!\tIq0C\u0002\u0002\u0002)\u0011A!\u00168ji\"A\u0011QA>\u0002\u0002\u0003\u0007\u00010A\u0002yIEBq!!\u0003\u0001A\u0003&\u00010\u0001\u0004rk>$\u0018\r\t\u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001f\tAb]3og>\u0014\u0018iY2fgN,\"!!\u0005\u0011\u0007U\t\u0019\"C\u0002\u0002\u0016\t\u0011AbU3og>\u0014\u0018iY2fgND\u0001\"!\u0007\u0001A\u0003%\u0011\u0011C\u0001\u000eg\u0016t7o\u001c:BG\u000e,7o\u001d\u0011\t\u0013\u0005u\u0001A1A\u0005\n\u0005}\u0011A\u0004:bi\u0016lU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0003C\u0001B!a\t\u0002&5\ta%C\u0002\u0002(\u0019\u0012!\"T3ue&\u001cg*Y7f\u0011!\tY\u0003\u0001Q\u0001\n\u0005\u0005\u0012a\u0004:bi\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u0005YQ\u000f\u001d3bi\u0016\fVo\u001c;b)\rq\u00181\u0007\u0005\u0007m\u00065\u0002\u0019\u0001=\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:\u0005y\u0011n])v_R\fW\t_2fK\u0012,G-\u0006\u0002\u0002<A\u0019\u0011\"!\u0010\n\u0007\u0005}\"BA\u0004C_>dW-\u00198\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F\u0005Y\u0011n\u001d+ie>$H\u000f\\3e)\u0011\tY$a\u0012\t\u0011\u0005%\u0013\u0011\ta\u0001\u0003\u0017\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002$\u00055\u0013bAA(M\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA*\u0001\u0011\u0005\u0011QK\u0001\u0007e\u0016\u001cwN\u001d3\u0015\u0007y\f9\u0006\u0003\u0005\u0002Z\u0005E\u0003\u0019AA.\u0003\u00151\u0018\r\\;f!\rI\u0011QL\u0005\u0004\u0003?R!\u0001\u0002'p]\u001eDq!a\u0019\u0001\t\u0003\t)'A\u0007nCJ\\G\u000b\u001b:piRdW\r\u001a\u000b\u0006}\u0006\u001d\u00141\u000e\u0005\b\u0003S\n\t\u00071\u0001d\u0003\u0015!x\u000e]5d\u0011\u001d\ti'!\u0019A\u0002)\f!\u0002]1si&$\u0018n\u001c8t\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003c\"2A`A:\u0011\u001d\tI'a\u001cA\u0002\rDq!a\u001e\u0001\t\u0003\tI(\u0001\bsK6|g/\u001a+ie>$H\u000f\\3\u0015\u0007y\fY\bC\u0004\u0002j\u0005U\u0004\u0019A2\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\u0006QQ\u000f\u001d9fe\n{WO\u001c3\u0015\u0005\u0005m\u0003bBAC\u0001\u0011%\u0011qQ\u0001\u0015O\u0016$\u0018+^8uC6+GO]5d\u0007>tg-[4\u0015\t\u0005%\u0015q\u0012\t\u0004I\u0005-\u0015bAAGK\taQ*\u001a;sS\u000e\u001cuN\u001c4jO\"1a/a!A\u0002aDq!a%\u0001\t\u0013\t)*\u0001\u0004tK:\u001cxN\u001d\u000b\u0003\u0003/\u00032\u0001JAM\u0013\r\tY*\n\u0002\u0007'\u0016t7o\u001c:")
public class ReplicationQuotaManager
implements Logging,
ReplicaQuota {
    private final ReplicationQuotaManagerConfig config;
    private final Metrics kafka$server$ReplicationQuotaManager$$metrics;
    private final QuotaType kafka$server$ReplicationQuotaManager$$replicationType;
    private final Time time;
    private final ReentrantReadWriteLock lock;
    private final ConcurrentHashMap<String, Seq<Object>> throttledPartitions;
    private Quota kafka$server$ReplicationQuotaManager$$quota;
    private final SensorAccess sensorAccess;
    private final MetricName kafka$server$ReplicationQuotaManager$$rateMetricName;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ReplicationQuotaManager replicationQuotaManager = this;
        synchronized (replicationQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ReplicationQuotaManagerConfig config() {
        return this.config;
    }

    public Metrics kafka$server$ReplicationQuotaManager$$metrics() {
        return this.kafka$server$ReplicationQuotaManager$$metrics;
    }

    public QuotaType kafka$server$ReplicationQuotaManager$$replicationType() {
        return this.kafka$server$ReplicationQuotaManager$$replicationType;
    }

    private Time time() {
        return this.time;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ConcurrentHashMap<String, Seq<Object>> throttledPartitions() {
        return this.throttledPartitions;
    }

    public Quota kafka$server$ReplicationQuotaManager$$quota() {
        return this.kafka$server$ReplicationQuotaManager$$quota;
    }

    public void kafka$server$ReplicationQuotaManager$$quota_$eq(Quota x$1) {
        this.kafka$server$ReplicationQuotaManager$$quota = x$1;
    }

    private SensorAccess sensorAccess() {
        return this.sensorAccess;
    }

    public MetricName kafka$server$ReplicationQuotaManager$$rateMetricName() {
        return this.kafka$server$ReplicationQuotaManager$$rateMetricName;
    }

    public void updateQuota(Quota quota) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), new Serializable(this, quota){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;
            private final Quota quota$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$ReplicationQuotaManager$$quota_$eq(this.quota$1);
                KafkaMetric metric = (KafkaMetric)this.$outer.kafka$server$ReplicationQuotaManager$$metrics().metrics().get(this.$outer.kafka$server$ReplicationQuotaManager$$rateMetricName());
                if (metric != null) {
                    metric.config(this.$outer.kafka$server$ReplicationQuotaManager$$getQuotaMetricConfig(this.quota$1));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.quota$1 = quota$1;
            }
        });
    }

    @Override
    public boolean isQuotaExceeded() {
        try {
            this.kafka$server$ReplicationQuotaManager$$sensor().checkQuotas();
            return false;
        }
        catch (QuotaViolationException quotaViolationException) {
            this.trace((Function0<String>)new Serializable(this, quotaViolationException){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicationQuotaManager $outer;
                private final QuotaViolationException qve$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("%s: Quota violated for sensor (%s), metric: (%s), metric-value: (%f), bound: (%f)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$ReplicationQuotaManager$$replicationType(), this.$outer.kafka$server$ReplicationQuotaManager$$sensor().name(), this.qve$1.metricName(), BoxesRunTime.boxToDouble((double)this.qve$1.value()), BoxesRunTime.boxToDouble((double)this.qve$1.bound())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.qve$1 = qve$1;
                }
            });
            return true;
        }
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        Seq<Object> partitions = this.throttledPartitions().get(topicPartition.topic());
        return partitions == null ? false : partitions == Constants$.MODULE$.AllReplicas() || partitions.contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
    }

    @Override
    public void record(long value2) {
        try {
            this.kafka$server$ReplicationQuotaManager$$sensor().record((double)value2);
        }
        catch (QuotaViolationException quotaViolationException) {
            this.trace((Function0<String>)new Serializable(this, value2, quotaViolationException){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicationQuotaManager $outer;
                private final long value$1;
                private final QuotaViolationException qve$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Record: Quota violated, but ignored, for sensor (", "), metric: (", "), value : (", "), bound: (", "), recordedValue (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$ReplicationQuotaManager$$sensor().name(), this.qve$2.metricName(), BoxesRunTime.boxToDouble((double)this.qve$2.value()), BoxesRunTime.boxToDouble((double)this.qve$2.bound()), BoxesRunTime.boxToLong((long)this.value$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.value$1 = value$1;
                    this.qve$2 = qve$2;
                }
            });
        }
    }

    public void markThrottled(String topic, Seq<Object> partitions) {
        this.throttledPartitions().put(topic, partitions);
    }

    public void markThrottled(String topic) {
        this.markThrottled(topic, Constants$.MODULE$.AllReplicas());
    }

    public void removeThrottle(String topic) {
        this.throttledPartitions().remove(topic);
    }

    public long upperBound() {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.kafka$server$ReplicationQuotaManager$$quota() == null ? Long.MAX_VALUE : (long)this.$outer.kafka$server$ReplicationQuotaManager$$quota().bound();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public MetricConfig kafka$server$ReplicationQuotaManager$$getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    public Sensor kafka$server$ReplicationQuotaManager$$sensor() {
        return this.sensorAccess().getOrCreate(this.kafka$server$ReplicationQuotaManager$$replicationType().toString(), ReplicationQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function0<MetricName>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;

            public final MetricName apply() {
                return this.$outer.kafka$server$ReplicationQuotaManager$$rateMetricName();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<Option<MetricConfig>>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;

            public final Some<MetricConfig> apply() {
                return new Some((Object)this.$outer.kafka$server$ReplicationQuotaManager$$getQuotaMetricConfig(this.$outer.kafka$server$ReplicationQuotaManager$$quota()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleRate apply() {
                return new SimpleRate();
            }
        });
    }

    public ReplicationQuotaManager(ReplicationQuotaManagerConfig config, Metrics metrics, QuotaType replicationType, Time time) {
        this.config = config;
        this.kafka$server$ReplicationQuotaManager$$metrics = metrics;
        this.kafka$server$ReplicationQuotaManager$$replicationType = replicationType;
        this.time = time;
        Logging$class.$init$(this);
        this.lock = new ReentrantReadWriteLock();
        this.throttledPartitions = new ConcurrentHashMap();
        this.kafka$server$ReplicationQuotaManager$$quota = null;
        this.sensorAccess = new SensorAccess(this.lock(), metrics);
        this.kafka$server$ReplicationQuotaManager$$rateMetricName = metrics.metricName("byte-rate", replicationType.toString(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tracking byte-rate for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicationType})));
    }
}

