/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u000f\t12k\u0019:b[N+'O^3s'R\f'\u000f^;q)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t1!\u00199j\u0013\ti!B\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\tIq\"\u0003\u0002\u0011\u0015\tI1+Y:m'\u0016$X\u000f\u001d\u0005\u0006%\u0001!\taE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\u0001\"!\u0006\u0001\u000e\u0003\tAqa\u0006\u0001C\u0002\u0013\u0005\u0003$A\u0007qe>$WoY3s\u0007>,h\u000e^\u000b\u00023A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t\u0019\u0011J\u001c;\t\r\u0001\u0002\u0001\u0015!\u0003\u001a\u00039\u0001(o\u001c3vG\u0016\u00148i\\;oi\u0002BqA\t\u0001C\u0002\u0013\u0005\u0003$A\u0007d_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0005\u0007I\u0001\u0001\u000b\u0011B\r\u0002\u001d\r|gn];nKJ\u001cu.\u001e8uA!9a\u0005\u0001b\u0001\n\u0003B\u0012aC:feZ,'oQ8v]RDa\u0001\u000b\u0001!\u0002\u0013I\u0012\u0001D:feZ,'oQ8v]R\u0004\u0003b\u0002\u0016\u0001\u0005\u0004%IaK\u0001\u0019W\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNlW#\u0001\u0017\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001\u00027b]\u001eT\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024]\t11\u000b\u001e:j]\u001eDa!\u000e\u0001!\u0002\u0013a\u0013!G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[\u0002Bqa\u000e\u0001C\u0002\u0013%\u0001(A\rlC\u001a\\\u0017mU3sm\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u001cX#A\u001d\u0011\u0007izD&D\u0001<\u0015\taT(A\u0004nkR\f'\r\\3\u000b\u0005yZ\u0012AC2pY2,7\r^5p]&\u0011\u0001i\u000f\u0002\u0007\u0005V4g-\u001a:\t\r\t\u0003\u0001\u0015!\u0003:\u0003iY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:!\u0011\u0015!\u0005\u0001\"\u0015F\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001G!\t95+D\u0001I\u0015\tI%*\u0001\u0003bkRD'BA&M\u0003!\u0019XmY;sSRL(BA'O\u0003\u0019\u0019w.\\7p]*\u0011Qa\u0014\u0006\u0003!F\u000ba!\u00199bG\",'\"\u0001*\u0002\u0007=\u0014x-\u0003\u0002U\u0011\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\b-\u0002\u0011\r\u0011\"\u0015X\u0003Q\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fgV\t\u0001\fE\u0002\u001b3nK!AW\u000e\u0003\tM{W.\u001a\t\u00039~k\u0011!\u0018\u0006\u0003=B\nA!\u001e;jY&\u0011\u0001-\u0018\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u00022\u0001A\u0003%\u0001,A\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm\u001d\u0011\t\u000f\u0011\u0004!\u0019!C)/\u0006!2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKNDaA\u001a\u0001!\u0002\u0013A\u0016!F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7\u000f\t\u0005\u0006Q\u0002!\t%[\u0001$G>tg-[4ve\u0016\u001cVmY;sSRL()\u001a4pe\u0016\u001cVM\u001d<feN\u001cF/\u0019:u)\u0005Q\u0007C\u0001\u000el\u0013\ta7D\u0001\u0003V]&$\b\"\u00028\u0001\t\u0003I\u0017a\u0005;fgR\fU\u000f\u001e5f]RL7-\u0019;j_:\u001c\bFA7q!\t\tH/D\u0001s\u0015\t\u0019\u0018+A\u0003kk:LG/\u0003\u0002ve\n!A+Z:u\u0001")
public class ScramServerStartupTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String kafkaClientSaslMechanism;
    private final Buffer<String> kafkaServerSaslMechanisms;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup$class.startSasl(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup$class.initializeKerberos(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup$class.maybeCreateEmptyKeytabFiles(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup$class.jaasSections(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup$class.kafkaServerSaslProperties(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup$class.kafkaClientSaslProperties(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup$class.jaasClientLoginModule(this, clientSaslMechanism);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup$class.createScramCredentials(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup$class.kafkaClientSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup$class.jaasSections$default$3(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup$class.jaasSections$default$4(this);
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private Buffer<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.jaasSections$default$4()));
    }

    @Test
    public void testAuthentications() {
        long successfulAuths = TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "successful-authentication-total");
        Assert.assertTrue((String)"No successful authentications", (successfulAuths > 0L ? 1 : 0) != 0);
        long failedAuths = TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "failed-authentication-total");
        Assert.assertEquals((long)0L, (long)failedAuths);
    }

    public ScramServerStartupTest() {
        SaslSetup$class.$init$(this);
        this.producerCount = 0;
        this.consumerCount = 0;
        this.serverCount = 1;
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.kafkaServerSaslMechanisms = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.singletonList("SCRAM-SHA-256")).asScala();
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

