/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import kafka.utils.json.JsonValue;
import kafka.utils.json.JsonValue$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

public final class Json$ {
    public static final Json$ MODULE$;
    private final ObjectMapper mapper;

    static {
        new Json$();
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public Option<JsonValue> parseFull(String input) {
        Option option;
        try {
            option = Option$.MODULE$.apply((Object)this.mapper().readTree(input)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonValue apply(JsonNode x$1) {
                    return JsonValue$.MODULE$.apply(x$1);
                }
            });
        }
        catch (JsonProcessingException jsonProcessingException) {
            String escapedInput = input.replaceAll("\\\\", "\\\\\\\\");
            try {
                option = Option$.MODULE$.apply((Object)this.mapper().readTree(escapedInput)).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final JsonValue apply(JsonNode x$2) {
                        return JsonValue$.MODULE$.apply(x$2);
                    }
                });
            }
            catch (JsonProcessingException jsonProcessingException2) {
                option = None$.MODULE$;
            }
        }
        return option;
    }

    public <T> Either<JsonProcessingException, T> parseStringAs(String input, ClassTag<T> tag) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply(this.mapper().readValue(input, tag.runtimeClass()));
        }
        catch (JsonProcessingException jsonProcessingException) {
            left = package$.MODULE$.Left().apply((Object)jsonProcessingException);
        }
        return left;
    }

    public Option<JsonValue> parseBytes(byte[] input) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)this.mapper().readTree(input)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonValue apply(JsonNode x$3) {
                    return JsonValue$.MODULE$.apply(x$3);
                }
            });
        }
        catch (JsonProcessingException jsonProcessingException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Either<JsonProcessingException, JsonValue> tryParseBytes(byte[] input) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)this.mapper().readTree(input)).right().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonValue apply(JsonNode x$4) {
                    return JsonValue$.MODULE$.apply(x$4);
                }
            });
        }
        catch (JsonProcessingException jsonProcessingException) {
            left = package$.MODULE$.Left().apply((Object)jsonProcessingException);
        }
        return left;
    }

    public <T> Either<JsonProcessingException, T> parseBytesAs(byte[] input, ClassTag<T> tag) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply(this.mapper().readValue(input, tag.runtimeClass()));
        }
        catch (JsonProcessingException jsonProcessingException) {
            left = package$.MODULE$.Left().apply((Object)jsonProcessingException);
        }
        return left;
    }

    public String legacyEncodeAsString(Object obj) {
        Object object;
        block12: {
            String string;
            block11: {
                while (true) {
                    if ((object = obj) == null) {
                        string = "null";
                        break block11;
                    }
                    if (object instanceof Boolean) {
                        boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                        string = ((Object)BoxesRunTime.boxToBoolean((boolean)bl)).toString();
                        break block11;
                    }
                    if (object instanceof String) {
                        String string2 = (String)object;
                        string = this.mapper().writeValueAsString((Object)string2);
                        break block11;
                    }
                    if (object instanceof Number) {
                        Number number = (Number)object;
                        string = number.toString();
                        break block11;
                    }
                    if (object instanceof Map) {
                        Map map = (Map)object;
                        string = new StringBuilder().append((Object)"{").append((Object)((TraversableOnce)map.map((Function1)new Serializable(obj){
                            public static final long serialVersionUID = 0L;
                            private final Object obj$1;

                            public final String apply(Tuple2<Object, Object> x0$1) {
                                Tuple2<Object, Object> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    Object k = tuple2._1();
                                    Object v = tuple2._2();
                                    String string = new StringBuilder().append((Object)Json$.MODULE$.legacyEncodeAsString(k)).append((Object)":").append((Object)Json$.MODULE$.legacyEncodeAsString(v)).toString();
                                    return string;
                                }
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid map element '", "' in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2, this.obj$1})));
                            }
                            {
                                this.obj$1 = obj$1;
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).mkString(",")).append((Object)"}").toString();
                        break block11;
                    }
                    if (!ScalaRunTime$.MODULE$.isArray(object, 1)) break;
                    Object object2 = object;
                    obj = Predef$.MODULE$.genericArrayOps(object2).toSeq();
                }
                if (!(object instanceof Iterable)) break block12;
                Iterable iterable = (Iterable)object;
                string = new StringBuilder().append((Object)"[").append((Object)((TraversableOnce)iterable.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object obj) {
                        return Json$.MODULE$.legacyEncodeAsString(obj);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString(",")).append((Object)"]").toString();
            }
            return string;
        }
        if (object instanceof Object) {
            Object object3 = object;
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown argument of type ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object3.getClass(), object3})));
        }
        throw new MatchError(object);
    }

    public String encodeAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    public byte[] encodeAsBytes(Object obj) {
        return this.mapper().writeValueAsBytes(obj);
    }

    private Json$() {
        MODULE$ = this;
        this.mapper = new ObjectMapper();
    }
}

