/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Replica;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002T8h%\u0016\u001cwN^3ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0003)\u0012a\u0005:fa2L7-\u0019'bORKW.Z'bq6\u001bX#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\t1{gn\u001a\u0005\u0007;\u0001\u0001\u000b\u0011\u0002\f\u0002)I,\u0007\u000f\\5dC2\u000bw\rV5nK6\u000b\u00070T:!\u0011\u001dy\u0002A1A\u0005\u0002U\tQC]3qY&\u001c\u0017\rT1h\u001b\u0006DX*Z:tC\u001e,7\u000f\u0003\u0004\"\u0001\u0001\u0006IAF\u0001\u0017e\u0016\u0004H.[2b\u0019\u0006<W*\u0019=NKN\u001c\u0018mZ3tA!91\u0005\u0001b\u0001\n\u0003!\u0013!\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj]\u000b\u0002KA\u0011qCJ\u0005\u0003Oa\u00111!\u00138u\u0011\u0019I\u0003\u0001)A\u0005K\u00051\"/\u001a9mS\u000e\fg)\u001a;dQ^\u000b\u0017\u000e^'bq6\u001b\b\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0013\u0002)I,\u0007\u000f\\5dC\u001a+Go\u00195NS:\u0014\u0015\u0010^3t\u0011\u0019i\u0003\u0001)A\u0005K\u0005)\"/\u001a9mS\u000e\fg)\u001a;dQ6KgNQ=uKN\u0004\u0003bB\u0018\u0001\u0005\u0004%\t\u0001M\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005!Q\u000f^5m\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004;\u0001\u0001\u0006I!M\u0001\u0011_Z,'O]5eS:<\u0007K]8qg\u0002Bq\u0001\u0010\u0001A\u0002\u0013\u0005Q(A\u0004d_:4\u0017nZ:\u0016\u0003y\u00022aP$K\u001d\t\u0001UI\u0004\u0002B\t6\t!I\u0003\u0002D\r\u00051AH]8pizJ\u0011!G\u0005\u0003\rb\tq\u0001]1dW\u0006<W-\u0003\u0002I\u0013\n\u00191+Z9\u000b\u0005\u0019C\u0002C\u0001\nL\u0013\ta%AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007b\u0002(\u0001\u0001\u0004%\taT\u0001\fG>tg-[4t?\u0012*\u0017\u000f\u0006\u0002Q'B\u0011q#U\u0005\u0003%b\u0011A!\u00168ji\"9A+TA\u0001\u0002\u0004q\u0014a\u0001=%c!1a\u000b\u0001Q!\ny\n\u0001bY8oM&<7\u000f\t\u0005\b1\u0002\u0011\r\u0011\"\u0001Z\u0003\u0015!x\u000e]5d+\u0005Q\u0006CA._\u001b\u0005a&BA/6\u0003\u0011a\u0017M\\4\n\u0005}c&AB*ue&tw\r\u0003\u0004b\u0001\u0001\u0006IAW\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f\r\u0004!\u0019!C\u0001I\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u0019)\u0007\u0001)A\u0005K\u0005a\u0001/\u0019:uSRLwN\\%eA!9q\r\u0001b\u0001\n\u0003A\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002SB\u0011!N]\u0007\u0002W*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a]6\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1Q\u000f\u0001Q\u0001\n%\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\bo\u0002\u0001\r\u0011\"\u0001y\u0003\u001d\u0019XM\u001d<feF*\u0012!\u001f\t\u0003%iL!a\u001f\u0002\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\b{\u0002\u0001\r\u0011\"\u0001\u007f\u0003-\u0019XM\u001d<feFzF%Z9\u0015\u0005A{\bb\u0002+}\u0003\u0003\u0005\r!\u001f\u0005\b\u0003\u0007\u0001\u0001\u0015)\u0003z\u0003!\u0019XM\u001d<feF\u0002\u0003\u0002CA\u0004\u0001\u0001\u0007I\u0011\u0001=\u0002\u000fM,'O^3se!I\u00111\u0002\u0001A\u0002\u0013\u0005\u0011QB\u0001\fg\u0016\u0014h/\u001a:3?\u0012*\u0017\u000fF\u0002Q\u0003\u001fA\u0001\u0002VA\u0005\u0003\u0003\u0005\r!\u001f\u0005\b\u0003'\u0001\u0001\u0015)\u0003z\u0003!\u0019XM\u001d<feJ\u0002\u0003bBA\f\u0001\u0011\u0005\u0011\u0011D\u0001\rG>tg-[4Qe>\u00048/M\u000b\u0002\u0015\"9\u0011Q\u0004\u0001\u0005\u0002\u0005e\u0011\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0004\u0002CA\u0011\u0001\t\u0007I\u0011A-\u0002\u000f5,7o]1hK\"9\u0011Q\u0005\u0001!\u0002\u0013Q\u0016\u0001C7fgN\fw-\u001a\u0011\t\u0013\u0005%\u0002\u00011A\u0005\u0002\u0005-\u0012\u0001\u00039s_\u0012,8-\u001a:\u0016\u0005\u00055\u0002\u0003CA\u0018\u0003o\tY$!\u0011\u000e\u0005\u0005E\"\u0002BA\u0015\u0003gQ1!!\u000en\u0003\u001d\u0019G.[3oiNLA!!\u000f\u00022\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u00042aWA\u001f\u0013\r\ty\u0004\u0018\u0002\b\u0013:$XmZ3s!\u0011\t\u0019%!\u0013\u000f\u0007]\t)%C\u0002\u0002Ha\ta\u0001\u0015:fI\u00164\u0017bA0\u0002L)\u0019\u0011q\t\r\t\u0013\u0005=\u0003\u00011A\u0005\u0002\u0005E\u0013\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fHc\u0001)\u0002T!IA+!\u0014\u0002\u0002\u0003\u0007\u0011Q\u0006\u0005\t\u0003/\u0002\u0001\u0015)\u0003\u0002.\u0005I\u0001O]8ek\u000e,'\u000f\t\u0005\b\u00037\u0002A\u0011AA/\u0003\u001dAwOR5mKF*\"!a\u0018\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001a\u0003\u0003-\u0019\u0007.Z2la>Lg\u000e^:\n\t\u0005%\u00141\r\u0002\u0015\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\t\u000f\u00055\u0004\u0001\"\u0001\u0002^\u00059\u0001n\u001e$jY\u0016\u0014\u0004\"CA9\u0001\u0001\u0007I\u0011AA:\u0003\u001d\u0019XM\u001d<feN,\"!!\u001e\u0011\u000b\u0005]\u0014QP=\u000e\u0005\u0005e$bAA>1\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007!\u000bI\bC\u0005\u0002\u0002\u0002\u0001\r\u0011\"\u0001\u0002\u0004\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\r\u0001\u0016Q\u0011\u0005\n)\u0006}\u0014\u0011!a\u0001\u0003kB\u0001\"!#\u0001A\u0003&\u0011QO\u0001\tg\u0016\u0014h/\u001a:tA!9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0015AD;qI\u0006$X\r\u0015:pIV\u001cWM\u001d\u000b\u0002!\"9\u00111\u0013\u0001\u0005B\u0005=\u0015!B:fiV\u0003\b\u0006BAI\u0003/\u0003B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;\u0003\u0018!\u00026v]&$\u0018\u0002BAQ\u00037\u0013aAQ3g_J,\u0007bBAS\u0001\u0011\u0005\u0013qR\u0001\ti\u0016\f'\u000fR8x]\"\"\u00111UAU!\u0011\tI*a+\n\t\u00055\u00161\u0014\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003c\u0003A\u0011AAH\u0003)\"Xm\u001d;I/\u000eCWmY6q_&tGOT8GC&dWO]3t'&tw\r\\3M_\u001e\u001cVmZ7f]RDC!a,\u00026B!\u0011\u0011TA\\\u0013\u0011\tI,a'\u0003\tQ+7\u000f\u001e\u0005\b\u0003{\u0003A\u0011AAH\u00031\"Xm\u001d;I/\u000eCWmY6q_&tGoV5uQ\u001a\u000b\u0017\u000e\\;sKN\u001c\u0016N\\4mK2{wmU3h[\u0016tG\u000f\u000b\u0003\u0002<\u0006U\u0006bBAb\u0001\u0011\u0005\u0011qR\u0001.i\u0016\u001cH\u000fS,DQ\u0016\u001c7\u000e]8j]RtuNR1jYV\u0014Xm]'vYRL\u0007\u000f\\3M_\u001e\u001cVmZ7f]R\u001c\b\u0006BAa\u0003kCq!!3\u0001\t\u0003\ty)A\u0018uKN$\bjV\"iK\u000e\\\u0007o\\5oi^KG\u000f\u001b$bS2,(/Z:Nk2$\u0018\u000e\u001d7f\u0019><7+Z4nK:$8\u000f\u000b\u0003\u0002H\u0006U\u0006bBAh\u0001\u0011%\u0011\u0011[\u0001\rg\u0016tG-T3tg\u0006<Wm\u001d\u000b\u0004!\u0006M\u0007bBAk\u0003\u001b\u0004\r!J\u0001\u0002]\u0002")
public class LogRecoveryTest
extends ZooKeeperTestHarness {
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final Properties overridingProps = new Properties();
    private Seq<KafkaConfig> configs;
    private final String topic;
    private final int partitionId;
    private final TopicPartition topicPartition;
    private KafkaServer server1;
    private KafkaServer server2;
    private final String message;
    private KafkaProducer<Integer, String> producer;
    private Seq<KafkaServer> servers;

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public KafkaServer server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public KafkaServer server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    public KafkaConfig configProps1() {
        return (KafkaConfig)this.configs().head();
    }

    public KafkaConfig configProps2() {
        return (KafkaConfig)this.configs().last();
    }

    public String message() {
        return this.message;
    }

    public KafkaProducer<Integer, String> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<Integer, String> x$1) {
        this.producer = x$1;
    }

    public OffsetCheckpointFile hwFile1() {
        return new OffsetCheckpointFile(new File((String)this.configProps1().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
    }

    public OffsetCheckpointFile hwFile2() {
        return new OffsetCheckpointFile(new File((String)this.configProps2().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public void updateProducer() {
        if (this.producer() != null) {
            this.producer().close();
        }
        String x$8 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$9 = 5;
        IntegerSerializer x$10 = new IntegerSerializer();
        StringSerializer x$11 = new StringSerializer();
        int x$12 = TestUtils$.MODULE$.createProducer$default$2();
        long x$13 = TestUtils$.MODULE$.createProducer$default$3();
        long x$14 = TestUtils$.MODULE$.createProducer$default$4();
        long x$15 = TestUtils$.MODULE$.createProducer$default$6();
        long x$16 = TestUtils$.MODULE$.createProducer$default$7();
        SecurityProtocol x$17 = TestUtils$.MODULE$.createProducer$default$8();
        Option<File> x$18 = TestUtils$.MODULE$.createProducer$default$9();
        Option<Properties> x$19 = TestUtils$.MODULE$.createProducer$default$10();
        Option<Properties> x$20 = TestUtils$.MODULE$.createProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$8, x$12, x$13, x$14, x$9, x$15, x$16, x$17, x$18, x$19, x$10, x$11, x$20));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configs_$eq((Seq<KafkaConfig>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.server1_$eq(TestUtils$.MODULE$.createServer(this.configProps1(), TestUtils$.MODULE$.createServer$default$2()));
        this.server2_$eq(TestUtils$.MODULE$.createServer(this.configProps2(), TestUtils$.MODULE$.createServer$default$2()));
        this.servers_$eq((Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()})));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        this.updateProducer();
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testHWCheckpointNoFailuresSingleLogSegment() {
        long numMessages = 2L;
        this.sendMessages((int)numMessages);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long numMessages$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)this.$outer.server2().replicaManager().getReplica(this.$outer.topicPartition()).get()).highWatermark().messageOffset() == this.numMessages$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numMessages$1 = numMessages$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$2) {
                x$2.replicaManager().checkpointHighWatermarks();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)numMessages, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)numMessages, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresSingleLogSegment() {
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.sendMessages(1);
        Thread.sleep(1000L);
        LongRef hw = LongRef.create((long)1L);
        this.server1().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        KafkaZkClient x$21 = this.zkClient();
        String x$22 = this.topic();
        int x$23 = this.partitionId();
        Some x$24 = new Some((Object)BoxesRunTime.boxToInteger((int)leader2));
        long x$25 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$26 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$21, x$22, x$23, x$25, (Option<Object>)x$24, x$26);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)leader2);
        this.server1().startup();
        this.updateProducer();
        leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader must remain on broker 1, in case of ZooKeeper session expiration it can move to broker 0", (leader2 == 0 || leader2 == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$27 = this.zkClient();
        String x$28 = this.topic();
        int x$29 = this.partitionId();
        Some x$30 = new Some((Object)BoxesRunTime.boxToInteger((int)leader2));
        long x$31 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$32 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$27, x$28, x$29, x$31, (Option<Object>)x$30, x$32);
        Assert.assertTrue((String)"Leader must remain on broker 0, in case of ZooKeeper session expiration it can move to broker 1", (leader2 == 0 || leader2 == 1 ? 1 : 0) != 0);
        this.sendMessages(1);
        ++hw.elem;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)this.$outer.server2().replicaManager().getReplica(this.$outer.topicPartition()).get()).highWatermark().messageOffset() == this.hw$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$1 = hw$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$3) {
                x$3.shutdown();
            }
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
    }

    @Test
    public void testHWCheckpointNoFailuresMultipleLogSegments() {
        this.sendMessages(20);
        long hw = 20L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long hw$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)this.$outer.server2().replicaManager().getReplica(this.$outer.topicPartition()).get()).highWatermark().messageOffset() == this.hw$2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$2 = hw$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$4) {
                x$4.shutdown();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)hw, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)hw, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresMultipleLogSegments() {
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.sendMessages(2);
        LongRef hw = LongRef.create((long)2L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)this.$outer.server2().replicaManager().getReplica(this.$outer.topicPartition()).get()).highWatermark().messageOffset() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.server1().shutdown();
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$33 = this.zkClient();
        String x$34 = this.topic();
        int x$35 = this.partitionId();
        Some x$36 = new Some((Object)BoxesRunTime.boxToInteger((int)leader2));
        long x$37 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$38 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$33, x$34, x$35, x$37, (Option<Object>)x$36, x$38);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)leader2);
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server1().startup();
        this.updateProducer();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.sendMessages(2);
        hw.elem += 2L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server1().replicaManager().getReplica(this.$outer.topicPartition()).nonEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to create replica in follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)this.$outer.server1().replicaManager().getReplica(this.$outer.topicPartition()).get()).highWatermark().messageOffset() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$5) {
                x$5.shutdown();
            }
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
    }

    private void sendMessages(int n) {
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final Future<RecordMetadata> apply(int x$6) {
                return this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)this.$outer.message()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$7) {
                return x$7.get();
            }
        });
    }

    public LogRecoveryTest() {
        this.replicaLagTimeMaxMs = 5000L;
        this.replicaLagMaxMessages = 10L;
        this.replicaFetchWaitMaxMs = 1000;
        this.replicaFetchMinBytes = 20;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMinBytes())).toString());
        this.configs = null;
        this.topic = "new-topic";
        this.partitionId = 0;
        this.topicPartition = new TopicPartition(this.topic(), this.partitionId());
        this.server1 = null;
        this.server2 = null;
        this.message = "hello";
        this.producer = null;
        this.servers = (Seq)Seq$.MODULE$.empty();
    }
}

