/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.server.AbstractFetcherThread;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogDirFailureTest$Checkpoint$;
import kafka.server.LogDirFailureTest$Roll$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!A\u0002ba&L!!\u0004\u0006\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005i\u0001O]8ek\u000e,'oQ8v]R,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0004\u0013:$\bBB\u000f\u0001A\u0003%a#\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\t\u000f}\u0001!\u0019!C\u0001+\u0005i1m\u001c8tk6,'oQ8v]RDa!\t\u0001!\u0002\u00131\u0012AD2p]N,X.\u001a:D_VtG\u000f\t\u0005\bG\u0001\u0011\r\u0011\"\u0001\u0016\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\t\r\u0015\u0002\u0001\u0015!\u0003\u0017\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0011\u001d9\u0003A1A\u0005\n!\nQ\u0001^8qS\u000e,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\"1!\u0007\u0001Q\u0001\n%\na\u0001^8qS\u000e\u0004\u0003b\u0002\u001b\u0001\u0005\u0004%I!F\u0001\ra\u0006\u0014H/\u001b;j_:tU/\u001c\u0005\u0007m\u0001\u0001\u000b\u0011\u0002\f\u0002\u001bA\f'\u000f^5uS>tg*^7!\u0011\u0015A\u0004\u0001\"\u0011:\u0003\u0015\u0019X\r^+q)\u0005Q\u0004CA\f<\u0013\ta\u0004D\u0001\u0003V]&$\bFA\u001c?!\tyD)D\u0001A\u0015\t\t%)A\u0003kk:LGOC\u0001D\u0003\ry'oZ\u0005\u0003\u000b\u0002\u0013aAQ3g_J,\u0007\"B$\u0001\t\u0003I\u0014\u0001\b;fgRLu*\u0012=dKB$\u0018n\u001c8EkJLgn\u001a'pOJ{G\u000e\u001c\u0015\u0003\r&\u0003\"a\u0010&\n\u0005-\u0003%\u0001\u0002+fgRDQ!\u0014\u0001\u0005\u0002e\n\u0011H\u0019:pW\u0016\u0014x+\u001b;i\u001f2$\u0017J\u001c;fe\n\u0013xn[3s!J|Go\\2pYNCw.\u001e7e\u0011\u0006dGo\u00148M_\u001e$\u0015N\u001d$bS2,(/\u001a\u0015\u0003\u0019&CQ\u0001\u0015\u0001\u0005\u0002e\nq\u0004^3ti&{U\t_2faRLwN\u001c#ve&twm\u00115fG.\u0004x.\u001b8uQ\ty\u0015\nC\u0003T\u0001\u0011\u0005\u0011(\u0001\u001buKN$(+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fe\r^3s\u0019><G)\u001b:GC&dWO]3P]\u001a{G\u000e\\8xKJD#AU%\t\u000bY\u0003A\u0011A,\u0002KQ,7\u000f\u001e)s_\u0012,8-Z!gi\u0016\u0014Hj\\4ESJ4\u0015-\u001b7ve\u0016|e\u000eT3bI\u0016\u0014HC\u0001\u001eY\u0011\u0015IV\u000b1\u0001[\u0003-1\u0017-\u001b7ve\u0016$\u0016\u0010]3\u0011\u0005m\u0003hB\u0001/d\u001d\ti&M\u0004\u0002_C6\tqL\u0003\u0002a\r\u00051AH]8pizJ\u0011!B\u0005\u0003\u0007\u00119Q\u0001\u001a\u0002\t\u0002\u0015\f\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+Z:u!\t\u0011bMB\u0003\u0002\u0005!\u0005qmE\u0002gQ.\u0004\"aF5\n\u0005)D\"AB!osJ+g\r\u0005\u0002\u0018Y&\u0011Q\u000e\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006\u001f\u0019$\ta\u001c\u000b\u0002K\u001a9\u0011O\u001aI\u0001$C\u0011(!\u0005'pO\u0012K'OR1jYV\u0014X\rV=qKN\u0011\u0001\u000f[\u0015\u0005aR\fyEB\u0003vM\"\u0005eO\u0001\u0006DQ\u0016\u001c7\u000e]8j]R\u001cR\u0001\u001e5xs.\u0004\"\u0001\u001f9\u000e\u0003\u0019\u0004\"a\u0006>\n\u0005mD\"a\u0002)s_\u0012,8\r\u001e\u0005\u0006\u001fQ$\t! \u000b\u0002}B\u0011\u0001\u0010\u001e\u0005\t\u0003\u0003!\u0018\u0011!C!Q\u0005i\u0001O]8ek\u000e$\bK]3gSbD\u0001\"!\u0002u\u0003\u0003%\t!F\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0003\u0013!\u0018\u0011!C\u0001\u0003\u0017\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u000e\u0005M\u0001cA\f\u0002\u0010%\u0019\u0011\u0011\u0003\r\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0016\u0005\u001d\u0011\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005eA/!A\u0005B\u0005m\u0011a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0001CBA\u0010\u0003K\ti!\u0004\u0002\u0002\")\u0019\u00111\u0005\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002(\u0005\u0005\"\u0001C%uKJ\fGo\u001c:\t\u0013\u0005-B/!A\u0005\u0002\u00055\u0012\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\u0012Q\u0007\t\u0004/\u0005E\u0012bAA\u001a1\t9!i\\8mK\u0006t\u0007BCA\u000b\u0003S\t\t\u00111\u0001\u0002\u000e!I\u0011\u0011\b;\u0002\u0002\u0013\u0005\u00131H\u0001\tQ\u0006\u001c\bnQ8eKR\ta\u0003C\u0005\u0002@Q\f\t\u0011\"\u0011\u0002B\u0005AAo\\*ue&tw\rF\u0001*\u0011%\t)\u0005^A\u0001\n\u0013\t9%A\u0006sK\u0006$'+Z:pYZ,GCAA%!\rQ\u00131J\u0005\u0004\u0003\u001bZ#AB(cU\u0016\u001cGOB\u0004\u0002R\u0019D\t)a\u0015\u0003\tI{G\u000e\\\n\u0007\u0003\u001fBw/_6\t\u000f=\ty\u0005\"\u0001\u0002XQ\u0011\u0011\u0011\f\t\u0004q\u0006=\u0003\"CA\u0001\u0003\u001f\n\t\u0011\"\u0011)\u0011%\t)!a\u0014\u0002\u0002\u0013\u0005Q\u0003\u0003\u0006\u0002\n\u0005=\u0013\u0011!C\u0001\u0003C\"B!!\u0004\u0002d!I\u0011QCA0\u0003\u0003\u0005\rA\u0006\u0005\u000b\u00033\ty%!A\u0005B\u0005m\u0001BCA\u0016\u0003\u001f\n\t\u0011\"\u0001\u0002jQ!\u0011qFA6\u0011)\t)\"a\u001a\u0002\u0002\u0003\u0007\u0011Q\u0002\u0005\u000b\u0003s\ty%!A\u0005B\u0005m\u0002BCA \u0003\u001f\n\t\u0011\"\u0011\u0002B!Q\u0011QIA(\u0003\u0003%I!a\u0012\b\u000f\u0005Ud\r#!\u0002Z\u0005!!k\u001c7m\u000f\u0019\tIH\u001aEA}\u0006Q1\t[3dWB|\u0017N\u001c;\t\u0013\u0005\u0015c-!A\u0005\n\u0005\u001d\u0003bBA@\u0001\u0011%\u0011\u0011Q\u0001\u001egV\u00147o\u0019:jE\u0016\fe\u000eZ,bSR4uN]!tg&<g.\\3oiR)!(a!\u0002\u0012\"9q%! A\u0002\u0005\u0015\u0005\u0003BAD\u0003\u001bs1aFAE\u0013\r\tY\tG\u0001\u0007!J,G-\u001a4\n\u0007A\nyIC\u0002\u0002\fbA\u0001\"a%\u0002~\u0001\u0007\u0011QS\u0001\tG>t7/^7feBA\u0011qSAS\u0003S\u000bI+\u0004\u0002\u0002\u001a*!\u00111SAN\u0015\u0011\ti*a(\u0002\u000f\rd\u0017.\u001a8ug*\u0019Q!!)\u000b\u0007\u0005\r&)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003O\u000bIJA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0006/\u0005-\u0016qV\u0005\u0004\u0003[C\"!B!se\u0006L\bcA\f\u00022&\u0019\u00111\u0017\r\u0003\t\tKH/\u001a")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String kafka$server$LogDirFailureTest$$topic;
    private final int partitionNum;

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String kafka$server$LogDirFailureTest$$topic() {
        return this.kafka$server$LogDirFailureTest$$topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.kafka$server$LogDirFailureTest$$topic(), this.partitionNum(), this.serverCount(), this.createTopic$default$4());
    }

    @Test
    public void testIOExceptionDuringLogRoll() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    @Test
    public void brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure() {
        VolatileObjectRef statusCodeOption = VolatileObjectRef.create((Object)None$.MODULE$);
        Exit$.MODULE$.setHaltProcedure((Function2)new Serializable(this, statusCodeOption){
            public static final long serialVersionUID = 0L;
            private final VolatileObjectRef statusCodeOption$1;

            public final Nothing$ apply(int statusCode, Option<String> x$1) {
                this.statusCodeOption$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
                throw new IllegalArgumentException();
            }
            {
                this.statusCodeOption$1 = statusCodeOption$1;
            }
        });
        KafkaServer server = null;
        try {
            int x$12 = this.serverCount();
            String x$13 = this.zkConnect();
            int x$14 = 3;
            boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$3();
            boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$4();
            int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$5();
            Option<SecurityProtocol> x$18 = TestUtils$.MODULE$.createBrokerConfig$default$6();
            Option<File> x$19 = TestUtils$.MODULE$.createBrokerConfig$default$7();
            Option<Properties> x$20 = TestUtils$.MODULE$.createBrokerConfig$default$8();
            boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$9();
            boolean x$22 = TestUtils$.MODULE$.createBrokerConfig$default$10();
            int x$23 = TestUtils$.MODULE$.createBrokerConfig$default$11();
            boolean x$24 = TestUtils$.MODULE$.createBrokerConfig$default$12();
            int x$25 = TestUtils$.MODULE$.createBrokerConfig$default$13();
            boolean x$26 = TestUtils$.MODULE$.createBrokerConfig$default$14();
            int x$27 = TestUtils$.MODULE$.createBrokerConfig$default$15();
            Option<String> x$28 = TestUtils$.MODULE$.createBrokerConfig$default$16();
            boolean x$29 = TestUtils$.MODULE$.createBrokerConfig$default$18();
            Properties props = TestUtils$.MODULE$.createBrokerConfig(x$12, x$13, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$14, x$29);
            props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
            props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            File logDir = new File((String)kafkaConfig.logDirs().head());
            CoreUtils$.MODULE$.swallow((Function0)new Serializable(this, logDir){
                public static final long serialVersionUID = 0L;
                private final File logDir$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Utils.delete((File)this.logDir$1);
                }
                {
                    this.logDir$1 = logDir$1;
                }
            }, (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            logDir.createNewFile();
            Assert.assertTrue((boolean)logDir.isFile());
            server = TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, statusCodeOption){
                public static final long serialVersionUID = 0L;
                private final VolatileObjectRef statusCodeOption$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return ((Option)this.statusCodeOption$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)1));
                }
                {
                    this.statusCodeOption$1 = statusCodeOption$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "timed out waiting for broker to halt";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
        catch (Throwable throwable) {
            Exit$.MODULE$.resetHaltProcedure();
            if (server != null) {
                TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})));
            }
            throw throwable;
        }
        Exit$.MODULE$.resetHaltProcedure();
        if (server != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})));
        }
    }

    @Test
    public void testIOExceptionDuringCheckpoint() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    @Test
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower() {
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        TopicPartition partition = new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.kafka$server$LogDirFailureTest$$topic())).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionInfo x$2) {
                return x$2.partition() == 0;
            }
        }).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, leaderServerId){
            public static final long serialVersionUID = 0L;
            private final int leaderServerId$1;

            public final boolean apply(KafkaServer x$3) {
                return x$3.config().brokerId() == this.leaderServerId$1;
            }
            {
                this.leaderServerId$1 = leaderServerId$1;
            }
        }).get();
        int followerServerId = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$4) {
                return x$4.id();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).find((Function1)new Serializable(this, leaderServerId){
            public static final long serialVersionUID = 0L;
            private final int leaderServerId$1;

            public final boolean apply(int x$5) {
                return this.apply$mcZI$sp(x$5);
            }

            public boolean apply$mcZI$sp(int x$5) {
                return x$5 != this.leaderServerId$1;
            }
            {
                this.leaderServerId$1 = leaderServerId$1;
            }
        }).get());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, followerServerId){
            public static final long serialVersionUID = 0L;
            private final int followerServerId$1;

            public final boolean apply(KafkaServer x$6) {
                return x$6.config().brokerId() == this.followerServerId$1;
            }
            {
                this.followerServerId$1 = followerServerId$1;
            }
        }).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.partitionNum()).find((Function1)new Serializable(this, leaderServer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogDirFailureTest $outer;
            private final KafkaServer leaderServer$1;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return this.leaderServer$1.replicaManager().getPartition(new TopicPartition(this.$outer.kafka$server$LogDirFailureTest$$topic(), i)).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Replica> apply(Partition x$7) {
                        return x$7.leaderReplicaIfLocal();
                    }
                }).isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderServer$1 = leaderServer$1;
            }
        }).get());
        ProducerRecord record = new ProducerRecord(this.kafka$server$LogDirFailureTest$$topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.kafka$server$LogDirFailureTest$$topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assert.assertEquals((long)this.serverCount(), (long)((Partition)leaderServer.replicaManager().getPartition(new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicas().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AbstractFetcherThread thread) {
                Assert.assertFalse((String)"ReplicaFetcherThread should still be working if its partition count > 0", (boolean)thread.isShutdownComplete());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testProduceAfterLogDirFailureOnLeader(LogDirFailureType failureType) {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.subscribeAndWaitForAssignment(this.kafka$server$LogDirFailureTest$$topic(), (KafkaConsumer<byte[], byte[]>)consumer);
        KafkaProducer producer = (KafkaProducer)this.producers().head();
        TopicPartition partition = new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), 0);
        ProducerRecord record = new ProducerRecord(this.kafka$server$LogDirFailureTest$$topic(), Predef$.MODULE$.int2Integer(0), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).s((Seq)Nil$.MODULE$).getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.kafka$server$LogDirFailureTest$$topic())).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionInfo x$8) {
                return x$8.partition() == 0;
            }
        }).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, leaderServerId){
            public static final long serialVersionUID = 0L;
            private final int leaderServerId$2;

            public final boolean apply(KafkaServer x$9) {
                return x$9.config().brokerId() == this.leaderServerId$2;
            }
            {
                this.leaderServerId$2 = leaderServerId$2;
            }
        }).get();
        producer.send(record).get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.consumer$1.poll(0L).count() == 1;
            }
            {
                this.consumer$1 = consumer$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected the first message";
            }
        }, 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        Replica replica = leaderServer.replicaManager().getReplicaOrException(partition);
        File logDir = ((Log)replica.log().get()).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)new Serializable(this, logDir){
            public static final long serialVersionUID = 0L;
            private final File logDir$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Utils.delete((File)this.logDir$2);
            }
            {
                this.logDir$2 = logDir$2;
            }
        }, (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        logDir.createNewFile();
        Assert.assertTrue((boolean)logDir.isFile());
        LogDirFailureType logDirFailureType = failureType;
        LogDirFailureTest$Roll$ logDirFailureTest$Roll$ = LogDirFailureTest$Roll$.MODULE$;
        if (!(logDirFailureType != null ? !logDirFailureType.equals(logDirFailureTest$Roll$) : logDirFailureTest$Roll$ != null)) {
            try {
                Log qual$1 = (Log)leaderServer.replicaManager().getLog(partition).get();
                long x$30 = qual$1.roll$default$1();
                qual$1.roll(x$30);
                throw this.fail("Log rolling should fail with KafkaStorageException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            }
            catch (KafkaStorageException kafkaStorageException) {
                // empty catch block
            }
        } else {
            LogDirFailureType logDirFailureType2 = failureType;
            LogDirFailureTest$Checkpoint$ logDirFailureTest$Checkpoint$ = LogDirFailureTest$Checkpoint$.MODULE$;
            if (!(logDirFailureType2 != null ? !logDirFailureType2.equals(logDirFailureTest$Checkpoint$) : logDirFailureTest$Checkpoint$ != null)) {
                leaderServer.replicaManager().checkpointHighWatermarks();
            }
        }
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, leaderServer, logDir){
            public static final long serialVersionUID = 0L;
            private final KafkaServer leaderServer$2;
            private final File logDir$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.leaderServer$2.logManager().isLogDirOnline(this.logDir$2.getAbsolutePath());
            }
            {
                this.leaderServer$2 = leaderServer$2;
                this.logDir$2 = logDir$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected log directory offline";
            }
        }, 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((boolean)leaderServer.replicaManager().getReplica(partition).isEmpty());
        try {
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            throw this.fail("send() should fail with either KafkaStorageException or NotLeaderForPartitionException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }
        catch (Throwable throwable) {
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send() should fail with either KafkaStorageException or NotLeaderForPartitionException instead of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable.toString()})), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        }
        catch (ExecutionException executionException) {
            block14: {
                block13: {
                    block12: {
                        throwable = executionException.getCause();
                        if (!(throwable instanceof KafkaStorageException)) break block12;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block13;
                    }
                    if (!(throwable instanceof NotLeaderForPartitionException)) break block14;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, producer, record, leaderServerId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LogDirFailureTest $outer;
                    private final KafkaProducer producer$1;
                    private final ProducerRecord record$1;
                    private final int leaderServerId$2;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        this.producer$1.send(this.record$1);
                        return ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.producer$1.partitionsFor(this.$outer.kafka$server$LogDirFailureTest$$topic())).asScala()).find((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(PartitionInfo x$10) {
                                return x$10.partition() == 0;
                            }
                        }).get()).leader().id() != this.leaderServerId$2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$1 = producer$1;
                        this.record$1 = record$1;
                        this.leaderServerId$2 = leaderServerId$2;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Expected new leader for the partition";
                    }
                }, 6000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer){
                    public static final long serialVersionUID = 0L;
                    private final KafkaConsumer consumer$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.consumer$1.poll(0L).count() > 0;
                    }
                    {
                        this.consumer$1 = consumer$1;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Expected some messages";
                    }
                }, 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
                Assert.assertTrue((boolean)this.zkClient().getAllLogDirEventNotifications().isEmpty());
                KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(KafkaServer x$11) {
                        return x$11.kafkaController().isActive();
                    }
                }).get();
                Set offlineReplicas = controllerServer.kafkaController().replicaStateMachine().replicasInState(this.kafka$server$LogDirFailureTest$$topic(), (ReplicaState)OfflineReplica$.MODULE$);
                Assert.assertTrue((boolean)offlineReplicas.contains((Object)new PartitionAndReplica(new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), 0), leaderServerId)));
                return;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send() should fail with either KafkaStorageException or NotLeaderForPartitionException instead of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable2.toString()})), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            }
            throw new MatchError((Object)throwable);
        }
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$2.poll(0L);
                return !this.consumer$2.assignment().isEmpty();
            }
            {
                this.consumer$2 = consumer$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected non-empty assignment";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.serverCount = 2;
        this.kafka$server$LogDirFailureTest$$topic = "topic";
        this.partitionNum = 12;
        this.logDirCount_$eq(3);
        this.producerConfig().setProperty("retries", "0");
        this.producerConfig().setProperty("retry.backoff.ms", "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
    }

    public static interface LogDirFailureType {
    }
}

