/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.cluster.Broker;
import kafka.common.AdminCommandFailedException;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Whitelist;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.KeeperException;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TopicCommand$
implements Logging {
    public static final TopicCommand$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TopicCommand$();
    }

    private Logger logger$lzycompute() {
        TopicCommand$ topicCommand$ = this;
        synchronized (topicCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Create, delete, describe, or change a topic.");
        }
        int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.createOpt(), opts.listOpt(), opts.alterOpt(), opts.describeOpt(), opts.deleteOpt()}))).count((Function1)new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final TopicCommand.TopicCommandOptions opts$1;

            public final boolean apply(OptionSpec<?> x$1) {
                return this.opts$1.options().has(x$1);
            }
            {
                this.opts$1 = opts$1;
            }
        });
        if (actions != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --list, --describe, --create, --alter or --delete");
        }
        opts.checkArgs();
        Time time = Time.SYSTEM;
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply((String)opts.options().valueOf(opts.zkConnectOpt()), JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, time, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
        int exitCode = 0;
        try {
            try {
                if (opts.options().has((OptionSpec)opts.createOpt())) {
                    this.createTopic(zkClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.alterOpt())) {
                    this.alterTopic(zkClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.listOpt())) {
                    this.listTopics(zkClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeTopic(zkClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.deleteOpt())) {
                    this.deleteTopic(zkClient, opts);
                }
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Error while executing topic command : ").append((Object)throwable.getMessage()).toString());
                this.error((Function0<String>)new Serializable(throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final String apply() {
                        return Utils.stackTrace((Throwable)this.e$1);
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                exitCode = 1;
            }
        }
        finally {
            zkClient.close();
            throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
        }
    }

    private Seq<String> getTopics(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        Seq allTopics = (Seq)zkClient.getAllTopicsInCluster().sorted((Ordering)Ordering.String$.MODULE$);
        if (opts.options().has(opts.topicOpt())) {
            String topicsSpec = (String)opts.options().valueOf(opts.topicOpt());
            Whitelist topicsFilter = new Whitelist(topicsSpec);
            seq = (Seq)allTopics.filter((Function1)new Serializable(topicsFilter){
                public static final long serialVersionUID = 0L;
                private final Whitelist topicsFilter$1;

                public final boolean apply(String x$1) {
                    return this.topicsFilter$1.isTopicAllowed(x$1, false);
                }
                {
                    this.topicsFilter$1 = topicsFilter$1;
                }
            });
        } else {
            seq = allTopics;
        }
        return seq;
    }

    public void createTopic(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        TopicExistsException topicExistsException2;
        block5: {
            String topic = (String)opts.options().valueOf(opts.topicOpt());
            Properties configs = this.parseTopicConfigsToBeAdded(opts);
            boolean ifNotExists = opts.options().has((OptionSpec)opts.ifNotExistsOpt());
            if (Topic.hasCollisionChars((String)topic)) {
                Predef$.MODULE$.println((Object)"WARNING: Due to limitations in metric names, topics with a period ('.') or underscore ('_') could collide. To avoid issues it is best to use either, but not both.");
            }
            AdminZkClient adminZkClient = new AdminZkClient(zkClient);
            try {
                if (opts.options().has(opts.replicaAssignmentOpt())) {
                    Map<Object, List<Object>> assignment = this.parseReplicaAssignment((String)opts.options().valueOf(opts.replicaAssignmentOpt()));
                    adminZkClient.createOrUpdateTopicPartitionAssignmentPathInZK(topic, assignment, configs, false);
                } else {
                    CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.partitionsOpt(), opts.replicationFactorOpt()}));
                    int partitions = (Integer)opts.options().valueOf(opts.partitionsOpt());
                    int replicas = (Integer)opts.options().valueOf(opts.replicationFactorOpt());
                    Product rackAwareMode = opts.options().has((OptionSpec)opts.disableRackAware()) ? RackAwareMode$Disabled$.MODULE$ : RackAwareMode$Enforced$.MODULE$;
                    adminZkClient.createTopic(topic, partitions, replicas, configs, (RackAwareMode)rackAwareMode);
                }
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Created topic \"%s\".")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (TopicExistsException topicExistsException2) {
                if (!ifNotExists) break block5;
            }
            return;
        }
        throw topicExistsException2;
    }

    public void alterTopic(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        boolean ifExists = opts.options().has((OptionSpec)opts.ifExistsOpt());
        if (topics.isEmpty() && !ifExists) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Topic %s does not exist on ZK path %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opts.options().valueOf(opts.topicOpt()), opts.options().valueOf(opts.zkConnectOpt())})));
        }
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        topics.foreach((Function1)new Serializable(zkClient, opts, adminZkClient){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$1;
            private final TopicCommand.TopicCommandOptions opts$2;
            private final AdminZkClient adminZkClient$1;

            public final void apply(String topic) {
                Properties configs = this.adminZkClient$1.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                if (this.opts$2.options().has(this.opts$2.configOpt()) || this.opts$2.options().has(this.opts$2.deleteConfigOpt())) {
                    Predef$.MODULE$.println((Object)"WARNING: Altering topic configuration from this script has been deprecated and may be removed in future releases.");
                    Predef$.MODULE$.println((Object)"         Going forward, please use kafka-configs.sh for this functionality");
                    Properties configsToBeAdded = TopicCommand$.MODULE$.parseTopicConfigsToBeAdded(this.opts$2);
                    Seq<String> configsToBeDeleted = TopicCommand$.MODULE$.parseTopicConfigsToBeDeleted(this.opts$2);
                    Implicits$.MODULE$.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
                    configsToBeDeleted.foreach((Function1)new Serializable(this, configs){
                        public static final long serialVersionUID = 0L;
                        private final Properties configs$1;

                        public final Object apply(String config) {
                            return this.configs$1.remove(config);
                        }
                        {
                            this.configs$1 = configs$1;
                        }
                    });
                    this.adminZkClient$1.changeTopicConfig(topic, configs);
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Updated config for topic \"%s\".")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                }
                if (this.opts$2.options().has(this.opts$2.partitionsOpt())) {
                    String string = topic;
                    String string2 = "__consumer_offsets";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new IllegalArgumentException("The number of partitions for the offsets topic cannot be changed.");
                    }
                    Predef$.MODULE$.println((Object)"WARNING: If partitions are increased for a topic that has a key, the partition logic or ordering of the messages will be affected");
                    int nPartitions = (Integer)this.opts$2.options().valueOf(this.opts$2.partitionsOpt());
                    scala.collection.immutable.Map existingAssignment = (scala.collection.immutable.Map)this.zkClient$1.getReplicaAssignmentForTopics((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$1) {
                            Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$1;
                            if (tuple2 != null) {
                                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                                Seq replicas = (Seq)tuple2._2();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    if (existingAssignment.isEmpty()) {
                        throw new InvalidTopicException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The topic ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    }
                    String replicaAssignmentStr = (String)this.opts$2.options().valueOf(this.opts$2.replicaAssignmentOpt());
                    Option newAssignment = Option$.MODULE$.apply((Object)replicaAssignmentStr).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String x$2) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
                        }
                    }).map((Function1)new Serializable(this, existingAssignment){
                        public static final long serialVersionUID = 0L;
                        private final scala.collection.immutable.Map existingAssignment$1;

                        public final Map<Object, Seq<Object>> apply(String replicaAssignmentString) {
                            int startPartitionId = this.existingAssignment$1.size();
                            String[] partitionList = (String[])Predef$.MODULE$.refArrayOps((Object[])replicaAssignmentString.split(",")).drop(startPartitionId);
                            return AdminUtils$.MODULE$.parseReplicaAssignment(Predef$.MODULE$.refArrayOps((Object[])partitionList).mkString(","), startPartitionId);
                        }
                        {
                            this.existingAssignment$1 = existingAssignment$1;
                        }
                    });
                    Seq<BrokerMetadata> allBrokers = this.adminZkClient$1.getBrokerMetadatas(this.adminZkClient$1.getBrokerMetadatas$default$1(), this.adminZkClient$1.getBrokerMetadatas$default$2());
                    this.adminZkClient$1.addPartitions(topic, (Map<Object, Seq<Object>>)existingAssignment, allBrokers, nPartitions, (Option<Map<Object, Seq<Object>>>)newAssignment, this.adminZkClient$1.addPartitions$default$6());
                    Predef$.MODULE$.println((Object)"Adding partitions succeeded!");
                }
            }
            {
                this.zkClient$1 = zkClient$1;
                this.opts$2 = opts$2;
                this.adminZkClient$1 = adminZkClient$1;
            }
        });
    }

    public void listTopics(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        topics.foreach((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$2;

            public final void apply(String topic) {
                if (this.zkClient$2.isTopicMarkedForDeletion(topic)) {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s - marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                } else {
                    Predef$.MODULE$.println((Object)topic);
                }
            }
            {
                this.zkClient$2 = zkClient$2;
            }
        });
    }

    public void deleteTopic(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        boolean ifExists = opts.options().has((OptionSpec)opts.ifExistsOpt());
        if (topics.isEmpty() && !ifExists) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Topic %s does not exist on ZK path %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opts.options().valueOf(opts.topicOpt()), opts.options().valueOf(opts.zkConnectOpt())})));
        }
        topics.foreach((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$4;

            public final void apply(String topic) {
                try {
                    if (Topic.isInternal((String)topic)) {
                        throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic %s is a kafka internal topic and is not allowed to be marked for deletion.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    }
                    this.zkClient$4.createDeleteTopicPath(topic);
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Topic %s is marked for deletion.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                    Predef$.MODULE$.println((Object)"Note: This will have no impact if delete.topic.enable is not set to true.");
                }
                catch (Throwable throwable) {
                    throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Error while deleting topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                }
                catch (AdminOperationException adminOperationException) {
                    throw adminOperationException;
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Topic %s is already marked for deletion.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                }
            }
            {
                this.zkClient$4 = zkClient$4;
            }
        });
    }

    public void describeTopic(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        boolean reportUnderReplicatedPartitions = opts.options().has((OptionSpec)opts.reportUnderReplicatedPartitionsOpt());
        boolean reportUnavailablePartitions = opts.options().has((OptionSpec)opts.reportUnavailablePartitionsOpt());
        boolean reportOverriddenConfigs = opts.options().has((OptionSpec)opts.topicsWithOverridesOpt());
        Set liveBrokers2 = ((TraversableOnce)zkClient.getAllBrokersInCluster().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Broker x$3) {
                return x$3.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        topics.foreach((Function1)new Serializable(zkClient, reportUnderReplicatedPartitions, reportUnavailablePartitions, reportOverriddenConfigs, liveBrokers2, adminZkClient){
            public static final long serialVersionUID = 0L;
            public final KafkaZkClient zkClient$3;
            public final boolean reportUnderReplicatedPartitions$1;
            public final boolean reportUnavailablePartitions$1;
            private final boolean reportOverriddenConfigs$1;
            public final Set liveBrokers$1;
            private final AdminZkClient adminZkClient$2;

            public final void apply(String topic) {
                Option option;
                block9: {
                    block8: {
                        block7: {
                            BoxedUnit boxedUnit;
                            option = this.zkClient$3.getPartitionAssignmentForTopics((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            scala.collection.immutable.Map topicPartitionAssignment = (scala.collection.immutable.Map)some.x();
                            boolean describeConfigs2 = !this.reportUnavailablePartitions$1 && !this.reportUnderReplicatedPartitions$1;
                            boolean describePartitions2 = !this.reportOverriddenConfigs$1;
                            Seq sortedPartitions = (Seq)topicPartitionAssignment.toSeq().sortBy((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Tuple2<Object, Seq<Object>> x$4) {
                                    return x$4._1$mcI$sp();
                                }
                            }, (Ordering)Ordering.Int$.MODULE$);
                            boolean markedForDeletion = this.zkClient$3.isTopicMarkedForDeletion(topic);
                            if (describeConfigs2) {
                                scala.collection.mutable.Map configs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.adminZkClient$2.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic)).asScala();
                                if (!this.reportOverriddenConfigs$1 || configs.nonEmpty()) {
                                    int numPartitions = topicPartitionAssignment.size();
                                    int replicationFactor = ((SeqLike)((Tuple2)topicPartitionAssignment.head())._2()).size();
                                    String configsAsString = ((TraversableOnce)configs.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Tuple2<String, String> x0$2) {
                                            Tuple2<String, String> tuple2 = x0$2;
                                            if (tuple2 != null) {
                                                String k = (String)tuple2._1();
                                                String v = (String)tuple2._2();
                                                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                                                return string;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
                                    String markedForDeletionString = markedForDeletion ? "\tMarkedForDeletion:true" : "";
                                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Topic:%s\tPartitionCount:%d\tReplicationFactor:%d\tConfigs:%s%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)numPartitions), BoxesRunTime.boxToInteger((int)replicationFactor), configsAsString, markedForDeletionString})));
                                }
                            }
                            if (describePartitions2) {
                                sortedPartitions.withFilter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Tuple2<Object, Seq<Object>> check$ifrefutable$1) {
                                        Tuple2<Object, Seq<Object>> tuple2 = check$ifrefutable$1;
                                        boolean bl = tuple2 != null;
                                        return bl;
                                    }
                                }).foreach((Function1)new Serializable(this, describeConfigs2, markedForDeletion, topic){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.describeTopic.1 $outer;
                                    private final boolean describeConfigs$1;
                                    private final boolean markedForDeletion$1;
                                    private final String topic$1;

                                    public final void apply(Tuple2<Object, Seq<Object>> x$5) {
                                        Tuple2<Object, Seq<Object>> tuple2 = x$5;
                                        if (tuple2 != null) {
                                            BoxedUnit boxedUnit;
                                            None$ leader;
                                            int partitionId = tuple2._1$mcI$sp();
                                            Seq assignedReplicas2 = (Seq)tuple2._2();
                                            Option<LeaderIsrAndControllerEpoch> leaderIsrEpoch = this.$outer.zkClient$3.getTopicPartitionState(new TopicPartition(this.topic$1, partitionId));
                                            List<Object> inSyncReplicas = leaderIsrEpoch.isEmpty() ? (List<Object>)Seq$.MODULE$.empty() : ((LeaderIsrAndControllerEpoch)leaderIsrEpoch.get()).leaderAndIsr().isr();
                                            Object object = leader = leaderIsrEpoch.isEmpty() ? None$.MODULE$ : Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((LeaderIsrAndControllerEpoch)leaderIsrEpoch.get()).leaderAndIsr().leader()));
                                            if (!(!this.$outer.reportUnderReplicatedPartitions$1 && !this.$outer.reportUnavailablePartitions$1 || this.$outer.reportUnderReplicatedPartitions$1 && inSyncReplicas.size() < assignedReplicas2.size() || this.$outer.reportUnavailablePartitions$1 && (leader.isEmpty() || !this.$outer.liveBrokers$1.contains(leader.get())))) {
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                String markedForDeletionString = this.markedForDeletion$1 && !this.describeConfigs$1 ? "\tMarkedForDeletion: true" : "";
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tTopic: ").append((Object)this.topic$1).toString());
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tPartition: ").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString());
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tLeader: ").append(leader.isDefined() ? leader.get() : "none").toString());
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tReplicas: ").append((Object)assignedReplicas2.mkString(",")).toString());
                                                Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tIsr: ").append((Object)inSyncReplicas.mkString(",")).toString());
                                                Predef$.MODULE$.print((Object)markedForDeletionString);
                                                Predef$.MODULE$.println();
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            BoxedUnit boxedUnit2 = boxedUnit;
                                            return;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.describeConfigs$1 = describeConfigs$1;
                                        this.markedForDeletion$1 = markedForDeletion$1;
                                        this.topic$1 = topic$1;
                                    }
                                });
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            break block8;
                        }
                        if (!None$.MODULE$.equals(option)) break block9;
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Topic ").append((Object)topic).append((Object)" doesn't exist!").toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError((Object)option);
            }
            {
                this.zkClient$3 = zkClient$3;
                this.reportUnderReplicatedPartitions$1 = reportUnderReplicatedPartitions$1;
                this.reportUnavailablePartitions$1 = reportUnavailablePartitions$1;
                this.reportOverriddenConfigs$1 = reportOverriddenConfigs$1;
                this.liveBrokers$1 = liveBrokers$1;
                this.adminZkClient$2 = adminZkClient$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_3;
        Buffer configsToBeAdded = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.configOpt())).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$6) {
                return x$6.split("\\s*=\\s*");
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(configsToBeAdded.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] config) {
                return config.length == 2;
            }
        }), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Invalid topic config: all configs to be added must be in the format \"key=val\".";
            }
        });
        Properties props = new Properties();
        configsToBeAdded.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String[] pair) {
                return this.props$1.setProperty(pair[0].trim(), pair[1].trim());
            }
            {
                this.props$1 = props$1;
            }
        });
        LogConfig$.MODULE$.validate(props);
        if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: The configuration ", "=", " is specified. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker."})).s((Seq)Nil$.MODULE$)).toString());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfigOpt())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.deleteConfigOpt())).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$7) {
                    return x$7.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1)new Serializable(propsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Properties propsToBeDeleted$1;

                public final Object apply(String x$8) {
                    return this.propsToBeDeleted$1.setProperty(x$8, "");
                }
                {
                    this.propsToBeDeleted$1 = propsToBeDeleted$1;
                }
            });
            LogConfig$.MODULE$.validateNames(propsToBeDeleted);
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        String[] partitionList = replicaAssignmentList.split(",");
        HashMap ret = new HashMap();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.refArrayOps((Object[])partitionList).size()).foreach$mVc$sp((Function1)new Serializable(partitionList, ret){
            public static final long serialVersionUID = 0L;
            private final String[] partitionList$1;
            private final HashMap ret$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int[] brokerList = (int[])Predef$.MODULE$.refArrayOps((Object[])this.partitionList$1[i].split(":")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String s) {
                        return new StringOps(Predef$.MODULE$.augmentString(s.trim())).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                Iterable<T> duplicateBrokers = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerList));
                if (duplicateBrokers.nonEmpty()) {
                    throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateBrokers.mkString(",")})));
                }
                this.ret$1.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)Predef$.MODULE$.intArrayOps(brokerList).toList());
                if (((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)i))).size() != ((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"Partition ").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" has different replication factor: ").append((Object)brokerList).toString());
                }
            }
            {
                this.partitionList$1 = partitionList$1;
                this.ret$1 = ret$1;
            }
        });
        return ret.toMap(Predef$.MODULE$.$conforms());
    }

    public void askToProceed() {
        Predef$.MODULE$.println((Object)"Are you sure you want to continue? [y/n]");
        if (Console$.MODULE$.readLine().equalsIgnoreCase("y")) {
            return;
        }
        Predef$.MODULE$.println((Object)"Ending your session");
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    private TopicCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

