/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionSpec;
import kafka.admin.ConfigCommand;
import kafka.common.Config$class;
import kafka.common.InvalidConfigException;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging$class;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.ScramFormatter;
import org.apache.kafka.common.security.scram.ScramMechanism;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class ConfigCommand$
implements kafka.common.Config {
    public static final ConfigCommand$ MODULE$;
    private final int DefaultScramIterations;
    private final Set<String> BrokerConfigsUpdatableUsingZooKeeper;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConfigCommand$();
    }

    @Override
    public void validateChars(String prop, String value2) {
        Config$class.validateChars(this, prop, value2);
    }

    private Logger logger$lzycompute() {
        ConfigCommand$ configCommand$ = this;
        synchronized (configCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int DefaultScramIterations() {
        return this.DefaultScramIterations;
    }

    public Set<String> BrokerConfigsUpdatableUsingZooKeeper() {
        return this.BrokerConfigsUpdatableUsingZooKeeper;
    }

    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            if (args.length == 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Add/Remove entity config for a topic, client, user or broker");
            }
            opts.checkArgs();
            if (opts.options().has(opts.zkConnectOpt())) {
                this.processCommandWithZk((String)opts.options().valueOf(opts.zkConnectOpt()), opts);
            } else {
                this.processBrokerConfig(opts);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalArgumentException ? true : (throwable2 instanceof InvalidConfigException ? true : throwable2 instanceof OptionException);
            if (bl) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed config command with args '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])args).mkString(" ")})), throwable2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                System.err.println(throwable2.getMessage());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing config command with args '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])args).mkString(" ")})));
                throwable3.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processCommandWithZk(String zkConnectString, ConfigCommand.ConfigCommandOptions opts) {
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnectString, JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfig(zkClient, opts, adminZkClient);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfig(zkClient, opts, adminZkClient);
            }
            zkClient.close();
            return;
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
    }

    public void alterConfig(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        Properties configs;
        Seq invalidConfigs;
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        String string = entityType;
        String string2 = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.preProcessScramCredentials(configsToBeAdded);
        }
        String string3 = entityType;
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            Predef$.MODULE$.require(((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String elem) {
                    return ConfigCommand$.MODULE$.BrokerConfigsUpdatableUsingZooKeeper().contains((Object)elem);
                }
            }), (Function0)new Serializable(configsToBeAdded){
                public static final long serialVersionUID = 0L;
                private final Properties configsToBeAdded$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server option must be specified to update broker configs ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.configsToBeAdded$1}));
                }
                {
                    this.configsToBeAdded$1 = configsToBeAdded$1;
                }
            });
        }
        if ((invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1)new Serializable(configs = adminZkClient.fetchEntityConfig(entityType, entityName)){
            public static final long serialVersionUID = 0L;
            private final Properties configs$1;

            public final boolean apply(String x$1) {
                return this.configs$1.containsKey(x$1);
            }
            {
                this.configs$1 = configs$1;
            }
        })).nonEmpty()) {
            throw new InvalidConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config(s): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidConfigs.mkString(",")})));
        }
        Implicits$.MODULE$.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
        configsToBeDeleted.foreach((Function1)new Serializable(configs){
            public static final long serialVersionUID = 0L;
            private final Properties configs$1;

            public final Object apply(String x$2) {
                return this.configs$1.remove(x$2);
            }
            {
                this.configs$1 = configs$1;
            }
        });
        adminZkClient.changeConfigs(entityType, entityName, configs);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed Updating config for entity: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity})));
    }

    private void preProcessScramCredentials(Properties configsToBeAdded) {
        Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values()).foreach((Function1)new Serializable(configsToBeAdded){
            public static final long serialVersionUID = 0L;
            private final Properties configsToBeAdded$2;

            public final Object apply(ScramMechanism mechanism) {
                String string = this.configsToBeAdded$2.getProperty(mechanism.mechanismName());
                Object object = string == null ? BoxedUnit.UNIT : this.configsToBeAdded$2.setProperty(mechanism.mechanismName(), ConfigCommand$.MODULE$.kafka$admin$ConfigCommand$$scramCredential$1(mechanism, string));
                return object;
            }
            {
                this.configsToBeAdded$2 = configsToBeAdded$2;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private void describeConfig(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        configEntity = this.parseEntity(opts);
        v0 = configEntity.root().entityType();
        var6_5 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        entities = configEntity.getAllEntities(zkClient);
        entities.foreach((Function1)new Serializable(adminZkClient, describeAllUsers){
            public static final long serialVersionUID = 0L;
            private final AdminZkClient adminZkClient$1;
            private final boolean describeAllUsers$1;

            public final void apply(ConfigCommand.ConfigEntity entity) {
                Properties configs = this.adminZkClient$1.fetchEntityConfig(entity.root().entityType(), entity.fullSanitizedName());
                if (!configs.isEmpty() || !this.describeAllUsers$1) {
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Configs for %s are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configs).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, String> kv) {
                            return new StringBuilder().append((Object)((String)kv._1())).append((Object)"=").append(kv._2()).toString();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
                }
            }
            {
                this.adminZkClient$1 = adminZkClient$1;
                this.describeAllUsers$1 = describeAllUsers$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        void var2_2;
        Properties props = new Properties();
        if (opts.options().has(opts.addConfig())) {
            String pattern = "(?=[^\\]]*(?:\\[|$))";
            String[][] configsToBeAdded = (String[][])Predef$.MODULE$.refArrayOps((Object[])((String)opts.options().valueOf(opts.addConfig())).split(new StringBuilder().append((Object)",").append((Object)pattern).toString())).map((Function1)new Serializable(pattern){
                public static final long serialVersionUID = 0L;
                private final String pattern$1;

                public final String[] apply(String x$4) {
                    return x$4.split(new StringBuilder().append((Object)"\\s*=\\s*").append((Object)this.pattern$1).toString());
                }
                {
                    this.pattern$1 = pattern$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
            Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded).forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String[] config) {
                    return config.length == 2;
                }
            }), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Invalid entity config: all configs to be added must be in the format \"key=val\".";
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded).foreach((Function1)new Serializable(props){
                public static final long serialVersionUID = 0L;
                private final Properties props$1;

                public final Object apply(String[] pair) {
                    return this.props$1.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim());
                }
                {
                    this.props$1 = props$1;
                }
            });
            if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: The configuration ", "=", " is specified. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker."})).s((Seq)Nil$.MODULE$)).toString());
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.deleteConfig())).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$5) {
                    return x$5.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1)new Serializable(propsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Properties propsToBeDeleted$1;

                public final Object apply(String x$6) {
                    return this.propsToBeDeleted$1.setProperty(x$6, "");
                }
                {
                    this.propsToBeDeleted$1 = propsToBeDeleted$1;
                }
            });
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBrokerConfig(ConfigCommand.ConfigCommandOptions opts) {
        AdminClient adminClient;
        block6: {
            String string;
            Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
            props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
            adminClient = AdminClient.create((Properties)props);
            if (opts.options().has(opts.entityName())) {
                string = (String)opts.options().valueOf(opts.entityName());
            } else {
                if (!opts.options().has((OptionSpec)opts.entityDefault())) throw new IllegalArgumentException("At least one of --entity-name or --entity-default must be specified with --bootstrap-server");
                string = "";
            }
            String entityName = string;
            Buffer entityTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
            if (entityTypes.size() != 1) {
                throw new IllegalArgumentException("Exactly one --entity-type must be specified with --bootstrap-server");
            }
            Object object = entityTypes.head();
            String string2 = ConfigType$.MODULE$.Broker();
            if (object != null ? !object.equals(string2) : string2 != null) void var5_5;
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper option must be specified for entity-type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_5})));
            try {
                if (opts.options().has((OptionSpec)opts.alterOpt())) {
                    this.alterBrokerConfig(adminClient, opts, entityName);
                    break block6;
                }
                if (!opts.options().has((OptionSpec)opts.describeOpt())) break block6;
                this.describeBrokerConfig(adminClient, opts, entityName);
            }
            catch (Throwable throwable) {
                void var3_3;
                var3_3.close();
                throw throwable;
            }
        }
        adminClient.close();
    }

    public void alterBrokerConfig(AdminClient adminClient, ConfigCommand.ConfigCommandOptions opts, String entityName) {
        scala.collection.mutable.Map configsToBeAdded = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.parseConfigsToBeAdded(opts)).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ConfigEntry> apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)k, (Object)new ConfigEntry(k, v));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityName);
        scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.brokerConfig(adminClient, entityName, false).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ConfigEntry> apply(ConfigEntry entry2) {
                return new Tuple2((Object)entry2.name(), (Object)entry2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1)new Serializable(oldConfig){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map oldConfig$1;

            public final boolean apply(String key) {
                return this.oldConfig$1.contains((Object)key);
            }
            {
                this.oldConfig$1 = oldConfig$1;
            }
        });
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config(s): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidConfigs.mkString(",")})));
        }
        scala.collection.immutable.Map newEntries = (scala.collection.immutable.Map)oldConfig.$plus$plus((GenTraversableOnce)configsToBeAdded).$minus$minus(configsToBeDeleted);
        scala.collection.immutable.Map sensitiveEntries = (scala.collection.immutable.Map)newEntries.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, ConfigEntry> x$7) {
                return ((ConfigEntry)x$7._2()).value() == null;
            }
        });
        if (sensitiveEntries.nonEmpty()) {
            throw new InvalidConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All sensitive broker config entries must be specified for --alter, missing entries: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sensitiveEntries.keySet()})));
        }
        Config newConfig = new Config(((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newEntries).asJava()).values());
        AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
        adminClient.alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)newConfig)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
        if (new StringOps(Predef$.MODULE$.augmentString(entityName)).nonEmpty()) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed updating config for broker: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityName})));
        } else {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed updating default config for brokers in the cluster,"})).s((Seq)Nil$.MODULE$));
        }
    }

    private void describeBrokerConfig(AdminClient adminClient, ConfigCommand.ConfigCommandOptions opts, String entityName) {
        Seq<ConfigEntry> configs = this.brokerConfig(adminClient, entityName, true);
        if (new StringOps(Predef$.MODULE$.augmentString(entityName)).nonEmpty()) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configs for broker ", " are:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityName})));
        } else {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Default config for brokers in the cluster are:"})).s((Seq)Nil$.MODULE$));
        }
        configs.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ConfigEntry config) {
                String synonyms = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(config.synonyms()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ConfigEntry.ConfigSynonym synonym) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{synonym.source(), synonym.name(), synonym.value()}));
                    }
                }, Buffer$.MODULE$.canBuildFrom())).mkString(", ");
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", "=", " sensitive=", " synonyms={", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.name(), config.value(), BoxesRunTime.boxToBoolean((boolean)config.isSensitive()), synonyms})));
            }
        });
    }

    private Seq<ConfigEntry> brokerConfig(AdminClient adminClient, String entityName, boolean includeSynonyms) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityName);
        ConfigEntry.ConfigSource configSource = entityName.isEmpty() ? ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG : ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG;
        DescribeConfigsOptions describeOpts = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource), describeOpts).all().get(30L, TimeUnit.SECONDS);
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs.get(configResource)).entries()).asScala()).filter((Function1)new Serializable(configSource){
            public static final long serialVersionUID = 0L;
            private final ConfigEntry.ConfigSource configSource$1;

            public final boolean apply(ConfigEntry entry2) {
                ConfigEntry.ConfigSource configSource = entry2.source();
                ConfigEntry.ConfigSource configSource2 = this.configSource$1;
                return !(configSource != null ? !configSource.equals(configSource2) : configSource2 != null);
            }
            {
                this.configSource$1 = configSource$1;
            }
        })).toSeq();
    }

    /*
     * Enabled aggressive block sorting
     */
    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        ConfigCommand.ConfigEntity configEntity;
        Buffer entityTypes;
        block3: {
            block2: {
                entityTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
                Object object = entityTypes.head();
                String string = ConfigType$.MODULE$.User();
                if (!(object == null ? string != null : !object.equals(string))) break block2;
                Object object2 = entityTypes.head();
                String string2 = ConfigType$.MODULE$.Client();
                if (object2 != null ? !object2.equals(string2) : string2 != null) break block3;
            }
            configEntity = this.parseQuotaEntity(opts);
            return configEntity;
        }
        None$ name = opts.options().has(opts.entityName()) ? new Some(opts.options().valueOf(opts.entityName())) : None$.MODULE$;
        configEntity = new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)entityTypes.head(), (Option<String>)name), (Option<ConfigCommand.Entity>)None$.MODULE$);
        return configEntity;
    }

    private Seq<String> entityNames(ConfigCommand.ConfigCommandOptions opts) {
        java.util.Iterator namesIterator = opts.options().valuesOf(opts.entityName()).iterator();
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().specs()).asScala()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OptionSpec<?> spec) {
                return spec.options().contains("entity-name") || spec.options().contains("entity-default");
            }
        })).map((Function1)new Serializable(namesIterator){
            public static final long serialVersionUID = 0L;
            private final java.util.Iterator namesIterator$1;

            public final String apply(OptionSpec<?> spec) {
                return spec.options().contains("entity-name") ? (String)this.namesIterator$1.next() : "";
            }
            {
                this.namesIterator$1 = namesIterator$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseQuotaEntity(ConfigCommand.ConfigCommandOptions opts) {
        types = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
        names = this.entityNames(opts);
        if (opts.options().has((OptionSpec)opts.alterOpt()) && names.size() != types.size()) {
            throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
        }
        if (types.size() != 2) ** GOTO lbl-1000
        v0 = types.apply(0);
        var5_4 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? (Buffer)types.reverse() : types;
        sortedNames = ((IterableLike)(reverse != false && names.length() == 2 ? names.reverse() : names)).iterator();
        entities = (Buffer)entityTypes.map((Function1)new Serializable(sortedNames){
            public static final long serialVersionUID = 0L;
            private final Iterator sortedNames$1;

            public final ConfigCommand.Entity apply(String t) {
                return new ConfigCommand.Entity(t, (Option<String>)(this.sortedNames$1.hasNext() ? new Some((Object)ConfigCommand$.MODULE$.kafka$admin$ConfigCommand$$sanitizeName$1(t, (String)this.sortedNames$1.next())) : None$.MODULE$));
            }
            {
                this.sortedNames$1 = sortedNames$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new ConfigCommand.ConfigEntity((ConfigCommand.Entity)entities.head(), (Option<ConfigCommand.Entity>)(entities.size() > 1 ? new Some(entities.apply(1)) : None$.MODULE$));
    }

    public final String kafka$admin$ConfigCommand$$scramCredential$1(ScramMechanism mechanism, String credentialStr) {
        String string;
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString("(?:iterations=([0-9]*),)?password=(.*)")).r();
        Option option = pattern.unapplySeq((CharSequence)(string = credentialStr));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String password;
            String iterations = (String)((LinearSeqOptimized)option.get()).apply(0);
            Tuple2 tuple2 = new Tuple2((Object)(iterations == null ? BoxesRunTime.boxToInteger((int)this.DefaultScramIterations()) : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(iterations)).toInt())), (Object)(password = (String)((LinearSeqOptimized)option.get()).apply(1)));
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                int iterations2 = tuple22._1$mcI$sp();
                String password2 = (String)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)iterations2), (Object)password2);
                int iterations3 = tuple24._1$mcI$sp();
                String password3 = (String)tuple24._2();
                if (iterations3 < mechanism.minIterations()) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iterations ", " is less than the minimum ", " required for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iterations3), BoxesRunTime.boxToInteger((int)mechanism.minIterations()), mechanism})));
                }
                ScramCredential credential = new ScramFormatter(mechanism).generateCredential(password3, iterations3);
                return ScramCredentialUtils.credentialToString((ScramCredential)credential);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid credential property ", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mechanism, credentialStr})));
    }

    public final String kafka$admin$ConfigCommand$$sanitizeName$1(String entityType, String name) {
        block7: {
            String string;
            block6: {
                String string2;
                boolean bl;
                block5: {
                    if (!name.isEmpty()) break block5;
                    string = ConfigEntityName$.MODULE$.Default();
                    break block6;
                }
                String string3 = entityType;
                String string4 = ConfigType$.MODULE$.User();
                String string5 = string3;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = ConfigType$.MODULE$.Client();
                    String string7 = string3;
                    bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
                }
                if (!bl) break block7;
                string = string2 = Sanitizer.sanitize((String)name);
            }
            return string;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid entity type ").append((Object)entityType).toString());
    }

    private ConfigCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        Config$class.$init$(this);
        this.DefaultScramIterations = 4096;
        this.BrokerConfigsUpdatableUsingZooKeeper = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()}));
    }
}

