/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.tools.ConsumerPerformance;
import kafka.tools.ConsumerPerformance$;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class ConsumerPerformance$ {
    public static final ConsumerPerformance$ MODULE$;
    private final Logger logger;

    static {
        new ConsumerPerformance$();
    }

    private Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        this.logger().info((Object)"Starting consumer...");
        AtomicLong totalMessagesRead = new AtomicLong(0L);
        AtomicLong totalBytesRead = new AtomicLong(0L);
        AtomicBoolean consumerTimeout = new AtomicBoolean(false);
        if (!config.hideHeader()) {
            if (config.showDetailedStats()) {
                Predef$.MODULE$.println((Object)"time, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            } else {
                Predef$.MODULE$.println((Object)"start.time, end.time, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            }
        }
        long startMs = 0L;
        long endMs = 0L;
        if (config.useNewConsumer()) {
            KafkaConsumer consumer = new KafkaConsumer(config.props());
            consumer.subscribe(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{config.topic()}))));
            startMs = System.currentTimeMillis();
            this.consume((KafkaConsumer<byte[], byte[]>)consumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{config.topic()})), config.numMessages(), 1000L, config, totalMessagesRead, totalBytesRead);
            endMs = System.currentTimeMillis();
            consumer.close();
        } else {
            ConsumerConfig consumerConfig = new ConsumerConfig(config.props());
            ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
            Map<String, List<KafkaStream<byte[], byte[]>>> topicMessageStreams = consumerConnector.createMessageStreams((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.topic()), (Object)BoxesRunTime.boxToInteger((int)config.numThreads()))}))));
            ObjectRef threadList = ObjectRef.create((Object)Nil$.MODULE$);
            topicMessageStreams.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, List<KafkaStream<byte[], byte[]>>> check$ifrefutable$1) {
                    Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(config, totalMessagesRead, totalBytesRead, consumerTimeout, threadList){
                public static final long serialVersionUID = 0L;
                public final ConsumerPerformance.ConsumerPerfConfig config$1;
                public final AtomicLong totalMessagesRead$1;
                public final AtomicLong totalBytesRead$1;
                public final AtomicBoolean consumerTimeout$1;
                public final ObjectRef threadList$1;

                public final void apply(Tuple2<String, List<KafkaStream<byte[], byte[]>>> x$1) {
                    Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple2 = x$1;
                    if (tuple2 != null) {
                        List streamList = (List)tuple2._2();
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), streamList.length()).foreach$mVc$sp((Function1)new Serializable(this, streamList){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.main.2 $outer;
                            private final List streamList$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.$outer.threadList$1.elem = ((List)this.$outer.threadList$1.elem).$colon$colon((Object)new ConsumerPerformance.ConsumerPerfThread(i, new StringBuilder().append((Object)"kafka-zk-consumer-").append((Object)BoxesRunTime.boxToInteger((int)i)).toString(), (KafkaStream)this.streamList$1.apply(i), this.$outer.config$1, this.$outer.totalMessagesRead$1, this.$outer.totalBytesRead$1, this.$outer.consumerTimeout$1));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.streamList$1 = streamList$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.config$1 = config$1;
                    this.totalMessagesRead$1 = totalMessagesRead$1;
                    this.totalBytesRead$1 = totalBytesRead$1;
                    this.consumerTimeout$1 = consumerTimeout$1;
                    this.threadList$1 = threadList$1;
                }
            });
            this.logger().info((Object)"Sleeping for 1 second.");
            Thread.sleep(1000L);
            this.logger().info((Object)"starting threads");
            startMs = System.currentTimeMillis();
            ((List)threadList.elem).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(ConsumerPerformance.ConsumerPerfThread thread) {
                    thread.start();
                }
            });
            ((List)threadList.elem).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(ConsumerPerformance.ConsumerPerfThread thread) {
                    thread.join();
                }
            });
            endMs = consumerTimeout.get() ? System.currentTimeMillis() - (long)consumerConfig.consumerTimeoutMs() : System.currentTimeMillis();
            consumerConnector.shutdown();
        }
        double elapsedSecs = (double)(endMs - startMs) / 1000.0;
        if (!config.showDetailedStats()) {
            double totalMBRead = (double)totalBytesRead.get() * 1.0 / (double)0x100000;
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %s, %.4f, %.4f, %d, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToDouble((double)totalMBRead), BoxesRunTime.boxToDouble((double)(totalMBRead / elapsedSecs)), BoxesRunTime.boxToLong((long)totalMessagesRead.get()), BoxesRunTime.boxToDouble((double)((double)totalMessagesRead.get() / elapsedSecs))})));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void consume(KafkaConsumer<byte[], byte[]> consumer, List<String> topics, long count, long timeout, ConsumerPerformance.ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead) {
        LongRef bytesRead = LongRef.create((long)0L);
        LongRef messagesRead = LongRef.create((long)0L);
        LongRef lastBytesRead = LongRef.create((long)0L);
        LongRef lastMessagesRead = LongRef.create((long)0L);
        int joinTimeout = 10000;
        AtomicBoolean isAssigned = new AtomicBoolean(false);
        consumer.subscribe(JavaConversions$.MODULE$.seqAsJavaList(topics), new ConsumerRebalanceListener(isAssigned){
            private final AtomicBoolean isAssigned$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.isAssigned$1.set(true);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                this.isAssigned$1.set(false);
            }
            {
                this.isAssigned$1 = isAssigned$1;
            }
        });
        long joinStart = System.currentTimeMillis();
        while (true) {
            void var14_12;
            void var16_14;
            if (isAssigned.get()) {
                consumer.seekToBeginning(new TopicPartition[0]);
                long startMs = System.currentTimeMillis();
                LongRef lastReportTime = LongRef.create((long)startMs);
                long lastConsumedTime = System.currentTimeMillis();
                while (messagesRead.elem < count && System.currentTimeMillis() - lastConsumedTime <= timeout) {
                    ConsumerRecords records = consumer.poll(100L);
                    if (records.count() > 0) {
                        lastConsumedTime = System.currentTimeMillis();
                    }
                    JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)records).foreach((Function1)new Serializable(config, bytesRead, messagesRead, lastBytesRead, lastMessagesRead, lastReportTime){
                        public static final long serialVersionUID = 0L;
                        private final ConsumerPerformance.ConsumerPerfConfig config$2;
                        private final LongRef bytesRead$1;
                        private final LongRef messagesRead$1;
                        private final LongRef lastBytesRead$1;
                        private final LongRef lastMessagesRead$1;
                        private final LongRef lastReportTime$1;

                        public final void apply(ConsumerRecord<byte[], byte[]> record) {
                            ++this.messagesRead$1.elem;
                            if (record.key() != null) {
                                this.bytesRead$1.elem += (long)Predef$.MODULE$.byteArrayOps((byte[])record.key()).size();
                            }
                            if (record.value() != null) {
                                this.bytesRead$1.elem += (long)Predef$.MODULE$.byteArrayOps((byte[])record.value()).size();
                            }
                            if (this.messagesRead$1.elem % (long)this.config$2.reportingInterval() == 0L) {
                                if (this.config$2.showDetailedStats()) {
                                    ConsumerPerformance$.MODULE$.printProgressMessage(0, this.bytesRead$1.elem, this.lastBytesRead$1.elem, this.messagesRead$1.elem, this.lastMessagesRead$1.elem, this.lastReportTime$1.elem, System.currentTimeMillis(), this.config$2.dateFormat());
                                }
                                this.lastReportTime$1.elem = System.currentTimeMillis();
                                this.lastMessagesRead$1.elem = this.messagesRead$1.elem;
                                this.lastBytesRead$1.elem = this.bytesRead$1.elem;
                            }
                        }
                        {
                            this.config$2 = config$2;
                            this.bytesRead$1 = bytesRead$1;
                            this.messagesRead$1 = messagesRead$1;
                            this.lastBytesRead$1 = lastBytesRead$1;
                            this.lastMessagesRead$1 = lastMessagesRead$1;
                            this.lastReportTime$1 = lastReportTime$1;
                        }
                    });
                }
                totalMessagesRead.set(messagesRead.elem);
                totalBytesRead.set(bytesRead.elem);
                return;
            }
            if (System.currentTimeMillis() - var16_14 >= (long)var14_12) {
                throw new Exception("Timed out waiting for initial group join.");
            }
            consumer.poll(100L);
        }
    }

    public void printProgressMessage(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, SimpleDateFormat dateFormat) {
        double elapsedMs = endMs - startMs;
        double totalMBRead = (double)bytesRead * 1.0 / (double)0x100000;
        double mbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %d, %.4f, %.4f, %d, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dateFormat.format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)id), BoxesRunTime.boxToDouble((double)totalMBRead), BoxesRunTime.boxToDouble((double)(1000.0 * (mbRead / elapsedMs))), BoxesRunTime.boxToLong((long)messagesRead), BoxesRunTime.boxToDouble((double)((double)(messagesRead - lastMessagesRead) / elapsedMs * 1000.0))})));
    }

    private ConsumerPerformance$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
    }
}

