/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$$anonfun$kafka$tools$DumpLogSegments$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.Record;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class DumpLogSegments$ {
    public static final DumpLogSegments$ MODULE$;

    static {
        new DumpLogSegments$();
    }

    public void main(String[] args) {
        DumpLogSegments.MessageParser<String, String> messageParser;
        OptionParser parser = new OptionParser();
        OptionSpecBuilder printOpt = parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        OptionSpecBuilder verifyOpt = parser.accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        OptionSpecBuilder indexSanityOpt = parser.accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        ArgumentAcceptingOptionSpec filesOpt = parser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        ArgumentAcceptingOptionSpec maxMessageSizeOpt = parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        OptionSpecBuilder deepIterationOpt = parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration.");
        ArgumentAcceptingOptionSpec valueDecoderOpt = parser.accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec keyDecoderOpt = parser.accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        OptionSpecBuilder offsetsOpt = parser.accepts("offsets-decoder", "if set, log data will be parsed as offset data from __consumer_offsets topic.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{filesOpt}));
        boolean printDataLog = options.has((OptionSpec)printOpt) || options.has((OptionSpec)offsetsOpt) || options.has((OptionSpec)valueDecoderOpt) || options.has((OptionSpec)keyDecoderOpt);
        boolean verifyOnly = options.has((OptionSpec)verifyOpt);
        boolean indexSanityOnly = options.has((OptionSpec)indexSanityOpt);
        String[] files = ((String)options.valueOf((OptionSpec)filesOpt)).split(",");
        int maxMessageSize = (Integer)options.valueOf((OptionSpec)maxMessageSizeOpt);
        boolean isDeepIteration = options.has((OptionSpec)deepIterationOpt);
        if (options.has((OptionSpec)offsetsOpt)) {
            messageParser = new DumpLogSegments.OffsetsMessageParser();
        } else {
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)options.valueOf((OptionSpec)valueDecoderOpt), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)options.valueOf((OptionSpec)keyDecoderOpt), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            messageParser = new DumpLogSegments.DecoderMessageParser(keyDecoder, valueDecoder);
        }
        DumpLogSegments.OffsetsMessageParser messageParser2 = messageParser;
        HashMap misMatchesForIndexFilesMap = new HashMap();
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        HashMap nonConsecutivePairsForLogFilesMap = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(printDataLog, verifyOnly, indexSanityOnly, maxMessageSize, isDeepIteration, messageParser2, misMatchesForIndexFilesMap, timeIndexDumpErrors, nonConsecutivePairsForLogFilesMap){
            public static final long serialVersionUID = 0L;
            private final boolean printDataLog$1;
            private final boolean verifyOnly$1;
            private final boolean indexSanityOnly$1;
            private final int maxMessageSize$1;
            private final boolean isDeepIteration$1;
            private final DumpLogSegments.MessageParser messageParser$1;
            private final HashMap misMatchesForIndexFilesMap$1;
            private final DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1;
            private final HashMap nonConsecutivePairsForLogFilesMap$1;

            public final void apply(String arg) {
                File file = new File(arg);
                if (file.getName().endsWith(Log$.MODULE$.LogFileSuffix())) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Dumping ").append((Object)file).toString());
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpLog(file, this.printDataLog$1, (HashMap<String, List<Tuple2<Object, Object>>>)this.nonConsecutivePairsForLogFilesMap$1, this.isDeepIteration$1, this.maxMessageSize$1, this.messageParser$1);
                } else if (file.getName().endsWith(Log$.MODULE$.IndexFileSuffix())) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Dumping ").append((Object)file).toString());
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpIndex(file, this.indexSanityOnly$1, this.verifyOnly$1, (HashMap<String, List<Tuple2<Object, Object>>>)this.misMatchesForIndexFilesMap$1, this.maxMessageSize$1);
                } else if (file.getName().endsWith(Log$.MODULE$.TimeIndexFileSuffix())) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Dumping ").append((Object)file).toString());
                    DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$dumpTimeIndex(file, this.indexSanityOnly$1, this.verifyOnly$1, this.timeIndexDumpErrors$1, this.maxMessageSize$1);
                }
            }
            {
                this.printDataLog$1 = printDataLog$1;
                this.verifyOnly$1 = verifyOnly$1;
                this.indexSanityOnly$1 = indexSanityOnly$1;
                this.maxMessageSize$1 = maxMessageSize$1;
                this.isDeepIteration$1 = isDeepIteration$1;
                this.messageParser$1 = messageParser$1;
                this.misMatchesForIndexFilesMap$1 = misMatchesForIndexFilesMap$1;
                this.timeIndexDumpErrors$1 = timeIndexDumpErrors$1;
                this.nonConsecutivePairsForLogFilesMap$1 = nonConsecutivePairsForLogFilesMap$1;
            }
        });
        misMatchesForIndexFilesMap.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$1) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String fileName = (String)tuple2._1();
                    List listOfMismatches = (List)tuple2._2();
                    System.err.println(new StringBuilder().append((Object)"Mismatches in :").append((Object)fileName).toString());
                    listOfMismatches.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> m) {
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index offset: %d, log offset: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        timeIndexDumpErrors.printErrors();
        nonConsecutivePairsForLogFilesMap.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, List<Tuple2<Object, Object>>> x0$2) {
                Tuple2<String, List<Tuple2<Object, Object>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String fileName = (String)tuple2._1();
                    List listOfNonConsecutivePairs = (List)tuple2._2();
                    System.err.println(new StringBuilder().append((Object)"Non-secutive offsets in :").append((Object)fileName).toString());
                    listOfNonConsecutivePairs.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> m) {
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  %d is followed by %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void kafka$tools$DumpLogSegments$$dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, HashMap<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            try {
                long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
                File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder().append((Object)file.getName().split("\\.")[0]).append((Object)Log$.MODULE$.LogFileSuffix()).toString());
                FileRecords fileRecords = FileRecords.open((File)logFile, (boolean)false);
                OffsetIndex index = new OffsetIndex(file, startOffset, OffsetIndex$.MODULE$.$lessinit$greater$default$3());
                if (indexSanityOnly) {
                    index.sanityCheck();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                    return;
                }
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index.entries()).foreach$mVc$sp((Function1)new Serializable(file, verifyOnly, misMatchesForIndexFilesMap, maxMessageSize, fileRecords, index, object){
                    public static final long serialVersionUID = 0L;
                    private final File file$2;
                    private final boolean verifyOnly$2;
                    private final HashMap misMatchesForIndexFilesMap$2;
                    private final int maxMessageSize$2;
                    private final FileRecords fileRecords$1;
                    private final OffsetIndex index$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        BoxedUnit boxedUnit;
                        OffsetPosition entry2 = this.index$1.entry(i);
                        FileRecords slice = this.fileRecords$1.read(entry2.position(), this.maxMessageSize$2);
                        LogEntry logEntry = (LogEntry)DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$getIterator((LogEntry)slice.shallowEntries().iterator().next(), true).next();
                        if (logEntry.offset() != entry2.offset() + this.index$1.baseOffset()) {
                            List misMatchesSeq = (List)this.misMatchesForIndexFilesMap$2.getOrElse((Object)this.file$2.getAbsolutePath(), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final List<Tuple2<Object, Object>> apply() {
                                    return Nil$.MODULE$;
                                }
                            });
                            misMatchesSeq = misMatchesSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(entry2.offset() + this.index$1.baseOffset(), logEntry.offset()));
                            boxedUnit = this.misMatchesForIndexFilesMap$2.put((Object)this.file$2.getAbsolutePath(), (Object)misMatchesSeq);
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        if (entry2.offset() == 0L && i > 0) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        if (!this.verifyOnly$2) {
                            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("offset: %d position: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(entry2.offset() + this.index$1.baseOffset())), BoxesRunTime.boxToInteger((int)entry2.position())})));
                        }
                    }
                    {
                        this.file$2 = file$2;
                        this.verifyOnly$2 = verifyOnly$2;
                        this.misMatchesForIndexFilesMap$2 = misMatchesForIndexFilesMap$2;
                        this.maxMessageSize$2 = maxMessageSize$2;
                        this.fileRecords$1 = fileRecords$1;
                        this.index$1 = index$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public void kafka$tools$DumpLogSegments$$dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors, int maxMessageSize) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            try {
                long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
                File logFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder().append((Object)file.getName().split("\\.")[0]).append((Object)Log$.MODULE$.LogFileSuffix()).toString());
                FileRecords fileRecords = FileRecords.open((File)logFile, (boolean)false);
                File indexFile = new File(file.getAbsoluteFile().getParent(), new StringBuilder().append((Object)file.getName().split("\\.")[0]).append((Object)Log$.MODULE$.IndexFileSuffix()).toString());
                OffsetIndex index = new OffsetIndex(indexFile, startOffset, OffsetIndex$.MODULE$.$lessinit$greater$default$3());
                TimeIndex timeIndex = new TimeIndex(file, startOffset, TimeIndex$.MODULE$.$lessinit$greater$default$3());
                if (indexSanityOnly) {
                    timeIndex.sanityCheck();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                    return;
                }
                LongRef prevTimestamp = LongRef.create((long)-1L);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), timeIndex.entries()).foreach$mVc$sp((Function1)new Serializable(file, verifyOnly, timeIndexDumpErrors, fileRecords, index, timeIndex, prevTimestamp, object){
                    public static final long serialVersionUID = 0L;
                    private final File file$3;
                    private final boolean verifyOnly$3;
                    private final DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$2;
                    private final FileRecords fileRecords$2;
                    private final OffsetIndex index$2;
                    public final TimeIndex timeIndex$1;
                    private final LongRef prevTimestamp$1;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Option option;
                        block10: {
                            TimestampOffset entry2;
                            block8: {
                                Some some;
                                boolean bl;
                                LongRef maxTimestamp;
                                block9: {
                                    block7: {
                                        entry2 = this.timeIndex$1.entry(i);
                                        int position = this.index$2.lookup(entry2.offset() + this.timeIndex$1.baseOffset()).position();
                                        FileRecords partialFileRecords = this.fileRecords$2.read(position, Integer.MAX_VALUE);
                                        Iterable shallowEntries = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(partialFileRecords.shallowEntries()).asScala();
                                        maxTimestamp = LongRef.create((long)-1L);
                                        Option maybeLogEntry = shallowEntries.find((Function1)new Serializable(this, entry2){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$kafka$tools$DumpLogSegments$$dumpTimeIndex$1 $outer;
                                            private final TimestampOffset entry$1;

                                            public final boolean apply(FileLogInputStream.FileChannelLogEntry x$1) {
                                                return x$1.offset() >= this.entry$1.offset() + this.$outer.timeIndex$1.baseOffset();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.entry$1 = entry$1;
                                            }
                                        });
                                        bl = false;
                                        some = null;
                                        option = maybeLogEntry;
                                        if (!None$.MODULE$.equals(option)) break block7;
                                        this.timeIndexDumpErrors$2.recordShallowOffsetNotFound(this.file$3, entry2.offset() + this.timeIndex$1.baseOffset(), -1);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block8;
                                    }
                                    if (!(option instanceof Some)) break block9;
                                    bl = true;
                                    some = (Some)option;
                                    FileLogInputStream.FileChannelLogEntry logEntry = (FileLogInputStream.FileChannelLogEntry)some.x();
                                    if (logEntry.offset() == entry2.offset() + this.timeIndex$1.baseOffset()) break block9;
                                    this.timeIndexDumpErrors$2.recordShallowOffsetNotFound(this.file$3, entry2.offset() + this.timeIndex$1.baseOffset(), logEntry.offset());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block8;
                                }
                                if (!bl) break block10;
                                FileLogInputStream.FileChannelLogEntry shallowLogEntry = (FileLogInputStream.FileChannelLogEntry)some.x();
                                Iterator<LogEntry> deepIter = DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$getIterator((LogEntry)shallowLogEntry, true);
                                deepIter.foreach((Function1)new Serializable(this, maxTimestamp){
                                    public static final long serialVersionUID = 0L;
                                    private final LongRef maxTimestamp$1;

                                    public final void apply(LogEntry deepLogEntry) {
                                        this.maxTimestamp$1.elem = scala.math.package$.MODULE$.max(this.maxTimestamp$1.elem, deepLogEntry.record().timestamp());
                                    }
                                    {
                                        this.maxTimestamp$1 = maxTimestamp$1;
                                    }
                                });
                                if (maxTimestamp.elem != entry2.timestamp()) {
                                    this.timeIndexDumpErrors$2.recordMismatchTimeIndex(this.file$3, entry2.timestamp(), maxTimestamp.elem);
                                }
                                if (this.prevTimestamp$1.elem >= entry2.timestamp()) {
                                    this.timeIndexDumpErrors$2.recordOutOfOrderIndexTimestamp(this.file$3, entry2.timestamp(), this.prevTimestamp$1.elem);
                                }
                                if (entry2.offset() == 0L && i > 0) {
                                    throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey2$1, BoxedUnit.UNIT);
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            if (!this.verifyOnly$3) {
                                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("timestamp: %s offset: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)entry2.timestamp()), BoxesRunTime.boxToLong((long)(this.timeIndex$1.baseOffset() + entry2.offset()))})));
                            }
                            this.prevTimestamp$1.elem = entry2.timestamp();
                            return;
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        this.file$3 = file$3;
                        this.verifyOnly$3 = verifyOnly$3;
                        this.timeIndexDumpErrors$2 = timeIndexDumpErrors$2;
                        this.fileRecords$2 = fileRecords$2;
                        this.index$2 = index$2;
                        this.timeIndex$1 = timeIndex$1;
                        this.prevTimestamp$1 = prevTimestamp$1;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public void kafka$tools$DumpLogSegments$$dumpLog(File file, boolean printContents, HashMap<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, DumpLogSegments.MessageParser<?, ?> parser) {
        long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Starting offset: ").append((Object)BoxesRunTime.boxToLong((long)startOffset)).toString());
        FileRecords messageSet = FileRecords.open((File)file, (boolean)false);
        LongRef validBytes = LongRef.create((long)0L);
        LongRef lastOffset = LongRef.create((long)-1L);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(messageSet.shallowEntries(maxMessageSize)).asScala()).foreach((Function1)new Serializable(file, printContents, nonConsecutivePairsForLogFilesMap, isDeepIteration, parser, validBytes, lastOffset){
            public static final long serialVersionUID = 0L;
            public final File file$1;
            public final boolean printContents$1;
            public final HashMap nonConsecutivePairsForLogFilesMap$2;
            private final boolean isDeepIteration$2;
            public final DumpLogSegments.MessageParser parser$1;
            public final LongRef validBytes$1;
            public final LongRef lastOffset$1;

            public final void apply(FileLogInputStream.FileChannelLogEntry shallowLogEntry) {
                Iterator<LogEntry> itr = DumpLogSegments$.MODULE$.kafka$tools$DumpLogSegments$$getIterator((LogEntry)shallowLogEntry, this.isDeepIteration$2);
                itr.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$kafka$tools$DumpLogSegments$$dumpLog$1 $outer;

                    public final void apply(LogEntry deepLogEntry) {
                        BoxedUnit boxedUnit;
                        Record record2 = deepLogEntry.record();
                        if (this.$outer.lastOffset$1.elem == -1L) {
                            this.$outer.lastOffset$1.elem = deepLogEntry.offset();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            CompressionType compressionType = record2.compressionType();
                            CompressionType compressionType2 = CompressionType.NONE;
                            if (!(compressionType != null ? !compressionType.equals(compressionType2) : compressionType2 != null) && deepLogEntry.offset() != this.$outer.lastOffset$1.elem + 1L) {
                                List nonConsecutivePairsSeq = (List)this.$outer.nonConsecutivePairsForLogFilesMap$2.getOrElse((Object)this.$outer.file$1.getAbsolutePath(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final List<Tuple2<Object, Object>> apply() {
                                        return Nil$.MODULE$;
                                    }
                                });
                                nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(this.$outer.lastOffset$1.elem, deepLogEntry.offset()));
                                boxedUnit = this.$outer.nonConsecutivePairsForLogFilesMap$2.put((Object)this.$outer.file$1.getAbsolutePath(), (Object)nonConsecutivePairsSeq);
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        this.$outer.lastOffset$1.elem = deepLogEntry.offset();
                        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"offset: ").append((Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset())).append((Object)" position: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.validBytes$1.elem)).append((Object)" ").append((Object)record2.timestampType()).append((Object)": ").append((Object)BoxesRunTime.boxToLong((long)record2.timestamp())).append((Object)" isvalid: ").append((Object)BoxesRunTime.boxToBoolean((boolean)record2.isValid())).append((Object)" payloadsize: ").append((Object)BoxesRunTime.boxToInteger((int)record2.valueSize())).append((Object)" magic: ").append((Object)BoxesRunTime.boxToByte((byte)record2.magic())).append((Object)" compresscodec: ").append((Object)record2.compressionType()).append((Object)" crc: ").append((Object)BoxesRunTime.boxToLong((long)record2.checksum())).toString());
                        if (record2.hasKey()) {
                            Predef$.MODULE$.print((Object)new StringBuilder().append((Object)" keysize: ").append((Object)BoxesRunTime.boxToInteger((int)record2.keySize())).toString());
                        }
                        if (this.$outer.printContents$1) {
                            Tuple2<Option<K>, Option<V>> tuple2 = this.$outer.parser$1.parse(record2);
                            if (tuple2 != null) {
                                Tuple2 tuple22;
                                Option key = (Option)tuple2._1();
                                Option payload = (Option)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)key, (Object)payload);
                                Option key2 = (Option)tuple23._1();
                                Option payload2 = (Option)tuple23._2();
                                key2.foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply(Object key) {
                                        Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
                                    }
                                });
                                payload2.foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply(Object payload) {
                                        Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" payload: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{payload})));
                                    }
                                });
                            } else {
                                throw new MatchError(tuple2);
                            }
                        }
                        Predef$.MODULE$.println();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.validBytes$1.elem += (long)shallowLogEntry.sizeInBytes();
            }
            {
                this.file$1 = file$1;
                this.printContents$1 = printContents$1;
                this.nonConsecutivePairsForLogFilesMap$2 = nonConsecutivePairsForLogFilesMap$2;
                this.isDeepIteration$2 = isDeepIteration$2;
                this.parser$1 = parser$1;
                this.validBytes$1 = validBytes$1;
                this.lastOffset$1 = lastOffset$1;
            }
        });
        long trailingBytes = (long)messageSet.sizeInBytes() - validBytes.elem;
        if (trailingBytes > 0L) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Found %d invalid bytes at the end of %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)trailingBytes), file.getName()})));
        }
    }

    public Iterator<LogEntry> kafka$tools$DumpLogSegments$$getIterator(LogEntry logEntry, boolean isDeepIteration) {
        return isDeepIteration ? (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(logEntry.iterator()).asScala() : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogEntry[]{logEntry}));
    }

    private DumpLogSegments$() {
        MODULE$ = this;
    }
}

