/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.api.OffsetRequest$;
import kafka.consumer.BaseConsumer;
import kafka.consumer.BaseConsumerRecord;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.NewShinyConsumer$;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CT3x'\"Lg._\"p]N,X.\u001a:\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u00051\u0011\u0015m]3D_:\u001cX/\\3s\u0011!\u0019\u0002A!A!\u0002\u0013!\u0012!\u0002;pa&\u001c\u0007cA\u0005\u0016/%\u0011aC\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005aYbBA\u0005\u001a\u0013\tQ\"\"\u0001\u0004Qe\u0016$WMZ\u0005\u00039u\u0011aa\u0015;sS:<'B\u0001\u000e\u000b\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013a\u00039beRLG/[8o\u0013\u0012\u00042!C\u000b\"!\tI!%\u0003\u0002$\u0015\t\u0019\u0011J\u001c;\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019\naa\u001c4gg\u0016$\bcA\u0005\u0016OA\u0011\u0011\u0002K\u0005\u0003S)\u0011A\u0001T8oO\"A1\u0006\u0001B\u0001B\u0003%A#A\u0005xQ&$X\r\\5ti\"AQ\u0006\u0001B\u0001B\u0003%a&A\u0007d_:\u001cX/\\3s!J|\u0007o\u001d\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nA!\u001e;jY*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\to\u0001\u0011)\u0019!C\u0001q\u0005IA/[7f_V$Xj]\u000b\u0002O!A!\b\u0001B\u0001B\u0003%q%\u0001\u0006uS6,w.\u001e;Ng\u0002BQ\u0001\u0010\u0001\u0005\u0002u\na\u0001P5oSRtDc\u0002 @\u0001\u0006\u00135\t\u0012\t\u0003\u001f\u0001AQaE\u001eA\u0002QAQaH\u001eA\u0002\u0001BQ!J\u001eA\u0002\u0019BQaK\u001eA\u0002QAQ!L\u001eA\u00029BqaN\u001e\u0011\u0002\u0003\u0007q\u0005C\u0004\u0004\u0001\t\u0007I\u0011\u0001$\u0016\u0003\u001d\u0003B\u0001S)T'6\t\u0011J\u0003\u0002\u0004\u0015*\u00111\nT\u0001\bG2LWM\u001c;t\u0015\t)QJ\u0003\u0002O\u001f\u00061\u0011\r]1dQ\u0016T\u0011\u0001U\u0001\u0004_J<\u0017B\u0001*J\u00055Y\u0015MZ6b\u0007>t7/^7feB\u0019\u0011\u0002\u0016,\n\u0005US!!B!se\u0006L\bCA\u0005X\u0013\tA&B\u0001\u0003CsR,\u0007B\u0002.\u0001A\u0003%q)A\u0005d_:\u001cX/\\3sA!9A\f\u0001a\u0001\n\u0003i\u0016A\u0003:fG>\u0014H-\u0013;feV\ta\fE\u00020?\u0006L!\u0001\u0019\u0019\u0003\u0011%#XM]1u_J\u0004B\u0001\u00132T'&\u00111-\u0013\u0002\u000f\u0007>t7/^7feJ+7m\u001c:e\u0011\u001d)\u0007\u00011A\u0005\u0002\u0019\faB]3d_J$\u0017\n^3s?\u0012*\u0017\u000f\u0006\u0002hUB\u0011\u0011\u0002[\u0005\u0003S*\u0011A!\u00168ji\"91\u000eZA\u0001\u0002\u0004q\u0016a\u0001=%c!1Q\u000e\u0001Q!\ny\u000b1B]3d_J$\u0017\n^3sA!)q\u000e\u0001C\u0001a\u0006a1m\u001c8tk6,'/\u00138jiR\tq\rC\u0003s\u0001\u0011\u00051/\u0001\u0003tK\u0016\\G\u0003B4ukZDQaE9A\u0002]AQaH9A\u0002\u0005BQ!J9A\u0002\u001dBQ\u0001\u001f\u0001\u0005Be\fqA]3dK&4X\rF\u0001{!\ty10\u0003\u0002}\u0005\t\u0011\")Y:f\u0007>t7/^7feJ+7m\u001c:e\u0011\u0015q\b\u0001\"\u0011q\u0003\u0011\u0019Ho\u001c9\t\r\u0005\u0005\u0001\u0001\"\u0011q\u0003\u001d\u0019G.Z1okBDa!!\u0002\u0001\t\u0003\u0002\u0018AB2p[6LGoB\u0005\u0002\n\t\t\t\u0011#\u0001\u0002\f\u0005\u0001b*Z<TQ&t\u0017pQ8ogVlWM\u001d\t\u0004\u001f\u00055a\u0001C\u0001\u0003\u0003\u0003E\t!a\u0004\u0014\u0007\u00055\u0001\u0002C\u0004=\u0003\u001b!\t!a\u0005\u0015\u0005\u0005-\u0001BCA\f\u0003\u001b\t\n\u0011\"\u0001\u0002\u001a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"!a\u0007+\u0007\u001d\nib\u000b\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!C;oG\",7m[3e\u0015\r\tICC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0017\u0003G\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class NewShinyConsumer
implements BaseConsumer {
    private final Option<String> topic;
    private final Option<Object> partitionId;
    private final Option<Object> offset;
    private final Option<String> whitelist;
    private final long timeoutMs;
    private final KafkaConsumer<byte[], byte[]> consumer;
    private Iterator<ConsumerRecord<byte[], byte[]>> recordIter;

    public static long $lessinit$greater$default$6() {
        return NewShinyConsumer$.MODULE$.$lessinit$greater$default$6();
    }

    public long timeoutMs() {
        return this.timeoutMs;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public Iterator<ConsumerRecord<byte[], byte[]>> recordIter() {
        return this.recordIter;
    }

    public void recordIter_$eq(Iterator<ConsumerRecord<byte[], byte[]>> x$1) {
        this.recordIter = x$1;
    }

    public void consumerInit() {
        block6: {
            block3: {
                Tuple4 tuple4;
                block5: {
                    block4: {
                        block2: {
                            tuple4 = new Tuple4(this.topic, this.partitionId, this.offset, this.whitelist);
                            if (tuple4 == null) break block2;
                            Option option = (Option)tuple4._1();
                            Option option2 = (Option)tuple4._2();
                            Option option3 = (Option)tuple4._3();
                            Option option4 = (Option)tuple4._4();
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String topic = (String)some.x();
                            if (!(option2 instanceof Some)) break block2;
                            Some some2 = (Some)option2;
                            int partitionId = BoxesRunTime.unboxToInt((Object)some2.x());
                            if (!(option3 instanceof Some)) break block2;
                            Some some3 = (Some)option3;
                            long offset = BoxesRunTime.unboxToLong((Object)some3.x());
                            if (!None$.MODULE$.equals(option4)) break block2;
                            this.seek(topic, partitionId, offset);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (tuple4 == null) break block4;
                        Option option = (Option)tuple4._1();
                        Option option5 = (Option)tuple4._2();
                        Option option6 = (Option)tuple4._3();
                        Option option7 = (Option)tuple4._4();
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        String topic = (String)some.x();
                        if (!(option5 instanceof Some)) break block4;
                        Some some4 = (Some)option5;
                        int partitionId = BoxesRunTime.unboxToInt((Object)some4.x());
                        if (!None$.MODULE$.equals(option6) || !None$.MODULE$.equals(option7)) break block4;
                        this.seek(topic, partitionId, OffsetRequest$.MODULE$.LatestTime());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (tuple4 == null) break block5;
                    Option option = (Option)tuple4._1();
                    Option option8 = (Option)tuple4._2();
                    Option option9 = (Option)tuple4._3();
                    Option option10 = (Option)tuple4._4();
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    String topic = (String)some.x();
                    if (!None$.MODULE$.equals(option8) || !None$.MODULE$.equals(option9) || !None$.MODULE$.equals(option10)) break block5;
                    this.consumer().subscribe(Collections.singletonList(topic));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (tuple4 == null) break block6;
                Option option = (Option)tuple4._1();
                Option option11 = (Option)tuple4._2();
                Option option12 = (Option)tuple4._3();
                Option option13 = (Option)tuple4._4();
                if (!None$.MODULE$.equals(option) || !None$.MODULE$.equals(option11) || !None$.MODULE$.equals(option12) || !(option13 instanceof Some)) break block6;
                Some some = (Some)option13;
                String whitelist = (String)some.x();
                this.consumer().subscribe(Pattern.compile(whitelist), (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException("An invalid combination of arguments is provided. Exactly one of 'topic' or 'whitelist' must be provided. If 'topic' is provided, an optional 'partition' may also be provided. If 'partition' is provided, an optional 'offset' may also be provided, otherwise, consumption starts from the end of the partition.");
    }

    public void seek(String topic, int partitionId, long offset) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        this.consumer().assign(Collections.singletonList(topicPartition));
        long l = offset;
        if (OffsetRequest$.MODULE$.EarliestTime() == l) {
            this.consumer().seekToBeginning(Collections.singletonList(topicPartition));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OffsetRequest$.MODULE$.LatestTime() == l) {
            this.consumer().seekToEnd(Collections.singletonList(topicPartition));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.consumer().seek(topicPartition, offset);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public BaseConsumerRecord receive() {
        block3: {
            block2: {
                if (this.recordIter().hasNext()) break block2;
                this.recordIter_$eq(this.consumer().poll(this.timeoutMs()).iterator());
                if (!this.recordIter().hasNext()) break block3;
            }
            ConsumerRecord<byte[], byte[]> record2 = this.recordIter().next();
            return new BaseConsumerRecord(record2.topic(), record2.partition(), record2.offset(), record2.timestamp(), record2.timestampType(), (byte[])record2.key(), (byte[])record2.value());
        }
        throw new ConsumerTimeoutException();
    }

    @Override
    public void stop() {
        this.consumer().wakeup();
    }

    @Override
    public void cleanup() {
        this.consumer().close();
    }

    @Override
    public void commit() {
        this.consumer().commitSync();
    }

    public NewShinyConsumer(Option<String> topic, Option<Object> partitionId, Option<Object> offset, Option<String> whitelist, Properties consumerProps, long timeoutMs) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.offset = offset;
        this.whitelist = whitelist;
        this.timeoutMs = timeoutMs;
        this.consumer = new KafkaConsumer(consumerProps);
        this.consumerInit();
        this.recordIter = this.consumer().poll(0L).iterator();
    }
}

