/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.common.TopicAndPartition;
import kafka.server.Constants$;
import kafka.server.QuotaType;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.SensorAccess;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001\u001d\u0011qCU3qY&\u001c\u0017\r^5p]F+x\u000e^1NC:\fw-\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u000f)A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011ABU3qY&\u001c\u0017-U;pi\u0006D\u0001\"\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\u0007G>tg-[4\u0016\u0003m\u0001\"!\u0006\u000f\n\u0005u\u0011!!\b*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\t\u0011}\u0001!\u0011!Q\u0001\nm\tqaY8oM&<\u0007\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0003#\u0003\u001diW\r\u001e:jGN,\u0012a\t\t\u0003I5j\u0011!\n\u0006\u0003C\u0019R!a\n\u0015\u0002\r\r|W.\\8o\u0015\t)\u0011F\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018&\u0005\u001diU\r\u001e:jGND\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IaI\u0001\t[\u0016$(/[2tA!A!\u0007\u0001BC\u0002\u0013%1'A\bsKBd\u0017nY1uS>tG+\u001f9f+\u0005!\u0004CA\u000b6\u0013\t1$AA\u0005Rk>$\u0018\rV=qK\"A\u0001\b\u0001B\u0001B\u0003%A'\u0001\tsKBd\u0017nY1uS>tG+\u001f9fA!A!\b\u0001BC\u0002\u0013%1(\u0001\u0003uS6,W#\u0001\u001f\u0011\u0005uzT\"\u0001 \u000b\u0005E1\u0013B\u0001!?\u0005\u0011!\u0016.\\3\t\u0011\t\u0003!\u0011!Q\u0001\nq\nQ\u0001^5nK\u0002BQ\u0001\u0012\u0001\u0005\u0002\u0015\u000ba\u0001P5oSRtD#\u0002$H\u0011&S\u0005CA\u000b\u0001\u0011\u0015I2\t1\u0001\u001c\u0011\u0015\t3\t1\u0001$\u0011\u0015\u00114\t1\u00015\u0011\u0015Q4\t1\u0001=\u0011\u001da\u0005A1A\u0005\n5\u000bA\u0001\\8dWV\ta\n\u0005\u0002P16\t\u0001K\u0003\u0002R%\u0006)An\\2lg*\u00111\u000bV\u0001\u000bG>t7-\u001e:sK:$(BA+W\u0003\u0011)H/\u001b7\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0015\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\"11\f\u0001Q\u0001\n9\u000bQ\u0001\\8dW\u0002Bq!\u0018\u0001C\u0002\u0013%a,A\nuQJ|G\u000f\u001e7fIB\u000b'\u000f^5uS>t7/F\u0001`!\u0011\u0001\u0017m\u00196\u000e\u0003IK!A\u0019*\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002eO:\u0011\u0011\"Z\u0005\u0003M*\ta\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011aM\u0003\t\u0004WN4hB\u00017r\u001d\ti\u0007/D\u0001o\u0015\tyg!\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011!OC\u0001\ba\u0006\u001c7.Y4f\u0013\t!XOA\u0002TKFT!A\u001d\u0006\u0011\u0005%9\u0018B\u0001=\u000b\u0005\rIe\u000e\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B0\u0002)QD'o\u001c;uY\u0016$\u0007+\u0019:uSRLwN\\:!\u0011\u001da\b\u00011A\u0005\nu\fQ!];pi\u0006,\u0012A \t\u0003I}L1!!\u0001&\u0005\u0015\tVo\u001c;b\u0011%\t)\u0001\u0001a\u0001\n\u0013\t9!A\u0005rk>$\u0018m\u0018\u0013fcR!\u0011\u0011BA\b!\rI\u00111B\u0005\u0004\u0003\u001bQ!\u0001B+oSRD\u0011\"!\u0005\u0002\u0004\u0005\u0005\t\u0019\u0001@\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0016\u0001\u0001\u000b\u0015\u0002@\u0002\rE,x\u000e^1!\u0011%\tI\u0002\u0001b\u0001\n\u0013\tY\"\u0001\u0007tK:\u001cxN]!dG\u0016\u001c8/\u0006\u0002\u0002\u001eA\u0019Q#a\b\n\u0007\u0005\u0005\"A\u0001\u0007TK:\u001cxN]!dG\u0016\u001c8\u000f\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u000f\u00035\u0019XM\\:pe\u0006\u001b7-Z:tA!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111F\u0001\u000fe\u0006$X-T3ue&\u001cg*Y7f+\t\ti\u0003\u0005\u0003\u00020\u0005ER\"\u0001\u0014\n\u0007\u0005MbE\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016D\u0001\"a\u000e\u0001A\u0003%\u0011QF\u0001\u0010e\u0006$X-T3ue&\u001cg*Y7fA!9\u00111\b\u0001\u0005\u0002\u0005u\u0012aC;qI\u0006$X-U;pi\u0006$B!!\u0003\u0002@!1A0!\u000fA\u0002yDq!a\u0011\u0001\t\u0003\n)%A\bjgF+x\u000e^1Fq\u000e,W\rZ3e)\t\t9\u0005E\u0002\n\u0003\u0013J1!a\u0013\u000b\u0005\u001d\u0011un\u001c7fC:Dq!a\u0014\u0001\t\u0003\n\t&A\u0006jgRC'o\u001c;uY\u0016$G\u0003BA$\u0003'B\u0001\"!\u0016\u0002N\u0001\u0007\u0011qK\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\tI&!\u0018\u000e\u0005\u0005m#BA\u0014\u0005\u0013\u0011\ty&a\u0017\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002d\u0001!\t!!\u001a\u0002\rI,7m\u001c:e)\u0011\tI!a\u001a\t\u0011\u0005%\u0014\u0011\ra\u0001\u0003W\nQA^1mk\u0016\u00042!CA7\u0013\r\tyG\u0003\u0002\u0005\u0019>tw\rC\u0004\u0002t\u0001!\t!!\u001e\u0002\u001b5\f'o\u001b+ie>$H\u000f\\3e)\u0019\tI!a\u001e\u0002|!9\u0011\u0011PA9\u0001\u0004\u0019\u0017!\u0002;pa&\u001c\u0007bBA?\u0003c\u0002\rA[\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bbBA:\u0001\u0011\u0005\u0011\u0011\u0011\u000b\u0005\u0003\u0013\t\u0019\tC\u0004\u0002z\u0005}\u0004\u0019A2\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\u0006q!/Z7pm\u0016$\u0006N]8ui2,G\u0003BA\u0005\u0003\u0017Cq!!\u001f\u0002\u0006\u0002\u00071\rC\u0004\u0002\u0010\u0002!\t!!%\u0002\u0015U\u0004\b/\u001a:C_VtG\r\u0006\u0002\u0002l!9\u0011Q\u0013\u0001\u0005\n\u0005]\u0015\u0001F4fiF+x\u000e^1NKR\u0014\u0018nY\"p]\u001aLw\r\u0006\u0003\u0002\u001a\u0006}\u0005c\u0001\u0013\u0002\u001c&\u0019\u0011QT\u0013\u0003\u00195+GO]5d\u0007>tg-[4\t\rq\f\u0019\n1\u0001\u007f\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003K\u000baa]3og>\u0014HCAAT!\r!\u0013\u0011V\u0005\u0004\u0003W+#AB*f]N|'\u000f")
public class ReplicationQuotaManager
implements Logging,
ReplicaQuota {
    private final ReplicationQuotaManagerConfig config;
    private final Metrics kafka$server$ReplicationQuotaManager$$metrics;
    private final QuotaType kafka$server$ReplicationQuotaManager$$replicationType;
    private final Time time;
    private final ReentrantReadWriteLock lock;
    private final ConcurrentHashMap<String, Seq<Object>> throttledPartitions;
    private Quota kafka$server$ReplicationQuotaManager$$quota;
    private final SensorAccess sensorAccess;
    private final MetricName kafka$server$ReplicationQuotaManager$$rateMetricName;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicationQuotaManager replicationQuotaManager = this;
        synchronized (replicationQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ReplicationQuotaManagerConfig config() {
        return this.config;
    }

    public Metrics kafka$server$ReplicationQuotaManager$$metrics() {
        return this.kafka$server$ReplicationQuotaManager$$metrics;
    }

    public QuotaType kafka$server$ReplicationQuotaManager$$replicationType() {
        return this.kafka$server$ReplicationQuotaManager$$replicationType;
    }

    private Time time() {
        return this.time;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ConcurrentHashMap<String, Seq<Object>> throttledPartitions() {
        return this.throttledPartitions;
    }

    public Quota kafka$server$ReplicationQuotaManager$$quota() {
        return this.kafka$server$ReplicationQuotaManager$$quota;
    }

    public void kafka$server$ReplicationQuotaManager$$quota_$eq(Quota x$1) {
        this.kafka$server$ReplicationQuotaManager$$quota = x$1;
    }

    private SensorAccess sensorAccess() {
        return this.sensorAccess;
    }

    public MetricName kafka$server$ReplicationQuotaManager$$rateMetricName() {
        return this.kafka$server$ReplicationQuotaManager$$rateMetricName;
    }

    public void updateQuota(Quota quota) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), new Serializable(this, quota){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;
            private final Quota quota$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$ReplicationQuotaManager$$quota_$eq(this.quota$1);
                KafkaMetric metric = (KafkaMetric)this.$outer.kafka$server$ReplicationQuotaManager$$metrics().metrics().get(this.$outer.kafka$server$ReplicationQuotaManager$$rateMetricName());
                if (metric != null) {
                    metric.config(this.$outer.kafka$server$ReplicationQuotaManager$$getQuotaMetricConfig(this.quota$1));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.quota$1 = quota$1;
            }
        });
    }

    @Override
    public boolean isQuotaExceeded() {
        try {
            this.kafka$server$ReplicationQuotaManager$$sensor().checkQuotas();
            return false;
        }
        catch (QuotaViolationException quotaViolationException) {
            this.trace((Function0<String>)new Serializable(this, quotaViolationException){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicationQuotaManager $outer;
                private final QuotaViolationException qve$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("%s: Quota violated for sensor (%s), metric: (%s), metric-value: (%f), bound: (%f)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$ReplicationQuotaManager$$replicationType(), this.$outer.kafka$server$ReplicationQuotaManager$$sensor().name(), this.qve$1.metricName(), BoxesRunTime.boxToDouble((double)this.qve$1.value()), BoxesRunTime.boxToDouble((double)this.qve$1.bound())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.qve$1 = qve$1;
                }
            });
            return true;
        }
    }

    @Override
    public boolean isThrottled(TopicAndPartition topicPartition) {
        Seq<Object> partitions = this.throttledPartitions().get(topicPartition.topic());
        return partitions == null ? false : partitions.contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())) || partitions == Constants$.MODULE$.AllReplicas();
    }

    public void record(long value2) {
        try {
            this.kafka$server$ReplicationQuotaManager$$sensor().record((double)value2);
        }
        catch (QuotaViolationException quotaViolationException) {
            this.trace((Function0<String>)new Serializable(this, value2, quotaViolationException){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicationQuotaManager $outer;
                private final long value$1;
                private final QuotaViolationException qve$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Record: Quota violated, but ignored, for sensor (", "), metric: (", "), value : (", "), bound: (", "), recordedValue (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$ReplicationQuotaManager$$sensor().name(), this.qve$2.metricName(), BoxesRunTime.boxToDouble((double)this.qve$2.value()), BoxesRunTime.boxToDouble((double)this.qve$2.bound()), BoxesRunTime.boxToLong((long)this.value$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.value$1 = value$1;
                    this.qve$2 = qve$2;
                }
            });
        }
    }

    public void markThrottled(String topic, Seq<Object> partitions) {
        this.throttledPartitions().put(topic, partitions);
    }

    public void markThrottled(String topic) {
        this.markThrottled(topic, Constants$.MODULE$.AllReplicas());
    }

    public void removeThrottle(String topic) {
        this.throttledPartitions().remove(topic);
    }

    public long upperBound() {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.kafka$server$ReplicationQuotaManager$$quota() == null ? Long.MAX_VALUE : (long)this.$outer.kafka$server$ReplicationQuotaManager$$quota().bound();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public MetricConfig kafka$server$ReplicationQuotaManager$$getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    public Sensor kafka$server$ReplicationQuotaManager$$sensor() {
        return this.sensorAccess().getOrCreate(this.kafka$server$ReplicationQuotaManager$$replicationType().toString(), ReplicationQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.kafka$server$ReplicationQuotaManager$$metrics(), (Function0<MetricName>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;

            public final MetricName apply() {
                return this.$outer.kafka$server$ReplicationQuotaManager$$rateMetricName();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<MetricConfig>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;

            public final MetricConfig apply() {
                return this.$outer.kafka$server$ReplicationQuotaManager$$getQuotaMetricConfig(this.$outer.kafka$server$ReplicationQuotaManager$$quota());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleRate apply() {
                return new SimpleRate();
            }
        });
    }

    public ReplicationQuotaManager(ReplicationQuotaManagerConfig config, Metrics metrics, QuotaType replicationType, Time time) {
        this.config = config;
        this.kafka$server$ReplicationQuotaManager$$metrics = metrics;
        this.kafka$server$ReplicationQuotaManager$$replicationType = replicationType;
        this.time = time;
        Logging$class.$init$(this);
        this.lock = new ReentrantReadWriteLock();
        this.throttledPartitions = new ConcurrentHashMap();
        this.kafka$server$ReplicationQuotaManager$$quota = null;
        this.sensorAccess = new SensorAccess();
        this.kafka$server$ReplicationQuotaManager$$rateMetricName = metrics.metricName("byte-rate", replicationType.toString(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tracking byte-rate for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicationType})));
    }
}

