/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.network.ConnectionQuotas;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.Selector;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001u4a!\u0001\u0002\u0002\u0002\u00111!\u0001F!cgR\u0014\u0018m\u0019;TKJ4XM\u001d+ie\u0016\fGM\u0003\u0002\u0004\t\u00059a.\u001a;x_J\\'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019qB\u0005\t\u0003\u00115i\u0011!\u0003\u0006\u0003\u0015-\tA\u0001\\1oO*\tA\"\u0001\u0003kCZ\f\u0017B\u0001\b\n\u0005\u0019y%M[3diB\u0011\u0001\u0002E\u0005\u0003#%\u0011\u0001BU;o]\u0006\u0014G.\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\tQ!\u001e;jYNL!a\u0006\u000b\u0003\u000f1{wmZ5oO\"A\u0011\u0004\u0001B\u0001B\u0003%1$\u0001\td_:tWm\u0019;j_:\fVo\u001c;bg\u000e\u0001\u0001C\u0001\u000f\u001e\u001b\u0005\u0011\u0011B\u0001\u0010\u0003\u0005A\u0019uN\u001c8fGRLwN\\)v_R\f7\u000fC\u0003!\u0001\u0011\u0005\u0011%\u0001\u0004=S:LGO\u0010\u000b\u0003E\r\u0002\"\u0001\b\u0001\t\u000bey\u0002\u0019A\u000e\t\u000f\u0015\u0002!\u0019!C\u0005M\u0005a1\u000f^1siV\u0004H*\u0019;dQV\tq\u0005\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00051Z\u0011\u0001B;uS2L!AL\u0015\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\"1\u0001\u0007\u0001Q\u0001\n\u001d\nQb\u001d;beR,\b\u000fT1uG\"\u0004\u0003b\u0002\u001a\u0001\u0005\u0004%IAJ\u0001\u000eg\",H\u000fZ8x]2\u000bGo\u00195\t\rQ\u0002\u0001\u0015!\u0003(\u00039\u0019\b.\u001e;e_^tG*\u0019;dQ\u0002BqA\u000e\u0001C\u0002\u0013%q'A\u0003bY&4X-F\u00019!\tID(D\u0001;\u0015\tY\u0014&\u0001\u0004bi>l\u0017nY\u0005\u0003{i\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007BB \u0001A\u0003%\u0001(\u0001\u0004bY&4X\r\t\u0005\u0006\u0003\u00021\tAQ\u0001\u0007o\u0006\\W-\u001e9\u0015\u0003\r\u0003\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013A!\u00168ji\")!\n\u0001C\u0001\u0005\u0006A1\u000f[;uI><h\u000eC\u0003M\u0001\u0011\u0005!)\u0001\u0007bo\u0006LGo\u0015;beR,\b\u000fC\u0003O\u0001\u0011E!)A\bti\u0006\u0014H/\u001e9D_6\u0004H.\u001a;f\u0011\u0015\u0001\u0006\u0001\"\u0005C\u0003A\u0019\b.\u001e;e_^t7i\\7qY\u0016$X\rC\u0003S\u0001\u0011E1+A\u0005jgJ+hN\\5oOV\tA\u000b\u0005\u0002E+&\u0011a+\u0012\u0002\b\u0005>|G.Z1o\u0011\u0015A\u0006\u0001\"\u0001Z\u0003\u0015\u0019Gn\\:f)\r\u0019%\f\u001b\u0005\u00067^\u0003\r\u0001X\u0001\tg\u0016dWm\u0019;peB\u0011QLZ\u0007\u0002=*\u00111a\u0018\u0006\u0003A\u0006\faaY8n[>t'BA\u0003c\u0015\t\u0019G-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0006\u0019qN]4\n\u0005\u001dt&\u0001C*fY\u0016\u001cGo\u001c:\t\u000b%<\u0006\u0019\u00016\u0002\u0019\r|gN\\3di&|g.\u00133\u0011\u0005-tgB\u0001#m\u0013\tiW)\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u0014aa\u0015;sS:<'BA7F\u0011\u0015A\u0006\u0001\"\u0001s)\t\u00195\u000fC\u0003uc\u0002\u0007Q/A\u0004dQ\u0006tg.\u001a7\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018\u0001C2iC:tW\r\\:\u000b\u0005i\\\u0011a\u00018j_&\u0011Ap\u001e\u0002\u000e'>\u001c7.\u001a;DQ\u0006tg.\u001a7")
public abstract class AbstractServerThread
implements Runnable,
Logging {
    private final ConnectionQuotas connectionQuotas;
    private final CountDownLatch startupLatch;
    private final CountDownLatch shutdownLatch;
    private final AtomicBoolean alive;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AbstractServerThread abstractServerThread = this;
        synchronized (abstractServerThread) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private CountDownLatch startupLatch() {
        return this.startupLatch;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    private AtomicBoolean alive() {
        return this.alive;
    }

    public abstract void wakeup();

    public void shutdown() {
        this.alive().set(false);
        this.wakeup();
        this.shutdownLatch().await();
    }

    public void awaitStartup() {
        this.startupLatch().await();
    }

    public void startupComplete() {
        this.startupLatch().countDown();
    }

    public void shutdownComplete() {
        this.shutdownLatch().countDown();
    }

    public boolean isRunning() {
        return this.alive().get();
    }

    public void close(Selector selector, String connectionId) {
        KafkaChannel channel = selector.channel(connectionId);
        if (channel != null) {
            this.debug((Function0<String>)new Serializable(this, connectionId){
                public static final long serialVersionUID = 0L;
                private final String connectionId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing selector connection ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.connectionId$1}));
                }
                {
                    this.connectionId$1 = connectionId$1;
                }
            });
            InetAddress address = channel.socketAddress();
            if (address != null) {
                this.connectionQuotas.dec(address);
            }
            selector.close(connectionId);
        }
    }

    public void close(SocketChannel channel) {
        if (channel != null) {
            this.debug((Function0<String>)new Serializable(this, channel){
                public static final long serialVersionUID = 0L;
                private final SocketChannel channel$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Closing connection from ").append((Object)this.channel$1.socket().getRemoteSocketAddress()).toString();
                }
                {
                    this.channel$1 = channel$1;
                }
            });
            this.connectionQuotas.dec(channel.socket().getInetAddress());
            this.swallowError((Function0<BoxedUnit>)new Serializable(this, channel){
                public static final long serialVersionUID = 0L;
                private final SocketChannel channel$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.channel$1.socket().close();
                }
                {
                    this.channel$1 = channel$1;
                }
            });
            this.swallowError((Function0<BoxedUnit>)new Serializable(this, channel){
                public static final long serialVersionUID = 0L;
                private final SocketChannel channel$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.channel$1.close();
                }
                {
                    this.channel$1 = channel$1;
                }
            });
        }
    }

    public AbstractServerThread(ConnectionQuotas connectionQuotas) {
        this.connectionQuotas = connectionQuotas;
        Logging$class.$init$(this);
        this.startupLatch = new CountDownLatch(1);
        this.shutdownLatch = new CountDownLatch(1);
        this.alive = new AtomicBoolean(true);
    }
}

