/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.message.MessageAndMetadata;
import kafka.tools.ConsumerPerformance$;
import kafka.tools.PerfConfig;
import kafka.utils.CommandLineUtils$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001dq!B\u0001\u0003\u0011\u00039\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014\u0007>t7/^7feB+'OZ8s[\u0006t7-Z\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\ta\u0001\\8hO\u0016\u0014X#\u0001\r\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012!\u00027pORR'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001eL!!\t\u000e\u0003\r1{wmZ3s\u0011\u0019\u0019\u0013\u0002)A\u00051\u00059An\\4hKJ\u0004\u0003\"B\u0013\n\t\u00031\u0013\u0001B7bS:$\"a\n\u0016\u0011\u00055A\u0013BA\u0015\u000f\u0005\u0011)f.\u001b;\t\u000b-\"\u0003\u0019\u0001\u0017\u0002\t\u0005\u0014xm\u001d\t\u0004\u001b5z\u0013B\u0001\u0018\u000f\u0005\u0015\t%O]1z!\t\u00014G\u0004\u0002\u000ec%\u0011!GD\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u00023\u001d\u0019!q'\u0003\u00019\u0005I\u0019uN\\:v[\u0016\u0014\b+\u001a:g\u0007>tg-[4\u0014\u0005YJ\u0004C\u0001\u0005;\u0013\tY$A\u0001\u0006QKJ47i\u001c8gS\u001eD\u0001b\u000b\u001c\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006'Y\"\tA\u0010\u000b\u0003\u007f\u0005\u0003\"\u0001\u0011\u001c\u000e\u0003%AQaK\u001fA\u00021Bqa\u0011\u001cC\u0002\u0013\u0005A)\u0001\u0007{W\u000e{gN\\3di>\u0003H/F\u0001F!\r1\u0015jL\u0007\u0002\u000f*\t\u0001*\u0001\u0006k_B$8/[7qY\u0016L!AS$\u00037\u0005\u0013x-^7f]R\f5mY3qi&twm\u00149uS>t7\u000b]3d\u0011\u0019ae\u0007)A\u0005\u000b\u0006i!p[\"p]:,7\r^(qi\u0002BqA\u0014\u001cC\u0002\u0013\u0005A)\u0001\u0005u_BL7m\u00149u\u0011\u0019\u0001f\u0007)A\u0005\u000b\u0006IAo\u001c9jG>\u0003H\u000f\t\u0005\b%Z\u0012\r\u0011\"\u0001E\u0003)9'o\\;q\u0013\u0012|\u0005\u000f\u001e\u0005\u0007)Z\u0002\u000b\u0011B#\u0002\u0017\u001d\u0014x.\u001e9JI>\u0003H\u000f\t\u0005\b-Z\u0012\r\u0011\"\u0001X\u000311W\r^2i'&TXm\u00149u+\u0005A\u0006c\u0001$J3B\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0005Y\u0006twMC\u0001_\u0003\u0011Q\u0017M^1\n\u0005\u0001\\&aB%oi\u0016<WM\u001d\u0005\u0007EZ\u0002\u000b\u0011\u0002-\u0002\u001b\u0019,Go\u00195TSj,w\n\u001d;!\u0011\u001d!gG1A\u0005\u0002\u0015\fqC]3tKR\u0014UmZ5o]&twm\u00144gg\u0016$x\n\u001d;\u0016\u0003\u0019\u0004\"AR4\n\u0005!<%!E(qi&|gn\u00159fG\n+\u0018\u000e\u001c3fe\"1!N\u000eQ\u0001\n\u0019\f\u0001D]3tKR\u0014UmZ5o]&twm\u00144gg\u0016$x\n\u001d;!\u0011\u001dagG1A\u0005\u0002]\u000b1c]8dW\u0016$()\u001e4gKJ\u001c\u0016N_3PaRDaA\u001c\u001c!\u0002\u0013A\u0016\u0001F:pG.,GOQ;gM\u0016\u00148+\u001b>f\u001fB$\b\u0005C\u0004qm\t\u0007I\u0011A,\u0002\u001b9,X\u000e\u00165sK\u0006$7o\u00149u\u0011\u0019\u0011h\u0007)A\u00051\u0006qa.^7UQJ,\u0017\rZ:PaR\u0004\u0003b\u0002;7\u0005\u0004%\taV\u0001\u000f]Vlg)\u001a;dQ\u0016\u00148o\u00149u\u0011\u00191h\u0007)A\u00051\u0006ya.^7GKR\u001c\u0007.\u001a:t\u001fB$\b\u0005C\u0004ym\t\u0007I\u0011A=\u0002\u000f=\u0004H/[8ogV\t!\u0010\u0005\u0002Gw&\u0011Ap\u0012\u0002\n\u001fB$\u0018n\u001c8TKRDaA \u001c!\u0002\u0013Q\u0018\u0001C8qi&|gn\u001d\u0011\t\u0013\u0005\u0005aG1A\u0005\u0002\u0005\r\u0011!\u00029s_B\u001cXCAA\u0003!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006;\u0006!Q\u000f^5m\u0013\u0011\ty!!\u0003\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0005\u0002\u0014Y\u0002\u000b\u0011BA\u0003\u0003\u0019\u0001(o\u001c9tA!I\u0011q\u0003\u001cC\u0002\u0013\u0005\u0011\u0011D\u0001\u000fG>t7/^7fe\u000e{gNZ5h+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t\u0003B\u0001\tG>t7/^7fe&!\u0011QEA\u0010\u00059\u0019uN\\:v[\u0016\u00148i\u001c8gS\u001eD\u0001\"!\u000b7A\u0003%\u00111D\u0001\u0010G>t7/^7fe\u000e{gNZ5hA!I\u0011Q\u0006\u001cC\u0002\u0013\u0005\u0011qF\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001cXCAA\u0019!\ri\u00111G\u0005\u0004\u0003kq!aA%oi\"A\u0011\u0011\b\u001c!\u0002\u0013\t\t$A\u0006ok6$\u0006N]3bIN\u0004\u0003\"CA\u001fm\t\u0007I\u0011AA \u0003\u0015!x\u000e]5d+\u0005y\u0003bBA\"m\u0001\u0006IaL\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u0013\u0005\u001dcG1A\u0005\u0002\u0005%\u0013a\u00038v[6+7o]1hKN,\"!a\u0013\u0011\u00075\ti%C\u0002\u0002P9\u0011A\u0001T8oO\"A\u00111\u000b\u001c!\u0002\u0013\tY%\u0001\u0007ok6lUm]:bO\u0016\u001c\b\u0005C\u0005\u0002XY\u0012\r\u0011\"\u0001\u00020\u0005\t\"/\u001a9peRLgnZ%oi\u0016\u0014h/\u00197\t\u0011\u0005mc\u0007)A\u0005\u0003c\t!C]3q_J$\u0018N\\4J]R,'O^1mA!I\u0011q\f\u001cC\u0002\u0013\u0005\u0011\u0011M\u0001\u0012g\"|w\u000fR3uC&dW\rZ*uCR\u001cXCAA2!\ri\u0011QM\u0005\u0004\u0003Or!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003W2\u0004\u0015!\u0003\u0002d\u0005\u00112\u000f[8x\t\u0016$\u0018-\u001b7fIN#\u0018\r^:!\u0011%\tyG\u000eb\u0001\n\u0003\t\t(\u0001\u0006eCR,gi\u001c:nCR,\"!a\u001d\u0011\t\u0005U\u00141P\u0007\u0003\u0003oR1!!\u001f^\u0003\u0011!X\r\u001f;\n\t\u0005u\u0014q\u000f\u0002\u0011'&l\u0007\u000f\\3ECR,gi\u001c:nCRD\u0001\"!!7A\u0003%\u00111O\u0001\fI\u0006$XMR8s[\u0006$\b\u0005C\u0005\u0002\u0006Z\u0012\r\u0011\"\u0001\u0002b\u0005Q\u0001.\u001b3f\u0011\u0016\fG-\u001a:\t\u0011\u0005%e\u0007)A\u0005\u0003G\n1\u0002[5eK\"+\u0017\rZ3sA\u00191\u0011QR\u0005\u0001\u0003\u001f\u0013!cQ8ogVlWM\u001d)fe\u001a$\u0006N]3bIN!\u00111RAI!\rQ\u00161S\u0005\u0004\u0003+[&A\u0002+ie\u0016\fG\rC\u0006\u0002\u001a\u0006-%\u0011!Q\u0001\n\u0005E\u0012\u0001\u0003;ie\u0016\fG-\u00133\t\u0015\u0005u\u00151\u0012B\u0001B\u0003%q&\u0001\u0003oC6,\u0007bCAQ\u0003\u0017\u0013\t\u0011)A\u0005\u0003G\u000baa\u001d;sK\u0006l\u0007\u0003CA\u000f\u0003K\u000bI+!+\n\t\u0005\u001d\u0016q\u0004\u0002\f\u0017\u000647.Y*ue\u0016\fW\u000e\u0005\u0003\u000e[\u0005-\u0006cA\u0007\u0002.&\u0019\u0011q\u0016\b\u0003\t\tKH/\u001a\u0005\u000b\u0003g\u000bYI!A!\u0002\u0013y\u0014AB2p]\u001aLw\rC\u0006\u00028\u0006-%\u0011!Q\u0001\n\u0005e\u0016!\u0005;pi\u0006dW*Z:tC\u001e,7OU3bIB!\u00111XAc\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017AB1u_6L7M\u0003\u0003\u0002D\u0006%\u0011AC2p]\u000e,(O]3oi&!\u0011qYA_\u0005)\tEo\\7jG2{gn\u001a\u0005\f\u0003\u0017\fYI!A!\u0002\u0013\tI,\u0001\bu_R\fGNQ=uKN\u0014V-\u00193\t\u000fM\tY\t\"\u0001\u0002PRq\u0011\u0011[Aj\u0003+\f9.!7\u0002\\\u0006u\u0007c\u0001!\u0002\f\"A\u0011\u0011TAg\u0001\u0004\t\t\u0004C\u0004\u0002\u001e\u00065\u0007\u0019A\u0018\t\u0011\u0005\u0005\u0016Q\u001aa\u0001\u0003GCq!a-\u0002N\u0002\u0007q\b\u0003\u0005\u00028\u00065\u0007\u0019AA]\u0011!\tY-!4A\u0002\u0005e\u0006\u0002CAq\u0003\u0017#\t%a9\u0002\u0007I,h\u000eF\u0001(\u0011!\t9/a#\u0005\n\u0005%\u0018\u0001\u00049sS:$X*Z:tC\u001e,GcD\u0014\u0002l\u0006=\u00181_A|\u0003w\fyPa\u0001\t\u0011\u00055\u0018Q\u001da\u0001\u0003c\t!!\u001b3\t\u0011\u0005E\u0018Q\u001da\u0001\u0003\u0017\n\u0011BY=uKN\u0014V-\u00193\t\u0011\u0005U\u0018Q\u001da\u0001\u0003\u0017\nQ\u0002\\1ti\nKH/Z:SK\u0006$\u0007\u0002CA}\u0003K\u0004\r!a\u0013\u0002\u00195,7o]1hKN\u0014V-\u00193\t\u0011\u0005u\u0018Q\u001da\u0001\u0003\u0017\n\u0001\u0003\\1ti6+7o]1hKN\u0014V-\u00193\t\u0011\t\u0005\u0011Q\u001da\u0001\u0003\u0017\nqa\u001d;beRl5\u000f\u0003\u0005\u0003\u0006\u0005\u0015\b\u0019AA&\u0003\u0015)g\u000eZ't\u0001")
public final class ConsumerPerformance {
    public static void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    public static class ConsumerPerfConfig
    extends PerfConfig {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)new StringBuilder().append((Object)"perf-consumer-").append((Object)BoxesRunTime.boxToInteger((int)new Random().nextInt(100000))).toString(), (Object[])new String[0]).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numFetchersOpt = this.parser().accepts("num-fetch-threads", "Number of fetcher threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        private final OptionSet options;
        private final Properties props;
        private final ConsumerConfig consumerConfig;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numFetchersOpt() {
            return this.numFetchersOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public Properties props() {
            return this.props;
        }

        public ConsumerConfig consumerConfig() {
            return this.consumerConfig;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] args) {
            super(args);
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.zkConnectOpt()}));
            this.props = new Properties();
            ((Hashtable)this.props()).put("group.id", this.options().valueOf(this.groupIdOpt()));
            ((Hashtable)this.props()).put("socket.receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
            ((Hashtable)this.props()).put("fetch.message.max.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
            ((Hashtable)this.props()).put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
            ((Hashtable)this.props()).put("zookeeper.connect", this.options().valueOf(this.zkConnectOpt()));
            ((Hashtable)this.props()).put("consumer.timeout.ms", "5000");
            ((Hashtable)this.props()).put("num.consumer.fetchers", ((Integer)this.options().valueOf(this.numFetchersOpt())).toString());
            this.consumerConfig = new ConsumerConfig(this.props());
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.numMessages = (Long)this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            this.showDetailedStats = this.options().has((OptionSpec)this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat((String)this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has((OptionSpec)this.hideHeaderOpt());
        }
    }

    public static class ConsumerPerfThread
    extends Thread {
        private final int threadId;
        private final KafkaStream<byte[], byte[]> stream;
        private final ConsumerPerfConfig config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;

        @Override
        public void run() {
            long startMs;
            long bytesRead = 0L;
            long messagesRead = 0L;
            long lastReportTime = startMs = System.currentTimeMillis();
            long lastBytesRead = 0L;
            long lastMessagesRead = 0L;
            try {
                Iterator iter = this.stream.iterator();
                while (iter.hasNext() && messagesRead < this.config.numMessages()) {
                    Object messageAndMetadata = iter.next();
                    bytesRead += (long)((byte[])((MessageAndMetadata)messageAndMetadata).message()).length;
                    if (++messagesRead % (long)this.config.reportingInterval() != 0L) continue;
                    if (this.config.showDetailedStats()) {
                        this.printMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, lastReportTime, System.currentTimeMillis());
                    }
                    lastReportTime = System.currentTimeMillis();
                    lastMessagesRead = messagesRead;
                    lastBytesRead = bytesRead;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            catch (ConsumerTimeoutException consumerTimeoutException) {
            }
            catch (ClosedByInterruptException closedByInterruptException) {
            }
            catch (InterruptedException interruptedException) {}
            this.totalMessagesRead.addAndGet(messagesRead);
            this.totalBytesRead.addAndGet(bytesRead);
            if (this.config.showDetailedStats()) {
                this.printMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, System.currentTimeMillis());
            }
        }

        private void printMessage(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs) {
            long elapsedMs = endMs - startMs;
            double totalMBRead = (double)bytesRead * 1.0 / (double)0x100000;
            double mbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %d, %d, %.4f, %.4f, %d, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.config.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)id), BoxesRunTime.boxToInteger((int)this.config.consumerConfig().fetchMessageMaxBytes()), BoxesRunTime.boxToDouble((double)totalMBRead), BoxesRunTime.boxToDouble((double)(1000.0 * (mbRead / (double)elapsedMs))), BoxesRunTime.boxToLong((long)messagesRead), BoxesRunTime.boxToDouble((double)((double)((messagesRead - lastMessagesRead) / elapsedMs) * 1000.0))})));
        }

        public ConsumerPerfThread(int threadId, String name, KafkaStream<byte[], byte[]> stream, ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead) {
            this.threadId = threadId;
            this.stream = stream;
            this.config = config;
            this.totalMessagesRead = totalMessagesRead;
            this.totalBytesRead = totalBytesRead;
            super(name);
        }
    }
}

