/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.admin.AdminUtils$;
import kafka.api.ConsumerMetadataRequest;
import kafka.api.ConsumerMetadataResponse;
import kafka.api.ControlledShutdownRequest;
import kafka.api.ControlledShutdownResponse;
import kafka.api.FetchRequest;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.api.FetchResponseSend;
import kafka.api.LeaderAndIsrRequest;
import kafka.api.LeaderAndIsrResponse;
import kafka.api.OffsetCommitRequest;
import kafka.api.OffsetCommitResponse;
import kafka.api.OffsetFetchRequest;
import kafka.api.OffsetFetchResponse;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.OffsetResponse;
import kafka.api.PartitionMetadata;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponseStatus;
import kafka.api.RequestKeys$;
import kafka.api.RequestOrResponse;
import kafka.api.StopReplicaRequest;
import kafka.api.StopReplicaResponse;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.api.UpdateMetadataRequest;
import kafka.api.UpdateMetadataResponse;
import kafka.api.UpdateMetadataResponse$;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.InvalidTopicException;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.common.NotEnoughReplicasException;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetMetadataAndError;
import kafka.common.OffsetMetadataAndError$;
import kafka.common.Topic$;
import kafka.common.TopicAndPartition;
import kafka.common.TopicExistsException;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.controller.KafkaController;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageSet;
import kafka.network.BoundedByteBufferSend;
import kafka.network.RequestChannel;
import kafka.server.BrokerTopicStats$;
import kafka.server.DelayedFetch;
import kafka.server.DelayedProduce;
import kafka.server.DelayedProduceResponseStatus;
import kafka.server.FetchRequestPurgatory;
import kafka.server.KafkaApis$;
import kafka.server.KafkaApis$ProduceResult$;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.MetadataCache;
import kafka.server.OffsetManager;
import kafka.server.OffsetManager$;
import kafka.server.PartitionDataAndOffset;
import kafka.server.ProducerRequestPurgatory;
import kafka.server.ReplicaManager;
import kafka.server.TopicPartitionRequestKey;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rUe\u0001B\u0001\u0003\u0001\u001d\u0011\u0011bS1gW\u0006\f\u0005/[:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0017\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012a\u0006\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\tqA\\3uo>\u00148.\u0003\u0002\u001d3\tq!+Z9vKN$8\t[1o]\u0016d\u0007\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u001fI,\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002B\u0001\u0002\t\u0001\u0003\u0006\u0004%\t!I\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005\u0011\u0003CA\u0012%\u001b\u0005\u0011\u0011BA\u0013\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0001b\n\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&A\u0007pM\u001a\u001cX\r^'b]\u0006<WM]\u000b\u0002WA\u00111\u0005L\u0005\u0003[\t\u0011Qb\u00144gg\u0016$X*\u00198bO\u0016\u0014\b\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u001d=4gm]3u\u001b\u0006t\u0017mZ3sA!A\u0011\u0007\u0001BC\u0002\u0013\u0005!'\u0001\u0005{W\u000ec\u0017.\u001a8u+\u0005\u0019\u0004C\u0001\u001b<\u001b\u0005)$B\u0001\u001c8\u0003!Q8n\u00197jK:$(B\u0001\u001d:\u0003\u0019I\u0005'\u0013;fG*\t!(A\u0002pe\u001eL!\u0001P\u001b\u0003\u0011i[7\t\\5f]RD\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaM\u0001\nu.\u001cE.[3oi\u0002B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t!Q\u0001\tEJ|7.\u001a:JIV\t!\t\u0005\u0002\n\u0007&\u0011AI\u0003\u0002\u0004\u0013:$\b\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0003\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011A%\u0002\r\r|gNZ5h+\u0005Q\u0005CA\u0012L\u0013\ta%AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\u0002\u000f\r|gNZ5hA!A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011+\u0001\u0006d_:$(o\u001c7mKJ,\u0012A\u0015\t\u0003'Vk\u0011\u0001\u0016\u0006\u0003!\u0012I!A\u0016+\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJD\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006IAU\u0001\fG>tGO]8mY\u0016\u0014\b\u0005C\u0003[\u0001\u0011\u00051,\u0001\u0004=S:LGO\u0010\u000b\t9vsv\fY1cGB\u00111\u0005\u0001\u0005\u0006+e\u0003\ra\u0006\u0005\u0006Ae\u0003\rA\t\u0005\u0006Se\u0003\ra\u000b\u0005\u0006ce\u0003\ra\r\u0005\u0006\u0001f\u0003\rA\u0011\u0005\u0006\u0011f\u0003\rA\u0013\u0005\u0006!f\u0003\rA\u0015\u0005\bK\u0002\u0011\r\u0011\"\u0001g\u0003a\u0001(o\u001c3vG\u0016\u0014(+Z9vKN$\b+\u001e:hCR|'/_\u000b\u0002OB\u00111\u0005[\u0005\u0003S\n\u0011\u0001\u0004\u0015:pIV\u001cWM\u001d*fcV,7\u000f\u001e)ve\u001e\fGo\u001c:z\u0011\u0019Y\u0007\u0001)A\u0005O\u0006I\u0002O]8ek\u000e,'OU3rk\u0016\u001cH\u000fU;sO\u0006$xN]=!\u0011\u001di\u0007A1A\u0005\u00029\fQCZ3uG\"\u0014V-];fgR\u0004VO]4bi>\u0014\u00180F\u0001p!\t\u0019\u0003/\u0003\u0002r\u0005\t)b)\u001a;dQJ+\u0017/^3tiB+(oZ1u_JL\bBB:\u0001A\u0003%q.\u0001\fgKR\u001c\u0007NU3rk\u0016\u001cH\u000fU;sO\u0006$xN]=!\u0011\u001d)\b\u00011A\u0005\u0002Y\fQ\"\\3uC\u0012\fG/Y\"bG\",W#A<\u0011\u0005\rB\u0018BA=\u0003\u00055iU\r^1eCR\f7)Y2iK\"91\u0010\u0001a\u0001\n\u0003a\u0018!E7fi\u0006$\u0017\r^1DC\u000eDWm\u0018\u0013fcR\u0019Q0!\u0001\u0011\u0005%q\u0018BA@\u000b\u0005\u0011)f.\u001b;\t\u0011\u0005\r!0!AA\u0002]\f1\u0001\u001f\u00132\u0011\u001d\t9\u0001\u0001Q!\n]\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007\u0005C\u0004\u0002\f\u0001!\t!!\u0004\u0002\r!\fg\u000e\u001a7f)\ri\u0018q\u0002\u0005\t\u0003#\tI\u00011\u0001\u0002\u0014\u00059!/Z9vKN$\b\u0003BA\u000b\u00037q1\u0001GA\f\u0013\r\tI\"G\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\ti\"a\b\u0003\u000fI+\u0017/^3ti*\u0019\u0011\u0011D\r\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u0005I\u0002.\u00198eY\u0016dU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u)\ri\u0018q\u0005\u0005\t\u0003#\t\t\u00031\u0001\u0002\u0014!9\u00111\u0006\u0001\u0005\u0002\u00055\u0012\u0001\u00075b]\u0012dWm\u0015;paJ+\u0007\u000f\\5dCJ+\u0017/^3tiR\u0019Q0a\f\t\u0011\u0005E\u0011\u0011\u0006a\u0001\u0003'Aq!a\r\u0001\t\u0003\t)$A\u000eiC:$G.Z+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u000b\u0004{\u0006]\u0002\u0002CA\t\u0003c\u0001\r!a\u0005\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u0005y\u0002.\u00198eY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8SKF,Xm\u001d;\u0015\u0007u\fy\u0004\u0003\u0005\u0002\u0012\u0005e\u0002\u0019AA\n\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003\u000b\nq\u0004\u001d:pIV\u001cWM\u001d*fcV,7\u000f\u001e$s_6|eMZ:fi\u000e{W.\\5u)\u0011\t9%a\u0015\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014\u0005\u0003\r\t\u0007/[\u0005\u0005\u0003#\nYEA\bQe>$WoY3s%\u0016\fX/Z:u\u0011!\t)&!\u0011A\u0002\u0005]\u0013aE8gMN,GoQ8n[&$(+Z9vKN$\b\u0003BA%\u00033JA!a\u0017\u0002L\t\u0019rJ\u001a4tKR\u001cu.\\7jiJ+\u0017/^3ti\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014a\t5b]\u0012dW\r\u0015:pIV\u001cWM](s\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e*fcV,7\u000f\u001e\u000b\u0004{\u0006\r\u0004\u0002CA\t\u0003;\u0002\r!a\u0005\u0007\r\u0005\u001d\u0004\u0001QA5\u00055\u0001&o\u001c3vG\u0016\u0014Vm];miN9\u0011Q\r\u0005\u0002l\u0005E\u0004cA\u0005\u0002n%\u0019\u0011q\u000e\u0006\u0003\u000fA\u0013x\u000eZ;diB\u0019\u0011\"a\u001d\n\u0007\u0005U$B\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0006\u0002z\u0005\u0015$Q3A\u0005\u0002\u0005m\u0014aA6fsV\u0011\u0011Q\u0010\t\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*\u0019\u00111\u0011\u0003\u0002\r\r|W.\\8o\u0013\u0011\t9)!!\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0006\u0002\f\u0006\u0015$\u0011#Q\u0001\n\u0005u\u0014\u0001B6fs\u0002B1\"a$\u0002f\tU\r\u0011\"\u0001\u0002\u0012\u0006)1\u000f^1siV\u0011\u00111\u0013\t\u0004\u0013\u0005U\u0015bAAL\u0015\t!Aj\u001c8h\u0011-\tY*!\u001a\u0003\u0012\u0003\u0006I!a%\u0002\rM$\u0018M\u001d;!\u0011-\ty*!\u001a\u0003\u0016\u0004%\t!!%\u0002\u0007\u0015tG\rC\u0006\u0002$\u0006\u0015$\u0011#Q\u0001\n\u0005M\u0015\u0001B3oI\u0002B1\"a*\u0002f\tU\r\u0011\"\u0001\u0002*\u0006)QM\u001d:peV\u0011\u00111\u0016\t\u0006\u0013\u00055\u0016\u0011W\u0005\u0004\u0003_S!AB(qi&|g\u000e\u0005\u0003\u00024\u0006\rg\u0002BA[\u0003\u007fsA!a.\u0002>6\u0011\u0011\u0011\u0018\u0006\u0004\u0003w3\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\r\t\tMC\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)-a2\u0003\u0013QC'o\\<bE2,'bAAa\u0015!Y\u00111ZA3\u0005#\u0005\u000b\u0011BAV\u0003\u0019)'O]8sA!9!,!\u001a\u0005\u0002\u0005=GCCAi\u0003+\f9.!7\u0002\\B!\u00111[A3\u001b\u0005\u0001\u0001\u0002CA=\u0003\u001b\u0004\r!! \t\u0011\u0005=\u0015Q\u001aa\u0001\u0003'C\u0001\"a(\u0002N\u0002\u0007\u00111\u0013\u0005\u000b\u0003O\u000bi\r%AA\u0002\u0005-\u0006b\u0002.\u0002f\u0011\u0005\u0011q\u001c\u000b\u0007\u0003#\f\t/a9\t\u0011\u0005e\u0014Q\u001ca\u0001\u0003{B\u0001\"!:\u0002^\u0002\u0007\u0011\u0011W\u0001\ni\"\u0014xn^1cY\u0016D\u0001\"!;\u0002f\u0011\u0005\u00111^\u0001\nKJ\u0014xN]\"pI\u0016,\"!!<\u0011\u0007%\ty/C\u0002\u0002r*\u0011Qa\u00155peRD!\"!>\u0002f\u0005\u0005I\u0011AA|\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005E\u0017\u0011`A~\u0003{\fy\u0010\u0003\u0006\u0002z\u0005M\b\u0013!a\u0001\u0003{B!\"a$\u0002tB\u0005\t\u0019AAJ\u0011)\ty*a=\u0011\u0002\u0003\u0007\u00111\u0013\u0005\u000b\u0003O\u000b\u0019\u0010%AA\u0002\u0005-\u0006B\u0003B\u0002\u0003K\n\n\u0011\"\u0001\u0003\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0004U\u0011\tiH!\u0003,\u0005\t-\u0001\u0003\u0002B\u0007\u0005/i!Aa\u0004\u000b\t\tE!1C\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0006\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00053\u0011yAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!B!\b\u0002fE\u0005I\u0011\u0001B\u0010\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\t+\t\u0005M%\u0011\u0002\u0005\u000b\u0005K\t)'%A\u0005\u0002\t}\u0011AD2paf$C-\u001a4bk2$He\r\u0005\u000b\u0005S\t)'%A\u0005\u0002\t-\u0012AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005[QC!a+\u0003\n!Q!\u0011GA3\u0003\u0003%\tEa\r\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011)\u0004\u0005\u0003\u00038\t\u0005SB\u0001B\u001d\u0015\u0011\u0011YD!\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0005\u007f\tAA[1wC&!!1\tB\u001d\u0005\u0019\u0019FO]5oO\"I!qIA3\u0003\u0003%\t!Q\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0005\u0017\n)'!A\u0005\u0002\t5\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u001f\u0012)\u0006E\u0002\n\u0005#J1Aa\u0015\u000b\u0005\r\te.\u001f\u0005\n\u0003\u0007\u0011I%!AA\u0002\tC!B!\u0017\u0002f\u0005\u0005I\u0011\tB.\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B/!\u0019\u0011yF!\u001a\u0003P5\u0011!\u0011\r\u0006\u0004\u0005GR\u0011AC2pY2,7\r^5p]&!!q\rB1\u0005!IE/\u001a:bi>\u0014\bB\u0003B6\u0003K\n\t\u0011\"\u0001\u0003n\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0003p\tU\u0004cA\u0005\u0003r%\u0019!1\u000f\u0006\u0003\u000f\t{w\u000e\\3b]\"Q\u00111\u0001B5\u0003\u0003\u0005\rAa\u0014\t\u0015\te\u0014QMA\u0001\n\u0003\u0012Y(\u0001\u0005iCND7i\u001c3f)\u0005\u0011\u0005B\u0003B@\u0003K\n\t\u0011\"\u0011\u0003\u0002\u0006AAo\\*ue&tw\r\u0006\u0002\u00036!Q!QQA3\u0003\u0003%\tEa\"\u0002\r\u0015\fX/\u00197t)\u0011\u0011yG!#\t\u0015\u0005\r!1QA\u0001\u0002\u0004\u0011yeB\u0005\u0003\u000e\u0002\t\t\u0011#\u0001\u0003\u0010\u0006i\u0001K]8ek\u000e,'+Z:vYR\u0004B!a5\u0003\u0012\u001aI\u0011q\r\u0001\u0002\u0002#\u0005!1S\n\u0007\u0005#\u0013)*!\u001d\u0011\u001d\t]%QTA?\u0003'\u000b\u0019*a+\u0002R6\u0011!\u0011\u0014\u0006\u0004\u00057S\u0011a\u0002:v]RLW.Z\u0005\u0005\u0005?\u0013IJA\tBEN$(/Y2u\rVt7\r^5p]RBqA\u0017BI\t\u0003\u0011\u0019\u000b\u0006\u0002\u0003\u0010\"Q!q\u0010BI\u0003\u0003%)E!!\t\u0015\t%&\u0011SA\u0001\n\u0003\u0013Y+A\u0003baBd\u0017\u0010\u0006\u0006\u0002R\n5&q\u0016BY\u0005gC\u0001\"!\u001f\u0003(\u0002\u0007\u0011Q\u0010\u0005\t\u0003\u001f\u00139\u000b1\u0001\u0002\u0014\"A\u0011q\u0014BT\u0001\u0004\t\u0019\n\u0003\u0006\u0002(\n\u001d\u0006\u0013!a\u0001\u0003WC!Ba.\u0003\u0012\u0006\u0005I\u0011\u0011B]\u0003\u001d)h.\u00199qYf$BAa/\u0003DB)\u0011\"!,\u0003>BY\u0011Ba0\u0002~\u0005M\u00151SAV\u0013\r\u0011\tM\u0003\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\t\u0015'Q\u0017a\u0001\u0003#\f1\u0001\u001f\u00131\u0011)\u0011IM!%\u0012\u0002\u0013\u0005!1F\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\t\u0015\t5'\u0011SI\u0001\n\u0003\u0011Y#A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011)\u0011\tN!%\u0002\u0002\u0013%!1[\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003VB!!q\u0007Bl\u0013\u0011\u0011IN!\u000f\u0003\r=\u0013'.Z2u\u0011\u001d\u0011i\u000e\u0001C\u0005\u0005?\f\u0001#\u00199qK:$Gk\u001c'pG\u0006dGj\\4\u0015\r\t\u0005(q\u001dBv!\u0019\u0011yFa9\u0002R&!!Q\u001dB1\u0005!IE/\u001a:bE2,\u0007\u0002\u0003Bu\u00057\u0004\r!a\u0012\u0002\u001fA\u0014x\u000eZ;dKJ\u0014V-];fgRD\u0001B!<\u0003\\\u0002\u0007!qN\u0001\u000fSN|eMZ:fi\u000e{W.\\5u\u0011\u001d\u0011\t\u0010\u0001C\u0001\u0005g\f!\u0003[1oI2,g)\u001a;dQJ+\u0017/^3tiR\u0019QP!>\t\u0011\u0005E!q\u001ea\u0001\u0003'AqA!?\u0001\t\u0013\u0011Y0A\u000esK\u000e|'\u000f\u001a$pY2|w/\u001a:M_\u001e,e\u000eZ(gMN,Go\u001d\u000b\u0006{\nu8\u0011\u0001\u0005\b\u0005\u007f\u00149\u00101\u0001C\u0003%\u0011X\r\u001d7jG\u0006LE\r\u0003\u0005\u0004\u0004\t]\b\u0019AB\u0003\u0003\u001dygMZ:fiN\u0004\u0002Ba\u0018\u0004\b\u0005u41B\u0005\u0005\u0007\u0013\u0011\tGA\u0002NCB\u00042aIB\u0007\u0013\r\u0019yA\u0001\u0002\u0012\u0019><wJ\u001a4tKRlU\r^1eCR\f\u0007bBB\n\u0001\u0011\u00051QC\u0001\u0014Q\u0006tG\r\\3PM\u001a\u001cX\r\u001e*fcV,7\u000f\u001e\u000b\u0004{\u000e]\u0001\u0002CA\t\u0007#\u0001\r!a\u0005\t\u000f\rm\u0001\u0001\"\u0001\u0004\u001e\u0005aa-\u001a;dQ>3gm]3ugRQ1qDB\u0013\u0007k\u0019Id!\u0010\u0011\r\t}3\u0011EAJ\u0013\u0011\u0019\u0019C!\u0019\u0003\u0007M+\u0017\u000f\u0003\u0005\u0004(\re\u0001\u0019AB\u0015\u0003)awnZ'b]\u0006<WM\u001d\t\u0005\u0007W\u0019\t$\u0004\u0002\u0004.)\u00191q\u0006\u0003\u0002\u00071|w-\u0003\u0003\u00044\r5\"A\u0003'pO6\u000bg.Y4fe\"A1qGB\r\u0001\u0004\ti(A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001ba\u000f\u0004\u001a\u0001\u0007\u00111S\u0001\ni&lWm\u001d;b[BDqaa\u0010\u0004\u001a\u0001\u0007!)A\u0007nCbtU/\\(gMN,Go\u001d\u0005\b\u0007\u0007\u0002A\u0011AB#\u0003I1W\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3\u0015\u0011\r}1qIB(\u0007#B\u0001ba\f\u0004B\u0001\u00071\u0011\n\t\u0005\u0007W\u0019Y%\u0003\u0003\u0004N\r5\"a\u0001'pO\"A11HB!\u0001\u0004\t\u0019\nC\u0004\u0004@\r\u0005\u0003\u0019\u0001\"\t\u000f\rU\u0003\u0001\"\u0003\u0004X\u0005\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\u0005\u00073\u001a\t\u0007\u0005\u0004\u0003`\r\u000521\f\t\u0005\u0003\u0013\u001ai&\u0003\u0003\u0004`\u0005-#!\u0004+pa&\u001cW*\u001a;bI\u0006$\u0018\r\u0003\u0005\u0004d\rM\u0003\u0019AB3\u0003\u0019!x\u000e]5dgB1!qLB4\u0007WJAa!\u001b\u0003b\t\u00191+\u001a;\u0011\t\r541\u000f\b\u0004\u0013\r=\u0014bAB9\u0015\u00051\u0001K]3eK\u001aLAAa\u0011\u0004v)\u00191\u0011\u000f\u0006\t\u000f\re\u0004\u0001\"\u0001\u0004|\u0005Q\u0002.\u00198eY\u0016$v\u000e]5d\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiR\u0019Qp! \t\u0011\u0005E1q\u000fa\u0001\u0003'Aqa!!\u0001\t\u0003\u0019\u0019)\u0001\riC:$G.Z(gMN,GOR3uG\"\u0014V-];fgR$2!`BC\u0011!\t\tba A\u0002\u0005M\u0001bBBE\u0001\u0011\u000511R\u0001\u001eQ\u0006tG\r\\3D_:\u001cX/\\3s\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiR\u0019Qp!$\t\u0011\u0005E1q\u0011a\u0001\u0003'Aqa!%\u0001\t\u0003\u0019\u0019*A\u0003dY>\u001cX\rF\u0001~\u0001")
public class KafkaApis
implements Logging {
    private final RequestChannel requestChannel;
    private final ReplicaManager replicaManager;
    private final OffsetManager offsetManager;
    private final ZkClient zkClient;
    private final int brokerId;
    private final KafkaConfig config;
    private final KafkaController controller;
    private final ProducerRequestPurgatory producerRequestPurgatory;
    private final FetchRequestPurgatory fetchRequestPurgatory;
    private MetadataCache metadataCache;
    private volatile KafkaApis$ProduceResult$ ProduceResult$module;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KafkaApis$ProduceResult$ ProduceResult$lzycompute() {
        KafkaApis kafkaApis = this;
        synchronized (kafkaApis) {
            if (this.ProduceResult$module != null) return this.ProduceResult$module;
            this.ProduceResult$module = new KafkaApis$ProduceResult$(this);
            return this.ProduceResult$module;
        }
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaApis kafkaApis = this;
        synchronized (kafkaApis) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public OffsetManager offsetManager() {
        return this.offsetManager;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public KafkaController controller() {
        return this.controller;
    }

    public ProducerRequestPurgatory producerRequestPurgatory() {
        return this.producerRequestPurgatory;
    }

    public FetchRequestPurgatory fetchRequestPurgatory() {
        return this.fetchRequestPurgatory;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public void metadataCache_$eq(MetadataCache x$1) {
        this.metadataCache = x$1;
    }

    public void handle(RequestChannel.Request request) {
        block27: {
            short s;
            block26: {
                this.trace((Function0<String>)new Serializable(this, request){
                    public static final long serialVersionUID = 0L;
                    private final RequestChannel.Request request$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Handling request: ").append((Object)this.request$1.requestObj()).append((Object)" from client: ").append((Object)this.request$1.remoteAddress()).toString();
                    }
                    {
                        this.request$1 = request$1;
                    }
                });
                s = request.requestId();
                if (RequestKeys$.MODULE$.ProduceKey() == s) {
                    this.handleProducerOrOffsetCommitRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RequestKeys$.MODULE$.FetchKey() == s) {
                    this.handleFetchRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RequestKeys$.MODULE$.OffsetsKey() == s) {
                    this.handleOffsetRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RequestKeys$.MODULE$.MetadataKey() == s) {
                    this.handleTopicMetadataRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RequestKeys$.MODULE$.LeaderAndIsrKey() == s) {
                    this.handleLeaderAndIsrRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RequestKeys$.MODULE$.StopReplicaKey() == s) {
                    this.handleStopReplicaRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RequestKeys$.MODULE$.UpdateMetadataKey() == s) {
                    this.handleUpdateMetadataRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RequestKeys$.MODULE$.ControlledShutdownKey() == s) {
                    this.handleControlledShutdownRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RequestKeys$.MODULE$.OffsetCommitKey() == s) {
                    this.handleProducerOrOffsetCommitRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RequestKeys$.MODULE$.OffsetFetchKey() == s) {
                    this.handleOffsetFetchRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (RequestKeys$.MODULE$.ConsumerMetadataKey() != s) break block26;
                    this.handleConsumerMetadataRequest(request);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                request.apiLocalCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
            }
            try {
                throw new KafkaException(new StringBuilder().append((Object)"Unknown api code ").append((Object)BoxesRunTime.boxToShort((short)s)).toString());
            }
            catch (Throwable throwable) {
                request.requestObj().handleError(throwable, this.requestChannel(), request);
                this.error((Function0<String>)new Serializable(this, request){
                    public static final long serialVersionUID = 0L;
                    private final RequestChannel.Request request$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("error when handling request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.requestObj()}));
                    }
                    {
                        this.request$1 = request$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
            }
            break block27;
            finally {
                request.apiLocalCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
            }
        }
    }

    public void handleLeaderAndIsrRequest(RequestChannel.Request request) {
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)request.requestObj();
        try {
            Tuple2 tuple2;
            Tuple2<Map<Tuple2<String, Object>, Object>, Object> tuple22 = this.replicaManager().becomeLeaderOrFollower(leaderAndIsrRequest, this.offsetManager());
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            Map response = (Map)tuple22._1();
            short error = BoxesRunTime.unboxToShort((Object)tuple22._2());
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)response, (Object)BoxesRunTime.boxToShort((short)error));
            Map response2 = (Map)tuple23._1();
            short error2 = BoxesRunTime.unboxToShort((Object)tuple23._2());
            LeaderAndIsrResponse leaderAndIsrResponse = new LeaderAndIsrResponse(leaderAndIsrRequest.correlationId(), (Map<Tuple2<String, Object>, Object>)response2, error2);
            this.requestChannel().sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(leaderAndIsrResponse)));
        }
        catch (KafkaStorageException kafkaStorageException) {
            this.fatal((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Disk error during leadership change.";
                }
            }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                public static final long serialVersionUID = 0L;
                private final KafkaStorageException e$2;

                public final KafkaStorageException apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            Runtime.getRuntime().halt(1);
        }
    }

    public void handleStopReplicaRequest(RequestChannel.Request request) {
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)request.requestObj();
        Tuple2<scala.collection.mutable.Map<TopicAndPartition, Object>, Object> tuple2 = this.replicaManager().stopReplicas(stopReplicaRequest);
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.mutable.Map response = (scala.collection.mutable.Map)tuple2._1();
            short error = BoxesRunTime.unboxToShort((Object)tuple2._2());
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)response, (Object)BoxesRunTime.boxToShort((short)error));
            scala.collection.mutable.Map response2 = (scala.collection.mutable.Map)tuple23._1();
            short error2 = BoxesRunTime.unboxToShort((Object)tuple23._2());
            StopReplicaResponse stopReplicaResponse = new StopReplicaResponse(stopReplicaRequest.correlationId(), (scala.collection.immutable.Map<TopicAndPartition, Object>)response2.toMap(Predef$.MODULE$.conforms()), error2);
            this.requestChannel().sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(stopReplicaResponse)));
            this.replicaManager().replicaFetcherManager().shutdownIdleFetcherThreads();
            return;
        }
        throw new MatchError(tuple2);
    }

    public void handleUpdateMetadataRequest(RequestChannel.Request request) {
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)request.requestObj();
        this.replicaManager().maybeUpdateMetadataCache(updateMetadataRequest, this.metadataCache());
        UpdateMetadataResponse updateMetadataResponse = new UpdateMetadataResponse(updateMetadataRequest.correlationId(), UpdateMetadataResponse$.MODULE$.$lessinit$greater$default$2());
        this.requestChannel().sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(updateMetadataResponse)));
    }

    public void handleControlledShutdownRequest(RequestChannel.Request request) {
        ControlledShutdownRequest controlledShutdownRequest = (ControlledShutdownRequest)request.requestObj();
        Set<TopicAndPartition> partitionsRemaining = this.controller().shutdownBroker(controlledShutdownRequest.brokerId());
        ControlledShutdownResponse controlledShutdownResponse = new ControlledShutdownResponse(controlledShutdownRequest.correlationId(), ErrorMapping$.MODULE$.NoError(), partitionsRemaining);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(controlledShutdownResponse)));
    }

    private ProducerRequest producerRequestFromOffsetCommit(OffsetCommitRequest offsetCommitRequest) {
        Seq msgs = ((TraversableOnce)offsetCommitRequest.filterLargeMetadata(this.config().offsetMetadataMaxSize()).map((Function1)new Serializable(this, offsetCommitRequest){
            public static final long serialVersionUID = 0L;
            private final OffsetCommitRequest offsetCommitRequest$1;

            public final Message apply(Tuple2<TopicAndPartition, OffsetAndMetadata> x0$1) {
                Tuple2<TopicAndPartition, OffsetAndMetadata> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                    OffsetAndMetadata offset = (OffsetAndMetadata)tuple2._2();
                    Message message = new Message(OffsetManager$.MODULE$.offsetCommitValue(offset), OffsetManager$.MODULE$.offsetCommitKey(this.offsetCommitRequest$1.groupId(), topicAndPartition.topic(), topicAndPartition.partition(), OffsetManager$.MODULE$.offsetCommitKey$default$4()));
                    return message;
                }
                throw new MatchError(tuple2);
            }
            {
                this.offsetCommitRequest$1 = offsetCommitRequest$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        scala.collection.mutable.Map producerData = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(OffsetManager$.MODULE$.OffsetsTopicName(), this.offsetManager().partitionFor(offsetCommitRequest.groupId()))), (Object)new ByteBufferMessageSet(this.config().offsetsTopicCompressionCodec(), (Seq<Message>)msgs))}));
        int x$22 = offsetCommitRequest.correlationId();
        String x$23 = offsetCommitRequest.clientId();
        short x$24 = this.config().offsetCommitRequiredAcks();
        int x$25 = this.config().offsetCommitTimeoutMs();
        scala.collection.mutable.Map x$26 = producerData;
        short x$27 = ProducerRequest$.MODULE$.apply$default$1();
        ProducerRequest request = new ProducerRequest(x$27, x$22, x$23, x$24, x$25, (scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet>)x$26);
        this.trace((Function0<String>)new Serializable(this, offsetCommitRequest, request){
            public static final long serialVersionUID = 0L;
            private final OffsetCommitRequest offsetCommitRequest$1;
            private final ProducerRequest request$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Created producer request %s for offset commit request %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$2, this.offsetCommitRequest$1}));
            }
            {
                this.offsetCommitRequest$1 = offsetCommitRequest$1;
                this.request$2 = request$2;
            }
        });
        return request;
    }

    public void handleProducerOrOffsetCommitRequest(RequestChannel.Request request) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (request.requestId() == RequestKeys$.MODULE$.OffsetCommitKey()) {
            OffsetCommitRequest offsetCommitRequest = (OffsetCommitRequest)request.requestObj();
            tuple22 = new Tuple2((Object)this.producerRequestFromOffsetCommit(offsetCommitRequest), (Object)new Some((Object)offsetCommitRequest));
        } else {
            tuple22 = tuple2 = new Tuple2((Object)((ProducerRequest)request.requestObj()), (Object)None$.MODULE$);
        }
        if (tuple2 != null) {
            Tuple2 tuple23;
            ProducerRequest produceRequest = (ProducerRequest)tuple2._1();
            Option offsetCommitRequestOpt = (Option)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)produceRequest, (Object)offsetCommitRequestOpt);
            ProducerRequest produceRequest2 = (ProducerRequest)tuple24._1();
            Option offsetCommitRequestOpt2 = (Option)tuple24._2();
            long sTime = SystemTime$.MODULE$.milliseconds();
            Iterable<ProduceResult> localProduceResults = this.appendToLocalLog(produceRequest2, offsetCommitRequestOpt2.nonEmpty());
            this.debug((Function0<String>)new Serializable(this, sTime){
                public static final long serialVersionUID = 0L;
                private final long sTime$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Produce to local log in %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(SystemTime$.MODULE$.milliseconds() - this.sTime$1))}));
                }
                {
                    this.sTime$1 = sTime$1;
                }
            });
            short firstErrorCode = BoxesRunTime.unboxToShort((Object)localProduceResults.find((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ProduceResult x$4) {
                    return x$4.errorCode() != ErrorMapping$.MODULE$.NoError();
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final short apply(ProduceResult x$5) {
                    return x$5.errorCode();
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final short apply() {
                    return this.apply$mcS$sp();
                }

                public short apply$mcS$sp() {
                    return ErrorMapping$.MODULE$.NoError();
                }
            }));
            int numPartitionsInError = localProduceResults.count((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ProduceResult x$6) {
                    return x$6.error().isDefined();
                }
            });
            if (produceRequest2.requiredAcks() == 0) {
                if (numPartitionsInError != 0) {
                    this.info((Function0<String>)new Serializable(this, produceRequest2){
                        public static final long serialVersionUID = 0L;
                        private final ProducerRequest produceRequest$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Send the close connection response due to error handling produce request [clientId = %s, correlationId = %s, topicAndPartition = %s] with Ack=0")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.produceRequest$1.clientId(), BoxesRunTime.boxToInteger((int)this.produceRequest$1.correlationId()), this.produceRequest$1.topicPartitionMessageSizeMap().keySet().mkString(",")}));
                        }
                        {
                            this.produceRequest$1 = produceRequest$1;
                        }
                    });
                    this.requestChannel().closeConnection(request.processor(), request);
                } else {
                    if (firstErrorCode == ErrorMapping$.MODULE$.NoError()) {
                        offsetCommitRequestOpt2.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ KafkaApis $outer;

                            public final void apply(OffsetCommitRequest ocr) {
                                this.$outer.offsetManager().putOffsets(ocr.groupId(), (Map<TopicAndPartition, OffsetAndMetadata>)ocr.requestInfo());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    if (offsetCommitRequestOpt2.isDefined()) {
                        OffsetCommitResponse response = ((OffsetCommitRequest)offsetCommitRequestOpt2.get()).responseFor(firstErrorCode, this.config().offsetMetadataMaxSize());
                        this.requestChannel().sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(response)));
                    } else {
                        this.requestChannel().noOperation(request.processor(), request);
                    }
                }
            } else if (produceRequest2.requiredAcks() == 1 || produceRequest2.numPartitions() <= 0 || numPartitionsInError == produceRequest2.numPartitions()) {
                if (firstErrorCode == ErrorMapping$.MODULE$.NoError()) {
                    offsetCommitRequestOpt2.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KafkaApis $outer;

                        public final void apply(OffsetCommitRequest ocr) {
                            this.$outer.offsetManager().putOffsets(ocr.groupId(), (Map<TopicAndPartition, OffsetAndMetadata>)ocr.requestInfo());
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                scala.collection.immutable.Map statuses = ((TraversableOnce)localProduceResults.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicAndPartition, ProducerResponseStatus> apply(ProduceResult r) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)r.key()), (Object)new ProducerResponseStatus(r.errorCode(), r.start()));
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                RequestOrResponse response = (RequestOrResponse)offsetCommitRequestOpt2.map((Function1)new Serializable(this, firstErrorCode){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KafkaApis $outer;
                    private final short firstErrorCode$1;

                    public final OffsetCommitResponse apply(OffsetCommitRequest x$7) {
                        return x$7.responseFor(this.firstErrorCode$1, this.$outer.config().offsetMetadataMaxSize());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.firstErrorCode$1 = firstErrorCode$1;
                    }
                }).getOrElse((Function0)new Serializable(this, produceRequest2, statuses){
                    public static final long serialVersionUID = 0L;
                    private final ProducerRequest produceRequest$1;
                    private final scala.collection.immutable.Map statuses$1;

                    public final ProducerResponse apply() {
                        return new ProducerResponse(this.produceRequest$1.correlationId(), (Map<TopicAndPartition, ProducerResponseStatus>)this.statuses$1);
                    }
                    {
                        this.produceRequest$1 = produceRequest$1;
                        this.statuses$1 = statuses$1;
                    }
                });
                this.requestChannel().sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(response)));
            } else {
                Seq producerRequestKeys = ((TraversableOnce)produceRequest2.data().keys().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopicPartitionRequestKey apply(TopicAndPartition topicAndPartition) {
                        return new TopicPartitionRequestKey(topicAndPartition);
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq();
                scala.collection.immutable.Map statuses = ((TraversableOnce)localProduceResults.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicAndPartition, DelayedProduceResponseStatus> apply(ProduceResult r) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)r.key()), (Object)new DelayedProduceResponseStatus(r.end() + 1L, new ProducerResponseStatus(r.errorCode(), r.start())));
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                DelayedProduce delayedRequest = new DelayedProduce((Seq<TopicPartitionRequestKey>)producerRequestKeys, request, produceRequest2.ackTimeoutMs(), produceRequest2, (scala.collection.immutable.Map<TopicAndPartition, DelayedProduceResponseStatus>)statuses, (Option<OffsetCommitRequest>)offsetCommitRequestOpt2);
                boolean satisfiedByMe = this.producerRequestPurgatory().checkAndMaybeWatch(delayedRequest);
                if (satisfiedByMe) {
                    this.producerRequestPurgatory().respond(delayedRequest);
                }
            }
            produceRequest2.emptyData();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public KafkaApis$ProduceResult$ ProduceResult() {
        return this.ProduceResult$module == null ? this.ProduceResult$lzycompute() : this.ProduceResult$module;
    }

    private Iterable<ProduceResult> appendToLocalLog(ProducerRequest producerRequest, boolean isOffsetCommit) {
        scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet> partitionAndData = producerRequest.data();
        this.trace((Function0<String>)new Serializable(this, (Map)partitionAndData){
            public static final long serialVersionUID = 0L;
            private final Map partitionAndData$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Append [%s] to local log ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionAndData$1.toString()}));
            }
            {
                this.partitionAndData$1 = partitionAndData$1;
            }
        });
        return (Iterable)partitionAndData.map((Function1)new Serializable(this, producerRequest, isOffsetCommit){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            public final ProducerRequest producerRequest$1;
            private final boolean isOffsetCommit$1;

            public final ProduceResult apply(Tuple2<TopicAndPartition, MessageSet> x0$2) {
                ProduceResult produceResult;
                Tuple2<TopicAndPartition, MessageSet> tuple2;
                block12: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block12;
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                    MessageSet messages = (MessageSet)tuple2._2();
                    try {
                        Option<Partition> partitionOpt;
                        Option<Partition> option;
                        block13: {
                            block14: {
                                if (!Topic$.MODULE$.InternalTopics().contains((Object)topicAndPartition.topic())) break block13;
                                if (!this.isOffsetCommit$1) break block14;
                                String string = topicAndPartition.topic();
                                String string2 = OffsetManager$.MODULE$.OffsetsTopicName();
                                if (!(string == null ? string2 != null : !string.equals(string2))) break block13;
                            }
                            throw new InvalidTopicException(new StringOps(Predef$.MODULE$.augmentString("Cannot append to internal topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition.topic()})));
                        }
                        if (!((option = (partitionOpt = this.$outer.replicaManager().getPartition(topicAndPartition.topic(), topicAndPartition.partition()))) instanceof Some)) {
                            None$ none$ = None$.MODULE$;
                            Option<Partition> option2 = option;
                            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                                throw new UnknownTopicOrPartitionException(new StringOps(Predef$.MODULE$.augmentString("Partition %s doesn't exist on %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, BoxesRunTime.boxToInteger((int)this.$outer.brokerId())})));
                            }
                            throw new MatchError(option);
                        }
                        Some some = (Some)option;
                        Partition partition = (Partition)some.x();
                        Log.LogAppendInfo logAppendInfo = partition.appendMessagesToLeader((ByteBufferMessageSet)messages, this.producerRequest$1.requiredAcks());
                        Log.LogAppendInfo info = logAppendInfo;
                        long numAppendedMessages = info.firstOffset() == -1L || info.lastOffset() == -1L ? 0L : info.lastOffset() - info.firstOffset() + 1L;
                        BrokerTopicStats$.MODULE$.getBrokerTopicStats(topicAndPartition.topic()).bytesInRate().mark((long)messages.sizeInBytes());
                        BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesInRate().mark((long)messages.sizeInBytes());
                        BrokerTopicStats$.MODULE$.getBrokerTopicStats(topicAndPartition.topic()).messagesInRate().mark(numAppendedMessages);
                        BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().messagesInRate().mark(numAppendedMessages);
                        this.$outer.trace((Function0<String>)new Serializable(this, topicAndPartition, messages, info){
                            public static final long serialVersionUID = 0L;
                            private final TopicAndPartition topicAndPartition$1;
                            private final MessageSet messages$1;
                            private final Log.LogAppendInfo info$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("%d bytes written to log %s-%d beginning at offset %d and ending at offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.size()), this.topicAndPartition$1.topic(), BoxesRunTime.boxToInteger((int)this.topicAndPartition$1.partition()), BoxesRunTime.boxToLong((long)this.info$1.firstOffset()), BoxesRunTime.boxToLong((long)this.info$1.lastOffset())}));
                            }
                            {
                                this.topicAndPartition$1 = topicAndPartition$1;
                                this.messages$1 = messages$1;
                                this.info$1 = info$1;
                            }
                        });
                        produceResult = new ProduceResult(this.$outer, topicAndPartition, info.firstOffset(), info.lastOffset(), this.$outer.ProduceResult().apply$default$4());
                    }
                    catch (Throwable throwable) {
                        BrokerTopicStats$.MODULE$.getBrokerTopicStats(topicAndPartition.topic()).failedProduceRequestRate().mark();
                        BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().failedProduceRequestRate().mark();
                        this.$outer.error((Function0<String>)new Serializable(this, topicAndPartition){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$appendToLocalLog$2 $outer;
                            private final TopicAndPartition topicAndPartition$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Error processing ProducerRequest with correlation id %d from client %s on partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.producerRequest$1.correlationId()), this.$outer.producerRequest$1.clientId(), this.topicAndPartition$1}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topicAndPartition$1 = topicAndPartition$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$4;

                            public final Throwable apply() {
                                return this.e$4;
                            }
                            {
                                this.e$4 = e$4;
                            }
                        });
                        produceResult = new ProduceResult(this.$outer, topicAndPartition, throwable);
                    }
                    catch (NotEnoughReplicasException notEnoughReplicasException) {
                        this.$outer.warn((Function0<String>)new Serializable(this, topicAndPartition, notEnoughReplicasException){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$appendToLocalLog$2 $outer;
                            private final TopicAndPartition topicAndPartition$1;
                            private final NotEnoughReplicasException nere$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Produce request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.producerRequest$1.correlationId()), this.$outer.producerRequest$1.clientId(), this.topicAndPartition$1, this.nere$1.getMessage()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topicAndPartition$1 = topicAndPartition$1;
                                this.nere$1 = nere$1;
                            }
                        });
                        produceResult = new ProduceResult(this.$outer, topicAndPartition, notEnoughReplicasException);
                    }
                    catch (NotLeaderForPartitionException notLeaderForPartitionException) {
                        this.$outer.warn((Function0<String>)new Serializable(this, topicAndPartition, notLeaderForPartitionException){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$appendToLocalLog$2 $outer;
                            private final TopicAndPartition topicAndPartition$1;
                            private final NotLeaderForPartitionException nle$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Produce request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.producerRequest$1.correlationId()), this.$outer.producerRequest$1.clientId(), this.topicAndPartition$1, this.nle$1.getMessage()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topicAndPartition$1 = topicAndPartition$1;
                                this.nle$1 = nle$1;
                            }
                        });
                        produceResult = new ProduceResult(this.$outer, topicAndPartition, notLeaderForPartitionException);
                    }
                    catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                        this.$outer.warn((Function0<String>)new Serializable(this, topicAndPartition, unknownTopicOrPartitionException){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$appendToLocalLog$2 $outer;
                            private final TopicAndPartition topicAndPartition$1;
                            private final UnknownTopicOrPartitionException utpe$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Produce request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.producerRequest$1.correlationId()), this.$outer.producerRequest$1.clientId(), this.topicAndPartition$1, this.utpe$1.getMessage()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topicAndPartition$1 = topicAndPartition$1;
                                this.utpe$1 = utpe$1;
                            }
                        });
                        produceResult = new ProduceResult(this.$outer, topicAndPartition, unknownTopicOrPartitionException);
                    }
                    catch (InvalidTopicException invalidTopicException) {
                        this.$outer.warn((Function0<String>)new Serializable(this, topicAndPartition, invalidTopicException){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$appendToLocalLog$2 $outer;
                            private final TopicAndPartition topicAndPartition$1;
                            private final InvalidTopicException ite$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Produce request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.producerRequest$1.correlationId()), this.$outer.producerRequest$1.clientId(), this.topicAndPartition$1, this.ite$1.getMessage()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topicAndPartition$1 = topicAndPartition$1;
                                this.ite$1 = ite$1;
                            }
                        });
                        produceResult = new ProduceResult(this.$outer, topicAndPartition, invalidTopicException);
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        this.$outer.fatal((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Halting due to unrecoverable I/O error while handling produce request: ";
                            }
                        }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                            public static final long serialVersionUID = 0L;
                            private final KafkaStorageException e$3;

                            public final KafkaStorageException apply() {
                                return this.e$3;
                            }
                            {
                                this.e$3 = e$3;
                            }
                        });
                        Runtime.getRuntime().halt(1);
                        produceResult = null;
                    }
                }
                throw new MatchError(tuple2);
                ProduceResult produceResult2 = produceResult;
                return produceResult2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.producerRequest$1 = producerRequest$1;
                this.isOffsetCommit$1 = isOffsetCommit$1;
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    public void handleFetchRequest(RequestChannel.Request request) {
        FetchRequest fetchRequest = (FetchRequest)request.requestObj();
        scala.collection.immutable.Map<TopicAndPartition, PartitionDataAndOffset> dataRead = this.replicaManager().readMessageSets(fetchRequest);
        if (fetchRequest.isFromFollower()) {
            this.recordFollowerLogEndOffsets(fetchRequest.replicaId(), (Map<TopicAndPartition, LogOffsetMetadata>)dataRead.mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final LogOffsetMetadata apply(PartitionDataAndOffset x$8) {
                    return x$8.offset();
                }
            }));
        }
        int bytesReadable = BoxesRunTime.unboxToInt((Object)((TraversableOnce)dataRead.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(PartitionDataAndOffset x$9) {
                return x$9.data().messages().sizeInBytes();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        boolean errorReadingData = BoxesRunTime.unboxToBoolean((Object)dataRead.values().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean errorIncurred, PartitionDataAndOffset dataAndOffset) {
                return errorIncurred || dataAndOffset.data().error() != ErrorMapping$.MODULE$.NoError();
            }
        }));
        if (fetchRequest.maxWait() <= 0 || fetchRequest.numPartitions() <= 0 || bytesReadable >= fetchRequest.minBytes() || errorReadingData) {
            this.debug((Function0<String>)new Serializable(this, fetchRequest, dataRead){
                public static final long serialVersionUID = 0L;
                private final FetchRequest fetchRequest$1;
                private final scala.collection.immutable.Map dataRead$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Returning fetch response %s for fetch request with correlation id %d to client %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.dataRead$1.values().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final short apply(PartitionDataAndOffset x$10) {
                            return x$10.data().error();
                        }
                    }, scala.collection.Iterable$.MODULE$.canBuildFrom())).mkString(","), BoxesRunTime.boxToInteger((int)this.fetchRequest$1.correlationId()), this.fetchRequest$1.clientId()}));
                }
                {
                    this.fetchRequest$1 = fetchRequest$1;
                    this.dataRead$1 = dataRead$1;
                }
            });
            FetchResponse response = new FetchResponse(fetchRequest.correlationId(), (scala.collection.immutable.Map<TopicAndPartition, FetchResponsePartitionData>)dataRead.mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final FetchResponsePartitionData apply(PartitionDataAndOffset x$11) {
                    return x$11.data();
                }
            }));
            this.requestChannel().sendResponse(new RequestChannel.Response(request, new FetchResponseSend(response)));
        } else {
            this.debug((Function0<String>)new Serializable(this, fetchRequest){
                public static final long serialVersionUID = 0L;
                private final FetchRequest fetchRequest$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Putting fetch request with correlation id %d from client %s into purgatory")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.fetchRequest$1.correlationId()), this.fetchRequest$1.clientId()}));
                }
                {
                    this.fetchRequest$1 = fetchRequest$1;
                }
            });
            Seq delayedFetchKeys = (Seq)fetchRequest.requestInfo().keys().toSeq().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicPartitionRequestKey apply(TopicAndPartition x$12) {
                    return new TopicPartitionRequestKey(x$12);
                }
            }, Seq$.MODULE$.canBuildFrom());
            DelayedFetch delayedFetch = new DelayedFetch((Seq<TopicPartitionRequestKey>)delayedFetchKeys, request, fetchRequest.maxWait(), fetchRequest, (scala.collection.immutable.Map<TopicAndPartition, LogOffsetMetadata>)dataRead.mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final LogOffsetMetadata apply(PartitionDataAndOffset x$13) {
                    return x$13.offset();
                }
            }));
            boolean satisfiedByMe = this.fetchRequestPurgatory().checkAndMaybeWatch(delayedFetch);
            if (satisfiedByMe) {
                this.fetchRequestPurgatory().respond(delayedFetch);
            }
        }
    }

    private void recordFollowerLogEndOffsets(int replicaId, Map<TopicAndPartition, LogOffsetMetadata> offsets) {
        this.debug((Function0<String>)new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final Map offsets$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Record follower log end offsets: %s ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offsets$1}));
            }
            {
                this.offsets$1 = offsets$1;
            }
        });
        offsets.foreach((Function1)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            private final int replicaId$1;

            public final void apply(Tuple2<TopicAndPartition, LogOffsetMetadata> x0$3) {
                Tuple2<TopicAndPartition, LogOffsetMetadata> tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                    LogOffsetMetadata offset = (LogOffsetMetadata)tuple2._2();
                    this.$outer.replicaManager().updateReplicaLEOAndPartitionHW(topicAndPartition.topic(), topicAndPartition.partition(), this.replicaId$1, offset);
                    this.$outer.replicaManager().unblockDelayedProduceRequests(new TopicPartitionRequestKey(topicAndPartition));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        });
    }

    public void handleOffsetRequest(RequestChannel.Request request) {
        OffsetRequest offsetRequest = (OffsetRequest)request.requestObj();
        scala.collection.immutable.Map responseMap = (scala.collection.immutable.Map)offsetRequest.requestInfo().map((Function1)new Serializable(this, offsetRequest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaApis $outer;
            public final OffsetRequest offsetRequest$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<TopicAndPartition, PartitionOffsetsResponse> apply(Tuple2<TopicAndPartition, PartitionOffsetRequestInfo> elem) {
                Tuple2 tuple2;
                Tuple2 tuple23;
                Tuple2<TopicAndPartition, PartitionOffsetRequestInfo> tuple22 = elem;
                if (tuple22 == null) throw new MatchError(tuple22);
                TopicAndPartition topicAndPartition2 = (TopicAndPartition)tuple22._1();
                PartitionOffsetRequestInfo partitionOffsetRequestInfo = (PartitionOffsetRequestInfo)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)topicAndPartition2, (Object)partitionOffsetRequestInfo);
                TopicAndPartition topicAndPartition = (TopicAndPartition)tuple24._1();
                PartitionOffsetRequestInfo partitionOffsetRequestInfo2 = (PartitionOffsetRequestInfo)tuple24._2();
                try {
                    Seq seq;
                    Replica localReplica = this.offsetRequest$1.isFromDebuggingClient() ? this.$outer.replicaManager().getReplicaOrException(topicAndPartition.topic(), topicAndPartition.partition()) : this.$outer.replicaManager().getLeaderReplicaIfLocal(topicAndPartition.topic(), topicAndPartition.partition());
                    Seq allOffsets = this.$outer.fetchOffsets(this.$outer.replicaManager().logManager(), topicAndPartition, partitionOffsetRequestInfo2.time(), partitionOffsetRequestInfo2.maxNumOffsets());
                    if (this.offsetRequest$1.isFromOrdinaryClient()) {
                        long hw = localReplica.highWatermark().messageOffset();
                        if (allOffsets.exists((Function1)new Serializable(this, hw){
                            public static final long serialVersionUID = 0L;
                            private final long hw$1;

                            public final boolean apply(long x$15) {
                                return this.apply$mcZJ$sp(x$15);
                            }

                            public boolean apply$mcZJ$sp(long x$15) {
                                return x$15 > this.hw$1;
                            }
                            {
                                this.hw$1 = hw$1;
                            }
                        })) {
                            long l = hw;
                            seq = (Seq)((SeqLike)allOffsets.dropWhile((Function1)new Serializable(this, hw){
                                public static final long serialVersionUID = 0L;
                                private final long hw$1;

                                public final boolean apply(long x$16) {
                                    return this.apply$mcZJ$sp(x$16);
                                }

                                public boolean apply$mcZJ$sp(long x$16) {
                                    return x$16 > this.hw$1;
                                }
                                {
                                    this.hw$1 = hw$1;
                                }
                            })).$plus$colon((Object)BoxesRunTime.boxToLong((long)l), Seq$.MODULE$.canBuildFrom());
                        } else {
                            seq = allOffsets;
                        }
                    } else {
                        seq = allOffsets;
                    }
                    Seq offsets = seq;
                    tuple2 = new Tuple2((Object)topicAndPartition, (Object)new PartitionOffsetsResponse(ErrorMapping$.MODULE$.NoError(), offsets));
                    return tuple2;
                }
                catch (Throwable throwable) {
                    this.$outer.warn((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Error while responding to offset request";
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$5;

                        public final Throwable apply() {
                            return this.e$5;
                        }
                        {
                            this.e$5 = e$5;
                        }
                    });
                    tuple2 = new Tuple2((Object)topicAndPartition, (Object)new PartitionOffsetsResponse(ErrorMapping$.MODULE$.codeFor(throwable.getClass()), (Seq<Object>)Nil$.MODULE$));
                    return tuple2;
                }
                catch (NotLeaderForPartitionException notLeaderForPartitionException) {
                    this.$outer.warn((Function0<String>)new Serializable(this, topicAndPartition, notLeaderForPartitionException){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$18 $outer;
                        private final TopicAndPartition topicAndPartition$2;
                        private final NotLeaderForPartitionException nle$2;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Offset request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.offsetRequest$1.correlationId()), this.$outer.offsetRequest$1.clientId(), this.topicAndPartition$2, this.nle$2.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.topicAndPartition$2 = topicAndPartition$2;
                            this.nle$2 = nle$2;
                        }
                    });
                    tuple2 = new Tuple2((Object)topicAndPartition, (Object)new PartitionOffsetsResponse(ErrorMapping$.MODULE$.codeFor(notLeaderForPartitionException.getClass()), (Seq<Object>)Nil$.MODULE$));
                    return tuple2;
                }
                catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                    this.$outer.warn((Function0<String>)new Serializable(this, topicAndPartition, unknownTopicOrPartitionException){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$18 $outer;
                        private final TopicAndPartition topicAndPartition$2;
                        private final UnknownTopicOrPartitionException utpe$2;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Offset request with correlation id %d from client %s on partition %s failed due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.offsetRequest$1.correlationId()), this.$outer.offsetRequest$1.clientId(), this.topicAndPartition$2, this.utpe$2.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.topicAndPartition$2 = topicAndPartition$2;
                            this.utpe$2 = utpe$2;
                        }
                    });
                    tuple2 = new Tuple2((Object)topicAndPartition, (Object)new PartitionOffsetsResponse(ErrorMapping$.MODULE$.codeFor(unknownTopicOrPartitionException.getClass()), (Seq<Object>)Nil$.MODULE$));
                }
                return tuple2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetRequest$1 = offsetRequest$1;
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        OffsetResponse response = new OffsetResponse(offsetRequest.correlationId(), (scala.collection.immutable.Map<TopicAndPartition, PartitionOffsetsResponse>)responseMap);
        this.requestChannel().sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(response)));
    }

    public Seq<Object> fetchOffsets(LogManager logManager, TopicAndPartition topicAndPartition, long timestamp, int maxNumOffsets) {
        Option<Log> option;
        block4: {
            Nil$ nil$;
            block3: {
                block2: {
                    option = logManager.getLog(topicAndPartition);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Log log = (Log)some.x();
                    nil$ = this.fetchOffsetsBefore(log, timestamp, maxNumOffsets);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Log> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                nil$ = timestamp == OffsetRequest$.MODULE$.LatestTime() || timestamp == OffsetRequest$.MODULE$.EarliestTime() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})) : Nil$.MODULE$;
            }
            return nil$;
        }
        throw new MatchError(option);
    }

    public Seq<Object> fetchOffsetsBefore(Log log, long timestamp, int maxNumOffsets) {
        LogSegment[] segsArray = (LogSegment[])log.logSegments().toArray(ClassTag$.MODULE$.apply(LogSegment.class));
        ObjectRef offsetTimeArray = new ObjectRef(null);
        offsetTimeArray.elem = ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray).last()).size() > 0L ? new Tuple2[segsArray.length + 1] : new Tuple2[segsArray.length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segsArray.length).foreach$mVc$sp((Function1)new Serializable(this, segsArray, offsetTimeArray){
            public static final long serialVersionUID = 0L;
            private final LogSegment[] segsArray$1;
            private final ObjectRef offsetTimeArray$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ((Tuple2[])this.offsetTimeArray$1.elem)[i] = new Tuple2.mcJJ.sp(this.segsArray$1[i].baseOffset(), this.segsArray$1[i].lastModified());
            }
            {
                this.segsArray$1 = segsArray$1;
                this.offsetTimeArray$1 = offsetTimeArray$1;
            }
        });
        if (((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray).last()).size() > 0L) {
            ((Tuple2[])offsetTimeArray.elem)[segsArray.length] = new Tuple2.mcJJ.sp(log.logEndOffset(), SystemTime$.MODULE$.milliseconds());
        }
        IntRef startIndex = new IntRef(-1);
        long l = timestamp;
        if (OffsetRequest$.MODULE$.LatestTime() == l) {
            startIndex.elem = ((Tuple2[])offsetTimeArray.elem).length - 1;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OffsetRequest$.MODULE$.EarliestTime() == l) {
            startIndex.elem = 0;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean isFound = false;
            this.debug((Function0<String>)new Serializable(this, offsetTimeArray){
                public static final long serialVersionUID = 0L;
                private final ObjectRef offsetTimeArray$1;

                public final String apply() {
                    StringBuilder stringBuilder = new StringBuilder().append((Object)"Offset time array = ");
                    Predef$.MODULE$.refArrayOps((Object[])((Tuple2[])this.offsetTimeArray$1.elem)).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<Object, Object> o) {
                            return new StringOps(Predef$.MODULE$.augmentString("%d, %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)o._1$mcJ$sp()), BoxesRunTime.boxToLong((long)o._2$mcJ$sp())}));
                        }
                    });
                    return stringBuilder.append((Object)BoxedUnit.UNIT).toString();
                }
                {
                    this.offsetTimeArray$1 = offsetTimeArray$1;
                }
            });
            startIndex.elem = ((Tuple2[])offsetTimeArray.elem).length - 1;
            while (startIndex.elem >= 0 && !isFound) {
                if (((Tuple2[])offsetTimeArray.elem)[startIndex.elem]._2$mcJ$sp() <= timestamp) {
                    isFound = true;
                    continue;
                }
                --startIndex.elem;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        int retSize = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(maxNumOffsets), startIndex.elem + 1);
        long[] ret = new long[retSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), retSize).foreach$mVc$sp((Function1)new Serializable(this, offsetTimeArray, startIndex, ret){
            public static final long serialVersionUID = 0L;
            private final ObjectRef offsetTimeArray$1;
            private final IntRef startIndex$1;
            private final long[] ret$1;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                this.ret$1[j] = ((Tuple2[])this.offsetTimeArray$1.elem)[this.startIndex$1.elem]._1$mcJ$sp();
                --this.startIndex$1.elem;
            }
            {
                this.offsetTimeArray$1 = offsetTimeArray$1;
                this.startIndex$1 = startIndex$1;
                this.ret$1 = ret$1;
            }
        });
        return (Seq)Predef$.MODULE$.longArrayOps(ret).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$18) {
                return this.apply$mcJJ$sp(x$18);
            }

            public long apply$mcJJ$sp(long x$18) {
                return -x$18;
            }
        }, (Ordering)Ordering.Long$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TopicMetadata> getTopicMetadata(Set<String> topics) {
        void var2_2;
        ListBuffer<TopicMetadata> topicResponses = this.metadataCache().getTopicMetadata(topics);
        if (topics.size() > 0 && topicResponses.size() != topics.size()) {
            Set nonExistentTopics = (Set)topics.$minus$minus((GenTraversableOnce)((TraversableForwarder)topicResponses.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(TopicMetadata x$19) {
                    return x$19.topic();
                }
            }, ListBuffer$.MODULE$.canBuildFrom())).toSet());
            Set responsesForNonExistentTopics = (Set)nonExistentTopics.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaApis $outer;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final TopicMetadata apply(String topic) {
                    TopicMetadata topicMetadata;
                    String string = topic;
                    String string2 = OffsetManager$.MODULE$.OffsetsTopicName();
                    if ((string == null ? string2 != null : !string.equals(string2)) && !this.$outer.config().autoCreateTopicsEnable()) {
                        topicMetadata = new TopicMetadata(topic, (Seq<PartitionMetadata>)((Seq)Seq$.MODULE$.empty()), ErrorMapping$.MODULE$.UnknownTopicOrPartitionCode());
                        return topicMetadata;
                    }
                    try {
                        String string3 = topic;
                        String string4 = OffsetManager$.MODULE$.OffsetsTopicName();
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            AdminUtils$.MODULE$.createTopic(this.$outer.zkClient(), topic, this.$outer.config().offsetsTopicPartitions(), this.$outer.config().offsetsTopicReplicationFactor(), this.$outer.offsetManager().offsetsTopicConfig());
                            this.$outer.info((Function0<String>)new Serializable(this, topic){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$20 $outer;
                                private final String topic$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Auto creation of topic %s with %d partitions and replication factor %d is successful!")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaApis$$anonfun$$$outer().config().offsetsTopicPartitions()), BoxesRunTime.boxToShort((short)this.$outer.kafka$server$KafkaApis$$anonfun$$$outer().config().offsetsTopicReplicationFactor())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topic$1 = topic$1;
                                }
                            });
                        } else {
                            AdminUtils$.MODULE$.createTopic(this.$outer.zkClient(), topic, this.$outer.config().numPartitions(), this.$outer.config().defaultReplicationFactor(), AdminUtils$.MODULE$.createTopic$default$5());
                            this.$outer.info((Function0<String>)new Serializable(this, topic){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$20 $outer;
                                private final String topic$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Auto creation of topic %s with %d partitions and replication factor %d is successful!")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaApis$$anonfun$$$outer().config().numPartitions()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaApis$$anonfun$$$outer().config().defaultReplicationFactor())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topic$1 = topic$1;
                                }
                            });
                        }
                    }
                    catch (TopicExistsException topicExistsException) {
                        // empty catch block
                    }
                    topicMetadata = new TopicMetadata(topic, (Seq<PartitionMetadata>)((Seq)Seq$.MODULE$.empty()), ErrorMapping$.MODULE$.LeaderNotAvailableCode());
                    return topicMetadata;
                }

                public /* synthetic */ KafkaApis kafka$server$KafkaApis$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom());
            topicResponses.appendAll((TraversableOnce)responsesForNonExistentTopics);
        }
        return var2_2;
    }

    public void handleTopicMetadataRequest(RequestChannel.Request request) {
        TopicMetadataRequest metadataRequest = (TopicMetadataRequest)request.requestObj();
        Seq<TopicMetadata> topicMetadata = this.getTopicMetadata((Set<String>)metadataRequest.topics().toSet());
        Seq<Broker> brokers = this.metadataCache().getAliveBrokers();
        this.trace((Function0<String>)new Serializable(this, metadataRequest, topicMetadata, brokers){
            public static final long serialVersionUID = 0L;
            private final TopicMetadataRequest metadataRequest$1;
            private final Seq topicMetadata$1;
            private final Seq brokers$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Sending topic metadata %s and brokers %s for correlation id %d to client %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicMetadata$1.mkString(","), this.brokers$1.mkString(","), BoxesRunTime.boxToInteger((int)this.metadataRequest$1.correlationId()), this.metadataRequest$1.clientId()}));
            }
            {
                this.metadataRequest$1 = metadataRequest$1;
                this.topicMetadata$1 = topicMetadata$1;
                this.brokers$1 = brokers$1;
            }
        });
        TopicMetadataResponse response = new TopicMetadataResponse(brokers, topicMetadata, metadataRequest.correlationId());
        this.requestChannel().sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(response)));
    }

    public void handleOffsetFetchRequest(RequestChannel.Request request) {
        OffsetFetchRequest offsetFetchRequest = (OffsetFetchRequest)request.requestObj();
        Tuple2 tuple2 = offsetFetchRequest.requestInfo().partition((Function1)new $anonfun$21(this));
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq unknownTopicPartitions = (Seq)tuple2._1();
            Seq knownTopicPartitions = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)unknownTopicPartitions, (Object)knownTopicPartitions);
            Seq unknownTopicPartitions2 = (Seq)tuple23._1();
            Seq knownTopicPartitions2 = (Seq)tuple23._2();
            scala.collection.immutable.Map unknownStatus = ((TraversableOnce)unknownTopicPartitions2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicAndPartition, OffsetMetadataAndError> apply(TopicAndPartition topicAndPartition) {
                    return new Tuple2((Object)topicAndPartition, (Object)OffsetMetadataAndError$.MODULE$.UnknownTopicOrPartition());
                }
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
            scala.collection.immutable.Map knownStatus = this.offsetManager().getOffsets(offsetFetchRequest.groupId(), (Seq<TopicAndPartition>)knownTopicPartitions2).toMap(Predef$.MODULE$.conforms());
            scala.collection.immutable.Map status = unknownStatus.$plus$plus((GenTraversableOnce)knownStatus);
            OffsetFetchResponse response = new OffsetFetchResponse((scala.collection.immutable.Map<TopicAndPartition, OffsetMetadataAndError>)status, offsetFetchRequest.correlationId());
            this.trace((Function0<String>)new Serializable(this, offsetFetchRequest, response){
                public static final long serialVersionUID = 0L;
                private final OffsetFetchRequest offsetFetchRequest$1;
                private final OffsetFetchResponse response$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Sending offset fetch response %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1, BoxesRunTime.boxToInteger((int)this.offsetFetchRequest$1.correlationId()), this.offsetFetchRequest$1.clientId()}));
                }
                {
                    this.offsetFetchRequest$1 = offsetFetchRequest$1;
                    this.response$1 = response$1;
                }
            });
            this.requestChannel().sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(response)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public void handleConsumerMetadataRequest(RequestChannel.Request request) {
        ConsumerMetadataRequest consumerMetadataRequest = (ConsumerMetadataRequest)request.requestObj();
        int partition = this.offsetManager().partitionFor(consumerMetadataRequest.group());
        TopicMetadata offsetsTopicMetadata = (TopicMetadata)this.getTopicMetadata((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{OffsetManager$.MODULE$.OffsetsTopicName()})))).head();
        ConsumerMetadataResponse errorResponse = new ConsumerMetadataResponse((Option<Broker>)None$.MODULE$, ErrorMapping$.MODULE$.ConsumerCoordinatorNotAvailableCode(), consumerMetadataRequest.correlationId());
        ConsumerMetadataResponse response = (ConsumerMetadataResponse)offsetsTopicMetadata.partitionsMetadata().find((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final int partition$1;

            public final boolean apply(PartitionMetadata x$21) {
                return x$21.partitionId() == this.partition$1;
            }
            {
                this.partition$1 = partition$1;
            }
        }).map((Function1)new Serializable(this, consumerMetadataRequest, errorResponse){
            public static final long serialVersionUID = 0L;
            public final ConsumerMetadataRequest consumerMetadataRequest$1;
            public final ConsumerMetadataResponse errorResponse$1;

            public final ConsumerMetadataResponse apply(PartitionMetadata partitionMetadata) {
                return (ConsumerMetadataResponse)partitionMetadata.leader().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$24 $outer;

                    public final ConsumerMetadataResponse apply(Broker leader) {
                        return new ConsumerMetadataResponse((Option<Broker>)new Some((Object)leader), ErrorMapping$.MODULE$.NoError(), this.$outer.consumerMetadataRequest$1.correlationId());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$24 $outer;

                    public final ConsumerMetadataResponse apply() {
                        return this.$outer.errorResponse$1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.consumerMetadataRequest$1 = consumerMetadataRequest$1;
                this.errorResponse$1 = errorResponse$1;
            }
        }).getOrElse((Function0)new Serializable(this, errorResponse){
            public static final long serialVersionUID = 0L;
            private final ConsumerMetadataResponse errorResponse$1;

            public final ConsumerMetadataResponse apply() {
                return this.errorResponse$1;
            }
            {
                this.errorResponse$1 = errorResponse$1;
            }
        });
        this.trace((Function0<String>)new Serializable(this, consumerMetadataRequest, response){
            public static final long serialVersionUID = 0L;
            private final ConsumerMetadataRequest consumerMetadataRequest$1;
            private final ConsumerMetadataResponse response$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Sending consumer metadata %s for correlation id %d to client %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$2, BoxesRunTime.boxToInteger((int)this.consumerMetadataRequest$1.correlationId()), this.consumerMetadataRequest$1.clientId()}));
            }
            {
                this.consumerMetadataRequest$1 = consumerMetadataRequest$1;
                this.response$2 = response$2;
            }
        });
        this.requestChannel().sendResponse(new RequestChannel.Response(request, new BoundedByteBufferSend(response)));
    }

    public void close() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down.";
            }
        });
        this.fetchRequestPurgatory().shutdown();
        this.producerRequestPurgatory().shutdown();
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shut down complete.";
            }
        });
    }

    public KafkaApis(RequestChannel requestChannel, ReplicaManager replicaManager, OffsetManager offsetManager, ZkClient zkClient, int brokerId, KafkaConfig config, KafkaController controller) {
        this.requestChannel = requestChannel;
        this.replicaManager = replicaManager;
        this.offsetManager = offsetManager;
        this.zkClient = zkClient;
        this.brokerId = brokerId;
        this.config = config;
        this.controller = controller;
        Logging$class.$init$(this);
        this.producerRequestPurgatory = new ProducerRequestPurgatory(replicaManager, offsetManager, requestChannel);
        this.fetchRequestPurgatory = new FetchRequestPurgatory(replicaManager, requestChannel);
        replicaManager.initWithRequestPurgatory(this.producerRequestPurgatory(), this.fetchRequestPurgatory());
        this.metadataCache = new MetadataCache();
        this.logIdent_$eq(new StringOps(Predef$.MODULE$.augmentString("[KafkaApi-%d] ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
    }

    public class ProduceResult
    implements Product,
    Serializable {
        private final TopicAndPartition key;
        private final long start;
        private final long end;
        private final Option<Throwable> error;
        public final /* synthetic */ KafkaApis $outer;

        public TopicAndPartition key() {
            return this.key;
        }

        public long start() {
            return this.start;
        }

        public long end() {
            return this.end;
        }

        public Option<Throwable> error() {
            return this.error;
        }

        public short errorCode() {
            Option<Throwable> option;
            block4: {
                short s;
                block3: {
                    block2: {
                        option = this.error();
                        None$ none$ = None$.MODULE$;
                        Option<Throwable> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                        s = ErrorMapping$.MODULE$.NoError();
                        break block3;
                    }
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    Throwable error = (Throwable)some.x();
                    s = ErrorMapping$.MODULE$.codeFor(error.getClass());
                }
                return s;
            }
            throw new MatchError(option);
        }

        public ProduceResult copy(TopicAndPartition key, long start, long end, Option<Throwable> error) {
            return new ProduceResult(this.kafka$server$KafkaApis$ProduceResult$$$outer(), key, start, end, error);
        }

        public TopicAndPartition copy$default$1() {
            return this.key();
        }

        public long copy$default$2() {
            return this.start();
        }

        public long copy$default$3() {
            return this.end();
        }

        public Option<Throwable> copy$default$4() {
            return this.error();
        }

        public String productPrefix() {
            return "ProduceResult";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = this.error();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.end());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.start());
                    break;
                }
                case 0: {
                    object = this.key();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ProduceResult;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.key()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.start()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.end()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.error()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ProduceResult)) return false;
            if (((ProduceResult)object).kafka$server$KafkaApis$ProduceResult$$$outer() != this.kafka$server$KafkaApis$ProduceResult$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ProduceResult produceResult = (ProduceResult)x$1;
            TopicAndPartition topicAndPartition = this.key();
            TopicAndPartition topicAndPartition2 = produceResult.key();
            if (topicAndPartition == null) {
                if (topicAndPartition2 != null) {
                    return false;
                }
            } else if (!((Object)topicAndPartition).equals(topicAndPartition2)) return false;
            if (this.start() != produceResult.start()) return false;
            if (this.end() != produceResult.end()) return false;
            Option<Throwable> option = this.error();
            Option<Throwable> option2 = produceResult.error();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!produceResult.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ KafkaApis kafka$server$KafkaApis$ProduceResult$$$outer() {
            return this.$outer;
        }

        public ProduceResult(KafkaApis $outer, TopicAndPartition key, long start, long end, Option<Throwable> error) {
            this.key = key;
            this.start = start;
            this.end = end;
            this.error = error;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }

        public ProduceResult(KafkaApis $outer, TopicAndPartition key, Throwable throwable) {
            this($outer, key, -1L, -1L, (Option<Throwable>)new Some((Object)throwable));
        }
    }
}

