/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.api.FetchResponse;
import kafka.api.FetchResponseSend;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.RequestChannel;
import kafka.server.DelayedFetch;
import kafka.server.ReplicaManager;
import kafka.server.RequestPurgatory;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u000f\t)b)\u001a;dQJ+\u0017/^3tiB+(oZ1u_JL(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001cA\u0005\u000b\u00195\t!!\u0003\u0002\f\u0005\t\u0001\"+Z9vKN$\b+\u001e:hCR|'/\u001f\t\u0003\u00135I!A\u0004\u0002\u0003\u0019\u0011+G.Y=fI\u001a+Go\u00195\t\u0011A\u0001!\u0011!Q\u0001\nE\taB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002\n%%\u00111C\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!)\u0002A!A!\u0002\u00131\u0012A\u0004:fcV,7\u000f^\"iC:tW\r\u001c\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\tqA\\3uo>\u00148.\u0003\u0002\u001c1\tq!+Z9vKN$8\t[1o]\u0016d\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0002 A\u0005\u0002\"!\u0003\u0001\t\u000bAa\u0002\u0019A\t\t\u000bUa\u0002\u0019\u0001\f\u0007\t\r\u0002A\u0001\n\u0002\u001b\t\u0016d\u0017-_3e\r\u0016$8\r\u001b*fcV,7\u000f^'fiJL7m]\n\u0004E\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-_5\tQF\u0003\u0002/\t\u00059Q.\u001a;sS\u000e\u001c\u0018B\u0001\u0019.\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\u0005\te\t\u0012\t\u0011)A\u0005g\u0005Yam\u001c:G_2dwn^3s!\t1C'\u0003\u00026O\t9!i\\8mK\u0006t\u0007\"B\u000f#\t\u00039DC\u0001\u001d;!\tI$%D\u0001\u0001\u0011\u0015\u0011d\u00071\u00014\u0011\u001da$E1A\u0005\nu\nA\"\\3ue&\u001c\u0007K]3gSb,\u0012A\u0010\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bA\u0001\\1oO*\t1)\u0001\u0003kCZ\f\u0017BA#A\u0005\u0019\u0019FO]5oO\"1qI\tQ\u0001\ny\nQ\"\\3ue&\u001c\u0007K]3gSb\u0004\u0003bB%#\u0005\u0004%\tAS\u0001\u0014Kb\u0004\u0018N]3e%\u0016\fX/Z:u\u001b\u0016$XM]\u000b\u0002\u0017B\u0011A\nV\u0007\u0002\u001b*\u0011ajT\u0001\u0005G>\u0014XM\u0003\u0002/!*\u0011\u0011KU\u0001\u0007s\u0006lW.\u001a:\u000b\u0003M\u000b1aY8n\u0013\t)VJA\u0003NKR,'\u000f\u0003\u0004XE\u0001\u0006IaS\u0001\u0015Kb\u0004\u0018N]3e%\u0016\fX/Z:u\u001b\u0016$XM\u001d\u0011\t\u000fe\u0003!\u0019!C\u00055\u0006!\u0013mZ4sK\u001e\fG/\u001a$pY2|w/\u001a:GKR\u001c\u0007NU3rk\u0016\u001cH/T3ue&\u001c7/F\u00019\u0011\u0019a\u0006\u0001)A\u0005q\u0005)\u0013mZ4sK\u001e\fG/\u001a$pY2|w/\u001a:GKR\u001c\u0007NU3rk\u0016\u001cH/T3ue&\u001c7\u000f\t\u0005\b=\u0002\u0011\r\u0011\"\u0003[\u0003\u001d\nwm\u001a:fO\u0006$XMT8o\r>dGn\\<fe\u001a+Go\u00195SKF,Xm\u001d;NKR\u0014\u0018nY:\t\r\u0001\u0004\u0001\u0015!\u00039\u0003!\nwm\u001a:fO\u0006$XMT8o\r>dGn\\<fe\u001a+Go\u00195SKF,Xm\u001d;NKR\u0014\u0018nY:!\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0003e\u0011XmY8sI\u0012+G.Y=fI\u001a+Go\u00195FqBL'/\u001a3\u0015\u0005\u0011<\u0007C\u0001\u0014f\u0013\t1wE\u0001\u0003V]&$\b\"\u0002\u001ab\u0001\u0004\u0019\u0004\"B5\u0001\t\u0003Q\u0017AD2iK\u000e\\7+\u0019;jg\u001aLW\r\u001a\u000b\u0003g-DQ\u0001\u001c5A\u00021\tA\u0002Z3mCf,GMR3uG\"DQA\u001c\u0001\u0005\u0002=\fa!\u001a=qSJ,GC\u00013q\u0011\u0015aW\u000e1\u0001\r\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\u001d\u0011Xm\u001d9p]\u0012$\"\u0001\u001a;\t\u000b1\f\b\u0019\u0001\u0007")
public class FetchRequestPurgatory
extends RequestPurgatory<DelayedFetch> {
    private final ReplicaManager replicaManager;
    private final RequestChannel requestChannel;
    private final DelayedFetchRequestMetrics aggregateFollowerFetchRequestMetrics;
    private final DelayedFetchRequestMetrics aggregateNonFollowerFetchRequestMetrics;

    private DelayedFetchRequestMetrics aggregateFollowerFetchRequestMetrics() {
        return this.aggregateFollowerFetchRequestMetrics;
    }

    private DelayedFetchRequestMetrics aggregateNonFollowerFetchRequestMetrics() {
        return this.aggregateNonFollowerFetchRequestMetrics;
    }

    private void recordDelayedFetchExpired(boolean forFollower) {
        DelayedFetchRequestMetrics metrics = forFollower ? this.aggregateFollowerFetchRequestMetrics() : this.aggregateNonFollowerFetchRequestMetrics();
        metrics.expiredRequestMeter().mark();
    }

    @Override
    public boolean checkSatisfied(DelayedFetch delayedFetch) {
        return delayedFetch.isSatisfied(this.replicaManager);
    }

    @Override
    public void expire(DelayedFetch delayedFetch) {
        this.debug((Function0<String>)new Serializable(this, delayedFetch){
            public static final long serialVersionUID = 0L;
            private final DelayedFetch delayedFetch$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Expiring fetch request %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.delayedFetch$1.fetch()}));
            }
            {
                this.delayedFetch$1 = delayedFetch$1;
            }
        });
        boolean fromFollower = delayedFetch.fetch().isFromFollower();
        this.recordDelayedFetchExpired(fromFollower);
        this.respond(delayedFetch);
    }

    public void respond(DelayedFetch delayedFetch) {
        FetchResponse response = delayedFetch.respond(this.replicaManager);
        this.requestChannel.sendResponse(new RequestChannel.Response(delayedFetch.request(), new FetchResponseSend(response)));
    }

    public FetchRequestPurgatory(ReplicaManager replicaManager, RequestChannel requestChannel) {
        this.replicaManager = replicaManager;
        this.requestChannel = requestChannel;
        super(replicaManager.config().brokerId(), replicaManager.config().fetchPurgatoryPurgeIntervalRequests());
        this.logIdent_$eq(new StringOps(Predef$.MODULE$.augmentString("[FetchRequestPurgatory-%d] ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaManager.config().brokerId())})));
        this.aggregateFollowerFetchRequestMetrics = new DelayedFetchRequestMetrics(true);
        this.aggregateNonFollowerFetchRequestMetrics = new DelayedFetchRequestMetrics(false);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class DelayedFetchRequestMetrics
    implements KafkaMetricsGroup {
        private final String metricPrefix;
        private final Meter expiredRequestMeter;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public <T> Gauge<T> newGauge(String name, Gauge<T> metric) {
            return KafkaMetricsGroup$class.newGauge(this, name, metric);
        }

        @Override
        public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
            return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
        }

        @Override
        public Histogram newHistogram(String name, boolean biased) {
            return KafkaMetricsGroup$class.newHistogram(this, name, biased);
        }

        @Override
        public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
            return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
        }

        @Override
        public void removeMetric(String name) {
            KafkaMetricsGroup$class.removeMetric(this, name);
        }

        @Override
        public boolean newHistogram$default$2() {
            return KafkaMetricsGroup$class.newHistogram$default$2(this);
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            DelayedFetchRequestMetrics delayedFetchRequestMetrics = this;
            synchronized (delayedFetchRequestMetrics) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
            this.loggerName = x$1;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
            this.kafka$utils$Logging$$log4jController = x$1;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        private String metricPrefix() {
            return this.metricPrefix;
        }

        public Meter expiredRequestMeter() {
            return this.expiredRequestMeter;
        }

        public /* synthetic */ FetchRequestPurgatory kafka$server$FetchRequestPurgatory$DelayedFetchRequestMetrics$$$outer() {
            return FetchRequestPurgatory.this;
        }

        public DelayedFetchRequestMetrics(boolean forFollower) {
            if (FetchRequestPurgatory.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            KafkaMetricsGroup$class.$init$(this);
            this.metricPrefix = forFollower ? "Follower" : "Consumer";
            this.expiredRequestMeter = this.newMeter(new StringBuilder().append((Object)this.metricPrefix()).append((Object)"ExpiresPerSecond").toString(), "requests", TimeUnit.SECONDS);
        }
    }
}

