/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsrRequest;
import kafka.api.PartitionStateInfo;
import kafka.api.StopReplicaRequest;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.ReplicaNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.HighwaterMarkCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager$;
import kafka.utils.KafkaScheduler;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Time;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rMr!B\u0001\u0003\u0011\u00039\u0011A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u00148CA\u0005\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\")1#\u0003C\u0001)\u00051A(\u001b8jiz\"\u0012a\u0002\u0005\b-%\u0011\r\u0011\"\u0001\u0018\u0003M)fn\u001b8po:dunZ#oI>3gm]3u+\u0005A\u0002CA\u0007\u001a\u0013\tQbB\u0001\u0003M_:<\u0007B\u0002\u000f\nA\u0003%\u0001$\u0001\u000bV].twn\u001e8M_\u001e,e\u000eZ(gMN,G\u000f\t\u0004\u0005\u0015\t\u0001ad\u0005\u0003\u001e\u0019})\u0003C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003\u0015)H/\u001b7t\u0013\t!\u0013EA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\"\u0011aB7fiJL7m]\u0005\u0003U\u001d\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011!aSD!b\u0001\n\u0003i\u0013AB2p]\u001aLw-F\u0001/!\tAq&\u0003\u00021\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011!\u0011TD!A!\u0002\u0013q\u0013aB2p]\u001aLw\r\t\u0005\tiu\u0011\t\u0011)A\u0005k\u0005!A/[7f!\t\u0001c'\u0003\u00028C\t!A+[7f\u0011!ITD!b\u0001\n\u0003Q\u0014\u0001\u0003>l\u00072LWM\u001c;\u0016\u0003m\u0002\"\u0001P\"\u000e\u0003uR!AP \u0002\u0011i\\7\r\\5f]RT!\u0001Q!\u0002\r%\u0003\u0014\n^3d\u0015\u0005\u0011\u0015aA8sO&\u0011A)\u0010\u0002\t5.\u001cE.[3oi\"Aa)\bB\u0001B\u0003%1(A\u0005{W\u000ec\u0017.\u001a8uA!A\u0001*\bB\u0001B\u0003%\u0011*\u0001\blC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0011\u0005\u0001R\u0015BA&\"\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJD\u0001\"T\u000f\u0003\u0006\u0004%\tAT\u0001\u000bY><W*\u00198bO\u0016\u0014X#A(\u0011\u0005A\u001bV\"A)\u000b\u0005I#\u0011a\u00017pO&\u0011A+\u0015\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\b\u0002\u0003,\u001e\u0005\u0003\u0005\u000b\u0011B(\u0002\u00171|w-T1oC\u001e,'\u000f\t\u0005\t1v\u0011)\u0019!C\u00013\u0006q\u0011n]*ikR$\u0018N\\4E_^tW#\u0001.\u0011\u0005m#W\"\u0001/\u000b\u0005us\u0016AB1u_6L7M\u0003\u0002`A\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0005\u0014\u0017\u0001B;uS2T\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002f9\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:D\u0001bZ\u000f\u0003\u0002\u0003\u0006IAW\u0001\u0010SN\u001c\u0006.\u001e;uS:<Gi\\<oA!)1#\bC\u0001SR9!n\u001b7n]>\u0004\bC\u0001\u0005\u001e\u0011\u0015a\u0003\u000e1\u0001/\u0011\u0015!\u0004\u000e1\u00016\u0011\u0015I\u0004\u000e1\u0001<\u0011\u0015A\u0005\u000e1\u0001J\u0011\u0015i\u0005\u000e1\u0001P\u0011\u0015A\u0006\u000e1\u0001[\u0011\u001d\u0011X\u00041A\u0005\u0002M\fqbY8oiJ|G\u000e\\3s\u000bB|7\r[\u000b\u0002iB\u0011Q\"^\u0005\u0003m:\u00111!\u00138u\u0011\u001dAX\u00041A\u0005\u0002e\f1cY8oiJ|G\u000e\\3s\u000bB|7\r[0%KF$\"A_?\u0011\u00055Y\u0018B\u0001?\u000f\u0005\u0011)f.\u001b;\t\u000fy<\u0018\u0011!a\u0001i\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005\u0005Q\u0004)Q\u0005i\u0006\u00012m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\t\u0015\u0004\u007f\u0006\u0015\u0001cA\u0007\u0002\b%\u0019\u0011\u0011\u0002\b\u0003\u0011Y|G.\u0019;jY\u0016D\u0001\"!\u0004\u001e\u0005\u0004%Ia]\u0001\u000eY>\u001c\u0017\r\u001c\"s_.,'/\u00133\t\u000f\u0005EQ\u0004)A\u0005i\u0006qAn\\2bY\n\u0013xn[3s\u0013\u0012\u0004\u0003\"CA\u000b;\t\u0007I\u0011BA\f\u00035\tG\u000e\u001c)beRLG/[8ogV\u0011\u0011\u0011\u0004\t\bA\u0005m\u0011qDA\u001a\u0013\r\ti\"\t\u0002\u0005!>|G\u000e\u0005\u0004\u000e\u0003C\t)\u0003^\u0005\u0004\u0003Gq!A\u0002+va2,'\u0007\u0005\u0003\u0002(\u00055bbA\u0007\u0002*%\u0019\u00111\u0006\b\u0002\rA\u0013X\rZ3g\u0013\u0011\ty#!\r\u0003\rM#(/\u001b8h\u0015\r\tYC\u0004\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u0003\u0002\u000f\rdWo\u001d;fe&!\u0011QHA\u001c\u0005%\u0001\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002Bu\u0001\u000b\u0011BA\r\u00039\tG\u000e\u001c)beRLG/[8og\u0002B\u0011\"!\u0012\u001e\u0001\u0004%I!a\u0012\u0002!1,\u0017\rZ3s!\u0006\u0014H/\u001b;j_:\u001cXCAA%!\u0019\tY%!\u0016\u000245\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&A\u0004nkR\f'\r\\3\u000b\u0007\u0005Mc\"\u0001\u0006d_2dWm\u0019;j_:LA!a\u0016\u0002N\t9\u0001*Y:i'\u0016$\b\"CA.;\u0001\u0007I\u0011BA/\u0003QaW-\u00193feB\u000b'\u000f^5uS>t7o\u0018\u0013fcR\u0019!0a\u0018\t\u0013y\fI&!AA\u0002\u0005%\u0003\u0002CA2;\u0001\u0006K!!\u0013\u0002#1,\u0017\rZ3s!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0005\u0002hu\u0011\r\u0011\"\u0003\u0002j\u0005!B.Z1eKJ\u0004\u0016M\u001d;ji&|gn\u001d'pG.,\"!a\u001b\u0011\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001dc\u0003\u0011a\u0017M\\4\n\t\u0005U\u0014q\u000e\u0002\u0007\u001f\nTWm\u0019;\t\u0011\u0005eT\u0004)A\u0005\u0003W\nQ\u0003\\3bI\u0016\u0014\b+\u0019:uSRLwN\\:M_\u000e\\\u0007\u0005C\u0005\u0002~u\u0011\r\u0011\"\u0001\u0002\u0000\u0005)\"/\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014XCAAA!\rA\u00111Q\u0005\u0004\u0003\u000b\u0013!!\u0006*fa2L7-\u0019$fi\u000eDWM]'b]\u0006<WM\u001d\u0005\t\u0003\u0013k\u0002\u0015!\u0003\u0002\u0002\u00061\"/\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\b\u0005\u0003\u0005\u0002\u000ev\u0011\r\u0011\"\u0003Z\u0003\u0011B\u0017n\u001a5XCR,'/\\1sW\u000eCWmY6Q_&tG\u000f\u00165sK\u0006$7\u000b^1si\u0016$\u0007bBAI;\u0001\u0006IAW\u0001&Q&<\u0007nV1uKJl\u0017M]6DQ\u0016\u001c7\u000eU8j]R$\u0006N]3bIN#\u0018M\u001d;fI\u0002B\u0011\"!&\u001e\u0005\u0004%\t!a&\u00021!Lw\r[,bi\u0016\u0014X.\u0019:l\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002\u001aBA\u00111TAQ\u0003K\t)+\u0004\u0002\u0002\u001e*!\u0011qTA)\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002$\u0006u%aA'baB\u0019\u0001\"a*\n\u0007\u0005%&AA\fIS\u001eDw/\u0019;fe6\u000b'o[\"iK\u000e\\\u0007o\\5oi\"A\u0011QV\u000f!\u0002\u0013\tI*A\riS\u001eDw+\u0019;fe6\f'o[\"iK\u000e\\\u0007o\\5oiN\u0004\u0003\"CAY;\u0001\u0007I\u0011BAZ\u0003MAw\u000f\u00165sK\u0006$\u0017J\\5uS\u0006d\u0017N_3e+\t\t)\fE\u0002\u000e\u0003oK1!!/\u000f\u0005\u001d\u0011un\u001c7fC:D\u0011\"!0\u001e\u0001\u0004%I!a0\u0002/!<H\u000b\u001b:fC\u0012Le.\u001b;jC2L'0\u001a3`I\u0015\fHc\u0001>\u0002B\"Ia0a/\u0002\u0002\u0003\u0007\u0011Q\u0017\u0005\t\u0003\u000bl\u0002\u0015)\u0003\u00026\u0006!\u0002n\u001e+ie\u0016\fG-\u00138ji&\fG.\u001b>fI\u0002B\u0011\"!3\u001e\u0005\u0004%\t!a3\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0002NB!\u0011qZAm\u001b\t\t\tN\u0003\u0003\u0002T\u0006U\u0017!\u00027pORR'bAAl\u0003\u00061\u0011\r]1dQ\u0016LA!a7\u0002R\n1Aj\\4hKJD\u0001\"a8\u001eA\u0003%\u0011QZ\u0001\u0013gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\b\u0005C\u0005\u0002dv\u0011\r\u0011\"\u0001\u0002f\u0006i\u0011n\u001d:FqB\fg\u000e\u001a*bi\u0016,\"!a:\u0011\t\u0005%\u0018\u0011`\u0007\u0003\u0003WTA!!<\u0002p\u0006!1m\u001c:f\u0015\rA\u0013\u0011\u001f\u0006\u0005\u0003g\f)0\u0001\u0004zC6lWM\u001d\u0006\u0003\u0003o\f1aY8n\u0013\u0011\tY0a;\u0003\u000b5+G/\u001a:\t\u0011\u0005}X\u0004)A\u0005\u0003O\fa\"[:s\u000bb\u0004\u0018M\u001c3SCR,\u0007\u0005C\u0005\u0003\u0004u\u0011\r\u0011\"\u0001\u0002f\u0006i\u0011n\u001d:TQJLgn\u001b*bi\u0016D\u0001Ba\u0002\u001eA\u0003%\u0011q]\u0001\u000fSN\u00148\u000b\u001b:j].\u0014\u0016\r^3!\u0011\u001d\u0011Y!\bC\u0001\u0005\u001b\t1e\u001d;beRD\u0015n\u001a5XCR,'/T1sWN\u001c\u0005.Z2l!>Lg\u000e\u001e+ie\u0016\fG\r\u0006\u0002\u0003\u0010A\u0019QB!\u0005\n\u0007\tMaBA\u0002B]fDqAa\u0006\u001e\t\u0003\u0011I\"\u0001\u0011hKR\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d$peB\u000b'\u000f^5uS>tG#\u0002;\u0003\u001c\t}\u0001\u0002\u0003B\u000f\u0005+\u0001\r!!\n\u0002\u000bQ|\u0007/[2\t\u000f\t\u0005\"Q\u0003a\u0001i\u0006Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\u0011)#\bC\u0001\u0005O\tqa\u001d;beR,\b\u000fF\u0001{\u0011\u001d\u0011Y#\bC\u0001\u0005[\t1b\u001d;paJ+\u0007\u000f\\5dCRA!q\u0006B\u001b\u0005o\u0011I\u0004E\u0002\u000e\u0005cI1Aa\r\u000f\u0005\u0015\u0019\u0006n\u001c:u\u0011!\u0011iB!\u000bA\u0002\u0005\u0015\u0002b\u0002B\u0011\u0005S\u0001\r\u0001\u001e\u0005\t\u0005w\u0011I\u00031\u0001\u00026\u0006yA-\u001a7fi\u0016\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003@u!\tA!\u0011\u0002\u0019M$x\u000e\u001d*fa2L7-Y:\u0015\t\t\r#\u0011\n\t\b\u001b\u0005\u0005\"Q\tB\u0018!!\tYEa\u0012\u0002 \t=\u0012\u0002BAR\u0003\u001bB\u0001Ba\u0013\u0003>\u0001\u0007!QJ\u0001\u0013gR|\u0007OU3qY&\u001c\u0017MU3rk\u0016\u001cH\u000f\u0005\u0003\u0003P\tUSB\u0001B)\u0015\r\u0011\u0019\u0006B\u0001\u0004CBL\u0017\u0002\u0002B,\u0005#\u0012!c\u0015;paJ+\u0007\u000f\\5dCJ+\u0017/^3ti\"9!1L\u000f\u0005\u0002\tu\u0013\u0001F4fi>\u00138I]3bi\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0005\u00024\t}#\u0011\rB2\u0011!\u0011iB!\u0017A\u0002\u0005\u0015\u0002b\u0002B\u0011\u00053\u0002\r\u0001\u001e\u0005\b\u0005K\u0012I\u00061\u0001u\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\b\u0005SjB\u0011\u0001B6\u000319W\r\u001e)beRLG/[8o)\u0019\u0011iGa\u001d\u0003vA)QBa\u001c\u00024%\u0019!\u0011\u000f\b\u0003\r=\u0003H/[8o\u0011!\u0011iBa\u001aA\u0002\u0005\u0015\u0002b\u0002B\u0011\u0005O\u0002\r\u0001\u001e\u0005\b\u0005sjB\u0011\u0001B>\u0003U9W\r\u001e*fa2L7-Y(s\u000bb\u001cW\r\u001d;j_:$bA! \u0003\u0004\n\u0015\u0005\u0003BA\u001b\u0005\u007fJAA!!\u00028\t9!+\u001a9mS\u000e\f\u0007\u0002\u0003B\u000f\u0005o\u0002\r!!\n\t\u000f\t\u001d%q\u000fa\u0001i\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0005\u0017kB\u0011\u0001BG\u0003]9W\r\u001e'fC\u0012,'OU3qY&\u001c\u0017-\u00134M_\u000e\fG\u000e\u0006\u0004\u0003~\t=%\u0011\u0013\u0005\t\u0005;\u0011I\t1\u0001\u0002&!9!\u0011\u0005BE\u0001\u0004!\bb\u0002BK;\u0011\u0005!qS\u0001\u000bO\u0016$(+\u001a9mS\u000e\fG\u0003\u0003BM\u00057\u0013iJa(\u0011\u000b5\u0011yG! \t\u0011\tu!1\u0013a\u0001\u0003KAqA!\t\u0003\u0014\u0002\u0007A\u000fC\u0005\u0003\"\nM\u0005\u0013!a\u0001i\u0006I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\b\u0005KkB\u0011\u0001BT\u0003Y\u0011WmY8nK2+\u0017\rZ3s\u001fJ4u\u000e\u001c7po\u0016\u0014H\u0003\u0002BU\u0005c\u0003r!DA\u0011\u0005W\u0013y\u0003\u0005\u0005\u0003.\n=\u0016q\u0004B\u0018\u001b\t\t\t&\u0003\u0003\u0002$\u0006E\u0003\u0002\u0003BZ\u0005G\u0003\rA!.\u0002'1,\u0017\rZ3s\u0003:$\u0017j\u0015*SKF,Xm\u001d;\u0011\t\t=#qW\u0005\u0005\u0005s\u0013\tFA\nMK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH\u000fC\u0004\u0003>v!IAa0\u0002\u00155\f7.\u001a'fC\u0012,'\u000fF\u0007{\u0005\u0003\u0014)M!3\u0003L\n5'q\u001b\u0005\b\u0005\u0007\u0014Y\f1\u0001u\u00031\u0019wN\u001c;s_2dWM]%e\u0011\u001d\u00119Ma/A\u0002Q\fQ!\u001a9pG\"D\u0001B!\b\u0003<\u0002\u0007\u0011Q\u0005\u0005\b\u0005C\u0011Y\f1\u0001u\u0011!\u0011yMa/A\u0002\tE\u0017A\u00059beRLG/[8o'R\fG/Z%oM>\u0004BAa\u0014\u0003T&!!Q\u001bB)\u0005I\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016LeNZ8\t\u000f\te'1\u0018a\u0001i\u0006i1m\u001c:sK2\fG/[8o\u0013\u0012DqA!8\u001e\t\u0013\u0011y.\u0001\u0007nC.,gi\u001c7m_^,'\u000fF\b{\u0005C\u0014\u0019O!:\u0003h\n%(1\u001eB~\u0011\u001d\u0011\u0019Ma7A\u0002QDqAa2\u0003\\\u0002\u0007A\u000f\u0003\u0005\u0003\u001e\tm\u0007\u0019AA\u0013\u0011\u001d\u0011\tCa7A\u0002QD\u0001Ba4\u0003\\\u0002\u0007!\u0011\u001b\u0005\t\u0005[\u0014Y\u000e1\u0001\u0003p\u00069A.Z1eKJ\u001c\bC\u0002BW\u0005c\u0014)0\u0003\u0003\u0003t\u0006E#aA*fiB!\u0011Q\u0007B|\u0013\u0011\u0011I0a\u000e\u0003\r\t\u0013xn[3s\u0011\u001d\u0011INa7A\u0002QDqAa@\u001e\t\u0013\u00119#\u0001\bnCf\u0014Wm\u00155sS:\\\u0017j\u001d:\t\u000f\r\rQ\u0004\"\u0001\u0004\u0006\u00051\"/Z2pe\u00124u\u000e\u001c7po\u0016\u0014\bk\\:ji&|g\u000eF\u0005{\u0007\u000f\u0019Iaa\u0003\u0004\u000e!A!QDB\u0001\u0001\u0004\t)\u0003C\u0004\u0003\"\r\u0005\u0001\u0019\u0001;\t\u000f\t\u00056\u0011\u0001a\u0001i\"91qBB\u0001\u0001\u0004A\u0012AB8gMN,G\u000fC\u0004\u0004\u0014u!\tAa\n\u00021\rDWmY6q_&tG\u000fS5hQ^\u000bG/\u001a:nCJ\\7\u000fC\u0004\u0004\u0018u!\tAa\n\u0002\u0011MDW\u000f\u001e3po:D\u0011ba\u0007\u001e#\u0003%\ta!\b\u0002)\u001d,GOU3qY&\u001c\u0017\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019yBK\u0002u\u0007CY#aa\t\u0011\t\r\u00152qF\u0007\u0003\u0007OQAa!\u000b\u0004,\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007[q\u0011AC1o]>$\u0018\r^5p]&!1\u0011GB\u0014\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ReplicaManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Time time;
    private final ZkClient zkClient;
    private final KafkaScheduler kafkaScheduler;
    private final LogManager logManager;
    private final AtomicBoolean isShuttingDown;
    private volatile int controllerEpoch;
    private final int kafka$server$ReplicaManager$$localBrokerId;
    private final Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions;
    private HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions;
    private final Object kafka$server$ReplicaManager$$leaderPartitionsLock;
    private final ReplicaFetcherManager replicaFetcherManager;
    private final AtomicBoolean highWatermarkCheckPointThreadStarted;
    private final scala.collection.immutable.Map<String, HighwaterMarkCheckpoint> highWatermarkCheckpoints;
    private boolean hwThreadInitialized;
    private final Logger stateChangeLogger;
    private final Meter isrExpandRate;
    private final Meter isrShrinkRate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static long UnknownLogEndOffset() {
        return ReplicaManager$.MODULE$.UnknownLogEndOffset();
    }

    @Override
    public <T> Gauge<T> newGauge(String string, Gauge<T> gauge) {
        return KafkaMetricsGroup$class.newGauge(this, string, gauge);
    }

    @Override
    public Meter newMeter(String string, String string2, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, string, string2, timeUnit);
    }

    @Override
    public Histogram newHistogram(String string, boolean bl) {
        return KafkaMetricsGroup$class.newHistogram(this, string, bl);
    }

    @Override
    public Timer newTimer(String string, TimeUnit timeUnit, TimeUnit timeUnit2) {
        return KafkaMetricsGroup$class.newTimer(this, string, timeUnit, timeUnit2);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicaManager replicaManager = this;
        synchronized (replicaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int n) {
        this.controllerEpoch = n;
    }

    public int kafka$server$ReplicaManager$$localBrokerId() {
        return this.kafka$server$ReplicaManager$$localBrokerId;
    }

    public Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions() {
        return this.kafka$server$ReplicaManager$$allPartitions;
    }

    public HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions() {
        return this.kafka$server$ReplicaManager$$leaderPartitions;
    }

    private void kafka$server$ReplicaManager$$leaderPartitions_$eq(HashSet<Partition> hashSet) {
        this.kafka$server$ReplicaManager$$leaderPartitions = hashSet;
    }

    public Object kafka$server$ReplicaManager$$leaderPartitionsLock() {
        return this.kafka$server$ReplicaManager$$leaderPartitionsLock;
    }

    public ReplicaFetcherManager replicaFetcherManager() {
        return this.replicaFetcherManager;
    }

    private AtomicBoolean highWatermarkCheckPointThreadStarted() {
        return this.highWatermarkCheckPointThreadStarted;
    }

    public scala.collection.immutable.Map<String, HighwaterMarkCheckpoint> highWatermarkCheckpoints() {
        return this.highWatermarkCheckpoints;
    }

    private boolean hwThreadInitialized() {
        return this.hwThreadInitialized;
    }

    private void hwThreadInitialized_$eq(boolean bl) {
        this.hwThreadInitialized = bl;
    }

    public Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public Meter isrExpandRate() {
        return this.isrExpandRate;
    }

    public Meter isrShrinkRate() {
        return this.isrShrinkRate;
    }

    public Object startHighWaterMarksCheckPointThread() {
        return this.highWatermarkCheckPointThreadStarted().compareAndSet(false, true) ? this.kafkaScheduler.scheduleWithRate((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkpointHighWatermarks();
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        }, "highwatermark-checkpoint-thread", 0L, this.config().replicaHighWatermarkCheckpointIntervalMs(), this.kafkaScheduler.scheduleWithRate$default$5()) : BoxedUnit.UNIT;
    }

    public int getReplicationFactorForPartition(String string, int n) {
        Option<Partition> option;
        block4: {
            int n2;
            block3: {
                block2: {
                    Option<Partition> option2 = this.getPartition(string, n);
                    option = option2;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Partition partition = (Partition)some.x();
                    n2 = partition.replicationFactor();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Partition> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                n2 = -1;
            }
            return n2;
        }
        throw new MatchError(option);
    }

    public void startup() {
        this.kafkaScheduler.scheduleWithRate((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$ReplicaManager$$maybeShrinkIsr();
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        }, "isr-expiration-thread-", 0L, this.config().replicaLagTimeMaxMs(), this.kafkaScheduler.scheduleWithRate$default$5());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short stopReplica(String string, int n, boolean bl) {
        BoxedUnit boxedUnit;
        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d handling stop replica for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), string, BoxesRunTime.boxToInteger((int)n)})));
        short s = ErrorMapping$.MODULE$.NoError();
        Option<Replica> option = this.getReplica(string, n, this.getReplica$default$3());
        if (option instanceof Some) {
            Object object;
            Some some = (Some)option;
            Replica replica = (Replica)some.x();
            this.replicaFetcherManager().removeFetcher(string, n);
            Object object2 = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
            synchronized (object2) {
                this.kafka$server$ReplicaManager$$leaderPartitions().$minus$eq((Object)replica.partition());
                // MONITOREXIT @DISABLED, blocks:[0, 1, 7] lbl13 : MonitorExitStatement: MONITOREXIT : object
                object = bl ? this.kafka$server$ReplicaManager$$allPartitions().remove((Tuple2<String, Object>)new Tuple2((Object)string, (Object)BoxesRunTime.boxToInteger((int)n))) : BoxedUnit.UNIT;
            }
            boxedUnit = object;
        } else {
            None$ none$ = None$.MODULE$;
            Option<Replica> option2 = option;
            if (none$ == null) {
                if (option2 != null) {
                    throw new MatchError(option);
                }
            } else if (!none$.equals(option2)) throw new MatchError(option);
            boxedUnit = BoxedUnit.UNIT;
        }
        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d finished handling stop replica for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), string, BoxesRunTime.boxToInteger((int)n)})));
        return s;
    }

    public Tuple2<scala.collection.mutable.Map<Tuple2<String, Object>, Object>, Object> stopReplicas(StopReplicaRequest stopReplicaRequest) {
        Tuple2 tuple2;
        HashMap hashMap = new HashMap();
        if (stopReplicaRequest.controllerEpoch() < this.controllerEpoch()) {
            this.stateChangeLogger().warn((Object)new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d received stop replica request from an old controller epoch %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)stopReplicaRequest.controllerEpoch())}))).append((Object)" Latest known controller epoch is %d ").append((Object)BoxesRunTime.boxToInteger((int)this.controllerEpoch())).toString());
            tuple2 = new Tuple2((Object)hashMap, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
        } else {
            this.controllerEpoch_$eq(stopReplicaRequest.controllerEpoch());
            HashMap hashMap2 = new HashMap();
            stopReplicaRequest.partitions().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> tuple2) {
                    Tuple2<String, Object> tuple22 = tuple2;
                    boolean bl = tuple22 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, stopReplicaRequest, hashMap2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManager $outer;
                private final StopReplicaRequest stopReplicaRequest$1;
                private final HashMap responseMap$1;

                public final Option<Object> apply(Tuple2<String, Object> tuple2) {
                    Tuple2<String, Object> tuple22 = tuple2;
                    if (tuple22 != null) {
                        String string = (String)tuple22._1();
                        int n = tuple22._2$mcI$sp();
                        short s = this.$outer.stopReplica(string, n, this.stopReplicaRequest$1.deletePartitions());
                        Option option = this.responseMap$1.put((Object)new Tuple2((Object)string, (Object)BoxesRunTime.boxToInteger((int)n)), (Object)BoxesRunTime.boxToShort((short)s));
                        return option;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if (replicaManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = replicaManager;
                    this.stopReplicaRequest$1 = stopReplicaRequest;
                    this.responseMap$1 = hashMap;
                }
            });
            tuple2 = new Tuple2((Object)hashMap2, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
        }
        return tuple2;
    }

    public Partition getOrCreatePartition(String string, int n, int n2) {
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)string, (Object)BoxesRunTime.boxToInteger((int)n)));
        if (partition == null) {
            this.kafka$server$ReplicaManager$$allPartitions().putIfNotExists((Tuple2<String, Object>)new Tuple2((Object)string, (Object)BoxesRunTime.boxToInteger((int)n)), new Partition(string, n, n2, this.time, this));
            partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)string, (Object)BoxesRunTime.boxToInteger((int)n)));
        }
        return partition;
    }

    public Option<Partition> getPartition(String string, int n) {
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)string, (Object)BoxesRunTime.boxToInteger((int)n)));
        return partition == null ? None$.MODULE$ : new Some((Object)partition);
    }

    public Replica getReplicaOrException(String string, int n) {
        Option<Replica> option = this.getReplica(string, n, this.getReplica$default$3());
        if (option.isDefined()) {
            return (Replica)option.get();
        }
        throw new ReplicaNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Replica %d is not available for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.config().brokerId()), string, BoxesRunTime.boxToInteger((int)n)})));
    }

    public Replica getLeaderReplicaIfLocal(String string, int n) {
        Option<Partition> option;
        Option<Partition> option2 = option = this.getPartition(string, n);
        None$ none$ = None$.MODULE$;
        Option<Partition> option3 = option2;
        if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
            throw new UnknownTopicOrPartitionException(new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] doesn't exist on %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
        }
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Partition partition = (Partition)some.x();
            Option<Replica> option4 = partition.leaderReplicaIfLocal();
            if (option4 instanceof Some) {
                Replica replica;
                Replica replica2;
                Some some2 = (Some)option4;
                Replica replica3 = replica2 = (replica = (Replica)some2.x());
                return replica3;
            }
            None$ none$2 = None$.MODULE$;
            Option<Replica> option5 = option4;
            if (!(none$2 != null ? !none$2.equals(option5) : option5 != null)) {
                throw new NotLeaderForPartitionException(new StringOps(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
            }
            throw new MatchError(option4);
        }
        throw new MatchError(option2);
    }

    public Option<Replica> getReplica(String string, int n, int n2) {
        Option<Partition> option;
        block4: {
            Option<Replica> option2;
            block3: {
                block2: {
                    Option<Partition> option3;
                    option = option3 = this.getPartition(string, n);
                    None$ none$ = None$.MODULE$;
                    Option<Partition> option4 = option;
                    if (none$ != null ? !none$.equals(option4) : option4 != null) break block2;
                    option2 = None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Partition partition = (Partition)some.x();
                option2 = partition.getReplica(n2);
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public int getReplica$default$3() {
        return this.config().brokerId();
    }

    public Tuple2<Map<Tuple2<String, Object>, Object>, Object> becomeLeaderOrFollower(LeaderAndIsrRequest leaderAndIsrRequest) {
        Tuple2 tuple2;
        leaderAndIsrRequest.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndIsrRequest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;
            private final LeaderAndIsrRequest leaderAndISRRequest$1;

            public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                this.$outer.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d handling LeaderAndIsr request correlation id %d received from controller %d epoch %d for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), ((Tuple2)tuple2._1())._1(), BoxesRunTime.boxToInteger((int)((Tuple2)tuple2._1())._2$mcI$sp())})));
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
                this.leaderAndISRRequest$1 = leaderAndIsrRequest;
            }
        });
        this.info((Function0<String>)new Serializable(this, leaderAndIsrRequest){
            public static final long serialVersionUID = 0L;
            private final LeaderAndIsrRequest leaderAndISRRequest$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Handling LeaderAndIsr request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leaderAndISRRequest$1}));
            }
            {
                this.leaderAndISRRequest$1 = leaderAndIsrRequest;
            }
        });
        HashMap hashMap = new HashMap();
        if (leaderAndIsrRequest.controllerEpoch() < this.controllerEpoch()) {
            this.stateChangeLogger().warn((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request correlation id %d with an old controller epoch %d. Latest known controller epoch is %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)leaderAndIsrRequest.controllerEpoch()), BoxesRunTime.boxToInteger((int)leaderAndIsrRequest.correlationId()), BoxesRunTime.boxToInteger((int)this.controllerEpoch())})));
            tuple2 = new Tuple2((Object)hashMap, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
        } else {
            int n = leaderAndIsrRequest.controllerId();
            this.controllerEpoch_$eq(leaderAndIsrRequest.controllerEpoch());
            leaderAndIsrRequest.partitionStateInfos().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                    Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = tuple2;
                    boolean bl = tuple22 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, leaderAndIsrRequest, hashMap, n){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManager $outer;
                private final LeaderAndIsrRequest leaderAndISRRequest$1;
                private final HashMap responseMap$2;
                private final int controllerId$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                    Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple23 = tuple2;
                    if (tuple23 == null) throw new MatchError(tuple23);
                    Tuple2 tuple22 = (Tuple2)tuple23._1();
                    PartitionStateInfo partitionStateInfo = (PartitionStateInfo)tuple23._2();
                    short s = ErrorMapping$.MODULE$.NoError();
                    String string = (String)tuple22._1();
                    int n = tuple22._2$mcI$sp();
                    int n2 = partitionStateInfo.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
                    try {
                        if (n2 == this.$outer.config().brokerId()) {
                            this.$outer.kafka$server$ReplicaManager$$makeLeader(this.controllerId$1, this.$outer.controllerEpoch(), string, n, partitionStateInfo, this.leaderAndISRRequest$1.correlationId());
                        } else {
                            this.$outer.kafka$server$ReplicaManager$$makeFollower(this.controllerId$1, this.$outer.controllerEpoch(), string, n, partitionStateInfo, (Set<Broker>)this.leaderAndISRRequest$1.leaders(), this.leaderAndISRRequest$1.correlationId());
                        }
                    }
                    catch (Throwable throwable) {
                        string = new StringOps(Predef$.MODULE$.augmentString("Error on broker %d while processing LeaderAndIsr request correlationId %d received from controller %d epoch %d for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), tuple22}));
                        this.$outer.stateChangeLogger().error((Object)string, throwable);
                        s = ErrorMapping$.MODULE$.codeFor(throwable.getClass());
                    }
                    this.responseMap$2.put((Object)tuple22, (Object)BoxesRunTime.boxToShort((short)s));
                    this.$outer.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d handled LeaderAndIsr request correlationId %d received from controller %d epoch %d for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), tuple22._1(), BoxesRunTime.boxToInteger((int)tuple22._2$mcI$sp())})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                {
                    if (replicaManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = replicaManager;
                    this.leaderAndISRRequest$1 = leaderAndIsrRequest;
                    this.responseMap$2 = hashMap;
                    this.controllerId$1 = n;
                }
            });
            this.info((Function0<String>)new Serializable(this, leaderAndIsrRequest){
                public static final long serialVersionUID = 0L;
                private final LeaderAndIsrRequest leaderAndISRRequest$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Handled leader and isr request %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leaderAndISRRequest$1}));
                }
                {
                    this.leaderAndISRRequest$1 = leaderAndIsrRequest;
                }
            });
            if (!this.hwThreadInitialized()) {
                this.startHighWaterMarksCheckPointThread();
                this.hwThreadInitialized_$eq(true);
            }
            this.replicaFetcherManager().shutdownIdleFetcherThreads();
            tuple2 = new Tuple2((Object)hashMap, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
        }
        return tuple2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void kafka$server$ReplicaManager$$makeLeader(int n, int n2, String string, int n3, PartitionStateInfo partitionStateInfo, int n4) {
        BoxedUnit boxedUnit;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = partitionStateInfo.leaderIsrAndControllerEpoch();
        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request correlationId %d from controller %d epoch %d starting the become-leader transition for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)n4), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)n2), string, BoxesRunTime.boxToInteger((int)n3)})));
        Partition partition = this.getOrCreatePartition(string, n3, partitionStateInfo.replicationFactor());
        if (partition.makeLeader(n, string, n3, leaderIsrAndControllerEpoch, n4)) {
            Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
            synchronized (object) {
                HashSet hashSet = this.kafka$server$ReplicaManager$$leaderPartitions().$plus$eq((Object)partition);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl9 : MonitorExitStatement: MONITOREXIT : object
                boxedUnit = hashSet;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d completed become-leader transition for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), string, BoxesRunTime.boxToInteger((int)n3)})));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void kafka$server$ReplicaManager$$makeFollower(int n, int n2, String string, int n3, PartitionStateInfo partitionStateInfo, Set<Broker> set, int n4) {
        BoxedUnit boxedUnit;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = partitionStateInfo.leaderIsrAndControllerEpoch();
        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request correlationId %d from controller %d epoch %d starting the become-follower transition for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)n4), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)n2), string, BoxesRunTime.boxToInteger((int)n3)})));
        Partition partition = this.getOrCreatePartition(string, n3, partitionStateInfo.replicationFactor());
        if (partition.makeFollower(n, string, n3, leaderIsrAndControllerEpoch, set, n4)) {
            Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
            synchronized (object) {
                HashSet hashSet = this.kafka$server$ReplicaManager$$leaderPartitions().$minus$eq((Object)partition);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl9 : MonitorExitStatement: MONITOREXIT : object
                boxedUnit = hashSet;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Broker %d completed the become-follower transition for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), string, BoxesRunTime.boxToInteger((int)n3)})));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void kafka$server$ReplicaManager$$maybeShrinkIsr() {
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Evaluating ISR list of partitions to see which replicas can be removed from the ISR";
            }
        });
        List list = null;
        Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
        synchronized (object) {
            list = this.kafka$server$ReplicaManager$$leaderPartitions().toList();
        }
        list.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            public final void apply(Partition partition) {
                partition.maybeShrinkIsr(this.$outer.config().replicaLagTimeMaxMs(), this.$outer.config().replicaLagMaxMessages());
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        });
    }

    public void recordFollowerPosition(String string, int n, int n2, long l) {
        Option<Partition> option = this.getPartition(string, n);
        if (option.isDefined()) {
            ((Partition)option.get()).updateLeaderHWAndMaybeExpandIsr(n2, l);
        } else {
            this.warn((Function0<String>)new Serializable(this, string, n){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final int partitionId$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("While recording the follower position, the partition [%s,%d] hasn't been created, skip updating leader HW")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1)}));
                }
                {
                    this.topic$1 = string;
                    this.partitionId$1 = n;
                }
            });
        }
    }

    public void checkpointHighWatermarks() {
        Iterable iterable = (Iterable)((TraversableLike)this.kafka$server$ReplicaManager$$allPartitions().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            public final Option<Replica> apply(Partition partition) {
                return partition.getReplica(this.$outer.config().brokerId());
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        }, Iterable$.MODULE$.canBuildFrom())).collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<Replica>, B1> B1 applyOrElse(A1 A1, Function1<A1, B1> function1) {
                Object object;
                A1 A12 = A1;
                if (A12 instanceof Some) {
                    Some some = (Some)A12;
                    Replica replica = (Replica)some.x();
                    object = replica;
                } else {
                    object = function1.apply(A1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<Replica> option) {
                Option<Replica> option2 = option;
                boolean bl = option2 instanceof Some;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map map = ((TraversableLike)iterable.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Replica replica) {
                return replica.log().isDefined();
            }
        })).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Replica replica) {
                return ((Log)replica.log().get()).dir().getParent();
            }
        });
        map.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Iterable<Replica>> tuple2) {
                Tuple2<String, Iterable<Replica>> tuple22 = tuple2;
                boolean bl = tuple22 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManager $outer;

            public final void apply(Tuple2<String, Iterable<Replica>> tuple2) {
                Tuple2<String, Iterable<Replica>> tuple22 = tuple2;
                if (tuple22 != null) {
                    String string = (String)tuple22._1();
                    Iterable iterable = (Iterable)tuple22._2();
                    scala.collection.immutable.Map map = ((TraversableOnce)iterable.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<TopicAndPartition, Object> apply(Replica replica) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(replica.topic(), replica.partitionId())), (Object)BoxesRunTime.boxToLong((long)replica.highWatermark()));
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                    ((HighwaterMarkCheckpoint)this.$outer.highWatermarkCheckpoints().apply((Object)string)).write((scala.collection.immutable.Map<TopicAndPartition, Object>)map);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shut down";
            }
        });
        this.replicaFetcherManager().shutdown();
        this.checkpointHighWatermarks();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutted down completely";
            }
        });
    }

    public ReplicaManager(KafkaConfig kafkaConfig, Time time, ZkClient zkClient, KafkaScheduler kafkaScheduler, LogManager logManager, AtomicBoolean atomicBoolean) {
        this.config = kafkaConfig;
        this.time = time;
        this.zkClient = zkClient;
        this.kafkaScheduler = kafkaScheduler;
        this.logManager = logManager;
        this.isShuttingDown = atomicBoolean;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.kafka$server$ReplicaManager$$localBrokerId = kafkaConfig.brokerId();
        this.kafka$server$ReplicaManager$$allPartitions = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.kafka$server$ReplicaManager$$leaderPartitions = new HashSet();
        this.kafka$server$ReplicaManager$$leaderPartitionsLock = new Object();
        this.replicaFetcherManager = new ReplicaFetcherManager(kafkaConfig, this);
        this.highWatermarkCheckPointThreadStarted = new AtomicBoolean(false);
        this.highWatermarkCheckpoints = ((TraversableOnce)kafkaConfig.logDirs().map((Function1)new $anonfun$2(this), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.hwThreadInitialized = false;
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
        this.newGauge("LeaderCount", new Gauge<Object>(this){
            private final /* synthetic */ ReplicaManager $outer;

            public int value() {
                Object object = this.$outer.kafka$server$ReplicaManager$$leaderPartitionsLock();
                synchronized (object) {
                    Integer n = BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$leaderPartitions().size());
                    return BoxesRunTime.unboxToInt((Object)n);
                }
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        });
        this.newGauge("PartitionCount", new Gauge<Object>(this){
            private final /* synthetic */ ReplicaManager $outer;

            public int value() {
                return this.$outer.kafka$server$ReplicaManager$$allPartitions().size();
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        });
        this.newGauge("UnderReplicatedPartitions", new Gauge<Object>(this){
            private final /* synthetic */ ReplicaManager $outer;

            public int value() {
                Object object = this.$outer.kafka$server$ReplicaManager$$leaderPartitionsLock();
                synchronized (object) {
                    Integer n = BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$leaderPartitions().count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Partition partition) {
                            return partition.isUnderReplicated();
                        }
                    }));
                    return BoxesRunTime.unboxToInt((Object)n);
                }
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        });
        this.isrExpandRate = this.newMeter("IsrExpandsPerSec", "expands", TimeUnit.SECONDS);
        this.isrShrinkRate = this.newMeter("ISRShrinksPerSec", "shrinks", TimeUnit.SECONDS);
    }
}

