/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.InvalidOffsetException;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Os$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sun.nio.ch.DirectBuffer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t%a\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\t\u0019LG.Z\u000b\u0002/A\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0003S>T\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t!a)\u001b7f\u0011!\u0001\u0003A!A!\u0002\u00139\u0012!\u00024jY\u0016\u0004\u0003\u0002\u0003\u0012\u0001\u0005\u000b\u0007I\u0011A\u0012\u0002\u0015\t\f7/Z(gMN,G/F\u0001%!\tIQ%\u0003\u0002'\u0015\t!Aj\u001c8h\u0011!A\u0003A!A!\u0002\u0013!\u0013a\u00032bg\u0016|eMZ:fi\u0002B\u0001B\u000b\u0001\u0003\u0006\u0004%\taK\u0001\r[\u0006D\u0018J\u001c3fqNK'0Z\u000b\u0002YA\u0011\u0011\"L\u0005\u0003])\u00111!\u00138u\u0011!\u0001\u0004A!A!\u0002\u0013a\u0013!D7bq&sG-\u001a=TSj,\u0007\u0005C\u00033\u0001\u0011\u00051'\u0001\u0004=S:LGO\u0010\u000b\u0005iY:\u0004\b\u0005\u00026\u00015\t!\u0001C\u0003\u0016c\u0001\u0007q\u0003C\u0003#c\u0001\u0007A\u0005C\u0004+cA\u0005\t\u0019\u0001\u0017\t\u000fi\u0002!\u0019!C\u0005w\u0005!An\\2l+\u0005a\u0004CA\u001fE\u001b\u0005q$BA A\u0003\u0015awnY6t\u0015\t\t%)\u0001\u0006d_:\u001cWO\u001d:f]RT!aQ\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003\u000bz\u0012QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0007BB$\u0001A\u0003%A(A\u0003m_\u000e\\\u0007\u0005C\u0004J\u0001\u0001\u0007I\u0011\u0002&\u0002\t5l\u0017\r]\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011ajG\u0001\u0004]&|\u0017B\u0001)N\u0005Ai\u0015\r\u001d9fI\nKH/\u001a\"vM\u001a,'\u000fC\u0004S\u0001\u0001\u0007I\u0011B*\u0002\u00115l\u0017\r]0%KF$\"\u0001V,\u0011\u0005%)\u0016B\u0001,\u000b\u0005\u0011)f.\u001b;\t\u000fa\u000b\u0016\u0011!a\u0001\u0017\u0006\u0019\u0001\u0010J\u0019\t\ri\u0003\u0001\u0015)\u0003L\u0003\u0015iW.\u00199!\u0011\u001da\u0006\u00011A\u0005\nu\u000bAa]5{KV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002b\u0001\u00061\u0011\r^8nS\u000eL!a\u00191\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011\u001d)\u0007\u00011A\u0005\n\u0019\f\u0001b]5{K~#S-\u001d\u000b\u0003)\u001eDq\u0001\u00173\u0002\u0002\u0003\u0007a\f\u0003\u0004j\u0001\u0001\u0006KAX\u0001\u0006g&TX\r\t\u0005\bW\u0002\u0001\r\u0011\"\u0001,\u0003)i\u0017\r_#oiJLWm\u001d\u0005\b[\u0002\u0001\r\u0011\"\u0001o\u00039i\u0017\r_#oiJLWm]0%KF$\"\u0001V8\t\u000fac\u0017\u0011!a\u0001Y!1\u0011\u000f\u0001Q!\n1\n1\"\\1y\u000b:$(/[3tA!\u0012\u0001o\u001d\t\u0003\u0013QL!!\u001e\u0006\u0003\u0011Y|G.\u0019;jY\u0016Dqa\u001e\u0001A\u0002\u0013\u00051%\u0001\u0006mCN$xJ\u001a4tKRDq!\u001f\u0001A\u0002\u0013\u0005!0\u0001\bmCN$xJ\u001a4tKR|F%Z9\u0015\u0005Q[\bb\u0002-y\u0003\u0003\u0005\r\u0001\n\u0005\u0007{\u0002\u0001\u000b\u0015\u0002\u0013\u0002\u00171\f7\u000f^(gMN,G\u000f\t\u0005\u0007\u007f\u0002!I!!\u0001\u0002\u001dI,\u0017\r\u001a'bgR|eMZ:fiR\tA\u0005C\u0004\u0002\u0006\u0001!\t!a\u0002\u0002\r1|wn[;q)\u0011\tI!a\u0004\u0011\u0007U\nY!C\u0002\u0002\u000e\t\u0011ab\u00144gg\u0016$\bk\\:ji&|g\u000eC\u0004\u0002\u0012\u0005\r\u0001\u0019\u0001\u0013\u0002\u0019Q\f'oZ3u\u001f\u001a47/\u001a;\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018\u0005a\u0011N\u001c3fqNcw\u000e\u001e$peR)A&!\u0007\u0002$!A\u00111DA\n\u0001\u0004\ti\"A\u0002jIb\u00042\u0001TA\u0010\u0013\r\t\t#\u0014\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBA\t\u0003'\u0001\r\u0001\n\u0005\b\u0003O\u0001A\u0011BA\u0015\u00039\u0011X\r\\1uSZ,wJ\u001a4tKR$R\u0001LA\u0016\u0003_A\u0001\"!\f\u0002&\u0001\u0007\u0011QD\u0001\u0007EV4g-\u001a:\t\u000f\u0005E\u0012Q\u0005a\u0001Y\u0005\ta\u000eC\u0004\u00026\u0001!I!a\u000e\u0002\u0011AD\u0017p]5dC2$R\u0001LA\u001d\u0003wA\u0001\"!\f\u00024\u0001\u0007\u0011Q\u0004\u0005\b\u0003c\t\u0019\u00041\u0001-\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\nQ!\u001a8uef$B!!\u0003\u0002D!9\u0011\u0011GA\u001f\u0001\u0004a\u0003bBA$\u0001\u0011\u0005\u0011\u0011J\u0001\u0007CB\u0004XM\u001c3\u0015\u000bQ\u000bY%a\u0014\t\u000f\u00055\u0013Q\ta\u0001I\u00051qN\u001a4tKRDq!!\u0015\u0002F\u0001\u0007A&\u0001\u0005q_NLG/[8o\u0011\u001d\t)\u0006\u0001C\u0001\u0003/\na![:Gk2dWCAA-!\rI\u00111L\u0005\u0004\u0003;R!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003C\u0002A\u0011AA2\u0003!!(/\u001e8dCR,G#\u0001+\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j\u0005QAO];oG\u0006$X\rV8\u0015\u0007Q\u000bY\u0007C\u0004\u0002N\u0005\u0015\u0004\u0019\u0001\u0013\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r\u0005\tBO];oG\u0006$X\rV8F]R\u0014\u0018.Z:\u0015\u0007Q\u000b\u0019\bC\u0004\u0002v\u00055\u0004\u0019\u0001\u0017\u0002\u000f\u0015tGO]5fg\"9\u0011\u0011\u0010\u0001\u0005\u0002\u0005\r\u0014a\u0004;sS6$vNV1mS\u0012\u001c\u0016N_3\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000\u00051!/Z:ju\u0016$2\u0001VAA\u0011\u001d\t\u0019)a\u001fA\u00021\nqA\\3x'&TX\rC\u0004\u0002\b\u0002!I!!#\u0002\u0015\u0019|'oY3V]6\f\u0007\u000fF\u0002U\u0003\u0017Cq!!$\u0002\u0006\u0002\u00071*A\u0001n\u0011\u001d\t\t\n\u0001C\u0001\u0003G\nQA\u001a7vg\"Dq!!&\u0001\t\u0003\t9*\u0001\u0004eK2,G/\u001a\u000b\u0003\u00033Bq!!\u001e\u0001\t\u0003\tY\nF\u0001-\u0011\u001d\ty\n\u0001C\u0001\u0003G\nQa\u00197pg\u0016Dq!a)\u0001\t\u0013\t)+\u0001\u000bs_VtG\rV8Fq\u0006\u001cG/T;mi&\u0004H.\u001a\u000b\u0006Y\u0005\u001d\u00161\u0016\u0005\b\u0003S\u000b\t\u000b1\u0001-\u0003\u0019qW/\u001c2fe\"9\u0011QVAQ\u0001\u0004a\u0013A\u00024bGR|'\u000fC\u0004\u00022\u0002!I!a-\u0002\u00135\f\u0017PY3M_\u000e\\W\u0003BA[\u0003{#B!a.\u0002ZR!\u0011\u0011XAh!\u0011\tY,!0\r\u0001\u0011A\u0011qXAX\u0005\u0004\t\tMA\u0001U#\u0011\t\u0019-!3\u0011\u0007%\t)-C\u0002\u0002H*\u0011qAT8uQ&tw\rE\u0002\n\u0003\u0017L1!!4\u000b\u0005\r\te.\u001f\u0005\n\u0003#\fy\u000b\"a\u0001\u0003'\f1AZ;o!\u0015I\u0011Q[A]\u0013\r\t9N\u0003\u0002\ty\tLh.Y7f}!9!(a,A\u0002\u0005m\u0007cA\u001f\u0002^&\u0019\u0011q\u001c \u0003\t1{7m[\u0004\n\u0003G\u0014\u0011\u0011!E\u0001\u0003K\f1b\u00144gg\u0016$\u0018J\u001c3fqB\u0019Q'a:\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003S\u001c2!a:\t\u0011\u001d\u0011\u0014q\u001dC\u0001\u0003[$\"!!:\t\u0015\u0005E\u0018q]I\u0001\n\u0003\t\u00190A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003kT3\u0001LA|W\t\tI\u0010\u0005\u0003\u0002|\n\u0015QBAA\u007f\u0015\u0011\tyP!\u0001\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0002\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u001d\u0011Q \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class OffsetIndex
implements Logging {
    private final File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final ReentrantLock lock;
    private MappedByteBuffer kafka$log$OffsetIndex$$mmap;
    private AtomicInteger kafka$log$OffsetIndex$$size;
    private volatile int maxEntries;
    private long lastOffset;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public File file() {
        return this.file;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer kafka$log$OffsetIndex$$mmap() {
        return this.kafka$log$OffsetIndex$$mmap;
    }

    public void kafka$log$OffsetIndex$$mmap_$eq(MappedByteBuffer mappedByteBuffer) {
        this.kafka$log$OffsetIndex$$mmap = mappedByteBuffer;
    }

    public AtomicInteger kafka$log$OffsetIndex$$size() {
        return this.kafka$log$OffsetIndex$$size;
    }

    private void kafka$log$OffsetIndex$$size_$eq(AtomicInteger atomicInteger) {
        this.kafka$log$OffsetIndex$$size = atomicInteger;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public void maxEntries_$eq(int n) {
        this.maxEntries = n;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public void lastOffset_$eq(long l) {
        this.lastOffset = l;
    }

    public long kafka$log$OffsetIndex$$readLastOffset() {
        return BoxesRunTime.unboxToLong(Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                int n;
                int n2 = this.$outer.kafka$log$OffsetIndex$$size().get();
                switch (n2) {
                    default: {
                        n = this.$outer.kafka$log$OffsetIndex$$relativeOffset(this.$outer.kafka$log$OffsetIndex$$mmap(), n2 - 1);
                        break;
                    }
                    case 0: {
                        n = 0;
                    }
                }
                int n3 = n;
                return this.$outer.baseOffset() + (long)n3;
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
            }
        }));
    }

    public OffsetPosition lookup(long l) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0)new Serializable(this, l){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long targetOffset$1;

            public final OffsetPosition apply() {
                ByteBuffer byteBuffer = ((ByteBuffer)this.$outer.kafka$log$OffsetIndex$$mmap()).duplicate();
                int n = this.$outer.kafka$log$OffsetIndex$$indexSlotFor(byteBuffer, this.targetOffset$1);
                return n == -1 ? new OffsetPosition(this.$outer.baseOffset(), 0) : new OffsetPosition(this.$outer.baseOffset() + (long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(byteBuffer, n), this.$outer.kafka$log$OffsetIndex$$physical(byteBuffer, n));
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.targetOffset$1 = l;
            }
        });
    }

    public int kafka$log$OffsetIndex$$indexSlotFor(ByteBuffer byteBuffer, long l) {
        long l2 = l - this.baseOffset();
        if (this.entries() == 0) {
            return -1;
        }
        if ((long)this.kafka$log$OffsetIndex$$relativeOffset(byteBuffer, 0) > l2) {
            return -1;
        }
        int n = 0;
        int n2 = this.entries() - 1;
        while (n < n2) {
            int n3 = (int)package$.MODULE$.ceil((double)n2 / 2.0 + (double)n / 2.0);
            int n4 = this.kafka$log$OffsetIndex$$relativeOffset(byteBuffer, n3);
            if ((long)n4 == l2) {
                return n3;
            }
            if ((long)n4 < l2) {
                n = n3;
                continue;
            }
            n2 = n3 - 1;
        }
        return n;
    }

    public int kafka$log$OffsetIndex$$relativeOffset(ByteBuffer byteBuffer, int n) {
        return byteBuffer.getInt(n * 8);
    }

    public int kafka$log$OffsetIndex$$physical(ByteBuffer byteBuffer, int n) {
        return byteBuffer.getInt(n * 8 + 4);
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0)new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int n$1;

            public final OffsetPosition apply() {
                if (this.n$1 >= this.$outer.entries()) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$1), BoxesRunTime.boxToInteger((int)this.$outer.entries())})));
                }
                ByteBuffer byteBuffer = ((ByteBuffer)this.$outer.kafka$log$OffsetIndex$$mmap()).duplicate();
                return new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$relativeOffset(byteBuffer, this.n$1), this.$outer.kafka$log$OffsetIndex$$physical(byteBuffer, this.n$1));
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.n$1 = n;
            }
        });
    }

    public void append(long l, int n) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, l, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            public final long offset$1;
            public final int position$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.require(!this.$outer.isFull(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$append$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Attempt to append to a full index (size = ").append((Object)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$size()).append((Object)").").toString();
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                    }
                });
                if (this.$outer.kafka$log$OffsetIndex$$size().get() == 0 || this.offset$1 > this.$outer.lastOffset()) {
                    this.$outer.debug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.position$1), this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().file().getName()}));
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                        }
                    });
                    this.$outer.kafka$log$OffsetIndex$$mmap().putInt((int)(this.offset$1 - this.$outer.baseOffset()));
                    this.$outer.kafka$log$OffsetIndex$$mmap().putInt(this.position$1);
                    this.$outer.kafka$log$OffsetIndex$$size().incrementAndGet();
                    this.$outer.lastOffset_$eq(this.offset$1);
                    Predef$.MODULE$.require(this.$outer.entries() * 8 == this.$outer.kafka$log$OffsetIndex$$mmap().position(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().entries()).append((Object)" entries but file position in index is ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$mmap().position())).append((Object)".").toString();
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                        }
                    });
                    return;
                }
                throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.entries()), BoxesRunTime.boxToLong((long)this.$outer.lastOffset()), this.$outer.file().getName()})));
            }

            public /* synthetic */ OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.offset$1 = l;
                this.position$1 = n;
            }
        });
    }

    public boolean isFull() {
        return this.entries() >= this.maxEntries();
    }

    public void truncate() {
        this.kafka$log$OffsetIndex$$truncateToEntries(0);
    }

    public void truncateTo(long l) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, l){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer byteBuffer = ((ByteBuffer)this.$outer.kafka$log$OffsetIndex$$mmap()).duplicate();
                int n = this.$outer.kafka$log$OffsetIndex$$indexSlotFor(byteBuffer, this.offset$2);
                int n2 = n < 0 ? 0 : ((long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(byteBuffer, n) == this.offset$2 - this.$outer.baseOffset() ? n : n + 1);
                this.$outer.kafka$log$OffsetIndex$$truncateToEntries(n2);
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.offset$2 = l;
            }
        });
    }

    public void kafka$log$OffsetIndex$$truncateToEntries(int n) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int entries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$OffsetIndex$$size().set(this.entries$1);
                ((Buffer)this.$outer.kafka$log$OffsetIndex$$mmap()).position(this.$outer.kafka$log$OffsetIndex$$size().get() * 8);
                this.$outer.lastOffset_$eq(this.$outer.kafka$log$OffsetIndex$$readLastOffset());
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.entries$1 = n;
            }
        });
    }

    public void trimToValidSize() {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resize(this.$outer.entries() * 8);
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
            }
        });
    }

    public void resize(int n) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int newSize$1;

            public final Buffer apply() {
                Buffer buffer;
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.$outer.file(), "rws");
                int n = this.$outer.kafka$log$OffsetIndex$$roundToExactMultiple(this.newSize$1, 8);
                int n2 = this.$outer.kafka$log$OffsetIndex$$mmap().position();
                if (Os$.MODULE$.isWindows()) {
                    this.$outer.kafka$log$OffsetIndex$$forceUnmap(this.$outer.kafka$log$OffsetIndex$$mmap());
                }
                try {
                    randomAccessFile.setLength(n);
                    this.$outer.kafka$log$OffsetIndex$$mmap_$eq(randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, n));
                    this.$outer.maxEntries_$eq(this.$outer.kafka$log$OffsetIndex$$mmap().limit() / 8);
                    buffer = ((Buffer)this.$outer.kafka$log$OffsetIndex$$mmap()).position(n2);
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, randomAccessFile){
                        public static final long serialVersionUID = 0L;
                        private final RandomAccessFile raf$2;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = randomAccessFile;
                        }
                    });
                }
                catch (Throwable throwable) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                return buffer;
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.newSize$1 = n;
            }
        });
    }

    public void kafka$log$OffsetIndex$$forceUnmap(MappedByteBuffer mappedByteBuffer) {
        try {
            if (mappedByteBuffer instanceof DirectBuffer) {
                ((DirectBuffer)((Object)mappedByteBuffer)).cleaner().clean();
            }
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error when freeing index buffer";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = throwable;
                }
            });
        }
    }

    public void flush() {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final MappedByteBuffer apply() {
                return this.$outer.kafka$log$OffsetIndex$$mmap().force();
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
            }
        });
    }

    public boolean delete() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Deleting index ").append((Object)this.$outer.file().getAbsolutePath()).toString();
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
            }
        });
        return this.file().delete();
    }

    public int entries() {
        return this.kafka$log$OffsetIndex$$size().get();
    }

    public void close() {
        this.trimToValidSize();
    }

    public int kafka$log$OffsetIndex$$roundToExactMultiple(int n, int n2) {
        return n2 * (n / n2);
    }

    private <T> T maybeLock(Lock lock2, Function0<T> function0) {
        if (Os$.MODULE$.isWindows()) {
            lock2.lock();
        }
        try {
            return (T)function0.apply();
        }
        finally {
            if (Os$.MODULE$.isWindows()) {
                lock2.unlock();
            }
        }
    }

    public OffsetIndex(File file, long l, int n) {
        this.file = file;
        this.baseOffset = l;
        this.maxIndexSize = n;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean bl = file.createNewFile();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        try {
            long l2;
            if (bl) {
                if (n < 8) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                randomAccessFile.setLength(this.kafka$log$OffsetIndex$$roundToExactMultiple(n, 8));
            }
            if ((l2 = randomAccessFile.length()) < 0L || l2 % 8L != 0L) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Index file ").append((Object)file.getName()).append((Object)" is corrupt, found ").append((Object)BoxesRunTime.boxToLong((long)l2)).append((Object)" bytes which is not positive or not a multiple of 8.").toString());
            }
            MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, l2);
            Buffer buffer = bl ? ((Buffer)mappedByteBuffer).position(0) : ((Buffer)mappedByteBuffer).position(this.kafka$log$OffsetIndex$$roundToExactMultiple(mappedByteBuffer.limit(), 8));
            this.kafka$log$OffsetIndex$$mmap = mappedByteBuffer;
            this.kafka$log$OffsetIndex$$size = new AtomicInteger(this.kafka$log$OffsetIndex$$mmap().position() / 8);
            this.maxEntries = this.kafka$log$OffsetIndex$$mmap().limit() / 8;
            this.lastOffset = this.kafka$log$OffsetIndex$$readLastOffset();
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OffsetIndex $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.maxEntries()), BoxesRunTime.boxToInteger((int)this.$outer.maxIndexSize()), BoxesRunTime.boxToInteger((int)this.$outer.entries()), BoxesRunTime.boxToLong((long)this.$outer.lastOffset()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$mmap().position())}));
                }
                {
                    if (offsetIndex == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = offsetIndex;
                }
            });
            return;
        }
        finally {
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)new $anonfun$1(this, randomAccessFile));
        }
    }
}

