/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals.metrics;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.MeteredIterator;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;

public class OpenIterators {
    private final TaskId taskId;
    private final String metricsScope;
    private final String name;
    private final StreamsMetricsImpl streamsMetrics;
    private final LongAdder numOpenIterators = new LongAdder();
    private final NavigableSet<MeteredIterator> openIterators = new ConcurrentSkipListSet<MeteredIterator>(Comparator.comparingLong(MeteredIterator::startTimestamp));
    private final AtomicLong oldestStartTimestamp = new AtomicLong();
    private MetricName metricName;

    public OpenIterators(TaskId taskId, String metricsScope, String name, StreamsMetricsImpl streamsMetrics) {
        this.taskId = taskId;
        this.metricsScope = metricsScope;
        this.name = name;
        this.streamsMetrics = streamsMetrics;
    }

    public void add(MeteredIterator iterator) {
        this.openIterators.add(iterator);
        this.numOpenIterators.increment();
        this.updateOldestStartTimestamp();
        if (this.numOpenIterators.intValue() == 1) {
            this.metricName = StateStoreMetrics.addOldestOpenIteratorGauge(this.taskId.toString(), this.metricsScope, this.name, this.streamsMetrics, (Gauge<Long>)((Gauge)(config, now) -> this.oldestStartTimestamp.get()));
        }
    }

    public void remove(MeteredIterator iterator) {
        if (this.numOpenIterators.intValue() == 1) {
            this.streamsMetrics.removeMetric(this.metricName);
            this.streamsMetrics.removeStoreLevelMetric(this.metricName);
        }
        this.numOpenIterators.decrement();
        this.openIterators.remove(iterator);
        this.updateOldestStartTimestamp();
    }

    public long sum() {
        return this.numOpenIterators.sum();
    }

    private void updateOldestStartTimestamp() {
        Iterator<MeteredIterator> openIteratorsIterator = this.openIterators.iterator();
        if (openIteratorsIterator.hasNext()) {
            this.oldestStartTimestamp.set(openIteratorsIterator.next().startTimestamp());
        }
    }
}

