/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RocksDBVersionedStoreSegmentValueFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBVersionedStoreSegmentValueFormatter.class);
    private static final int TIMESTAMP_SIZE = 8;
    private static final int VALUE_SIZE = 4;

    RocksDBVersionedStoreSegmentValueFormatter() {
    }

    static long getNextTimestamp(byte[] segmentValue) {
        return ByteBuffer.wrap(segmentValue).getLong(0);
    }

    static long getMinTimestamp(byte[] segmentValue) {
        return ByteBuffer.wrap(segmentValue).getLong(8);
    }

    static SegmentValue deserialize(byte[] segmentValue) {
        return new PartiallyDeserializedSegmentValue(segmentValue);
    }

    static SegmentValue newSegmentValueWithRecord(byte[] value, long validFrom, long validTo) {
        return new PartiallyDeserializedSegmentValue(value, validFrom, validTo);
    }

    private static class PartiallyDeserializedSegmentValue
    implements SegmentValue {
        private byte[] segmentValue;
        private long nextTimestamp;
        private long minTimestamp;
        private boolean isDegenerate;
        private int deserIndex = -1;
        private List<TimestampAndValueSize> unpackedReversedTimestampAndValueSizes;
        private List<Integer> cumulativeValueSizes;

        private PartiallyDeserializedSegmentValue(byte[] segmentValue) {
            this.segmentValue = segmentValue;
            this.nextTimestamp = RocksDBVersionedStoreSegmentValueFormatter.getNextTimestamp(segmentValue);
            this.minTimestamp = RocksDBVersionedStoreSegmentValueFormatter.getMinTimestamp(segmentValue);
            this.isDegenerate = this.nextTimestamp == this.minTimestamp;
            this.resetDeserHelpers();
        }

        private PartiallyDeserializedSegmentValue(byte[] valueOrNull, long validFrom, long validTo) {
            this.initializeWithRecord(new ValueAndValueSize(valueOrNull), validFrom, validTo);
        }

        @Override
        public SegmentValue.SegmentSearchResult find(long timestamp, boolean includeValue) {
            if (timestamp < this.minTimestamp) {
                throw new IllegalArgumentException("Timestamp is too small to be found in this segment.");
            }
            if (timestamp >= this.nextTimestamp) {
                throw new IllegalArgumentException("Timestamp is too large to be found in this segment.");
            }
            long currNextTimestamp = this.nextTimestamp;
            long currTimestamp = -1L;
            int currIndex = 0;
            int cumValueSize = 0;
            while (currTimestamp != this.minTimestamp) {
                int currValueSize;
                if (currIndex <= this.deserIndex) {
                    TimestampAndValueSize curr = this.unpackedReversedTimestampAndValueSizes.get(currIndex);
                    currTimestamp = curr.timestamp;
                    currValueSize = curr.valueSize;
                    cumValueSize = this.cumulativeValueSizes.get(currIndex);
                } else {
                    int timestampSegmentIndex = 16 + currIndex * 12;
                    currTimestamp = ByteBuffer.wrap(this.segmentValue).getLong(timestampSegmentIndex);
                    currValueSize = ByteBuffer.wrap(this.segmentValue).getInt(timestampSegmentIndex + 8);
                    this.deserIndex = currIndex;
                    this.unpackedReversedTimestampAndValueSizes.add(new TimestampAndValueSize(currTimestamp, currValueSize));
                    this.cumulativeValueSizes.add(cumValueSize += Math.max(currValueSize, 0));
                }
                if (currTimestamp <= timestamp) {
                    if (includeValue) {
                        if (currValueSize >= 0) {
                            byte[] value = new byte[currValueSize];
                            int valueSegmentIndex = this.segmentValue.length - cumValueSize;
                            System.arraycopy(this.segmentValue, valueSegmentIndex, value, 0, currValueSize);
                            return new SegmentValue.SegmentSearchResult(currIndex, currTimestamp, currNextTimestamp, value);
                        }
                        return new SegmentValue.SegmentSearchResult(currIndex, currTimestamp, currNextTimestamp, null);
                    }
                    return new SegmentValue.SegmentSearchResult(currIndex, currTimestamp, currNextTimestamp);
                }
                currNextTimestamp = currTimestamp;
                ++currIndex;
            }
            throw new IllegalStateException("Search in segment expected to find result but did not.");
        }

        @Override
        public void insertAsLatest(long validFrom, long validTo, byte[] valueOrNull) {
            ValueAndValueSize value = new ValueAndValueSize(valueOrNull);
            if (validFrom < this.nextTimestamp) {
                LOG.warn("Detected inconsistency among versioned store segments. This indicates a previous failure to write to a state store. Automatically recovering and continuing.");
                this.truncateRecordsToTimestamp(validFrom);
            }
            if (this.nextTimestamp == validFrom) {
                if (this.isDegenerate) {
                    this.initializeWithRecord(value, validFrom, validTo);
                } else {
                    this.doInsert(validFrom, value, 0);
                }
            } else {
                if (this.isDegenerate) {
                    this.initializeWithRecord(new ValueAndValueSize(null), this.nextTimestamp, validFrom);
                } else {
                    this.doInsert(this.nextTimestamp, new ValueAndValueSize(null), 0);
                }
                this.doInsert(validFrom, value, 0);
            }
            this.nextTimestamp = validTo;
            ByteBuffer.wrap(this.segmentValue, 0, 8).putLong(this.nextTimestamp);
        }

        @Override
        public void insertAsEarliest(long timestamp, byte[] valueOrNull) {
            ValueAndValueSize value = new ValueAndValueSize(valueOrNull);
            if (this.isDegenerate) {
                this.initializeWithRecord(value, timestamp, this.nextTimestamp);
            } else {
                int lastIndex = this.find(this.minTimestamp, false).index;
                this.doInsert(timestamp, value, lastIndex + 1);
            }
        }

        @Override
        public void insert(long timestamp, byte[] valueOrNull, int index) {
            if (index > this.deserIndex) {
                throw new IllegalArgumentException("Must invoke find() to deserialize record before insert() at specific index.");
            }
            ValueAndValueSize value = new ValueAndValueSize(valueOrNull);
            this.doInsert(timestamp, value, index);
        }

        private void doInsert(long timestamp, ValueAndValueSize value, int index) {
            if (index > this.deserIndex + 1) {
                throw new IllegalStateException("Must invoke find() to deserialize record before insert() at specific index.");
            }
            if (this.isDegenerate || index < 0) {
                throw new IllegalStateException("Cannot insert at negative index or into degenerate segment.");
            }
            boolean needsMinTsUpdate = this.isLastIndex(index - 1);
            this.truncateDeserHelpersToIndex(index - 1);
            this.unpackedReversedTimestampAndValueSizes.add(new TimestampAndValueSize(timestamp, value.valueSize()));
            int prevCumValueSize = this.deserIndex == -1 ? 0 : this.cumulativeValueSizes.get(this.deserIndex);
            this.cumulativeValueSizes.add(prevCumValueSize + value.value().length);
            ++this.deserIndex;
            int segmentTimestampIndex = 16 + index * 12;
            this.segmentValue = ByteBuffer.allocate(this.segmentValue.length + 8 + 4 + value.value().length).put(this.segmentValue, 0, segmentTimestampIndex).putLong(timestamp).putInt(value.valueSize()).put(this.segmentValue, segmentTimestampIndex, this.segmentValue.length - segmentTimestampIndex - prevCumValueSize).put(value.value()).put(this.segmentValue, this.segmentValue.length - prevCumValueSize, prevCumValueSize).array();
            if (needsMinTsUpdate) {
                this.minTimestamp = timestamp;
                ByteBuffer.wrap(this.segmentValue, 8, 8).putLong(8, this.minTimestamp);
            }
        }

        @Override
        public void updateRecord(long timestamp, byte[] valueOrNull, int index) {
            if (index > this.deserIndex || index < 0) {
                throw new IllegalArgumentException("Must invoke find() to deserialize record before updateRecord().");
            }
            ValueAndValueSize value = new ValueAndValueSize(valueOrNull);
            int oldValueSize = Math.max(this.unpackedReversedTimestampAndValueSizes.get((int)index).valueSize, 0);
            int oldCumValueSize = this.cumulativeValueSizes.get(index);
            boolean needsMinTsUpdate = this.isLastIndex(index);
            this.unpackedReversedTimestampAndValueSizes.set(index, new TimestampAndValueSize(timestamp, value.valueSize()));
            this.cumulativeValueSizes.set(index, oldCumValueSize - oldValueSize + value.value().length);
            this.truncateDeserHelpersToIndex(index);
            int segmentTimestampIndex = 16 + index * 12;
            this.segmentValue = ByteBuffer.allocate(this.segmentValue.length - oldValueSize + value.value().length).put(this.segmentValue, 0, segmentTimestampIndex).putLong(timestamp).putInt(value.valueSize()).put(this.segmentValue, segmentTimestampIndex + 8 + 4, this.segmentValue.length - (segmentTimestampIndex + 8 + 4) - oldCumValueSize).put(value.value()).put(this.segmentValue, this.segmentValue.length - oldCumValueSize + oldValueSize, oldCumValueSize - oldValueSize).array();
            if (needsMinTsUpdate) {
                this.minTimestamp = timestamp;
                ByteBuffer.wrap(this.segmentValue, 8, 8).putLong(8, this.minTimestamp);
            }
        }

        @Override
        public byte[] serialize() {
            return this.segmentValue;
        }

        private void initializeWithRecord(ValueAndValueSize value, long validFrom, long validTo) {
            this.nextTimestamp = validTo;
            this.minTimestamp = validFrom;
            this.segmentValue = ByteBuffer.allocate(28 + value.value().length).putLong(this.nextTimestamp).putLong(this.minTimestamp).putLong(validFrom).putInt(value.valueSize()).put(value.value()).array();
            this.isDegenerate = this.nextTimestamp == this.minTimestamp;
            this.resetDeserHelpers();
        }

        private void resetDeserHelpers() {
            this.deserIndex = -1;
            this.unpackedReversedTimestampAndValueSizes = new ArrayList<TimestampAndValueSize>();
            this.cumulativeValueSizes = new ArrayList<Integer>();
        }

        private void truncateDeserHelpersToIndex(int index) {
            this.deserIndex = index;
            this.unpackedReversedTimestampAndValueSizes.subList(index + 1, this.unpackedReversedTimestampAndValueSizes.size()).clear();
            this.cumulativeValueSizes.subList(index + 1, this.cumulativeValueSizes.size()).clear();
        }

        private boolean isLastIndex(int index) {
            if (index < 0) {
                return false;
            }
            return this.unpackedReversedTimestampAndValueSizes.get((int)index).timestamp == this.minTimestamp;
        }

        private void truncateRecordsToTimestamp(long timestamp) {
            if (timestamp <= this.minTimestamp) {
                int totalRecords = this.find(this.minTimestamp, false).index() + 1;
                if (timestamp != this.minTimestamp || totalRecords != 1) {
                    LOG.warn("The versioned store inconsistency affects more than one record version, even though under normal replay operations only one record should be affected. Full records affected: {} (expected: 1). New record timestamp: {} (expected: {}).", new Object[]{totalRecords, timestamp, this.unpackedReversedTimestampAndValueSizes.get((int)0).timestamp});
                }
                this.initializeWithRecord(new ValueAndValueSize(null), timestamp, timestamp);
                return;
            }
            SegmentValue.SegmentSearchResult searchResult = this.find(timestamp, false);
            int fullRecordsToTruncate = searchResult.index();
            if (searchResult.validFrom() == timestamp) {
                ++fullRecordsToTruncate;
            }
            if (fullRecordsToTruncate != 1 || searchResult.index != 0) {
                LOG.warn("The versioned store inconsistency affects more (or less) than one record version, even though under normal replay operations only one record should be affected. Full records affected: {} (expected: 1). New record timestamp: {} (expected: {}).", new Object[]{fullRecordsToTruncate, timestamp, this.unpackedReversedTimestampAndValueSizes.get((int)0).timestamp});
            }
            if (fullRecordsToTruncate == 0) {
                this.nextTimestamp = timestamp;
                ByteBuffer.wrap(this.segmentValue, 0, 8).putLong(0, timestamp);
                return;
            }
            int valuesLengthToRemove = this.cumulativeValueSizes.get(fullRecordsToTruncate - 1);
            int timestampAndValueSizesLengthToRemove = 12 * fullRecordsToTruncate;
            int newSegmentLength = this.segmentValue.length - valuesLengthToRemove - timestampAndValueSizesLengthToRemove;
            this.segmentValue = ByteBuffer.allocate(newSegmentLength).putLong(timestamp).putLong(this.minTimestamp).put(this.segmentValue, 16 + timestampAndValueSizesLengthToRemove, newSegmentLength - 16).array();
            this.nextTimestamp = timestamp;
            this.resetDeserHelpers();
        }

        private static class ValueAndValueSize {
            private final byte[] valueToStore;
            private final int valueSizeToStore;

            ValueAndValueSize(byte[] valueOrNull) {
                if (valueOrNull == null) {
                    this.valueToStore = new byte[0];
                    this.valueSizeToStore = -1;
                } else {
                    this.valueToStore = valueOrNull;
                    this.valueSizeToStore = this.valueToStore.length;
                }
            }

            byte[] value() {
                return this.valueToStore;
            }

            int valueSize() {
                return this.valueSizeToStore;
            }
        }

        private static class TimestampAndValueSize {
            final long timestamp;
            final int valueSize;

            TimestampAndValueSize(long timestamp, int valueSize) {
                this.timestamp = timestamp;
                this.valueSize = valueSize;
            }
        }
    }

    static interface SegmentValue {
        public SegmentSearchResult find(long var1, boolean var3);

        public void insertAsLatest(long var1, long var3, byte[] var5);

        public void insertAsEarliest(long var1, byte[] var3);

        public void insert(long var1, byte[] var3, int var4);

        public void updateRecord(long var1, byte[] var3, int var4);

        public byte[] serialize();

        public static class SegmentSearchResult {
            private final int index;
            private final long validFrom;
            private final long validTo;
            private final byte[] value;

            SegmentSearchResult(int index, long validFrom, long validTo) {
                this(index, validFrom, validTo, null);
            }

            SegmentSearchResult(int index, long validFrom, long validTo, byte[] value) {
                this.index = index;
                this.validFrom = validFrom;
                this.validTo = validTo;
                this.value = value;
            }

            int index() {
                return this.index;
            }

            long validFrom() {
                return this.validFrom;
            }

            long validTo() {
                return this.validTo;
            }

            byte[] value() {
                return this.value;
            }
        }
    }
}

