/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.StoreBuilder;

public class TableProcessorNode<K, V>
extends GraphNode {
    private final ProcessorParameters<K, V, ?, ?> processorParameters;
    private final StoreBuilder<?> storeBuilder;
    private final String[] storeNames;

    public TableProcessorNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, StoreBuilder<?> storeBuilder) {
        this(nodeName, processorParameters, storeBuilder, null);
    }

    public TableProcessorNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, StoreBuilder<?> storeBuilder, String[] storeNames) {
        super(nodeName);
        this.processorParameters = processorParameters;
        this.storeBuilder = storeBuilder;
        this.storeNames = storeNames != null ? storeNames : new String[]{};
    }

    public ProcessorParameters<K, V, ?, ?> processorParameters() {
        return this.processorParameters;
    }

    @Override
    public String toString() {
        return "TableProcessorNode{, processorParameters=" + this.processorParameters + ", storeBuilder=" + (this.storeBuilder == null ? "null" : this.storeBuilder.name()) + ", storeNames=" + Arrays.toString(this.storeNames) + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        KTableSource tableSource;
        String processorName = this.processorParameters.processorName();
        topologyBuilder.addProcessor(processorName, this.processorParameters.processorSupplier(), this.parentNodeNames());
        if (this.storeNames.length > 0) {
            topologyBuilder.connectProcessorAndStateStores(processorName, this.storeNames);
        }
        KTableSource kTableSource = tableSource = this.processorParameters.processorSupplier() instanceof KTableSource ? (KTableSource)this.processorParameters.processorSupplier() : null;
        if (tableSource != null) {
            if (tableSource.materialized()) {
                topologyBuilder.addStateStore(Objects.requireNonNull(this.storeBuilder, "storeBuilder was null"), processorName);
            }
        } else if (this.storeBuilder != null) {
            topologyBuilder.addStateStore(this.storeBuilder, processorName);
        }
    }
}

