/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.SlidingWindows;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamSlidingWindowAggregate<KIn, VIn, VAgg>
implements KStreamAggProcessorSupplier<KIn, VIn, Windowed<KIn>, VAgg> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String storeName;
    private final SlidingWindows windows;
    private final Initializer<VAgg> initializer;
    private final Aggregator<? super KIn, ? super VIn, VAgg> aggregator;
    private boolean sendOldValues = false;

    public KStreamSlidingWindowAggregate(SlidingWindows windows, String storeName, Initializer<VAgg> initializer, Aggregator<? super KIn, ? super VIn, VAgg> aggregator) {
        this.windows = windows;
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
    }

    @Override
    public Processor<KIn, VIn, Windowed<KIn>, Change<VAgg>> get() {
        return new KStreamSlidingWindowAggregateProcessor();
    }

    public SlidingWindows windows() {
        return this.windows;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<Windowed<KIn>, VAgg> view() {
        return new KTableValueGetterSupplier<Windowed<KIn>, VAgg>(){

            @Override
            public KTableValueGetter<Windowed<KIn>, VAgg> get() {
                return new KStreamWindowAggregateValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamSlidingWindowAggregate.this.storeName};
            }
        };
    }

    private class KStreamWindowAggregateValueGetter
    implements KTableValueGetter<Windowed<KIn>, VAgg> {
        private TimestampedWindowStore<KIn, VAgg> windowStore;

        private KStreamWindowAggregateValueGetter() {
        }

        @Override
        public void init(org.apache.kafka.streams.processor.ProcessorContext context) {
            this.windowStore = (TimestampedWindowStore)context.getStateStore(KStreamSlidingWindowAggregate.this.storeName);
        }

        @Override
        public ValueAndTimestamp<VAgg> get(Windowed<KIn> windowedKey) {
            Object key = windowedKey.key();
            return (ValueAndTimestamp)this.windowStore.fetch(key, windowedKey.window().start());
        }

        @Override
        public void close() {
        }
    }

    private class KStreamSlidingWindowAggregateProcessor
    extends ContextualProcessor<KIn, VIn, Windowed<KIn>, Change<VAgg>> {
        private TimestampedWindowStore<KIn, VAgg> windowStore;
        private TimestampedTupleForwarder<Windowed<KIn>, VAgg> tupleForwarder;
        private Sensor droppedRecordsSensor;
        private long observedStreamTime = -1L;
        private Boolean reverseIteratorPossible = null;

        private KStreamSlidingWindowAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext<Windowed<KIn>, Change<VAgg>> context) {
            super.init(context);
            InternalProcessorContext internalProcessorContext = (InternalProcessorContext)context;
            StreamsMetricsImpl metrics = internalProcessorContext.metrics();
            String threadId = Thread.currentThread().getName();
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(threadId, context.taskId().toString(), metrics);
            this.windowStore = (TimestampedWindowStore)context.getStateStore(KStreamSlidingWindowAggregate.this.storeName);
            this.tupleForwarder = new TimestampedTupleForwarder(this.windowStore, context, new TimestampedCacheFlushListener(context), KStreamSlidingWindowAggregate.this.sendOldValues);
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            if (record.key() == null || record.value() == null) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    KStreamSlidingWindowAggregate.this.log.warn("Skipping record due to null key or value. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    KStreamSlidingWindowAggregate.this.log.warn("Skipping record due to null key or value. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            long inputRecordTimestamp = record.timestamp();
            this.observedStreamTime = Math.max(this.observedStreamTime, inputRecordTimestamp);
            long closeTime = this.observedStreamTime - KStreamSlidingWindowAggregate.this.windows.gracePeriodMs();
            if (inputRecordTimestamp + 1L + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs() <= closeTime) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    KStreamSlidingWindowAggregate.this.log.warn("Skipping record for expired window. topic=[{}] partition=[{}] offset=[{}] timestamp=[{}] window=[{},{}] expiration=[{}] streamTime=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset(), record.timestamp(), inputRecordTimestamp - KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs(), inputRecordTimestamp, closeTime, this.observedStreamTime});
                } else {
                    KStreamSlidingWindowAggregate.this.log.warn("Skipping record for expired window. Topic, partition, and offset not known. timestamp=[{}] window=[{},{}] expiration=[{}] streamTime=[{}]", new Object[]{record.timestamp(), inputRecordTimestamp - KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs(), inputRecordTimestamp, closeTime, this.observedStreamTime});
                }
                this.droppedRecordsSensor.record();
                return;
            }
            if (inputRecordTimestamp < KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs()) {
                this.processEarly(record.key(), record.value(), inputRecordTimestamp, closeTime);
                return;
            }
            if (this.reverseIteratorPossible == null) {
                try {
                    this.windowStore.backwardFetch(record.key(), 0L, 0L);
                    this.reverseIteratorPossible = true;
                    KStreamSlidingWindowAggregate.this.log.debug("Sliding Windows aggregate using a reverse iterator");
                }
                catch (UnsupportedOperationException e) {
                    this.reverseIteratorPossible = false;
                    KStreamSlidingWindowAggregate.this.log.debug("Sliding Windows aggregate using a forward iterator");
                }
            }
            if (this.reverseIteratorPossible.booleanValue()) {
                this.processReverse(record.key(), record.value(), inputRecordTimestamp, closeTime);
            } else {
                this.processInOrder(record.key(), record.value(), inputRecordTimestamp, closeTime);
            }
        }

        public void processInOrder(KIn key, VIn value, long inputRecordTimestamp, long closeTime) {
            HashSet<Long> windowStartTimes = new HashSet<Long>();
            ValueAndTimestamp leftWinAgg = null;
            ValueAndTimestamp rightWinAgg = null;
            boolean leftWinAlreadyCreated = false;
            boolean rightWinAlreadyCreated = false;
            Long previousRecordTimestamp = null;
            try (KeyValueIterator iterator = this.windowStore.fetch(key, key, Math.max(0L, inputRecordTimestamp - 2L * KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs()), inputRecordTimestamp + 1L);){
                while (iterator.hasNext()) {
                    KeyValue windowBeingProcessed = (KeyValue)iterator.next();
                    long startTime = ((Windowed)windowBeingProcessed.key).window().start();
                    windowStartTimes.add(startTime);
                    long endTime = startTime + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs();
                    long windowMaxRecordTimestamp = ((ValueAndTimestamp)windowBeingProcessed.value).timestamp();
                    if (endTime < inputRecordTimestamp) {
                        leftWinAgg = (ValueAndTimestamp)windowBeingProcessed.value;
                        previousRecordTimestamp = windowMaxRecordTimestamp;
                        continue;
                    }
                    if (endTime == inputRecordTimestamp) {
                        leftWinAlreadyCreated = true;
                        if (windowMaxRecordTimestamp < inputRecordTimestamp) {
                            previousRecordTimestamp = windowMaxRecordTimestamp;
                        }
                        this.updateWindowAndForward(((Windowed)windowBeingProcessed.key).window(), (ValueAndTimestamp)windowBeingProcessed.value, key, value, closeTime, inputRecordTimestamp);
                        continue;
                    }
                    if (endTime > inputRecordTimestamp && startTime <= inputRecordTimestamp) {
                        rightWinAgg = (ValueAndTimestamp)windowBeingProcessed.value;
                        this.updateWindowAndForward(((Windowed)windowBeingProcessed.key).window(), (ValueAndTimestamp)windowBeingProcessed.value, key, value, closeTime, inputRecordTimestamp);
                        continue;
                    }
                    if (startTime == inputRecordTimestamp + 1L) {
                        rightWinAlreadyCreated = true;
                        continue;
                    }
                    KStreamSlidingWindowAggregate.this.log.error("Unexpected window with start {} found when processing record at {} in `KStreamSlidingWindowAggregate`.", (Object)startTime, (Object)inputRecordTimestamp);
                    throw new IllegalStateException("Unexpected window found when processing sliding windows");
                }
            }
            this.createWindows(key, value, inputRecordTimestamp, closeTime, windowStartTimes, rightWinAgg, leftWinAgg, leftWinAlreadyCreated, rightWinAlreadyCreated, previousRecordTimestamp);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void processReverse(KIn key, VIn value, long inputRecordTimestamp, long closeTime) {
            HashSet<Long> windowStartTimes = new HashSet<Long>();
            ValueAndTimestamp leftWinAgg = null;
            ValueAndTimestamp rightWinAgg = null;
            boolean leftWinAlreadyCreated = false;
            boolean rightWinAlreadyCreated = false;
            Long previousRecordTimestamp = null;
            try (KeyValueIterator iterator = this.windowStore.backwardFetch(key, key, Math.max(0L, inputRecordTimestamp - 2L * KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs()), inputRecordTimestamp + 1L);){
                while (iterator.hasNext()) {
                    KeyValue windowBeingProcessed = (KeyValue)iterator.next();
                    long startTime = ((Windowed)windowBeingProcessed.key).window().start();
                    windowStartTimes.add(startTime);
                    long endTime = startTime + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs();
                    long windowMaxRecordTimestamp = ((ValueAndTimestamp)windowBeingProcessed.value).timestamp();
                    if (startTime == inputRecordTimestamp + 1L) {
                        rightWinAlreadyCreated = true;
                        continue;
                    }
                    if (endTime > inputRecordTimestamp) {
                        if (rightWinAgg == null) {
                            rightWinAgg = (ValueAndTimestamp)windowBeingProcessed.value;
                        }
                        this.updateWindowAndForward(((Windowed)windowBeingProcessed.key).window(), (ValueAndTimestamp)windowBeingProcessed.value, key, value, closeTime, inputRecordTimestamp);
                        continue;
                    }
                    if (endTime == inputRecordTimestamp) {
                        leftWinAlreadyCreated = true;
                        this.updateWindowAndForward(((Windowed)windowBeingProcessed.key).window(), (ValueAndTimestamp)windowBeingProcessed.value, key, value, closeTime, inputRecordTimestamp);
                        if (windowMaxRecordTimestamp >= inputRecordTimestamp) {
                            return;
                        }
                        previousRecordTimestamp = windowMaxRecordTimestamp;
                        continue;
                    }
                    if (endTime >= inputRecordTimestamp) {
                        KStreamSlidingWindowAggregate.this.log.error("Unexpected window with start {} found when processing record at {} in `KStreamSlidingWindowAggregate`.", (Object)startTime, (Object)inputRecordTimestamp);
                        throw new IllegalStateException("Unexpected window found when processing sliding windows");
                    }
                    leftWinAgg = (ValueAndTimestamp)windowBeingProcessed.value;
                    previousRecordTimestamp = windowMaxRecordTimestamp;
                    break;
                }
            }
            this.createWindows(key, value, inputRecordTimestamp, closeTime, windowStartTimes, rightWinAgg, leftWinAgg, leftWinAlreadyCreated, rightWinAlreadyCreated, previousRecordTimestamp);
        }

        private void processEarly(KIn key, VIn value, long inputRecordTimestamp, long closeTime) {
            if (inputRecordTimestamp < 0L || inputRecordTimestamp >= KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs()) {
                KStreamSlidingWindowAggregate.this.log.error("Early record for sliding windows must fall between fall between 0 <= inputRecordTimestamp. Timestamp {} does not fall between 0 <= {}", (Object)inputRecordTimestamp, (Object)KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs());
                throw new IllegalArgumentException("Early record for sliding windows must fall between fall between 0 <= inputRecordTimestamp");
            }
            KeyValue combinedWindow = null;
            ValueAndTimestamp rightWinAgg = null;
            boolean rightWinAlreadyCreated = false;
            HashSet<Long> windowStartTimes = new HashSet<Long>();
            Long previousRecordTimestamp = null;
            try (KeyValueIterator iterator = this.windowStore.fetch(key, key, 0L, inputRecordTimestamp + 1L);){
                while (iterator.hasNext()) {
                    KeyValue windowBeingProcessed = (KeyValue)iterator.next();
                    long startTime = ((Windowed)windowBeingProcessed.key).window().start();
                    windowStartTimes.add(startTime);
                    long windowMaxRecordTimestamp = ((ValueAndTimestamp)windowBeingProcessed.value).timestamp();
                    if (startTime == 0L) {
                        combinedWindow = windowBeingProcessed;
                        if (windowMaxRecordTimestamp >= inputRecordTimestamp) continue;
                        previousRecordTimestamp = windowMaxRecordTimestamp;
                        continue;
                    }
                    if (startTime <= inputRecordTimestamp) {
                        rightWinAgg = (ValueAndTimestamp)windowBeingProcessed.value;
                        this.updateWindowAndForward(((Windowed)windowBeingProcessed.key).window(), (ValueAndTimestamp)windowBeingProcessed.value, key, value, closeTime, inputRecordTimestamp);
                        continue;
                    }
                    if (startTime == inputRecordTimestamp + 1L) {
                        rightWinAlreadyCreated = true;
                        continue;
                    }
                    KStreamSlidingWindowAggregate.this.log.error("Unexpected window with start {} found when processing record at {} in `KStreamSlidingWindowAggregate`.", (Object)startTime, (Object)inputRecordTimestamp);
                    throw new IllegalStateException("Unexpected window found when processing sliding windows");
                }
            }
            if (rightWinAgg == null && combinedWindow != null && ((ValueAndTimestamp)combinedWindow.value).timestamp() > inputRecordTimestamp) {
                rightWinAgg = (ValueAndTimestamp)combinedWindow.value;
            }
            if (!rightWinAlreadyCreated && this.rightWindowIsNotEmpty(rightWinAgg, inputRecordTimestamp)) {
                this.createCurrentRecordRightWindow(inputRecordTimestamp, rightWinAgg, key);
            }
            if (previousRecordTimestamp != null && !windowStartTimes.contains(previousRecordTimestamp + 1L)) {
                this.createPreviousRecordRightWindow(previousRecordTimestamp + 1L, inputRecordTimestamp, key, value, closeTime);
            }
            if (combinedWindow == null) {
                TimeWindow window = new TimeWindow(0L, KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs());
                ValueAndTimestamp valueAndTime = ValueAndTimestamp.make(KStreamSlidingWindowAggregate.this.initializer.apply(), inputRecordTimestamp);
                this.updateWindowAndForward(window, valueAndTime, key, value, closeTime, inputRecordTimestamp);
            } else {
                this.updateWindowAndForward(((Windowed)combinedWindow.key).window(), (ValueAndTimestamp)combinedWindow.value, key, value, closeTime, inputRecordTimestamp);
            }
        }

        private void createWindows(KIn key, VIn value, long inputRecordTimestamp, long closeTime, Set<Long> windowStartTimes, ValueAndTimestamp<VAgg> rightWinAgg, ValueAndTimestamp<VAgg> leftWinAgg, boolean leftWinAlreadyCreated, boolean rightWinAlreadyCreated, Long previousRecordTimestamp) {
            long previousRightWinStart;
            if (previousRecordTimestamp != null && this.previousRecordRightWindowDoesNotExistAndIsNotEmpty(windowStartTimes, previousRightWinStart = previousRecordTimestamp + 1L, inputRecordTimestamp)) {
                this.createPreviousRecordRightWindow(previousRightWinStart, inputRecordTimestamp, key, value, closeTime);
            }
            if (!leftWinAlreadyCreated) {
                ValueAndTimestamp<Object> valueAndTime = this.leftWindowNotEmpty(previousRecordTimestamp, inputRecordTimestamp) ? ValueAndTimestamp.make(leftWinAgg.value(), inputRecordTimestamp) : ValueAndTimestamp.make(KStreamSlidingWindowAggregate.this.initializer.apply(), inputRecordTimestamp);
                TimeWindow window = new TimeWindow(inputRecordTimestamp - KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs(), inputRecordTimestamp);
                this.updateWindowAndForward(window, valueAndTime, key, value, closeTime, inputRecordTimestamp);
            }
            if (!rightWinAlreadyCreated && this.rightWindowIsNotEmpty(rightWinAgg, inputRecordTimestamp)) {
                this.createCurrentRecordRightWindow(inputRecordTimestamp, rightWinAgg, key);
            }
        }

        private void createCurrentRecordRightWindow(long inputRecordTimestamp, ValueAndTimestamp<VAgg> rightWinAgg, KIn key) {
            TimeWindow window = new TimeWindow(inputRecordTimestamp + 1L, inputRecordTimestamp + 1L + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs());
            this.windowStore.put(key, rightWinAgg, window.start());
            this.tupleForwarder.maybeForward(new Windowed(key, window), rightWinAgg.value(), null, rightWinAgg.timestamp());
        }

        private void createPreviousRecordRightWindow(long windowStart, long inputRecordTimestamp, KIn key, VIn value, long closeTime) {
            TimeWindow window = new TimeWindow(windowStart, windowStart + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs());
            ValueAndTimestamp valueAndTime = ValueAndTimestamp.make(KStreamSlidingWindowAggregate.this.initializer.apply(), inputRecordTimestamp);
            this.updateWindowAndForward(window, valueAndTime, key, value, closeTime, inputRecordTimestamp);
        }

        private boolean leftWindowNotEmpty(Long previousRecordTimestamp, long inputRecordTimestamp) {
            return previousRecordTimestamp != null && inputRecordTimestamp - KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs() <= previousRecordTimestamp;
        }

        private boolean previousRecordRightWindowDoesNotExistAndIsNotEmpty(Set<Long> windowStartTimes, long previousRightWindowStart, long inputRecordTimestamp) {
            return !windowStartTimes.contains(previousRightWindowStart) && previousRightWindowStart + KStreamSlidingWindowAggregate.this.windows.timeDifferenceMs() >= inputRecordTimestamp;
        }

        private boolean rightWindowIsNotEmpty(ValueAndTimestamp<VAgg> rightWinAgg, long inputRecordTimestamp) {
            return rightWinAgg != null && rightWinAgg.timestamp() > inputRecordTimestamp;
        }

        private void updateWindowAndForward(Window window, ValueAndTimestamp<VAgg> valueAndTime, KIn key, VIn value, long closeTime, long inputRecordTimestamp) {
            long windowStart = window.start();
            long windowEnd = window.end();
            if (windowEnd > closeTime) {
                Object oldAgg = ValueAndTimestamp.getValueOrNull(valueAndTime);
                Object newAgg = KStreamSlidingWindowAggregate.this.aggregator.apply(key, value, oldAgg);
                long newTimestamp = oldAgg == null ? inputRecordTimestamp : Math.max(inputRecordTimestamp, valueAndTime.timestamp());
                this.windowStore.put(key, ValueAndTimestamp.make(newAgg, newTimestamp), windowStart);
                this.tupleForwarder.maybeForward(new Windowed(key, window), newAgg, KStreamSlidingWindowAggregate.this.sendOldValues ? oldAgg : null, newTimestamp);
            } else {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    KStreamSlidingWindowAggregate.this.log.warn("Skipping record for expired window. topic=[{}] partition=[{}] offset=[{}] timestamp=[{}] window=[{},{}] expiration=[{}] streamTime=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset(), inputRecordTimestamp, windowStart, windowEnd, closeTime, this.observedStreamTime});
                } else {
                    KStreamSlidingWindowAggregate.this.log.warn("Skipping record for expired window. Topic, partition, and offset not known. timestamp=[{}] window=[{},{}] expiration=[{}] streamTime=[{}]", new Object[]{inputRecordTimestamp, windowStart, windowEnd, closeTime, this.observedStreamTime});
                }
                this.droppedRecordsSensor.record();
            }
        }
    }
}

