/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.ProcessorNodeMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class ProcessorNodeMetricsTest {
    private static final String THREAD_ID = "test-thread";
    private static final String TASK_ID = "test-task";
    private static final String PROCESSOR_NODE_ID = "test-processor";
    private final Map<String, String> tagMap = Collections.singletonMap("hello", "world");
    private final Map<String, String> parentTagMap = Collections.singletonMap("hi", "universe");
    private final Sensor expectedSensor = (Sensor)Mockito.mock(Sensor.class);
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)Mockito.mock(StreamsMetricsImpl.class);
    private final Sensor expectedParentSensor = (Sensor)Mockito.mock(Sensor.class);

    @Test
    public void shouldGetSuppressionEmitSensor() {
        String metricNamePrefix = "suppression-emit";
        String descriptionOfCount = "The total number of emitted records from the suppression buffer";
        String descriptionOfRate = "The average number of emitted records from the suppression buffer per second";
        Mockito.when((Object)this.streamsMetrics.nodeLevelSensor(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, "suppression-emit", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.nodeLevelTagMap(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-processor-node-metrics", this.tagMap, (String)"suppression-emit", (String)"The average number of emitted records from the suppression buffer per second", (String)"The total number of emitted records from the suppression buffer");
        this.verifySensor(() -> ProcessorNodeMetrics.suppressionEmitSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetIdempotentUpdateSkipSensor() {
        String metricNamePrefix = "idempotent-update-skip";
        String descriptionOfCount = "The total number of skipped idempotent updates";
        String descriptionOfRate = "The average number of skipped idempotent updates per second";
        Mockito.when((Object)this.streamsMetrics.nodeLevelSensor(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, "idempotent-update-skip", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.nodeLevelTagMap(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-processor-node-metrics", this.tagMap, (String)"idempotent-update-skip", (String)"The average number of skipped idempotent updates per second", (String)"The total number of skipped idempotent updates");
        this.verifySensor(() -> ProcessorNodeMetrics.skippedIdempotentUpdatesSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetProcessAtSourceSensor() {
        String metricNamePrefix = "process";
        String descriptionOfCount = "The total number of calls to process";
        String descriptionOfRate = "The average number of calls to process per second";
        Mockito.when((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "process", Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedParentSensor);
        Mockito.when((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).thenReturn(this.parentTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedParentSensor, (String)"stream-task-metrics", this.parentTagMap, (String)"process", (String)"The average number of calls to process per second", (String)"The total number of calls to process");
        this.setUpThroughputSensor("process", "The average number of calls to process per second", "The total number of calls to process", Sensor.RecordingLevel.DEBUG, this.expectedParentSensor);
        this.verifySensor(() -> ProcessorNodeMetrics.processAtSourceSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetForwardSensor() {
        String metricNamePrefix = "forward";
        String descriptionOfCount = "The total number of calls to forward";
        String descriptionOfRate = "The average number of calls to forward per second";
        this.setUpThroughputParentSensor("forward", "The average number of calls to forward per second", "The total number of calls to forward");
        this.setUpThroughputSensor("forward", "The average number of calls to forward per second", "The total number of calls to forward", Sensor.RecordingLevel.DEBUG, this.expectedParentSensor);
        this.verifySensor(() -> ProcessorNodeMetrics.forwardSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    private void setUpThroughputParentSensor(String metricNamePrefix, String descriptionOfRate, String descriptionOfCount) {
        Mockito.when((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, metricNamePrefix, Sensor.RecordingLevel.DEBUG, new Sensor[0])).thenReturn((Object)this.expectedParentSensor);
        Mockito.when((Object)this.streamsMetrics.nodeLevelTagMap(THREAD_ID, TASK_ID, "all")).thenReturn(this.parentTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedParentSensor, (String)"stream-processor-node-metrics", this.parentTagMap, (String)metricNamePrefix, (String)descriptionOfRate, (String)descriptionOfCount);
    }

    private void setUpThroughputSensor(String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, Sensor.RecordingLevel recordingLevel, Sensor ... parentSensors) {
        Mockito.when((Object)this.streamsMetrics.nodeLevelSensor(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, metricNamePrefix, recordingLevel, parentSensors)).thenReturn((Object)this.expectedSensor);
        Mockito.when((Object)this.streamsMetrics.nodeLevelTagMap(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID)).thenReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-processor-node-metrics", this.tagMap, (String)metricNamePrefix, (String)descriptionOfRate, (String)descriptionOfCount);
    }

    private void verifySensor(Supplier<Sensor> sensorSupplier) {
        Sensor sensor = sensorSupplier.get();
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }
}

