/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.LegacySubscriptionInfoSerde;
import org.apache.kafka.streams.processor.internals.assignment.SubscriptionInfo;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionInfoTest {
    private static final Set<TaskId> ACTIVE_TASKS = new HashSet<TaskId>(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0));
    private static final Set<TaskId> STANDBY_TASKS = new HashSet<TaskId>(Arrays.asList(AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_2_0));
    private static final Map<TaskId, Long> TASK_OFFSET_SUMS = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)-2L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)-2L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_0, (Object)-2L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_1, (Object)0L), Utils.mkEntry((Object)AssignmentTestUtils.TASK_2_0, (Object)10L)});
    private static final Map<TaskId, Long> NAMED_TASK_OFFSET_SUMS = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T0_0_0, (Object)-2L), Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T0_0_1, (Object)-2L), Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T0_1_0, (Object)5L), Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T0_1_1, (Object)10000L), Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T1_0_0, (Object)-2L), Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T1_0_1, (Object)0L), Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T2_0_0, (Object)10L), Utils.mkEntry((Object)AssignmentTestUtils.NAMED_TASK_T2_2_0, (Object)5L)});
    private static final String IGNORED_USER_ENDPOINT = "ignoredUserEndpoint:80";
    private static final byte IGNORED_UNIQUE_FIELD = 0;
    private static final int IGNORED_ERROR_CODE = 0;

    @Test
    public void shouldThrowForUnknownVersion1() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new SubscriptionInfo(0, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0));
    }

    @Test
    public void shouldThrowForUnknownVersion2() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new SubscriptionInfo(11, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0));
    }

    @Test
    public void shouldEncodeAndDecodeVersion1() {
        SubscriptionInfo info = new SubscriptionInfo(1, 10, AssignmentTestUtils.UUID_1, IGNORED_USER_ENDPOINT, TASK_OFFSET_SUMS, 0, 0);
        SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)info.encode());
        Assert.assertEquals((long)1L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)AssignmentTestUtils.UUID_1, (Object)decoded.processId());
        Assert.assertEquals(ACTIVE_TASKS, (Object)decoded.prevTasks());
        Assert.assertEquals(STANDBY_TASKS, (Object)decoded.standbyTasks());
        Assert.assertNull((Object)decoded.userEndPoint());
    }

    @Test
    public void generatedVersion1ShouldBeDecodableByLegacyLogic() {
        SubscriptionInfo info = new SubscriptionInfo(1, 1234, AssignmentTestUtils.UUID_1, "ignoreme", TASK_OFFSET_SUMS, 0, 0);
        ByteBuffer buffer = info.encode();
        LegacySubscriptionInfoSerde decoded = LegacySubscriptionInfoSerde.decode(buffer);
        Assert.assertEquals((long)1L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)AssignmentTestUtils.UUID_1, (Object)decoded.processId());
        Assert.assertEquals(ACTIVE_TASKS, decoded.prevTasks());
        Assert.assertEquals(STANDBY_TASKS, decoded.standbyTasks());
        Assert.assertNull((Object)decoded.userEndPoint());
    }

    @Test
    public void generatedVersion1ShouldDecodeLegacyFormat() {
        LegacySubscriptionInfoSerde info = new LegacySubscriptionInfoSerde(1, 10, AssignmentTestUtils.UUID_1, ACTIVE_TASKS, STANDBY_TASKS, "localhost:80");
        ByteBuffer buffer = info.encode();
        buffer.rewind();
        SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)buffer);
        Assert.assertEquals((long)1L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)AssignmentTestUtils.UUID_1, (Object)decoded.processId());
        Assert.assertEquals(ACTIVE_TASKS, (Object)decoded.prevTasks());
        Assert.assertEquals(STANDBY_TASKS, (Object)decoded.standbyTasks());
        Assert.assertNull((Object)decoded.userEndPoint());
    }

    @Test
    public void shouldEncodeAndDecodeVersion2() {
        SubscriptionInfo info = new SubscriptionInfo(2, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
        SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)info.encode());
        Assert.assertEquals((long)2L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)AssignmentTestUtils.UUID_1, (Object)decoded.processId());
        Assert.assertEquals(ACTIVE_TASKS, (Object)decoded.prevTasks());
        Assert.assertEquals(STANDBY_TASKS, (Object)decoded.standbyTasks());
        Assert.assertEquals((Object)"localhost:80", (Object)decoded.userEndPoint());
    }

    @Test
    public void generatedVersion2ShouldBeDecodableByLegacyLogic() {
        SubscriptionInfo info = new SubscriptionInfo(2, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
        ByteBuffer buffer = info.encode();
        LegacySubscriptionInfoSerde decoded = LegacySubscriptionInfoSerde.decode(buffer);
        Assert.assertEquals((long)2L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)AssignmentTestUtils.UUID_1, (Object)decoded.processId());
        Assert.assertEquals(ACTIVE_TASKS, decoded.prevTasks());
        Assert.assertEquals(STANDBY_TASKS, decoded.standbyTasks());
        Assert.assertEquals((Object)"localhost:80", (Object)decoded.userEndPoint());
    }

    @Test
    public void generatedVersion2ShouldDecodeLegacyFormat() {
        LegacySubscriptionInfoSerde info = new LegacySubscriptionInfoSerde(2, 10, AssignmentTestUtils.UUID_1, ACTIVE_TASKS, STANDBY_TASKS, "localhost:80");
        ByteBuffer buffer = info.encode();
        buffer.rewind();
        SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)buffer);
        Assert.assertEquals((long)2L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)AssignmentTestUtils.UUID_1, (Object)decoded.processId());
        Assert.assertEquals(ACTIVE_TASKS, (Object)decoded.prevTasks());
        Assert.assertEquals(STANDBY_TASKS, (Object)decoded.standbyTasks());
        Assert.assertEquals((Object)"localhost:80", (Object)decoded.userEndPoint());
    }

    @Test
    public void shouldEncodeAndDecodeVersion3And4() {
        for (int version = 3; version <= 4; ++version) {
            SubscriptionInfo info = new SubscriptionInfo(version, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
            SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)info.encode());
            Assert.assertEquals((long)version, (long)decoded.version());
            Assert.assertEquals((long)10L, (long)decoded.latestSupportedVersion());
            Assert.assertEquals((Object)AssignmentTestUtils.UUID_1, (Object)decoded.processId());
            Assert.assertEquals(ACTIVE_TASKS, (Object)decoded.prevTasks());
            Assert.assertEquals(STANDBY_TASKS, (Object)decoded.standbyTasks());
            Assert.assertEquals((Object)"localhost:80", (Object)decoded.userEndPoint());
        }
    }

    @Test
    public void generatedVersion3And4ShouldBeDecodableByLegacyLogic() {
        for (int version = 3; version <= 4; ++version) {
            SubscriptionInfo info = new SubscriptionInfo(version, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
            ByteBuffer buffer = info.encode();
            LegacySubscriptionInfoSerde decoded = LegacySubscriptionInfoSerde.decode(buffer);
            Assert.assertEquals((long)version, (long)decoded.version());
            Assert.assertEquals((long)10L, (long)decoded.latestSupportedVersion());
            Assert.assertEquals((Object)AssignmentTestUtils.UUID_1, (Object)decoded.processId());
            Assert.assertEquals(ACTIVE_TASKS, decoded.prevTasks());
            Assert.assertEquals(STANDBY_TASKS, decoded.standbyTasks());
            Assert.assertEquals((Object)"localhost:80", (Object)decoded.userEndPoint());
        }
    }

    @Test
    public void generatedVersion3To6ShouldDecodeLegacyFormat() {
        for (int version = 3; version <= 6; ++version) {
            LegacySubscriptionInfoSerde info = new LegacySubscriptionInfoSerde(version, 10, AssignmentTestUtils.UUID_1, ACTIVE_TASKS, STANDBY_TASKS, "localhost:80");
            ByteBuffer buffer = info.encode();
            buffer.rewind();
            SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)buffer);
            String message = "for version: " + version;
            Assert.assertEquals((String)message, (long)version, (long)decoded.version());
            Assert.assertEquals((String)message, (long)10L, (long)decoded.latestSupportedVersion());
            Assert.assertEquals((String)message, (Object)AssignmentTestUtils.UUID_1, (Object)decoded.processId());
            Assert.assertEquals((String)message, ACTIVE_TASKS, (Object)decoded.prevTasks());
            Assert.assertEquals((String)message, STANDBY_TASKS, (Object)decoded.standbyTasks());
            Assert.assertEquals((String)message, (Object)"localhost:80", (Object)decoded.userEndPoint());
        }
    }

    @Test
    public void shouldEncodeAndDecodeVersion5() {
        SubscriptionInfo info = new SubscriptionInfo(5, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
        Assert.assertEquals((Object)info, (Object)SubscriptionInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldAllowToDecodeFutureSupportedVersion() {
        SubscriptionInfo info = SubscriptionInfo.decode((ByteBuffer)SubscriptionInfoTest.encodeFutureVersion());
        Assert.assertEquals((long)11L, (long)info.version());
        Assert.assertEquals((long)11L, (long)info.latestSupportedVersion());
    }

    @Test
    public void shouldEncodeAndDecodeSmallerLatestSupportedVersion() {
        int usedVersion = 9;
        int latestSupportedVersion = 9;
        SubscriptionInfo info = new SubscriptionInfo(9, 9, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
        SubscriptionInfo expectedInfo = new SubscriptionInfo(9, 9, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
        Assert.assertEquals((Object)expectedInfo, (Object)SubscriptionInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion7() {
        SubscriptionInfo info = new SubscriptionInfo(7, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.is((Object)SubscriptionInfo.decode((ByteBuffer)info.encode())));
    }

    @Test
    public void shouldConvertTaskOffsetSumMapToTaskSets() {
        SubscriptionInfo info = new SubscriptionInfo(7, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
        MatcherAssert.assertThat((Object)info.prevTasks(), (Matcher)CoreMatchers.is(ACTIVE_TASKS));
        MatcherAssert.assertThat((Object)info.standbyTasks(), (Matcher)CoreMatchers.is(STANDBY_TASKS));
    }

    @Test
    public void shouldReturnTaskOffsetSumsMapForDecodedSubscription() {
        SubscriptionInfo info = SubscriptionInfo.decode((ByteBuffer)new SubscriptionInfo(7, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0).encode());
        MatcherAssert.assertThat((Object)info.taskOffsetSums(), (Matcher)CoreMatchers.is(TASK_OFFSET_SUMS));
    }

    @Test
    public void shouldConvertTaskSetsToTaskOffsetSumMapWithOlderSubscription() {
        Map expectedOffsetSumsMap = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new TaskId(0, 0), (Object)-2L), Utils.mkEntry((Object)new TaskId(0, 1), (Object)-2L), Utils.mkEntry((Object)new TaskId(1, 0), (Object)-2L), Utils.mkEntry((Object)new TaskId(1, 1), (Object)-3L), Utils.mkEntry((Object)new TaskId(2, 0), (Object)-3L)});
        SubscriptionInfo info = SubscriptionInfo.decode((ByteBuffer)new LegacySubscriptionInfoSerde(6, 10, AssignmentTestUtils.UUID_1, ACTIVE_TASKS, STANDBY_TASKS, "localhost:80").encode());
        MatcherAssert.assertThat((Object)info.taskOffsetSums(), (Matcher)CoreMatchers.is((Object)expectedOffsetSumsMap));
    }

    @Test
    public void shouldEncodeAndDecodeVersion8() {
        SubscriptionInfo info = new SubscriptionInfo(8, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.is((Object)SubscriptionInfo.decode((ByteBuffer)info.encode())));
    }

    @Test
    public void shouldNotErrorAccessingFutureVars() {
        SubscriptionInfo info = new SubscriptionInfo(8, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
        try {
            info.errorCode();
        }
        catch (Exception e) {
            Assert.fail((String)"should not error");
        }
    }

    @Test
    public void shouldEncodeAndDecodeVersion9() {
        SubscriptionInfo info = new SubscriptionInfo(9, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.is((Object)SubscriptionInfo.decode((ByteBuffer)info.encode())));
    }

    @Test
    public void shouldEncodeAndDecodeVersion10() {
        SubscriptionInfo info = new SubscriptionInfo(10, 10, AssignmentTestUtils.UUID_1, "localhost:80", TASK_OFFSET_SUMS, 0, 0);
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.is((Object)SubscriptionInfo.decode((ByteBuffer)info.encode())));
    }

    @Test
    public void shouldEncodeAndDecodeVersion10WithNamedTopologies() {
        SubscriptionInfo info = new SubscriptionInfo(10, 10, AssignmentTestUtils.UUID_1, "localhost:80", NAMED_TASK_OFFSET_SUMS, 0, 0);
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.is((Object)SubscriptionInfo.decode((ByteBuffer)info.encode())));
    }

    @Test
    public void shouldThrowIfAttemptingToUseNamedTopologiesWithOlderVersion() {
        Assert.assertThrows(TaskAssignmentException.class, () -> new SubscriptionInfo(9, 10, AssignmentTestUtils.UUID_1, "localhost:80", NAMED_TASK_OFFSET_SUMS, 0, 0));
    }

    private static ByteBuffer encodeFutureVersion() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(11);
        buf.putInt(11);
        buf.rewind();
        return buf;
    }
}

