/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionResponseWrapper;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionResponseWrapperSerde;
import org.apache.kafka.streams.state.internals.Murmur3;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionResponseWrapperSerdeTest {
    @Test
    public void ShouldSerdeWithNonNullsTest() {
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{1, -102, -1, 0});
        String foreignValue = "foreignValue";
        SubscriptionResponseWrapper srw = new SubscriptionResponseWrapper(hashedValue, (Object)"foreignValue");
        SubscriptionResponseWrapperSerde srwSerde = new SubscriptionResponseWrapperSerde(new NonNullableSerde(Serdes.String()));
        byte[] serResponse = srwSerde.serializer().serialize(null, (Object)srw);
        SubscriptionResponseWrapper result = (SubscriptionResponseWrapper)srwSerde.deserializer().deserialize(null, serResponse);
        Assert.assertArrayEquals((long[])hashedValue, (long[])result.getOriginalValueHash());
        Assert.assertEquals((Object)"foreignValue", (Object)result.getForeignValue());
    }

    @Test
    public void shouldSerdeWithNullForeignValueTest() {
        long[] hashedValue = Murmur3.hash128((byte[])new byte[]{1, -102, -1, 0});
        SubscriptionResponseWrapper srw = new SubscriptionResponseWrapper(hashedValue, null);
        SubscriptionResponseWrapperSerde srwSerde = new SubscriptionResponseWrapperSerde(new NonNullableSerde(Serdes.String()));
        byte[] serResponse = srwSerde.serializer().serialize(null, (Object)srw);
        SubscriptionResponseWrapper result = (SubscriptionResponseWrapper)srwSerde.deserializer().deserialize(null, serResponse);
        Assert.assertArrayEquals((long[])hashedValue, (long[])result.getOriginalValueHash());
        Assert.assertNull((Object)result.getForeignValue());
    }

    @Test
    public void shouldSerdeWithNullHashTest() {
        long[] hashedValue = null;
        String foreignValue = "foreignValue";
        SubscriptionResponseWrapper srw = new SubscriptionResponseWrapper(hashedValue, (Object)"foreignValue");
        SubscriptionResponseWrapperSerde srwSerde = new SubscriptionResponseWrapperSerde(new NonNullableSerde(Serdes.String()));
        byte[] serResponse = srwSerde.serializer().serialize(null, (Object)srw);
        SubscriptionResponseWrapper result = (SubscriptionResponseWrapper)srwSerde.deserializer().deserialize(null, serResponse);
        Assert.assertArrayEquals(hashedValue, (long[])result.getOriginalValueHash());
        Assert.assertEquals((Object)"foreignValue", (Object)result.getForeignValue());
    }

    @Test
    public void shouldSerdeWithNullsTest() {
        long[] hashedValue = null;
        Object foreignValue = null;
        SubscriptionResponseWrapper srw = new SubscriptionResponseWrapper(hashedValue, foreignValue);
        SubscriptionResponseWrapperSerde srwSerde = new SubscriptionResponseWrapperSerde(new NonNullableSerde(Serdes.String()));
        byte[] serResponse = srwSerde.serializer().serialize(null, (Object)srw);
        SubscriptionResponseWrapper result = (SubscriptionResponseWrapper)srwSerde.deserializer().deserialize(null, serResponse);
        Assert.assertArrayEquals(hashedValue, (long[])result.getOriginalValueHash());
        Assert.assertEquals(foreignValue, (Object)result.getForeignValue());
    }

    @Test
    public void shouldThrowExceptionWithBadVersionTest() {
        long[] hashedValue = null;
        Assert.assertThrows(UnsupportedVersionException.class, () -> new SubscriptionResponseWrapper(hashedValue, (Object)"foreignValue", -1));
    }

    private static final class NonNullableSerde<T>
    implements Serde<T>,
    Serializer<T>,
    Deserializer<T> {
        private final Serde<T> delegate;

        NonNullableSerde(Serde<T> delegate) {
            this.delegate = delegate;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public void close() {
        }

        public Serializer<T> serializer() {
            return this;
        }

        public Deserializer<T> deserializer() {
            return this;
        }

        public byte[] serialize(String topic, T data) {
            return this.delegate.serializer().serialize(topic, Objects.requireNonNull(data));
        }

        public T deserialize(String topic, byte[] data) {
            return (T)this.delegate.deserializer().deserialize(topic, Objects.requireNonNull(data));
        }
    }
}

