/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.SlidingWindows;
import org.apache.kafka.streams.kstream.TimeWindowedKStream;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SlidingWindowedKStreamImplTest {
    private static final String TOPIC = "input";
    private final StreamsBuilder builder = new StreamsBuilder();
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());
    private TimeWindowedKStream<String, String> windowedStream;

    @Before
    public void before() {
        KStream stream = this.builder.stream(TOPIC, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.windowedStream = stream.groupByKey(Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String())).windowedBy(SlidingWindows.withTimeDifferenceAndGrace((Duration)Duration.ofMillis(100L), (Duration)Duration.ofMillis(1000L)));
    }

    @Test
    public void shouldCountSlidingWindows() {
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        this.windowedStream.count().toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
        }
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(0L, 100L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)1L, (long)100L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(101L, 201L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)1L, (long)150L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(50L, 150L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)2L, (long)150L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(400L, 500L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)1L, (long)500L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"2", (Window)new TimeWindow(100L, 200L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)2L, (long)200L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"2", (Window)new TimeWindow(50L, 150L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)1L, (long)150L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"2", (Window)new TimeWindow(151L, 251L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)1L, (long)200L)));
    }

    @Test
    public void shouldReduceSlidingWindows() {
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        this.windowedStream.reduce(MockReducer.STRING_ADDER).toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
        }
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(0L, 100L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"1", (long)100L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(101L, 201L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"2", (long)150L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(50L, 150L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"1+2", (long)150L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(400L, 500L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"3", (long)500L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"2", (Window)new TimeWindow(100L, 200L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"10+20", (long)200L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"2", (Window)new TimeWindow(50L, 150L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"20", (long)150L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"2", (Window)new TimeWindow(151L, 251L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"10", (long)200L)));
    }

    @Test
    public void shouldAggregateSlidingWindows() {
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        this.windowedStream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, Materialized.with((Serde)Serdes.String(), (Serde)Serdes.String())).toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
        }
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(0L, 100L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+1", (long)100L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(101L, 201L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+2", (long)150L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(50L, 150L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+1+2", (long)150L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"1", (Window)new TimeWindow(400L, 500L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+3", (long)500L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"2", (Window)new TimeWindow(100L, 200L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+10+20", (long)200L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"2", (Window)new TimeWindow(50L, 150L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+20", (long)150L)));
        MatcherAssert.assertThat(supplier.theCapturedProcessor().lastValueAndTimestampPerKey().get(new Windowed((Object)"2", (Window)new TimeWindow(151L, 251L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+10", (long)200L)));
    }

    @Test
    public void shouldMaterializeCount() {
        this.windowedStream.count(Materialized.as((String)"count-store").withKeySerde(Serdes.String()).withValueSerde(Serdes.Long()));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
            WindowStore windowStore = driver.getWindowStore("count-store");
            List data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 100L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(50L, 150L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(101L, 201L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(400L, 500L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(50L, 150L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(100L, 200L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(151L, 251L)), (Object)1L))));
            windowStore = driver.getTimestampedWindowStore("count-store");
            data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 100L)), (Object)ValueAndTimestamp.make((Object)1L, (long)100L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(50L, 150L)), (Object)ValueAndTimestamp.make((Object)2L, (long)150L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(101L, 201L)), (Object)ValueAndTimestamp.make((Object)1L, (long)150L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(400L, 500L)), (Object)ValueAndTimestamp.make((Object)1L, (long)500L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(50L, 150L)), (Object)ValueAndTimestamp.make((Object)1L, (long)150L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(100L, 200L)), (Object)ValueAndTimestamp.make((Object)2L, (long)200L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(151L, 251L)), (Object)ValueAndTimestamp.make((Object)1L, (long)200L)))));
        }
    }

    @Test
    public void shouldMaterializeReduced() {
        this.windowedStream.reduce(MockReducer.STRING_ADDER, Materialized.as((String)"reduced").withKeySerde(Serdes.String()).withValueSerde(Serdes.String()));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
            WindowStore windowStore = driver.getWindowStore("reduced");
            List data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 100L)), (Object)"1"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(50L, 150L)), (Object)"1+2"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(101L, 201L)), (Object)"2"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(400L, 500L)), (Object)"3"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(50L, 150L)), (Object)"20"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(100L, 200L)), (Object)"10+20"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(151L, 251L)), (Object)"10"))));
            windowStore = driver.getTimestampedWindowStore("reduced");
            data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 100L)), (Object)ValueAndTimestamp.make((Object)"1", (long)100L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(50L, 150L)), (Object)ValueAndTimestamp.make((Object)"1+2", (long)150L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(101L, 201L)), (Object)ValueAndTimestamp.make((Object)"2", (long)150L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(400L, 500L)), (Object)ValueAndTimestamp.make((Object)"3", (long)500L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(50L, 150L)), (Object)ValueAndTimestamp.make((Object)"20", (long)150L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(100L, 200L)), (Object)ValueAndTimestamp.make((Object)"10+20", (long)200L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(151L, 251L)), (Object)ValueAndTimestamp.make((Object)"10", (long)200L)))));
        }
    }

    @Test
    public void shouldMaterializeAggregated() {
        this.windowedStream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, Materialized.as((String)"aggregated").withKeySerde(Serdes.String()).withValueSerde(Serdes.String()));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
            WindowStore windowStore = driver.getWindowStore("aggregated");
            List data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 100L)), (Object)"0+1"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(50L, 150L)), (Object)"0+1+2"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(101L, 201L)), (Object)"0+2"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(400L, 500L)), (Object)"0+3"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(50L, 150L)), (Object)"0+20"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(100L, 200L)), (Object)"0+10+20"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(151L, 251L)), (Object)"0+10"))));
            windowStore = driver.getTimestampedWindowStore("aggregated");
            data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"2", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(1000L)));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(0L, 100L)), (Object)ValueAndTimestamp.make((Object)"0+1", (long)100L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(50L, 150L)), (Object)ValueAndTimestamp.make((Object)"0+1+2", (long)150L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(101L, 201L)), (Object)ValueAndTimestamp.make((Object)"0+2", (long)150L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(400L, 500L)), (Object)ValueAndTimestamp.make((Object)"0+3", (long)500L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(50L, 150L)), (Object)ValueAndTimestamp.make((Object)"0+20", (long)150L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(100L, 200L)), (Object)ValueAndTimestamp.make((Object)"0+10+20", (long)200L)), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new TimeWindow(151L, 251L)), (Object)ValueAndTimestamp.make((Object)"0+10", (long)200L)))));
        }
    }

    @Test
    public void shouldThrowNullPointerOnAggregateIfInitializerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.aggregate(null, MockAggregator.TOSTRING_ADDER));
    }

    @Test
    public void shouldThrowNullPointerOnAggregateIfAggregatorIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.aggregate(MockInitializer.STRING_INIT, null));
    }

    @Test
    public void shouldThrowNullPointerOnReduceIfReducerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.reduce(null));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedAggregateIfInitializerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.aggregate(null, MockAggregator.TOSTRING_ADDER, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedAggregateIfAggregatorIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.aggregate(MockInitializer.STRING_INIT, null, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedAggregateIfMaterializedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, (Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedReduceIfReducerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.reduce(null, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedReduceIfMaterializedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.reduce(MockReducer.STRING_ADDER, (Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedReduceIfNamedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.reduce(MockReducer.STRING_ADDER, (Named)null));
    }

    @Test
    public void shouldThrowNullPointerOnCountIfMaterializedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.windowedStream.count((Materialized)null));
    }

    @Test
    public void shouldThrowIllegalArgumentWhenRetentionIsTooSmall() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.windowedStream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, Materialized.as((String)"aggregated").withKeySerde(Serdes.String()).withValueSerde(Serdes.String()).withRetention(Duration.ofMillis(1L))));
    }

    @Test
    public void shouldDropWindowsOutsideOfRetention() {
        WindowBytesStoreSupplier storeSupplier = Stores.inMemoryWindowStore((String)"aggregated", (Duration)Duration.ofMillis(1200L), (Duration)Duration.ofMillis(100L), (boolean)false);
        this.windowedStream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, Materialized.as((WindowBytesStoreSupplier)storeSupplier).withKeySerde(Serdes.String()).withValueSerde(Serdes.String()).withCachingDisabled());
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic(TOPIC, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            inputTopic.pipeInput((Object)"1", (Object)"2", 100L);
            inputTopic.pipeInput((Object)"1", (Object)"3", 500L);
            inputTopic.pipeInput((Object)"1", (Object)"4", 799L);
            inputTopic.pipeInput((Object)"1", (Object)"4", 1000L);
            inputTopic.pipeInput((Object)"1", (Object)"5", 2000L);
            WindowStore windowStore = driver.getWindowStore("aggregated");
            List data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"1", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10000L)));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(900L, 1000L)), (Object)"0+4"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(1900L, 2000L)), (Object)"0+5"))));
            windowStore = driver.getTimestampedWindowStore("aggregated");
            data = StreamsTestUtils.toList(windowStore.fetch((Object)"1", (Object)"1", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(2000L)));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(900L, 1000L)), (Object)ValueAndTimestamp.make((Object)"0+4", (long)1000L)), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new TimeWindow(1900L, 2000L)), (Object)ValueAndTimestamp.make((Object)"0+5", (long)2000L)))));
        }
    }

    private void processData(TopologyTestDriver driver) {
        TestInputTopic inputTopic = driver.createInputTopic(TOPIC, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        inputTopic.pipeInput((Object)"1", (Object)"1", 100L);
        inputTopic.pipeInput((Object)"1", (Object)"2", 150L);
        inputTopic.pipeInput((Object)"1", (Object)"3", 500L);
        inputTopic.pipeInput((Object)"2", (Object)"10", 200L);
        inputTopic.pipeInput((Object)"2", (Object)"20", 150L);
    }
}

