/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.AbstractJoinIntegrationTest;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.test.TestRecord;
import org.apache.kafka.test.IntegrationTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={IntegrationTest.class})
@RunWith(value=Parameterized.class)
public class StreamTableJoinIntegrationTest
extends AbstractJoinIntegrationTest {
    private KStream<Long, String> leftStream;
    private KTable<Long, String> rightTable;

    public StreamTableJoinIntegrationTest(boolean cacheEnabled) {
        super(cacheEnabled);
    }

    @Before
    public void prepareTopology() throws InterruptedException {
        super.prepareEnvironment();
        appID = "stream-table-join-integration-test";
        this.builder = new StreamsBuilder();
        this.rightTable = this.builder.table("inputTopicRight");
        this.leftStream = this.builder.stream("inputTopicLeft");
    }

    @Test
    public void testInner() {
        STREAMS_CONFIG.put("application.id", appID + "-inner");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), null, null, null, null, null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(15L))));
        this.leftStream.join(this.rightTable, this.valueJoiner).to("outputTopic");
        this.runTestWithDriver(expectedResult);
    }

    @Test
    public void testLeft() {
        STREAMS_CONFIG.put("application.id", appID + "-left");
        List<List<TestRecord<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"A-null", null, Long.valueOf(3L))), null, Collections.singletonList(new TestRecord((Object)0L, (Object)"B-a", null, Long.valueOf(5L))), null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"C-null", null, Long.valueOf(9L))), null, null, null, null, null, Collections.singletonList(new TestRecord((Object)0L, (Object)"D-d", null, Long.valueOf(15L))));
        this.leftStream.leftJoin(this.rightTable, this.valueJoiner).to("outputTopic");
        this.runTestWithDriver(expectedResult);
    }
}

