/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.test.MockProcessor;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;

public class MockProcessorSupplier<K, V>
implements ProcessorSupplier<K, V> {
    private final long scheduleInterval;
    private final PunctuationType punctuationType;
    private final List<MockProcessor<K, V>> processors = new ArrayList<MockProcessor<K, V>>();

    public MockProcessorSupplier() {
        this(-1L);
    }

    public MockProcessorSupplier(long scheduleInterval) {
        this(scheduleInterval, PunctuationType.STREAM_TIME);
    }

    public MockProcessorSupplier(long scheduleInterval, PunctuationType punctuationType) {
        this.scheduleInterval = scheduleInterval;
        this.punctuationType = punctuationType;
    }

    public Processor<K, V> get() {
        MockProcessor processor = new MockProcessor(this.punctuationType, this.scheduleInterval);
        if (!StreamsTestUtils.isCheckSupplierCall()) {
            this.processors.add(processor);
        }
        return processor;
    }

    public MockProcessor<K, V> theCapturedProcessor() {
        return this.capturedProcessors(1).get(0);
    }

    public int capturedProcessorsCount() {
        return this.processors.size();
    }

    public List<MockProcessor<K, V>> capturedProcessors(int expectedNumberOfProcessors) {
        Assert.assertEquals((long)expectedNumberOfProcessors, (long)this.processors.size());
        return this.processors;
    }
}

