/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;
import org.apache.kafka.streams.kstream.Grouped;

public class BrokerCompatibilityTest {
    private static final String SOURCE_TOPIC = "brokerCompatibilitySourceTopic";
    private static final String SINK_TOPIC = "brokerCompatibilitySinkTopic";

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("BrokerCompatibilityTest are expecting two parameters: propFile, processingMode; but only see " + args.length + " parameter");
            Exit.exit((int)1);
        }
        System.out.println("StreamsTest instance started");
        String propFileName = args[0];
        String processingMode = args[1];
        Properties streamsProperties = Utils.loadProps((String)propFileName);
        String kafka = streamsProperties.getProperty("bootstrap.servers");
        if (kafka == null) {
            System.err.println("No bootstrap kafka servers specified in bootstrap.servers");
            Exit.exit((int)1);
        }
        streamsProperties.put("application.id", "kafka-streams-system-test-broker-compatibility");
        streamsProperties.put("auto.offset.reset", "earliest");
        streamsProperties.put("default.key.serde", Serdes.String().getClass());
        streamsProperties.put("default.value.serde", Serdes.String().getClass());
        streamsProperties.put("commit.interval.ms", (Object)100);
        streamsProperties.put("cache.max.bytes.buffering", (Object)0);
        streamsProperties.put("processing.guarantee", processingMode);
        int timeout = 6000;
        streamsProperties.put(StreamsConfig.consumerPrefix((String)"session.timeout.ms"), (Object)6000);
        streamsProperties.put(StreamsConfig.consumerPrefix((String)"fetch.max.wait.ms"), (Object)6000);
        streamsProperties.put("request.timeout.ms", (Object)6001);
        Serde stringSerde = Serdes.String();
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream(SOURCE_TOPIC).groupByKey(Grouped.with((Serde)stringSerde, (Serde)stringSerde)).count().toStream().mapValues(Object::toString).to(SINK_TOPIC);
        KafkaStreams streams = new KafkaStreams(builder.build(), streamsProperties);
        streams.setUncaughtExceptionHandler(e -> {
            Throwable cause = e;
            if (cause instanceof StreamsException) {
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
            }
            System.err.println("FATAL: An unexpected exception " + cause);
            e.printStackTrace(System.err);
            System.err.flush();
            return StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse.SHUTDOWN_CLIENT;
        });
        System.out.println("start Kafka Streams");
        streams.start();
        boolean eosEnabled = processingMode.startsWith("exactly_once");
        System.out.println("send data");
        Properties producerProperties = new Properties();
        producerProperties.put("bootstrap.servers", kafka);
        producerProperties.put("key.serializer", StringSerializer.class);
        producerProperties.put("value.serializer", StringSerializer.class);
        if (eosEnabled) {
            producerProperties.put("transactional.id", "broker-compatibility-producer-tx");
        }
        try (KafkaProducer producer = new KafkaProducer(producerProperties);){
            if (eosEnabled) {
                producer.initTransactions();
                producer.beginTransaction();
            }
            producer.send(new ProducerRecord(SOURCE_TOPIC, (Object)"key", (Object)"value"));
            if (eosEnabled) {
                producer.commitTransaction();
            }
            System.out.println("wait for result");
            BrokerCompatibilityTest.loopUntilRecordReceived(kafka, eosEnabled);
            System.out.println("close Kafka Streams");
            streams.close();
        }
        catch (RuntimeException e2) {
            System.err.println("Non-Streams exception occurred: ");
            e2.printStackTrace(System.err);
            System.err.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loopUntilRecordReceived(String kafka, boolean eosEnabled) {
        Properties consumerProperties = new Properties();
        consumerProperties.put("bootstrap.servers", kafka);
        consumerProperties.put("group.id", "broker-compatibility-consumer");
        consumerProperties.put("auto.offset.reset", "earliest");
        consumerProperties.put("key.deserializer", StringDeserializer.class);
        consumerProperties.put("value.deserializer", StringDeserializer.class);
        if (eosEnabled) {
            consumerProperties.put("isolation.level", IsolationLevel.READ_COMMITTED.name().toLowerCase(Locale.ROOT));
        }
        try (KafkaConsumer consumer = new KafkaConsumer(consumerProperties);){
            consumer.subscribe(Collections.singletonList(SINK_TOPIC));
            block10: while (true) {
                ConsumerRecords records = consumer.poll(Duration.ofMillis(100L));
                Iterator iterator = records.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block10;
                    ConsumerRecord record = (ConsumerRecord)iterator.next();
                    if (((String)record.key()).equals("key") && ((String)record.value()).equals("1")) {
                        return;
                    }
                    continue;
                    break;
                }
                break;
            }
        }
    }
}

